/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.plugin.oss;

import com.aliyun.openservices.oss.OSSClient;
import com.aliyun.openservices.oss.model.ListObjectsRequest;
import com.aliyun.openservices.oss.model.ObjectListing;
import com.aliyun.openservices.oss.model.ObjectMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.shopxx.FileInfo;
import net.shopxx.entity.PluginConfig;
import net.shopxx.plugin.StoragePlugin;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="ossPlugin")
public class OssPlugin
extends StoragePlugin {
    public String getName() {
        return "\u963f\u91cc\u4e91\u5b58\u50a8";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getAuthor() {
        return "SHOP++";
    }

    public String getSiteUrl() {
        return "http://www.shopxx.net";
    }

    public String getInstallUrl() {
        return "oss/install.jhtml";
    }

    public String getUninstallUrl() {
        return "oss/uninstall.jhtml";
    }

    public String getSettingUrl() {
        return "oss/setting.jhtml";
    }

    public void upload(String path, File file, String contentType) {
        block6: {
            PluginConfig pluginConfig = this.getPluginConfig();
            if (pluginConfig != null) {
                String string = pluginConfig.getAttribute("accessId");
                String string2 = pluginConfig.getAttribute("accessKey");
                String string3 = pluginConfig.getAttribute("bucketName");
                FileInputStream fileInputStream = null;
                try {
                    try {
                        fileInputStream = new FileInputStream(file);
                        OSSClient oSSClient = new OSSClient(string, string2);
                        ObjectMetadata objectMetadata = new ObjectMetadata();
                        objectMetadata.setContentType(contentType);
                        objectMetadata.setContentLength(file.length());
                        oSSClient.putObject(string3, StringUtils.removeStart((String)path, (String)"/"), (InputStream)fileInputStream, objectMetadata);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        IOUtils.closeQuietly((InputStream)fileInputStream);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fileInputStream);
            }
        }
    }

    public String getUrl(String path) {
        PluginConfig pluginConfig = this.getPluginConfig();
        if (pluginConfig != null) {
            String string = pluginConfig.getAttribute("urlPrefix");
            return String.valueOf(string) + path;
        }
        return null;
    }

    public List<FileInfo> browser(String path) {
        ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>();
        PluginConfig pluginConfig = this.getPluginConfig();
        if (pluginConfig != null) {
            String string = pluginConfig.getAttribute("accessId");
            String string2 = pluginConfig.getAttribute("accessKey");
            String string3 = pluginConfig.getAttribute("bucketName");
            String string4 = pluginConfig.getAttribute("urlPrefix");
            try {
                FileInfo fileInfo;
                OSSClient oSSClient = new OSSClient(string, string2);
                ListObjectsRequest listObjectsRequest = new ListObjectsRequest(string3);
                listObjectsRequest.setPrefix(StringUtils.removeStart((String)path, (String)"/"));
                listObjectsRequest.setDelimiter("/");
                ObjectListing objectListing = oSSClient.listObjects(listObjectsRequest);
                for (String string5 : objectListing.getCommonPrefixes()) {
                    fileInfo = new FileInfo();
                    fileInfo.setName(StringUtils.substringAfterLast((String)StringUtils.removeEnd((String)string5, (String)"/"), (String)"/"));
                    fileInfo.setUrl(String.valueOf(string4) + "/" + string5);
                    fileInfo.setIsDirectory(Boolean.valueOf(true));
                    fileInfo.setSize(Long.valueOf(0L));
                    arrayList.add(fileInfo);
                }
                for (String string5 : objectListing.getObjectSummaries()) {
                    if (string5.getKey().endsWith("/")) continue;
                    fileInfo = new FileInfo();
                    fileInfo.setName(StringUtils.substringAfterLast((String)string5.getKey(), (String)"/"));
                    fileInfo.setUrl(String.valueOf(string4) + "/" + string5.getKey());
                    fileInfo.setIsDirectory(Boolean.valueOf(false));
                    fileInfo.setSize(Long.valueOf(string5.getSize()));
                    fileInfo.setLastModified(string5.getLastModified());
                    arrayList.add(fileInfo);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }
}

