/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import net.shopxx.Principal;
import net.shopxx.dao.AdminDao;
import net.shopxx.dao.BaseDao;
import net.shopxx.entity.Admin;
import net.shopxx.entity.Role;
import net.shopxx.service.AdminService;
import net.shopxx.service.impl.BaseServiceImpl;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="adminServiceImpl")
public class AdminServiceImpl
extends BaseServiceImpl<Admin, Long>
implements AdminService {
    @Resource(name="adminDaoImpl")
    private AdminDao IIIllIlI;

    @Resource(name="adminDaoImpl")
    public void setBaseDao(AdminDao adminDao) {
        super.setBaseDao((BaseDao)adminDao);
    }

    @Transactional(readOnly=true)
    public boolean usernameExists(String username) {
        return this.IIIllIlI.usernameExists(username);
    }

    @Transactional(readOnly=true)
    public Admin findByUsername(String username) {
        return this.IIIllIlI.findByUsername(username);
    }

    @Transactional(readOnly=true)
    public List<String> findAuthorities(Long id) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Admin admin = (Admin)this.IIIllIlI.find((Serializable)id);
        if (admin != null) {
            for (Role role : admin.getRoles()) {
                arrayList.addAll(role.getAuthorities());
            }
        }
        return arrayList;
    }

    @Transactional(readOnly=true)
    public boolean isAuthenticated() {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            return subject.isAuthenticated();
        }
        return false;
    }

    @Transactional(readOnly=true)
    public Admin getCurrent() {
        Principal principal;
        Subject subject = SecurityUtils.getSubject();
        if (subject != null && (principal = (Principal)subject.getPrincipal()) != null) {
            return (Admin)this.IIIllIlI.find((Serializable)principal.getId());
        }
        return null;
    }

    @Transactional(readOnly=true)
    public String getCurrentUsername() {
        Principal principal;
        Subject subject = SecurityUtils.getSubject();
        if (subject != null && (principal = (Principal)subject.getPrincipal()) != null) {
            return principal.getUsername();
        }
        return null;
    }

    @Transactional
    @CacheEvict(value={"authorization"}, allEntries=true)
    public void save(Admin admin) {
        super.save((Object)admin);
    }

    @Transactional
    @CacheEvict(value={"authorization"}, allEntries=true)
    public Admin update(Admin admin) {
        return (Admin)super.update((Object)admin);
    }

    @Transactional
    @CacheEvict(value={"authorization"}, allEntries=true)
    public Admin update(Admin admin, String ... ignoreProperties) {
        return (Admin)super.update((Object)admin, ignoreProperties);
    }

    @Transactional
    @CacheEvict(value={"authorization"}, allEntries=true)
    public void delete(Long id) {
        super.delete((Serializable)id);
    }

    @Transactional
    @CacheEvict(value={"authorization"}, allEntries=true)
    public void delete(Long ... ids) {
        super.delete((Serializable[])ids);
    }

    @Transactional
    @CacheEvict(value={"authorization"}, allEntries=true)
    public void delete(Admin admin) {
        super.delete((Object)admin);
    }
}

