/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.shopxx.Filter;
import net.shopxx.Order;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.dao.ArticleDao;
import net.shopxx.dao.BaseDao;
import net.shopxx.entity.Article;
import net.shopxx.entity.ArticleCategory;
import net.shopxx.entity.Tag;
import net.shopxx.service.ArticleService;
import net.shopxx.service.StaticService;
import net.shopxx.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="articleServiceImpl")
public class ArticleServiceImpl
extends BaseServiceImpl<Article, Long>
implements ArticleService,
DisposableBean {
    private long IIIllIlI = System.currentTimeMillis();
    @Resource(name="ehCacheManager")
    private CacheManager IIIllIll;
    @Resource(name="articleDaoImpl")
    private ArticleDao IIIlllII;
    @Resource(name="staticServiceImpl")
    private StaticService IIIlllIl;

    @Resource(name="articleDaoImpl")
    public void setBaseDao(ArticleDao articleDao) {
        super.setBaseDao((BaseDao)articleDao);
    }

    @Transactional(readOnly=true)
    public List<Article> findList(ArticleCategory articleCategory, List<Tag> tags, Integer count, List<Filter> filters, List<Order> orders) {
        return this.IIIlllII.findList(articleCategory, tags, count, filters, orders);
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"article"})
    public List<Article> findList(ArticleCategory articleCategory, List<Tag> tags, Integer count, List<Filter> filters, List<Order> orders, String cacheRegion) {
        return this.IIIlllII.findList(articleCategory, tags, count, filters, orders);
    }

    @Transactional(readOnly=true)
    public List<Article> findList(ArticleCategory articleCategory, Date beginDate, Date endDate, Integer first, Integer count) {
        return this.IIIlllII.findList(articleCategory, beginDate, endDate, first, count);
    }

    @Transactional(readOnly=true)
    public Page<Article> findPage(ArticleCategory articleCategory, List<Tag> tags, Pageable pageable) {
        return this.IIIlllII.findPage(articleCategory, tags, pageable);
    }

    public long viewHits(Long id) {
        Long l;
        Ehcache ehcache = this.IIIllIll.getEhcache("articleHits");
        Element element = ehcache.get((Serializable)id);
        if (element != null) {
            l = (Long)element.getObjectValue();
        } else {
            Article article = (Article)this.IIIlllII.find((Serializable)id);
            if (article == null) {
                return 0L;
            }
            l = article.getHits();
        }
        l = l + 1L;
        ehcache.put(new Element((Serializable)id, (Serializable)l));
        long l2 = System.currentTimeMillis();
        if (l2 > this.IIIllIlI + 600000L) {
            this.IIIllIlI = l2;
            this.IIIllIlI();
            ehcache.removeAll();
        }
        return l;
    }

    public void destroy() {
        this.IIIllIlI();
    }

    private void IIIllIlI() {
        Ehcache ehcache = this.IIIllIll.getEhcache("articleHits");
        List list = ehcache.getKeys();
        for (Long l : list) {
            Article article = (Article)this.IIIlllII.find((Serializable)l);
            if (article == null) continue;
            Element element = ehcache.get((Serializable)l);
            long l2 = (Long)element.getObjectValue();
            article.setHits(Long.valueOf(l2));
            this.IIIlllII.merge((Object)article);
        }
    }

    @Transactional
    @CacheEvict(value={"article", "articleCategory"}, allEntries=true)
    public void save(Article article) {
        Assert.notNull((Object)article);
        super.save((Object)article);
        this.IIIlllII.flush();
        this.IIIlllIl.build(article);
    }

    @Transactional
    @CacheEvict(value={"article", "articleCategory"}, allEntries=true)
    public Article update(Article article) {
        Assert.notNull((Object)article);
        Article article2 = (Article)super.update((Object)article);
        this.IIIlllII.flush();
        this.IIIlllIl.build(article2);
        return article2;
    }

    @Transactional
    @CacheEvict(value={"article", "articleCategory"}, allEntries=true)
    public Article update(Article article, String ... ignoreProperties) {
        return (Article)super.update((Object)article, ignoreProperties);
    }

    @Transactional
    @CacheEvict(value={"article", "articleCategory"}, allEntries=true)
    public void delete(Long id) {
        super.delete((Serializable)id);
    }

    @Transactional
    @CacheEvict(value={"article", "articleCategory"}, allEntries=true)
    public void delete(Long ... ids) {
        super.delete((Serializable[])ids);
    }

    @Transactional
    @CacheEvict(value={"article", "articleCategory"}, allEntries=true)
    public void delete(Article article) {
        if (article != null) {
            this.IIIlllIl.delete(article);
        }
        super.delete((Object)article);
    }
}

