/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.Principal;
import net.shopxx.dao.BaseDao;
import net.shopxx.dao.CartDao;
import net.shopxx.dao.CartItemDao;
import net.shopxx.dao.MemberDao;
import net.shopxx.entity.Cart;
import net.shopxx.entity.CartItem;
import net.shopxx.entity.Member;
import net.shopxx.entity.Product;
import net.shopxx.service.CartService;
import net.shopxx.service.impl.BaseServiceImpl;
import net.shopxx.util.CookieUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="cartServiceImpl")
public class CartServiceImpl
extends BaseServiceImpl<Cart, Long>
implements CartService {
    @Resource(name="cartDaoImpl")
    private CartDao IIIllIlI;
    @Resource(name="cartItemDaoImpl")
    private CartItemDao IIIllIll;
    @Resource(name="memberDaoImpl")
    private MemberDao IIIlllII;

    @Resource(name="cartDaoImpl")
    public void setBaseDao(CartDao cartDao) {
        super.setBaseDao((BaseDao)cartDao);
    }

    public Cart getCurrent() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (requestAttributes != null) {
            Member member;
            HttpServletRequest httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
            Principal principal = (Principal)httpServletRequest.getSession().getAttribute(Member.PRINCIPAL_ATTRIBUTE_NAME);
            Member member2 = member = principal != null ? (Member)this.IIIlllII.find((Serializable)principal.getId()) : null;
            if (member != null) {
                Cart cart = member.getCart();
                if (cart != null) {
                    if (!cart.hasExpired()) {
                        if (!DateUtils.isSameDay((Date)cart.getModifyDate(), (Date)new Date())) {
                            cart.setModifyDate(new Date());
                            this.IIIllIlI.merge((Object)cart);
                        }
                        return cart;
                    }
                    this.IIIllIlI.remove((Object)cart);
                }
            } else {
                Cart cart;
                String string = CookieUtils.getCookie((HttpServletRequest)httpServletRequest, (String)"cartId");
                String string2 = CookieUtils.getCookie((HttpServletRequest)httpServletRequest, (String)"cartKey");
                if (StringUtils.isNotEmpty((String)string) && StringUtils.isNumeric((String)string) && StringUtils.isNotEmpty((String)string2) && (cart = (Cart)this.IIIllIlI.find((Serializable)Long.valueOf(string))) != null && cart.getMember() == null && StringUtils.equals((String)cart.getKey(), (String)string2)) {
                    if (!cart.hasExpired()) {
                        if (!DateUtils.isSameDay((Date)cart.getModifyDate(), (Date)new Date())) {
                            cart.setModifyDate(new Date());
                            this.IIIllIlI.merge((Object)cart);
                        }
                        return cart;
                    }
                    this.IIIllIlI.remove((Object)cart);
                }
            }
        }
        return null;
    }

    public void merge(Member member, Cart cart) {
        if (member != null && cart != null && cart.getMember() == null) {
            Cart cart2 = member.getCart();
            if (cart2 != null) {
                Iterator iterator = cart.getCartItems().iterator();
                while (iterator.hasNext()) {
                    CartItem cartItem = (CartItem)iterator.next();
                    Product product = cartItem.getProduct();
                    if (cart2.contains(product)) {
                        if (Cart.MAX_PRODUCT_COUNT != null && cart2.getCartItems().size() > Cart.MAX_PRODUCT_COUNT) continue;
                        CartItem cartItem2 = cart2.getCartItem(product);
                        cartItem2.add(cartItem.getQuantity().intValue());
                        this.IIIllIll.merge((Object)cartItem2);
                        continue;
                    }
                    if (Cart.MAX_PRODUCT_COUNT != null && cart2.getCartItems().size() >= Cart.MAX_PRODUCT_COUNT) continue;
                    iterator.remove();
                    cartItem.setCart(cart2);
                    cart2.getCartItems().add(cartItem);
                    this.IIIllIll.merge((Object)cartItem);
                }
                this.IIIllIlI.remove((Object)cart);
            } else {
                member.setCart(cart);
                cart.setMember(member);
                this.IIIllIlI.merge((Object)cart);
            }
        }
    }

    public void evictExpired() {
        this.IIIllIlI.evictExpired();
    }
}

