/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import net.shopxx.FileInfo;
import net.shopxx.FileInfo$FileType;
import net.shopxx.FileInfo$OrderType;
import net.shopxx.Setting;
import net.shopxx.plugin.StoragePlugin;
import net.shopxx.service.FileService;
import net.shopxx.service.PluginService;
import net.shopxx.service.impl.FileServiceImpl$1;
import net.shopxx.service.impl.FileServiceImpl$NameComparator;
import net.shopxx.service.impl.FileServiceImpl$SizeComparator;
import net.shopxx.service.impl.FileServiceImpl$TypeComparator;
import net.shopxx.util.FreemarkerUtils;
import net.shopxx.util.SettingUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="fileServiceImpl")
public class FileServiceImpl
implements FileService,
ServletContextAware {
    private ServletContext IIIllIlI;
    @Resource(name="taskExecutor")
    private TaskExecutor IIIllIll;
    @Resource(name="pluginServiceImpl")
    private PluginService IIIlllII;

    public void setServletContext(ServletContext servletContext) {
        this.IIIllIlI = servletContext;
    }

    private void IIIllIlI(StoragePlugin storagePlugin, String string, File file, String string2) {
        this.IIIllIll.execute((Runnable)new FileServiceImpl$1(this, file, storagePlugin, string, string2));
    }

    public boolean isValid(FileInfo$FileType fileType, MultipartFile multipartFile) {
        if (multipartFile == null) {
            return false;
        }
        Setting setting = SettingUtils.get();
        if (setting.getUploadMaxSize() != null && setting.getUploadMaxSize() != 0 && multipartFile.getSize() > (long)setting.getUploadMaxSize().intValue() * 1024L * 1024L) {
            return false;
        }
        Object[] objectArray = fileType == FileInfo$FileType.flash ? setting.getUploadFlashExtensions() : (fileType == FileInfo$FileType.media ? setting.getUploadMediaExtensions() : (fileType == FileInfo$FileType.file ? setting.getUploadFileExtensions() : setting.getUploadImageExtensions()));
        if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
            return FilenameUtils.isExtension((String)multipartFile.getOriginalFilename(), (String[])objectArray);
        }
        return false;
    }

    public String upload(FileInfo$FileType fileType, MultipartFile multipartFile, boolean async) {
        block9: {
            if (multipartFile == null) {
                return null;
            }
            Setting setting = SettingUtils.get();
            String string = fileType == FileInfo$FileType.flash ? setting.getFlashUploadPath() : (fileType == FileInfo$FileType.media ? setting.getMediaUploadPath() : (fileType == FileInfo$FileType.file ? setting.getFileUploadPath() : setting.getImageUploadPath()));
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("uuid", UUID.randomUUID().toString());
                String string2 = FreemarkerUtils.process((String)string, hashMap);
                String string3 = String.valueOf(string2) + UUID.randomUUID() + "." + FilenameUtils.getExtension((String)multipartFile.getOriginalFilename());
                Iterator iterator = this.IIIlllII.getStoragePlugins(true).iterator();
                if (!iterator.hasNext()) break block9;
                StoragePlugin storagePlugin = (StoragePlugin)iterator.next();
                File file = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + "/upload_" + UUID.randomUUID() + ".tmp");
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                multipartFile.transferTo(file);
                if (async) {
                    this.IIIllIlI(storagePlugin, string3, file, multipartFile.getContentType());
                } else {
                    try {
                        storagePlugin.upload(string3, file, multipartFile.getContentType());
                    }
                    finally {
                        FileUtils.deleteQuietly((File)file);
                    }
                }
                return storagePlugin.getUrl(string3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public String upload(FileInfo$FileType fileType, MultipartFile multipartFile) {
        return this.upload(fileType, multipartFile, false);
    }

    public String uploadLocal(FileInfo$FileType fileType, MultipartFile multipartFile) {
        if (multipartFile == null) {
            return null;
        }
        Setting setting = SettingUtils.get();
        String string = fileType == FileInfo$FileType.flash ? setting.getFlashUploadPath() : (fileType == FileInfo$FileType.media ? setting.getMediaUploadPath() : (fileType == FileInfo$FileType.file ? setting.getFileUploadPath() : setting.getImageUploadPath()));
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("uuid", UUID.randomUUID().toString());
            String string2 = FreemarkerUtils.process((String)string, hashMap);
            String string3 = String.valueOf(string2) + UUID.randomUUID() + "." + FilenameUtils.getExtension((String)multipartFile.getOriginalFilename());
            File file = new File(this.IIIllIlI.getRealPath(string3));
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            multipartFile.transferTo(file);
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public List<FileInfo> browser(String path, FileInfo$FileType fileType, FileInfo$OrderType orderType) {
        if (path != null) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
        } else {
            path = "/";
        }
        Setting setting = SettingUtils.get();
        String string = fileType == FileInfo$FileType.flash ? setting.getFlashUploadPath() : (fileType == FileInfo$FileType.media ? setting.getMediaUploadPath() : (fileType == FileInfo$FileType.file ? setting.getFileUploadPath() : setting.getImageUploadPath()));
        String string2 = StringUtils.substringBefore((String)string, (String)"${");
        string2 = String.valueOf(StringUtils.substringBeforeLast((String)string2, (String)"/")) + path;
        List<Object> list = new ArrayList<FileInfo>();
        if (string2.indexOf("..") >= 0) {
            return list;
        }
        Iterator iterator = this.IIIlllII.getStoragePlugins(true).iterator();
        if (iterator.hasNext()) {
            StoragePlugin storagePlugin = (StoragePlugin)iterator.next();
            list = storagePlugin.browser(string2);
        }
        if (orderType == FileInfo$OrderType.size) {
            Collections.sort(list, new FileServiceImpl$SizeComparator(this, null));
        } else if (orderType == FileInfo$OrderType.type) {
            Collections.sort(list, new FileServiceImpl$TypeComparator(this, null));
        } else {
            Collections.sort(list, new FileServiceImpl$NameComparator(this, null));
        }
        return list;
    }
}

