/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import net.shopxx.dao.BaseDao;
import net.shopxx.dao.GoodsDao;
import net.shopxx.dao.ProductDao;
import net.shopxx.entity.Goods;
import net.shopxx.entity.Product;
import net.shopxx.service.GoodsService;
import net.shopxx.service.StaticService;
import net.shopxx.service.impl.BaseServiceImpl;
import net.shopxx.service.impl.GoodsServiceImpl$1;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="goodsServiceImpl")
public class GoodsServiceImpl
extends BaseServiceImpl<Goods, Long>
implements GoodsService {
    @Resource(name="goodsDaoImpl")
    private GoodsDao IIIllIlI;
    @Resource(name="productDaoImpl")
    private ProductDao IIIllIll;
    @Resource(name="staticServiceImpl")
    private StaticService IIIlllII;

    @Resource(name="goodsDaoImpl")
    public void setBaseDao(GoodsDao goodsDao) {
        super.setBaseDao((BaseDao)goodsDao);
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public void save(Goods goods) {
        Assert.notNull((Object)goods);
        super.save((Object)goods);
        this.IIIllIlI.flush();
        if (goods.getProducts() != null) {
            for (Product product : goods.getProducts()) {
                this.IIIlllII.build(product);
            }
        }
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public Goods update(Goods goods) {
        Product product2;
        Assert.notNull((Object)goods);
        HashSet hashSet = new HashSet();
        CollectionUtils.select((Collection)goods.getProducts(), (Predicate)new GoodsServiceImpl$1(this), hashSet);
        List list = this.IIIllIll.findList(goods, hashSet);
        for (Product product2 : list) {
            this.IIIlllII.delete(product2);
        }
        product2 = (Goods)super.update((Object)goods);
        this.IIIllIlI.flush();
        if (product2.getProducts() != null) {
            for (Product product3 : product2.getProducts()) {
                this.IIIlllII.build(product3);
            }
        }
        return product2;
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public Goods update(Goods goods, String ... ignoreProperties) {
        return (Goods)super.update((Object)goods, ignoreProperties);
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public void delete(Long id) {
        super.delete((Serializable)id);
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public void delete(Long ... ids) {
        super.delete((Serializable[])ids);
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public void delete(Goods goods) {
        if (goods != null && goods.getProducts() != null) {
            for (Product product : goods.getProducts()) {
                this.IIIlllII.delete(product);
            }
        }
        super.delete((Object)goods);
    }
}

