/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import net.shopxx.Setting;
import net.shopxx.Template;
import net.shopxx.entity.ProductNotify;
import net.shopxx.entity.SafeKey;
import net.shopxx.service.MailService;
import net.shopxx.service.TemplateService;
import net.shopxx.service.impl.MailServiceImpl$1;
import net.shopxx.util.SettingUtils;
import net.shopxx.util.SpringUtils;
import org.springframework.core.task.TaskExecutor;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="mailServiceImpl")
public class MailServiceImpl
implements MailService {
    @Resource(name="freeMarkerConfigurer")
    private FreeMarkerConfigurer IIIllIlI;
    @Resource(name="javaMailSender")
    private JavaMailSenderImpl IIIllIll;
    @Resource(name="taskExecutor")
    private TaskExecutor IIIlllII;
    @Resource(name="templateServiceImpl")
    private TemplateService IIIlllIl;

    private void IIIllIlI(MimeMessage mimeMessage) {
        try {
            this.IIIlllII.execute((Runnable)new MailServiceImpl$1(this, mimeMessage));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void send(String smtpFromMail, String smtpHost, Integer smtpPort, String smtpUsername, String smtpPassword, String toMail, String subject, String templatePath, Map<String, Object> model, boolean async) {
        Assert.hasText((String)smtpFromMail);
        Assert.hasText((String)smtpHost);
        Assert.notNull((Object)smtpPort);
        Assert.hasText((String)smtpUsername);
        Assert.hasText((String)smtpPassword);
        Assert.hasText((String)toMail);
        Assert.hasText((String)subject);
        Assert.hasText((String)templatePath);
        try {
            Setting setting = SettingUtils.get();
            Configuration configuration = this.IIIllIlI.getConfiguration();
            freemarker.template.Template template = configuration.getTemplate(templatePath);
            String string = FreeMarkerTemplateUtils.processTemplateIntoString((freemarker.template.Template)template, model);
            this.IIIllIll.setHost(smtpHost);
            this.IIIllIll.setPort(smtpPort.intValue());
            this.IIIllIll.setUsername(smtpUsername);
            this.IIIllIll.setPassword(smtpPassword);
            MimeMessage mimeMessage = this.IIIllIll.createMimeMessage();
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, false, "utf-8");
            mimeMessageHelper.setFrom(String.valueOf(MimeUtility.encodeWord((String)setting.getSiteName())) + " <" + smtpFromMail + ">");
            mimeMessageHelper.setSubject(subject);
            mimeMessageHelper.setTo(toMail);
            mimeMessageHelper.setText(string, true);
            if (async) {
                this.IIIllIlI(mimeMessage);
            } else {
                this.IIIllIll.send(mimeMessage);
            }
        }
        catch (TemplateException templateException) {
            templateException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace();
        }
    }

    public void send(String toMail, String subject, String templatePath, Map<String, Object> model, boolean async) {
        Setting setting = SettingUtils.get();
        this.send(setting.getSmtpFromMail(), setting.getSmtpHost(), setting.getSmtpPort(), setting.getSmtpUsername(), setting.getSmtpPassword(), toMail, subject, templatePath, model, async);
    }

    public void send(String toMail, String subject, String templatePath, Map<String, Object> model) {
        Setting setting = SettingUtils.get();
        this.send(setting.getSmtpFromMail(), setting.getSmtpHost(), setting.getSmtpPort(), setting.getSmtpUsername(), setting.getSmtpPassword(), toMail, subject, templatePath, model, true);
    }

    public void send(String toMail, String subject, String templatePath) {
        Setting setting = SettingUtils.get();
        this.send(setting.getSmtpFromMail(), setting.getSmtpHost(), setting.getSmtpPort(), setting.getSmtpUsername(), setting.getSmtpPassword(), toMail, subject, templatePath, null, true);
    }

    public void sendTestMail(String smtpFromMail, String smtpHost, Integer smtpPort, String smtpUsername, String smtpPassword, String toMail) {
        Setting setting = SettingUtils.get();
        String string = SpringUtils.getMessage((String)"admin.setting.testMailSubject", (Object[])new Object[]{setting.getSiteName()});
        Template template = this.IIIlllIl.get("testMail");
        this.send(smtpFromMail, smtpHost, smtpPort, smtpUsername, smtpPassword, toMail, string, template.getTemplatePath(), null, false);
    }

    public void sendFindPasswordMail(String toMail, String username, SafeKey safeKey) {
        Setting setting = SettingUtils.get();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("username", username);
        hashMap.put("safeKey", (String)safeKey);
        String string = SpringUtils.getMessage((String)"shop.password.mailSubject", (Object[])new Object[]{setting.getSiteName()});
        Template template = this.IIIlllIl.get("findPasswordMail");
        this.send(toMail, string, template.getTemplatePath(), hashMap);
    }

    public void sendProductNotifyMail(ProductNotify productNotify) {
        Setting setting = SettingUtils.get();
        HashMap<String, ProductNotify> hashMap = new HashMap<String, ProductNotify>();
        hashMap.put("productNotify", productNotify);
        String string = SpringUtils.getMessage((String)"admin.productNotify.mailSubject", (Object[])new Object[]{setting.getSiteName()});
        Template template = this.IIIlllIl.get("productNotifyMail");
        this.send(productNotify.getEmail(), string, template.getTemplatePath(), hashMap);
    }

    static /* synthetic */ JavaMailSenderImpl IIIllIlI(MailServiceImpl mailServiceImpl) {
        return mailServiceImpl.IIIllIll;
    }
}

