/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.LockModeType;
import javax.servlet.http.HttpServletRequest;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.Principal;
import net.shopxx.Setting;
import net.shopxx.dao.BaseDao;
import net.shopxx.dao.DepositDao;
import net.shopxx.dao.MemberDao;
import net.shopxx.entity.Admin;
import net.shopxx.entity.Deposit;
import net.shopxx.entity.Deposit$Type;
import net.shopxx.entity.Member;
import net.shopxx.service.MemberService;
import net.shopxx.service.impl.BaseServiceImpl;
import net.shopxx.util.SettingUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="memberServiceImpl")
public class MemberServiceImpl
extends BaseServiceImpl<Member, Long>
implements MemberService {
    @Resource(name="memberDaoImpl")
    private MemberDao IIIllIlI;
    @Resource(name="depositDaoImpl")
    private DepositDao IIIllIll;

    @Resource(name="memberDaoImpl")
    public void setBaseDao(MemberDao memberDao) {
        super.setBaseDao((BaseDao)memberDao);
    }

    @Transactional(readOnly=true)
    public boolean usernameExists(String username) {
        return this.IIIllIlI.usernameExists(username);
    }

    @Transactional(readOnly=true)
    public boolean usernameDisabled(String username) {
        Assert.hasText((String)username);
        Setting setting = SettingUtils.get();
        if (setting.getDisabledUsernames() != null) {
            String[] stringArray = setting.getDisabledUsernames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (StringUtils.containsIgnoreCase((String)username, (String)string)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Transactional(readOnly=true)
    public boolean emailExists(String email) {
        return this.IIIllIlI.emailExists(email);
    }

    @Transactional(readOnly=true)
    public boolean emailUnique(String previousEmail, String currentEmail) {
        if (StringUtils.equalsIgnoreCase((String)previousEmail, (String)currentEmail)) {
            return true;
        }
        return !this.IIIllIlI.emailExists(currentEmail);
    }

    public void save(Member member, Admin operator) {
        Assert.notNull((Object)member);
        this.IIIllIlI.persist((Object)member);
        if (member.getBalance().compareTo(new BigDecimal(0)) > 0) {
            Deposit deposit = new Deposit();
            deposit.setType(operator != null ? Deposit$Type.adminRecharge : Deposit$Type.memberRecharge);
            deposit.setCredit(member.getBalance());
            deposit.setDebit(new BigDecimal(0));
            deposit.setBalance(member.getBalance());
            deposit.setOperator(operator != null ? operator.getUsername() : null);
            deposit.setMember(member);
            this.IIIllIll.persist((Object)deposit);
        }
    }

    public void update(Member member, Integer modifyPoint, BigDecimal modifyBalance, String depositMemo, Admin operator) {
        Assert.notNull((Object)member);
        this.IIIllIlI.lock((Object)member, LockModeType.PESSIMISTIC_WRITE);
        if (modifyPoint != null && modifyPoint != 0 && member.getPoint() + (long)modifyPoint.intValue() >= 0L) {
            member.setPoint(Long.valueOf(member.getPoint() + (long)modifyPoint.intValue()));
        }
        if (modifyBalance != null && modifyBalance.compareTo(new BigDecimal(0)) != 0 && member.getBalance().add(modifyBalance).compareTo(new BigDecimal(0)) >= 0) {
            member.setBalance(member.getBalance().add(modifyBalance));
            Deposit deposit = new Deposit();
            if (modifyBalance.compareTo(new BigDecimal(0)) > 0) {
                deposit.setType(operator != null ? Deposit$Type.adminRecharge : Deposit$Type.memberRecharge);
                deposit.setCredit(modifyBalance);
                deposit.setDebit(new BigDecimal(0));
            } else {
                deposit.setType(operator != null ? Deposit$Type.adminChargeback : Deposit$Type.memberPayment);
                deposit.setCredit(new BigDecimal(0));
                deposit.setDebit(modifyBalance);
            }
            deposit.setBalance(member.getBalance());
            deposit.setOperator(operator != null ? operator.getUsername() : null);
            deposit.setMemo(depositMemo);
            deposit.setMember(member);
            this.IIIllIll.persist((Object)deposit);
        }
        this.IIIllIlI.merge((Object)member);
    }

    @Transactional(readOnly=true)
    public Member findByUsername(String username) {
        return this.IIIllIlI.findByUsername(username);
    }

    @Transactional(readOnly=true)
    public List<Member> findListByEmail(String email) {
        return this.IIIllIlI.findListByEmail(email);
    }

    @Transactional(readOnly=true)
    public Page<Object> findPurchasePage(Date beginDate, Date endDate, Pageable pageable) {
        return this.IIIllIlI.findPurchasePage(beginDate, endDate, pageable);
    }

    @Transactional(readOnly=true)
    public boolean isAuthenticated() {
        HttpServletRequest httpServletRequest;
        Principal principal;
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        return requestAttributes != null && (principal = (Principal)(httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest()).getSession().getAttribute(Member.PRINCIPAL_ATTRIBUTE_NAME)) != null;
    }

    @Transactional(readOnly=true)
    public Member getCurrent() {
        HttpServletRequest httpServletRequest;
        Principal principal;
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (requestAttributes != null && (principal = (Principal)(httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest()).getSession().getAttribute(Member.PRINCIPAL_ATTRIBUTE_NAME)) != null) {
            return (Member)this.IIIllIlI.find((Serializable)principal.getId());
        }
        return null;
    }

    @Transactional(readOnly=true)
    public String getCurrentUsername() {
        HttpServletRequest httpServletRequest;
        Principal principal;
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (requestAttributes != null && (principal = (Principal)(httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest()).getSession().getAttribute(Member.PRINCIPAL_ATTRIBUTE_NAME)) != null) {
            return principal.getUsername();
        }
        return null;
    }
}

