/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.LockModeType;
import net.shopxx.Filter;
import net.shopxx.Order;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.Setting;
import net.shopxx.dao.BaseDao;
import net.shopxx.dao.CartDao;
import net.shopxx.dao.CouponCodeDao;
import net.shopxx.dao.DepositDao;
import net.shopxx.dao.MemberDao;
import net.shopxx.dao.MemberRankDao;
import net.shopxx.dao.OrderDao;
import net.shopxx.dao.OrderItemDao;
import net.shopxx.dao.OrderLogDao;
import net.shopxx.dao.PaymentDao;
import net.shopxx.dao.ProductDao;
import net.shopxx.dao.RefundsDao;
import net.shopxx.dao.ReturnsDao;
import net.shopxx.dao.ShippingDao;
import net.shopxx.dao.SnDao;
import net.shopxx.entity.Admin;
import net.shopxx.entity.Cart;
import net.shopxx.entity.Coupon;
import net.shopxx.entity.CouponCode;
import net.shopxx.entity.Deposit;
import net.shopxx.entity.Deposit$Type;
import net.shopxx.entity.Member;
import net.shopxx.entity.MemberRank;
import net.shopxx.entity.Order$OrderStatus;
import net.shopxx.entity.Order$PaymentStatus;
import net.shopxx.entity.Order$ShippingStatus;
import net.shopxx.entity.OrderItem;
import net.shopxx.entity.OrderLog;
import net.shopxx.entity.OrderLog$Type;
import net.shopxx.entity.Payment;
import net.shopxx.entity.Payment$Type;
import net.shopxx.entity.PaymentMethod;
import net.shopxx.entity.PaymentMethod$Type;
import net.shopxx.entity.Product;
import net.shopxx.entity.Receiver;
import net.shopxx.entity.Refunds;
import net.shopxx.entity.Refunds$Type;
import net.shopxx.entity.Returns;
import net.shopxx.entity.ReturnsItem;
import net.shopxx.entity.Shipping;
import net.shopxx.entity.ShippingMethod;
import net.shopxx.entity.Sn$Type;
import net.shopxx.service.OrderService;
import net.shopxx.service.StaticService;
import net.shopxx.service.impl.BaseServiceImpl;
import net.shopxx.util.SettingUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="orderServiceImpl")
public class OrderServiceImpl
extends BaseServiceImpl<net.shopxx.entity.Order, Long>
implements OrderService {
    @Resource(name="orderDaoImpl")
    private OrderDao IIIllIlI;
    @Resource(name="orderItemDaoImpl")
    private OrderItemDao IIIllIll;
    @Resource(name="orderLogDaoImpl")
    private OrderLogDao IIIlllII;
    @Resource(name="cartDaoImpl")
    private CartDao IIIlllIl;
    @Resource(name="couponCodeDaoImpl")
    private CouponCodeDao IIIllllI;
    @Resource(name="snDaoImpl")
    private SnDao IIIlllll;
    @Resource(name="memberDaoImpl")
    private MemberDao IIlIIIII;
    @Resource(name="memberRankDaoImpl")
    private MemberRankDao IIlIIIIl;
    @Resource(name="productDaoImpl")
    private ProductDao IIlIIIlI;
    @Resource(name="depositDaoImpl")
    private DepositDao IIlIIIll;
    @Resource(name="paymentDaoImpl")
    private PaymentDao IIlIIlII;
    @Resource(name="refundsDaoImpl")
    private RefundsDao IIlIIlIl;
    @Resource(name="shippingDaoImpl")
    private ShippingDao IIlIIllI;
    @Resource(name="returnsDaoImpl")
    private ReturnsDao IIlIIlll;
    @Resource(name="staticServiceImpl")
    private StaticService IIlIlIII;

    @Resource(name="orderDaoImpl")
    public void setBaseDao(OrderDao orderDao) {
        super.setBaseDao((BaseDao)orderDao);
    }

    @Transactional(readOnly=true)
    public net.shopxx.entity.Order findBySn(String sn) {
        return this.IIIllIlI.findBySn(sn);
    }

    @Transactional(readOnly=true)
    public List<net.shopxx.entity.Order> findList(Member member, Integer count, List<Filter> filters, List<Order> orders) {
        return this.IIIllIlI.findList(member, count, filters, orders);
    }

    @Transactional(readOnly=true)
    public Page<net.shopxx.entity.Order> findPage(Member member, Pageable pageable) {
        return this.IIIllIlI.findPage(member, pageable);
    }

    @Transactional(readOnly=true)
    public Page<net.shopxx.entity.Order> findPage(Order$OrderStatus orderStatus, Order$PaymentStatus paymentStatus, Order$ShippingStatus shippingStatus, Boolean hasExpired, Pageable pageable) {
        return this.IIIllIlI.findPage(orderStatus, paymentStatus, shippingStatus, hasExpired, pageable);
    }

    @Transactional(readOnly=true)
    public Long count(Order$OrderStatus orderStatus, Order$PaymentStatus paymentStatus, Order$ShippingStatus shippingStatus, Boolean hasExpired) {
        return this.IIIllIlI.count(orderStatus, paymentStatus, shippingStatus, hasExpired);
    }

    @Transactional(readOnly=true)
    public Long waitingPaymentCount(Member member) {
        return this.IIIllIlI.waitingPaymentCount(member);
    }

    @Transactional(readOnly=true)
    public Long waitingShippingCount(Member member) {
        return this.IIIllIlI.waitingShippingCount(member);
    }

    @Transactional(readOnly=true)
    public BigDecimal getSalesAmount(Date beginDate, Date endDate) {
        return this.IIIllIlI.getSalesAmount(beginDate, endDate);
    }

    @Transactional(readOnly=true)
    public Integer getSalesVolume(Date beginDate, Date endDate) {
        return this.IIIllIlI.getSalesVolume(beginDate, endDate);
    }

    public void releaseStock() {
        this.IIIllIlI.releaseStock();
    }

    @Transactional(readOnly=true)
    public net.shopxx.entity.Order build(Cart cart, Receiver receiver, PaymentMethod paymentMethod, ShippingMethod shippingMethod, CouponCode couponCode, boolean isInvoice, String invoiceTitle, boolean useBalance, String memo) {
        OrderItem orderItem;
        Product product;
        Object object3;
        Object object2;
        Assert.notNull((Object)cart);
        Assert.notNull((Object)cart.getMember());
        Assert.notEmpty((Collection)cart.getCartItems());
        net.shopxx.entity.Order order = new net.shopxx.entity.Order();
        order.setShippingStatus(Order$ShippingStatus.unshipped);
        order.setFee(new BigDecimal(0));
        order.setDiscount(cart.getDiscount());
        order.setPoint(Integer.valueOf(cart.getPoint()));
        order.setMemo(memo);
        order.setMember(cart.getMember());
        if (receiver != null) {
            order.setConsignee(receiver.getConsignee());
            order.setAreaName(receiver.getAreaName());
            order.setAddress(receiver.getAddress());
            order.setZipCode(receiver.getZipCode());
            order.setPhone(receiver.getPhone());
            order.setArea(receiver.getArea());
        }
        if (!cart.getPromotions().isEmpty()) {
            object2 = new StringBuffer();
            for (Object object3 : cart.getPromotions()) {
                if (object3 == null || object3.getName() == null) continue;
                ((StringBuffer)object2).append(" " + object3.getName());
            }
            if (((StringBuffer)object2).length() > 0) {
                ((StringBuffer)object2).deleteCharAt(0);
            }
            order.setPromotion(((StringBuffer)object2).toString());
        }
        order.setPaymentMethod(paymentMethod);
        if (shippingMethod != null && paymentMethod != null && paymentMethod.getShippingMethods().contains(shippingMethod)) {
            object2 = shippingMethod.calculateFreight(Integer.valueOf(cart.getWeight()));
            for (Object object3 : cart.getPromotions()) {
                if (!object3.getIsFreeShipping().booleanValue()) continue;
                object2 = new BigDecimal(0);
                break;
            }
            order.setFreight((BigDecimal)object2);
            order.setShippingMethod(shippingMethod);
        } else {
            order.setFreight(new BigDecimal(0));
        }
        if (couponCode != null && cart.isCouponAllowed()) {
            this.IIIllllI.lock((Object)couponCode, LockModeType.PESSIMISTIC_READ);
            if (!couponCode.getIsUsed().booleanValue() && couponCode.getCoupon() != null && cart.isValid(couponCode.getCoupon())) {
                object2 = couponCode.getCoupon().calculatePrice(cart.getAmount());
                object3 = cart.getAmount().subtract((BigDecimal)object2);
                if (((BigDecimal)object3).compareTo(new BigDecimal(0)) > 0) {
                    order.setDiscount(cart.getDiscount().add((BigDecimal)object3));
                }
                order.setCouponCode(couponCode);
            }
        }
        object2 = order.getOrderItems();
        for (Object object3 : cart.getCartItems()) {
            if (object3 == null || object3.getProduct() == null) continue;
            product = object3.getProduct();
            orderItem = new OrderItem();
            orderItem.setSn(product.getSn());
            orderItem.setName(product.getName());
            orderItem.setFullName(product.getFullName());
            orderItem.setPrice(object3.getUnitPrice());
            orderItem.setWeight(product.getWeight());
            orderItem.setThumbnail(product.getThumbnail());
            orderItem.setIsGift(Boolean.valueOf(false));
            orderItem.setQuantity(object3.getQuantity());
            orderItem.setShippedQuantity(Integer.valueOf(0));
            orderItem.setReturnQuantity(Integer.valueOf(0));
            orderItem.setProduct(product);
            orderItem.setOrder(order);
            object2.add(orderItem);
        }
        for (Object object3 : cart.getGiftItems()) {
            if (object3 == null || object3.getGift() == null) continue;
            product = object3.getGift();
            orderItem = new OrderItem();
            orderItem.setSn(product.getSn());
            orderItem.setName(product.getName());
            orderItem.setFullName(product.getFullName());
            orderItem.setPrice(new BigDecimal(0));
            orderItem.setWeight(product.getWeight());
            orderItem.setThumbnail(product.getThumbnail());
            orderItem.setIsGift(Boolean.valueOf(true));
            orderItem.setQuantity(object3.getQuantity());
            orderItem.setShippedQuantity(Integer.valueOf(0));
            orderItem.setReturnQuantity(Integer.valueOf(0));
            orderItem.setProduct(product);
            orderItem.setOrder(order);
            object2.add(orderItem);
        }
        object3 = SettingUtils.get();
        if (object3.getIsInvoiceEnabled().booleanValue() && isInvoice && StringUtils.isNotEmpty((String)invoiceTitle)) {
            order.setIsInvoice(Boolean.valueOf(true));
            order.setInvoiceTitle(invoiceTitle);
            order.setTax(order.calculateTax());
        } else {
            order.setIsInvoice(Boolean.valueOf(false));
            order.setTax(new BigDecimal(0));
        }
        if (useBalance) {
            Member member = cart.getMember();
            if (member.getBalance().compareTo(order.getAmount()) >= 0) {
                order.setAmountPaid(order.getAmount());
            } else {
                order.setAmountPaid(member.getBalance());
            }
        } else {
            order.setAmountPaid(new BigDecimal(0));
        }
        if (order.getAmountPayable().compareTo(new BigDecimal(0)) == 0) {
            order.setOrderStatus(Order$OrderStatus.confirmed);
            order.setPaymentStatus(Order$PaymentStatus.paid);
        } else if (order.getAmountPayable().compareTo(new BigDecimal(0)) > 0 && order.getAmountPaid().compareTo(new BigDecimal(0)) > 0) {
            order.setOrderStatus(Order$OrderStatus.confirmed);
            order.setPaymentStatus(Order$PaymentStatus.partialPayment);
        } else {
            order.setOrderStatus(Order$OrderStatus.unconfirmed);
            order.setPaymentStatus(Order$PaymentStatus.unpaid);
        }
        if (paymentMethod != null && paymentMethod.getTimeout() != null && order.getPaymentStatus() == Order$PaymentStatus.unpaid) {
            order.setExpire(DateUtils.addMinutes((Date)new Date(), (int)paymentMethod.getTimeout()));
        }
        return order;
    }

    public net.shopxx.entity.Order create(Cart cart, Receiver receiver, PaymentMethod paymentMethod, ShippingMethod shippingMethod, CouponCode couponCode, boolean isInvoice, String invoiceTitle, boolean useBalance, String memo, Admin operator) {
        Coupon coupon2;
        Setting setting2;
        Assert.notNull((Object)cart);
        Assert.notNull((Object)cart.getMember());
        Assert.notEmpty((Collection)cart.getCartItems());
        Assert.notNull((Object)receiver);
        Assert.notNull((Object)paymentMethod);
        Assert.notNull((Object)shippingMethod);
        net.shopxx.entity.Order order = this.build(cart, receiver, paymentMethod, shippingMethod, couponCode, isInvoice, invoiceTitle, useBalance, memo);
        order.setSn(this.IIIlllll.generate(Sn$Type.order));
        if (paymentMethod.getType() == PaymentMethod$Type.online) {
            order.setLockExpire(DateUtils.addSeconds((Date)new Date(), (int)10));
            order.setOperator(operator);
        }
        if (order.getCouponCode() != null) {
            couponCode.setIsUsed(Boolean.valueOf(true));
            couponCode.setUsedDate(new Date());
            this.IIIllllI.merge((Object)couponCode);
        }
        for (Setting setting2 : cart.getPromotions()) {
            for (Coupon coupon2 : setting2.getCoupons()) {
                order.getCoupons().add(coupon2);
            }
        }
        setting2 = SettingUtils.get();
        if (setting2.getStockAllocationTime() == Setting.StockAllocationTime.order || setting2.getStockAllocationTime() == Setting.StockAllocationTime.payment && (order.getPaymentStatus() == Order$PaymentStatus.partialPayment || order.getPaymentStatus() == Order$PaymentStatus.paid)) {
            order.setIsAllocatedStock(Boolean.valueOf(true));
        } else {
            order.setIsAllocatedStock(Boolean.valueOf(false));
        }
        this.IIIllIlI.persist((Object)order);
        OrderLog orderLog = new OrderLog();
        orderLog.setType(OrderLog$Type.create);
        orderLog.setOperator(operator != null ? operator.getUsername() : null);
        orderLog.setOrder(order);
        this.IIIlllII.persist((Object)orderLog);
        coupon2 = cart.getMember();
        if (order.getAmountPaid().compareTo(new BigDecimal(0)) > 0) {
            this.IIlIIIII.lock((Object)coupon2, LockModeType.PESSIMISTIC_WRITE);
            coupon2.setBalance(coupon2.getBalance().subtract(order.getAmountPaid()));
            this.IIlIIIII.merge((Object)coupon2);
            OrderItem orderItem = new Deposit();
            orderItem.setType(operator != null ? Deposit$Type.adminPayment : Deposit$Type.memberPayment);
            orderItem.setCredit(new BigDecimal(0));
            orderItem.setDebit(order.getAmountPaid());
            orderItem.setBalance(coupon2.getBalance());
            orderItem.setOperator(operator != null ? operator.getUsername() : null);
            orderItem.setMember((Member)coupon2);
            orderItem.setOrder(order);
            this.IIlIIIll.persist((Object)orderItem);
        }
        if (setting2.getStockAllocationTime() == Setting.StockAllocationTime.order || setting2.getStockAllocationTime() == Setting.StockAllocationTime.payment && (order.getPaymentStatus() == Order$PaymentStatus.partialPayment || order.getPaymentStatus() == Order$PaymentStatus.paid)) {
            for (OrderItem orderItem : order.getOrderItems()) {
                if (orderItem == null) continue;
                Product product = orderItem.getProduct();
                this.IIlIIIlI.lock((Object)product, LockModeType.PESSIMISTIC_WRITE);
                if (product == null || product.getStock() == null) continue;
                product.setAllocatedStock(Integer.valueOf(product.getAllocatedStock() + (orderItem.getQuantity() - orderItem.getShippedQuantity())));
                this.IIlIIIlI.merge((Object)product);
                this.IIIllIlI.flush();
                this.IIlIlIII.build(product);
            }
        }
        this.IIIlllIl.remove((Object)cart);
        return order;
    }

    public void update(net.shopxx.entity.Order order, Admin operator) {
        OrderLog orderLog2;
        Assert.notNull((Object)order);
        net.shopxx.entity.Order order2 = (net.shopxx.entity.Order)this.IIIllIlI.find((Serializable)order.getId());
        if (order2.getIsAllocatedStock().booleanValue()) {
            Product product;
            for (OrderLog orderLog2 : order2.getOrderItems()) {
                if (orderLog2 == null) continue;
                product = orderLog2.getProduct();
                this.IIlIIIlI.lock((Object)product, LockModeType.PESSIMISTIC_WRITE);
                if (product == null || product.getStock() == null) continue;
                product.setAllocatedStock(Integer.valueOf(product.getAllocatedStock() - (orderLog2.getQuantity() - orderLog2.getShippedQuantity())));
                this.IIlIIIlI.merge((Object)product);
                this.IIIllIlI.flush();
                this.IIlIlIII.build(product);
            }
            for (OrderLog orderLog2 : order.getOrderItems()) {
                if (orderLog2 == null) continue;
                product = orderLog2.getProduct();
                this.IIlIIIlI.lock((Object)product, LockModeType.PESSIMISTIC_WRITE);
                if (product == null || product.getStock() == null) continue;
                product.setAllocatedStock(Integer.valueOf(product.getAllocatedStock() + (orderLog2.getQuantity() - orderLog2.getShippedQuantity())));
                this.IIlIIIlI.merge((Object)product);
                this.IIlIIIlI.flush();
                this.IIlIlIII.build(product);
            }
        }
        this.IIIllIlI.merge((Object)order);
        orderLog2 = new OrderLog();
        orderLog2.setType(OrderLog$Type.modify);
        orderLog2.setOperator(operator != null ? operator.getUsername() : null);
        orderLog2.setOrder(order);
        this.IIIlllII.persist((Object)orderLog2);
    }

    public void confirm(net.shopxx.entity.Order order, Admin operator) {
        Assert.notNull((Object)order);
        order.setOrderStatus(Order$OrderStatus.confirmed);
        this.IIIllIlI.merge((Object)order);
        OrderLog orderLog = new OrderLog();
        orderLog.setType(OrderLog$Type.confirm);
        orderLog.setOperator(operator != null ? operator.getUsername() : null);
        orderLog.setOrder(order);
        this.IIIlllII.persist((Object)orderLog);
    }

    public void complete(net.shopxx.entity.Order order, Admin operator) {
        Product product;
        CouponCode couponCode2;
        Assert.notNull((Object)order);
        Member member = order.getMember();
        this.IIlIIIII.lock((Object)member, LockModeType.PESSIMISTIC_WRITE);
        if (order.getShippingStatus() == Order$ShippingStatus.partialShipment || order.getShippingStatus() == Order$ShippingStatus.shipped) {
            member.setPoint(Long.valueOf(member.getPoint() + (long)order.getPoint().intValue()));
            for (CouponCode couponCode2 : order.getCoupons()) {
                this.IIIllllI.build((Coupon)couponCode2, member);
            }
        }
        if ((order.getShippingStatus() == Order$ShippingStatus.unshipped || order.getShippingStatus() == Order$ShippingStatus.returned) && (couponCode2 = order.getCouponCode()) != null) {
            couponCode2.setIsUsed(Boolean.valueOf(false));
            couponCode2.setUsedDate(null);
            this.IIIllllI.merge((Object)couponCode2);
            order.setCouponCode(null);
            this.IIIllIlI.merge((Object)order);
        }
        member.setAmount(member.getAmount().add(order.getAmountPaid()));
        if (!member.getMemberRank().getIsSpecial().booleanValue() && (couponCode2 = this.IIlIIIIl.findByAmount(member.getAmount())) != null && couponCode2.getAmount().compareTo(member.getMemberRank().getAmount()) > 0) {
            member.setMemberRank((MemberRank)couponCode2);
        }
        this.IIlIIIII.merge((Object)member);
        if (order.getIsAllocatedStock().booleanValue()) {
            for (CouponCode couponCode2 : order.getOrderItems()) {
                if (couponCode2 == null) continue;
                product = couponCode2.getProduct();
                this.IIlIIIlI.lock((Object)product, LockModeType.PESSIMISTIC_WRITE);
                if (product == null || product.getStock() == null) continue;
                product.setAllocatedStock(Integer.valueOf(product.getAllocatedStock() - (couponCode2.getQuantity() - couponCode2.getShippedQuantity())));
                this.IIlIIIlI.merge((Object)product);
                this.IIIllIlI.flush();
                this.IIlIlIII.build(product);
            }
            order.setIsAllocatedStock(Boolean.valueOf(false));
        }
        for (CouponCode couponCode2 : order.getOrderItems()) {
            if (couponCode2 == null) continue;
            product = couponCode2.getProduct();
            this.IIlIIIlI.lock((Object)product, LockModeType.PESSIMISTIC_WRITE);
            if (product == null) continue;
            Integer n = couponCode2.getQuantity();
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = DateUtils.toCalendar((Date)product.getWeekSalesDate());
            Calendar calendar3 = DateUtils.toCalendar((Date)product.getMonthSalesDate());
            if (calendar.get(1) != calendar2.get(1) || calendar.get(3) > calendar2.get(3)) {
                product.setWeekSales(Long.valueOf(n.intValue()));
            } else {
                product.setWeekSales(Long.valueOf(product.getWeekSales() + (long)n.intValue()));
            }
            if (calendar.get(1) != calendar3.get(1) || calendar.get(2) > calendar3.get(2)) {
                product.setMonthSales(Long.valueOf(n.intValue()));
            } else {
                product.setMonthSales(Long.valueOf(product.getMonthSales() + (long)n.intValue()));
            }
            product.setSales(Long.valueOf(product.getSales() + (long)n.intValue()));
            product.setWeekSalesDate(new Date());
            product.setMonthSalesDate(new Date());
            this.IIlIIIlI.merge((Object)product);
            this.IIIllIlI.flush();
            this.IIlIlIII.build(product);
        }
        order.setOrderStatus(Order$OrderStatus.completed);
        order.setExpire(null);
        this.IIIllIlI.merge((Object)order);
        couponCode2 = new OrderLog();
        couponCode2.setType(OrderLog$Type.complete);
        couponCode2.setOperator(operator != null ? operator.getUsername() : null);
        couponCode2.setOrder(order);
        this.IIIlllII.persist((Object)couponCode2);
    }

    public void cancel(net.shopxx.entity.Order order, Admin operator) {
        OrderItem orderItem2;
        Assert.notNull((Object)order);
        CouponCode couponCode = order.getCouponCode();
        if (couponCode != null) {
            couponCode.setIsUsed(Boolean.valueOf(false));
            couponCode.setUsedDate(null);
            this.IIIllllI.merge((Object)couponCode);
            order.setCouponCode(null);
            this.IIIllIlI.merge((Object)order);
        }
        if (order.getIsAllocatedStock().booleanValue()) {
            for (OrderItem orderItem2 : order.getOrderItems()) {
                if (orderItem2 == null) continue;
                Product product = orderItem2.getProduct();
                this.IIlIIIlI.lock((Object)product, LockModeType.PESSIMISTIC_WRITE);
                if (product == null || product.getStock() == null) continue;
                product.setAllocatedStock(Integer.valueOf(product.getAllocatedStock() - (orderItem2.getQuantity() - orderItem2.getShippedQuantity())));
                this.IIlIIIlI.merge((Object)product);
                this.IIIllIlI.flush();
                this.IIlIlIII.build(product);
            }
            order.setIsAllocatedStock(Boolean.valueOf(false));
        }
        order.setOrderStatus(Order$OrderStatus.cancelled);
        order.setExpire(null);
        this.IIIllIlI.merge((Object)order);
        orderItem2 = new OrderLog();
        orderItem2.setType(OrderLog$Type.cancel);
        orderItem2.setOperator(operator != null ? operator.getUsername() : null);
        orderItem2.setOrder(order);
        this.IIIlllII.persist((Object)orderItem2);
    }

    public void payment(net.shopxx.entity.Order order, Payment payment, Admin operator) {
        OrderItem orderItem2;
        Setting setting;
        Assert.notNull((Object)order);
        Assert.notNull((Object)payment);
        this.IIIllIlI.lock((Object)order, LockModeType.PESSIMISTIC_WRITE);
        payment.setOrder(order);
        this.IIlIIlII.merge((Object)payment);
        if (payment.getType() == Payment$Type.deposit) {
            setting = order.getMember();
            this.IIlIIIII.lock((Object)setting, LockModeType.PESSIMISTIC_WRITE);
            setting.setBalance(setting.getBalance().subtract(payment.getAmount()));
            this.IIlIIIII.merge((Object)setting);
            orderItem2 = new Deposit();
            orderItem2.setType(operator != null ? Deposit$Type.adminPayment : Deposit$Type.memberPayment);
            orderItem2.setCredit(new BigDecimal(0));
            orderItem2.setDebit(payment.getAmount());
            orderItem2.setBalance(setting.getBalance());
            orderItem2.setOperator(operator != null ? operator.getUsername() : null);
            orderItem2.setMember((Member)setting);
            orderItem2.setOrder(order);
            this.IIlIIIll.persist((Object)orderItem2);
        }
        setting = SettingUtils.get();
        if (!order.getIsAllocatedStock().booleanValue() && setting.getStockAllocationTime() == Setting.StockAllocationTime.payment) {
            for (OrderItem orderItem2 : order.getOrderItems()) {
                if (orderItem2 == null) continue;
                Product product = orderItem2.getProduct();
                this.IIlIIIlI.lock((Object)product, LockModeType.PESSIMISTIC_WRITE);
                if (product == null || product.getStock() == null) continue;
                product.setAllocatedStock(Integer.valueOf(product.getAllocatedStock() + (orderItem2.getQuantity() - orderItem2.getShippedQuantity())));
                this.IIlIIIlI.merge((Object)product);
                this.IIIllIlI.flush();
                this.IIlIlIII.build(product);
            }
            order.setIsAllocatedStock(Boolean.valueOf(true));
        }
        order.setAmountPaid(order.getAmountPaid().add(payment.getAmount()));
        order.setFee(payment.getFee());
        order.setExpire(null);
        if (order.getAmountPaid().compareTo(order.getAmount()) >= 0) {
            order.setOrderStatus(Order$OrderStatus.confirmed);
            order.setPaymentStatus(Order$PaymentStatus.paid);
        } else if (order.getAmountPaid().compareTo(new BigDecimal(0)) > 0) {
            order.setOrderStatus(Order$OrderStatus.confirmed);
            order.setPaymentStatus(Order$PaymentStatus.partialPayment);
        }
        this.IIIllIlI.merge((Object)order);
        orderItem2 = new OrderLog();
        orderItem2.setType(OrderLog$Type.payment);
        orderItem2.setOperator(operator != null ? operator.getUsername() : null);
        orderItem2.setOrder(order);
        this.IIIlllII.persist((Object)orderItem2);
    }

    public void refunds(net.shopxx.entity.Order order, Refunds refunds, Admin operator) {
        Member member;
        Assert.notNull((Object)order);
        Assert.notNull((Object)refunds);
        this.IIIllIlI.lock((Object)order, LockModeType.PESSIMISTIC_WRITE);
        refunds.setOrder(order);
        this.IIlIIlIl.persist((Object)refunds);
        if (refunds.getType() == Refunds$Type.deposit) {
            member = order.getMember();
            this.IIlIIIII.lock((Object)member, LockModeType.PESSIMISTIC_WRITE);
            member.setBalance(member.getBalance().add(refunds.getAmount()));
            this.IIlIIIII.merge((Object)member);
            Deposit deposit = new Deposit();
            deposit.setType(Deposit$Type.adminRefunds);
            deposit.setCredit(refunds.getAmount());
            deposit.setDebit(new BigDecimal(0));
            deposit.setBalance(member.getBalance());
            deposit.setOperator(operator != null ? operator.getUsername() : null);
            deposit.setMember(member);
            deposit.setOrder(order);
            this.IIlIIIll.persist((Object)deposit);
        }
        order.setAmountPaid(order.getAmountPaid().subtract(refunds.getAmount()));
        order.setExpire(null);
        if (order.getAmountPaid().compareTo(new BigDecimal(0)) == 0) {
            order.setPaymentStatus(Order$PaymentStatus.refunded);
        } else if (order.getAmountPaid().compareTo(new BigDecimal(0)) > 0) {
            order.setPaymentStatus(Order$PaymentStatus.partialRefunds);
        }
        this.IIIllIlI.merge((Object)order);
        member = new OrderLog();
        member.setType(OrderLog$Type.refunds);
        member.setOperator(operator != null ? operator.getUsername() : null);
        member.setOrder(order);
        this.IIIlllII.persist((Object)member);
    }

    public void shipping(net.shopxx.entity.Order order, Shipping shipping, Admin operator) {
        Product product;
        OrderItem orderItem2;
        Assert.notNull((Object)order);
        Assert.notNull((Object)shipping);
        Assert.notEmpty((Collection)shipping.getShippingItems());
        this.IIIllIlI.lock((Object)order, LockModeType.PESSIMISTIC_WRITE);
        Setting setting = SettingUtils.get();
        if (!order.getIsAllocatedStock().booleanValue() && setting.getStockAllocationTime() == Setting.StockAllocationTime.ship) {
            for (OrderItem orderItem2 : order.getOrderItems()) {
                if (orderItem2 == null) continue;
                product = orderItem2.getProduct();
                this.IIlIIIlI.lock((Object)product, LockModeType.PESSIMISTIC_WRITE);
                if (product == null || product.getStock() == null) continue;
                product.setAllocatedStock(Integer.valueOf(product.getAllocatedStock() + (orderItem2.getQuantity() - orderItem2.getShippedQuantity())));
                this.IIlIIIlI.merge((Object)product);
                this.IIIllIlI.flush();
                this.IIlIlIII.build(product);
            }
            order.setIsAllocatedStock(Boolean.valueOf(true));
        }
        shipping.setOrder(order);
        this.IIlIIllI.persist((Object)shipping);
        for (OrderItem orderItem2 : shipping.getShippingItems()) {
            product = order.getOrderItem(orderItem2.getSn());
            if (product == null) continue;
            Product product2 = product.getProduct();
            this.IIlIIIlI.lock((Object)product2, LockModeType.PESSIMISTIC_WRITE);
            if (product2 != null) {
                if (product2.getStock() != null) {
                    product2.setStock(Integer.valueOf(product2.getStock() - orderItem2.getQuantity()));
                    if (order.getIsAllocatedStock().booleanValue()) {
                        product2.setAllocatedStock(Integer.valueOf(product2.getAllocatedStock() - orderItem2.getQuantity()));
                    }
                }
                this.IIlIIIlI.merge((Object)product2);
                this.IIIllIlI.flush();
                this.IIlIlIII.build(product2);
            }
            this.IIIllIll.lock((Object)product, LockModeType.PESSIMISTIC_WRITE);
            product.setShippedQuantity(Integer.valueOf(product.getShippedQuantity() + orderItem2.getQuantity()));
        }
        if (order.getShippedQuantity() >= order.getQuantity()) {
            order.setShippingStatus(Order$ShippingStatus.shipped);
            order.setIsAllocatedStock(Boolean.valueOf(false));
        } else if (order.getShippedQuantity() > 0) {
            order.setShippingStatus(Order$ShippingStatus.partialShipment);
        }
        order.setExpire(null);
        this.IIIllIlI.merge((Object)order);
        orderItem2 = new OrderLog();
        orderItem2.setType(OrderLog$Type.shipping);
        orderItem2.setOperator(operator != null ? operator.getUsername() : null);
        orderItem2.setOrder(order);
        this.IIIlllII.persist((Object)orderItem2);
    }

    public void returns(net.shopxx.entity.Order order, Returns returns, Admin operator) {
        ReturnsItem returnsItem2;
        Assert.notNull((Object)order);
        Assert.notNull((Object)returns);
        Assert.notEmpty((Collection)returns.getReturnsItems());
        this.IIIllIlI.lock((Object)order, LockModeType.PESSIMISTIC_WRITE);
        returns.setOrder(order);
        this.IIlIIlll.persist((Object)returns);
        for (ReturnsItem returnsItem2 : returns.getReturnsItems()) {
            OrderItem orderItem = order.getOrderItem(returnsItem2.getSn());
            if (orderItem == null) continue;
            this.IIIllIll.lock((Object)orderItem, LockModeType.PESSIMISTIC_WRITE);
            orderItem.setReturnQuantity(Integer.valueOf(orderItem.getReturnQuantity() + returnsItem2.getQuantity()));
        }
        if (order.getReturnQuantity() >= order.getShippedQuantity()) {
            order.setShippingStatus(Order$ShippingStatus.returned);
        } else if (order.getReturnQuantity() > 0) {
            order.setShippingStatus(Order$ShippingStatus.partialReturns);
        }
        order.setExpire(null);
        this.IIIllIlI.merge((Object)order);
        returnsItem2 = new OrderLog();
        returnsItem2.setType(OrderLog$Type.returns);
        returnsItem2.setOperator(operator != null ? operator.getUsername() : null);
        returnsItem2.setOrder(order);
        this.IIIlllII.persist((Object)returnsItem2);
    }

    public void delete(net.shopxx.entity.Order order) {
        if (order.getIsAllocatedStock().booleanValue()) {
            for (OrderItem orderItem : order.getOrderItems()) {
                if (orderItem == null) continue;
                Product product = orderItem.getProduct();
                this.IIlIIIlI.lock((Object)product, LockModeType.PESSIMISTIC_WRITE);
                if (product == null || product.getStock() == null) continue;
                product.setAllocatedStock(Integer.valueOf(product.getAllocatedStock() - (orderItem.getQuantity() - orderItem.getShippedQuantity())));
                this.IIlIIIlI.merge((Object)product);
                this.IIIllIlI.flush();
                this.IIlIlIII.build(product);
            }
        }
        super.delete((Object)order);
    }
}

