/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.LockModeType;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.shopxx.Filter;
import net.shopxx.Order;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.dao.BaseDao;
import net.shopxx.dao.ProductDao;
import net.shopxx.entity.Attribute;
import net.shopxx.entity.Brand;
import net.shopxx.entity.Member;
import net.shopxx.entity.Product;
import net.shopxx.entity.Product$OrderType;
import net.shopxx.entity.ProductCategory;
import net.shopxx.entity.Promotion;
import net.shopxx.entity.Tag;
import net.shopxx.service.ProductService;
import net.shopxx.service.StaticService;
import net.shopxx.service.impl.BaseServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="productServiceImpl")
public class ProductServiceImpl
extends BaseServiceImpl<Product, Long>
implements ProductService,
DisposableBean {
    private long IIIllIlI = System.currentTimeMillis();
    @Resource(name="ehCacheManager")
    private CacheManager IIIllIll;
    @Resource(name="productDaoImpl")
    private ProductDao IIIlllII;
    @Resource(name="staticServiceImpl")
    private StaticService IIIlllIl;

    @Resource(name="productDaoImpl")
    public void setBaseDao(ProductDao productDao) {
        super.setBaseDao((BaseDao)productDao);
    }

    @Transactional(readOnly=true)
    public boolean snExists(String sn) {
        return this.IIIlllII.snExists(sn);
    }

    @Transactional(readOnly=true)
    public Product findBySn(String sn) {
        return this.IIIlllII.findBySn(sn);
    }

    @Transactional(readOnly=true)
    public boolean snUnique(String previousSn, String currentSn) {
        if (StringUtils.equalsIgnoreCase((String)previousSn, (String)currentSn)) {
            return true;
        }
        return !this.IIIlllII.snExists(currentSn);
    }

    @Transactional(readOnly=true)
    public List<Product> search(String keyword, Boolean isGift, Integer count) {
        return this.IIIlllII.search(keyword, isGift, count);
    }

    @Transactional(readOnly=true)
    public List<Product> findList(ProductCategory productCategory, Brand brand, Promotion promotion, List<Tag> tags, Map<Attribute, String> attributeValue, BigDecimal startPrice, BigDecimal endPrice, Boolean isMarketable, Boolean isList, Boolean isTop, Boolean isGift, Boolean isOutOfStock, Boolean isStockAlert, Product$OrderType orderType, Integer count, List<Filter> filters, List<Order> orders) {
        return this.IIIlllII.findList(productCategory, brand, promotion, tags, attributeValue, startPrice, endPrice, isMarketable, isList, isTop, isGift, isOutOfStock, isStockAlert, orderType, count, filters, orders);
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"product"})
    public List<Product> findList(ProductCategory productCategory, Brand brand, Promotion promotion, List<Tag> tags, Map<Attribute, String> attributeValue, BigDecimal startPrice, BigDecimal endPrice, Boolean isMarketable, Boolean isList, Boolean isTop, Boolean isGift, Boolean isOutOfStock, Boolean isStockAlert, Product$OrderType orderType, Integer count, List<Filter> filters, List<Order> orders, String cacheRegion) {
        return this.IIIlllII.findList(productCategory, brand, promotion, tags, attributeValue, startPrice, endPrice, isMarketable, isList, isTop, isGift, isOutOfStock, isStockAlert, orderType, count, filters, orders);
    }

    @Transactional(readOnly=true)
    public List<Product> findList(ProductCategory productCategory, Date beginDate, Date endDate, Integer first, Integer count) {
        return this.IIIlllII.findList(productCategory, beginDate, endDate, first, count);
    }

    @Transactional(readOnly=true)
    public Page<Product> findPage(ProductCategory productCategory, Brand brand, Promotion promotion, List<Tag> tags, Map<Attribute, String> attributeValue, BigDecimal startPrice, BigDecimal endPrice, Boolean isMarketable, Boolean isList, Boolean isTop, Boolean isGift, Boolean isOutOfStock, Boolean isStockAlert, Product$OrderType orderType, Pageable pageable) {
        return this.IIIlllII.findPage(productCategory, brand, promotion, tags, attributeValue, startPrice, endPrice, isMarketable, isList, isTop, isGift, isOutOfStock, isStockAlert, orderType, pageable);
    }

    @Transactional(readOnly=true)
    public Page<Product> findPage(Member member, Pageable pageable) {
        return this.IIIlllII.findPage(member, pageable);
    }

    @Transactional(readOnly=true)
    public Page<Object> findSalesPage(Date beginDate, Date endDate, Pageable pageable) {
        return this.IIIlllII.findSalesPage(beginDate, endDate, pageable);
    }

    @Transactional(readOnly=true)
    public Long count(Member favoriteMember, Boolean isMarketable, Boolean isList, Boolean isTop, Boolean isGift, Boolean isOutOfStock, Boolean isStockAlert) {
        return this.IIIlllII.count(favoriteMember, isMarketable, isList, isTop, isGift, isOutOfStock, isStockAlert);
    }

    @Transactional(readOnly=true)
    public boolean isPurchased(Member member, Product product) {
        return this.IIIlllII.isPurchased(member, product);
    }

    public long viewHits(Long id) {
        Long l;
        Ehcache ehcache = this.IIIllIll.getEhcache("productHits");
        Element element = ehcache.get((Serializable)id);
        if (element != null) {
            l = (Long)element.getObjectValue();
        } else {
            Product product = (Product)this.IIIlllII.find((Serializable)id);
            if (product == null) {
                return 0L;
            }
            l = product.getHits();
        }
        l = l + 1L;
        ehcache.put(new Element((Serializable)id, (Serializable)l));
        long l2 = System.currentTimeMillis();
        if (l2 > this.IIIllIlI + 600000L) {
            this.IIIllIlI = l2;
            this.IIIllIlI();
            ehcache.removeAll();
        }
        return l;
    }

    public void destroy() {
        this.IIIllIlI();
    }

    private void IIIllIlI() {
        Ehcache ehcache = this.IIIllIll.getEhcache("productHits");
        List list = ehcache.getKeys();
        for (Long l : list) {
            Product product = (Product)this.IIIlllII.find((Serializable)l);
            if (product == null) continue;
            this.IIIlllII.lock((Object)product, LockModeType.PESSIMISTIC_WRITE);
            Element element = ehcache.get((Serializable)l);
            long l2 = (Long)element.getObjectValue();
            long l3 = l2 - product.getHits();
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = DateUtils.toCalendar((Date)product.getWeekHitsDate());
            Calendar calendar3 = DateUtils.toCalendar((Date)product.getMonthHitsDate());
            if (calendar.get(1) != calendar2.get(1) || calendar.get(3) > calendar2.get(3)) {
                product.setWeekHits(Long.valueOf(l3));
            } else {
                product.setWeekHits(Long.valueOf(product.getWeekHits() + l3));
            }
            if (calendar.get(1) != calendar3.get(1) || calendar.get(2) > calendar3.get(2)) {
                product.setMonthHits(Long.valueOf(l3));
            } else {
                product.setMonthHits(Long.valueOf(product.getMonthHits() + l3));
            }
            product.setHits(Long.valueOf(l2));
            product.setWeekHitsDate(new Date());
            product.setMonthHitsDate(new Date());
            this.IIIlllII.merge((Object)product);
        }
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public void save(Product product) {
        Assert.notNull((Object)product);
        super.save((Object)product);
        this.IIIlllII.flush();
        this.IIIlllIl.build(product);
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public Product update(Product product) {
        Assert.notNull((Object)product);
        Product product2 = (Product)super.update((Object)product);
        this.IIIlllII.flush();
        this.IIIlllIl.build(product2);
        return product2;
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public Product update(Product product, String ... ignoreProperties) {
        return (Product)super.update((Object)product, ignoreProperties);
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public void delete(Long id) {
        super.delete((Serializable)id);
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public void delete(Long ... ids) {
        super.delete((Serializable[])ids);
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public void delete(Product product) {
        if (product != null) {
            this.IIIlllIl.delete(product);
        }
        super.delete((Object)product);
    }
}

