/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import net.shopxx.Filter;
import net.shopxx.Order;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.dao.BaseDao;
import net.shopxx.dao.ProductDao;
import net.shopxx.dao.ReviewDao;
import net.shopxx.entity.Member;
import net.shopxx.entity.Product;
import net.shopxx.entity.Review;
import net.shopxx.entity.Review$Type;
import net.shopxx.service.ReviewService;
import net.shopxx.service.StaticService;
import net.shopxx.service.impl.BaseServiceImpl;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="reviewServiceImpl")
public class ReviewServiceImpl
extends BaseServiceImpl<Review, Long>
implements ReviewService {
    @Resource(name="reviewDaoImpl")
    private ReviewDao IIIllIlI;
    @Resource(name="productDaoImpl")
    private ProductDao IIIllIll;
    @Resource(name="staticServiceImpl")
    private StaticService IIIlllII;

    @Resource(name="reviewDaoImpl")
    public void setBaseDao(ReviewDao reviewDao) {
        super.setBaseDao((BaseDao)reviewDao);
    }

    @Transactional(readOnly=true)
    public List<Review> findList(Member member, Product product, Review$Type type, Boolean isShow, Integer count, List<Filter> filters, List<Order> orders) {
        return this.IIIllIlI.findList(member, product, type, isShow, count, filters, orders);
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"review"})
    public List<Review> findList(Member member, Product product, Review$Type type, Boolean isShow, Integer count, List<Filter> filters, List<Order> orders, String cacheRegion) {
        return this.IIIllIlI.findList(member, product, type, isShow, count, filters, orders);
    }

    @Transactional(readOnly=true)
    public Page<Review> findPage(Member member, Product product, Review$Type type, Boolean isShow, Pageable pageable) {
        return this.IIIllIlI.findPage(member, product, type, isShow, pageable);
    }

    @Transactional(readOnly=true)
    public Long count(Member member, Product product, Review$Type type, Boolean isShow) {
        return this.IIIllIlI.count(member, product, type, isShow);
    }

    @Transactional(readOnly=true)
    public boolean isReviewed(Member member, Product product) {
        return this.IIIllIlI.isReviewed(member, product);
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public void save(Review review) {
        super.save((Object)review);
        Product product = review.getProduct();
        if (product != null) {
            this.IIIllIlI.flush();
            long l = this.IIIllIlI.calculateTotalScore(product);
            long l2 = this.IIIllIlI.calculateScoreCount(product);
            product.setTotalScore(Long.valueOf(l));
            product.setScoreCount(Long.valueOf(l2));
            this.IIIllIll.merge((Object)product);
            this.IIIllIlI.flush();
            this.IIIlllII.build(product);
        }
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public Review update(Review review) {
        Review review2 = (Review)super.update((Object)review);
        Product product = review2.getProduct();
        if (product != null) {
            this.IIIllIlI.flush();
            long l = this.IIIllIlI.calculateTotalScore(product);
            long l2 = this.IIIllIlI.calculateScoreCount(product);
            product.setTotalScore(Long.valueOf(l));
            product.setScoreCount(Long.valueOf(l2));
            this.IIIllIll.merge((Object)product);
            this.IIIllIlI.flush();
            this.IIIlllII.build(product);
        }
        return review2;
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public Review update(Review review, String ... ignoreProperties) {
        return (Review)super.update((Object)review, ignoreProperties);
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public void delete(Long id) {
        super.delete((Serializable)id);
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public void delete(Long ... ids) {
        super.delete((Serializable[])ids);
    }

    @Transactional
    @CacheEvict(value={"product", "productCategory", "review", "consultation"}, allEntries=true)
    public void delete(Review review) {
        if (review != null) {
            super.delete((Object)review);
            Product product = review.getProduct();
            if (product != null) {
                this.IIIllIlI.flush();
                long l = this.IIIllIlI.calculateTotalScore(product);
                long l2 = this.IIIllIlI.calculateScoreCount(product);
                product.setTotalScore(Long.valueOf(l));
                product.setScoreCount(Long.valueOf(l2));
                this.IIIllIll.merge((Object)product);
                this.IIIllIlI.flush();
                this.IIIlllII.build(product);
            }
        }
    }
}

