/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import net.shopxx.Filter;
import net.shopxx.Page;
import net.shopxx.Pageable;
import net.shopxx.dao.ArticleDao;
import net.shopxx.dao.ProductDao;
import net.shopxx.entity.Article;
import net.shopxx.entity.Product;
import net.shopxx.entity.Product$OrderType;
import net.shopxx.service.SearchService;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Version;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.wltea.analyzer.lucene.IKAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="searchServiceImpl")
@Transactional
public class SearchServiceImpl
implements SearchService {
    private static final float IIIllIll = 0.5f;
    @PersistenceContext
    protected EntityManager IIIllIlI;
    @Resource(name="articleDaoImpl")
    private ArticleDao IIIlllII;
    @Resource(name="productDaoImpl")
    private ProductDao IIIlllIl;

    public void index() {
        this.index(Article.class);
        this.index(Product.class);
    }

    public void index(Class<?> type) {
        block5: {
            FullTextEntityManager fullTextEntityManager;
            block4: {
                fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.IIIllIlI);
                if (type != Article.class) break block4;
                int n = 0;
                while ((long)n < this.IIIlllII.count(new Filter[0])) {
                    List list = this.IIIlllII.findList(Integer.valueOf(n), Integer.valueOf(20), null, null);
                    for (Article article : list) {
                        fullTextEntityManager.index((Object)article);
                    }
                    fullTextEntityManager.flushToIndexes();
                    fullTextEntityManager.clear();
                    this.IIIlllII.clear();
                    n += 20;
                }
                break block5;
            }
            if (type != Product.class) break block5;
            int n = 0;
            while ((long)n < this.IIIlllIl.count(new Filter[0])) {
                List list = this.IIIlllIl.findList(Integer.valueOf(n), Integer.valueOf(20), null, null);
                for (Product product : list) {
                    fullTextEntityManager.index((Object)product);
                }
                fullTextEntityManager.flushToIndexes();
                fullTextEntityManager.clear();
                this.IIIlllIl.clear();
                n += 20;
            }
        }
    }

    public void index(Article article) {
        if (article != null) {
            FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.IIIllIlI);
            fullTextEntityManager.index((Object)article);
        }
    }

    public void index(Product product) {
        if (product != null) {
            FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.IIIllIlI);
            fullTextEntityManager.index((Object)product);
        }
    }

    public void purge() {
        this.purge(Article.class);
        this.purge(Product.class);
    }

    public void purge(Class<?> type) {
        FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.IIIllIlI);
        if (type == Article.class) {
            fullTextEntityManager.purgeAll(Article.class);
        } else if (type == Product.class) {
            fullTextEntityManager.purgeAll(Product.class);
        }
    }

    public void purge(Article article) {
        if (article != null) {
            FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.IIIllIlI);
            fullTextEntityManager.purge(Article.class, (Serializable)article.getId());
        }
    }

    public void purge(Product product) {
        if (product != null) {
            FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.IIIllIlI);
            fullTextEntityManager.purge(Product.class, (Serializable)product.getId());
        }
    }

    @Transactional(readOnly=true)
    public Page<Article> search(String keyword, Pageable pageable) {
        if (StringUtils.isEmpty((String)keyword)) {
            return new Page();
        }
        if (pageable == null) {
            pageable = new Pageable();
        }
        try {
            String string = QueryParser.escape((String)keyword);
            QueryParser queryParser = new QueryParser(Version.LUCENE_35, "title", (Analyzer)new IKAnalyzer());
            queryParser.setDefaultOperator(QueryParser.AND_OPERATOR);
            Query query = queryParser.parse(string);
            FuzzyQuery fuzzyQuery = new FuzzyQuery(new Term("title", string), 0.5f);
            TermQuery termQuery = new TermQuery(new Term("content", string));
            TermQuery termQuery2 = new TermQuery(new Term("isPublication", "true"));
            BooleanQuery booleanQuery = new BooleanQuery();
            BooleanQuery booleanQuery2 = new BooleanQuery();
            booleanQuery.add(query, BooleanClause.Occur.SHOULD);
            booleanQuery.add((Query)fuzzyQuery, BooleanClause.Occur.SHOULD);
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
            booleanQuery2.add((Query)termQuery2, BooleanClause.Occur.MUST);
            booleanQuery2.add((Query)booleanQuery, BooleanClause.Occur.MUST);
            FullTextEntityManager fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.IIIllIlI);
            FullTextQuery fullTextQuery = fullTextEntityManager.createFullTextQuery((Query)booleanQuery2, new Class[]{Article.class});
            fullTextQuery.setSort(new Sort(new SortField[]{new SortField("isTop", 3, true), new SortField(null, 0), new SortField("createDate", 6, true)}));
            fullTextQuery.setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize());
            fullTextQuery.setMaxResults(pageable.getPageSize());
            return new Page(fullTextQuery.getResultList(), (long)fullTextQuery.getResultSize(), pageable);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return new Page();
        }
    }

    @Transactional(readOnly=true)
    public Page<Product> search(String keyword, BigDecimal startPrice, BigDecimal endPrice, Product$OrderType orderType, Pageable pageable) {
        if (StringUtils.isEmpty((String)keyword)) {
            return new Page();
        }
        if (pageable == null) {
            pageable = new Pageable();
        }
        try {
            BigDecimal bigDecimal;
            String string = QueryParser.escape((String)keyword);
            TermQuery termQuery = new TermQuery(new Term("sn", string));
            Query query = new QueryParser(Version.LUCENE_35, "keyword", (Analyzer)new IKAnalyzer()).parse(string);
            QueryParser queryParser = new QueryParser(Version.LUCENE_35, "name", (Analyzer)new IKAnalyzer());
            queryParser.setDefaultOperator(QueryParser.AND_OPERATOR);
            Query query2 = queryParser.parse(string);
            FuzzyQuery fuzzyQuery = new FuzzyQuery(new Term("name", string), 0.5f);
            TermQuery termQuery2 = new TermQuery(new Term("introduction", string));
            TermQuery termQuery3 = new TermQuery(new Term("isMarketable", "true"));
            TermQuery termQuery4 = new TermQuery(new Term("isList", "true"));
            TermQuery termQuery5 = new TermQuery(new Term("isGift", "false"));
            BooleanQuery booleanQuery = new BooleanQuery();
            BooleanQuery booleanQuery2 = new BooleanQuery();
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
            booleanQuery.add(query, BooleanClause.Occur.SHOULD);
            booleanQuery.add(query2, BooleanClause.Occur.SHOULD);
            booleanQuery.add((Query)fuzzyQuery, BooleanClause.Occur.SHOULD);
            booleanQuery.add((Query)termQuery2, BooleanClause.Occur.SHOULD);
            booleanQuery2.add((Query)termQuery3, BooleanClause.Occur.MUST);
            booleanQuery2.add((Query)termQuery4, BooleanClause.Occur.MUST);
            booleanQuery2.add((Query)termQuery5, BooleanClause.Occur.MUST);
            booleanQuery2.add((Query)booleanQuery, BooleanClause.Occur.MUST);
            if (startPrice != null && endPrice != null && startPrice.compareTo(endPrice) > 0) {
                bigDecimal = startPrice;
                startPrice = endPrice;
                endPrice = bigDecimal;
            }
            if (startPrice != null && startPrice.compareTo(new BigDecimal(0)) >= 0 && endPrice != null && endPrice.compareTo(new BigDecimal(0)) >= 0) {
                bigDecimal = NumericRangeQuery.newDoubleRange((String)"price", (Double)startPrice.doubleValue(), (Double)endPrice.doubleValue(), (boolean)true, (boolean)true);
                booleanQuery2.add((Query)bigDecimal, BooleanClause.Occur.MUST);
            } else if (startPrice != null && startPrice.compareTo(new BigDecimal(0)) >= 0) {
                bigDecimal = NumericRangeQuery.newDoubleRange((String)"price", (Double)startPrice.doubleValue(), null, (boolean)true, (boolean)false);
                booleanQuery2.add((Query)bigDecimal, BooleanClause.Occur.MUST);
            } else if (endPrice != null && endPrice.compareTo(new BigDecimal(0)) >= 0) {
                bigDecimal = NumericRangeQuery.newDoubleRange((String)"price", null, (Double)endPrice.doubleValue(), (boolean)false, (boolean)true);
                booleanQuery2.add((Query)bigDecimal, BooleanClause.Occur.MUST);
            }
            bigDecimal = Search.getFullTextEntityManager((EntityManager)this.IIIllIlI);
            FullTextQuery fullTextQuery = bigDecimal.createFullTextQuery((Query)booleanQuery2, new Class[]{Product.class});
            SortField[] sortFieldArray = null;
            sortFieldArray = orderType == Product$OrderType.priceAsc ? new SortField[]{new SortField("price", 7, false), new SortField("createDate", 6, true)} : (orderType == Product$OrderType.priceDesc ? new SortField[]{new SortField("price", 7, true), new SortField("createDate", 6, true)} : (orderType == Product$OrderType.salesDesc ? new SortField[]{new SortField("sales", 4, true), new SortField("createDate", 6, true)} : (orderType == Product$OrderType.scoreDesc ? new SortField[]{new SortField("score", 4, true), new SortField("createDate", 6, true)} : (orderType == Product$OrderType.dateDesc ? new SortField[]{new SortField("createDate", 6, true)} : new SortField[]{new SortField("isTop", 3, true), new SortField(null, 0), new SortField("modifyDate", 6, true)}))));
            fullTextQuery.setSort(new Sort(sortFieldArray));
            fullTextQuery.setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize());
            fullTextQuery.setMaxResults(pageable.getPageSize());
            return new Page(fullTextQuery.getResultList(), (long)fullTextQuery.getResultSize(), pageable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Page();
        }
    }
}

