/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import net.shopxx.Setting;
import net.shopxx.dao.BaseDao;
import net.shopxx.dao.ShippingDao;
import net.shopxx.entity.Shipping;
import net.shopxx.service.ShippingService;
import net.shopxx.service.impl.BaseServiceImpl;
import net.shopxx.util.SettingUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="shippingServiceImpl")
public class ShippingServiceImpl
extends BaseServiceImpl<Shipping, Long>
implements ShippingService {
    @Resource(name="shippingDaoImpl")
    private ShippingDao IIIllIlI;

    @Resource(name="shippingDaoImpl")
    public void setBaseDao(ShippingDao shippingDao) {
        super.setBaseDao((BaseDao)shippingDao);
    }

    @Transactional(readOnly=true)
    public Shipping findBySn(String sn) {
        return this.IIIllIlI.findBySn(sn);
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"shipping"})
    public Map<String, Object> query(Shipping shipping) {
        Setting setting = SettingUtils.get();
        Map<String, Object> map = new HashMap<String, Object>();
        if (shipping != null && StringUtils.isNotEmpty((String)setting.getKuaidi100Key()) && StringUtils.isNotEmpty((String)shipping.getDeliveryCorpCode()) && StringUtils.isNotEmpty((String)shipping.getTrackingNo())) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                URL uRL = new URL("http://api.kuaidi100.com/api?id=" + setting.getKuaidi100Key() + "&com=" + shipping.getDeliveryCorpCode() + "&nu=" + shipping.getTrackingNo() + "&show=0&muti=1&order=asc");
                map = (Map)objectMapper.readValue(uRL, Map.class);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return map;
    }
}

