/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import net.shopxx.Filter;
import net.shopxx.Template;
import net.shopxx.dao.ArticleDao;
import net.shopxx.dao.BrandDao;
import net.shopxx.dao.ProductDao;
import net.shopxx.dao.PromotionDao;
import net.shopxx.entity.Article;
import net.shopxx.entity.Product;
import net.shopxx.service.StaticService;
import net.shopxx.service.TemplateService;
import net.shopxx.util.FreemarkerUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="staticServiceImpl")
public class StaticServiceImpl
implements StaticService,
ServletContextAware {
    private static final Integer IIIllIlI = 40000;
    private ServletContext IIIllIll;
    @Resource(name="freeMarkerConfigurer")
    private FreeMarkerConfigurer IIIlllII;
    @Resource(name="templateServiceImpl")
    private TemplateService IIIlllIl;
    @Resource(name="articleDaoImpl")
    private ArticleDao IIIllllI;
    @Resource(name="productDaoImpl")
    private ProductDao IIIlllll;
    @Resource(name="brandDaoImpl")
    private BrandDao IIlIIIII;
    @Resource(name="promotionDaoImpl")
    private PromotionDao IIlIIIIl;

    public void setServletContext(ServletContext servletContext) {
        this.IIIllIll = servletContext;
    }

    @Transactional(readOnly=true)
    public int build(String templatePath, String staticPath, Map<String, Object> model) {
        block6: {
            Assert.hasText((String)templatePath);
            Assert.hasText((String)staticPath);
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            BufferedWriter bufferedWriter = null;
            try {
                freemarker.template.Template template = this.IIIlllII.getConfiguration().getTemplate(templatePath);
                File file = new File(this.IIIllIll.getRealPath(staticPath));
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                fileOutputStream = new FileOutputStream(file);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                template.process(model, (Writer)bufferedWriter);
                ((Writer)bufferedWriter).flush();
                IOUtils.closeQuietly((Writer)bufferedWriter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break block6;
            }
            finally {
                IOUtils.closeQuietly(bufferedWriter);
                IOUtils.closeQuietly(outputStreamWriter);
                IOUtils.closeQuietly(fileOutputStream);
            }
            IOUtils.closeQuietly((Writer)outputStreamWriter);
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            return 1;
        }
        return 0;
    }

    @Transactional(readOnly=true)
    public int build(String templatePath, String staticPath) {
        return this.build(templatePath, staticPath, null);
    }

    @Transactional(readOnly=true)
    public int build(Article article) {
        Assert.notNull((Object)article);
        this.delete(article);
        Template template = this.IIIlllIl.get("articleContent");
        int n = 0;
        if (article.getIsPublication().booleanValue()) {
            HashMap<String, Article> hashMap = new HashMap<String, Article>();
            hashMap.put("article", article);
            int n2 = 1;
            while (n2 <= article.getTotalPages()) {
                article.setPageNumber(Integer.valueOf(n2));
                n += this.build(template.getTemplatePath(), article.getPath(), hashMap);
                ++n2;
            }
            article.setPageNumber(null);
        }
        return n;
    }

    @Transactional(readOnly=true)
    public int build(Product product) {
        Assert.notNull((Object)product);
        this.delete(product);
        Template template = this.IIIlllIl.get("productContent");
        int n = 0;
        if (product.getIsMarketable().booleanValue()) {
            HashMap<String, Product> hashMap = new HashMap<String, Product>();
            hashMap.put("product", product);
            n += this.build(template.getTemplatePath(), product.getPath(), hashMap);
        }
        return n;
    }

    @Transactional(readOnly=true)
    public int buildIndex() {
        Template template = this.IIIlllIl.get("index");
        return this.build(template.getTemplatePath(), template.getStaticPath());
    }

    @Transactional(readOnly=true)
    public int buildSitemap() {
        int n = 0;
        Template template = this.IIIlllIl.get("sitemapIndex");
        Template template2 = this.IIIlllIl.get("sitemap");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = IIIllIlI;
        block2: while (true) {
            try {
                while (true) {
                    List list;
                    hashMap.put("index", n3);
                    String string = template2.getTemplatePath();
                    String string2 = FreemarkerUtils.process((String)template2.getStaticPath(), hashMap);
                    if (n2 == 0) {
                        list = this.IIIllllI.findList(Integer.valueOf(n4), Integer.valueOf(n5), null, null);
                        hashMap.put("articles", list);
                        if (list.size() < n5) {
                            ++n2;
                            n4 = 0;
                            n5 -= list.size();
                            continue;
                        }
                        n += this.build(string, string2, hashMap);
                        this.IIIllllI.clear();
                        this.IIIllllI.flush();
                        arrayList.add(string2);
                        hashMap.clear();
                        ++n3;
                        n4 += list.size();
                        n5 = IIIllIlI;
                        continue;
                    }
                    if (n2 == 1) {
                        list = this.IIIlllll.findList(Integer.valueOf(n4), Integer.valueOf(n5), null, null);
                        hashMap.put("products", list);
                        if (list.size() < n5) {
                            ++n2;
                            n4 = 0;
                            n5 -= list.size();
                            continue;
                        }
                        n += this.build(string, string2, hashMap);
                        this.IIIlllll.clear();
                        this.IIIlllll.flush();
                        arrayList.add(string2);
                        hashMap.clear();
                        ++n3;
                        n4 += list.size();
                        n5 = IIIllIlI;
                        continue;
                    }
                    if (n2 == 2) {
                        list = this.IIlIIIII.findList(Integer.valueOf(n4), Integer.valueOf(n5), null, null);
                        hashMap.put("brands", list);
                        if (list.size() < n5) {
                            ++n2;
                            n4 = 0;
                            n5 -= list.size();
                            continue;
                        }
                        n += this.build(string, string2, hashMap);
                        this.IIlIIIII.clear();
                        this.IIlIIIII.flush();
                        arrayList.add(string2);
                        hashMap.clear();
                        ++n3;
                        n4 += list.size();
                        n5 = IIIllIlI;
                        continue;
                    }
                    if (n2 != 3) continue;
                    list = this.IIlIIIIl.findList(Integer.valueOf(n4), Integer.valueOf(n5), null, null);
                    hashMap.put("promotions", list);
                    n += this.build(string, string2, hashMap);
                    this.IIlIIIIl.clear();
                    this.IIlIIIIl.flush();
                    arrayList.add(string2);
                    if (list.size() < n5) {
                        hashMap.put("staticPaths", arrayList);
                        break block2;
                    }
                    hashMap.clear();
                    ++n3;
                    n4 += list.size();
                    n5 = IIIllIlI;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
        return n += this.build(template.getTemplatePath(), template.getStaticPath(), hashMap);
    }

    @Transactional(readOnly=true)
    public int buildOther() {
        int n = 0;
        Template template = this.IIIlllIl.get("shopCommonJs");
        Template template2 = this.IIIlllIl.get("adminCommonJs");
        n += this.build(template.getTemplatePath(), template.getStaticPath());
        return n += this.build(template2.getTemplatePath(), template2.getStaticPath());
    }

    @Transactional(readOnly=true)
    public int buildAll() {
        List list;
        int n = 0;
        int n2 = 0;
        while ((long)n2 < this.IIIllllI.count(new Filter[0])) {
            list = this.IIIllllI.findList(Integer.valueOf(n2), Integer.valueOf(20), null, null);
            for (Article article : list) {
                n += this.build(article);
            }
            this.IIIllllI.clear();
            n2 += 20;
        }
        n2 = 0;
        while ((long)n2 < this.IIIlllll.count(new Filter[0])) {
            list = this.IIIlllll.findList(Integer.valueOf(n2), Integer.valueOf(20), null, null);
            for (Article article : list) {
                n += this.build((Product)article);
            }
            this.IIIlllll.clear();
            n2 += 20;
        }
        this.buildIndex();
        this.buildSitemap();
        this.buildOther();
        return n;
    }

    @Transactional(readOnly=true)
    public int delete(String staticPath) {
        Assert.hasText((String)staticPath);
        File file = new File(this.IIIllIll.getRealPath(staticPath));
        if (file.exists()) {
            file.delete();
            return 1;
        }
        return 0;
    }

    @Transactional(readOnly=true)
    public int delete(Article article) {
        Assert.notNull((Object)article);
        int n = 0;
        int n2 = 1;
        while (n2 <= article.getTotalPages() + 1000) {
            article.setPageNumber(Integer.valueOf(n2));
            int n3 = this.delete(article.getPath());
            if (n3 < 1) break;
            n += n3;
            ++n2;
        }
        article.setPageNumber(null);
        return n;
    }

    @Transactional(readOnly=true)
    public int delete(Product product) {
        Assert.notNull((Object)product);
        return this.delete(product.getPath());
    }

    @Transactional(readOnly=true)
    public int deleteIndex() {
        Template template = this.IIIlllIl.get("index");
        return this.delete(template.getStaticPath());
    }

    @Transactional(readOnly=true)
    public int deleteOther() {
        int n = 0;
        Template template = this.IIIlllIl.get("shopCommonJs");
        Template template2 = this.IIIlllIl.get("adminCommonJs");
        n += this.delete(template.getStaticPath());
        return n += this.delete(template2.getStaticPath());
    }
}

