/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.service.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import net.shopxx.Template;
import net.shopxx.Template$Type;
import net.shopxx.service.TemplateService;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="templateServiceImpl")
public class TemplateServiceImpl
implements TemplateService,
ServletContextAware {
    private ServletContext IIIllIlI;
    @Value(value="${template.loader_path}")
    private String[] IIIllIll;

    public void setServletContext(ServletContext servletContext) {
        this.IIIllIlI = servletContext;
    }

    @Cacheable(value={"template"})
    public List<Template> getAll() {
        try {
            File file = new ClassPathResource("/shopxx.xml").getFile();
            Document document = new SAXReader().read(file);
            ArrayList<Template> arrayList = new ArrayList<Template>();
            List list = document.selectNodes("/shopxx/template");
            for (Element element : list) {
                Template template = this.IIIllIlI(element);
                arrayList.add(template);
            }
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Cacheable(value={"template"})
    public List<Template> getList(Template$Type type) {
        if (type != null) {
            try {
                File file = new ClassPathResource("/shopxx.xml").getFile();
                Document document = new SAXReader().read(file);
                ArrayList<Template> arrayList = new ArrayList<Template>();
                List list = document.selectNodes("/shopxx/template[@type='" + type + "']");
                for (Element element : list) {
                    Template template = this.IIIllIlI(element);
                    arrayList.add(template);
                }
                return arrayList;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return this.getAll();
    }

    @Cacheable(value={"template"})
    public Template get(String id) {
        try {
            File file = new ClassPathResource("/shopxx.xml").getFile();
            Document document = new SAXReader().read(file);
            Element element = (Element)document.selectSingleNode("/shopxx/template[@id='" + id + "']");
            Template template = this.IIIllIlI(element);
            return template;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String read(String id) {
        Template template = this.get(id);
        return this.read(template);
    }

    public String read(Template template) {
        String string = this.IIIllIlI.getRealPath(String.valueOf(this.IIIllIll[0]) + template.getTemplatePath());
        File file = new File(string);
        String string2 = null;
        try {
            string2 = FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string2;
    }

    public void write(String id, String content) {
        Template template = this.get(id);
        this.write(template, content);
    }

    public void write(Template template, String content) {
        String string = this.IIIllIlI.getRealPath(String.valueOf(this.IIIllIll[0]) + template.getTemplatePath());
        File file = new File(string);
        try {
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Template IIIllIlI(Element element) {
        String string = element.attributeValue("id");
        String string2 = element.attributeValue("type");
        String string3 = element.attributeValue("name");
        String string4 = element.attributeValue("templatePath");
        String string5 = element.attributeValue("staticPath");
        String string6 = element.attributeValue("description");
        Template template = new Template();
        template.setId(string);
        template.setType(Template$Type.valueOf((String)string2));
        template.setName(string3);
        template.setTemplatePath(string4);
        template.setStaticPath(string5);
        template.setDescription(string6);
        return template;
    }
}

