/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shopxx.Setting;
import net.shopxx.util.SettingUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CookieUtils {
    private CookieUtils() {
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, Integer maxAge, String path, String domain, Boolean secure) {
        Assert.notNull((Object)request);
        Assert.notNull((Object)response);
        Assert.hasText((String)name);
        try {
            name = URLEncoder.encode(name, "UTF-8");
            value = URLEncoder.encode(value, "UTF-8");
            Cookie cookie = new Cookie(name, value);
            if (maxAge != null) {
                cookie.setMaxAge(maxAge.intValue());
            }
            if (StringUtils.isNotEmpty((String)path)) {
                cookie.setPath(path);
            }
            if (StringUtils.isNotEmpty((String)domain)) {
                cookie.setDomain(domain);
            }
            if (secure != null) {
                cookie.setSecure(secure.booleanValue());
            }
            response.addCookie(cookie);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, Integer maxAge) {
        Setting setting = SettingUtils.get();
        CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)name, (String)value, (Integer)maxAge, (String)setting.getCookiePath(), (String)setting.getCookieDomain(), null);
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        Setting setting = SettingUtils.get();
        CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)name, (String)value, null, (String)setting.getCookiePath(), (String)setting.getCookieDomain(), null);
    }

    public static String getCookie(HttpServletRequest request, String name) {
        Assert.notNull((Object)request);
        Assert.hasText((String)name);
        Cookie[] cookieArray = request.getCookies();
        if (cookieArray != null) {
            try {
                name = URLEncoder.encode(name, "UTF-8");
                Cookie[] cookieArray2 = cookieArray;
                int n = cookieArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Cookie cookie = cookieArray2[n2];
                    if (name.equals(cookie.getName())) {
                        return URLDecoder.decode(cookie.getValue(), "UTF-8");
                    }
                    ++n2;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return null;
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String name, String path, String domain) {
        Assert.notNull((Object)request);
        Assert.notNull((Object)response);
        Assert.hasText((String)name);
        try {
            name = URLEncoder.encode(name, "UTF-8");
            Cookie cookie = new Cookie(name, null);
            cookie.setMaxAge(0);
            if (StringUtils.isNotEmpty((String)path)) {
                cookie.setPath(path);
            }
            if (StringUtils.isNotEmpty((String)domain)) {
                cookie.setDomain(domain);
            }
            response.addCookie(cookie);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        Setting setting = SettingUtils.get();
        CookieUtils.removeCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)name, (String)setting.getCookiePath(), (String)setting.getCookieDomain());
    }
}

