/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.util;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import net.shopxx.CommonAttributes;
import net.shopxx.util.FreemarkerUtils$1;
import net.shopxx.util.SpringUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class FreemarkerUtils {
    private static final ConvertUtilsBean IIIllIlI = new FreemarkerUtils$1();

    static {
        DateConverter dateConverter = new DateConverter();
        dateConverter.setPatterns(CommonAttributes.DATE_PATTERNS);
        IIIllIlI.register((Converter)dateConverter, Date.class);
    }

    private FreemarkerUtils() {
    }

    public static String process(String template, Map<String, ?> model) {
        FreeMarkerConfigurer freeMarkerConfigurer;
        Configuration configuration = null;
        ApplicationContext applicationContext = SpringUtils.getApplicationContext();
        if (applicationContext != null && (freeMarkerConfigurer = (FreeMarkerConfigurer)SpringUtils.getBean((String)"freeMarkerConfigurer", FreeMarkerConfigurer.class)) != null) {
            configuration = freeMarkerConfigurer.getConfiguration();
        }
        return FreemarkerUtils.process((String)template, model, configuration);
    }

    public static String process(String template, Map<String, ?> model, Configuration configuration) {
        if (template == null) {
            return null;
        }
        if (configuration == null) {
            configuration = new Configuration();
        }
        StringWriter stringWriter = new StringWriter();
        try {
            new Template("template", (Reader)new StringReader(template), configuration).process(model, (Writer)stringWriter);
        }
        catch (TemplateException templateException) {
            templateException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringWriter.toString();
    }

    public static <T> T getParameter(String name, Class<T> type, Map<String, TemplateModel> params) {
        Assert.hasText((String)name);
        Assert.notNull(type);
        Assert.notNull(params);
        TemplateModel templateModel = params.get(name);
        if (templateModel == null) {
            return null;
        }
        Object object = DeepUnwrap.unwrap((TemplateModel)templateModel);
        return (T)IIIllIlI.convert(object, type);
    }

    public static TemplateModel getVariable(String name, Environment env) {
        Assert.hasText((String)name);
        Assert.notNull((Object)env);
        return env.getVariable(name);
    }

    public static void setVariable(String name, Object value, Environment env) {
        Assert.hasText((String)name);
        Assert.notNull((Object)env);
        if (value instanceof TemplateModel) {
            env.setVariable(name, (TemplateModel)value);
        } else {
            env.setVariable(name, ObjectWrapper.BEANS_WRAPPER.wrap(value));
        }
    }

    public static void setVariables(Map<String, Object> variables, Environment env) {
        Assert.notNull(variables);
        Assert.notNull((Object)env);
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof TemplateModel) {
                env.setVariable(string, (TemplateModel)object);
                continue;
            }
            env.setVariable(string, ObjectWrapper.BEANS_WRAPPER.wrap(object));
        }
    }
}

