/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonUtils {
    private static ObjectMapper IIIllIlI = new ObjectMapper();

    private JsonUtils() {
    }

    public static String toJson(Object value) {
        try {
            return IIIllIlI.writeValueAsString(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void toJson(HttpServletResponse response, String contentType, Object value) {
        Assert.notNull((Object)response);
        Assert.hasText((String)contentType);
        try {
            response.setContentType(contentType);
            IIIllIlI.writeValue((Writer)response.getWriter(), value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void toJson(HttpServletResponse response, Object value) {
        Assert.notNull((Object)response);
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = response.getWriter();
                IIIllIlI.writeValue((Writer)printWriter, value);
                printWriter.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                IOUtils.closeQuietly((Writer)printWriter);
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)printWriter);
        }
    }

    public static <T> T toObject(String json, Class<T> valueType) {
        Assert.hasText((String)json);
        Assert.notNull(valueType);
        try {
            return (T)IIIllIlI.readValue(json, valueType);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static <T> T toObject(String json, TypeReference<?> typeReference) {
        Assert.hasText((String)json);
        Assert.notNull(typeReference);
        try {
            return (T)IIIllIlI.readValue(json, typeReference);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static <T> T toObject(String json, JavaType javaType) {
        Assert.hasText((String)json);
        Assert.notNull((Object)javaType);
        try {
            return (T)IIIllIlI.readValue(json, javaType);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

