/*
 * Decompiled with CFR 0.152.
 */
package com.intrint.idap.net.API;

import com.intrint.idap.net.API.Debug;
import com.intrint.idap.net.API.IllegalParameterException;
import com.intrint.idap.net.API.LoginFailException;
import com.intrint.idap.net.API.PraseError;
import com.intrint.idap.net.API.SendFailException;
import com.intrint.idap.net.API.SendTimeoutException;
import com.intrint.idap.net.API.Target;
import com.intrint.idap.net.API.TimeTrigger;
import com.intrint.idap.net.API.WrongTelnumException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;

public class EMASendmsg
implements Target {
    private String enterprise_id;
    private String account_id;
    private String password;
    private String telnum;
    private String content;
    private String telnum4out;
    private String encodetype = "GBK";
    private String server;
    private int port;
    private TimeTrigger timer;
    public static String defaultPort = "8088";
    private String orgCode = null;

    private static String convert(String s1, String s2) {
        try {
            byte[] abyte0 = s1.getBytes(s2);
            return new String(abyte0, "GBK");
        }
        catch (Exception exception) {
            return s1;
        }
    }

    public EMASendmsg(String s1, String s2, String s3) throws IllegalParameterException, SendTimeoutException, LoginFailException {
        this.enterprise_id = s1;
        this.password = s2;
        this.encodetype = "GBK";
        this.init();
        this.server = System.getProperty("ipaddr");
        defaultPort = System.getProperty("port");
        Long timeout = new Long(System.getProperty("timeout").toString());
        if (s3 != null && !"".equals(s3)) {
            this.server = s3;
        }
        if (s1 == null || !this.isInt(s1)) {
            throw new IllegalParameterException("enterpriseID must be 5 numbers");
        }
        this.timer = new TimeTrigger(timeout, this);
    }

    private void init() {
        if (System.getProperty("ipaddr") == null) {
            Properties prop = System.getProperties();
            InputStream in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream("init.properties");
            }
            catch (Exception e) {
                try {
                    in = new FileInputStream(new File("init.properties"));
                }
                catch (FileNotFoundException e2) {
                    throw new RuntimeException("\u672a\u627e\u5230init.properties");
                }
            }
            if (in == null) {
                throw new RuntimeException("\u672a\u627e\u5230init.properties");
            }
            try {
                prop.load(in);
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
            System.setProperties(prop);
            System.out.println("---" + System.getProperty("ipaddr"));
            System.out.println("---" + System.getProperty("port"));
            System.out.println("---" + System.getProperty("timeout"));
        }
    }

    private boolean isInt(String s) {
        if (s == null) {
            return false;
        }
        if (s.indexOf("-") >= 0) {
            s = s.substring(1);
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setAccount_id(String s1) {
        this.account_id = s1;
    }

    public void setSenttelnum(String s1) {
        this.telnum = s1;
    }

    public boolean checkSenttelnum(String s1) {
        StringTokenizer stringtokenizer = new StringTokenizer(s1, ";", false);
        this.telnum4out = "";
        while (stringtokenizer.hasMoreTokens()) {
            String s2 = stringtokenizer.nextToken();
            if (s2.length() != 11) {
                return false;
            }
            String s3 = s2.substring(0, 3);
            try {
                Long.parseLong(s2);
            }
            catch (Exception exception) {
                return false;
            }
            this.telnum4out = String.valueOf(this.telnum4out) + "." + s2;
        }
        if (this.telnum4out.substring(0, 1).equals(".")) {
            this.telnum4out = this.telnum4out.substring(1, this.telnum4out.length());
        }
        return true;
    }

    public void targetTriggered() {
        this.timer.stopTimer();
        Debug.println("Client Connection timeout. Closing connection");
    }

    public void setContent(String s1) {
        this.content = s1;
    }

    public void setContentEncode(String s1) {
        this.encodetype = s1.trim().equals("") || !s1.trim().equalsIgnoreCase("GBK") || !s1.trim().equalsIgnoreCase("BIG5") || !s1.trim().equalsIgnoreCase("ISO-8859-1") ? "GBK" : s1;
    }

    private String[] splitString(String str, String exp) {
        int i = str.indexOf(exp);
        ArrayList<String> sd = new ArrayList<String>();
        while (i >= 0) {
            sd.add(str.substring(0, i));
            str = str.substring(i + 1);
            i = str.indexOf(exp);
        }
        if (!"".equals(str)) {
            sd.add(str);
        }
        String[] sds = new String[sd.size()];
        int k = 0;
        while (k < sd.size()) {
            sds[k] = (String)sd.get(k);
            ++k;
        }
        return sds;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public synchronized String[] send() throws WrongTelnumException, SendFailException, SendTimeoutException {
        String[] telArray = this.splitString(this.telnum, ";");
        try {
            try {
                Collection sendContent = EMASendmsg.splitMsg(this.content);
                String[] sendId = new String[]{};
                ArrayList<String> dstId = new ArrayList<String>();
                int i = 0;
                while (i < telArray.length) {
                    String mob = this.checkMobile(telArray[i]);
                    if (mob == null || !this.isInt(mob)) {
                        throw new WrongTelnumException("\u9519\u8bef\u7684\u624b\u673a");
                    }
                    dstId.add(telArray[i]);
                    ++i;
                }
                HttpClient http = new HttpClient();
                this.timer.startTimer();
                int n = 0;
                ArrayList<String> send = new ArrayList<String>();
                Iterator it = sendContent.iterator();
                while (it.hasNext()) {
                    try {
                        StringBuffer url = new StringBuffer();
                        if ("".equals(this.enterprise_id)) {
                            throw new SendFailException("enterpriseID must be 5 numbers");
                        }
                        url.append("http://" + this.server + ":" + defaultPort + "/esmp/httpserver");
                        url.append("?enterpriseid=" + this.enterprise_id);
                        url.append("&accountid=" + this.account_id);
                        url.append("&pswd=" + URLEncoder.encode(this.password));
                        url.append("&mobs=" + this.telnum);
                        String s1 = (String)it.next();
                        System.out.println("-----" + s1);
                        url.append("&msg=" + URLEncoder.encode(s1, this.encodetype));
                        GetMethod get = new GetMethod(url.toString());
                        System.out.println("-----" + s1);
                        http.executeMethod(get);
                        System.out.println("-----" + get.getRequestCharSet());
                        String msgstr = new String(get.getResponseBody(), "GBK");
                        int ln = msgstr.indexOf("100");
                        int lns = msgstr.indexOf("300");
                        if (ln >= 0 || lns >= 0) {
                            sendId = this.splitString(msgstr.substring(ln + 4), "\n");
                            int k = 0;
                            while (k < sendId.length) {
                                if (this.isInt(sendId[k])) {
                                    send.add(sendId[k]);
                                }
                                ++k;
                            }
                        } else if (msgstr.length() == 3) {
                            throw new LoginFailException((String)PraseError.errorMap.get(msgstr));
                        }
                    }
                    catch (HttpException e) {
                        throw new SendFailException("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38");
                    }
                    catch (IOException e) {
                        throw new SendFailException("\u53d1\u9001\u77ed\u4fe1I/O\u5f02\u5e38");
                    }
                    ++n;
                }
                sendId = new String[send.size()];
                it = send.iterator();
                int k = 0;
                while (it.hasNext()) {
                    sendId[k++] = (String)it.next();
                }
                String[] stringArray = sendId;
                Object var16_23 = null;
                if (this.timer != null) {
                    this.timer.stopTimer();
                }
                return stringArray;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SendFailException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            block18: {
                Object var16_24 = null;
                if (this.timer == null) break block18;
                this.timer.stopTimer();
            }
            throw throwable;
        }
    }

    public String[] puttelnum2ary(String s1) {
        ArrayList<String> arraylist = new ArrayList<String>();
        StringTokenizer stringtokenizer = new StringTokenizer(s1, ";", false);
        while (stringtokenizer.hasMoreTokens()) {
            arraylist.add(stringtokenizer.nextToken());
        }
        return arraylist.toArray(new String[0]);
    }

    private String checkMobile(String mobile) {
        if (mobile != null && !"".equals(mobile)) {
            if (mobile.substring(0, 2).equals("86")) {
                mobile = mobile.substring(2);
            }
            if (mobile.length() - 11 != 0) {
                return "\u624b\u673a\u53f7\u7801\u7684\u957f\u5ea6\u4e0d\u5bf9.";
            }
            if (!mobile.substring(0, 2).equals("13") && !mobile.substring(0, 2).equals("15")) {
                return "\u624b\u673a\u53f7\u7801\u5e94\u8be5\u4ee513\u621615\u8d77\u59cb.";
            }
            return mobile;
        }
        return null;
    }

    private int getMsgLength(String msg) {
        byte bv = new Integer(msg.getBytes().length).byteValue();
        return bv & 0xFF;
    }

    public static Collection splitMsg(String msgContent) {
        ArrayList<String> msgBuffer = new ArrayList<String>();
        if (msgContent.length() <= 70) {
            msgBuffer.add(msgContent);
            return msgBuffer;
        }
        byte[] msgByte = msgContent.getBytes();
        int messlength = 140;
        int isEn = 1;
        int ePos = 0;
        int sPos = 0;
        boolean n = false;
        if (EMASendmsg.hasCN_Fmt(msgContent)) {
            isEn = 2;
        }
        while (ePos < msgByte.length) {
            int k = 0;
            while (k < messlength / isEn) {
                if (ePos >= msgByte.length) break;
                ePos = EMASendmsg.isChineseChr(msgByte[ePos]) ? (ePos += 2) : ++ePos;
                ++k;
            }
            byte[] byteBuf = new byte[ePos - sPos];
            System.arraycopy(msgByte, sPos, byteBuf, 0, ePos - sPos);
            sPos = ePos;
            msgBuffer.add(new String(byteBuf));
        }
        return msgBuffer;
    }

    private static boolean hasCN_Fmt(String msg) {
        byte[] bytes = msg.getBytes();
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] < 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isChineseChr(byte byteChr) {
        boolean isChineseChr = Integer.valueOf(String.valueOf(Character.forDigit(byteChr >>> 4 & 0xF, 16)), 16) >= 8;
        return isChineseChr;
    }

    public static void main(String[] args) {
    }
}

