/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.renderer.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.tiles.Attribute;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.awareness.TilesRequestContextFactoryAware;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.evaluator.AttributeEvaluatorFactoryAware;
import org.apache.tiles.renderer.AttributeRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseAttributeRenderer
implements AttributeRenderer,
TilesRequestContextFactoryAware,
TilesApplicationContextAware,
AttributeEvaluatorFactoryAware {
    private final Logger log = LoggerFactory.getLogger(AbstractBaseAttributeRenderer.class);
    protected TilesRequestContextFactory contextFactory;
    protected TilesApplicationContext applicationContext;
    protected AttributeEvaluatorFactory attributeEvaluatorFactory;

    @Override
    public void setRequestContextFactory(TilesRequestContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public void setApplicationContext(TilesApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setAttributeEvaluatorFactory(AttributeEvaluatorFactory attributeEvaluatorFactory) {
        this.attributeEvaluatorFactory = attributeEvaluatorFactory;
    }

    @Override
    public void render(Attribute attribute, TilesRequestContext request) throws IOException {
        if (!this.isPermitted(request, attribute.getRoles())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Access to attribute denied.  User not in role '" + attribute.getRoles() + "'");
            }
            return;
        }
        AttributeEvaluator evaluator = this.attributeEvaluatorFactory.getAttributeEvaluator(attribute);
        Object value = evaluator.evaluate(attribute, request);
        this.write(value, attribute, request);
    }

    public abstract void write(Object var1, Attribute var2, TilesRequestContext var3) throws IOException;

    protected TilesRequestContext getRequestContext(Object ... requestItems) {
        return this.contextFactory.createRequestContext(this.applicationContext, requestItems);
    }

    protected boolean isPermitted(TilesRequestContext request, Set<String> roles) {
        if (roles == null || roles.isEmpty()) {
            return true;
        }
        boolean retValue = false;
        Iterator<String> roleIt = roles.iterator();
        while (roleIt.hasNext() && !retValue) {
            retValue = request.isUserInRole(roleIt.next());
        }
        return retValue;
    }
}

