/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package org.apache.mina.example.udp;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/**
 * Class the represents a client connection using a JPanel
 *
 * @author The Apache MINA Project (dev@mina.apache.org)
 */
public class ClientPanel extends JPanel {

    private static final long serialVersionUID = 1L;

    private JTextField textField;

    public ClientPanel(String label) {
        super();

        setPreferredSize(MemoryMonitor.PANEL_SIZE);

        setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();

        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = GridBagConstraints.CENTER;

        c.gridwidth = GridBagConstraints.REMAINDER;
        add(new JLabel(label), c);

        c.gridwidth = 1;
        add(new JLabel("Memory Used : "));
        textField = new JTextField(10);
        textField.setEditable(false);
        add(textField, c);
    }

    public void updateTextField(final long val) {
        System.out.println("New value for textfield - " + val);
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                textField.setText(String.valueOf(val));
            }
        });
    }
}
