<%@page import="shopxx.util.FreemarkerUtils"%>
<%@page language="java" contentType="text/html; charset=utf-8" pageEncoding="UTF-8"%>
<%@page import="java.io.*"%>
<%@page import="java.sql.*"%>
<%@page import="org.apache.commons.lang.StringUtils"%>
<%@page import="org.apache.commons.io.FileUtils"%>
<%@page import="java.util.List"%>
<%@page import="java.util.HashMap"%>
<%@page import="java.util.Map"%>
<%@page import="java.util.regex.Pattern"%>
<%@page import="java.util.regex.Matcher"%>
<%@page import="org.codehaus.jackson.map.ObjectMapper"%>
<%@include file="common.jsp"%>
<%
	Boolean isAgreeAgreement = (Boolean) session.getAttribute("isAgreeAgreement");
	if (isAgreeAgreement == null || !isAgreeAgreement) {
		response.sendRedirect("index.jsp");
		return;
	}
	
	String databaseType = (String) session.getAttribute("databaseType");
	String databaseHost = (String) session.getAttribute("databaseHost");
	String databasePort = (String) session.getAttribute("databasePort");
	String databaseUsername = (String) session.getAttribute("databaseUsername");
	String databasePassword = (String) session.getAttribute("databasePassword");
	String databaseName = (String) session.getAttribute("databaseName");
	String isInitializeDemo = (String) session.getAttribute("isInitializeDemo");
	
	String status = "success";
	String message = "";
	String exception = "";
	
	if (StringUtils.isEmpty(databaseType)) {
		status = "error";
		message = "数据库类型不允许为空!";
	} else if (StringUtils.isEmpty(databaseHost)) {
		status = "error";
		message = "数据库主机不允许为空!";
	} else if (StringUtils.isEmpty(databasePort)) {
		status = "error";
		message = "数据库端口不允许为空!";
	} else if (StringUtils.isEmpty(databaseUsername)) {
		status = "error";
		message = "数据库用户名不允许为空!";
	} else if (StringUtils.isEmpty(databaseName)) {
		status = "error";
		message = "数据库名称不允许为空!";
	} else if (StringUtils.isEmpty(isInitializeDemo)) {
		status = "error";
		message = "初始化DEMO数据参数错误!";
	}
	
	if (status.equals("success")) {
		String jdbcUrl = null;
		File demoSqlFile = null;
		
		if (databaseType.equalsIgnoreCase("mysql")) {
			jdbcUrl = "jdbc:mysql://" + databaseHost + ":" + databasePort + "/" + databaseName + "?useUnicode=true&characterEncoding=" + DATABASE_ENCODING;
			demoSqlFile = new File(rootPath + "/install/data/mysql/demo.sql");
		} else if (databaseType.equalsIgnoreCase("sqlserver")) {
			jdbcUrl = "jdbc:sqlserver://" + databaseHost + ":" + databasePort + ";DatabaseName=" + databaseName;
			demoSqlFile = new File(rootPath + "/install/data/sqlserver/demo.sql");
		} else if (databaseType.equalsIgnoreCase("oracle")) {
			jdbcUrl = "jdbc:oracle:thin:@" + databaseHost + ":" + databasePort + ":" + databaseName;
			demoSqlFile = new File(rootPath + "/install/data/oracle/demo.sql");
		} else {
			status = "error";
			message = "参数错误!";
		}
		
		if (status.equals("success")) {
			Connection connection = null;
			Statement statement = null;
			ResultSet resultSet = null;
			
			String currentSQL = null;
			try {
				connection = DriverManager.getConnection(jdbcUrl, databaseUsername, databasePassword);
				connection.setAutoCommit(false);
				statement = connection.createStatement();
				if (demoSqlFile != null) {
					StringBuffer stringBuffer = new StringBuffer();
					List<String> demoSqlLineList = FileUtils.readLines(demoSqlFile, "UTF-8");
					for (String line : demoSqlLineList) {
						if (!StringUtils.startsWith(line, "--")) {
							stringBuffer.append(line + "\n");
						}
					}
					
					String demoSql = stringBuffer.toString();
					if (databaseType.equalsIgnoreCase("mysql")) {
						String tableCharset;
						if (StringUtils.equalsIgnoreCase(TABLE_CHARSET, "utf-8")) {
							tableCharset = "utf8";
						} else {
							tableCharset = TABLE_CHARSET;
						}
						
						String mysqlVersion = null;
						try {
							resultSet = statement.executeQuery("select version()");
							resultSet.next();
							mysqlVersion = resultSet.getString(1);
							resultSet.close();
						} catch (SQLException e0) {
							status = "error";
							message = "获取MySQL数据库版本失败!";
							exception = stackToString(e0);
							try {
								if(resultSet != null) {
									resultSet.close();
									resultSet = null;
								}
								if(statement != null) {
									statement.close();
									statement = null;
								}
								if(connection != null) {
									connection.close();
									connection = null;
								}
							} catch (SQLException e1) {
								status = "error";
								message = "获取MySQL数据库版本失败!";
								exception = stackToString(e1);
							}
						}

						String bit0 = null;
						String bit1 = null;
						if (mysqlVersion.compareTo("5.0") < 0) {
							bit0 = "'0'";
							bit1 = "'1'";
						} else {
							bit0 = "b'0'";
							bit1 = "b'1'";
						}
						
						Map<String, Object> model = new HashMap<String, Object>();
						model.put("tableCharset", tableCharset);
						model.put("bit0", bit0);
						model.put("bit1", bit1);
						model.put("base", request.getContextPath());
						model.put("demoImageUrl", DEMO_IMAGE_URL);
						demoSql = FreemarkerUtils.process(demoSql, model);
					}
					String[] initSqlArray = demoSql.split(";\n");
					for (String sql : initSqlArray) {
						if (!StringUtils.startsWith(sql, "--")) {
							if (StringUtils.isNotEmpty(sql)) {
								currentSQL = sql;
								statement.executeUpdate(sql);
							}
						}
					}
					connection.commit();
				} else {
					status = "error";
					message = "DEMO.SQL文件不存在!";
				}
			} catch (SQLException e) {
				status = "error";
				message = "JDBC执行错误!";
				exception = stackToString(e);
				if (currentSQL != null) {
					exception = "SQL: " + currentSQL + "<br />" + exception;
				}
			} catch (IOException e) {
				status = "error";
				message = "DEMO.SQL文件读取失败!";
				exception = stackToString(e);
			} finally {
				try {
					if(resultSet != null) {
						resultSet.close();
						resultSet = null;
					}
					if(statement != null) {
						statement.close();
						statement = null;
					}
					if(connection != null) {
						connection.close();
						connection = null;
					}
				} catch (SQLException e) {
					status = "error";
					message = "JDBC执行错误!";
					exception = stackToString(e);
				}
			}
		}
	}
	
	ObjectMapper mapper = new ObjectMapper();
	Map<String, String> jsonMap = new HashMap<String, String>();
	jsonMap.put("status", status);
	jsonMap.put("message", message);
	jsonMap.put("exception", exception);
	mapper.writeValue(response.getWriter(), jsonMap);
%>