define(function(require,exports, module) {
	var $ = require("jquery");
	//just for form
	var applyForm = function(elementId,formId,event,params){
		$("#"+elementId).bind(event,function(){
			submit(elementId,formId,params);
		});
	}
	
	var applyResource = function(elementId,formId,event,params){
		$("#"+elementId).bind(event,function(){
			var url = $("#"+formId).attr("action");
			getRemotingResource(url,params);
		});
	}
	
	function submit(elementId,formId,params){
		var sourceId =elementId;
		var element = $("#"+sourceId);
		if(element.length<0){
			alert("Element with id "+sourceId +" not found in the DOM");
		}
		form = $("#"+formId);
		if(form.length>0){
			formMethod =form.attr("method"); 
			method = formMethod?formMethod:'POST';
			url = form.attr("action");
			formData = convertToObject(form.serialize());
		}else{
			alert("Form with id "+formId +" not found in the DOM");
			return;
		}
		var data ={'ajaxSource':sourceId};
		if("button"==element.attr("type")){
			var name = element.attr("name");
			data[name]=name;
		}
		if(formData){
			$.extend(data,formData);
		}
		$.extend(data,params);
	    var p ={
	    	'url':url,
	    	'type':method,
	    	'data':data
	    };	
	    	doRequest(p);
	}
	
	var getRemotingResource = function(url,params){
		var data ={'ajaxSource':''};
		$.extend(data,params);
	    var p ={
	    	'url':url,
	    	'type':"GET",
	    	'data':data
	    };
	    doRequest(p);
	}
	
	function doRequest(args){
		$.ajax($.extend({
		beforeSend: function(jqXHR){
			jqXHR.setRequestHeader("Accept","text/html;type=ajax");
	    },	
		success:responseHandler	
		},args));
	}
	
	function responseHandler(response,textStatus,jqXHR){
		var redirectURL = jqXHR.getResponseHeader("Spring-Redirect-URL");
		var modalViewHeader = jqXHR.getResponseHeader("Spring-Modal-View");
		var modalView = modalViewHeader?true:false;
		if(redirectURL){
			if(modalView){
				alert("modalView not supported yet!");
				return;
			}
			window.location =window.location.protocol+"//"+window.location.host+ redirectURL;
			return;
		}
		//Extract and store all <script> elements from the response
		var scriptPattern = '(?:<script(.|[\n|\r])*?>)((\n|\r|.)*?)(?:<\/script>)';
		var extractedScriptNodes = [];
		var matchAll = new RegExp(scriptPattern, 'img');
		var matchOne = new RegExp(scriptPattern, 'im');
		var scriptNodes = response.match(matchAll);
		if (scriptNodes != null)
		{
			for (var i=0; i<scriptNodes.length; i++)
			{
				var script = (scriptNodes[i].match(matchOne) || ['','',''])[2];
				script = script.replace(/<!--/mg,'').replace(/\/\/-->/mg,'').replace(/<!\[CDATA\[(\/\/>)*/mg,'').replace(/(<!)*\]\]>/mg,'');
				extractedScriptNodes.push(script);
			}
		}
		// Remove scripts but don't remove scripts entirely (see SWF-1358) 
		response = response.replace(matchAll, '<script> // Original script removed to avoid re-execution </script>');
	//	var tmpSpan = $("<span id='ajaxResponse' style='display:none'></span>");
		var flowContentId = $(response).find(":first").parent().attr("id");
		var target = $("#"+flowContentId);
		target.parent().html(response);
		//$("#ajaxResponse").remove();
		for(var index in extractedScriptNodes){
			eval(extractedScriptNodes[index]);
		}
	}
	
	function convertToObject(source){
	  var elements = source.split("&");
	  var data = {};
	  for(var i in elements){
		  var kv = elements[i].split("=");
		  data[kv[0]]=decodeURIComponent(kv[1]);
	  }
	  return data;
	}
	
	exports.applyForm = applyForm;
	exports.submitForm = submit;
	exports.applyResource = applyResource;
	exports.getRemotingResource = getRemotingResource;
});
