﻿/*
** 歌词文件处理类
** 作者： 太阳光
** 版本： 1.0
** 修改时间： 2009-6-16
** 如果不懂AS的请不要修改,否则播放器无法显示歌词
*/
class Vnices.Lrc extends LoadVars {
	public var lrc:Object;
	public function Lrc(url:String) {
	}
	public static function Parse(lrcdata:String):Object {
		var lrctemp:Object = {stime:[], msg:[], ti:"曲目名称", ar:"艺术家", al:"专辑名称", by:"歌词制作"};
		var str:Array = lrcdata.split("\r\n");
		var s = str.length;
		var k = 0;
		for (var i = 0; i<s; i++) {
			var temp = Replace(str[i], "[", "");
			var my_array:Array = temp.split("]");
			var n = my_array.length;
			for (var j = 0; j<n-1; j++) {	
				if (my_array[j].indexOf("ti:") != -1) {
					lrctemp.ti = Replace(my_array[j], "ti:", "");
				} else if (my_array[j].indexOf("ar:") != -1) {
					lrctemp.ar = Replace(my_array[j], "ar:", "");
				} else if (my_array[j].indexOf("al:") != -1) {
					lrctemp.al = Replace(my_array[j], "al:", "");
				} else if (my_array[j].indexOf("by:") != -1) {
					lrctemp.by = Replace(my_array[j], "by:", "");
				} else {
					var times = Time2Ten(my_array[j]);
					var msgstr = my_array[n-1];
					lrctemp.stime[k] = times;
					lrctemp.msg[k] = msgstr;					
					k++;
				}
			}
		}
		lrctemp = Order(lrctemp);
		return lrctemp;
	}
	public static function Replace(target_str:String, replace_str:String, instead_str:String):String {
		var a:Array = target_str.split(replace_str);
		var n = a.length;
		target_str = "";
		for (var b = 0; b<n; b++) {
			if (b == 0) {
				target_str += a[b];
			} else {
				target_str += instead_str+a[b];
			}
		}
		return target_str;
	}
	public static function Time2Ten(str:String):Number {
		str=str.split(".")[0];
		var num = 0;
		var temp:Array = str.split(":");
		var n = temp.length;
		for (var i = 0; i<n; i++) {
			num += temp[i]*NxN(60, (n-(i+1)));
		}
		return num;
	}
	public static function NxN(num:Number, n:Number):Number {
		var temp:Number = 1;
		for (var i = 0; i<n; i++) {
			temp *= num;
		}
		return temp;
	}
	public static function Order(lrc:Object):Object {
		var a = lrc.stime;
		var b = lrc.msg;
		var n = a.length;
		for (var i = 0; i<n; i++) {
			var min = i;
			for (var j = i+1; j<n+1; j++) {
				if (a[min]>a[j]) {
					min = j;
				}
			}
			var temp = a[i];
			a[i] = a[min];
			a[min] = temp;
			var msgtemp = b[i];
			b[i] = b[min];
			b[min] = msgtemp;
		}
		return lrc;
	}
}
