Class AutoPaging
'*************************************************************
'目　　　的：自动将长文章分页输出
'属　　　性：Splitchar：分页搜索标志。以一维数组方式输入，默认array("<br/>","<BR>","<Br>","<bR>")
'　　　　　　PagingString：要进行分页的字符串
'　　　　　　PagingSize：分页长度
'　　　　　　CurrentPage：当前输出页码
'　　　　　　DefaultRange：默认搜索分页标志范围
'　　　　　　StepRange：搜索步长
'方　　　法：getTotalPageCount()：返回总分页数
'　　　　　　OutputString：输出当前分页内容
'*************************************************************
public Splitchar'分页搜索标志，数组
public PagingString'分页字符串
public PagingSize'页面最大长度
public CurrentPage'当前页码
public DefaultRange'默认起始范围
public StepRange'步长
private Truncate'2维数组m，n。m0=页码、m1=起始字符、m2=结束字符，n=总页数
private intStart'开始位置
private intLen'截取长度
private tmpStr
private Range'起始范围
private Sub Class_Initialize()
  Splitchar=array("<br/>","<BR>","<Br>","<bR>")
  PagingSize = 2000
  DefaultRange=1
  StepRange = 1
  intStart = 0
  intEnd = 0
End Sub
public Function getTotalPageCount()'返回总页数
  if len(PagingString) mod PagingSize > 0 then
    getTotalPageCount = int(len(PagingString) / PagingSize) + 1
  else
    getTotalPageCount = len(PagingString) / PagingSize
  end if
End Function
public Sub OutputString
  redim Truncate(2,getTotalPageCount())
  For tmpI = 0 to getTotalPageCount()
    Truncate(0,tmpI)=tmpI
  Next
  For tmpI = 1 to ubound(Truncate,2)
    if Truncate(0,tmpI) = 1 then
      Truncate(1,tmpI) = 1
    else
      Truncate(1,tmpI)=Truncate(1,tmpI - 1) + Truncate(2,tmpI - 1)
    end if
    Range = DefaultRange
    Do while Range < PagingSize
      tmpStr=right(mid(PagingString,Truncate(1,tmpI),PagingSize),Range)
      For tmpInt=0 to ubound(Splitchar)
        if instr(1,tmpStr,Splitchar(tmpInt)) > 0 then
          Truncate(2,tmpI) = (PagingSize - (len(tmpStr) - instr(1,tmpStr,Splitchar(tmpInt)))) - 1
          exit do
        end if
      Next
      Range = Range + StepRange
    Loop
    if tmpI = Cint(CurrentPage) then
      intStart = Truncate(1,tmpI)
      intLen = Truncate(2,tmpI)
    end if
  next
  if Cint(CurrentPage) = getTotalPageCount() then
    response.write(mid(PagingString,intStart))'如果当前分页为最后一页，则取剩下的所有字符
  else
    response.write(mid(PagingString,intStart,intLen))
  end if
End Sub
End Class
调用示例
set paging=new autopaging
with paging
  .pagingstring=Content　　'此为从数据库取得数据
  .pagingsize=2000
  .splitchar=array("<br/>","<BR>","<Br>","<bR>","<p>","<P>")
end with
TotalPage = paging.gettotalpagecount()
Page=request("page")
if Page="" or Cint(Page)<1 then
  Page=1
else
  if Cint(Page) > TotalPage then
    Page = TotalPage
  else
    if CheckValid(Page)=false or not isnumeric(Page) then
      response.write("页码参数非法，请返回！")
      response.end
    end if
  end if
end if
paging.currentpage=Page
paging.outputstring
set paging=nothing
分页页码部分：
<%
if TotalPage > 1 then
  For i=1 to TotalPage
    if i = Cint(Page) then
      response.write("<b>" & i & "</b>　")
    else
      response.write("<a href=readnews.asp?newsid=" & NewsID & "&bigclassid=" & BigClassID & "&smallclassid=" & SmallClassid & "&specialid=" & SpecialID & "&page=" & i & ">[" & i & "]</a>　")
    end if
  Next
end if
%>
应用示例
http://www.chceg.com/readnews.asp?newsid=227&bigclassid=9&smallclassid=36&specialid=5
缺陷，输出内容中不可包含table标签。