﻿CREATE TABLE IF NOT EXISTS `des_action_log` (
  `id` int(11) NOT NULL COMMENT '主键',
  `user_id` int(11) NOT NULL COMMENT '用户ID',
  `from` text NOT NULL COMMENT 'IP',
  `action` int(11) NOT NULL COMMENT '动作类型',
  `name` int(11) NOT NULL COMMENT '名称',
  `create_time` int(11) NOT NULL COMMENT '操作时间'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='系统变更日志';


CREATE TABLE IF NOT EXISTS `des_action_log` (
  `id` int(11) NOT NULL COMMENT '主键',
  `user_id` int(11) NOT NULL COMMENT '用户ID',
  `from` text NOT NULL COMMENT 'IP',
  `action` int(11) NOT NULL COMMENT '动作类型',
  `name` int(11) NOT NULL COMMENT '名称',
  `create_time` int(11) NOT NULL COMMENT '操作时间'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='系统变更日志';


CREATE TABLE IF NOT EXISTS `des_access` (
  `role_id` smallint(6) unsigned NOT NULL,
  `node_id` smallint(6) unsigned NOT NULL,
  `level` tinyint(1) NOT NULL,
  `pid` smallint(6) NOT NULL,
  `module` varchar(50) DEFAULT NULL,
  KEY `groupId` (`role_id`),
  KEY `nodeId` (`node_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



CREATE TABLE IF NOT EXISTS `des_tags` (
  
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(255) NOT NULL,

  `type` tinyint(4) NOT NULL,

  `hot` tinyint(4) NOT NULL COMMENT '热度，查看次数',

  `bits` int(11) NOT NULL COMMENT '出现次数',

  PRIMARY KEY (`id`)

) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='标签';

CREATE TABLE IF NOT EXISTS `des_album` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cate_id` int(11) NOT NULL,
  `path` varchar(255) NOT NULL,
  `title` varchar(125) NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `create_time` int(11) NOT NULL,
  `update_time` int(11) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='相册';


CREATE TABLE IF NOT EXISTS `des_category` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `parent_id` mediumint(9) NOT NULL COMMENT '上级id',
  `sort` mediumint(9) NOT NULL COMMENT '排序',
  `status` enum('-1','0','1') NOT NULL COMMENT '状态{-1：已删除，0：不在常规排序中显示，1：正常}',
  `alias` varchar(64) NOT NULL,
  `name` varchar(125) NOT NULL COMMENT '分类名称',
  `keyword` varchar(255) NOT NULL COMMENT '关键字',
  `description` varchar(500) NOT NULL COMMENT '描述',
  `url` varchar(255) NOT NULL COMMENT '链接',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标',
  `view` varchar(255) DEFAULT NULL,
  `create_time` int(11) NOT NULL,
  `update_time` int(11) NOT NULL,
  `app` tinyint(4) NOT NULL DEFAULT '0',
  `page` tinyint(4) NOT NULL DEFAULT '12',
  `hits` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ;


INSERT INTO `des_category` (`id`, `parent_id`, `sort`, `status`, `alias`, `name`, `keyword`, `description`, `url`, `icon`, `view`, `create_time`, `update_time`) VALUES
(1, 0, 0, '1', 'content', '文章', '文章', '文章', '', '', '', 0, 0),
(2, 0, 0, '1', 'album', '相册', '相册', '相册', '', '', '', 0, 0),
(3, 0, 0, '1', 'links', '链接', '链接', '链接', '', '', '', 0, 0),
(4, 1, 994, '1', 'default', '默认分类', '4564', '   456', '', '/Data/Uploads/Picture/20150722/1437579111.jpg', '', 1448960770, 0),
(5, 2, 997, '1', '16848', '默认相册', '', ' ', '', '/Data/Uploads/Picture/20150224/1424769274.jpg', '', 1437057497, 0);



CREATE TABLE IF NOT EXISTS `des_center` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL COMMENT '类型',
  `cate_id` int(11) NOT NULL COMMENT '分类id',
  `user_id` int(11) NOT NULL,
  `thumb` varchar(525) NOT NULL,
  `title` varchar(255) NOT NULL,
  `center` text NOT NULL,
  `view` varchar(125) NOT NULL COMMENT '模版',
  `comm` tinyint(4) NOT NULL,
  `tags` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `create_time` int(11) NOT NULL,
  `update_time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='内容中心';



INSERT INTO `des_center` (`id`, `type`, `cate_id`, `user_id`, `thumb`, `title`, `center`, `view`, `comm`, `tags`, `description`, `status`, `create_time`, `update_time`) VALUES
(3, 0, 4, 1, '', '浅析Android系统架构及内核', 'Android是Google公司开发的基于Linux平台的开源手机操作系统,它包括操作系统、中间件、用户界面和应用程序,而且不存在任何以往阻碍移动产业创新的专利权障碍,并由Google公司于2007年11月5日正式发布。同时,Google公司组建了一个开放手机联盟,这个联盟由中国移动、摩托罗拉、高通、宏达电和T-Mobile等在内的全球30多家技术和无线应用的领军企业组成,Google通过与运营商、设备制造商、开发商和其他有关各方结成深层次的合作伙伴关系,希望借助建立标准化、开放式的移动电话软件平台,在移动产业内形成一个开放式的生态系统;可预见地,生产和使用基于Android系统的嵌入式手持移动设备将是未来的发展趋势,对相应软件的需求量也将日趋增长,因此对Android系统内部作一个完整和深入的分析,对基于Android平台的软件移植和开发是很有益处的。 ', '', 0, '', '', 1, 1403939790, 1403939790),
(4, 0, 4, 0, '', 'javascript Array 对象', 'Bootstrap中文网联合又拍云存储共同推出了开放CDN服务，我们对广泛的前端开源库提供了稳定的存储和带宽的支持，例如Bootstrap、jQuery等', '44455', 0, 'admin', '4545', 1, 1424938647, 0),
(5, 1, 4, 0, '', 'html DOM document对象getElementById()方法', '讨论模板的显式实例化之前，先弄清楚什么是模板的实例化。\n\n模板的实例化 : 指的是用具体的类型替代了模板参数的一个过程。这个过程的产物是一个模板的实例。\n\n另外，只要在代码中正确使用模板，编译器会自动引发一个模板的实例化过程，这叫做隐式的（implicit）实例化。\n\n例如：', '44455', 1, 'admin', '4545', 1, 1424939383, 0),
(6, 1, 4, 0, '', 'C++模板显式实例化', '这套工具让你在使用jQuery UI 控件时也能充分利用Bootstrap的样式，而且不会出现样式不统一的现象，Bootstrap和jQuery UI可以完美融合在一起了！', '44455', 3, 'admin', '4545', 1, 1424939392, 0),
(7, 1, 4, 0, '', 'ThinkPHP3.2.3新特性之：数据库设置', '讨论模板的显式实例化之前，先弄清楚什么是模板的实例化。\n\n模板的实例化 : 指的是用具体的类型替代了模板参数的一个过程。这个过程的产物是一个模板的实例。\n\n另外，只要在代码中正确使用模板，编译器会自动引发一个模板的实例化过程，这叫做隐式的（implicit）实例化。\n\n例如：', '44455', 3, 'admin', '4545', 1, 1424941165, 0),
(1, 1, 4, 1, '', 'Bootstrap相关优质项目推荐00', 'Bootstrap相关优质项目推荐，这些项目或者是对Bootstrap进行了有益的补充，或者是基于Bootstrap开发的这些项目或者是对Bootstrap进行了有益的补充，或者是基于Bootstrap开发的', '11111', 1, 'admin', '111110', 1, 1436883049, 0),
(2, 1, 4, 1, '/Data/Uploads/Picture/20150722/1437579219.jpg', '模特潜规则 容貌非天成', '<span style="color: rgb(51, 51, 51); font-family: Simsun, ''Microsoft YaHei'', Tahoma, Verdana, ''Arial Unicode MS'', Mingliu, Arial, Helvetica; font-size: 14px; line-height: 25px;">容貌天成，风韵难有的时代已经一去不复返。当今这个时代，你在娱乐圈能找到几个真美女?硕果仅存的天然美女明星大多上了一定的年纪，让人不禁感叹：人工美占据了成了娱乐圈的主流色彩。&nbsp;</span><br style="color: rgb(51, 51, 51); font-family: Simsun, ''Microsoft YaHei'', Tahoma, Verdana, ''Arial Unicode MS'', Mingliu, Arial, Helvetica; font-size: 14px; line-height: 25px;" /><br style="color: rgb(51, 51, 51); font-family: Simsun, ''Microsoft YaHei'', Tahoma, Verdana, ''Arial Unicode MS'', Mingliu, Arial, Helvetica; font-size: 14px; line-height: 25px;" /><img alt="" src="http://www.v41.cn/uploads/allimg/121113/15562H1O-0.jpg" style="border: medium none; margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Simsun, ''Microsoft YaHei'', Tahoma, Verdana, ''Arial Unicode MS'', Mingliu, Arial, Helvetica; font-size: 14px; line-height: 25px;" /><br />', '', 1, '模特,潜规则', '容貌天成，风韵难有的时代已经一去不复返。当今这个时代，你在娱乐圈能找到几个真美女?硕果仅存的天然美女明星大多上了一定的年纪，让人不禁感叹：人工美占据了成了娱乐圈的主流色彩。 ', 1, 1437582824, 0);



CREATE TABLE IF NOT EXISTS `des_center_attachment` (
  `center_id` int(11) NOT NULL,
  `link` text NOT NULL,
  PRIMARY KEY (`center_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='附件';



CREATE TABLE IF NOT EXISTS `des_center_count` (
  `center_id` int(11) NOT NULL,
  `foot` int(11) NOT NULL DEFAULT '1' COMMENT '踩',
  `praise` int(11) NOT NULL DEFAULT '1' COMMENT '赞',
  `Concern` int(11) NOT NULL DEFAULT '1' COMMENT '关注',
  `comments` int(11) NOT NULL DEFAULT '0' COMMENT '评论'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='统计';


INSERT INTO `des_center_count` (`center_id`, `foot`, `praise`, `Concern`, `comments`) VALUES
(1, 1, 5, 1, 0),
(2, 1, 9, 1, 0),
(3, 1, 1, 1, 0),
(4, 1, 12, 1, 0),
(5, 1, 36, 1, 0),
(6, 1, 3, 1, 0),
(7, 1, 7, 1, 0);


CREATE TABLE IF NOT EXISTS `des_center_hits` (
  `center_id` int(11) NOT NULL,
  `hits` int(11) NOT NULL DEFAULT '1',
  `today_hits` int(11) NOT NULL DEFAULT '1',
  `week_hits` int(11) NOT NULL DEFAULT '1',
  `month_hits` int(11) NOT NULL DEFAULT '1',
  `yesterday_hits` int(11) NOT NULL DEFAULT '1',
  `last_week_hits` int(11) NOT NULL DEFAULT '1',
  `last_month_hits` int(11) NOT NULL DEFAULT '1',
  KEY `art_id` (`center_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


INSERT INTO `des_center_hits` (`center_id`, `hits`, `today_hits`, `week_hits`, `month_hits`, `yesterday_hits`, `last_week_hits`, `last_month_hits`) VALUES
(1, 24, 1, 1, 1, 1, 1, 1),
(2, 3, 1, 1, 1, 1, 1, 1),
(3, 4, 1, 1, 1, 1, 1, 1),
(4, 6, 1, 1, 1, 1, 1, 1),
(5, 1, 1, 1, 1, 1, 1, 1),
(6, 1, 1, 1, 1, 1, 1, 1),
(7, 1, 1, 1, 1, 1, 1, 1);



CREATE TABLE IF NOT EXISTS `des_center_limit` (
  `center_id` int(11) NOT NULL,
  `type` varchar(75) NOT NULL COMMENT '类型：all,所有用户.users,注册用户.vip,会员.group,用户组.money,金额.score,积分.piece,金币',
  `value` text NOT NULL COMMENT '值',
  UNIQUE KEY `art_id` (`center_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='浏览权限';



INSERT INTO `des_center_limit` (`center_id`, `type`, `value`) VALUES
(2, 'all', ''),
(1, 'all', ''),
(3, 'all', ''),
(4, 'all', ''),
(5, 'all', ''),
(6, 'all', ''),
(7, 'all', '');



CREATE TABLE IF NOT EXISTS `des_center_setting` (
  `key` varchar(125) CHARACTER SET latin1 NOT NULL,
  `value` text CHARACTER SET latin1 NOT NULL,
  UNIQUE KEY `key` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `des_center_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `name` varchar(125) NOT NULL COMMENT '名词',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='内容类型';


INSERT INTO `des_center_type` (`id`, `name`) VALUES
(1, '普通'),
(2, '头条'),
(3, '推荐'),
(4, '置顶');


CREATE TABLE IF NOT EXISTS `des_city` (
  `serialId` int(3) NOT NULL AUTO_INCREMENT,
  `cityId` varchar(20) CHARACTER SET gbk DEFAULT NULL,
  `cityName` varchar(20) CHARACTER SET gbk DEFAULT NULL,
  `cityUpId` varchar(20) CHARACTER SET gbk DEFAULT NULL,
  `cityUpIdNum` int(11) DEFAULT NULL,
  `cityPath` varchar(100) CHARACTER SET gbk DEFAULT NULL,
  `cityType` varchar(20) CHARACTER SET gbk DEFAULT NULL,
  `cityTypeNum` int(11) DEFAULT NULL,
  `shortName` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  `spell` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  `areaId` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  `postCode` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  PRIMARY KEY (`serialId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;


INSERT INTO `des_city` (`serialId`, `cityId`, `cityName`, `cityUpId`, `cityUpIdNum`, `cityPath`, `cityType`, `cityTypeNum`, `shortName`, `spell`, `areaId`, `postCode`) VALUES
(1, '001001001', '东城', '001001', 1, '中国/北京/东城', '区', 3, 'dc', 'dongcheng', '010', '100010'),
(2, '001001002', '西城', '001001', 1, '中国/北京/西城', '区', 3, 'xc', 'xicheng', '010', '100032'),
(3, '001001003', '崇文', '001001', 1, '中国/北京/崇文', '区', 3, 'cw', 'chongwen', '010', '100061'),
(4, '001001004', '宣武', '001001', 1, '中国/北京/宣武', '区', 3, 'xw', 'xuanwu', '010', '100054'),
(5, '001001005', '朝阳', '001001', 1, '中国/北京/朝阳', '区', 3, 'cy', 'chaoyang', '010', '100020'),
(6, '001001006', '丰台', '001001', 1, '中国/北京/丰台', '区', 3, 'ft', 'fengtai', '010', '100071'),
(7, '001001007', '石景山', '001001', 1, '中国/北京/石景山', '区', 3, 'sjs', 'shijingshan', '010', '100043'),
(8, '001001008', '海淀', '001001', 1, '中国/北京/海淀3', '区', 3, 'hd', 'haidian', '010', '100080'),
(9, '001001009', '门头沟', '001001', 1, '中国/北京/门头沟', '区', 3, 'mtg', 'mentougou', '010', '102300'),
(10, '001001010', '房山', '001001', 1, '中国/北京/房山', '区', 3, 'fs', 'fangshan', '010', '102400'),
(11, '001001011', '通州', '001001', 1, '中国/北京/通州', '区', 3, 'tz', 'tongzhou', '010', '101149'),
(12, '001001012', '顺义', '001001', 1, '中国/北京/顺义', '区', 3, 'sy', 'shunyi', '010', '101300'),
(13, '001001013', '昌平', '001001', 1, '中国/北京/昌平', '区', 3, 'cp', 'changping', '010', '102200'),
(14, '001001014', '大兴', '001001', 1, '中国/北京/大兴', '区', 3, 'dx', 'daxing', '010', '102600'),
(15, '001001015', '怀柔', '001001', 1, '中国/北京/怀柔', '区', 3, 'hr', 'huairou', '010', '101400'),
(16, '001001016', '平谷', '001001', 1, '中国/北京/平谷', '区', 3, 'pg', 'pinggu', '010', '101200'),
(17, '001001017', '延庆', '001001', 1, '中国/北京/延庆', '县', 3, 'yq', 'yanqing', '010', '102100'),
(18, '001001018', '密云', '001001', 1, '中国/北京/密云', '县', 3, 'my', 'miyun', '010', '101500'),
(19, '001003001', '石家庄', '001003', 3, '中国/河北/石家庄', '市', 3, 'sjz', 'shijiazhuan', '0311', '050011'),
(20, '001003002', '唐山', '001003', 3, '中国/河北/唐山', '市', 3, 'ts', 'tangshan', '0315', '063006'),
(21, '001003003', '秦皇岛', '001003', 3, '中国/河北/秦皇岛', '市', 3, 'qhd', 'qinhuangdao', '0335', '066000'),
(22, '001003004', '邯郸', '001003', 3, '中国/河北/邯郸', '市', 3, 'hd', 'handan', '0310', '056002'),
(23, '001003005', '邢台', '001003', 3, '中国/河北/邢台', '市', 3, 'xt', 'xingtai', '0319', '054001'),
(24, '001003006', '保定', '001003', 3, '中国/河北/保定', '市', 3, 'bd', 'baoding', '0312', '071052'),
(25, '001003007', '张家口', '001003', 3, '中国/河北/张家口', '市', 3, 'zjk', 'zhangjiakou', '0313', '075061'),
(26, '001003008', '承德', '001003', 3, '中国/河北/承德', '市', 3, 'cd', 'chengde', '0314', '067000'),
(27, '001003009', '沧州', '001003', 3, '中国/河北/沧州', '市', 3, 'cz', 'cangzhou', '0317', '061001'),
(28, '001003010', '廊坊', '001003', 3, '中国/河北/廊坊', '市', 3, 'lf', 'langfang', '0316', '065000'),
(29, '001003011', '衡水', '001003', 3, '中国/河北/衡水', '市', 3, 'hs', 'hengshui', '0318', '053000'),
(30, '001004001', '太原', '001004', 4, '中国/山西/太原', '市', 3, 'ty', 'taiyuan', '0351', '030082'),
(31, '001004002', '大同', '001004', 4, '中国/山西/大同', '市', 3, 'dt', 'datong', '0352', '037008'),
(32, '001004003', '阳泉', '001004', 4, '中国/山西/阳泉', '市', 3, 'yq', 'yangquan', '0353', '045000'),
(33, '001004004', '长治', '001004', 4, '中国/山西/长治', '市', 3, 'cz', 'changzhi', '0355', '046000'),
(34, '001004005', '晋城', '001004', 4, '中国/山西/晋城', '市', 3, 'jc', 'jincheng', '0356', '048000'),
(35, '001004006', '朔州', '001004', 4, '中国/山西/朔州', '市', 3, 'sz', 'shuozhou', '0349', '036000'),
(36, '001004007', '晋中', '001004', 4, '中国/山西/晋中', '市', 3, 'jz', 'jinzhong', '0354', '030600'),
(37, '001004008', '运城', '001004', 4, '中国/山西/运城', '市', 3, 'yc', 'yuncheng', '0359', '044000'),
(38, '001004009', '忻州', '001004', 4, '中国/山西/忻州', '市', 3, 'xz', 'xinzhou', '0350', '034000'),
(39, '001004010', '临汾', '001004', 4, '中国/山西/临汾', '市', 3, 'lf', 'linfen', '0357', '041000'),
(40, '001004011', '吕梁地', '001004', 4, '中国/山西/吕梁地', '区', 3, 'lld', 'lvliangdi', '0358', '033000'),
(41, '001005001', '呼和浩特', '001005', 5, '中国/内蒙古/呼和浩特', '市', 3, 'hhht', 'huhehaote', '0471', '010020'),
(42, '001005002', '包头', '001005', 5, '中国/内蒙古/包头', '市', 3, 'bt', 'baotou', '0472', '014025'),
(43, '001005003', '乌海', '001005', 5, '中国/内蒙古/乌海', '市', 3, 'wh', 'wuhai', '0473', '016000'),
(44, '001005004', '赤峰', '001005', 5, '中国/内蒙古/赤峰', '市', 3, 'cf', 'chifeng', '0476', '024000'),
(45, '001005005', '通辽', '001005', 5, '中国/内蒙古/通辽', '市', 3, 'tl', 'tongliao', '0475', '028000'),
(46, '001005006', '鄂尔多斯', '001005', 5, '中国/内蒙古/鄂尔多斯', '市', 3, 'eeds', 'eerduosi', '0477', '017004'),
(47, '001005007', '呼伦贝尔', '001005', 5, '中国/内蒙古/呼伦贝尔', '市', 3, 'hlbe', 'hulunbeier', '0470', '021008'),
(48, '001005008', '乌兰察布', '001005', 5, '中国/内蒙古/乌兰察布', '盟', 3, 'wlcbm', 'wulanchabum', '0474', '012000'),
(49, '001005009', '锡林郭勒', '001005', 5, '中国/内蒙古/锡林郭勒', '盟', 3, 'xlglm', 'xilinguolem', '0479', '026021'),
(50, '001005010', '巴彦淖尔', '001005', 5, '中国/内蒙古/巴彦淖尔', '盟', 3, 'bynem', 'bayannaoerm', '0478', '015001'),
(51, '001005011', '阿拉善', '001005', 5, '中国/内蒙古/阿拉善', '盟', 3, 'alsm', 'alashanmeng', '0483', '750306'),
(52, '001005012', '兴安', '001005', 5, '中国/内蒙古/兴安', '盟', 3, 'xam', 'xinganmeng', '0482', '137401'),
(53, '001006001', '沈阳', '001006', 6, '中国/辽宁/沈阳', '市', 3, 'sy', 'shenyang', '024', '110013'),
(54, '001006002', '大连', '001006', 6, '中国/辽宁/大连', '市', 3, 'dl', 'dalian', '0411', '116011'),
(55, '001006003', '鞍山', '001006', 6, '中国/辽宁/鞍山', '市', 3, 'as', 'anshan', '0412', '114001'),
(56, '001006004', '抚顺', '001006', 6, '中国/辽宁/抚顺', '市', 3, 'fs', 'fushun', '0413', '113008'),
(57, '001006005', '本溪', '001006', 6, '中国/辽宁/本溪', '市', 3, 'bx', 'benxi', '0414', '117000'),
(58, '001006006', '丹东', '001006', 6, '中国/辽宁/丹东', '市', 3, 'dd', 'dandong', '0415', '118000'),
(59, '001006007', '锦州', '001006', 6, '中国/辽宁/锦州', '市', 3, 'jz', 'jinzhou', '0416', '121000'),
(60, '001006008', '葫芦岛', '001006', 6, '中国/辽宁/葫芦岛', '市', 3, 'hld', 'huludao', '0429', '125000'),
(61, '001006009', '营口', '001006', 6, '中国/辽宁/营口', '市', 3, 'yk', 'yingkou', '0417', '115003'),
(62, '001006010', '盘锦', '001006', 6, '中国/辽宁/盘锦', '市', 3, 'pj', 'panjin', '0427', '124010'),
(63, '001006011', '阜新', '001006', 6, '中国/辽宁/阜新', '市', 3, 'fx', 'fuxin', '0418', '123000'),
(64, '001006012', '辽阳', '001006', 6, '中国/辽宁/辽阳', '市', 3, 'ly', 'liaoyang', '0419', '111000'),
(65, '001006013', '铁岭', '001006', 6, '中国/辽宁/铁岭', '市', 3, 'tl', 'tieling', '0410', '112000'),
(66, '001006014', '朝阳', '001006', 6, '中国/辽宁/朝阳', '市', 3, 'cy', 'chaoyang', '0421', '122000'),
(67, '001007001', '长春', '001007', 7, '中国/吉林/长春', '市', 3, 'cc', 'changchun', '0431', '130061'),
(68, '001007002', '吉林', '001007', 7, '中国/吉林/吉林', '市', 3, 'jl', 'jilin', '0432', '132011'),
(69, '001007003', '四平', '001007', 7, '中国/吉林/四平', '市', 3, 'sp', 'siping', '0434', '136000'),
(70, '001007004', '辽源', '001007', 7, '中国/吉林/辽源', '市', 3, 'ly', 'liaoyuan', '0437', '136200'),
(71, '001007005', '通化', '001007', 7, '中国/吉林/通化', '市', 3, 'th', 'tonghua', '0435', '134001'),
(72, '001007006', '白山', '001007', 7, '中国/吉林/白山', '市', 3, 'bs', 'baishan', '0439', '134300'),
(73, '001007007', '松原', '001007', 7, '中国/吉林/松原', '市', 3, 'sy', 'songyuan', '0438', '138000'),
(74, '001007008', '白城', '001007', 7, '中国/吉林/白城', '市', 3, 'bc', 'baicheng', '0436', '137000'),
(75, '001007009', '延边', '001007', 7, '中国/吉林/延边', '州', 3, 'yb', 'yanbian', '0433', '133000'),
(76, '001008001', '哈尔滨', '001008', 8, '中国/黑龙江/哈尔滨', '市', 3, 'heb', 'haerbin', '0451', '150010'),
(77, '001008002', '齐齐哈尔', '001008', 8, '中国/黑龙江/齐齐哈尔', '市', 3, 'qqhe', 'qiqihaer', '0452', '161005'),
(78, '001008003', '鹤岗', '001008', 8, '中国/黑龙江/鹤岗', '市', 3, 'hg', 'hegang', '0468', '154100'),
(79, '001008004', '双鸭山', '001008', 8, '中国/黑龙江/双鸭山', '市', 3, 'sys', 'shuangyasha', '0469', '155100'),
(80, '001008005', '鸡西', '001008', 8, '中国/黑龙江/鸡西', '市', 3, 'jx', 'jixi', '0467', '158100'),
(81, '001008006', '大庆', '001008', 8, '中国/黑龙江/大庆', '市', 3, 'dq', 'daqing', '0459', '163311'),
(82, '001008007', '伊春', '001008', 8, '中国/黑龙江/伊春', '市', 3, 'yc', 'yichun', '0458', '153000'),
(83, '001008008', '牡丹江', '001008', 8, '中国/黑龙江/牡丹江', '市', 3, 'mdj', 'mudanjiang', '0453', '157000'),
(84, '001008009', '佳木斯', '001008', 8, '中国/黑龙江/佳木斯', '市', 3, 'jms', 'jiamusi', '0454', '154002'),
(85, '001008010', '七台河', '001008', 8, '中国/黑龙江/七台河', '市', 3, 'qth', 'qitaihe', '0464', '154600'),
(86, '001008011', '黑河', '001008', 8, '中国/黑龙江/黑河', '市', 3, 'hh', 'heihe', '0456', '164300'),
(87, '001008012', '绥化', '001008', 8, '中国/黑龙江/绥化', '市', 3, 'sh', 'suihua', '0455', '152000'),
(88, '001008013', '大兴安岭', '001008', 8, '中国/黑龙江/大兴安岭', '地区', 3, 'dxald', 'daxinganlin', '0457', '165000'),
(89, '001010001', '南京', '001010', 10, '中国/江苏/南京', '市', 3, 'nj', 'nanjing', '025', '210008'),
(90, '001010002', '徐州', '001010', 10, '中国/江苏/徐州', '市', 3, 'xz', 'xuzhou', '0516', '221003'),
(91, '001010003', '连云港', '001010', 10, '中国/江苏/连云港', '市', 3, 'lyg', 'lianyungang', '0518', '222002'),
(92, '001010004', '淮安', '001010', 10, '中国/江苏/淮安', '市', 3, 'ha', 'huaian', '0517', '223001'),
(93, '001010005', '宿迁', '001010', 10, '中国/江苏/宿迁', '市', 3, 'sq', 'suqian', '0527', '223800'),
(94, '001010006', '盐城', '001010', 10, '中国/江苏/盐城', '市', 3, 'yc', 'yancheng', '0515', '224005'),
(95, '001010007', '扬州', '001010', 10, '中国/江苏/扬州', '市', 3, 'yz', 'yangzhou', '0514', '225002'),
(96, '001010008', '泰州', '001010', 10, '中国/江苏/泰州', '市', 3, 'tz', 'taizhou', '0523', '225300'),
(97, '001010009', '南通', '001010', 10, '中国/江苏/南通', '市', 3, 'nt', 'nantong', '0513', '226001'),
(98, '001010010', '镇江', '001010', 10, '中国/江苏/镇江', '市', 3, 'zj', 'zhenjiang', '0511', '212001'),
(99, '001010011', '常州', '001010', 10, '中国/江苏/常州', '市', 3, 'cz', 'changzhou', '0519', '213003'),
(100, '001010012', '无锡', '001010', 10, '中国/江苏/无锡', '市', 3, 'wx', 'wuxi', '0510', '214001'),
(101, '001010013', '苏州', '001010', 10, '中国/江苏/苏州', '市', 3, 'sz', 'suzhou', '0512', '215002'),
(102, '001011001', '杭州', '001011', 11, '中国/浙江/杭州', '市', 3, 'hz', 'hangzhou', '0571', '310026'),
(103, '001011002', '宁波', '001011', 11, '中国/浙江/宁波', '市', 3, 'nb', 'ningbo', '0574', '315000'),
(104, '001011003', '温州', '001011', 11, '中国/浙江/温州', '市', 3, 'wz', 'wenzhou', '0577', '325000'),
(105, '001011004', '嘉兴', '001011', 11, '中国/浙江/嘉兴', '市', 3, 'jx', 'jiaxing', '0573', '314000'),
(106, '001011005', '湖州', '001011', 11, '中国/浙江/湖州', '市', 3, 'hz', 'huzhou', '0572', '313000'),
(107, '001011006', '绍兴', '001011', 11, '中国/浙江/绍兴', '市', 3, 'sx', 'shaoxing', '0575', '312000'),
(108, '001011007', '金华', '001011', 11, '中国/浙江/金华', '市', 3, 'jh', 'jinhua', '0579', '321000'),
(109, '001011008', '衢州', '001011', 11, '中国/浙江/衢州', '市', 3, 'xz', 'xuzhou', '0570', '324002'),
(110, '001011009', '舟山', '001011', 11, '中国/浙江/舟山', '市', 3, 'zs', 'zhoushan', '0580', '316000'),
(111, '001011010', '台州', '001011', 11, '中国/浙江/台州', '市', 3, 'tz', 'taizhou', '0576', '318000'),
(112, '001011011', '丽水', '001011', 11, '中国/浙江/丽水', '市', 3, 'ls', 'lishui', '0578', '323000'),
(113, '001012001', '合肥', '001012', 12, '中国/安徽/合肥', '市', 3, 'hf', 'hefei', '0551', '230001'),
(114, '001012002', '芜湖', '001012', 12, '中国/安徽/芜湖', '市', 3, 'wh', 'wuhu', '0553', '241000'),
(115, '001012003', '蚌埠', '001012', 12, '中国/安徽/蚌埠', '市', 3, 'bb', 'bangbu', '0552', '233000'),
(116, '001012004', '淮南', '001012', 12, '中国/安徽/淮南', '市', 3, 'hn', 'huainan', '0554', '232000'),
(117, '001012005', '马鞍山', '001012', 12, '中国/安徽/马鞍山', '市', 3, 'mas', 'maanshan', '0555', '243000'),
(118, '001012006', '淮北', '001012', 12, '中国/安徽/淮北', '市', 3, 'hb', 'huaibei', '0561', '235000'),
(119, '001012007', '铜陵', '001012', 12, '中国/安徽/铜陵', '市', 3, 'tl', 'tongling', '0562', '244000'),
(120, '001012008', '安庆', '001012', 12, '中国/安徽/安庆', '市', 3, 'aq', 'anqing', '0556', '246001'),
(121, '001012009', '黄山', '001012', 12, '中国/安徽/黄山', '市', 3, 'hs', 'huangshan', '0559', '245000'),
(122, '001012010', '滁州', '001012', 12, '中国/安徽/滁州', '市', 3, 'cz', 'chuzhou', '0550', '239001'),
(123, '001012011', '阜阳', '001012', 12, '中国/安徽/阜阳', '市', 3, 'fy', 'fuyang', '0558', '236033'),
(124, '001012012', '宿州', '001012', 12, '中国/安徽/宿州', '市', 3, 'sz', 'suzhou', '0557', '234000'),
(125, '001012013', '巢湖', '001012', 12, '中国/安徽/巢湖', '市', 3, 'ch', 'chaohu', '0565', '238000'),
(126, '001012014', '六安', '001012', 12, '中国/安徽/六安', '市', 3, 'la', 'liuan', '0564', '237002'),
(127, '001012015', '亳州', '001012', 12, '中国/安徽/亳州', '市', 3, 'hz', 'haozhou', '0558', '236802'),
(128, '001012016', '池州', '001012', 12, '中国/安徽/池州', '市', 3, 'cz', 'chizhou', '0566', '247100'),
(129, '001012017', '宣城', '001012', 12, '中国/安徽/宣城', '市', 3, 'xc', 'xuancheng', '0563', '242000'),
(130, '001013001', '福州', '001013', 13, '中国/福建/福州', '市', 3, 'fz', 'fuzhou', '0591', '350001'),
(131, '001013002', '厦门', '001013', 13, '中国/福建/厦门', '市', 3, 'xm', 'xiamen', '0592', '361012'),
(132, '001013003', '三明', '001013', 13, '中国/福建/三明', '市', 3, 'sm', 'sanming', '0598', '365000'),
(133, '001013004', '莆田', '001013', 13, '中国/福建/莆田', '市', 3, 'pt', 'putian', '0594', '351100'),
(134, '001013005', '泉州', '001013', 13, '中国/福建/泉州', '市', 3, 'qz', 'quanzhou', '0595', '362000'),
(135, '001013006', '漳州', '001013', 13, '中国/福建/漳州', '市', 3, 'zz', 'zhangzhou', '0596', '363000'),
(136, '001013007', '南平', '001013', 13, '中国/福建/南平', '市', 3, 'np', 'nanping', '0599', '353000'),
(137, '001013008', '龙岩', '001013', 13, '中国/福建/龙岩', '市', 3, 'ly', 'longyan', '0597', '364000'),
(138, '001013009', '宁德', '001013', 13, '中国/福建/宁德', '市', 3, 'nd', 'ningde', '0593', '352100'),
(139, '001014001', '南昌', '001014', 14, '中国/江西/南昌', '市', 3, 'nc', 'nanchang', '0791', '330008'),
(140, '001014002', '景德镇', '001014', 14, '中国/江西/景德镇', '市', 3, 'jdz', 'jingdezhen', '0798', '333000'),
(141, '001014003', '萍乡', '001014', 14, '中国/江西/萍乡', '市', 3, 'px', 'pingxiang', '0799', '337002'),
(142, '001014004', '九江', '001014', 14, '中国/江西/九江', '市', 3, 'jj', 'jiujiang', '0792', '332000'),
(143, '001014005', '新余', '001014', 14, '中国/江西/新余', '市', 3, 'xy', 'xinyu', '0790', '336525'),
(144, '001014006', '鹰潭', '001014', 14, '中国/江西/鹰潭', '市', 3, 'yt', 'yingtan', '0701', '335001'),
(145, '001014007', '赣州', '001014', 14, '中国/江西/赣州', '市', 3, 'gz', 'ganzhou', '0797', '341000'),
(146, '001014008', '吉安', '001014', 14, '中国/江西/吉安', '市', 3, 'ja', 'jian', '0796', '343000'),
(147, '001014009', '宜春', '001014', 14, '中国/江西/宜春', '市', 3, 'yc', 'yichun', '0795', '336000'),
(148, '001014010', '抚州', '001014', 14, '中国/江西/抚州', '市', 3, 'fz', 'fuzhou', '0794', '344000'),
(149, '001014011', '上饶', '001014', 14, '中国/江西/上饶', '市', 3, 'sr', 'shangrao', '0793', '334000'),
(150, '001015001', '济南', '001015', 15, '中国/山东/济南', '市', 3, 'jn', 'jinan', '0531', '250001'),
(151, '001015002', '青岛', '001015', 15, '中国/山东/青岛', '市', 3, 'qd', 'qingdao', '0532', '266001'),
(152, '001015003', '淄博', '001015', 15, '中国/山东/淄博', '市', 3, 'zb', 'zibo', '0533', '255039'),
(153, '001015004', '枣庄', '001015', 15, '中国/山东/枣庄', '市', 3, 'zz', 'zaozhuang', '0632', '277101'),
(154, '001015005', '东营', '001015', 15, '中国/山东/东营', '市', 3, 'dy', 'dongying', '0546', '257093'),
(155, '001015006', '潍坊', '001015', 15, '中国/山东/潍坊', '市', 3, 'wf', 'weifang', '0536', '261041'),
(156, '001015007', '烟台', '001015', 15, '中国/山东/烟台', '市', 3, 'yt', 'yantai', '0535', '264001'),
(157, '001015008', '威海', '001015', 15, '中国/山东/威海', '市', 3, 'wh', 'weihai', '0631', '264200'),
(158, '001015009', '济宁', '001015', 15, '中国/山东/济宁', '市', 3, 'jn', 'jining', '0537', '272119'),
(159, '001015010', '泰安', '001015', 15, '中国/山东/泰安', '市', 3, 'ta', 'taian', '0538', '271000'),
(160, '001015011', '日照', '001015', 15, '中国/山东/日照', '市', 3, 'rz', 'rizhao', '0633', '276800'),
(161, '001015012', '莱芜', '001015', 15, '中国/山东/莱芜', '市', 3, 'lw', 'laiwu', '0634', '271100'),
(162, '001015013', '临沂', '001015', 15, '中国/山东/临沂', '市', 3, 'ly', 'linyi', '0539', '276001'),
(163, '001015014', '德州', '001015', 15, '中国/山东/德州', '市', 3, 'dz', 'dezhou', '0534', '253012'),
(164, '001015015', '聊城', '001015', 15, '中国/山东/聊城', '市', 3, 'lc', 'liaocheng', '0635', '252052'),
(165, '001015016', '滨州', '001015', 15, '中国/山东/滨州', '市', 3, 'bz', 'binzhou', '0543', '256619'),
(166, '001015017', '菏泽', '001015', 15, '中国/山东/菏泽', '市', 3, 'hz', 'heze', '0530', '274020'),
(167, '001016001', '郑州', '001016', 16, '中国/河南/郑州', '市', 3, 'zz', 'zhengzhou', '0371', '450006'),
(168, '001016002', '开封', '001016', 16, '中国/河南/开封', '市', 3, 'kf', 'kaifeng', '0378', '475001'),
(169, '001016003', '洛阳', '001016', 16, '中国/河南/洛阳', '市', 3, 'ly', 'luoyang', '0379', '471000'),
(170, '001016004', '平顶山', '001016', 16, '中国/河南/平顶山', '市', 3, 'pds', 'pingdingsha', '0375', '467000'),
(171, '001016005', '焦作', '001016', 16, '中国/河南/焦作', '市', 3, 'jz', 'jiaozuo', '0391', '454002'),
(172, '001016006', '鹤壁', '001016', 16, '中国/河南/鹤壁', '市', 3, 'hb', 'hebi', '0392', '458030'),
(173, '001016007', '新乡', '001016', 16, '中国/河南/新乡', '市', 3, 'xx', 'xinxiang', '0373', '453000'),
(174, '001016008', '安阳', '001016', 16, '中国/河南/安阳', '市', 3, 'ay', 'anyang', '0372', '455000'),
(175, '001016009', '濮阳', '001016', 16, '中国/河南/濮阳', '市', 3, 'y', 'yang', '0393', '457000'),
(176, '001016010', '许昌', '001016', 16, '中国/河南/许昌', '市', 3, 'xc', 'xuchang', '0374', '461000'),
(177, '001016011', '漯河', '001016', 16, '中国/河南/漯河', '市', 3, 'h', 'he', '0395', '462000'),
(178, '001016012', '三门峡', '001016', 16, '中国/河南/三门峡', '市', 3, 'smx', 'sanmenxia', '0398', '472000'),
(179, '001016013', '南阳', '001016', 16, '中国/河南/南阳', '市', 3, 'ny', 'nanyang', '0377', '473002'),
(180, '001016014', '商丘', '001016', 16, '中国/河南/商丘', '市', 3, 'sq', 'shangqiu', '0370', '476000'),
(181, '001016015', '信阳', '001016', 16, '中国/河南/信阳', '市', 3, 'xy', 'xinyang', '0376', '464000'),
(182, '001016016', '周口', '001016', 16, '中国/河南/周口', '市', 3, 'zk', 'zhoukou', '0394', '466000'),
(183, '001016017', '驻马店', '001016', 16, '中国/河南/驻马店', '市', 3, 'zmd', 'zhumadian', '0396', '463000'),
(184, '001016018', '直辖行政单位', '001016', 16, '中国/河南/直辖行政单位', 'null', 3, 'zxxzdw', 'zhixiaxingz', '0391		', '454650'),
(185, '001017001', '武汉', '001017', 17, '中国/湖北/武汉', '市', 3, 'wh', 'wuhan', '027', '430014'),
(186, '001017002', '黄石', '001017', 17, '中国/湖北/黄石', '市', 3, 'hs', 'huangshi', '0714', '435003'),
(187, '001017003', '襄樊', '001017', 17, '中国/湖北/襄樊', '市', 3, 'xf', 'xiangfan', '0710', '441021'),
(188, '001017004', '十堰', '001017', 17, '中国/湖北/十堰', '市', 3, 'sy', 'shiyan', '0719', '442000'),
(189, '001017005', '荆州', '001017', 17, '中国/湖北/荆州', '市', 3, 'jz', 'jingzhou', '0716', '434000'),
(190, '001017006', '宜昌', '001017', 17, '中国/湖北/宜昌', '市', 3, 'yc', 'yichang', '0717', '443000'),
(191, '001017007', '荆门', '001017', 17, '中国/湖北/荆门', '市', 3, 'jm', 'jingmen', '0724', '448000'),
(192, '001017008', '鄂州', '001017', 17, '中国/湖北/鄂州', '市', 3, 'ez', 'ezhou', '0711', '436000'),
(193, '001017009', '孝感', '001017', 17, '中国/湖北/孝感', '市', 3, 'xg', 'xiaogan', '0712', '432100'),
(194, '001017010', '黄冈', '001017', 17, '中国/湖北/黄冈', '市', 3, 'hg', 'huanggang', '0713', '438000'),
(195, '001017011', '咸宁', '001017', 17, '中国/湖北/咸宁', '市', 3, 'xn', 'xianning', '0715', '437000'),
(196, '001017012', '随州', '001017', 17, '中国/湖北/随州', '市', 3, 'sz', 'suizhou', '0722', '441300'),
(197, '001017013', '恩施', '001017', 17, '中国/湖北/恩施', '州', 3, 'es', 'enshi', '0718', '445000'),
(198, '001017014', '直辖行政单位', '001017', 17, '中国/湖北/直辖行政单位', 'null', 3, 'zxxzdw', 'zhixiaxingz', '0719', '442400'),
(199, '001018001', '长沙', '001018', 18, '中国/湖南/长沙', '市', 3, 'cs', 'changsha', '0731', '410005'),
(200, '001018002', '株洲', '001018', 18, '中国/湖南/株洲', '市', 3, 'zz', 'zhuzhou', '0733', '412000'),
(201, '001018003', '湘潭', '001018', 18, '中国/湖南/湘潭', '市', 3, 'xt', 'xiangtan', '0732', '411100'),
(202, '001018004', '衡阳', '001018', 18, '中国/湖南/衡阳', '市', 3, 'hy', 'hengyang', '0734', '421001'),
(203, '001018005', '邵阳', '001018', 18, '中国/湖南/邵阳', '市', 3, 'sy', 'shaoyang', '0739', '422000'),
(204, '001018006', '岳阳', '001018', 18, '中国/湖南/岳阳', '市', 3, 'yy', 'yueyang', '0730', '414000'),
(205, '001018007', '常德', '001018', 18, '中国/湖南/常德', '市', 3, 'cd', 'changde', '0736', '415000'),
(206, '001018008', '张家界', '001018', 18, '中国/湖南/张家界', '市', 3, 'zjj', 'zhangjiajie', '0744', '427000'),
(207, '001018009', '益阳', '001018', 18, '中国/湖南/益阳', '市', 3, 'yy', 'yiyang', '0737', '413000'),
(208, '001018010', '郴州', '001018', 18, '中国/湖南/郴州', '市', 3, 'cz', 'chenzhou', '0735', '423000'),
(209, '001018011', '永州', '001018', 18, '中国/湖南/永州', '市', 3, 'yz', 'yongzhou', '0746', '425000'),
(210, '001018012', '怀化', '001018', 18, '中国/湖南/怀化', '市', 3, 'hh', 'huaihua', '0745', '418000'),
(211, '001018013', '娄底', '001018', 18, '中国/湖南/娄底', '市', 3, 'ld', 'loudi', '0738', '417000'),
(212, '001018014', '湘西', '001018', 18, '中国/湖南/湘西', '州', 3, 'xx', 'xiangxi', '0743', '416000'),
(213, '001019001', '广州', '001019', 19, '中国/广东/广州', '市', 3, 'gz', 'guangzhou', '020', '510130'),
(214, '001019002', '深圳', '001019', 19, '中国/广东/深圳', '市', 3, 'sz', 'shenzhen', '0755', '518027'),
(215, '001019003', '珠海', '001019', 19, '中国/广东/珠海', '市', 3, 'zh', 'zhuhai', '0756', '519000'),
(216, '001019004', '汕头', '001019', 19, '中国/广东/汕头', '市', 3, 'st', 'shantou', '0754', '515031'),
(217, '001019005', '韶关', '001019', 19, '中国/广东/韶关', '市', 3, 'sg', 'shaoguan', '0751', '512000'),
(218, '001019006', '河源', '001019', 19, '中国/广东/河源', '市', 3, 'hy', 'heyuan', '0762', '517001'),
(219, '001019007', '梅州', '001019', 19, '中国/广东/梅州', '市', 3, 'mz', 'meizhou', '0753', '514021'),
(220, '001019008', '惠州', '001019', 19, '中国/广东/惠州', '市', 3, 'hz', 'huizhou', '0752', '516001'),
(221, '001019009', '汕尾', '001019', 19, '中国/广东/汕尾', '市', 3, 'sw', 'shanwei', '0660', '516601'),
(222, '001019010', '东莞', '001019', 19, '中国/广东/东莞', '市', 3, 'd', 'dongwan', '0769', '523003'),
(223, '001019011', '中山', '001019', 19, '中国/广东/中山', '市', 3, 'zs', 'zhongshan', '0760', '528403'),
(224, '001019012', '江门', '001019', 19, '中国/广东/江门', '市', 3, 'jm', 'jiangmen', '0750', '529020'),
(225, '001019013', '佛山', '001019', 19, '中国/广东/佛山', '市', 3, 'fs', 'foshan', '0757', '528000'),
(226, '001019014', '阳江', '001019', 19, '中国/广东/阳江', '市', 3, 'yj', 'yangjiang', '0662', '529525'),
(227, '001019015', '湛江', '001019', 19, '中国/广东/湛江', '市', 3, 'zj', 'zhanjiang', '0759', '524038'),
(228, '001019016', '茂名', '001019', 19, '中国/广东/茂名', '市', 3, 'mm', 'maoming', '0668', '525011'),
(229, '001019017', '肇庆', '001019', 19, '中国/广东/肇庆', '市', 3, 'zq', 'zhaoqing', '0758', '526060'),
(230, '001019018', '清远', '001019', 19, '中国/广东/清远', '市', 3, 'qy', 'qingyuan', '0763', '511500'),
(231, '001019019', '潮州', '001019', 19, '中国/广东/潮州', '市', 3, 'cz', 'chaozhou', '0768', '521000'),
(232, '001019020', '揭阳', '001019', 19, '中国/广东/揭阳', '市', 3, 'jy', 'jieyang', '0663', '522000'),
(233, '001019021', '云浮', '001019', 19, '中国/广东/云浮', '市', 3, 'yf', 'yunfu', '0766', '527300'),
(234, '001020001', '南宁', '001020', 20, '中国/广西/南宁', '市', 3, 'nn', 'nanning', '0771', '530012'),
(235, '001020002', '柳州', '001020', 20, '中国/广西/柳州', '市', 3, 'lz', 'liuzhou', '0772', '545001'),
(236, '001020003', '桂林', '001020', 20, '中国/广西/桂林', '市', 3, 'gl', 'guilin', '0773', '541002'),
(237, '001020004', '梧州', '001020', 20, '中国/广西/梧州', '市', 3, 'wz', 'wuzhou', '0774', '543000'),
(238, '001020005', '北海', '001020', 20, '中国/广西/北海', '市', 3, 'bh', 'beihai', '0779', '536000'),
(239, '001020006', '防城港', '001020', 20, '中国/广西/防城港', '市', 3, 'fcg', 'fangchengga', '0770', '538001'),
(240, '001020007', '钦州', '001020', 20, '中国/广西/钦州', '市', 3, 'qz', 'qinzhou', '0777', '535000'),
(241, '001020008', '贵港', '001020', 20, '中国/广西/贵港', '市', 3, 'gg', 'guigang', '0775', '537100'),
(242, '001020009', '玉林', '001020', 20, '中国/广西/玉林', '市', 3, 'yl', 'yulin', '0775', '537000'),
(243, '001020010', '百色', '001020', 20, '中国/广西/百色', '市', 3, 'bs', 'baise', '0776', '533000'),
(244, '001020011', '贺州', '001020', 20, '中国/广西/贺州', '市', 3, 'hz', 'hezhou', '0774', '542800'),
(245, '001020012', '河池', '001020', 20, '中国/广西/河池', '市', 3, 'hc', 'hechi', '0778', '547000'),
(246, '001020013', '来宾', '001020', 20, '中国/广西/来宾', '市', 3, 'lb', 'laibin', '0772', 'null'),
(247, '001020014', '崇左', '001020', 20, '中国/广西/崇左', '市', 3, 'cz', 'chongzuo', 'null', 'null'),
(248, '001021001', '海口', '001021', 21, '中国/海南/海口', '市', 3, 'hk', 'haikou', '0898', '570102'),
(249, '001021002', '三亚', '001021', 21, '中国/海南/三亚', '市', 3, 'sy', 'sanya', '0898', '572002'),
(250, '001021003', '省直辖行政单位', '001021', 21, '中国/海南/省直辖行政单位', 'null', 3, 'zxxzdw', 'zhixiaxingz', '0898', '571800'),
(251, '001023001', '成都', '001023', 23, '中国/四川/成都', '市', 3, 'cd', 'chengdu', '028', '610015'),
(252, '001023002', '自贡', '001023', 23, '中国/四川/自贡', '市', 3, 'zg', 'zigong', '0813', '643000'),
(253, '001023003', '攀枝花', '001023', 23, '中国/四川/攀枝花', '市', 3, 'pzh', 'panzhihua', '0812', '617000'),
(254, '001023004', '泸州', '001023', 23, '中国/四川/泸州', '市', 3, 'lz', 'luzhou', '0830', '646000'),
(255, '001023005', '德阳', '001023', 23, '中国/四川/德阳', '市', 3, 'dy', 'deyang', '0838', '618000'),
(256, '001023006', '绵阳', '001023', 23, '中国/四川/绵阳', '市', 3, 'my', 'mianyang', '0816', '621000'),
(257, '001023007', '广元', '001023', 23, '中国/四川/广元', '市', 3, 'gy', 'guangyuan', '0839', '628017'),
(258, '001023008', '遂宁', '001023', 23, '中国/四川/遂宁', '市', 3, 'sn', 'suining', '0825', '629000'),
(259, '001023009', '内江', '001023', 23, '中国/四川/内江', '市', 3, 'nj', 'neijiang', '0832', '641000'),
(260, '001023010', '乐山', '001023', 23, '中国/四川/乐山', '市', 3, 'ls', 'leshan', '0833', '614000'),
(261, '001023011', '南充', '001023', 23, '中国/四川/南充', '市', 3, 'nc', 'nanchong', '0817', '637000'),
(262, '001023012', '宜宾', '001023', 23, '中国/四川/宜宾', '市', 3, 'yb', 'yibin', '0831', '644000'),
(263, '001023013', '广安', '001023', 23, '中国/四川/广安', '市', 3, 'ga', 'guangan', '0826', '638500'),
(264, '001023014', '达州', '001023', 23, '中国/四川/达州', '市', 3, 'dz', 'dazhou', '0818', '635000'),
(265, '001023015', '眉山', '001023', 23, '中国/四川/眉山', '市', 3, 'ms', 'meishan', '0833', '620010'),
(266, '001023016', '雅安', '001023', 23, '中国/四川/雅安', '市', 3, 'ya', 'yaan', '0835', '625000'),
(267, '001023017', '巴中', '001023', 23, '中国/四川/巴中', '市', 3, 'bz', 'bazhong', '0827', '636600'),
(268, '001023018', '资阳', '001023', 23, '中国/四川/资阳', '市', 3, 'zy', 'ziyang', '0832', '641300'),
(269, '001023019', '阿坝', '001023', 23, '中国/四川/阿坝', '州', 3, 'ab', 'aba', '0837', '624000'),
(270, '001023020', '甘孜', '001023', 23, '中国/四川/甘孜', '州', 3, 'gz', 'ganzi', '0836', '626000'),
(271, '001023021', '凉山', '001023', 23, '中国/四川/凉山', '州', 3, 'ls', 'liangshan', '0834', '615000'),
(272, '001024001', '贵阳', '001024', 24, '中国/贵州/贵阳', '市', 3, 'gy', 'guiyang', '0851', '550003'),
(273, '001024002', '六盘水', '001024', 24, '中国/贵州/六盘水', '市', 3, 'lps', 'liupanshui', '0858', '553001'),
(274, '001024003', '遵义', '001024', 24, '中国/贵州/遵义', '市', 3, 'zy', 'zunyi', '0852', '563000'),
(275, '001024004', '安顺', '001024', 24, '中国/贵州/安顺', '市', 3, 'as', 'anshun', '0853', '561000'),
(276, '001024005', '铜仁地', '001024', 24, '中国/贵州/铜仁地', '区', 3, 'trd', 'tongrendi', '0856', '554300'),
(277, '001024006', '毕节地', '001024', 24, '中国/贵州/毕节地', '区', 3, 'bjd', 'bijiedi', '0857', '551700'),
(278, '001024007', '黔西南', '001024', 24, '中国/贵州/黔西南', '州', 3, 'qxn', 'qianxinan', '0859', '562400'),
(279, '001024008', '黔东南', '001024', 24, '中国/贵州/黔东南', '州', 3, 'qdn', 'qiandongnan', '0855', '556000'),
(280, '001024009', '黔南', '001024', 24, '中国/贵州/黔南', '州', 3, 'qn', 'qiannan', '0854', '558000'),
(281, '001025001', '昆明', '001025', 25, '中国/云南/昆明', '市', 3, 'km', 'kunming', '0871', '650011'),
(282, '001025002', '曲靖', '001025', 25, '中国/云南/曲靖', '市', 3, 'qj', 'qujing', '0874', '655000'),
(283, '001025003', '玉溪', '001025', 25, '中国/云南/玉溪', '市', 3, 'yx', 'yuxi', '0877', '653100'),
(284, '001025004', '保山', '001025', 25, '中国/云南/保山', '市', 3, 'bs', 'baoshan', '0875', '678000'),
(285, '001025005', '昭通', '001025', 25, '中国/云南/昭通', '市', 3, 'zt', 'zhaotong', '0870', '657000'),
(286, '001025006', '思茅', '001025', 25, '中国/云南/思茅', '地区', 3, 'smd', 'simaodi', '0879', '665000'),
(287, '001025007', '临沧', '001025', 25, '中国/云南/临沧', '地区', 3, 'lcd', 'lincangdi', '0883', '677000'),
(288, '001025008', '丽江', '001025', 25, '中国/云南/丽江', '市', 3, 'lj', 'lijiang', '0888', '674100'),
(289, '001025009', '文山', '001025', 25, '中国/云南/文山', '州', 3, 'ws', 'wenshan', '0876', '663000'),
(290, '001025010', '红河', '001025', 25, '中国/云南/红河', '州', 3, 'hh', 'honghe', '0873', '661400'),
(291, '001025011', '西双版纳', '001025', 25, '中国/云南/西双版纳', '州', 3, 'xsbn', 'xishuangban', '0691', '666100'),
(292, '001025012', '楚雄', '001025', 25, '中国/云南/楚雄', '州', 3, 'cx', 'chuxiong', '0878', '675000'),
(293, '001025013', '大理', '001025', 25, '中国/云南/大理', '州', 3, 'dl', 'dali', '0872', '671000'),
(294, '001025014', '德宏', '001025', 25, '中国/云南/德宏', '州', 3, 'dh', 'dehong', '0692', '678400'),
(295, '001025015', '怒江', '001025', 25, '中国/云南/怒江', '州', 3, 'nj', 'nujiang', '0886', '673100'),
(296, '001025016', '迪庆', '001025', 25, '中国/云南/迪庆', '州', 3, 'dq', 'diqing', '0887', '674400'),
(297, '001026001', '拉萨', '001026', 26, '中国/西藏/拉萨', '市', 3, 'ls', 'lasa', '0891', '850012'),
(298, '001026002', '那曲', '001026', 26, '中国/西藏/那曲', '地区', 3, 'nqd', 'naqudi', '0896', '852000'),
(299, '001026003', '昌都', '001026', 26, '中国/西藏/昌都', '地区', 3, 'cdd', 'changdudi', '0895', '854000'),
(300, '001026004', '山南', '001026', 26, '中国/西藏/山南', '地区', 3, 'snd', 'shannandi', '0893', '856000'),
(301, '001026005', '日喀则', '001026', 26, '中国/西藏/日喀则', '地区', 3, 'rkzd', 'rikazedi', '0892', '857000'),
(302, '001026006', '阿里', '001026', 26, '中国/西藏/阿里', '地区', 3, 'ald', 'alidi', '0897', '859000'),
(303, '001026007', '林芝', '001026', 26, '中国/西藏/林芝', '地区', 3, 'lzd', 'linzhidi', '0894', '860000'),
(304, '001027001', '西安', '001027', 27, '中国/陕西/西安', '市', 3, 'xa', 'xian', '029', '710003'),
(305, '001027002', '铜川', '001027', 27, '中国/陕西/铜川', '市', 3, 'tc', 'tongchuan', '0919', '727000'),
(306, '001027003', '宝鸡', '001027', 27, '中国/陕西/宝鸡', '市', 3, 'bj', 'baoji', '0917', '721000'),
(307, '001027004', '咸阳', '001027', 27, '中国/陕西/咸阳', '市', 3, 'xy', 'xianyang', '0910', '712000'),
(308, '001027005', '渭南', '001027', 27, '中国/陕西/渭南', '市', 3, 'wn', 'weinan', '0913', '714000'),
(309, '001027006', '延安', '001027', 27, '中国/陕西/延安', '市', 3, 'ya', 'yanan', '0911', '716000'),
(310, '001027007', '汉中', '001027', 27, '中国/陕西/汉中', '市', 3, 'hz', 'hanzhong', '0916', '723000'),
(311, '001027008', '榆林', '001027', 27, '中国/陕西/榆林', '市', 3, 'yl', 'yulin', '0912', '719000'),
(312, '001027009', '安康', '001027', 27, '中国/陕西/安康', '市', 3, 'ak', 'ankang', '0915', '725000'),
(313, '001027010', '商洛', '001027', 27, '中国/陕西/商洛', '市', 3, 'sl', 'shangluo', '0914', '726000'),
(314, '001028001', '兰州', '001028', 28, '中国/甘肃/兰州', '市', 3, 'lz', 'lanzhou', '0931', '730030'),
(315, '001028002', '金昌', '001028', 28, '中国/甘肃/金昌', '市', 3, 'jc', 'jinchang', '0935', '737100'),
(316, '001028003', '白银', '001028', 28, '中国/甘肃/白银', '市', 3, 'by', 'baiyin', '0943', '730900'),
(317, '001028004', '天水', '001028', 28, '中国/甘肃/天水', '市', 3, 'ts', 'tianshui', '0938', '741000'),
(318, '001028005', '嘉峪关', '001028', 28, '中国/甘肃/嘉峪关', '市', 3, 'jyg', 'jiayuguan', '0937', '735100'),
(319, '001028006', '武威', '001028', 28, '中国/甘肃/武威', '市', 3, 'ww', 'wuwei', '0935', '733000'),
(320, '001028007', '张掖', '001028', 28, '中国/甘肃/张掖', '市', 3, 'zy', 'zhangye', '0936', '734000'),
(321, '001028008', '平凉', '001028', 28, '中国/甘肃/平凉', '市', 3, 'pl', 'pingliang', '0933', '744000'),
(322, '001028009', '酒泉', '001028', 28, '中国/甘肃/酒泉', '市', 3, 'jq', 'jiuquan', '0937', '735000'),
(323, '001028010', '庆阳', '001028', 28, '中国/甘肃/庆阳', '市', 3, 'qy', 'qingyang', '0934', '745000'),
(324, '001028011', '定西', '001028', 28, '中国/甘肃/定西', '地区', 3, 'dxd', 'dingxidi', '0932', '743000'),
(325, '001028012', '陇南', '001028', 28, '中国/甘肃/陇南', '地区', 3, 'lnd', 'longnandi', '0935', '742500'),
(326, '001028013', '甘南', '001028', 28, '中国/甘肃/甘南', '州', 3, 'gn', 'gannan', '0941', '747004'),
(327, '001028014', '临夏', '001028', 28, '中国/甘肃/临夏', '州', 3, 'lx', 'linxia', '0930', '731100'),
(328, '001029001', '西宁', '001029', 29, '中国/青海/西宁', '市', 3, 'xn', 'xining', '0971', '810000'),
(329, '001029002', '海东', '001029', 29, '中国/青海/海东', '地区', 3, 'hdd', 'haidongdi', '0972', '810600'),
(330, '001029003', '海北', '001029', 29, '中国/青海/海北', '州', 3, 'hb', 'haibei', '0970', '812200'),
(331, '001029004', '黄南', '001029', 29, '中国/青海/黄南', '州', 3, 'hn', 'huangnan', '0973', '811300'),
(332, '001029005', '海南', '001029', 29, '中国/青海/海南', '州', 3, 'hn', 'hainan', '0974', '813000'),
(333, '001029006', '果洛', '001029', 29, '中国/青海/果洛', '州', 3, 'gl', 'guoluo', '0975', '814000'),
(334, '001029007', '玉树', '001029', 29, '中国/青海/玉树', '州', 3, 'ys', 'yushu', '0976', '815000'),
(335, '001029008', '海西', '001029', 29, '中国/青海/海西', '州', 3, 'hx', 'haixi', '0977', '817000'),
(336, '001030001', '银川', '001030', 30, '中国/宁夏/银川', '市', 3, 'yc', 'yinchuan', '0951', '750004'),
(337, '001030002', '石嘴山', '001030', 30, '中国/宁夏/石嘴山', '市', 3, 'szs', 'shizuishan', '0952', '753000'),
(338, '001030003', '吴忠', '001030', 30, '中国/宁夏/吴忠', '市', 3, 'wz', 'wuzhong', '0953', '751100'),
(339, '001030004', '固原', '001030', 30, '中国/宁夏/固原', '市', 3, 'gy', 'guyuan', '0954', '756000'),
(340, '001031001', '乌鲁木齐', '001031', 31, '中国/新疆/乌鲁木齐', '市', 3, 'wlmq', 'wulumuqi', '0991', '830002'),
(341, '001031002', '克拉玛依', '001031', 31, '中国/新疆/克拉玛依', '市', 3, 'klmy', 'kelamayi', '0990', '834000'),
(342, '001031003', '直辖行政单位', '001031', 31, '中国/新疆/直辖行政单位', 'null', 3, 'zxxzdw', 'zhixiaxingz', '0993', '832000'),
(343, '001031004', '吐鲁番', '001031', 31, '中国/新疆/吐鲁番', '地区', 3, 'tlfd', 'tulufandi', '0995', '838000'),
(344, '001031005', '哈密', '001031', 31, '中国/新疆/哈密', '地区', 3, 'hmd', 'hamidi', '0902', '839000'),
(345, '001031006', '和田', '001031', 31, '中国/新疆/和田', '地区', 3, 'htd', 'hetiandi', '0903', '848000'),
(346, '001031007', '阿克苏', '001031', 31, '中国/新疆/阿克苏', '地区', 3, 'aksd', 'akesudi', '0997', '843000'),
(347, '001031008', '喀什', '001031', 31, '中国/新疆/喀什', '地区', 3, 'ksd', 'kashidi', '0998', '844000'),
(348, '001031009', '克孜勒苏', '001031', 31, '中国/新疆/克孜勒苏', '州', 3, 'kzls', 'kezilesu', '0908', '845350'),
(349, '001031010', '巴音郭楞', '001031', 31, '中国/新疆/巴音郭楞', '州', 3, 'bygl', 'bayinguolen', '0996', '841000'),
(350, '001031011', '昌吉', '001031', 31, '中国/新疆/昌吉', '州', 3, 'cj', 'changji', '0994', '831100'),
(351, '001031012', '博尔塔拉', '001031', 31, '中国/新疆/博尔塔拉', '州', 3, 'betl', 'boertala', '0909', '833400'),
(352, '001031013', '伊犁', '001031', 31, '中国/新疆/伊犁', '州', 3, 'yl', 'yili', '0999', '835000'),
(353, '001031014', '塔城', '001031', 31, '中国/新疆/塔城', '地区', 3, 'tcd', 'tachengdi', '0901', '834700'),
(354, '001031015', '阿勒泰', '001031', 31, '中国/新疆/阿勒泰', '地区', 3, 'altd', 'aletaidi', '0906', '836500'),
(355, '001009001', '市辖区', '001009', 9, '中国/上海/市辖区', 'null', 3, 'null', 'null', '020', '200000'),
(356, '001009002', '县', '001009', 9, '中国/上海/县', 'null', 3, 'null', 'null', '020', 'null'),
(357, '001022001', '市辖区', '001022', 22, '中国/重庆/市辖区', 'null', 3, 'null', 'null', 'null', 'null'),
(358, '001022002', '市', '001022', 22, '中国/重庆/市', 'null', 3, 'null', 'null', 'null', 'null'),
(359, '001022003', '县', '001022', 22, '中国/重庆/县', 'null', 3, 'null', 'null', 'null', 'null'),
(360, '001002001', '市辖区', '001002', 2, '中国/天津/市辖区', 'null', 3, 'null', 'null', 'null', 'null'),
(361, '001002002', '县', '001002', 2, '中国/天津/县', 'null', 3, 'null', 'null', 'null', 'null');



CREATE TABLE IF NOT EXISTS `des_comm` (
  `comm_id` int(11) NOT NULL AUTO_INCREMENT,
  `sort` int(11) NOT NULL COMMENT '应用id',
  `fid` int(11) NOT NULL COMMENT '回复id',
  `user_id` int(11) NOT NULL COMMENT '用户id',
  `sys_id` int(11) NOT NULL COMMENT '内容id',
  `status` int(11) NOT NULL COMMENT '状态{-1：已删除，0：未审核，1审核通过}',
  `comm` text NOT NULL COMMENT '内容',
  `create_time` int(11) NOT NULL COMMENT '提交时间',
  PRIMARY KEY (`comm_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


INSERT INTO `des_comm` (`comm_id`, `sort`, `fid`, `user_id`, `sys_id`, `status`, `comm`, `create_time`) VALUES
(1, 0, 0, 0, 0, 1, '3245fghdfhdf', 0);



CREATE TABLE IF NOT EXISTS `des_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '配置名称',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '配置类型',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '配置说明',
  `group` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '配置分组',
  `extra` varchar(255) NOT NULL DEFAULT '' COMMENT '配置值',
  `remark` varchar(100) NOT NULL COMMENT '配置说明',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT '状态',
  `value` text NOT NULL COMMENT '配置值',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


INSERT INTO `des_config` (`id`, `name`, `type`, `title`, `group`, `extra`, `remark`, `create_time`, `update_time`, `status`, `value`, `sort`) VALUES
(4, 'WEB_SITE_CLOSE', 4, '关闭站点', 1, '0:关闭,1:开启', '站点关闭后其他用户不能访问，管理员可以正常访问', 1378898976, 1379235296, 1, '1', 0),
(9, 'CONFIG_TYPE_LIST', 3, '配置类型列表', 4, '', '主要用于数据解析和页面表单的生成', 1378898976, 1379235348, 1, '0:数字\r\n1:字符\r\n2:文本\r\n3:数组\r\n4:枚举', 0),
(11, 'DOCUMENT_POSITION', 3, '文档推荐位', 2, '', '文档推荐位，推荐到多个位置KEY值相加即可', 1379053380, 1379235329, 1, '1:列表页推荐\r\n2:频道页推荐\r\n4:网站首页推荐', 0),
(12, 'DOCUMENT_DISPLAY', 3, '文档可见性', 2, '', '文章可见性仅影响前台显示，后台不收影响', 1379056370, 1379235322, 1, '0:所有人可见\r\n1:仅注册会员可见\r\n2:仅管理员可见', 0),
(13, 'COLOR_STYLE', 4, '后台色系', 1, 'default_color:默认\r\nblue_color:紫罗兰', '后台颜色风格', 1379122533, 1379235904, 1, 'blue_color', 5),
(20, 'CONFIG_GROUP_LIST', 3, '配置分组', 4, '', '配置分组', 1379228036, 1384418383, 1, '1:基本\r\n2:内容\r\n3:用户\r\n4:系统', 0),
(21, 'HOOKS_TYPE', 3, '钩子的类型', 4, '', '类型 1-用于扩展显示内容，2-用于扩展业务处理', 1379313397, 1379313407, 1, '1:视图\r\n2:控制器', 0),
(22, 'AUTH_CONFIG', 3, 'Auth配置', 4, '', '自定义Auth.class.php类配置', 1379409310, 1379409564, 1, 'AUTH_ON:1\r\nAUTH_TYPE:2', 0),
(23, 'OPEN_DRAFTBOX', 4, '是否开启草稿功能', 2, '0:关闭草稿功能\r\n1:开启草稿功能\r\n', '新增文章时的草稿功能配置', 1379484332, 1379484591, 1, '1', 0),
(24, 'AOTUSAVE_DRAFT', 0, '自动保存草稿时间', 2, '', '自动保存草稿的时间间隔，单位：秒', 1379484574, 1379484574, 1, '60', 0),
(25, 'LIST_ROWS', 0, '后台每页记录数', 2, '', '后台数据每页显示记录数', 1379503896, 1380427745, 1, '10', 5),
(26, 'USER_ALLOW_REGISTER', 4, '是否允许用户注册', 3, '0:关闭注册\r\n1:允许注册', '是否开放用户注册', 1379504487, 1379504580, 1, '1', 0),
(27, 'CODEMIRROR_THEME', 4, '预览插件的CodeMirror主题', 4, '3024-day:3024 day\r\n3024-night:3024 night\r\nambiance:ambiance\r\nbase16-dark:base16 dark\r\nbase16-light:base16 light\r\nblackboard:blackboard\r\ncobalt:cobalt\r\neclipse:eclipse\r\nelegant:elegant\r\nerlang-dark:erlang-dark\r\nlesser-dark:lesser-dark\r\nmidnight:midnight', '详情见CodeMirror官网', 1379814385, 1384740813, 1, 'ambiance', 0),
(28, 'DATA_BACKUP_PATH', 1, '数据库备份根路径', 4, '', '路径必须以 / 结尾', 1381482411, 1381482411, 1, './Data/', 0),
(29, 'DATA_BACKUP_PART_SIZE', 0, '数据库备份卷大小', 4, '', '该值用于限制压缩后的分卷最大长度。单位：B；建议设置20M', 1381482488, 1381729564, 1, '20971520', 0),
(30, 'DATA_BACKUP_COMPRESS', 4, '数据库备份文件是否启用压缩', 4, '0:不压缩\r\n1:启用压缩', '压缩备份文件需要PHP环境支持gzopen,gzwrite函数', 1381713345, 1381729544, 1, '1', 0),
(31, 'DATA_BACKUP_COMPRESS_LEVEL', 4, '数据库备份文件压缩级别', 4, '1:普通\r\n4:一般\r\n9:最高', '数据库备份文件的压缩级别，该配置在开启压缩时生效', 1381713408, 1381713408, 1, '9', 0),
(32, 'DEVELOP_MODE', 4, '开启开发者模式', 4, '0:关闭\r\n1:开启', '是否开启开发者模式', 1383105995, 1383291877, 1, '1', 0);


CREATE TABLE IF NOT EXISTS `des_country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `countryId` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  `countryIdNum` int(11) DEFAULT NULL,
  `countryName` varchar(50) CHARACTER SET gbk DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `des_district` (
  `serialId` int(4) NOT NULL AUTO_INCREMENT,
  `districtId` varchar(20) CHARACTER SET gbk DEFAULT NULL,
  `districtName` varchar(20) CHARACTER SET gbk DEFAULT NULL,
  `districtUpId` varchar(20) CHARACTER SET gbk DEFAULT NULL,
  `districtUpIdNum` int(11) DEFAULT NULL,
  `districtPath` varchar(100) CHARACTER SET gbk DEFAULT NULL,
  `districtType` varchar(20) CHARACTER SET gbk DEFAULT NULL,
  `districtTypeNum` int(11) DEFAULT NULL,
  `shortName` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  `spell` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  `areaId` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  `postCode` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  PRIMARY KEY (`serialId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;


INSERT INTO `des_district` (`serialId`, `districtId`, `districtName`, `districtUpId`, `districtUpIdNum`, `districtPath`, `districtType`, `districtTypeNum`, `shortName`, `spell`, `areaId`, `postCode`) VALUES
(1, '001002001002', '河东', '001002001', 360, '中国/天津/市辖区/河东', '区', 4, 'hd', 'hedong', '022', '300171'),
(2, '001002001003', '河西', '001002001', 360, '中国/天津/市辖区/河西', '区', 4, 'hx', 'hexi', '022', '300202'),
(3, '001002001004', '南开', '001002001', 360, '中国/天津/市辖区/南开', '区', 4, 'nk', 'nankai', '022', '300100'),
(4, '001002001005', '河北', '001002001', 360, '中国/天津/市辖区/河北', '区', 4, 'hb', 'hebei', '022', '300143'),
(5, '001002001006', '红桥', '001002001', 360, '中国/天津/市辖区/红桥', '区', 4, 'hq', 'hongqiao', '022', '300131'),
(6, '001002001007', '塘沽', '001002001', 360, '中国/天津/市辖区/塘沽', '区', 4, 'tg', 'tanggu', '022', '300450'),
(7, '001002001008', '汉沽', '001002001', 360, '中国/天津/市辖区/汉沽', '区', 4, 'hg', 'hangu', '022', '300480'),
(8, '001002001009', '大港', '001002001', 360, '中国/天津/市辖区/大港', '区', 4, 'dg', 'dagang', '022', '300270'),
(9, '001002001010', '东丽', '001002001', 360, '中国/天津/市辖区/东丽', '区', 4, 'dl', 'dongli', '022', '300300'),
(10, '001002001011', '西青', '001002001', 360, '中国/天津/市辖区/西青', '区', 4, 'xq', 'xiqing', '022', '300380'),
(11, '001002001012', '津南', '001002001', 360, '中国/天津/市辖区/津南', '区', 4, 'jn', 'jinnan', '022', '300350'),
(12, '001002001013', '北辰', '001002001', 360, '中国/天津/市辖区/北辰', '区', 4, 'bc', 'beichen', '022', '300400'),
(13, '001002001014', '武清', '001002001', 360, '中国/天津/市辖区/武清', '区', 4, 'wq', 'wuqing', '022', '301700'),
(14, '001002001015', '宝坻', '001002001', 360, '中国/天津/市辖区/宝坻', '区', 4, 'b', 'bao', '022', '301800'),
(15, '001002002016', '蓟县', '001002002', 361, '中国/天津/县/蓟县', 'null', 4, 'j', 'ji', '022', '301900'),
(16, '001002002017', '宁河', '001002002', 361, '中国/天津/县/宁河', '县', 4, 'nh', 'ninghe', '022', '301500'),
(17, '001002002018', '静海', '001002002', 361, '中国/天津/县/静海', '县', 4, 'jh', 'jinghai', '022', '301600'),
(18, '001003001001', '长安', '001003001', 19, '中国/河北/石家庄/长安', '区', 4, 'ca', 'changan', 'null', '050011'),
(19, '001003001002', '桥东', '001003001', 19, '中国/河北/石家庄/桥东', '区', 4, 'qd', 'qiaodong', 'null', '050011'),
(20, '001003001003', '桥西', '001003001', 19, '中国/河北/石家庄/桥西', '区', 4, 'qx', 'qiaoxi', 'null', '050051'),
(21, '001003001004', '新华', '001003001', 19, '中国/河北/石家庄/新华', '区', 4, 'xh', 'xinhua', 'null', '050051'),
(22, '001003001005', '裕华', '001003001', 19, '中国/河北/石家庄/裕华', '区', 4, 'yh', 'yuhua', 'null', '050081'),
(23, '001003001006', '井陉矿', '001003001', 19, '中国/河北/石家庄/井陉矿', '区', 4, 'jk', 'jingkuang', 'null', '050100'),
(24, '001003001007', '辛集', '001003001', 19, '中国/河北/石家庄/辛集', '市', 4, 'xj', 'xinji', 'null', '052360'),
(25, '001003001008', '藁城', '001003001', 19, '中国/河北/石家庄/藁城', '市', 4, 'c', 'cheng', 'null', '052160'),
(26, '001003001009', '晋州', '001003001', 19, '中国/河北/石家庄/晋州', '市', 4, 'jz', 'jinzhou', 'null', '052260'),
(27, '001003001010', '新乐', '001003001', 19, '中国/河北/石家庄/新乐', '市', 4, 'xl', 'xinle', 'null', '050700'),
(28, '001003001011', '鹿泉', '001003001', 19, '中国/河北/石家庄/鹿泉', '市', 4, 'lq', 'luquan', 'null', '050200'),
(29, '001003001012', '井陉', '001003001', 19, '中国/河北/石家庄/井陉', '县', 4, 'j', 'jing', 'null', '050300'),
(30, '001003001013', '正定', '001003001', 19, '中国/河北/石家庄/正定', '县', 4, 'zd', 'zhengding', 'null', '050800'),
(31, '001003001014', '栾城', '001003001', 19, '中国/河北/石家庄/栾城', '县', 4, 'c', 'cheng', 'null', '051430'),
(32, '001003001015', '行唐', '001003001', 19, '中国/河北/石家庄/行唐', '县', 4, 'xt', 'xingtang', 'null', '050600'),
(33, '001003001016', '灵寿', '001003001', 19, '中国/河北/石家庄/灵寿', '县', 4, 'ls', 'lingshou', 'null', '050500'),
(34, '001003001017', '高邑', '001003001', 19, '中国/河北/石家庄/高邑', '县', 4, 'gy', 'gaoyi', 'null', '051330'),
(35, '001003001018', '深泽', '001003001', 19, '中国/河北/石家庄/深泽', '县', 4, 'sz', 'shenze', 'null', '052560'),
(36, '001003001019', '赞皇', '001003001', 19, '中国/河北/石家庄/赞皇', '县', 4, 'zh', 'zanhuang', 'null', '051230'),
(37, '001003001020', '无极', '001003001', 19, '中国/河北/石家庄/无极', '县', 4, 'wj', 'wuji', 'null', '052460'),
(38, '001003001021', '平山', '001003001', 19, '中国/河北/石家庄/平山', '县', 4, 'ps', 'pingshan', 'null', '050400'),
(39, '001003001022', '元氏', '001003001', 19, '中国/河北/石家庄/元氏', '县', 4, 'ys', 'yuanshi', 'null', '051130'),
(40, '001003001023', '赵县', '001003001', 19, '中国/河北/石家庄/赵县', 'null', 4, 'z', 'zhao', 'null', '051530'),
(41, '001003002001', '路北', '001003002', 20, '中国/河北/唐山/路北', '区', 4, 'lb', 'lubei', 'null', '063015'),
(42, '001003002002', '路南', '001003002', 20, '中国/河北/唐山/路南', '区', 4, 'ln', 'lunan', 'null', '063017'),
(43, '001003002003', '古冶', '001003002', 20, '中国/河北/唐山/古冶', '区', 4, 'gy', 'guye', 'null', '063104'),
(44, '001003002004', '开平', '001003002', 20, '中国/河北/唐山/开平', '区', 4, 'kp', 'kaiping', 'null', '063021'),
(45, '001003002005', '丰润', '001003002', 20, '中国/河北/唐山/丰润', '区', 4, 'fr', 'fengrun', 'null', '064000'),
(46, '001003002006', '丰南', '001003002', 20, '中国/河北/唐山/丰南', '区', 4, 'fn', 'fengnan', 'null', '063300'),
(47, '001003002007', '遵化', '001003002', 20, '中国/河北/唐山/遵化', '市', 4, 'zh', 'zunhua', 'null', '064200'),
(48, '001003002008', '迁安', '001003002', 20, '中国/河北/唐山/迁安', '市', 4, 'qa', 'qianan', 'null', '064400'),
(49, '001003002009', '滦县', '001003002', 20, '中国/河北/唐山/滦县', 'null', 4, 'l', 'luan', 'null', '063700'),
(50, '001003002010', '滦南', '001003002', 20, '中国/河北/唐山/滦南', '县', 4, 'ln', 'luannan', 'null', '063500'),
(51, '001003002011', '乐亭', '001003002', 20, '中国/河北/唐山/乐亭', '县', 4, 'lt', 'leting', 'null', '063600'),
(52, '001003002012', '迁西', '001003002', 20, '中国/河北/唐山/迁西', '县', 4, 'qx', 'qianxi', 'null', '064300'),
(53, '001003002013', '玉田', '001003002', 20, '中国/河北/唐山/玉田', '县', 4, 'yt', 'yutian', 'null', '064100'),
(54, '001003002014', '唐海', '001003002', 20, '中国/河北/唐山/唐海', '县', 4, 'th', 'tanghai', 'null', '063200'),
(55, '001003003001', '海港', '001003003', 21, '中国/河北/秦皇岛/海港', '区', 4, 'hg', 'haigang', 'null', '066000'),
(56, '001003003002', '山海关', '001003003', 21, '中国/河北/秦皇岛/山海关', '区', 4, 'shg', 'shanhaiguan', 'null', '066200'),
(57, '001003003003', '北戴河', '001003003', 21, '中国/河北/秦皇岛/北戴河', '区', 4, 'bdh', 'beidaihe', 'null', '066100'),
(58, '001003003004', '昌黎', '001003003', 21, '中国/河北/秦皇岛/昌黎', '县', 4, 'cl', 'changli', 'null', '066600'),
(59, '001003003005', '抚宁', '001003003', 21, '中国/河北/秦皇岛/抚宁', '县', 4, 'fn', 'funing', 'null', '066300'),
(60, '001003003006', '卢龙', '001003003', 21, '中国/河北/秦皇岛/卢龙', '县', 4, 'll', 'lulong', 'null', '066400'),
(61, '001003003007', '青龙', '001003003', 21, '中国/河北/秦皇岛/青龙', '满族自治县', 4, 'qlmzzz', 'qinglongman', 'null', '066500'),
(62, '001003004001', '丛台', '001003004', 22, '中国/河北/邯郸/丛台', '区', 4, 'ct', 'congtai', 'null', '056004'),
(63, '001003004002', '邯山', '001003004', 22, '中国/河北/邯郸/邯山', '区', 4, 'hs', 'hanshan', 'null', '056001'),
(64, '001003004003', '复兴', '001003004', 22, '中国/河北/邯郸/复兴', '区', 4, 'fx', 'fuxing', 'null', '056003'),
(65, '001003004004', '峰峰', '001003004', 22, '中国/河北/邯郸/峰峰', '矿区', 4, 'ffk', 'fengfengkua', 'null', '056200'),
(66, '001003004005', '武安', '001003004', 22, '中国/河北/邯郸/武安', '市', 4, 'wa', 'wuan', 'null', '056300'),
(67, '001003004006', '邯郸', '001003004', 22, '中国/河北/邯郸/邯郸', '县', 4, 'hd', 'handan', 'null', '056100'),
(68, '001003004007', '临漳', '001003004', 22, '中国/河北/邯郸/临漳', '县', 4, 'lz', 'linzhang', 'null', '056600'),
(69, '001003004008', '成安', '001003004', 22, '中国/河北/邯郸/成安', '县', 4, 'ca', 'chengan', 'null', '056700'),
(70, '001003004009', '大名', '001003004', 22, '中国/河北/邯郸/大名', '县', 4, 'dm', 'daming', 'null', '056900'),
(71, '001003004010', '涉县', '001003004', 22, '中国/河北/邯郸/涉县', 'null', 4, 's', 'she', 'null', '056500'),
(72, '001003004011', '磁县', '001003004', 22, '中国/河北/邯郸/磁县', 'null', 4, 'c', 'ci', 'null', '056600'),
(73, '001003004012', '肥乡', '001003004', 22, '中国/河北/邯郸/肥乡', '县', 4, 'fx', 'feixiang', 'null', '057550'),
(74, '001003004013', '永年', '001003004', 22, '中国/河北/邯郸/永年', '县', 4, 'yn', 'yongnian', 'null', '057150'),
(75, '001003004014', '邱县', '001003004', 22, '中国/河北/邯郸/邱县', 'null', 4, 'q', 'qiu', 'null', '057450'),
(76, '001003004015', '鸡泽', '001003004', 22, '中国/河北/邯郸/鸡泽', '县', 4, 'jz', 'jize', 'null', '057350'),
(77, '001003004016', '广平', '001003004', 22, '中国/河北/邯郸/广平', '县', 4, 'gp', 'guangping', 'null', '057650'),
(78, '001003004017', '馆陶', '001003004', 22, '中国/河北/邯郸/馆陶', '县', 4, 'gt', 'guantao', 'null', '057750'),
(79, '001003004018', '魏县', '001003004', 22, '中国/河北/邯郸/魏县', 'null', 4, 'w', 'wei', 'null', '056800'),
(80, '001003004019', '曲周', '001003004', 22, '中国/河北/邯郸/曲周', '县', 4, 'qz', 'quzhou', 'null', '057250'),
(81, '001003005001', '桥东', '001003005', 23, '中国/河北/邢台/桥东', '区', 4, 'qd', 'qiaodong', 'null', '054001'),
(82, '001003005002', '桥西', '001003005', 23, '中国/河北/邢台/桥西', '区', 4, 'qx', 'qiaoxi', 'null', '054000'),
(83, '001003005003', '南宫', '001003005', 23, '中国/河北/邢台/南宫', '市', 4, 'ng', 'nangong', 'null', '055750'),
(84, '001003005004', '沙河', '001003005', 23, '中国/河北/邢台/沙河', '市', 4, 'sh', 'shahe', 'null', '054100'),
(85, '001003005005', '邢台', '001003005', 23, '中国/河北/邢台/邢台', '县', 4, 'xt', 'xingtai', 'null', '054001'),
(86, '001003005006', '临城', '001003005', 23, '中国/河北/邢台/临城', '县', 4, 'lc', 'lincheng', 'null', '054300'),
(87, '001003005007', '内丘', '001003005', 23, '中国/河北/邢台/内丘', '县', 4, 'nq', 'neiqiu', 'null', '054200'),
(88, '001003005008', '柏乡', '001003005', 23, '中国/河北/邢台/柏乡', '县', 4, 'bx', 'baixiang', 'null', '055450'),
(89, '001003005009', '隆尧', '001003005', 23, '中国/河北/邢台/隆尧', '县', 4, 'ly', 'longyao', 'null', '055350'),
(90, '001003005010', '任县', '001003005', 23, '中国/河北/邢台/任县', 'null', 4, 'r', 'ren', 'null', '055150'),
(91, '001003005011', '南和', '001003005', 23, '中国/河北/邢台/南和', '县', 4, 'nh', 'nanhe', 'null', '054400'),
(92, '001003005012', '宁晋', '001003005', 23, '中国/河北/邢台/宁晋', '县', 4, 'nj', 'ningjin', 'null', '055550'),
(93, '001003005013', '巨鹿', '001003005', 23, '中国/河北/邢台/巨鹿', '县', 4, 'jl', 'julu', 'null', '055250'),
(94, '001003005014', '新河', '001003005', 23, '中国/河北/邢台/新河', '县', 4, 'xh', 'xinhe', 'null', '051730'),
(95, '001003005015', '广宗', '001003005', 23, '中国/河北/邢台/广宗', '县', 4, 'gz', 'guangzong', 'null', '054600'),
(96, '001003005016', '平乡', '001003005', 23, '中国/河北/邢台/平乡', '县', 4, 'px', 'pingxiang', 'null', '054500'),
(97, '001003005017', '威县', '001003005', 23, '中国/河北/邢台/威县', 'null', 4, 'w', 'wei', 'null', '054700'),
(98, '001003005018', '清河', '001003005', 23, '中国/河北/邢台/清河', '县', 4, 'qh', 'qinghe', 'null', '054800'),
(99, '001003005019', '临西', '001003005', 23, '中国/河北/邢台/临西', '县', 4, 'lx', 'linxi', 'null', '054900'),
(100, '001003006001', '新市', '001003006', 24, '中国/河北/保定/新市', '区', 4, 'x', 'xin', 'null', '071052'),
(101, '001003006002', '北市', '001003006', 24, '中国/河北/保定/北市', '区', 4, 'b', 'bei', 'null', '071000'),
(102, '001003006003', '南市', '001003006', 24, '中国/河北/保定/南市', '区', 4, 'n', 'nan', 'null', '071000'),
(103, '001003006004', '定州', '001003006', 24, '中国/河北/保定/定州', '市', 4, 'dz', 'dingzhou', 'null', '073000'),
(104, '001003006005', '涿州', '001003006', 24, '中国/河北/保定/涿州', '市', 4, 'zz', 'zhuzhou', 'null', '072750'),
(105, '001003006006', '安国', '001003006', 24, '中国/河北/保定/安国', '市', 4, 'ag', 'anguo', 'null', '071200'),
(106, '001003006007', '高碑店', '001003006', 24, '中国/河北/保定/高碑店', '市', 4, 'gbd', 'gaobeidian', 'null', '074000'),
(107, '001003006008', '满城', '001003006', 24, '中国/河北/保定/满城', '县', 4, 'mc', 'mancheng', 'null', '072150'),
(108, '001003006009', '清苑', '001003006', 24, '中国/河北/保定/清苑', '县', 4, 'qy', 'qingyuan', 'null', '071100'),
(109, '001003006010', '易县', '001003006', 24, '中国/河北/保定/易县', 'null', 4, 'y', 'yi', 'null', '074200'),
(110, '001003006011', '徐水', '001003006', 24, '中国/河北/保定/徐水', '县', 4, 'xs', 'xushui', 'null', '072550'),
(111, '001003006012', '涞源', '001003006', 24, '中国/河北/保定/涞源', '县', 4, 'y', 'yuan', 'null', '074300'),
(112, '001003006013', '定兴', '001003006', 24, '中国/河北/保定/定兴', '县', 4, 'dx', 'dingxing', 'null', '074200'),
(113, '001003006014', '顺平', '001003006', 24, '中国/河北/保定/顺平', '县', 4, 'sp', 'shunping', 'null', '072250'),
(114, '001003006015', '唐县', '001003006', 24, '中国/河北/保定/唐县', 'null', 4, 't', 'tang', 'null', '072350'),
(115, '001003006016', '望都', '001003006', 24, '中国/河北/保定/望都', '县', 4, 'wd', 'wangdu', 'null', '072450'),
(116, '001003006017', '涞水', '001003006', 24, '中国/河北/保定/涞水', '县', 4, 's', 'shui', 'null', '074100'),
(117, '001003006018', '高阳', '001003006', 24, '中国/河北/保定/高阳', '县', 4, 'gy', 'gaoyang', 'null', '071500'),
(118, '001003006019', '安新', '001003006', 24, '中国/河北/保定/安新', '县', 4, 'ax', 'anxin', 'null', '071600'),
(119, '001003006020', '雄县', '001003006', 24, '中国/河北/保定/雄县', 'null', 4, 'x', 'xiong', 'null', '071800'),
(120, '001003006021', '容城', '001003006', 24, '中国/河北/保定/容城', '县', 4, 'rc', 'rongcheng', 'null', '071700'),
(121, '001003006022', '曲阳', '001003006', 24, '中国/河北/保定/曲阳', '县', 4, 'qy', 'quyang', 'null', '073100'),
(122, '001003006023', '阜平', '001003006', 24, '中国/河北/保定/阜平', '县', 4, 'fp', 'fuping', 'null', '073200'),
(123, '001003006024', '博野', '001003006', 24, '中国/河北/保定/博野', '县', 4, 'by', 'boye', 'null', '071300'),
(124, '001003006025', '蠡县', '001003006', 24, '中国/河北/保定/蠡县', 'null', 4, 'null', 'null', 'null', '071400'),
(125, '001003007001', '桥西', '001003007', 25, '中国/河北/张家口/桥西', '区', 4, 'qx', 'qiaoxi', 'null', '075061'),
(126, '001003007002', '桥东', '001003007', 25, '中国/河北/张家口/桥东', '区', 4, 'qd', 'qiaodong', 'null', '075000'),
(127, '001003007003', '宣化', '001003007', 25, '中国/河北/张家口/宣化', '区', 4, 'xh', 'xuanhua', 'null', '075100'),
(128, '001003007004', '下花园', '001003007', 25, '中国/河北/张家口/下花园', '区', 4, 'xhy', 'xiahuayuan', 'null', '075300'),
(129, '001003007005', '宣化', '001003007', 25, '中国/河北/张家口/宣化', '县', 4, 'xh', 'xuanhua', 'null', '075100'),
(130, '001003007006', '张北', '001003007', 25, '中国/河北/张家口/张北', '县', 4, 'zb', 'zhangbei', 'null', '076450'),
(131, '001003007007', '康保', '001003007', 25, '中国/河北/张家口/康保', '县', 4, 'kb', 'kangbao', 'null', '076650'),
(132, '001003007008', '沽源', '001003007', 25, '中国/河北/张家口/沽源', '县', 4, 'gy', 'guyuan', 'null', '076550'),
(133, '001003007009', '尚义', '001003007', 25, '中国/河北/张家口/尚义', '县', 4, 'sy', 'shangyi', 'null', '076750'),
(134, '001003007010', '蔚县', '001003007', 25, '中国/河北/张家口/蔚县', 'null', 4, 'w', 'wei', 'null', '075700'),
(135, '001003007011', '阳原', '001003007', 25, '中国/河北/张家口/阳原', '县', 4, 'yy', 'yangyuan', 'null', '075800'),
(136, '001003007012', '怀安', '001003007', 25, '中国/河北/张家口/怀安', '县', 4, 'ha', 'huaian', 'null', '076150'),
(137, '001003007013', '万全', '001003007', 25, '中国/河北/张家口/万全', '县', 4, 'wq', 'wanquan', 'null', '076250'),
(138, '001003007014', '怀来', '001003007', 25, '中国/河北/张家口/怀来', '县', 4, 'hl', 'huailai', 'null', '075400'),
(139, '001003007015', '涿鹿', '001003007', 25, '中国/河北/张家口/涿鹿', '县', 4, 'l', 'lu', 'null', '075600'),
(140, '001003007016', '赤城', '001003007', 25, '中国/河北/张家口/赤城', '县', 4, 'cc', 'chicheng', 'null', '075500'),
(141, '001003007017', '崇礼', '001003007', 25, '中国/河北/张家口/崇礼', '县', 4, 'cl', 'chongli', 'null', '076350'),
(142, '001003008001', '双桥', '001003008', 26, '中国/河北/承德/双桥', '区', 4, 'sq', 'shuangqiao', 'null', '067000'),
(143, '001003008002', '双滦', '001003008', 26, '中国/河北/承德/双滦', '区', 4, 'sl', 'shuangluan', 'null', '067000'),
(144, '001003008003', '鹰手营子矿区', '001003008', 26, '中国/河北/承德/鹰手营子矿区', 'null', 4, 'ysyzk', 'yingshouyin', 'null', '067000'),
(145, '001003008004', '承德', '001003008', 26, '中国/河北/承德/承德', '县', 4, 'cd', 'chengde', 'null', '067400'),
(146, '001003008005', '兴隆', '001003008', 26, '中国/河北/承德/兴隆', '县', 4, 'xl', 'xinglong', 'null', '067300'),
(147, '001003008006', '平泉', '001003008', 26, '中国/河北/承德/平泉', '县', 4, 'pq', 'pingquan', 'null', '067500'),
(148, '001003008007', '滦平', '001003008', 26, '中国/河北/承德/滦平', '县', 4, 'lp', 'luanping', 'null', '068250'),
(149, '001003008008', '隆化', '001003008', 26, '中国/河北/承德/隆化', '县', 4, 'lh', 'longhua', 'null', '068150'),
(150, '001003008009', '丰宁', '001003008', 26, '中国/河北/承德/丰宁', '满族自治县', 4, 'fnmzzz', 'fengningman', 'null', '068350'),
(151, '001003008010', '宽城', '001003008', 26, '中国/河北/承德/宽城', '满族自治县', 4, 'kcmzzz', 'kuanchengma', 'null', '067600'),
(152, '001003008011', '围场', '001003008', 26, '中国/河北/承德/围场', '满族蒙古族自治县', 4, 'wcmzmgzzz', 'weichangman', 'null', '068450'),
(153, '001003009001', '运河', '001003009', 27, '中国/河北/沧州/运河', '区', 4, 'yh', 'yunhe', 'null', '061000'),
(154, '001003009002', '新华', '001003009', 27, '中国/河北/沧州/新华', '区', 4, 'xh', 'xinhua', 'null', '061000'),
(155, '001003009003', '泊头', '001003009', 27, '中国/河北/沧州/泊头', '市', 4, 'bt', 'botou', 'null', '062150'),
(156, '001003009004', '任丘', '001003009', 27, '中国/河北/沧州/任丘', '市', 4, 'rq', 'renqiu', 'null', '062550'),
(157, '001003009005', '黄骅', '001003009', 27, '中国/河北/沧州/黄骅', '市', 4, 'h', 'huang', 'null', '061100'),
(158, '001003009006', '河间', '001003009', 27, '中国/河北/沧州/河间', '市', 4, 'hj', 'hejian', 'null', '062450'),
(159, '001003009007', '沧县', '001003009', 27, '中国/河北/沧州/沧县', 'null', 4, 'c', 'cang', 'null', '061000'),
(160, '001003009008', '青县', '001003009', 27, '中国/河北/沧州/青县', 'null', 4, 'q', 'qing', 'null', '062650'),
(161, '001003009009', '东光', '001003009', 27, '中国/河北/沧州/东光', '县', 4, 'dg', 'dongguang', 'null', '061600'),
(162, '001003009010', '海兴', '001003009', 27, '中国/河北/沧州/海兴', '县', 4, 'hx', 'haixing', 'null', '061200'),
(163, '001003009011', '盐山', '001003009', 27, '中国/河北/沧州/盐山', '县', 4, 'ys', 'yanshan', 'null', '061300'),
(164, '001003009012', '肃宁', '001003009', 27, '中国/河北/沧州/肃宁', '县', 4, 'sn', 'suning', 'null', '062350'),
(165, '001003009013', '南皮', '001003009', 27, '中国/河北/沧州/南皮', '县', 4, 'np', 'nanpi', 'null', '061500'),
(166, '001003009014', '吴桥', '001003009', 27, '中国/河北/沧州/吴桥', '县', 4, 'wq', 'wuqiao', 'null', '061800'),
(167, '001003009015', '献县', '001003009', 27, '中国/河北/沧州/献县', 'null', 4, 'x', 'xian', 'null', '062250'),
(168, '001003009016', '孟村', '001003009', 27, '中国/河北/沧州/孟村', '回族自治县', 4, 'mczz', 'mengcunzizh', 'null', '061400'),
(169, '001003010001', '安次', '001003010', 28, '中国/河北/廊坊/安次', '区', 4, 'ac', 'anci', 'null', '065000'),
(170, '001003010002', '广阳', '001003010', 28, '中国/河北/廊坊/广阳', '区', 4, 'gy', 'guangyang', 'null', '065000'),
(171, '001003010003', '霸州', '001003010', 28, '中国/河北/廊坊/霸州', '市', 4, 'bz', 'bazhou', 'null', '065700'),
(172, '001003010004', '三河', '001003010', 28, '中国/河北/廊坊/三河', '市', 4, 'sh', 'sanhe', 'null', '065200'),
(173, '001003010005', '固安', '001003010', 28, '中国/河北/廊坊/固安', '县', 4, 'ga', 'guan', 'null', '065500'),
(174, '001003010006', '永清', '001003010', 28, '中国/河北/廊坊/永清', '县', 4, 'yq', 'yongqing', 'null', '065600'),
(175, '001003010007', '香河', '001003010', 28, '中国/河北/廊坊/香河', '县', 4, 'xh', 'xianghe', 'null', '065400'),
(176, '001003010008', '大城', '001003010', 28, '中国/河北/廊坊/大城', '县', 4, 'dc', 'dacheng', 'null', '065900'),
(177, '001003010009', '文安', '001003010', 28, '中国/河北/廊坊/文安', '县', 4, 'wa', 'wenan', 'null', '065800'),
(178, '001003010010', '大厂', '001003010', 28, '中国/河北/廊坊/大厂', '回族自治县', 4, 'dczz', 'dachangzizh', 'null', '065300'),
(179, '001003011001', '桃城', '001003011', 29, '中国/河北/衡水/桃城', '区', 4, 'tc', 'taocheng', 'null', '053000'),
(180, '001003011002', '冀州', '001003011', 29, '中国/河北/衡水/冀州', '市', 4, 'jz', 'jizhou', 'null', '053200'),
(181, '001003011003', '深州', '001003011', 29, '中国/河北/衡水/深州', '市', 4, 'sz', 'shenzhou', 'null', '053800'),
(182, '001003011004', '枣强', '001003011', 29, '中国/河北/衡水/枣强', '县', 4, 'zq', 'zaoqiang', 'null', '053100'),
(183, '001003011005', '武邑', '001003011', 29, '中国/河北/衡水/武邑', '县', 4, 'wy', 'wuyi', 'null', '053400'),
(184, '001003011006', '武强', '001003011', 29, '中国/河北/衡水/武强', '县', 4, 'wq', 'wuqiang', 'null', '053300'),
(185, '001003011007', '饶阳', '001003011', 29, '中国/河北/衡水/饶阳', '县', 4, 'ry', 'raoyang', 'null', '053900'),
(186, '001003011008', '安平', '001003011', 29, '中国/河北/衡水/安平', '县', 4, 'ap', 'anping', 'null', '053600'),
(187, '001003011009', '故城', '001003011', 29, '中国/河北/衡水/故城', '县', 4, 'gc', 'gucheng', 'null', '053800'),
(188, '001003011010', '景县', '001003011', 29, '中国/河北/衡水/景县', 'null', 4, 'j', 'jing', 'null', '053500'),
(189, '001003011011', '阜城', '001003011', 29, '中国/河北/衡水/阜城', '县', 4, 'fc', 'fucheng', 'null', '053700'),
(190, '001004001001', '小店', '001004001', 30, '中国/山西/太原/小店', '区', 4, 'xd', 'xiaodian', 'null', '030032'),
(191, '001004001002', '迎泽', '001004001', 30, '中国/山西/太原/迎泽', '区', 4, 'yz', 'yingze', 'null', '030024'),
(192, '001004001003', '尖草坪', '001004001', 30, '中国/山西/太原/尖草坪', '区', 4, 'jcp', 'jiancaoping', 'null', '030003'),
(193, '001004001004', '万柏林', '001004001', 30, '中国/山西/太原/万柏林', '区', 4, 'wbl', 'wanbailin', 'null', '030027'),
(194, '001004001005', '晋源', '001004001', 30, '中国/山西/太原/晋源', '区', 4, 'jy', 'jinyuan', 'null', '030025'),
(195, '001004001006', '古交', '001004001', 30, '中国/山西/太原/古交', '市', 4, 'gj', 'gujiao', 'null', '030200'),
(196, '001004001007', '清徐', '001004001', 30, '中国/山西/太原/清徐', '县', 4, 'qx', 'qingxu', 'null', '030400'),
(197, '001004001008', '阳曲', '001004001', 30, '中国/山西/太原/阳曲', '县', 4, 'yq', 'yangqu', 'null', '030100'),
(198, '001004001009', '娄烦', '001004001', 30, '中国/山西/太原/娄烦', '县', 4, 'lf', 'loufan', 'null', '030300'),
(199, '001004002001', '矿区', '001004002', 31, '中国/山西/大同/矿区', 'null', 4, 'k', 'kuang', 'null', '037001'),
(200, '001004002002', '南郊', '001004002', 31, '中国/山西/大同/南郊', '区', 4, 'nj', 'nanjiao', 'null', '037001'),
(201, '001004002003', '新荣', '001004002', 31, '中国/山西/大同/新荣', '区', 4, 'xr', 'xinrong', 'null', '037002'),
(202, '001004002004', '阳高', '001004002', 31, '中国/山西/大同/阳高', '县', 4, 'yg', 'yanggao', 'null', '038100'),
(203, '001004002005', '天镇', '001004002', 31, '中国/山西/大同/天镇', '县', 4, 'tz', 'tianzhen', 'null', '038200'),
(204, '001004002006', '广灵', '001004002', 31, '中国/山西/大同/广灵', '县', 4, 'gl', 'guangling', 'null', '037500'),
(205, '001004002007', '灵丘', '001004002', 31, '中国/山西/大同/灵丘', '县', 4, 'lq', 'lingqiu', 'null', '034400'),
(206, '001004002008', '浑源', '001004002', 31, '中国/山西/大同/浑源', '县', 4, 'hy', 'hunyuan', 'null', '037400'),
(207, '001004002009', '左云', '001004002', 31, '中国/山西/大同/左云', '县', 4, 'zy', 'zuoyun', 'null', '037100'),
(208, '001004002010', '大同', '001004002', 31, '中国/山西/大同/大同', '县', 4, 'dt', 'datong', 'null', '037300'),
(209, '001004003001', '矿区', '001004003', 32, '中国/山西/阳泉/矿区', 'null', 4, 'k', 'kuang', 'null', '045000'),
(210, '001004003002', '郊区', '001004003', 32, '中国/山西/阳泉/郊区', 'null', 4, 'j', 'jiao', 'null', '045011'),
(211, '001004003003', '平定', '001004003', 32, '中国/山西/阳泉/平定', '县', 4, 'pd', 'pingding', 'null', '045200'),
(212, '001004003004', '盂县', '001004003', 32, '中国/山西/阳泉/盂县', 'null', 4, 'y', 'yu', 'null', '045100'),
(213, '001004004001', '郊区', '001004004', 33, '中国/山西/长治/郊区', 'null', 4, 'j', 'jiao', 'null', '046011'),
(214, '001004004002', '潞城', '001004004', 33, '中国/山西/长治/潞城', '市', 4, 'lc', 'lucheng', 'null', '047500'),
(215, '001004004003', '长治', '001004004', 33, '中国/山西/长治/长治', '县', 4, 'cz', 'changzhi', 'null', '047100'),
(216, '001004004004', '襄垣', '001004004', 33, '中国/山西/长治/襄垣', '县', 4, 'xy', 'xiangyuan', 'null', '046200'),
(217, '001004004005', '屯留', '001004004', 33, '中国/山西/长治/屯留', '县', 4, 'tl', 'tunliu', 'null', '046100'),
(218, '001004004006', '平顺', '001004004', 33, '中国/山西/长治/平顺', '县', 4, 'ps', 'pingshun', 'null', '047400'),
(219, '001004004007', '黎城', '001004004', 33, '中国/山西/长治/黎城', '县', 4, 'lc', 'licheng', 'null', '047600'),
(220, '001004004008', '壶关', '001004004', 33, '中国/山西/长治/壶关', '县', 4, 'hg', 'huguan', 'null', '047300'),
(221, '001004004009', '长子', '001004004', 33, '中国/山西/长治/长子', '县', 4, 'cz', 'changzi', 'null', '046600'),
(222, '001004004010', '武乡', '001004004', 33, '中国/山西/长治/武乡', '县', 4, 'wx', 'wuxiang', 'null', '046300'),
(223, '001004004011', '沁县', '001004004', 33, '中国/山西/长治/沁县', 'null', 4, 'q', 'qin', 'null', '046400'),
(224, '001004004012', '沁源', '001004004', 33, '中国/山西/长治/沁源', '县', 4, 'qy', 'qinyuan', 'null', '046500'),
(225, '001004005001', '高平', '001004005', 34, '中国/山西/晋城/高平', '市', 4, 'gp', 'gaoping', 'null', '048400'),
(226, '001004005002', '泽州', '001004005', 34, '中国/山西/晋城/泽州', '县', 4, 'zz', 'zezhou', 'null', '048012'),
(227, '001004005003', '沁水', '001004005', 34, '中国/山西/晋城/沁水', '县', 4, 'qs', 'qinshui', 'null', '048200'),
(228, '001004005004', '阳城', '001004005', 34, '中国/山西/晋城/阳城', '县', 4, 'yc', 'yangcheng', 'null', '048100'),
(229, '001004005005', '陵川', '001004005', 34, '中国/山西/晋城/陵川', '县', 4, 'lc', 'lingchuan', 'null', '048300'),
(230, '001004006001', '平鲁', '001004006', 35, '中国/山西/朔州/平鲁', '区', 4, 'pl', 'pinglu', 'null', '038600'),
(231, '001004006002', '山阴', '001004006', 35, '中国/山西/朔州/山阴', '县', 4, 'sy', 'shanyin', 'null', '036900'),
(232, '001004006003', '应县', '001004006', 35, '中国/山西/朔州/应县', 'null', 4, 'y', 'ying', 'null', '037600'),
(233, '001004006004', '右玉', '001004006', 35, '中国/山西/朔州/右玉', '县', 4, 'yy', 'youyu', 'null', '037200'),
(234, '001004006005', '怀仁', '001004006', 35, '中国/山西/朔州/怀仁', '县', 4, 'hr', 'huairen', 'null', '038300'),
(235, '001004007001', '介休', '001004007', 36, '中国/山西/晋中/介休', '市', 4, 'jx', 'jiexiu', 'null', '031200'),
(236, '001004007002', '榆社', '001004007', 36, '中国/山西/晋中/榆社', '县', 4, 'ys', 'yushe', 'null', '031800'),
(237, '001004007003', '左权', '001004007', 36, '中国/山西/晋中/左权', '县', 4, 'zq', 'zuoquan', 'null', '032600'),
(238, '001004007004', '和顺', '001004007', 36, '中国/山西/晋中/和顺', '县', 4, 'hs', 'heshun', 'null', '032700'),
(239, '001004007005', '昔阳', '001004007', 36, '中国/山西/晋中/昔阳', '县', 4, 'xy', 'xiyang', 'null', '045400'),
(240, '001004007006', '寿阳', '001004007', 36, '中国/山西/晋中/寿阳', '县', 4, 'sy', 'shouyang', 'null', '045400'),
(241, '001004007007', '太谷', '001004007', 36, '中国/山西/晋中/太谷', '县', 4, 'tg', 'taigu', 'null', '030800'),
(242, '001004007008', '祁县', '001004007', 36, '中国/山西/晋中/祁县', 'null', 4, 'q', 'qi', 'null', '030900'),
(243, '001004007009', '平遥', '001004007', 36, '中国/山西/晋中/平遥', '县', 4, 'py', 'pingyao', 'null', '031100'),
(244, '001004007010', '灵石', '001004007', 36, '中国/山西/晋中/灵石', '县', 4, 'ls', 'lingshi', 'null', '031300'),
(245, '001004008001', '永济', '001004008', 37, '中国/山西/运城/永济', '市', 4, 'yj', 'yongji', 'null', '044500'),
(246, '001004008002', '河津', '001004008', 37, '中国/山西/运城/河津', '市', 4, 'hj', 'hejin', 'null', '043300'),
(247, '001004008003', '芮城', '001004008', 37, '中国/山西/运城/芮城', '县', 4, 'c', 'cheng', 'null', '044600'),
(248, '001004008004', '临猗', '001004008', 37, '中国/山西/运城/临猗', '县', 4, 'l', 'lin', 'null', '044100'),
(249, '001004008005', '万荣', '001004008', 37, '中国/山西/运城/万荣', '县', 4, 'wr', 'wanrong', 'null', '044200'),
(250, '001004008006', '新绛', '001004008', 37, '中国/山西/运城/新绛', '县', 4, 'x', 'xin', 'null', '043100'),
(251, '001004008007', '稷山', '001004008', 37, '中国/山西/运城/稷山', '县', 4, 's', 'shan', 'null', '043200'),
(252, '001004008008', '闻喜', '001004008', 37, '中国/山西/运城/闻喜', '县', 4, 'wx', 'wenxi', 'null', '043800'),
(253, '001004008009', '夏县', '001004008', 37, '中国/山西/运城/夏县', 'null', 4, 'x', 'xia', 'null', '044400'),
(254, '001004008010', '绛县', '001004008', 37, '中国/山西/运城/绛县', 'null', 4, 'null', 'null', 'null', '043600'),
(255, '001004008011', '平陆', '001004008', 37, '中国/山西/运城/平陆', '县', 4, 'pl', 'pinglu', 'null', '044300'),
(256, '001004008012', '垣曲', '001004008', 37, '中国/山西/运城/垣曲', '县', 4, 'yq', 'yuanqu', 'null', '043700'),
(257, '001004009001', '原平', '001004009', 38, '中国/山西/忻州/原平', '市', 4, 'yp', 'yuanping', 'null', '034100'),
(258, '001004009002', '定襄', '001004009', 38, '中国/山西/忻州/定襄', '县', 4, 'dx', 'dingxiang', 'null', '035400'),
(259, '001004009003', '五台', '001004009', 38, '中国/山西/忻州/五台', '县', 4, 'wt', 'wutai', 'null', '035500'),
(260, '001004009004', '代县', '001004009', 38, '中国/山西/忻州/代县', 'null', 4, 'd', 'dai', 'null', '034200'),
(261, '001004009005', '繁峙', '001004009', 38, '中国/山西/忻州/繁峙', '县', 4, 'fz', 'fanzhi', 'null', '034300'),
(262, '001004009006', '宁武', '001004009', 38, '中国/山西/忻州/宁武', '县', 4, 'nw', 'ningwu', 'null', '036700'),
(263, '001004009007', '静乐', '001004009', 38, '中国/山西/忻州/静乐', '县', 4, 'jl', 'jingle', 'null', '035100'),
(264, '001004009008', '神池', '001004009', 38, '中国/山西/忻州/神池', '县', 4, 'sc', 'shenchi', 'null', '036100'),
(265, '001004009009', '五寨', '001004009', 38, '中国/山西/忻州/五寨', '县', 4, 'wz', 'wuzhai', 'null', '036200'),
(266, '001004009010', '岢岚', '001004009', 38, '中国/山西/忻州/岢岚', '县', 4, 'null', 'null', 'null', '036300'),
(267, '001004009011', '河曲', '001004009', 38, '中国/山西/忻州/河曲', '县', 4, 'hq', 'hequ', 'null', '036500'),
(268, '001004009012', '保德', '001004009', 38, '中国/山西/忻州/保德', '县', 4, 'bd', 'baode', 'null', '036600'),
(269, '001004009013', '偏关', '001004009', 38, '中国/山西/忻州/偏关', '县', 4, 'pg', 'pianguan', 'null', '036400'),
(270, '001004010001', '侯马', '001004010', 39, '中国/山西/临汾/侯马', '市', 4, 'hm', 'houma', 'null', '043000'),
(271, '001004010002', '霍州', '001004010', 39, '中国/山西/临汾/霍州', '市', 4, 'hz', 'huozhou', 'null', '031400'),
(272, '001004010003', '曲沃', '001004010', 39, '中国/山西/临汾/曲沃', '县', 4, 'qw', 'quwo', 'null', '043400'),
(273, '001004010004', '翼城', '001004010', 39, '中国/山西/临汾/翼城', '县', 4, 'yc', 'yicheng', 'null', '043500'),
(274, '001004010005', '襄汾', '001004010', 39, '中国/山西/临汾/襄汾', '县', 4, 'xf', 'xiangfen', 'null', '041500'),
(275, '001004010006', '洪洞', '001004010', 39, '中国/山西/临汾/洪洞', '县', 4, 'hd', 'hongdong', 'null', '031600'),
(276, '001004010007', '古县', '001004010', 39, '中国/山西/临汾/古县', 'null', 4, 'g', 'gu', 'null', '042400'),
(277, '001004010008', '安泽', '001004010', 39, '中国/山西/临汾/安泽', '县', 4, 'az', 'anze', 'null', '042500'),
(278, '001004010009', '浮山', '001004010', 39, '中国/山西/临汾/浮山', '县', 4, 'fs', 'fushan', 'null', '042600'),
(279, '001004010010', '吉县', '001004010', 39, '中国/山西/临汾/吉县', 'null', 4, 'j', 'ji', 'null', '042200'),
(280, '001004010011', '乡宁', '001004010', 39, '中国/山西/临汾/乡宁', '县', 4, 'xn', 'xiangning', 'null', '042100'),
(281, '001004010012', '蒲县', '001004010', 39, '中国/山西/临汾/蒲县', 'null', 4, 'p', 'pu', 'null', '041200'),
(282, '001004010013', '大宁', '001004010', 39, '中国/山西/临汾/大宁', '县', 4, 'dn', 'daning', 'null', '042300'),
(283, '001004010014', '永和', '001004010', 39, '中国/山西/临汾/永和', '县', 4, 'yh', 'yonghe', 'null', '041400'),
(284, '001004010015', '隰县', '001004010', 39, '中国/山西/临汾/隰县', 'null', 4, 'null', 'null', 'null', '041300'),
(285, '001004010016', '汾西', '001004010', 39, '中国/山西/临汾/汾西', '县', 4, 'fx', 'fenxi', 'null', '031500'),
(286, '001004011001', '孝义', '001004011', 40, '中国/山西/吕梁地/孝义', '市', 4, 'xy', 'xiaoyi', 'null', '032300'),
(287, '001004011002', '汾阳', '001004011', 40, '中国/山西/吕梁地/汾阳', '市', 4, 'fy', 'fenyang', 'null', '032200'),
(288, '001004011003', '文水', '001004011', 40, '中国/山西/吕梁地/文水', '县', 4, 'ws', 'wenshui', 'null', '032100'),
(289, '001004011004', '中阳', '001004011', 40, '中国/山西/吕梁地/中阳', '县', 4, 'zy', 'zhongyang', 'null', '033400'),
(290, '001004011005', '兴县', '001004011', 40, '中国/山西/吕梁地/兴县', 'null', 4, 'x', 'xing', 'null', '033600'),
(291, '001004011006', '临县', '001004011', 40, '中国/山西/吕梁地/临县', 'null', 4, 'l', 'lin', 'null', '033200'),
(292, '001004011007', '方山', '001004011', 40, '中国/山西/吕梁地/方山', '县', 4, 'fs', 'fangshan', 'null', '033100'),
(293, '001004011008', '柳林', '001004011', 40, '中国/山西/吕梁地/柳林', '县', 4, 'll', 'liulin', 'null', '033300'),
(294, '001004011009', '岚县', '001004011', 40, '中国/山西/吕梁地/岚县', 'null', 4, 'null', 'null', 'null', '033500'),
(295, '001004011010', '交口', '001004011', 40, '中国/山西/吕梁地/交口', '县', 4, 'jk', 'jiaokou', 'null', '032400'),
(296, '001004011011', '交城', '001004011', 40, '中国/山西/吕梁地/交城', '县', 4, 'jc', 'jiaocheng', 'null', '030500'),
(297, '001004011012', '石楼', '001004011', 40, '中国/山西/吕梁地/石楼', '县', 4, 'sl', 'shilou', 'null', '032500'),
(298, '001005001001', '回民', '001005001', 41, '中国/内蒙古/呼和浩特/回民', '区', 4, 'hm', 'huimin', 'null', '010030'),
(299, '001005001002', '新城', '001005001', 41, '中国/内蒙古/呼和浩特/新城', '区', 4, 'xc', 'xincheng', 'null', '010010'),
(300, '001005001003', '玉泉', '001005001', 41, '中国/内蒙古/呼和浩特/玉泉', '区', 4, 'yq', 'yuquan', 'null', '010031'),
(301, '001005001004', '赛罕', '001005001', 41, '中国/内蒙古/呼和浩特/赛罕', '区', 4, 'sh', 'saihan', 'null', '010020'),
(302, '001005001005', '托克托', '001005001', 41, '中国/内蒙古/呼和浩特/托克托', '县', 4, 'tkt', 'tuoketuo', 'null', '010200'),
(303, '001005001006', '武川', '001005001', 41, '中国/内蒙古/呼和浩特/武川', '县', 4, 'wc', 'wuchuan', 'null', '011700'),
(304, '001005001007', '和林格尔', '001005001', 41, '中国/内蒙古/呼和浩特/和林格尔', '县', 4, 'hlge', 'helingeer', 'null', '011500'),
(305, '001005001008', '清水河', '001005001', 41, '中国/内蒙古/呼和浩特/清水河', '县', 4, 'qsh', 'qingshuihe', 'null', '011600'),
(306, '001005001009', '土默特左旗', '001005001', 41, '中国/内蒙古/呼和浩特/土默特左旗', '左旗', 4, 'tmtzq', 'tumotezuoqi', 'null', '010100'),
(307, '001005002001', '昆都仑', '001005002', 42, '中国/内蒙古/包头/昆都仑', '区', 4, 'kdl', 'kundulun', 'null', '014010'),
(308, '001005002002', '东河', '001005002', 42, '中国/内蒙古/包头/东河', '区', 4, 'dh', 'donghe', 'null', '014040'),
(309, '001005002003', '青山', '001005002', 42, '中国/内蒙古/包头/青山', '区', 4, 'qs', 'qingshan', 'null', '014030'),
(310, '001005002004', '石拐', '001005002', 42, '中国/内蒙古/包头/石拐', '区', 4, 'sg', 'shiguai', 'null', '014070'),
(311, '001005002005', '白云矿', '001005002', 42, '中国/内蒙古/包头/白云矿', '区', 4, 'byk', 'baiyunkuang', 'null', '014080'),
(312, '001005002006', '九原', '001005002', 42, '中国/内蒙古/包头/九原', '区', 4, 'jy', 'jiuyuan', 'null', '014060'),
(313, '001005002007', '固阳', '001005002', 42, '中国/内蒙古/包头/固阳', '县', 4, 'gy', 'guyang', 'null', '014200'),
(314, '001005002008', '土默特右旗', '001005002', 42, '中国/内蒙古/包头/土默特右旗', '右旗', 4, 'tmtyq', 'tumoteyouqi', 'null', '014100'),
(315, '001005002009', '达尔罕茂明安联合旗', '001005002', 42, '中国/内蒙古/包头/达尔罕茂明安联合旗', '联合旗', 4, 'dehmmalhq', 'daerhanmaom', 'null', '014500'),
(316, '001005003001', '海勃湾', '001005003', 43, '中国/内蒙古/乌海/海勃湾', '区', 4, 'hbw', 'haibowan', 'null', '016000'),
(317, '001005003002', '乌达', '001005003', 43, '中国/内蒙古/乌海/乌达', '区', 4, 'wd', 'wuda', 'null', '016040'),
(318, '001005003003', '海南', '001005003', 43, '中国/内蒙古/乌海/海南', '区', 4, 'hn', 'hainan', 'null', '016030'),
(319, '001005004001', '红山', '001005004', 44, '中国/内蒙古/赤峰/红山', '区', 4, 'hs', 'hongshan', 'null', '024001'),
(320, '001005004002', '元宝山', '001005004', 44, '中国/内蒙古/赤峰/元宝山', '区', 4, 'ybs', 'yuanbaoshan', 'null', '024070'),
(321, '001005004003', '松山', '001005004', 44, '中国/内蒙古/赤峰/松山', '区', 4, 'ss', 'songshan', 'null', '024001'),
(322, '001005004004', '宁城', '001005004', 44, '中国/内蒙古/赤峰/宁城', '县', 4, 'nc', 'ningcheng', 'null', '024200'),
(323, '001005004005', '林西', '001005004', 44, '中国/内蒙古/赤峰/林西', '县', 4, 'lx', 'linxi', 'null', '025250'),
(324, '001005004006', '阿鲁科尔沁旗', '001005004', 44, '中国/内蒙古/赤峰/阿鲁科尔沁旗', 'null', 4, 'alkeqq', 'alukeerqinq', 'null', '025550'),
(325, '001005004007', '巴林左旗', '001005004', 44, '中国/内蒙古/赤峰/巴林左旗', 'null', 4, 'blzq', 'balinzuoqi', 'null', '025450'),
(326, '001005004008', '巴林右旗', '001005004', 44, '中国/内蒙古/赤峰/巴林右旗', 'null', 4, 'blyq', 'balinyouqi', 'null', '025150'),
(327, '001005004009', '克什克腾旗', '001005004', 44, '中国/内蒙古/赤峰/克什克腾旗', 'null', 4, 'ksktq', 'keshiketeng', 'null', '025350'),
(328, '001005004010', '翁牛特旗', '001005004', 44, '中国/内蒙古/赤峰/翁牛特旗', 'null', 4, 'wntq', 'wengniuteqi', 'null', '024500'),
(329, '001005004011', '喀喇沁旗', '001005004', 44, '中国/内蒙古/赤峰/喀喇沁旗', 'null', 4, 'klqq', 'kalaqinqi', 'null', '024400'),
(330, '001005004012', '敖汉旗', '001005004', 44, '中国/内蒙古/赤峰/敖汉旗', 'null', 4, 'ahq', 'aohanqi', 'null', '024300'),
(331, '001005005001', '科尔沁', '001005005', 45, '中国/内蒙古/通辽/科尔沁', '区', 4, 'keq', 'keerqin', 'null', '028000'),
(332, '001005005002', '霍林郭勒', '001005005', 45, '中国/内蒙古/通辽/霍林郭勒', '市', 4, 'hlgl', 'huolinguole', 'null', '029200'),
(333, '001005005003', '开鲁', '001005005', 45, '中国/内蒙古/通辽/开鲁', '县', 4, 'kl', 'kailu', 'null', '028400'),
(334, '001005005004', '库伦旗', '001005005', 45, '中国/内蒙古/通辽/库伦旗', 'null', 4, 'klq', 'kulunqi', 'null', '028200'),
(335, '001005005005', '奈曼旗', '001005005', 45, '中国/内蒙古/通辽/奈曼旗', 'null', 4, 'nmq', 'naimanqi', 'null', '028300'),
(336, '001005005006', '扎鲁特旗', '001005005', 45, '中国/内蒙古/通辽/扎鲁特旗', 'null', 4, 'zltq', 'zhaluteqi', 'null', '029100'),
(337, '001005005007', '科尔沁左翼中旗', '001005005', 45, '中国/内蒙古/通辽/科尔沁左翼中旗', 'null', 4, 'keqzyzq', 'keerqinzuoy', 'null', '029300'),
(338, '001005005008', '科尔沁左翼后旗', '001005005', 45, '中国/内蒙古/通辽/科尔沁左翼后旗', 'null', 4, 'keqzyhq', 'keerqinzuoy', 'null', '028100'),
(339, '001005006001', '东胜', '001005006', 46, '中国/内蒙古/鄂尔多斯/东胜', '区', 4, 'ds', 'dongsheng', 'null', '017000'),
(340, '001005006002', '达拉特旗', '001005006', 46, '中国/内蒙古/鄂尔多斯/达拉特旗', 'null', 4, 'dltq', 'dalateqi', 'null', '014300'),
(341, '001005006003', '准格尔旗', '001005006', 46, '中国/内蒙古/鄂尔多斯/准格尔旗', 'null', 4, 'zgeq', 'zhungeerqi', 'null', '010425'),
(342, '001005006004', '鄂托克前旗', '001005006', 46, '中国/内蒙古/鄂尔多斯/鄂托克前旗', 'null', 4, 'etkqq', 'etuokeqianq', 'null', '016200'),
(343, '001005006005', '鄂托克旗', '001005006', 46, '中国/内蒙古/鄂尔多斯/鄂托克旗', 'null', 4, 'etkq', 'etuokeqi', 'null', '016100'),
(344, '001005006006', '杭锦旗', '001005006', 46, '中国/内蒙古/鄂尔多斯/杭锦旗', 'null', 4, 'hjq', 'hangjinqi', 'null', '017400'),
(345, '001005006007', '乌审旗', '001005006', 46, '中国/内蒙古/鄂尔多斯/乌审旗', 'null', 4, 'wsq', 'wushenqi', 'null', '017300'),
(346, '001005006008', '伊金霍洛旗', '001005006', 46, '中国/内蒙古/鄂尔多斯/伊金霍洛旗', 'null', 4, 'yjhlq', 'yijinhuoluo', 'null', '017200'),
(347, '001005007001', '海拉尔', '001005007', 47, '中国/内蒙古/呼伦贝尔/海拉尔', '区', 4, 'hle', 'hailaer', 'null', '021000'),
(348, '001005007002', '满洲里', '001005007', 47, '中国/内蒙古/呼伦贝尔/满洲里', '市', 4, 'mzl', 'manzhouli', 'null', '021400'),
(349, '001005007003', '扎兰屯', '001005007', 47, '中国/内蒙古/呼伦贝尔/扎兰屯', '市', 4, 'zlt', 'zhalantun', 'null', '162650'),
(350, '001005007004', '牙克石', '001005007', 47, '中国/内蒙古/呼伦贝尔/牙克石', '市', 4, 'yks', 'yakeshi', 'null', '162650'),
(351, '001005007005', '根河', '001005007', 47, '中国/内蒙古/呼伦贝尔/根河', '市', 4, 'gh', 'genhe', 'null', '022350'),
(352, '001005007006', '额尔古纳', '001005007', 47, '中国/内蒙古/呼伦贝尔/额尔古纳', '市', 4, 'eegn', 'eerguna', 'null', '022250'),
(353, '001005007007', '阿荣旗', '001005007', 47, '中国/内蒙古/呼伦贝尔/阿荣旗', 'null', 4, 'arq', 'arongqi', 'null', '162750'),
(354, '001005007008', '新巴尔虎右旗', '001005007', 47, '中国/内蒙古/呼伦贝尔/新巴尔虎右旗', 'null', 4, 'xbehyq', 'xinbaerhuyo', 'null', '021300'),
(355, '001005007009', '新巴尔虎左旗', '001005007', 47, '中国/内蒙古/呼伦贝尔/新巴尔虎左旗', 'null', 4, 'xbehzq', 'xinbaerhuzu', 'null', '021200'),
(356, '001005007010', '陈巴尔虎旗', '001005007', 47, '中国/内蒙古/呼伦贝尔/陈巴尔虎旗', 'null', 4, 'cbehq', 'chenbaerhuq', 'null', '021500'),
(357, '001005007011', '鄂伦春自治旗', '001005007', 47, '中国/内蒙古/呼伦贝尔/鄂伦春自治旗', 'null', 4, 'elczzq', 'elunchunziz', 'null', '165450'),
(358, '001005007012', '鄂温克族自治旗', '001005007', 47, '中国/内蒙古/呼伦贝尔/鄂温克族自治旗', 'null', 4, 'ewkzzzq', 'ewenkezuziz', 'null', '021100'),
(359, '001005007013', '莫力达瓦达斡尔族自治旗', '001005007', 47, '中国/内蒙古/呼伦贝尔/莫力达瓦达斡尔族自治旗', 'null', 4, 'mldwdwezzzq', 'molidawadaw', 'null', '162850'),
(360, '001005008001', '集宁', '001005008', 48, '中国/内蒙古/乌兰察布/集宁', '市', 4, 'jn', 'jining', 'null', '012000'),
(361, '001005008002', '丰镇', '001005008', 48, '中国/内蒙古/乌兰察布/丰镇', '市', 4, 'fz', 'fengzhen', 'null', '012100'),
(362, '001005008003', '卓资', '001005008', 48, '中国/内蒙古/乌兰察布/卓资', '县', 4, 'zz', 'zhuozi', 'null', '012300'),
(363, '001005008004', '化德', '001005008', 48, '中国/内蒙古/乌兰察布/化德', '县', 4, 'hd', 'huade', 'null', '013350'),
(364, '001005008005', '商都', '001005008', 48, '中国/内蒙古/乌兰察布/商都', '县', 4, 'sd', 'shangdu', 'null', '013450'),
(365, '001005008006', '兴和', '001005008', 48, '中国/内蒙古/乌兰察布/兴和', '县', 4, 'xh', 'xinghe', 'null', '013650'),
(366, '001005008007', '凉城', '001005008', 48, '中国/内蒙古/乌兰察布/凉城', '县', 4, 'lc', 'liangcheng', 'null', '013750'),
(367, '001005008008', '察哈尔右翼前旗', '001005008', 48, '中国/内蒙古/乌兰察布/察哈尔右翼前旗', 'null', 4, 'cheyyqq', 'chahaeryouy', 'null', '012200'),
(368, '001005008009', '察哈尔右翼中旗', '001005008', 48, '中国/内蒙古/乌兰察布/察哈尔右翼中旗', 'null', 4, 'cheyyzq', 'chahaeryouy', 'null', '013550'),
(369, '001005008010', '察哈尔右翼后旗', '001005008', 48, '中国/内蒙古/乌兰察布/察哈尔右翼后旗', 'null', 4, 'cheyyhq', 'chahaeryouy', 'null', '012400'),
(370, '001005008011', '四子王旗', '001005008', 48, '中国/内蒙古/乌兰察布/四子王旗', 'null', 4, 'szwq', 'siziwangqi', 'null', '011800'),
(371, '001005009001', '锡林浩特', '001005009', 49, '中国/内蒙古/锡林郭勒/锡林浩特', '市', 4, 'xlht', 'xilinhaote', 'null', '026021'),
(372, '001005009002', '二连浩特', '001005009', 49, '中国/内蒙古/锡林郭勒/二连浩特', '市', 4, 'elht', 'erlianhaote', 'null', '011100'),
(373, '001005009003', '多伦', '001005009', 49, '中国/内蒙古/锡林郭勒/多伦', '县', 4, 'dl', 'duolun', 'null', '027300'),
(374, '001005009004', '阿巴嘎旗', '001005009', 49, '中国/内蒙古/锡林郭勒/阿巴嘎旗', 'null', 4, 'abgq', 'abagaqi', 'null', '011400'),
(375, '001005009005', '苏尼特左旗', '001005009', 49, '中国/内蒙古/锡林郭勒/苏尼特左旗', 'null', 4, 'sntzq', 'sunitezuoqi', 'null', '011300'),
(376, '001005009006', '苏尼特右旗', '001005009', 49, '中国/内蒙古/锡林郭勒/苏尼特右旗', 'null', 4, 'sntyq', 'suniteyouqi', 'null', '011200'),
(377, '001005009007', '东乌珠穆沁旗', '001005009', 49, '中国/内蒙古/锡林郭勒/东乌珠穆沁旗', 'null', 4, 'dwzmqq', 'dongwuzhumu', 'null', '026300'),
(378, '001005009008', '西乌珠穆沁旗', '001005009', 49, '中国/内蒙古/锡林郭勒/西乌珠穆沁旗', 'null', 4, 'xwzmqq', 'xiwuzhumuqi', 'null', '026200'),
(379, '001005009009', '太仆寺旗', '001005009', 49, '中国/内蒙古/锡林郭勒/太仆寺旗', 'null', 4, 'tpsq', 'taipusiqi', 'null', '027000'),
(380, '001005009010', '镶黄旗', '001005009', 49, '中国/内蒙古/锡林郭勒/镶黄旗', 'null', 4, 'xhq', 'xianghuangq', 'null', '013250'),
(381, '001005009011', '正镶白旗', '001005009', 49, '中国/内蒙古/锡林郭勒/正镶白旗', 'null', 4, 'zxbq', 'zhengxiangb', 'null', '013800'),
(382, '001005009012', '正蓝旗', '001005009', 49, '中国/内蒙古/锡林郭勒/正蓝旗', 'null', 4, 'zlq', 'zhenglanqi', 'null', '027200'),
(383, '001005010001', '临河', '001005010', 50, '中国/内蒙古/巴彦淖尔/临河', '市', 4, 'lh', 'linhe', 'null', '015001'),
(384, '001005010002', '五原', '001005010', 50, '中国/内蒙古/巴彦淖尔/五原', '县', 4, 'wy', 'wuyuan', 'null', '015100'),
(385, '001005010003', '磴口', '001005010', 50, '中国/内蒙古/巴彦淖尔/磴口', '县', 4, 'k', 'kou', 'null', '015200'),
(386, '001005010004', '乌拉特前旗', '001005010', 50, '中国/内蒙古/巴彦淖尔/乌拉特前旗', 'null', 4, 'wltqq', 'wulateqianq', 'null', '014400');
INSERT INTO `des_district` (`serialId`, `districtId`, `districtName`, `districtUpId`, `districtUpIdNum`, `districtPath`, `districtType`, `districtTypeNum`, `shortName`, `spell`, `areaId`, `postCode`) VALUES
(387, '001005010005', '乌拉特中旗', '001005010', 50, '中国/内蒙古/巴彦淖尔/乌拉特中旗', 'null', 4, 'wltzq', 'wulatezhong', 'null', '015300'),
(388, '001005010006', '乌拉特后旗', '001005010', 50, '中国/内蒙古/巴彦淖尔/乌拉特后旗', 'null', 4, 'wlthq', 'wulatehouqi', 'null', '015500'),
(389, '001005010007', '杭锦后旗', '001005010', 50, '中国/内蒙古/巴彦淖尔/杭锦后旗', 'null', 4, 'hjhq', 'hangjinhouq', 'null', '015400'),
(390, '001005011001', '阿拉善左旗', '001005011', 51, '中国/内蒙古/阿拉善/阿拉善左旗', 'null', 4, 'alszq', 'alashanzuoq', 'null', '750306'),
(391, '001005011002', '阿拉善右旗', '001005011', 51, '中国/内蒙古/阿拉善/阿拉善右旗', 'null', 4, 'alsyq', 'alashanyouq', 'null', '737300'),
(392, '001005011003', '额济纳旗', '001005011', 51, '中国/内蒙古/阿拉善/额济纳旗', 'null', 4, 'ejnq', 'ejinaqi', 'null', '735400'),
(393, '001005012001', '乌兰浩特', '001005012', 52, '中国/内蒙古/兴安/乌兰浩特', '市', 4, 'wlht', 'wulanhaote', 'null', '137401'),
(394, '001005012002', '阿尔山', '001005012', 52, '中国/内蒙古/兴安/阿尔山', '市', 4, 'aes', 'aershan', 'null', '137800'),
(395, '001005012003', '突泉', '001005012', 52, '中国/内蒙古/兴安/突泉', '县', 4, 'tq', 'tuquan', 'null', '137500'),
(396, '001005012004', '科尔沁右翼前旗', '001005012', 52, '中国/内蒙古/兴安/科尔沁右翼前旗', 'null', 4, 'keqyyqq', 'keerqinyouy', 'null', '137400'),
(397, '001005012005', '科尔沁右翼中旗', '001005012', 52, '中国/内蒙古/兴安/科尔沁右翼中旗', 'null', 4, 'keqyyzq', 'keerqinyouy', 'null', '029300'),
(398, '001005012006', '扎赉特旗', '001005012', 52, '中国/内蒙古/兴安/扎赉特旗', 'null', 4, 'ztq', 'zhateqi', 'null', '137600'),
(399, '001006001001', '和平', '001006001', 53, '中国/辽宁/沈阳/和平', '区', 4, 'hp', 'heping', 'null', '110001'),
(400, '001006001002', '大东', '001006001', 53, '中国/辽宁/沈阳/大东', '区', 4, 'dd', 'dadong', 'null', '110041'),
(401, '001006001003', '皇姑', '001006001', 53, '中国/辽宁/沈阳/皇姑', '区', 4, 'hg', 'huanggu', 'null', '110031'),
(402, '001006001004', '铁西', '001006001', 53, '中国/辽宁/沈阳/铁西', '区', 4, 'tx', 'tiexi', 'null', '110021'),
(403, '001006001005', '苏家屯', '001006001', 53, '中国/辽宁/沈阳/苏家屯', '区', 4, 'sjt', 'sujiatun', 'null', '110101'),
(404, '001006001006', '东陵', '001006001', 53, '中国/辽宁/沈阳/东陵', '区', 4, 'dl', 'dongling', 'null', '110015'),
(405, '001006001007', '新城子', '001006001', 53, '中国/辽宁/沈阳/新城子', '区', 4, 'xcz', 'xinchengzi', 'null', '110121'),
(406, '001006001008', '于洪', '001006001', 53, '中国/辽宁/沈阳/于洪', '区', 4, 'yh', 'yuhong', 'null', '110024'),
(407, '001006001009', '新民', '001006001', 53, '中国/辽宁/沈阳/新民', '市', 4, 'xm', 'xinmin', 'null', '110300'),
(408, '001006001010', '辽中', '001006001', 53, '中国/辽宁/沈阳/辽中', '县', 4, 'lz', 'liaozhong', 'null', '110200'),
(409, '001006001011', '康平', '001006001', 53, '中国/辽宁/沈阳/康平', '县', 4, 'kp', 'kangping', 'null', '110400'),
(410, '001006001012', '法库', '001006001', 53, '中国/辽宁/沈阳/法库', '县', 4, 'fk', 'faku', 'null', '110400'),
(411, '001006002001', '西岗', '001006002', 54, '中国/辽宁/大连/西岗', '区', 4, 'xg', 'xigang', 'null', '116001'),
(412, '001006002002', '中山', '001006002', 54, '中国/辽宁/大连/中山', '区', 4, 'zs', 'zhongshan', 'null', '116001'),
(413, '001006002003', '沙河口', '001006002', 54, '中国/辽宁/大连/沙河口', '区', 4, 'shk', 'shahekou', 'null', '116021'),
(414, '001006002004', '甘井子', '001006002', 54, '中国/辽宁/大连/甘井子', '区', 4, 'gjz', 'ganjingzi', 'null', '116033'),
(415, '001006002005', '旅顺口', '001006002', 54, '中国/辽宁/大连/旅顺口', '区', 4, 'lsk', 'lvshunkou', 'null', '116041'),
(416, '001006002006', '金州', '001006002', 54, '中国/辽宁/大连/金州', '区', 4, 'jz', 'jinzhou', 'null', '116100'),
(417, '001006002007', '瓦房店', '001006002', 54, '中国/辽宁/大连/瓦房店', '市', 4, 'wfd', 'wafangdian', 'null', '116300'),
(418, '001006002008', '普兰店', '001006002', 54, '中国/辽宁/大连/普兰店', '市', 4, 'pld', 'pulandian', 'null', '116200'),
(419, '001006002009', '庄河', '001006002', 54, '中国/辽宁/大连/庄河', '市', 4, 'zh', 'zhuanghe', 'null', '116400'),
(420, '001006002010', '长海', '001006002', 54, '中国/辽宁/大连/长海', '县', 4, 'ch', 'changhai', 'null', '116500'),
(421, '001006003001', '铁东', '001006003', 55, '中国/辽宁/鞍山/铁东', '区', 4, 'td', 'tiedong', 'null', '114001'),
(422, '001006003002', '铁西', '001006003', 55, '中国/辽宁/鞍山/铁西', '区', 4, 'tx', 'tiexi', 'null', '114014'),
(423, '001006003003', '立山', '001006003', 55, '中国/辽宁/鞍山/立山', '区', 4, 'ls', 'lishan', 'null', '114031'),
(424, '001006003004', '千山', '001006003', 55, '中国/辽宁/鞍山/千山', '区', 4, 'qs', 'qianshan', 'null', '114041'),
(425, '001006003005', '海城', '001006003', 55, '中国/辽宁/鞍山/海城', '市', 4, 'hc', 'haicheng', 'null', '114200'),
(426, '001006003006', '台安', '001006003', 55, '中国/辽宁/鞍山/台安', '县', 4, 'ta', 'taian', 'null', '114100'),
(427, '001006003007', '岫岩', '001006003', 55, '中国/辽宁/鞍山/岫岩', '满族自治县', 4, 'ymzzz', 'yanmanzuziz', 'null', '114300'),
(428, '001006004001', '新抚', '001006004', 56, '中国/辽宁/抚顺/新抚', '区', 4, 'xf', 'xinfu', 'null', '113008'),
(429, '001006004002', '东洲', '001006004', 56, '中国/辽宁/抚顺/东洲', '区', 4, 'dz', 'dongzhou', 'null', '113003'),
(430, '001006004003', '望花', '001006004', 56, '中国/辽宁/抚顺/望花', '区', 4, 'wh', 'wanghua', 'null', '113001'),
(431, '001006004004', '顺城', '001006004', 56, '中国/辽宁/抚顺/顺城', '区', 4, 'sc', 'shuncheng', 'null', '113006'),
(432, '001006004005', '抚顺', '001006004', 56, '中国/辽宁/抚顺/抚顺', '县', 4, 'fs', 'fushun', 'null', '113006'),
(433, '001006004006', '新宾', '001006004', 56, '中国/辽宁/抚顺/新宾', '满族自治县', 4, 'xbmzzz', 'xinbinmanzu', 'null', '113200'),
(434, '001006004007', '清原', '001006004', 56, '中国/辽宁/抚顺/清原', '满族自治县', 4, 'qymzzz', 'qingyuanman', 'null', '113300'),
(435, '001006005001', '平山', '001006005', 57, '中国/辽宁/本溪/平山', '区', 4, 'ps', 'pingshan', 'null', '117000'),
(436, '001006005002', '溪湖', '001006005', 57, '中国/辽宁/本溪/溪湖', '区', 4, 'xh', 'xihu', 'null', '117000'),
(437, '001006005003', '明山', '001006005', 57, '中国/辽宁/本溪/明山', '区', 4, 'ms', 'mingshan', 'null', '117021'),
(438, '001006005004', '南芬', '001006005', 57, '中国/辽宁/本溪/南芬', '区', 4, 'nf', 'nanfen', 'null', '117014'),
(439, '001006005005', '本溪', '001006005', 57, '中国/辽宁/本溪/本溪', '满族自治县', 4, 'bxmzzz', 'benximanzuz', 'null', '117100'),
(440, '001006005006', '桓仁', '001006005', 57, '中国/辽宁/本溪/桓仁', '满族自治县', 4, 'hrmzzz', 'huanrenmanz', 'null', '117200'),
(441, '001006006001', '振兴', '001006006', 58, '中国/辽宁/丹东/振兴', '区', 4, 'zx', 'zhenxing', 'null', '118002'),
(442, '001006006002', '元宝', '001006006', 58, '中国/辽宁/丹东/元宝', '区', 4, 'yb', 'yuanbao', 'null', '118000'),
(443, '001006006003', '振安', '001006006', 58, '中国/辽宁/丹东/振安', '区', 4, 'za', 'zhenan', 'null', '118001'),
(444, '001006006004', '凤城', '001006006', 58, '中国/辽宁/丹东/凤城', '市', 4, 'fc', 'fengcheng', 'null', '118100'),
(445, '001006006005', '东港', '001006006', 58, '中国/辽宁/丹东/东港', '市', 4, 'dg', 'donggang', 'null', '118300'),
(446, '001006006006', '宽甸', '001006006', 58, '中国/辽宁/丹东/宽甸', '满族自治县', 4, 'kdmzzz', 'kuandianman', 'null', '118200'),
(447, '001006007001', '太和', '001006007', 59, '中国/辽宁/锦州/太和', '区', 4, 'th', 'taihe', 'null', '121011'),
(448, '001006007002', '古塔', '001006007', 59, '中国/辽宁/锦州/古塔', '区', 4, 'gt', 'guta', 'null', '121001'),
(449, '001006007003', '凌河', '001006007', 59, '中国/辽宁/锦州/凌河', '区', 4, 'lh', 'linghe', 'null', '121000'),
(450, '001006007004', '凌海', '001006007', 59, '中国/辽宁/锦州/凌海', '市', 4, 'lh', 'linghai', 'null', '121200'),
(451, '001006007005', '北宁', '001006007', 59, '中国/辽宁/锦州/北宁', '市', 4, 'bn', 'beining', 'null', '121300'),
(452, '001006007006', '黑山', '001006007', 59, '中国/辽宁/锦州/黑山', '县', 4, 'hs', 'heishan', 'null', '121400'),
(453, '001006007007', '义县', '001006007', 59, '中国/辽宁/锦州/义县', 'null', 4, 'y', 'yi', 'null', '121100'),
(454, '001006008001', '龙港', '001006008', 60, '中国/辽宁/葫芦岛/龙港', '区', 4, 'lg', 'longgang', 'null', '125004'),
(455, '001006008002', '连山', '001006008', 60, '中国/辽宁/葫芦岛/连山', '区', 4, 'ls', 'lianshan', 'null', '125001'),
(456, '001006008003', '南票', '001006008', 60, '中国/辽宁/葫芦岛/南票', '区', 4, 'np', 'nanpiao', 'null', '125027'),
(457, '001006008004', '兴城', '001006008', 60, '中国/辽宁/葫芦岛/兴城', '市', 4, 'xc', 'xingcheng', 'null', '125100'),
(458, '001006008005', '绥中', '001006008', 60, '中国/辽宁/葫芦岛/绥中', '县', 4, 'sz', 'suizhong', 'null', '125200'),
(459, '001006008006', '建昌', '001006008', 60, '中国/辽宁/葫芦岛/建昌', '县', 4, 'jc', 'jianchang', 'null', '125300'),
(460, '001006009001', '站前', '001006009', 61, '中国/辽宁/营口/站前', '区', 4, 'zq', 'zhanqian', 'null', '115002'),
(461, '001006009002', '西市', '001006009', 61, '中国/辽宁/营口/西市', '区', 4, 'x', 'xi', 'null', '115004'),
(462, '001006009003', '鲅鱼圈', '001006009', 61, '中国/辽宁/营口/鲅鱼圈', '区', 4, 'yq', 'yuquan', 'null', '115007'),
(463, '001006009004', '老边', '001006009', 61, '中国/辽宁/营口/老边', '区', 4, 'lb', 'laobian', 'null', '115005'),
(464, '001006009005', '大石桥', '001006009', 61, '中国/辽宁/营口/大石桥', '市', 4, 'dsq', 'dashiqiao', 'null', '115100'),
(465, '001006009006', '盖州', '001006009', 61, '中国/辽宁/营口/盖州', '市', 4, 'gz', 'gaizhou', 'null', '115200'),
(466, '001006010001', '双台子', '001006010', 62, '中国/辽宁/盘锦/双台子', '区', 4, 'stz', 'shuangtaizi', 'null', '124000'),
(467, '001006010002', '兴隆台', '001006010', 62, '中国/辽宁/盘锦/兴隆台', '区', 4, 'xlt', 'xinglongtai', 'null', '124010'),
(468, '001006010003', '大洼', '001006010', 62, '中国/辽宁/盘锦/大洼', '县', 4, 'dw', 'dawa', 'null', '124200'),
(469, '001006010004', '盘山', '001006010', 62, '中国/辽宁/盘锦/盘山', '县', 4, 'ps', 'panshan', 'null', '124000'),
(470, '001006011001', '海州', '001006011', 63, '中国/辽宁/阜新/海州', '区', 4, 'hz', 'haizhou', 'null', '123000'),
(471, '001006011002', '新邱', '001006011', 63, '中国/辽宁/阜新/新邱', '区', 4, 'xq', 'xinqiu', 'null', '123005'),
(472, '001006011003', '太平', '001006011', 63, '中国/辽宁/阜新/太平', '区', 4, 'tp', 'taiping', 'null', '123003'),
(473, '001006011004', '清河门', '001006011', 63, '中国/辽宁/阜新/清河门', '区', 4, 'qhm', 'qinghemen', 'null', '123006'),
(474, '001006011005', '细河', '001006011', 63, '中国/辽宁/阜新/细河', '区', 4, 'xh', 'xihe', 'null', '123000'),
(475, '001006011006', '彰武', '001006011', 63, '中国/辽宁/阜新/彰武', '县', 4, 'zw', 'zhangwu', 'null', '123200'),
(476, '001006011007', '阜新', '001006011', 63, '中国/辽宁/阜新/阜新', '蒙古族自治县', 4, 'fxmgzzz', 'fuxinmenggu', 'null', '123100'),
(477, '001006012001', '白塔', '001006012', 64, '中国/辽宁/辽阳/白塔', '区', 4, 'bt', 'baita', 'null', '111000'),
(478, '001006012002', '文圣', '001006012', 64, '中国/辽宁/辽阳/文圣', '区', 4, 'ws', 'wensheng', 'null', '111000'),
(479, '001006012003', '宏伟', '001006012', 64, '中国/辽宁/辽阳/宏伟', '区', 4, 'hw', 'hongwei', 'null', '111003'),
(480, '001006012004', '弓长岭', '001006012', 64, '中国/辽宁/辽阳/弓长岭', '区', 4, 'gcl', 'gongchangli', 'null', '111008'),
(481, '001006012005', '太子河', '001006012', 64, '中国/辽宁/辽阳/太子河', '区', 4, 'tzh', 'taizihe', 'null', '111000'),
(482, '001006012006', '灯塔', '001006012', 64, '中国/辽宁/辽阳/灯塔', '市', 4, 'dt', 'dengta', 'null', '111300'),
(483, '001006012007', '辽阳', '001006012', 64, '中国/辽宁/辽阳/辽阳', '县', 4, 'ly', 'liaoyang', 'null', '111200'),
(484, '001006013001', '银州', '001006013', 65, '中国/辽宁/铁岭/银州', '区', 4, 'yz', 'yinzhou', 'null', '112000'),
(485, '001006013002', '清河', '001006013', 65, '中国/辽宁/铁岭/清河', '区', 4, 'qh', 'qinghe', 'null', '112003'),
(486, '001006013003', '调兵山', '001006013', 65, '中国/辽宁/铁岭/调兵山', '市', 4, 'dbs', 'diaobingsha', 'null', '112700'),
(487, '001006013004', '开原', '001006013', 65, '中国/辽宁/铁岭/开原', '市', 4, 'ky', 'kaiyuan', 'null', '112300'),
(488, '001006013005', '铁岭', '001006013', 65, '中国/辽宁/铁岭/铁岭', '县', 4, 'tl', 'tieling', 'null', '112000'),
(489, '001006013006', '西丰', '001006013', 65, '中国/辽宁/铁岭/西丰', '县', 4, 'xf', 'xifeng', 'null', '112400'),
(490, '001006013007', '昌图', '001006013', 65, '中国/辽宁/铁岭/昌图', '县', 4, 'ct', 'changtu', 'null', '112500'),
(491, '001006014001', '双塔', '001006014', 66, '中国/辽宁/朝阳/双塔', '区', 4, 'st', 'shuangta', 'null', '122000'),
(492, '001006014002', '龙城', '001006014', 66, '中国/辽宁/朝阳/龙城', '区', 4, 'lc', 'longcheng', 'null', '122000'),
(493, '001006014003', '北票', '001006014', 66, '中国/辽宁/朝阳/北票', '市', 4, 'bp', 'beipiao', 'null', '122100'),
(494, '001006014004', '凌源', '001006014', 66, '中国/辽宁/朝阳/凌源', '市', 4, 'ly', 'lingyuan', 'null', '122500'),
(495, '001006014005', '朝阳', '001006014', 66, '中国/辽宁/朝阳/朝阳', '县', 4, 'cy', 'chaoyang', 'null', '122000'),
(496, '001006014006', '建平', '001006014', 66, '中国/辽宁/朝阳/建平', '县', 4, 'jp', 'jianping', 'null', '122400'),
(497, '001006014007', '喀喇沁左翼', '001006014', 66, '中国/辽宁/朝阳/喀喇沁左翼', '蒙古族自治县', 4, 'klqzymgzzz', 'kalaqinzuoy', 'null', '122300'),
(498, '001007001001', '朝阳', '001007001', 67, '中国/吉林/长春/朝阳', '区', 4, 'cy', 'chaoyang', 'null', '130061'),
(499, '001007001002', '南关', '001007001', 67, '中国/吉林/长春/南关', '区', 4, 'ng', 'nanguan', 'null', '130041'),
(500, '001007001003', '宽城', '001007001', 67, '中国/吉林/长春/宽城', '区', 4, 'kc', 'kuancheng', 'null', '130051'),
(501, '001007001004', '二道', '001007001', 67, '中国/吉林/长春/二道', '区', 4, 'ed', 'erdao', 'null', '130031'),
(502, '001007001005', '绿园', '001007001', 67, '中国/吉林/长春/绿园', '区', 4, 'ly', 'lvyuan', 'null', '130062'),
(503, '001007001006', '双阳', '001007001', 67, '中国/吉林/长春/双阳', '区', 4, 'sy', 'shuangyang', 'null', '130600'),
(504, '001007001007', '德惠', '001007001', 67, '中国/吉林/长春/德惠', '市', 4, 'dh', 'dehui', 'null', '130300'),
(505, '001007001008', '九台', '001007001', 67, '中国/吉林/长春/九台', '市', 4, 'jt', 'jiutai', 'null', '130500'),
(506, '001007001009', '榆树', '001007001', 67, '中国/吉林/长春/榆树', '市', 4, 'ys', 'yushu', 'null', '130400'),
(507, '001007001010', '农安', '001007001', 67, '中国/吉林/长春/农安', '县', 4, 'na', 'nongan', 'null', '130200'),
(508, '001007002001', '船营', '001007002', 68, '中国/吉林/吉林/船营', '区', 4, 'cy', 'chuanying', 'null', '132011'),
(509, '001007002002', '龙潭', '001007002', 68, '中国/吉林/吉林/龙潭', '区', 4, 'lt', 'longtan', 'null', '132021'),
(510, '001007002003', '昌邑', '001007002', 68, '中国/吉林/吉林/昌邑', '区', 4, 'cy', 'changyi', 'null', '132001'),
(511, '001007002004', '丰满', '001007002', 68, '中国/吉林/吉林/丰满', '区', 4, 'fm', 'fengman', 'null', '132108'),
(512, '001007002005', '磐石', '001007002', 68, '中国/吉林/吉林/磐石', '市', 4, 'ps', 'panshi', 'null', '132300'),
(513, '001007002006', '蛟河', '001007002', 68, '中国/吉林/吉林/蛟河', '市', 4, 'h', 'he', 'null', '132500'),
(514, '001007002007', '桦甸', '001007002', 68, '中国/吉林/吉林/桦甸', '市', 4, 'd', 'dian', 'null', '132400'),
(515, '001007002008', '舒兰', '001007002', 68, '中国/吉林/吉林/舒兰', '市', 4, 'sl', 'shulan', 'null', '132600'),
(516, '001007002009', '永吉', '001007002', 68, '中国/吉林/吉林/永吉', '县', 4, 'yj', 'yongji', 'null', '132200'),
(517, '001007003001', '铁西', '001007003', 69, '中国/吉林/四平/铁西', '区', 4, 'tx', 'tiexi', 'null', '136000'),
(518, '001007003002', '铁东', '001007003', 69, '中国/吉林/四平/铁东', '区', 4, 'td', 'tiedong', 'null', '136001'),
(519, '001007003003', '双辽', '001007003', 69, '中国/吉林/四平/双辽', '市', 4, 'sl', 'shuangliao', 'null', '136400'),
(520, '001007003004', '公主岭', '001007003', 69, '中国/吉林/四平/公主岭', '市', 4, 'gzl', 'gongzhuling', 'null', '136100'),
(521, '001007003005', '梨树', '001007003', 69, '中国/吉林/四平/梨树', '县', 4, 'ls', 'lishu', 'null', '136500'),
(522, '001007003006', '伊通', '001007003', 69, '中国/吉林/四平/伊通', '满族自治县', 4, 'ytmzzz', 'yitongmanzu', 'null', '130700'),
(523, '001007004001', '龙山', '001007004', 70, '中国/吉林/辽源/龙山', '区', 4, 'ls', 'longshan', 'null', '136200'),
(524, '001007004002', '西安', '001007004', 70, '中国/吉林/辽源/西安', '区', 4, 'xa', 'xian', 'null', '136201'),
(525, '001007004003', '东丰', '001007004', 70, '中国/吉林/辽源/东丰', '县', 4, 'df', 'dongfeng', 'null', '136300'),
(526, '001007004004', '东辽', '001007004', 70, '中国/吉林/辽源/东辽', '县', 4, 'dl', 'dongliao', 'null', '136600'),
(527, '001007005001', '东昌', '001007005', 71, '中国/吉林/通化/东昌', '区', 4, 'dc', 'dongchang', 'null', '134001'),
(528, '001007005002', '二道江', '001007005', 71, '中国/吉林/通化/二道江', '区', 4, 'edj', 'erdaojiang', 'null', '134300'),
(529, '001007005003', '梅河口', '001007005', 71, '中国/吉林/通化/梅河口', '市', 4, 'mhk', 'meihekou', 'null', '135000'),
(530, '001007005004', '集安', '001007005', 71, '中国/吉林/通化/集安', '市', 4, 'ja', 'jian', 'null', '134200'),
(531, '001007005005', '通化', '001007005', 71, '中国/吉林/通化/通化', '县', 4, 'th', 'tonghua', 'null', '134100'),
(532, '001007005006', '辉南', '001007005', 71, '中国/吉林/通化/辉南', '县', 4, 'hn', 'huinan', 'null', '135100'),
(533, '001007005007', '柳河', '001007005', 71, '中国/吉林/通化/柳河', '县', 4, 'lh', 'liuhe', 'null', '135300'),
(534, '001007006001', '八道江', '001007006', 72, '中国/吉林/白山/八道江', '区', 4, 'bdj', 'badaojiang', 'null', '134300'),
(535, '001007006002', '临江', '001007006', 72, '中国/吉林/白山/临江', '市', 4, 'lj', 'linjiang', 'null', '134600'),
(536, '001007006003', '江源', '001007006', 72, '中国/吉林/白山/江源', '县', 4, 'jy', 'jiangyuan', 'null', '134700'),
(537, '001007006004', '抚松', '001007006', 72, '中国/吉林/白山/抚松', '县', 4, 'fs', 'fusong', 'null', '134500'),
(538, '001007006005', '靖宇', '001007006', 72, '中国/吉林/白山/靖宇', '县', 4, 'jy', 'jingyu', 'null', '135200'),
(539, '001007006006', '长白', '001007006', 72, '中国/吉林/白山/长白', '朝鲜族自治县', 4, 'cbcxzzz', 'changbaicha', 'null', '134400'),
(540, '001007007001', '宁江', '001007007', 73, '中国/吉林/松原/宁江', '区', 4, 'nj', 'ningjiang', 'null', '138000'),
(541, '001007007002', '扶余', '001007007', 73, '中国/吉林/松原/扶余', '县', 4, 'fy', 'fuyu', 'null', '131203'),
(542, '001007007003', '长岭', '001007007', 73, '中国/吉林/松原/长岭', '县', 4, 'cl', 'changling', 'null', '131500'),
(543, '001007007004', '乾安', '001007007', 73, '中国/吉林/松原/乾安', '县', 4, 'qa', 'qianan', 'null', '131400'),
(544, '001007007005', '前郭尔罗斯', '001007007', 73, '中国/吉林/松原/前郭尔罗斯', '蒙古族自治县', 4, 'qgelsmgzzz', 'qianguoerlu', 'null', '131100'),
(545, '001007008001', '洮北', '001007008', 74, '中国/吉林/白城/洮北', '区', 4, 'b', 'bei', 'null', '137000'),
(546, '001007008002', '大安', '001007008', 74, '中国/吉林/白城/大安', '市', 4, 'da', 'daan', 'null', '131300'),
(547, '001007008003', '洮南', '001007008', 74, '中国/吉林/白城/洮南', '市', 4, 'n', 'nan', 'null', '137100'),
(548, '001007008004', '镇赉', '001007008', 74, '中国/吉林/白城/镇赉', '县', 4, 'z', 'zhen', 'null', '137300'),
(549, '001007008005', '通榆', '001007008', 74, '中国/吉林/白城/通榆', '县', 4, 'ty', 'tongyu', 'null', '137200'),
(550, '001007009001', '延吉', '001007009', 75, '中国/吉林/延边/延吉', '市', 4, 'yj', 'yanji', 'null', '133000'),
(551, '001007009002', '图们', '001007009', 75, '中国/吉林/延边/图们', '市', 4, 'tm', 'tumen', 'null', '133100'),
(552, '001007009003', '敦化', '001007009', 75, '中国/吉林/延边/敦化', '市', 4, 'dh', 'dunhua', 'null', '133700'),
(553, '001007009004', '珲春', '001007009', 75, '中国/吉林/延边/珲春', '市', 4, 'c', 'chun', 'null', '133300'),
(554, '001007009005', '龙井', '001007009', 75, '中国/吉林/延边/龙井', '市', 4, 'lj', 'longjing', 'null', '133400'),
(555, '001007009006', '和龙', '001007009', 75, '中国/吉林/延边/和龙', '市', 4, 'hl', 'helong', 'null', '133500'),
(556, '001007009007', '汪清', '001007009', 75, '中国/吉林/延边/汪清', '县', 4, 'wq', 'wangqing', 'null', '133200'),
(557, '001007009008', '安图', '001007009', 75, '中国/吉林/延边/安图', '县', 4, 'at', 'antu', 'null', '133600'),
(558, '001008001001', '南岗', '001008001', 76, '中国/黑龙江/哈尔滨/南岗', '区', 4, 'ng', 'nangang', 'null', '150006'),
(559, '001008001002', '道外', '001008001', 76, '中国/黑龙江/哈尔滨/道外', '区', 4, 'dw', 'daowai', 'null', '150020'),
(560, '001008001003', '太平', '001008001', 76, '中国/黑龙江/哈尔滨/太平', '区', 4, 'tp', 'taiping', 'null', '150056'),
(561, '001008001004', '香坊', '001008001', 76, '中国/黑龙江/哈尔滨/香坊', '区', 4, 'xf', 'xiangfang', 'null', '150036'),
(562, '001008001005', '动力', '001008001', 76, '中国/黑龙江/哈尔滨/动力', '区', 4, 'dl', 'dongli', 'null', '150040'),
(563, '001008001006', '平房', '001008001', 76, '中国/黑龙江/哈尔滨/平房', '区', 4, 'pf', 'pingfang', 'null', '150060'),
(564, '001008001007', '双城', '001008001', 76, '中国/黑龙江/哈尔滨/双城', '市', 4, 'sc', 'shuangcheng', 'null', '150100'),
(565, '001008001008', '尚志', '001008001', 76, '中国/黑龙江/哈尔滨/尚志', '市', 4, 'sz', 'shangzhi', 'null', '150600'),
(566, '001008001009', '五常', '001008001', 76, '中国/黑龙江/哈尔滨/五常', '市', 4, 'wc', 'wuchang', 'null', '150200'),
(567, '001008001010', '阿城', '001008001', 76, '中国/黑龙江/哈尔滨/阿城', '市', 4, 'ac', 'acheng', 'null', '150300'),
(568, '001008001011', '呼兰', '001008001', 76, '中国/黑龙江/哈尔滨/呼兰', '县', 4, 'hl', 'hulan', 'null', '150500'),
(569, '001008001012', '依兰', '001008001', 76, '中国/黑龙江/哈尔滨/依兰', '县', 4, 'yl', 'yilan', 'null', '154800'),
(570, '001008001013', '方正', '001008001', 76, '中国/黑龙江/哈尔滨/方正', '县', 4, 'fz', 'fangzheng', 'null', '150800'),
(571, '001008001014', '宾县', '001008001', 76, '中国/黑龙江/哈尔滨/宾县', 'null', 4, 'b', 'bin', 'null', '150400'),
(572, '001008001015', '巴彦', '001008001', 76, '中国/黑龙江/哈尔滨/巴彦', '县', 4, 'by', 'bayan', 'null', '151800'),
(573, '001008001016', '木兰', '001008001', 76, '中国/黑龙江/哈尔滨/木兰', '县', 4, 'ml', 'mulan', 'null', '151900'),
(574, '001008001017', '通河', '001008001', 76, '中国/黑龙江/哈尔滨/通河', '县', 4, 'th', 'tonghe', 'null', '150900'),
(575, '001008001018', '延寿', '001008001', 76, '中国/黑龙江/哈尔滨/延寿', '县', 4, 'ys', 'yanshou', 'null', '150700'),
(576, '001008002001', '龙沙', '001008002', 77, '中国/黑龙江/齐齐哈尔/龙沙', '区', 4, 'ls&nbsp&nbs', 'longsha&nbs', 'null', '161000'),
(577, '001008002002', '建华', '001008002', 77, '中国/黑龙江/齐齐哈尔/建华', '区', 4, 'jh&nbsp&nbs', 'jianhua&nbs', 'null', '161006'),
(578, '001008002003', '铁峰', '001008002', 77, '中国/黑龙江/齐齐哈尔/铁峰', '区', 4, 'tf&nbsp&nbs', 'tiefeng&nbs', 'null', '161000'),
(579, '001008002004', '昂昂溪', '001008002', 77, '中国/黑龙江/齐齐哈尔/昂昂溪', '区', 4, 'aax&nbsp&nb', 'angangxi&nb', 'null', '161031'),
(580, '001008002005', '富拉尔基', '001008002', 77, '中国/黑龙江/齐齐哈尔/富拉尔基', '区', 4, 'flej&nbsp', 'fulaerji&nb', 'null', '161041'),
(581, '001008002006', '碾子山', '001008002', 77, '中国/黑龙江/齐齐哈尔/碾子山', '区', 4, 'nzs&nbsp&nb', 'nianzishan&', 'null', '161046'),
(582, '001008002007', '梅里斯达斡尔', '001008002', 77, '中国/黑龙江/齐齐哈尔/梅里斯达斡尔', '区', 4, 'mlsdwe', 'meilisidawo', 'null', '161021'),
(583, '001008002008', '讷河', '001008002', 77, '中国/黑龙江/齐齐哈尔/讷河', '市', 4, 'h&nbsp&nbsp', 'he&nbsp&nbs', 'null', '161300'),
(584, '001008002009', '龙江', '001008002', 77, '中国/黑龙江/齐齐哈尔/龙江', '县', 4, 'lj&nbsp&nbs', 'longjiang&n', 'null', '161100'),
(585, '001008002010', '依安', '001008002', 77, '中国/黑龙江/齐齐哈尔/依安', '县', 4, 'ya&nbsp&nbs', 'yian&nbsp&n', 'null', '161500'),
(586, '001008002011', '泰来', '001008002', 77, '中国/黑龙江/齐齐哈尔/泰来', '县', 4, 'tl&nbsp&nbs', 'tailai&nbsp', 'null', '162400'),
(587, '001008002012', '甘南', '001008002', 77, '中国/黑龙江/齐齐哈尔/甘南', '县', 4, 'gn&nbsp&nbs', 'gannan&nbsp', 'null', '162100'),
(588, '001008002013', '富裕', '001008002', 77, '中国/黑龙江/齐齐哈尔/富裕', '县', 4, 'fy&nbsp&nbs', 'fuyu&nbsp&n', 'null', '161200'),
(589, '001008002014', '克山', '001008002', 77, '中国/黑龙江/齐齐哈尔/克山', '县', 4, 'ks&nbsp&nbs', 'keshan&nbsp', 'null', '161600'),
(590, '001008002015', '克东', '001008002', 77, '中国/黑龙江/齐齐哈尔/克东', '县', 4, 'kd&nbsp&nbs', 'kedong&nbsp', 'null', '164800'),
(591, '001008002016', '拜泉', '001008002', 77, '中国/黑龙江/齐齐哈尔/拜泉', '县', 4, 'bq&nbsp&nbs', 'baiquan&nbs', 'null', '164700'),
(592, '001008003001', '兴山', '001008003', 78, '中国/黑龙江/鹤岗/兴山', '区', 4, 'xs', 'xingshan', 'null', '154105'),
(593, '001008003002', '向阳', '001008003', 78, '中国/黑龙江/鹤岗/向阳', '区', 4, 'xy', 'xiangyang', 'null', '154100'),
(594, '001008003003', '工农', '001008003', 78, '中国/黑龙江/鹤岗/工农', '区', 4, 'gn', 'gongnong', 'null', '154101'),
(595, '001008003004', '南山', '001008003', 78, '中国/黑龙江/鹤岗/南山', '区', 4, 'ns', 'nanshan', 'null', '154104'),
(596, '001008003005', '兴安', '001008003', 78, '中国/黑龙江/鹤岗/兴安', '区', 4, 'xa', 'xingan', 'null', '154102'),
(597, '001008003006', '东山', '001008003', 78, '中国/黑龙江/鹤岗/东山', '区', 4, 'ds', 'dongshan', 'null', '154106'),
(598, '001008003007', '萝北', '001008003', 78, '中国/黑龙江/鹤岗/萝北', '县', 4, 'lb', 'luobei', 'null', '154200'),
(599, '001008003008', '绥滨', '001008003', 78, '中国/黑龙江/鹤岗/绥滨', '县', 4, 'sb', 'suibin', 'null', '156200'),
(600, '001008004001', '尖山', '001008004', 79, '中国/黑龙江/双鸭山/尖山', '区', 4, 'js', 'jianshan', 'null', '155100'),
(601, '001008004002', '岭东', '001008004', 79, '中国/黑龙江/双鸭山/岭东', '区', 4, 'ld', 'lingdong', 'null', '155120'),
(602, '001008004003', '四方台', '001008004', 79, '中国/黑龙江/双鸭山/四方台', '区', 4, 'sft', 'sifangtai', 'null', '155130'),
(603, '001008004004', '宝山', '001008004', 79, '中国/黑龙江/双鸭山/宝山', '区', 4, 'bs', 'baoshan', 'null', '155131'),
(604, '001008004005', '集贤', '001008004', 79, '中国/黑龙江/双鸭山/集贤', '县', 4, 'jx', 'jixian', 'null', '155900'),
(605, '001008004006', '友谊', '001008004', 79, '中国/黑龙江/双鸭山/友谊', '县', 4, 'yy', 'youyi', 'null', '155800'),
(606, '001008004007', '宝清', '001008004', 79, '中国/黑龙江/双鸭山/宝清', '县', 4, 'bq', 'baoqing', 'null', '155600'),
(607, '001008004008', '饶河', '001008004', 79, '中国/黑龙江/双鸭山/饶河', '县', 4, 'rh', 'raohe', 'null', '155700'),
(608, '001008005001', '鸡冠', '001008005', 80, '中国/黑龙江/鸡西/鸡冠', '区', 4, 'jg', 'jiguan', 'null', '158100'),
(609, '001008005002', '恒山', '001008005', 80, '中国/黑龙江/鸡西/恒山', '区', 4, 'hs', 'hengshan', 'null', '158130'),
(610, '001008005003', '滴道', '001008005', 80, '中国/黑龙江/鸡西/滴道', '区', 4, 'dd', 'didao', 'null', '158150'),
(611, '001008005004', '梨树', '001008005', 80, '中国/黑龙江/鸡西/梨树', '区', 4, 'ls', 'lishu', 'null', '158160'),
(612, '001008005005', '城子河', '001008005', 80, '中国/黑龙江/鸡西/城子河', '区', 4, 'czh', 'chengzihe', 'null', '158170'),
(613, '001008005006', '麻山', '001008005', 80, '中国/黑龙江/鸡西/麻山', '区', 4, 'ms', 'mashan', 'null', '158180'),
(614, '001008005007', '虎林', '001008005', 80, '中国/黑龙江/鸡西/虎林', '市', 4, 'hl', 'hulin', 'null', '158400'),
(615, '001008005008', '密山', '001008005', 80, '中国/黑龙江/鸡西/密山', '市', 4, 'ms', 'mishan', 'null', '158300'),
(616, '001008005009', '鸡东', '001008005', 80, '中国/黑龙江/鸡西/鸡东', '县', 4, 'jd', 'jidong', 'null', '158200'),
(617, '001008006001', '萨尔图', '001008006', 81, '中国/黑龙江/大庆/萨尔图', '区', 4, 'set', 'saertu', 'null', '163001'),
(618, '001008006002', '龙凤', '001008006', 81, '中国/黑龙江/大庆/龙凤', '区', 4, 'lf', 'longfeng', 'null', '163711'),
(619, '001008006003', '让胡路', '001008006', 81, '中国/黑龙江/大庆/让胡路', '区', 4, 'rhl', 'ranghulu', 'null', '163712'),
(620, '001008006004', '大同', '001008006', 81, '中国/黑龙江/大庆/大同', '区', 4, 'dt', 'datong', 'null', '163515'),
(621, '001008006005', '红岗', '001008006', 81, '中国/黑龙江/大庆/红岗', '区', 4, 'hg', 'honggang', 'null', '163511'),
(622, '001008006006', '肇州', '001008006', 81, '中国/黑龙江/大庆/肇州', '县', 4, 'zz', 'zhaozhou', 'null', '166400'),
(623, '001008006007', '肇源', '001008006', 81, '中国/黑龙江/大庆/肇源', '县', 4, 'zy', 'zhaoyuan', 'null', '166500'),
(624, '001008006008', '林甸', '001008006', 81, '中国/黑龙江/大庆/林甸', '县', 4, 'ld', 'lindian', 'null', '166300'),
(625, '001008006009', '杜尔伯特', '001008006', 81, '中国/黑龙江/大庆/杜尔伯特', '蒙古族自治县', 4, 'debtmgzzz', 'duerbotemen', 'null', '166200'),
(626, '001008007001', '伊春', '001008007', 82, '中国/黑龙江/伊春/伊春', '区', 4, 'yc', 'yichun', 'null', '153000'),
(627, '001008007002', '南岔', '001008007', 82, '中国/黑龙江/伊春/南岔', '区', 4, 'nc', 'nancha', 'null', '153100'),
(628, '001008007003', '友好', '001008007', 82, '中国/黑龙江/伊春/友好', '区', 4, 'yh', 'youhao', 'null', '153031'),
(629, '001008007004', '西林', '001008007', 82, '中国/黑龙江/伊春/西林', '区', 4, 'xl', 'xilin', 'null', '153025'),
(630, '001008007005', '翠峦', '001008007', 82, '中国/黑龙江/伊春/翠峦', '区', 4, 'cl', 'cuiluan', 'null', '153013'),
(631, '001008007006', '新青', '001008007', 82, '中国/黑龙江/伊春/新青', '区', 4, 'xq', 'xinqing', 'null', '153036'),
(632, '001008007007', '美溪', '001008007', 82, '中国/黑龙江/伊春/美溪', '区', 4, 'mx', 'meixi', 'null', '153021'),
(633, '001008007008', '金山屯', '001008007', 82, '中国/黑龙江/伊春/金山屯', '区', 4, 'jst', 'jinshantun', 'null', '152026'),
(634, '001008007009', '五营', '001008007', 82, '中国/黑龙江/伊春/五营', '区', 4, 'wy', 'wuying', 'null', '153033'),
(635, '001008007010', '乌马河', '001008007', 82, '中国/黑龙江/伊春/乌马河', '区', 4, 'wmh', 'wumahe', 'null', '153011'),
(636, '001008007011', '汤旺河', '001008007', 82, '中国/黑龙江/伊春/汤旺河', '区', 4, 'twh', 'tangwanghe', 'null', '153037'),
(637, '001008007012', '带岭', '001008007', 82, '中国/黑龙江/伊春/带岭', '区', 4, 'dl', 'dailing', 'null', '153106'),
(638, '001008007013', '乌伊岭', '001008007', 82, '中国/黑龙江/伊春/乌伊岭', '区', 4, 'wyl', 'wuyiling', 'null', '153038'),
(639, '001008007014', '红星', '001008007', 82, '中国/黑龙江/伊春/红星', '区', 4, 'hx', 'hongxing', 'null', '153035'),
(640, '001008007015', '上甘岭', '001008007', 82, '中国/黑龙江/伊春/上甘岭', '区', 4, 'sgl', 'shangganlin', 'null', '153032'),
(641, '001008007016', '铁力', '001008007', 82, '中国/黑龙江/伊春/铁力', '市', 4, 'tl', 'tieli', 'null', '152500'),
(642, '001008007017', '嘉荫', '001008007', 82, '中国/黑龙江/伊春/嘉荫', '县', 4, 'jy', 'jiayin', 'null', '153200'),
(643, '001008008001', '爱民', '001008008', 83, '中国/黑龙江/牡丹江/爱民', '区', 4, 'am', 'aimin', 'null', '157009'),
(644, '001008008002', '东安', '001008008', 83, '中国/黑龙江/牡丹江/东安', '区', 4, 'da', 'dongan', 'null', '157000'),
(645, '001008008003', '阳明', '001008008', 83, '中国/黑龙江/牡丹江/阳明', '区', 4, 'ym', 'yangming', 'null', '157013'),
(646, '001008008004', '西安', '001008008', 83, '中国/黑龙江/牡丹江/西安', '区', 4, 'xa', 'xian', 'null', '157000'),
(647, '001008008005', '穆棱', '001008008', 83, '中国/黑龙江/牡丹江/穆棱', '市', 4, 'ml', 'muleng', 'null', '157500'),
(648, '001008008006', '绥芬河', '001008008', 83, '中国/黑龙江/牡丹江/绥芬河', '市', 4, 'sfh', 'suifenhe', 'null', '157300'),
(649, '001008008007', '海林', '001008008', 83, '中国/黑龙江/牡丹江/海林', '市', 4, 'hl', 'hailin', 'null', '157100'),
(650, '001008008008', '宁安', '001008008', 83, '中国/黑龙江/牡丹江/宁安', '市', 4, 'na', 'ningan', 'null', '157400'),
(651, '001008008009', '东宁', '001008008', 83, '中国/黑龙江/牡丹江/东宁', '县', 4, 'dn', 'dongning', 'null', '157200'),
(652, '001008008010', '林口', '001008008', 83, '中国/黑龙江/牡丹江/林口', '县', 4, 'lk', 'linkou', 'null', '157600'),
(653, '001008009001', '前进', '001008009', 84, '中国/黑龙江/佳木斯/前进', '区', 4, 'qj', 'qianjin', 'null', '154002'),
(654, '001008009002', '永红', '001008009', 84, '中国/黑龙江/佳木斯/永红', '区', 4, 'yh', 'yonghong', 'null', '154003'),
(655, '001008009003', '向阳', '001008009', 84, '中国/黑龙江/佳木斯/向阳', '区', 4, 'xy', 'xiangyang', 'null', '154002'),
(656, '001008009004', '东风', '001008009', 84, '中国/黑龙江/佳木斯/东风', '区', 4, 'df', 'dongfeng', 'null', '154005'),
(657, '001008009005', '郊区', '001008009', 84, '中国/黑龙江/佳木斯/郊区', 'null', 4, 'j', 'jiao', 'null', '154004'),
(658, '001008009006', '同江', '001008009', 84, '中国/黑龙江/佳木斯/同江', '市', 4, 'tj', 'tongjiang', 'null', '156400'),
(659, '001008009007', '富锦', '001008009', 84, '中国/黑龙江/佳木斯/富锦', '市', 4, 'fj', 'fujin', 'null', '156100'),
(660, '001008009008', '桦南', '001008009', 84, '中国/黑龙江/佳木斯/桦南', '县', 4, 'n', 'nan', 'null', '154400'),
(661, '001008009009', '桦川', '001008009', 84, '中国/黑龙江/佳木斯/桦川', '县', 4, 'c', 'chuan', 'null', '154300'),
(662, '001008009010', '汤原', '001008009', 84, '中国/黑龙江/佳木斯/汤原', '县', 4, 'ty', 'tangyuan', 'null', '154700'),
(663, '001008009011', '抚远', '001008009', 84, '中国/黑龙江/佳木斯/抚远', '县', 4, 'fy', 'fuyuan', 'null', '156500'),
(664, '001008010001', '桃山', '001008010', 85, '中国/黑龙江/七台河/桃山', '区', 4, 'ts', 'taoshan', 'null', '154600'),
(665, '001008010002', '新兴', '001008010', 85, '中国/黑龙江/七台河/新兴', '区', 4, 'xx', 'xinxing', 'null', '154604'),
(666, '001008010003', '茄子河', '001008010', 85, '中国/黑龙江/七台河/茄子河', '区', 4, 'qzh', 'qiezihe', 'null', '154622'),
(667, '001008010004', '勃利', '001008010', 85, '中国/黑龙江/七台河/勃利', '县', 4, 'bl', 'boli', 'null', '154500'),
(668, '001008011001', '爱辉', '001008011', 86, '中国/黑龙江/黑河/爱辉', '区', 4, 'ah', 'aihui', 'null', '164300'),
(669, '001008011002', '北安', '001008011', 86, '中国/黑龙江/黑河/北安', '市', 4, 'ba', 'beian', 'null', '164000'),
(670, '001008011003', '五大连池', '001008011', 86, '中国/黑龙江/黑河/五大连池', '市', 4, 'wdlc', 'wudalianchi', 'null', '164100'),
(671, '001008011004', '嫩江', '001008011', 86, '中国/黑龙江/黑河/嫩江', '县', 4, 'nj', 'nenjiang', 'null', '161400'),
(672, '001008011005', '逊克', '001008011', 86, '中国/黑龙江/黑河/逊克', '县', 4, 'xk', 'xunke', 'null', '164400'),
(673, '001008011006', '孙吴', '001008011', 86, '中国/黑龙江/黑河/孙吴', '县', 4, 'sw', 'sunwu', 'null', '164200'),
(674, '001008012001', '北林', '001008012', 87, '中国/黑龙江/绥化/北林', '区', 4, 'bl', 'beilin', 'null', '152000'),
(675, '001008012002', '安达', '001008012', 87, '中国/黑龙江/绥化/安达', '市', 4, 'ad', 'anda', 'null', '151400'),
(676, '001008012003', '肇东', '001008012', 87, '中国/黑龙江/绥化/肇东', '市', 4, 'zd', 'zhaodong', 'null', '151100'),
(677, '001008012004', '海伦', '001008012', 87, '中国/黑龙江/绥化/海伦', '市', 4, 'hl', 'hailun', 'null', '152300'),
(678, '001008012005', '望奎', '001008012', 87, '中国/黑龙江/绥化/望奎', '县', 4, 'wk', 'wangkui', 'null', '152101'),
(679, '001008012006', '兰西', '001008012', 87, '中国/黑龙江/绥化/兰西', '县', 4, 'lx', 'lanxi', 'null', '151500'),
(680, '001008012007', '青冈', '001008012', 87, '中国/黑龙江/绥化/青冈', '县', 4, 'qg', 'qinggang', 'null', '151600'),
(681, '001008012008', '庆安', '001008012', 87, '中国/黑龙江/绥化/庆安', '县', 4, 'qa', 'qingan', 'null', '152400'),
(682, '001008012009', '明水', '001008012', 87, '中国/黑龙江/绥化/明水', '县', 4, 'ms', 'mingshui', 'null', '151700'),
(683, '001008012010', '绥棱', '001008012', 87, '中国/黑龙江/绥化/绥棱', '县', 4, 'sl', 'suileng', 'null', '152200'),
(684, '001008013001', '呼玛', '001008013', 88, '中国/黑龙江/大兴安岭/呼玛', '县', 4, 'hm', 'huma', 'null', '165100'),
(685, '001008013002', '塔河', '001008013', 88, '中国/黑龙江/大兴安岭/塔河', '县', 4, 'th', 'tahe', 'null', '165200'),
(686, '001008013003', '漠河', '001008013', 88, '中国/黑龙江/大兴安岭/漠河', '县', 4, 'mh', 'mohe', 'null', '165300'),
(687, '001010001001', '玄武', '001010001', 89, '中国/江苏/南京/玄武', '区', 4, 'xw', 'xuanwu', 'null', '210018'),
(688, '001010001002', '白下', '001010001', 89, '中国/江苏/南京/白下', '区', 4, 'bx', 'baixia', 'null', '210002'),
(689, '001010001003', '秦淮', '001010001', 89, '中国/江苏/南京/秦淮', '区', 4, 'qh', 'qinhuai', 'null', '210001'),
(690, '001010001004', '建邺', '001010001', 89, '中国/江苏/南京/建邺', '区', 4, 'j', 'jian', 'null', '210004'),
(691, '001010001005', '鼓楼', '001010001', 89, '中国/江苏/南京/鼓楼', '区', 4, 'gl', 'gulou', 'null', '210009'),
(692, '001010001006', '下关', '001010001', 89, '中国/江苏/南京/下关', '区', 4, 'xg', 'xiaguan', 'null', '210011'),
(693, '001010001007', '浦口', '001010001', 89, '中国/江苏/南京/浦口', '区', 4, 'pk', 'pukou', 'null', '211800'),
(694, '001010001008', '六合', '001010001', 89, '中国/江苏/南京/六合', '区', 4, 'lh', 'liuhe', 'null', '211500'),
(695, '001010001009', '栖霞', '001010001', 89, '中国/江苏/南京/栖霞', '区', 4, 'qx', 'qixia', 'null', '210046'),
(696, '001010001010', '雨花台', '001010001', 89, '中国/江苏/南京/雨花台', '区', 4, 'yht', 'yuhuatai', 'null', '210012'),
(697, '001010001011', '江宁', '001010001', 89, '中国/江苏/南京/江宁', '区', 4, 'jn', 'jiangning', 'null', '211100'),
(698, '001010001012', '溧水', '001010001', 89, '中国/江苏/南京/溧水', '县', 4, 's', 'shui', 'null', '211200'),
(699, '001010001013', '高淳', '001010001', 89, '中国/江苏/南京/高淳', '县', 4, 'gc', 'gaochun', 'null', '211300'),
(700, '001010002001', '云龙', '001010002', 90, '中国/江苏/徐州/云龙', '区', 4, 'yl', 'yunlong', 'null', '221009'),
(701, '001010002002', '鼓楼', '001010002', 90, '中国/江苏/徐州/鼓楼', '区', 4, 'gl', 'gulou', 'null', '221005'),
(702, '001010002003', '九里', '001010002', 90, '中国/江苏/徐州/九里', '区', 4, 'jl', 'jiuli', 'null', '221040'),
(703, '001010002004', '贾汪', '001010002', 90, '中国/江苏/徐州/贾汪', '区', 4, 'jw', 'jiawang', 'null', '221011'),
(704, '001010002005', '泉山', '001010002', 90, '中国/江苏/徐州/泉山', '区', 4, 'qs', 'quanshan', 'null', '221006'),
(705, '001010002006', '邳州', '001010002', 90, '中国/江苏/徐州/邳州', '市', 4, 'null', 'null', 'null', '221300'),
(706, '001010002007', '新沂', '001010002', 90, '中国/江苏/徐州/新沂', '市', 4, 'xy', 'xinyi', 'null', '221400'),
(707, '001010002008', '铜山', '001010002', 90, '中国/江苏/徐州/铜山', '县', 4, 'ts', 'tongshan', 'null', '221116'),
(708, '001010002009', '睢宁', '001010002', 90, '中国/江苏/徐州/睢宁', '县', 4, 'n', 'ning', 'null', '221200'),
(709, '001010002010', '沛县', '001010002', 90, '中国/江苏/徐州/沛县', 'null', 4, 'p', 'pei', 'null', '221600'),
(710, '001010002011', '丰县', '001010002', 90, '中国/江苏/徐州/丰县', 'null', 4, 'f', 'feng', 'null', '221700'),
(711, '001010003001', '新浦', '001010003', 91, '中国/江苏/连云港/新浦', '区', 4, 'xp', 'xinpu', 'null', '222003'),
(712, '001010003002', '连云', '001010003', 91, '中国/江苏/连云港/连云', '区', 4, 'ly', 'lianyun', 'null', '222042'),
(713, '001010003003', '海州', '001010003', 91, '中国/江苏/连云港/海州', '区', 4, 'hz', 'haizhou', 'null', '222023'),
(714, '001010003004', '赣榆', '001010003', 91, '中国/江苏/连云港/赣榆', '县', 4, 'gy', 'ganyu', 'null', '222100'),
(715, '001010003005', '灌云', '001010003', 91, '中国/江苏/连云港/灌云', '县', 4, 'gy', 'guanyun', 'null', '222200'),
(716, '001010003006', '东海', '001010003', 91, '中国/江苏/连云港/东海', '县', 4, 'dh', 'donghai', 'null', '222300'),
(717, '001010003007', '灌南', '001010003', 91, '中国/江苏/连云港/灌南', '县', 4, 'gn', 'guannan', 'null', '222500'),
(718, '001010004001', '清河', '001010004', 92, '中国/江苏/淮安/清河', '区', 4, 'qh', 'qinghe', 'null', '223001'),
(719, '001010004002', '清浦', '001010004', 92, '中国/江苏/淮安/清浦', '区', 4, 'qp', 'qingpu', 'null', '223002'),
(720, '001010004003', '楚州', '001010004', 92, '中国/江苏/淮安/楚州', '区', 4, 'cz', 'chuzhou', 'null', '223200'),
(721, '001010004004', '淮阴', '001010004', 92, '中国/江苏/淮安/淮阴', '区', 4, 'hy', 'huaiyin', 'null', '223300'),
(722, '001010004005', '金湖', '001010004', 92, '中国/江苏/淮安/金湖', '县', 4, 'jh', 'jinhu', 'null', '211600'),
(723, '001010004006', '盱眙', '001010004', 92, '中国/江苏/淮安/盱眙', '县', 4, 'null', 'null', 'null', '211700'),
(724, '001010004007', '洪泽', '001010004', 92, '中国/江苏/淮安/洪泽', '县', 4, 'hz', 'hongze', 'null', '223100'),
(725, '001010004008', '涟水', '001010004', 92, '中国/江苏/淮安/涟水', '县', 4, 'ls', 'lianshui', 'null', '223400'),
(726, '001010005001', '宿城', '001010005', 93, '中国/江苏/宿迁/宿城', '区', 4, 'sc', 'sucheng', 'null', '223800'),
(727, '001010005002', '宿豫', '001010005', 93, '中国/江苏/宿迁/宿豫', '县', 4, 'sy', 'suyu', 'null', '223800'),
(728, '001010005003', '沭阳', '001010005', 93, '中国/江苏/宿迁/沭阳', '县', 4, 'y', 'yang', 'null', '223600'),
(729, '001010005004', '泗阳', '001010005', 93, '中国/江苏/宿迁/泗阳', '县', 4, 'y', 'yang', 'null', '223700'),
(730, '001010005005', '泗洪', '001010005', 93, '中国/江苏/宿迁/泗洪', '县', 4, 'h', 'hong', 'null', '223900'),
(731, '001010006001', '城区', '001010006', 94, '中国/江苏/盐城/城区', 'null', 4, 'c', 'cheng', 'null', '224005'),
(732, '001010006002', '东台', '001010006', 94, '中国/江苏/盐城/东台', '市', 4, 'dt', 'dongtai', 'null', '224200'),
(733, '001010006003', '大丰', '001010006', 94, '中国/江苏/盐城/大丰', '市', 4, 'df', 'dafeng', 'null', '224100'),
(734, '001010006004', '盐都', '001010006', 94, '中国/江苏/盐城/盐都', '县', 4, 'yd', 'yandu', 'null', '224055'),
(735, '001010006005', '射阳', '001010006', 94, '中国/江苏/盐城/射阳', '县', 4, 'sy', 'sheyang', 'null', '224300'),
(736, '001010006006', '阜宁', '001010006', 94, '中国/江苏/盐城/阜宁', '县', 4, 'fn', 'funing', 'null', '224400'),
(737, '001010006007', '滨海', '001010006', 94, '中国/江苏/盐城/滨海', '县', 4, 'bh', 'binhai', 'null', '224500'),
(738, '001010006008', '响水', '001010006', 94, '中国/江苏/盐城/响水', '县', 4, 'xs', 'xiangshui', 'null', '224600'),
(739, '001010006009', '建湖', '001010006', 94, '中国/江苏/盐城/建湖', '县', 4, 'jh', 'jianhu', 'null', '224700'),
(740, '001010007001', '广陵', '001010007', 95, '中国/江苏/扬州/广陵', '区', 4, 'gl', 'guangling', 'null', '225002'),
(741, '001010007002', '维扬', '001010007', 95, '中国/江苏/扬州/维扬', '区', 4, 'wy', 'weiyang', 'null', '225002'),
(742, '001010007003', '邗江', '001010007', 95, '中国/江苏/扬州/邗江', '区', 4, 'j', 'jiang', 'null', '225002'),
(743, '001010007004', '仪征', '001010007', 95, '中国/江苏/扬州/仪征', '市', 4, 'yz', 'yizheng', 'null', '211400'),
(744, '001010007005', '江都', '001010007', 95, '中国/江苏/扬州/江都', '市', 4, 'jd', 'jiangdu', 'null', '225200'),
(745, '001010007006', '高邮', '001010007', 95, '中国/江苏/扬州/高邮', '市', 4, 'gy', 'gaoyou', 'null', '225600'),
(746, '001010007007', '宝应', '001010007', 95, '中国/江苏/扬州/宝应', '县', 4, 'by', 'baoying', 'null', '225800'),
(747, '001010008001', '海陵', '001010008', 96, '中国/江苏/泰州/海陵', '区', 4, 'hl', 'hailing', 'null', '225300'),
(748, '001010008002', '高港', '001010008', 96, '中国/江苏/泰州/高港', '区', 4, 'gg', 'gaogang', 'null', '225321'),
(749, '001010008003', '靖江', '001010008', 96, '中国/江苏/泰州/靖江', '市', 4, 'jj', 'jingjiang', 'null', '214500'),
(750, '001010008004', '泰兴', '001010008', 96, '中国/江苏/泰州/泰兴', '市', 4, 'tx', 'taixing', 'null', '225400'),
(751, '001010008005', '姜堰', '001010008', 96, '中国/江苏/泰州/姜堰', '市', 4, 'jy', 'jiangyan', 'null', '225500'),
(752, '001010008006', '兴化', '001010008', 96, '中国/江苏/泰州/兴化', '市', 4, 'xh', 'xinghua', 'null', '225700'),
(753, '001010009001', '崇川', '001010009', 97, '中国/江苏/南通/崇川', '区', 4, 'cc', 'chongchuan', 'null', '226001'),
(754, '001010009002', '港闸', '001010009', 97, '中国/江苏/南通/港闸', '区', 4, 'gz', 'gangzha', 'null', '226001'),
(755, '001010009003', '海门', '001010009', 97, '中国/江苏/南通/海门', '市', 4, 'hm', 'haimen', 'null', '226100'),
(756, '001010009004', '启东', '001010009', 97, '中国/江苏/南通/启东', '市', 4, 'qd', 'qidong', 'null', '226200'),
(757, '001010009005', '通州', '001010009', 97, '中国/江苏/南通/通州', '市', 4, 'tz', 'tongzhou', 'null', '226300'),
(758, '001010009006', '如皋', '001010009', 97, '中国/江苏/南通/如皋', '市', 4, 'rg', 'rugao', 'null', '226500'),
(759, '001010009007', '如东', '001010009', 97, '中国/江苏/南通/如东', '县', 4, 'rd', 'rudong', 'null', '226400'),
(760, '001010009008', '海安', '001010009', 97, '中国/江苏/南通/海安', '县', 4, 'ha', 'haian', 'null', '226600'),
(761, '001010010001', '京口', '001010010', 98, '中国/江苏/镇江/京口', '区', 4, 'jk', 'jingkou', 'null', '226001'),
(762, '001010010002', '润州', '001010010', 98, '中国/江苏/镇江/润州', '区', 4, 'rz', 'runzhou', 'null', '212004'),
(763, '001010010003', '丹徒', '001010010', 98, '中国/江苏/镇江/丹徒', '区', 4, 'dt', 'dantu', 'null', '212200'),
(764, '001010010004', '丹阳', '001010010', 98, '中国/江苏/镇江/丹阳', '市', 4, 'dy', 'danyang', 'null', '212300'),
(765, '001010010005', '句容', '001010010', 98, '中国/江苏/镇江/句容', '市', 4, 'jr', 'jurong', 'null', '212400'),
(766, '001010011001', '钟楼', '001010011', 99, '中国/江苏/常州/钟楼', '区', 4, 'zl', 'zhonglou', 'null', '213002'),
(767, '001010011002', '天宁', '001010011', 99, '中国/江苏/常州/天宁', '区', 4, 'tn', 'tianning', 'null', '213003'),
(768, '001010011003', '戚墅堰', '001010011', 99, '中国/江苏/常州/戚墅堰', '区', 4, 'qsy', 'qishuyan', 'null', '213011'),
(769, '001010011004', '新北', '001010011', 99, '中国/江苏/常州/新北', '区', 4, 'xb', 'xinbei', 'null', '213161'),
(770, '001010011005', '金坛', '001010011', 99, '中国/江苏/常州/金坛', '市', 4, 'jt', 'jintan', 'null', '213200'),
(771, '001010011006', '溧阳', '001010011', 99, '中国/江苏/常州/溧阳', '市', 4, 'y', 'yang', 'null', '213300'),
(772, '001010012001', '崇安', '001010012', 100, '中国/江苏/无锡/崇安', '区', 4, 'ca', 'chongan', 'null', '214002'),
(773, '001010012002', '南长', '001010012', 100, '中国/江苏/无锡/南长', '区', 4, 'nc', 'nanchang', 'null', '214021');
INSERT INTO `des_district` (`serialId`, `districtId`, `districtName`, `districtUpId`, `districtUpIdNum`, `districtPath`, `districtType`, `districtTypeNum`, `shortName`, `spell`, `areaId`, `postCode`) VALUES
(774, '001010012003', '北塘', '001010012', 100, '中国/江苏/无锡/北塘', '区', 4, 'bt', 'beitang', 'null', '214044'),
(775, '001010012004', '滨湖', '001010012', 100, '中国/江苏/无锡/滨湖', '区', 4, 'bh', 'binhu', 'null', '214062'),
(776, '001010012005', '惠山', '001010012', 100, '中国/江苏/无锡/惠山', '区', 4, 'hs', 'huishan', 'null', '214187'),
(777, '001010012006', '锡山', '001010012', 100, '中国/江苏/无锡/锡山', '区', 4, 'xs', 'xishan', 'null', '214101'),
(778, '001010012007', '江阴', '001010012', 100, '中国/江苏/无锡/江阴', '市', 4, 'jy', 'jiangyin', 'null', '214400'),
(779, '001010012008', '宜兴', '001010012', 100, '中国/江苏/无锡/宜兴', '市', 4, 'yx', 'yixing', 'null', '214200'),
(780, '001010013001', '金阊', '001010013', 101, '中国/江苏/苏州/金阊', '区', 4, 'j', 'jin', 'null', '215008'),
(781, '001010013002', '沧浪', '001010013', 101, '中国/江苏/苏州/沧浪', '区', 4, 'cl', 'canglang', 'null', '215006'),
(782, '001010013003', '平江', '001010013', 101, '中国/江苏/苏州/平江', '区', 4, 'pj', 'pingjiang', 'null', '215005'),
(783, '001010013004', '虎丘', '001010013', 101, '中国/江苏/苏州/虎丘', '区', 4, 'hq', 'huqiu', 'null', '215004'),
(784, '001010013005', '吴中', '001010013', 101, '中国/江苏/苏州/吴中', '区', 4, 'wz', 'wuzhong', 'null', '215128'),
(785, '001010013006', '相城', '001010013', 101, '中国/江苏/苏州/相城', '区', 4, 'xc', 'xiangcheng', 'null', '215131'),
(786, '001010013007', '吴江', '001010013', 101, '中国/江苏/苏州/吴江', '市', 4, 'wj', 'wujiang', 'null', '215200'),
(787, '001010013008', '昆山', '001010013', 101, '中国/江苏/苏州/昆山', '市', 4, 'ks', 'kunshan', 'null', '215300'),
(788, '001010013009', '太仓', '001010013', 101, '中国/江苏/苏州/太仓', '市', 4, 'tc', 'taicang', 'null', '215400'),
(789, '001010013010', '常熟', '001010013', 101, '中国/江苏/苏州/常熟', '市', 4, 'cs', 'changshu', 'null', '215500'),
(790, '001010013011', '张家港', '001010013', 101, '中国/江苏/苏州/张家港', '市', 4, 'zjg', 'zhangjiagan', 'null', '215600'),
(791, '001011001001', '拱墅', '001011001', 102, '中国/浙江/杭州/拱墅', '区', 4, 'gs', 'gongshu', 'null', '310011'),
(792, '001011001002', '上城', '001011001', 102, '中国/浙江/杭州/上城', '区', 4, 'sc', 'shangcheng', 'null', '311500'),
(793, '001011001003', '下城', '001011001', 102, '中国/浙江/杭州/下城', '区', 4, 'xc', 'xiacheng', 'null', '310006'),
(794, '001011001004', '江干', '001011001', 102, '中国/浙江/杭州/江干', '区', 4, 'jg', 'jianggan', 'null', '310002'),
(795, '001011001005', '西湖', '001011001', 102, '中国/浙江/杭州/西湖', '区', 4, 'xh', 'xihu', 'null', '310013'),
(796, '001011001006', '滨江', '001011001', 102, '中国/浙江/杭州/滨江', '区', 4, 'bj', 'binjiang', 'null', '310051'),
(797, '001011001007', '余杭', '001011001', 102, '中国/浙江/杭州/余杭', '区', 4, 'yh', 'yuhang', 'null', '311000'),
(798, '001011001008', '萧山', '001011001', 102, '中国/浙江/杭州/萧山', '区', 4, 'xs', 'xiaoshan', 'null', '311200'),
(799, '001011001009', '临安', '001011001', 102, '中国/浙江/杭州/临安', '市', 4, 'la', 'linan', 'null', '311300'),
(800, '001011001010', '富阳', '001011001', 102, '中国/浙江/杭州/富阳', '市', 4, 'fy', 'fuyang', 'null', '311400'),
(801, '001011001011', '建德', '001011001', 102, '中国/浙江/杭州/建德', '市', 4, 'jd', 'jiande', 'null', '311600'),
(802, '001011001012', '桐庐', '001011001', 102, '中国/浙江/杭州/桐庐', '县', 4, 'tl', 'tonglu', 'null', '311500'),
(803, '001011001013', '淳安', '001011001', 102, '中国/浙江/杭州/淳安', '县', 4, 'ca', 'chunan', 'null', '311700'),
(804, '001011002001', '海曙', '001011002', 103, '中国/浙江/宁波/海曙', '区', 4, 'hs', 'haishu', 'null', '315000'),
(805, '001011002002', '江东', '001011002', 103, '中国/浙江/宁波/江东', '区', 4, 'jd', 'jiangdong', 'null', '315040'),
(806, '001011002003', '江北', '001011002', 103, '中国/浙江/宁波/江北', '区', 4, 'jb', 'jiangbei', 'null', '315020'),
(807, '001011002004', '镇海', '001011002', 103, '中国/浙江/宁波/镇海', '区', 4, 'zh', 'zhenhai', 'null', '315200'),
(808, '001011002005', '北仑', '001011002', 103, '中国/浙江/宁波/北仑', '区', 4, 'bl', 'beilun', 'null', '315800'),
(809, '001011002006', '鄞州', '001011002', 103, '中国/浙江/宁波/鄞州', '区', 4, 'yz', 'yinzhou', 'null', '315040'),
(810, '001011002007', '余姚', '001011002', 103, '中国/浙江/宁波/余姚', '市', 4, 'yy', 'yuyao', 'null', '315400'),
(811, '001011002008', '慈溪', '001011002', 103, '中国/浙江/宁波/慈溪', '市', 4, 'cx', 'cixi', 'null', '315300'),
(812, '001011002009', '奉化', '001011002', 103, '中国/浙江/宁波/奉化', '市', 4, 'fh', 'fenghua', 'null', '315500'),
(813, '001011002010', '宁海', '001011002', 103, '中国/浙江/宁波/宁海', '县', 4, 'nh', 'ninghai', 'null', '315600'),
(814, '001011002011', '象山', '001011002', 103, '中国/浙江/宁波/象山', '县', 4, 'xs', 'xiangshan', 'null', '315700'),
(815, '001011003001', '鹿城', '001011003', 104, '中国/浙江/温州/鹿城', '区', 4, 'lc', 'lucheng', 'null', '325000'),
(816, '001011003002', '龙湾', '001011003', 104, '中国/浙江/温州/龙湾', '区', 4, 'lw', 'longwan', 'null', '325013'),
(817, '001011003003', '瓯海', '001011003', 104, '中国/浙江/温州/瓯海', '区', 4, 'h', 'hai', 'null', '325005'),
(818, '001011003004', '瑞安', '001011003', 104, '中国/浙江/温州/瑞安', '市', 4, 'ra', 'ruian', 'null', '325200'),
(819, '001011003005', '乐清', '001011003', 104, '中国/浙江/温州/乐清', '市', 4, 'lq', 'leqing', 'null', '325600'),
(820, '001011003006', '永嘉', '001011003', 104, '中国/浙江/温州/永嘉', '县', 4, 'yj', 'yongjia', 'null', '325100'),
(821, '001011003007', '文成', '001011003', 104, '中国/浙江/温州/文成', '县', 4, 'wc', 'wencheng', 'null', '325300'),
(822, '001011003008', '平阳', '001011003', 104, '中国/浙江/温州/平阳', '县', 4, 'py', 'pingyang', 'null', '325400'),
(823, '001011003009', '泰顺', '001011003', 104, '中国/浙江/温州/泰顺', '县', 4, 'ts', 'taishun', 'null', '325500'),
(824, '001011003010', '洞头', '001011003', 104, '中国/浙江/温州/洞头', '县', 4, 'dt', 'dongtou', 'null', '325700'),
(825, '001011003011', '苍南', '001011003', 104, '中国/浙江/温州/苍南', '县', 4, 'cn', 'cangnan', 'null', '325800'),
(826, '001011004001', '秀城', '001011004', 105, '中国/浙江/嘉兴/秀城', '区', 4, 'xc', 'xiucheng', 'null', '314001'),
(827, '001011004002', '秀洲', '001011004', 105, '中国/浙江/嘉兴/秀洲', '区', 4, 'xz', 'xiuzhou', 'null', '314001'),
(828, '001011004003', '海宁', '001011004', 105, '中国/浙江/嘉兴/海宁', '市', 4, 'hn', 'haining', 'null', '314400'),
(829, '001011004004', '平湖', '001011004', 105, '中国/浙江/嘉兴/平湖', '市', 4, 'ph', 'pinghu', 'null', '314200'),
(830, '001011004005', '桐乡', '001011004', 105, '中国/浙江/嘉兴/桐乡', '市', 4, 'tx', 'tongxiang', 'null', '314500'),
(831, '001011004006', '嘉善', '001011004', 105, '中国/浙江/嘉兴/嘉善', '县', 4, 'js', 'jiashan', 'null', '314100'),
(832, '001011004007', '海盐', '001011004', 105, '中国/浙江/嘉兴/海盐', '县', 4, 'hy', 'haiyan', 'null', '314300'),
(833, '001011005001', '长兴', '001011005', 106, '中国/浙江/湖州/长兴', '县', 4, 'cx', 'changxing', 'null', '313100'),
(834, '001011005002', '德清', '001011005', 106, '中国/浙江/湖州/德清', '县', 4, 'dq', 'deqing', 'null', '313200'),
(835, '001011005003', '安吉', '001011005', 106, '中国/浙江/湖州/安吉', '县', 4, 'aj', 'anji', 'null', '313300'),
(836, '001011006001', '越城', '001011006', 107, '中国/浙江/绍兴/越城', '区', 4, 'yc', 'yuecheng', 'null', '312000'),
(837, '001011006002', '诸暨', '001011006', 107, '中国/浙江/绍兴/诸暨', '市', 4, 'z', 'zhu', 'null', '311800'),
(838, '001011006003', '上虞', '001011006', 107, '中国/浙江/绍兴/上虞', '市', 4, 'sy', 'shangyu', 'null', '312300'),
(839, '001011006004', '嵊州', '001011006', 107, '中国/浙江/绍兴/嵊州', '市', 4, 'sz', 'shengzhou', 'null', '312400'),
(840, '001011006005', '绍兴', '001011006', 107, '中国/浙江/绍兴/绍兴', '县', 4, 'sx', 'shaoxing', 'null', '312000'),
(841, '001011006006', '新昌', '001011006', 107, '中国/浙江/绍兴/新昌', '县', 4, 'xc', 'xinchang', 'null', '312500'),
(842, '001011007001', '婺城', '001011007', 108, '中国/浙江/金华/婺城', '区', 4, 'c', 'cheng', 'null', '321000'),
(843, '001011007002', '金东', '001011007', 108, '中国/浙江/金华/金东', '区', 4, 'jd', 'jindong', 'null', '321000'),
(844, '001011007003', '兰溪', '001011007', 108, '中国/浙江/金华/兰溪', '市', 4, 'lx', 'lanxi', 'null', '321100'),
(845, '001011007004', '永康', '001011007', 108, '中国/浙江/金华/永康', '市', 4, 'yk', 'yongkang', 'null', '321300'),
(846, '001011007005', '义乌', '001011007', 108, '中国/浙江/金华/义乌', '市', 4, 'yw', 'yiwu', 'null', '322000'),
(847, '001011007006', '东阳', '001011007', 108, '中国/浙江/金华/东阳', '市', 4, 'dy', 'dongyang', 'null', '322100'),
(848, '001011007007', '武义', '001011007', 108, '中国/浙江/金华/武义', '县', 4, 'wy', 'wuyi', 'null', '321200'),
(849, '001011007008', '浦江', '001011007', 108, '中国/浙江/金华/浦江', '县', 4, 'pj', 'pujiang', 'null', '322200'),
(850, '001011007009', '磐安', '001011007', 108, '中国/浙江/金华/磐安', '县', 4, 'pa', 'panan', 'null', '322300'),
(851, '001011008001', '柯城', '001011008', 109, '中国/浙江/衢州/柯城', '区', 4, 'kc', 'kecheng', 'null', '324000'),
(852, '001011008002', '衢江', '001011008', 109, '中国/浙江/衢州/衢江', '区', 4, 'j', 'jiang', 'null', '324022'),
(853, '001011008003', '江山', '001011008', 109, '中国/浙江/衢州/江山', '市', 4, 'js', 'jiangshan', 'null', '324100'),
(854, '001011008004', '常山', '001011008', 109, '中国/浙江/衢州/常山', '县', 4, 'cs', 'changshan', 'null', '324200'),
(855, '001011008005', '开化', '001011008', 109, '中国/浙江/衢州/开化', '县', 4, 'kh', 'kaihua', 'null', '324300'),
(856, '001011008006', '龙游', '001011008', 109, '中国/浙江/衢州/龙游', '县', 4, 'ly', 'longyou', 'null', '324400'),
(857, '001011009001', '定海', '001011009', 110, '中国/浙江/舟山/定海', '区', 4, 'dh', 'dinghai', 'null', '316000'),
(858, '001011009002', '普陀', '001011009', 110, '中国/浙江/舟山/普陀', '区', 4, 'pt', 'putuo', 'null', '316100'),
(859, '001011009003', '岱山', '001011009', 110, '中国/浙江/舟山/岱山', '县', 4, 's', 'shan', 'null', '316200'),
(860, '001011009004', '嵊泗', '001011009', 110, '中国/浙江/舟山/嵊泗', '县', 4, 'null', 'null', 'null', '202450'),
(861, '001011010001', '椒江', '001011010', 111, '中国/浙江/台州/椒江', '区', 4, 'jj', 'jiaojiang', 'null', '318000'),
(862, '001011010002', '黄岩', '001011010', 111, '中国/浙江/台州/黄岩', '区', 4, 'hy', 'huangyan', 'null', '318020'),
(863, '001011010003', '路桥', '001011010', 111, '中国/浙江/台州/路桥', '区', 4, 'lq', 'luqiao', 'null', '318050'),
(864, '001011010004', '临海', '001011010', 111, '中国/浙江/台州/临海', '市', 4, 'lh', 'linhai', 'null', '317000'),
(865, '001011010005', '温岭', '001011010', 111, '中国/浙江/台州/温岭', '市', 4, 'wl', 'wenling', 'null', '317500'),
(866, '001011010006', '三门', '001011010', 111, '中国/浙江/台州/三门', '县', 4, 'sm', 'sanmen', 'null', '317100'),
(867, '001011010007', '天台', '001011010', 111, '中国/浙江/台州/天台', '县', 4, 'tt', 'tiantai', 'null', '317200'),
(868, '001011010008', '仙居', '001011010', 111, '中国/浙江/台州/仙居', '县', 4, 'xj', 'xianju', 'null', '317300'),
(869, '001011010009', '玉环', '001011010', 111, '中国/浙江/台州/玉环', '县', 4, 'yh', 'yuhuan', 'null', '317600'),
(870, '001011011001', '莲都', '001011011', 112, '中国/浙江/丽水/莲都', '区', 4, 'ld', 'liandu', 'null', '323000'),
(871, '001011011002', '龙泉', '001011011', 112, '中国/浙江/丽水/龙泉', '市', 4, 'lq', 'longquan', 'null', '323700'),
(872, '001011011003', '缙云', '001011011', 112, '中国/浙江/丽水/缙云', '县', 4, 'y', 'yun', 'null', '321400'),
(873, '001011011004', '青田', '001011011', 112, '中国/浙江/丽水/青田', '县', 4, 'qt', 'qingtian', 'null', '323900'),
(874, '001011011005', '云和', '001011011', 112, '中国/浙江/丽水/云和', '县', 4, 'yh', 'yunhe', 'null', '323600'),
(875, '001011011006', '遂昌', '001011011', 112, '中国/浙江/丽水/遂昌', '县', 4, 'sc', 'suichang', 'null', '323300'),
(876, '001011011007', '松阳', '001011011', 112, '中国/浙江/丽水/松阳', '县', 4, 'sy', 'songyang', 'null', '323400'),
(877, '001011011008', '庆元', '001011011', 112, '中国/浙江/丽水/庆元', '县', 4, 'qy', 'qingyuan', 'null', '323800'),
(878, '001011011009', '景宁', '001011011', 112, '中国/浙江/丽水/景宁', '畲族自治县', 4, 'jnzzz', 'jingningzuz', 'null', '323500'),
(879, '001012001001', '瑶海', '001012001', 113, '中国/安徽/合肥/瑶海', '区', 4, 'yh', 'yaohai', 'null', '230011'),
(880, '001012001002', '庐阳', '001012001', 113, '中国/安徽/合肥/庐阳', '区', 4, 'ly', 'luyang', 'null', '230001'),
(881, '001012001003', '蜀山', '001012001', 113, '中国/安徽/合肥/蜀山', '区', 4, 'ss', 'shushan', 'null', '230061'),
(882, '001012001004', '包河', '001012001', 113, '中国/安徽/合肥/包河', '区', 4, 'bh', 'baohe', 'null', '230041'),
(883, '001012001005', '长丰', '001012001', 113, '中国/安徽/合肥/长丰', '县', 4, 'cf', 'changfeng', 'null', '231100'),
(884, '001012001006', '肥东', '001012001', 113, '中国/安徽/合肥/肥东', '县', 4, 'fd', 'feidong', 'null', '231600'),
(885, '001012001007', '肥西', '001012001', 113, '中国/安徽/合肥/肥西', '县', 4, 'fx', 'feixi', 'null', '231200'),
(886, '001012002001', '镜湖', '001012002', 114, '中国/安徽/芜湖/镜湖', '区', 4, 'jh', 'jinghu', 'null', '241000'),
(887, '001012002002', '马塘', '001012002', 114, '中国/安徽/芜湖/马塘', '区', 4, 'mt', 'matang', 'null', '241002'),
(888, '001012002003', '新芜', '001012002', 114, '中国/安徽/芜湖/新芜', '区', 4, 'xw', 'xinwu', 'null', '241000'),
(889, '001012002004', '鸠江', '001012002', 114, '中国/安徽/芜湖/鸠江', '区', 4, 'j', 'jiang', 'null', '241000'),
(890, '001012002005', '芜湖', '001012002', 114, '中国/安徽/芜湖/芜湖', '县', 4, 'wh', 'wuhu', 'null', '241100'),
(891, '001012002006', '繁昌', '001012002', 114, '中国/安徽/芜湖/繁昌', '县', 4, 'fc', 'fanchang', 'null', '241200'),
(892, '001012002007', '南陵', '001012002', 114, '中国/安徽/芜湖/南陵', '县', 4, 'nl', 'nanling', 'null', '241300'),
(893, '001012003001', '中市', '001012003', 115, '中国/安徽/蚌埠/中市', '区', 4, 'z', 'zhong', 'null', '233000'),
(894, '001012003002', '东市', '001012003', 115, '中国/安徽/蚌埠/东市', '区', 4, 'd', 'dong', 'null', '233000'),
(895, '001012003003', '西市', '001012003', 115, '中国/安徽/蚌埠/西市', '区', 4, 'x', 'xi', 'null', '233000'),
(896, '001012003004', '郊区', '001012003', 115, '中国/安徽/蚌埠/郊区', 'null', 4, 'j', 'jiao', 'null', '233000'),
(897, '001012003005', '怀远', '001012003', 115, '中国/安徽/蚌埠/怀远', '县', 4, 'hy', 'huaiyuan', 'null', '233400'),
(898, '001012003006', '五河', '001012003', 115, '中国/安徽/蚌埠/五河', '县', 4, 'wh', 'wuhe', 'null', '233300'),
(899, '001012003007', '固镇', '001012003', 115, '中国/安徽/蚌埠/固镇', '县', 4, 'gz', 'guzhen', 'null', '233700'),
(900, '001012004001', '田家庵', '001012004', 116, '中国/安徽/淮南/田家庵', '区', 4, 'tj', 'tianjia', 'null', '232007'),
(901, '001012004002', '大通', '001012004', 116, '中国/安徽/淮南/大通', '区', 4, 'dt', 'datong', 'null', '232033'),
(902, '001012004003', '谢家集', '001012004', 116, '中国/安徽/淮南/谢家集', '区', 4, 'xjj', 'xiejiaji', 'null', '232052'),
(903, '001012004004', '八公山', '001012004', 116, '中国/安徽/淮南/八公山', '区', 4, 'bgs', 'bagongshan', 'null', '232072'),
(904, '001012004005', '潘集', '001012004', 116, '中国/安徽/淮南/潘集', '区', 4, 'pj', 'panji', 'null', '232087'),
(905, '001012004006', '凤台', '001012004', 116, '中国/安徽/淮南/凤台', '县', 4, 'ft', 'fengtai', 'null', '232100'),
(906, '001012005001', '雨山', '001012005', 117, '中国/安徽/马鞍山/雨山', '区', 4, 'ys', 'yushan', 'null', '243011'),
(907, '001012005002', '花山', '001012005', 117, '中国/安徽/马鞍山/花山', '区', 4, 'hs', 'huashan', 'null', '243000'),
(908, '001012005003', '金家庄', '001012005', 117, '中国/安徽/马鞍山/金家庄', '区', 4, 'jjz', 'jinjiazhuan', 'null', '243021'),
(909, '001012005004', '当涂', '001012005', 117, '中国/安徽/马鞍山/当涂', '县', 4, 'dt', 'dangtu', 'null', '243100'),
(910, '001012006001', '相山', '001012006', 118, '中国/安徽/淮北/相山', '区', 4, 'xs', 'xiangshan', 'null', '235000'),
(911, '001012006002', '杜集', '001012006', 118, '中国/安徽/淮北/杜集', '区', 4, 'dj', 'duji', 'null', '235047'),
(912, '001012006003', '烈山', '001012006', 118, '中国/安徽/淮北/烈山', '区', 4, 'ls', 'lieshan', 'null', '235025'),
(913, '001012006004', '濉溪', '001012006', 118, '中国/安徽/淮北/濉溪', '县', 4, 'x', 'xi', 'null', '235100'),
(914, '001012007001', '铜官山', '001012007', 119, '中国/安徽/铜陵/铜官山', '区', 4, 'tgs', 'tongguansha', 'null', '244000'),
(915, '001012007002', '狮子山', '001012007', 119, '中国/安徽/铜陵/狮子山', '区', 4, 'szs', 'shizishan', 'null', '244031'),
(916, '001012007003', '郊区', '001012007', 119, '中国/安徽/铜陵/郊区', 'null', 4, 'j', 'jiao', 'null', '244000'),
(917, '001012007004', '铜陵', '001012007', 119, '中国/安徽/铜陵/铜陵', '县', 4, 'tl', 'tongling', 'null', '244100'),
(918, '001012008001', '迎江', '001012008', 120, '中国/安徽/安庆/迎江', '区', 4, 'yj', 'yingjiang', 'null', '246003'),
(919, '001012008002', '大观', '001012008', 120, '中国/安徽/安庆/大观', '区', 4, 'dg', 'daguan', 'null', '246004'),
(920, '001012008003', '郊区', '001012008', 120, '中国/安徽/安庆/郊区', 'null', 4, 'j', 'jiao', 'null', '246003'),
(921, '001012008004', '桐城', '001012008', 120, '中国/安徽/安庆/桐城', '市', 4, 'tc', 'tongcheng', 'null', '231402'),
(922, '001012008005', '怀宁', '001012008', 120, '中国/安徽/安庆/怀宁', '县', 4, 'hn', 'huaining', 'null', '246100'),
(923, '001012008006', '枞阳', '001012008', 120, '中国/安徽/安庆/枞阳', '县', 4, 'y', 'yang', 'null', '246700'),
(924, '001012008007', '潜山', '001012008', 120, '中国/安徽/安庆/潜山', '县', 4, 'qs', 'qianshan', 'null', '246300'),
(925, '001012008008', '太湖', '001012008', 120, '中国/安徽/安庆/太湖', '县', 4, 'th', 'taihu', 'null', '246400'),
(926, '001012008009', '宿松', '001012008', 120, '中国/安徽/安庆/宿松', '县', 4, 'ss', 'susong', 'null', '246500'),
(927, '001012008010', '望江', '001012008', 120, '中国/安徽/安庆/望江', '县', 4, 'wj', 'wangjiang', 'null', '246200'),
(928, '001012008011', '岳西', '001012008', 120, '中国/安徽/安庆/岳西', '县', 4, 'yx', 'yuexi', 'null', '246600'),
(929, '001012009001', '屯溪', '001012009', 121, '中国/安徽/黄山/屯溪', '区', 4, 'tx', 'tunxi', 'null', '245000'),
(930, '001012009002', '黄山', '001012009', 121, '中国/安徽/黄山/黄山', '区', 4, 'hs', 'huangshan', 'null', '242700'),
(931, '001012009003', '徽州', '001012009', 121, '中国/安徽/黄山/徽州', '区', 4, 'hz', 'huizhou', 'null', '245061'),
(932, '001012009004', '歙县', '001012009', 121, '中国/安徽/黄山/歙县', 'null', 4, 'null', 'null', 'null', '245200'),
(933, '001012009005', '休宁', '001012009', 121, '中国/安徽/黄山/休宁', '县', 4, 'xn', 'xiuning', 'null', '245400'),
(934, '001012009006', '黟县', '001012009', 121, '中国/安徽/黄山/黟县', 'null', 4, 'null', 'null', 'null', '245500'),
(935, '001012009007', '祁门', '001012009', 121, '中国/安徽/黄山/祁门', '县', 4, 'qm', 'qimen', 'null', '245600'),
(936, '001012010001', '琅琊', '001012010', 122, '中国/安徽/滁州/琅琊', '区', 4, 'l', 'lang', 'null', '238058'),
(937, '001012010002', '南谯', '001012010', 122, '中国/安徽/滁州/南谯', '区', 4, 'n', 'nan', 'null', '239001'),
(938, '001012010003', '明光', '001012010', 122, '中国/安徽/滁州/明光', '市', 4, 'mg', 'mingguang', 'null', '239400'),
(939, '001012010004', '天长', '001012010', 122, '中国/安徽/滁州/天长', '市', 4, 'tc', 'tianchang', 'null', '239300'),
(940, '001012010005', '来安', '001012010', 122, '中国/安徽/滁州/来安', '县', 4, 'la', 'laian', 'null', '239200'),
(941, '001012010006', '全椒', '001012010', 122, '中国/安徽/滁州/全椒', '县', 4, 'qj', 'quanjiao', 'null', '239500'),
(942, '001012010007', '定远', '001012010', 122, '中国/安徽/滁州/定远', '县', 4, 'dy', 'dingyuan', 'null', '233201'),
(943, '001012010008', '凤阳', '001012010', 122, '中国/安徽/滁州/凤阳', '县', 4, 'fy', 'fengyang', 'null', '233100'),
(944, '001012011001', '颖州', '001012011', 123, '中国/安徽/阜阳/颖州', '区', 4, 'yz', 'yingzhou', 'null', '236033'),
(945, '001012011002', '颖东', '001012011', 123, '中国/安徽/阜阳/颖东', '区', 4, 'yd', 'yingdong', 'null', '236033'),
(946, '001012011003', '颖泉', '001012011', 123, '中国/安徽/阜阳/颖泉', '区', 4, 'yq', 'yingquan', 'null', '236033'),
(947, '001012011004', '界首', '001012011', 123, '中国/安徽/阜阳/界首', '市', 4, 'js', 'jieshou', 'null', '236501'),
(948, '001012011005', '临泉', '001012011', 123, '中国/安徽/阜阳/临泉', '县', 4, 'lq', 'linquan', 'null', '236400'),
(949, '001012011006', '太和', '001012011', 123, '中国/安徽/阜阳/太和', '县', 4, 'th', 'taihe', 'null', '236601'),
(950, '001012011007', '阜南', '001012011', 123, '中国/安徽/阜阳/阜南', '县', 4, 'fn', 'funan', 'null', '236200'),
(951, '001012011008', '颖上', '001012011', 123, '中国/安徽/阜阳/颖上', '县', 4, 'ys', 'yingshang', 'null', '236201'),
(952, '001012012001', '埇桥', '001012012', 124, '中国/安徽/宿州/埇桥', '区', 4, 'q', 'qiao', 'null', '234000'),
(953, '001012012002', '砀山', '001012012', 124, '中国/安徽/宿州/砀山', '县', 4, 's', 'shan', 'null', '235300'),
(954, '001012012003', '萧县', '001012012', 124, '中国/安徽/宿州/萧县', 'null', 4, 'x', 'xiao', 'null', '235200'),
(955, '001012012004', '灵璧', '001012012', 124, '中国/安徽/宿州/灵璧', '县', 4, 'l', 'ling', 'null', '234200'),
(956, '001012012005', '泗县', '001012012', 124, '中国/安徽/宿州/泗县', 'null', 4, 'null', 'null', 'null', '234300'),
(957, '001012013001', '居巢', '001012013', 125, '中国/安徽/巢湖/居巢', '区', 4, 'jc', 'juchao', 'null', '238000'),
(958, '001012013002', '庐江', '001012013', 125, '中国/安徽/巢湖/庐江', '县', 4, 'lj', 'lujiang', 'null', '231500'),
(959, '001012013003', '无为', '001012013', 125, '中国/安徽/巢湖/无为', '县', 4, 'ww', 'wuwei', 'null', '238300'),
(960, '001012013004', '含山', '001012013', 125, '中国/安徽/巢湖/含山', '县', 4, 'hs', 'hanshan', 'null', '238100'),
(961, '001012013005', '和县', '001012013', 125, '中国/安徽/巢湖/和县', 'null', 4, 'h', 'he', 'null', '238200'),
(962, '001012014001', '金安', '001012014', 126, '中国/安徽/六安/金安', '区', 4, 'ja', 'jinan', 'null', '237005'),
(963, '001012014002', '裕安', '001012014', 126, '中国/安徽/六安/裕安', '区', 4, 'ya', 'yuan', 'null', '237000'),
(964, '001012014003', '寿县', '001012014', 126, '中国/安徽/六安/寿县', 'null', 4, 's', 'shou', 'null', '232200'),
(965, '001012014004', '霍邱', '001012014', 126, '中国/安徽/六安/霍邱', '县', 4, 'hq', 'huoqiu', 'null', '237400'),
(966, '001012014005', '舒城', '001012014', 126, '中国/安徽/六安/舒城', '县', 4, 'sc', 'shucheng', 'null', '231300'),
(967, '001012014006', '金寨', '001012014', 126, '中国/安徽/六安/金寨', '县', 4, 'jz', 'jinzhai', 'null', '237300'),
(968, '001012014007', '霍山', '001012014', 126, '中国/安徽/六安/霍山', '县', 4, 'hs', 'huoshan', 'null', '237200'),
(969, '001012015001', '谯城', '001012015', 127, '中国/安徽/亳州/谯城', '区', 4, 'c', 'cheng', 'null', '236800'),
(970, '001012015002', '涡阳', '001012015', 127, '中国/安徽/亳州/涡阳', '县', 4, 'wy', 'woyang', 'null', '233601'),
(971, '001012015003', '蒙城', '001012015', 127, '中国/安徽/亳州/蒙城', '县', 4, 'mc', 'mengcheng', 'null', '233500'),
(972, '001012015004', '利辛', '001012015', 127, '中国/安徽/亳州/利辛', '县', 4, 'lx', 'lixin', 'null', '236702'),
(973, '001012016001', '贵池', '001012016', 128, '中国/安徽/池州/贵池', '区', 4, 'gc', 'guichi', 'null', '247100'),
(974, '001012016002', '东至', '001012016', 128, '中国/安徽/池州/东至', '县', 4, 'dz', 'dongzhi', 'null', '247200'),
(975, '001012016003', '石台', '001012016', 128, '中国/安徽/池州/石台', '县', 4, 'st', 'shitai', 'null', '245101'),
(976, '001012016004', '青阳', '001012016', 128, '中国/安徽/池州/青阳', '县', 4, 'qy', 'qingyang', 'null', '242800'),
(977, '001012017001', '宣州', '001012017', 129, '中国/安徽/宣城/宣州', '区', 4, 'xz', 'xuanzhou', 'null', '242000'),
(978, '001012017002', '宁国', '001012017', 129, '中国/安徽/宣城/宁国', '市', 4, 'ng', 'ningguo', 'null', '242300'),
(979, '001012017003', '郎溪', '001012017', 129, '中国/安徽/宣城/郎溪', '县', 4, 'lx', 'langxi', 'null', '242100'),
(980, '001012017004', '广德', '001012017', 129, '中国/安徽/宣城/广德', '县', 4, 'gd', 'guangde', 'null', '242200'),
(981, '001012017005', '泾县', '001012017', 129, '中国/安徽/宣城/泾县', 'null', 4, 'null', 'null', 'null', '242500'),
(982, '001012017006', '旌德', '001012017', 129, '中国/安徽/宣城/旌德', '县', 4, 'd', 'de', 'null', '242600'),
(983, '001012017007', '绩溪', '001012017', 129, '中国/安徽/宣城/绩溪', '县', 4, 'jx', 'jixi', 'null', '245300'),
(984, '001013001001', '台江', '001013001', 130, '中国/福建/福州/台江', '区', 4, 'tj', 'taijiang', 'null', '350004'),
(985, '001013001002', '仓山', '001013001', 130, '中国/福建/福州/仓山', '区', 4, 'cs', 'cangshan', 'null', '350007'),
(986, '001013001003', '马尾', '001013001', 130, '中国/福建/福州/马尾', '区', 4, 'mw', 'mawei', 'null', '350015'),
(987, '001013001004', '晋安', '001013001', 130, '中国/福建/福州/晋安', '区', 4, 'ja', 'jinan', 'null', '350011'),
(988, '001013001005', '福清', '001013001', 130, '中国/福建/福州/福清', '市', 4, 'fq', 'fuqing', 'null', '350300'),
(989, '001013001006', '长乐', '001013001', 130, '中国/福建/福州/长乐', '市', 4, 'cl', 'changle', 'null', '350200'),
(990, '001013001007', '闽侯', '001013001', 130, '中国/福建/福州/闽侯', '县', 4, 'mh', 'minhou', 'null', '350100'),
(991, '001013001008', '连江', '001013001', 130, '中国/福建/福州/连江', '县', 4, 'lj', 'lianjiang', 'null', '350500'),
(992, '001013001009', '罗源', '001013001', 130, '中国/福建/福州/罗源', '县', 4, 'ly', 'luoyuan', 'null', '350600'),
(993, '001013001010', '闽清', '001013001', 130, '中国/福建/福州/闽清', '县', 4, 'mq', 'minqing', 'null', '350800'),
(994, '001013001011', '永泰', '001013001', 130, '中国/福建/福州/永泰', '县', 4, 'yt', 'yongtai', 'null', '350700'),
(995, '001013001012', '平潭', '001013001', 130, '中国/福建/福州/平潭', '县', 4, 'pt', 'pingtan', 'null', '350400'),
(996, '001013002001', '鼓浪屿', '001013002', 131, '中国/福建/厦门/鼓浪屿', '区', 4, 'gly', 'gulangyu', 'null', '361002'),
(997, '001013002002', '思明', '001013002', 131, '中国/福建/厦门/思明', '区', 4, 'sm', 'siming', 'null', '361001'),
(998, '001013002003', '杏林', '001013002', 131, '中国/福建/厦门/杏林', '区', 4, 'xl', 'xinglin', 'null', '361022'),
(999, '001013002004', '湖里', '001013002', 131, '中国/福建/厦门/湖里', '区', 4, 'hl', 'huli', 'null', '361006'),
(1000, '001013002005', '集美', '001013002', 131, '中国/福建/厦门/集美', '区', 4, 'jm', 'jimei', 'null', '361021'),
(1001, '001013002006', '同安', '001013002', 131, '中国/福建/厦门/同安', '区', 4, 'ta', 'tongan', 'null', '361100'),
(1002, '001013003001', '三元', '001013003', 132, '中国/福建/三明/三元', '区', 4, 'sy', 'sanyuan', 'null', '365001'),
(1003, '001013003002', '永安', '001013003', 132, '中国/福建/三明/永安', '市', 4, 'ya', 'yongan', 'null', '366000'),
(1004, '001013003003', '明溪', '001013003', 132, '中国/福建/三明/明溪', '县', 4, 'mx', 'mingxi', 'null', '365200'),
(1005, '001013003004', '清流', '001013003', 132, '中国/福建/三明/清流', '县', 4, 'ql', 'qingliu', 'null', '365300'),
(1006, '001013003005', '宁化', '001013003', 132, '中国/福建/三明/宁化', '县', 4, 'nh', 'ninghua', 'null', '365400'),
(1007, '001013003006', '大田', '001013003', 132, '中国/福建/三明/大田', '县', 4, 'dt', 'datian', 'null', '366100'),
(1008, '001013003007', '尤溪', '001013003', 132, '中国/福建/三明/尤溪', '县', 4, 'yx', 'youxi', 'null', '365100'),
(1009, '001013003008', '沙县', '001013003', 132, '中国/福建/三明/沙县', 'null', 4, 's', 'sha', 'null', '365500'),
(1010, '001013003009', '将乐', '001013003', 132, '中国/福建/三明/将乐', '县', 4, 'jl', 'jiangle', 'null', '353300'),
(1011, '001013003010', '泰宁', '001013003', 132, '中国/福建/三明/泰宁', '县', 4, 'tn', 'taining', 'null', '354400'),
(1012, '001013003011', '建宁', '001013003', 132, '中国/福建/三明/建宁', '县', 4, 'jn', 'jianning', 'null', '354500'),
(1013, '001013004001', '涵江', '001013004', 133, '中国/福建/莆田/涵江', '区', 4, 'hj', 'hanjiang', 'null', '351111'),
(1014, '001013004002', '荔城', '001013004', 133, '中国/福建/莆田/荔城', '区', 4, 'lc', 'licheng', 'null', '351200'),
(1015, '001013005001', '丰泽', '001013005', 134, '中国/福建/泉州/丰泽', '区', 4, 'fz', 'fengze', 'null', '362000'),
(1016, '001013005002', '洛江', '001013005', 134, '中国/福建/泉州/洛江', '区', 4, 'lj', 'luojiang', 'null', '362000'),
(1017, '001013005003', '泉港', '001013005', 134, '中国/福建/泉州/泉港', '区', 4, 'qg', 'quangang', 'null', '362801'),
(1018, '001013005004', '石狮', '001013005', 134, '中国/福建/泉州/石狮', '市', 4, 'ss', 'shishi', 'null', '362700'),
(1019, '001013005005', '晋江', '001013005', 134, '中国/福建/泉州/晋江', '市', 4, 'jj', 'jinjiang', 'null', '362200'),
(1020, '001013005006', '南安', '001013005', 134, '中国/福建/泉州/南安', '市', 4, 'na', 'nanan', 'null', '362300'),
(1021, '001013005007', '惠安', '001013005', 134, '中国/福建/泉州/惠安', '县', 4, 'ha', 'huian', 'null', '362100'),
(1022, '001013005008', '安溪', '001013005', 134, '中国/福建/泉州/安溪', '县', 4, 'ax', 'anxi', 'null', '362400'),
(1023, '001013005009', '永春', '001013005', 134, '中国/福建/泉州/永春', '县', 4, 'yc', 'yongchun', 'null', '362600'),
(1024, '001013005010', '德化', '001013005', 134, '中国/福建/泉州/德化', '县', 4, 'dh', 'dehua', 'null', '362500'),
(1025, '001013006001', '龙文', '001013006', 135, '中国/福建/漳州/龙文', '区', 4, 'lw', 'longwen', 'null', '363005'),
(1026, '001013006002', '龙海', '001013006', 135, '中国/福建/漳州/龙海', '市', 4, 'lh', 'longhai', 'null', '363100'),
(1027, '001013006003', '云霄', '001013006', 135, '中国/福建/漳州/云霄', '县', 4, 'yx', 'yunxiao', 'null', '363300'),
(1028, '001013006004', '漳浦', '001013006', 135, '中国/福建/漳州/漳浦', '县', 4, 'zp', 'zhangpu', 'null', '363200'),
(1029, '001013006005', '诏安', '001013006', 135, '中国/福建/漳州/诏安', '县', 4, 'a', 'an', 'null', '363500'),
(1030, '001013006006', '长泰', '001013006', 135, '中国/福建/漳州/长泰', '县', 4, 'ct', 'changtai', 'null', '363900'),
(1031, '001013006007', '东山', '001013006', 135, '中国/福建/漳州/东山', '县', 4, 'ds', 'dongshan', 'null', '363400'),
(1032, '001013006008', '南靖', '001013006', 135, '中国/福建/漳州/南靖', '县', 4, 'nj', 'nanjing', 'null', '363600'),
(1033, '001013006009', '平和', '001013006', 135, '中国/福建/漳州/平和', '县', 4, 'ph', 'pinghe', 'null', '363700'),
(1034, '001013006010', '华安', '001013006', 135, '中国/福建/漳州/华安', '县', 4, 'ha', 'huaan', 'null', '363800'),
(1035, '001013007001', '邵武', '001013007', 136, '中国/福建/南平/邵武', '市', 4, 'sw', 'shaowu', 'null', '354000'),
(1036, '001013007002', '武夷山', '001013007', 136, '中国/福建/南平/武夷山', '市', 4, 'wys', 'wuyishan', 'null', '354300'),
(1037, '001013007003', '建瓯', '001013007', 136, '中国/福建/南平/建瓯', '市', 4, 'j', 'jian', 'null', '353100'),
(1038, '001013007004', '建阳', '001013007', 136, '中国/福建/南平/建阳', '市', 4, 'jy', 'jianyang', 'null', '354200'),
(1039, '001013007005', '顺昌', '001013007', 136, '中国/福建/南平/顺昌', '县', 4, 'sc', 'shunchang', 'null', '353200'),
(1040, '001013007006', '浦城', '001013007', 136, '中国/福建/南平/浦城', '县', 4, 'pc', 'pucheng', 'null', '353400'),
(1041, '001013007007', '光泽', '001013007', 136, '中国/福建/南平/光泽', '县', 4, 'gz', 'guangze', 'null', '354100'),
(1042, '001013007008', '松溪', '001013007', 136, '中国/福建/南平/松溪', '县', 4, 'sx', 'songxi', 'null', '353500'),
(1043, '001013007009', '政和', '001013007', 136, '中国/福建/南平/政和', '县', 4, 'zh', 'zhenghe', 'null', '353600'),
(1044, '001013008001', '漳平', '001013008', 137, '中国/福建/龙岩/漳平', '市', 4, 'zp', 'zhangping', 'null', '364400'),
(1045, '001013008002', '长汀', '001013008', 137, '中国/福建/龙岩/长汀', '县', 4, 'ct', 'changting', 'null', '366300'),
(1046, '001013008003', '永定', '001013008', 137, '中国/福建/龙岩/永定', '县', 4, 'yd', 'yongding', 'null', '364100'),
(1047, '001013008004', '上杭', '001013008', 137, '中国/福建/龙岩/上杭', '县', 4, 'sh', 'shanghang', 'null', '364200'),
(1048, '001013008005', '武平', '001013008', 137, '中国/福建/龙岩/武平', '县', 4, 'wp', 'wuping', 'null', '364300'),
(1049, '001013008006', '连城', '001013008', 137, '中国/福建/龙岩/连城', '县', 4, 'lc', 'liancheng', 'null', '362200'),
(1050, '001013009001', '福安', '001013009', 138, '中国/福建/宁德/福安', '市', 4, 'fa', 'fuan', 'null', '355000'),
(1051, '001013009002', '福鼎', '001013009', 138, '中国/福建/宁德/福鼎', '市', 4, 'fd', 'fuding', 'null', '355200'),
(1052, '001013009003', '寿宁', '001013009', 138, '中国/福建/宁德/寿宁', '县', 4, 'sn', 'shouning', 'null', '355500'),
(1053, '001013009004', '霞浦', '001013009', 138, '中国/福建/宁德/霞浦', '县', 4, 'xp', 'xiapu', 'null', '355100'),
(1054, '001013009005', '柘荣', '001013009', 138, '中国/福建/宁德/柘荣', '县', 4, 'r', 'rong', 'null', '355300'),
(1055, '001013009006', '屏南', '001013009', 138, '中国/福建/宁德/屏南', '县', 4, 'pn', 'pingnan', 'null', '352300'),
(1056, '001013009007', '古田', '001013009', 138, '中国/福建/宁德/古田', '县', 4, 'gt', 'gutian', 'null', '352200'),
(1057, '001013009008', '周宁', '001013009', 138, '中国/福建/宁德/周宁', '县', 4, 'zn', 'zhouning', 'null', '355400'),
(1058, '001014001001', '西湖', '001014001', 139, '中国/江西/南昌/西湖', '区', 4, 'xh', 'xihu', 'null', '330009'),
(1059, '001014001002', '青云谱', '001014001', 139, '中国/江西/南昌/青云谱', '区', 4, 'qyp', 'qingyunpu', 'null', '330001'),
(1060, '001014001003', '湾里', '001014001', 139, '中国/江西/南昌/湾里', '区', 4, 'wl', 'wanli', 'null', '330004'),
(1061, '001014001004', '青山湖', '001014001', 139, '中国/江西/南昌/青山湖', '区', 4, 'qsh', 'qingshanhu', 'null', '330006'),
(1062, '001014001005', '南昌', '001014001', 139, '中国/江西/南昌/南昌', '县', 4, 'nc', 'nanchang', 'null', '330200'),
(1063, '001014001006', '新建', '001014001', 139, '中国/江西/南昌/新建', '县', 4, 'xj', 'xinjian', 'null', '330100'),
(1064, '001014001007', '安义', '001014001', 139, '中国/江西/南昌/安义', '县', 4, 'ay', 'anyi', 'null', '330500'),
(1065, '001014001008', '进贤', '001014001', 139, '中国/江西/南昌/进贤', '县', 4, 'jx', 'jinxian', 'null', '331700'),
(1066, '001014002001', '昌江', '001014002', 140, '中国/江西/景德镇/昌江', '区', 4, 'cj', 'changjiang', 'null', '333000'),
(1067, '001014002002', '乐平', '001014002', 140, '中国/江西/景德镇/乐平', '市', 4, 'lp', 'leping', 'null', '333300'),
(1068, '001014002003', '浮梁', '001014002', 140, '中国/江西/景德镇/浮梁', '县', 4, 'fl', 'fuliang', 'null', '333400'),
(1069, '001014003001', '湘东', '001014003', 141, '中国/江西/萍乡/湘东', '区', 4, 'xd', 'xiangdong', 'null', '337016'),
(1070, '001014003002', '莲花', '001014003', 141, '中国/江西/萍乡/莲花', '县', 4, 'lh', 'lianhua', 'null', '337100'),
(1071, '001014003003', '上栗', '001014003', 141, '中国/江西/萍乡/上栗', '县', 4, 'sl', 'shangli', 'null', '337300'),
(1072, '001014003004', '芦溪', '001014003', 141, '中国/江西/萍乡/芦溪', '县', 4, 'lx', 'luxi', 'null', '337253'),
(1073, '001014004001', '庐山', '001014004', 142, '中国/江西/九江/庐山', '区', 4, 'ls', 'lushan', 'null', '332005'),
(1074, '001014004002', '瑞昌', '001014004', 142, '中国/江西/九江/瑞昌', '市', 4, 'rc', 'ruichang', 'null', '332200'),
(1075, '001014004003', '九江', '001014004', 142, '中国/江西/九江/九江', '县', 4, 'jj', 'jiujiang', 'null', '332100'),
(1076, '001014004004', '武宁', '001014004', 142, '中国/江西/九江/武宁', '县', 4, 'wn', 'wuning', 'null', '332300'),
(1077, '001014004005', '修水', '001014004', 142, '中国/江西/九江/修水', '县', 4, 'xs', 'xiushui', 'null', '332400'),
(1078, '001014004006', '永修', '001014004', 142, '中国/江西/九江/永修', '县', 4, 'yx', 'yongxiu', 'null', '330300'),
(1079, '001014004007', '德安', '001014004', 142, '中国/江西/九江/德安', '县', 4, 'da', 'dean', 'null', '330400'),
(1080, '001014004008', '星子', '001014004', 142, '中国/江西/九江/星子', '县', 4, 'xz', 'xingzi', 'null', '332800'),
(1081, '001014004009', '都昌', '001014004', 142, '中国/江西/九江/都昌', '县', 4, 'dc', 'duchang', 'null', '332600'),
(1082, '001014004010', '湖口', '001014004', 142, '中国/江西/九江/湖口', '县', 4, 'hk', 'hukou', 'null', '332500'),
(1083, '001014004011', '彭泽', '001014004', 142, '中国/江西/九江/彭泽', '县', 4, 'pz', 'pengze', 'null', '332700'),
(1084, '001014005001', '分宜', '001014005', 143, '中国/江西/新余/分宜', '县', 4, 'fy', 'fenyi', 'null', '336600'),
(1085, '001014006001', '贵溪', '001014006', 144, '中国/江西/鹰潭/贵溪', '市', 4, 'gx', 'guixi', 'null', '335400'),
(1086, '001014006002', '余江', '001014006', 144, '中国/江西/鹰潭/余江', '县', 4, 'yj', 'yujiang', 'null', '335200'),
(1087, '001014007001', '瑞金', '001014007', 145, '中国/江西/赣州/瑞金', '市', 4, 'rj', 'ruijin', 'null', '342500'),
(1088, '001014007002', '南康', '001014007', 145, '中国/江西/赣州/南康', '市', 4, 'nk', 'nankang', 'null', '341400'),
(1089, '001014007003', '赣县', '001014007', 145, '中国/江西/赣州/赣县', 'null', 4, 'g', 'gan', 'null', '341100'),
(1090, '001014007004', '信丰', '001014007', 145, '中国/江西/赣州/信丰', '县', 4, 'xf', 'xinfeng', 'null', '341600'),
(1091, '001014007005', '大余', '001014007', 145, '中国/江西/赣州/大余', '县', 4, 'dy', 'dayu', 'null', '341500'),
(1092, '001014007006', '上犹', '001014007', 145, '中国/江西/赣州/上犹', '县', 4, 'sy', 'shangyou', 'null', '341200'),
(1093, '001014007007', '崇义', '001014007', 145, '中国/江西/赣州/崇义', '县', 4, 'cy', 'chongyi', 'null', '341300'),
(1094, '001014007008', '安远', '001014007', 145, '中国/江西/赣州/安远', '县', 4, 'ay', 'anyuan', 'null', '342100'),
(1095, '001014007009', '龙南', '001014007', 145, '中国/江西/赣州/龙南', '县', 4, 'ln', 'longnan', 'null', '341700'),
(1096, '001014007010', '定南', '001014007', 145, '中国/江西/赣州/定南', '县', 4, 'dn', 'dingnan', 'null', '341900'),
(1097, '001014007011', '全南', '001014007', 145, '中国/江西/赣州/全南', '县', 4, 'qn', 'quannan', 'null', '341800'),
(1098, '001014007012', '宁都', '001014007', 145, '中国/江西/赣州/宁都', '县', 4, 'nd', 'ningdu', 'null', '342800'),
(1099, '001014007013', '于都', '001014007', 145, '中国/江西/赣州/于都', '县', 4, 'yd', 'yudu', 'null', '342300'),
(1100, '001014007014', '兴国', '001014007', 145, '中国/江西/赣州/兴国', '县', 4, 'xg', 'xingguo', 'null', '342400'),
(1101, '001014007015', '会昌', '001014007', 145, '中国/江西/赣州/会昌', '县', 4, 'hc', 'huichang', 'null', '342600'),
(1102, '001014007016', '寻乌', '001014007', 145, '中国/江西/赣州/寻乌', '县', 4, 'xw', 'xunwu', 'null', '342210'),
(1103, '001014007017', '石城', '001014007', 145, '中国/江西/赣州/石城', '县', 4, 'sc', 'shicheng', 'null', '342700'),
(1104, '001014008001', '青原', '001014008', 146, '中国/江西/吉安/青原', '区', 4, 'qy', 'qingyuan', 'null', '343009'),
(1105, '001014008002', '井冈山', '001014008', 146, '中国/江西/吉安/井冈山', '市', 4, 'jgs', 'jinggangsha', 'null', '343600'),
(1106, '001014008003', '吉安', '001014008', 146, '中国/江西/吉安/吉安', '县', 4, 'ja', 'jian', 'null', '343100'),
(1107, '001014008004', '吉水', '001014008', 146, '中国/江西/吉安/吉水', '县', 4, 'js', 'jishui', 'null', '331600'),
(1108, '001014008005', '峡江', '001014008', 146, '中国/江西/吉安/峡江', '县', 4, 'xj', 'xiajiang', 'null', '331409'),
(1109, '001014008006', '新干', '001014008', 146, '中国/江西/吉安/新干', '县', 4, 'xg', 'xingan', 'null', '331300'),
(1110, '001014008007', '永丰', '001014008', 146, '中国/江西/吉安/永丰', '县', 4, 'yf', 'yongfeng', 'null', '331500'),
(1111, '001014008008', '泰和', '001014008', 146, '中国/江西/吉安/泰和', '县', 4, 'th', 'taihe', 'null', '343700'),
(1112, '001014008009', '遂川', '001014008', 146, '中国/江西/吉安/遂川', '县', 4, 'sc', 'suichuan', 'null', '343900'),
(1113, '001014008010', '万安', '001014008', 146, '中国/江西/吉安/万安', '县', 4, 'wa', 'wanan', 'null', '343800'),
(1114, '001014008011', '安福', '001014008', 146, '中国/江西/吉安/安福', '县', 4, 'af', 'anfu', 'null', '343200'),
(1115, '001014008012', '永新', '001014008', 146, '中国/江西/吉安/永新', '县', 4, 'yx', 'yongxin', 'null', '343400'),
(1116, '001014009001', '丰城', '001014009', 147, '中国/江西/宜春/丰城', '市', 4, 'fc', 'fengcheng', 'null', '331100'),
(1117, '001014009002', '樟树', '001014009', 147, '中国/江西/宜春/樟树', '市', 4, 'zs', 'zhangshu', 'null', '331200'),
(1118, '001014009003', '高安', '001014009', 147, '中国/江西/宜春/高安', '市', 4, 'ga', 'gaoan', 'null', '330800'),
(1119, '001014009004', '奉新', '001014009', 147, '中国/江西/宜春/奉新', '县', 4, 'fx', 'fengxin', 'null', '330700'),
(1120, '001014009005', '万载', '001014009', 147, '中国/江西/宜春/万载', '县', 4, 'wz', 'wanzai', 'null', '336100'),
(1121, '001014009006', '上高', '001014009', 147, '中国/江西/宜春/上高', '县', 4, 'sg', 'shanggao', 'null', '336400'),
(1122, '001014009007', '宜丰', '001014009', 147, '中国/江西/宜春/宜丰', '县', 4, 'yf', 'yifeng', 'null', '336300'),
(1123, '001014009008', '靖安', '001014009', 147, '中国/江西/宜春/靖安', '县', 4, 'ja', 'jingan', 'null', '330600'),
(1124, '001014009009', '铜鼓', '001014009', 147, '中国/江西/宜春/铜鼓', '县', 4, 'tg', 'tonggu', 'null', '336200'),
(1125, '001014010001', '南城', '001014010', 148, '中国/江西/抚州/南城', '县', 4, 'nc', 'nancheng', 'null', '344700'),
(1126, '001014010002', '黎川', '001014010', 148, '中国/江西/抚州/黎川', '县', 4, 'lc', 'lichuan', 'null', '344600'),
(1127, '001014010003', '南丰', '001014010', 148, '中国/江西/抚州/南丰', '县', 4, 'nf', 'nanfeng', 'null', '344500'),
(1128, '001014010004', '崇仁', '001014010', 148, '中国/江西/抚州/崇仁', '县', 4, 'cr', 'chongren', 'null', '344200'),
(1129, '001014010005', '乐安', '001014010', 148, '中国/江西/抚州/乐安', '县', 4, 'la', 'lean', 'null', '344300'),
(1130, '001014010006', '宜黄', '001014010', 148, '中国/江西/抚州/宜黄', '县', 4, 'yh', 'yihuang', 'null', '344400'),
(1131, '001014010007', '金溪', '001014010', 148, '中国/江西/抚州/金溪', '县', 4, 'jx', 'jinxi', 'null', '344800'),
(1132, '001014010008', '资溪', '001014010', 148, '中国/江西/抚州/资溪', '县', 4, 'zx', 'zixi', 'null', '335300'),
(1133, '001014010009', '东乡', '001014010', 148, '中国/江西/抚州/东乡', '县', 4, 'dx', 'dongxiang', 'null', '331800'),
(1134, '001014010010', '广昌', '001014010', 148, '中国/江西/抚州/广昌', '县', 4, 'gc', 'guangchang', 'null', '344900'),
(1135, '001014011001', '德兴', '001014011', 149, '中国/江西/上饶/德兴', '市', 4, 'dx', 'dexing', 'null', '334200'),
(1136, '001014011002', '上饶', '001014011', 149, '中国/江西/上饶/上饶', '县', 4, 'sr', 'shangrao', 'null', '334100'),
(1137, '001014011003', '广丰', '001014011', 149, '中国/江西/上饶/广丰', '县', 4, 'gf', 'guangfeng', 'null', '334600'),
(1138, '001014011004', '玉山', '001014011', 149, '中国/江西/上饶/玉山', '县', 4, 'ys', 'yushan', 'null', '334700'),
(1139, '001014011005', '铅山', '001014011', 149, '中国/江西/上饶/铅山', '县', 4, 'qs', 'qianshan', 'null', '334500'),
(1140, '001014011006', '横峰', '001014011', 149, '中国/江西/上饶/横峰', '县', 4, 'hf', 'hengfeng', 'null', '334300'),
(1141, '001014011007', '弋阳', '001014011', 149, '中国/江西/上饶/弋阳', '县', 4, 'y', 'yang', 'null', '334400'),
(1142, '001014011008', '余干', '001014011', 149, '中国/江西/上饶/余干', '县', 4, 'yg', 'yugan', 'null', '335100'),
(1143, '001014011009', '波阳', '001014011', 149, '中国/江西/上饶/波阳', '县', 4, 'by', 'boyang', 'null', '333100'),
(1144, '001014011010', '万年', '001014011', 149, '中国/江西/上饶/万年', '县', 4, 'wn', 'wannian', 'null', '335500'),
(1145, '001014011011', '婺源', '001014011', 149, '中国/江西/上饶/婺源', '县', 4, 'y', 'yuan', 'null', '333200'),
(1146, '001015001001', '市中', '001015001', 150, '中国/山东/济南/市中', '区', 4, 'z', 'zhong', 'null', '250001'),
(1147, '001015001002', '历下', '001015001', 150, '中国/山东/济南/历下', '区', 4, 'lx', 'lixia', 'null', '250013'),
(1148, '001015001003', '槐荫', '001015001', 150, '中国/山东/济南/槐荫', '区', 4, 'hy', 'huaiyin', 'null', '250021'),
(1149, '001015001004', '天桥', '001015001', 150, '中国/山东/济南/天桥', '区', 4, 'tq', 'tianqiao', 'null', '250031'),
(1150, '001015001005', '历城', '001015001', 150, '中国/山东/济南/历城', '区', 4, 'lc', 'licheng', 'null', '250100'),
(1151, '001015001006', '长清', '001015001', 150, '中国/山东/济南/长清', '区', 4, 'cq', 'changqing', 'null', '250300'),
(1152, '001015001007', '章丘', '001015001', 150, '中国/山东/济南/章丘', '市', 4, 'zq', 'zhangqiu', 'null', '250200'),
(1153, '001015001008', '平阴', '001015001', 150, '中国/山东/济南/平阴', '县', 4, 'py', 'pingyin', 'null', '250400'),
(1154, '001015001009', '济阳', '001015001', 150, '中国/山东/济南/济阳', '县', 4, 'jy', 'jiyang', 'null', '251400'),
(1155, '001015001010', '商河', '001015001', 150, '中国/山东/济南/商河', '县', 4, 'sh', 'shanghe', 'null', '251600'),
(1156, '001015002001', '市南', '001015002', 151, '中国/山东/青岛/市南', '区', 4, 'n', 'nan', 'null', '266001'),
(1157, '001015002002', '市北', '001015002', 151, '中国/山东/青岛/市北', '区', 4, 'b', 'bei', 'null', '266011'),
(1158, '001015002003', '四方', '001015002', 151, '中国/山东/青岛/四方', '区', 4, 'sf', 'sifang', 'null', '266031'),
(1159, '001015002004', '黄岛', '001015002', 151, '中国/山东/青岛/黄岛', '区', 4, 'hd', 'huangdao', 'null', '266500'),
(1160, '001015002005', '崂山', '001015002', 151, '中国/山东/青岛/崂山', '区', 4, 's', 'shan', 'null', '266100'),
(1161, '001015002006', '城阳', '001015002', 151, '中国/山东/青岛/城阳', '区', 4, 'cy', 'chengyang', 'null', '266041'),
(1162, '001015002007', '李沧', '001015002', 151, '中国/山东/青岛/李沧', '区', 4, 'lc', 'licang', 'null', '266021'),
(1163, '001015002008', '胶州', '001015002', 151, '中国/山东/青岛/胶州', '市', 4, 'jz', 'jiaozhou', 'null', '266300'),
(1164, '001015002009', '即墨', '001015002', 151, '中国/山东/青岛/即墨', '市', 4, 'jm', 'jimo', 'null', '266200'),
(1165, '001015002010', '平度', '001015002', 151, '中国/山东/青岛/平度', '市', 4, 'pd', 'pingdu', 'null', '266700'),
(1166, '001015002011', '胶南', '001015002', 151, '中国/山东/青岛/胶南', '市', 4, 'jn', 'jiaonan', 'null', '266400'),
(1167, '001015002012', '莱西', '001015002', 151, '中国/山东/青岛/莱西', '市', 4, 'lx', 'laixi', 'null', '266600'),
(1168, '001015003001', '张店', '001015003', 152, '中国/山东/淄博/张店', '区', 4, 'zd', 'zhangdian', 'null', '255022'),
(1169, '001015003002', '淄川', '001015003', 152, '中国/山东/淄博/淄川', '区', 4, 'zc', 'zichuan', 'null', '255100'),
(1170, '001015003003', '博山', '001015003', 152, '中国/山东/淄博/博山', '区', 4, 'bs', 'boshan', 'null', '255200');
INSERT INTO `des_district` (`serialId`, `districtId`, `districtName`, `districtUpId`, `districtUpIdNum`, `districtPath`, `districtType`, `districtTypeNum`, `shortName`, `spell`, `areaId`, `postCode`) VALUES
(1171, '001015003004', '临淄', '001015003', 152, '中国/山东/淄博/临淄', '区', 4, 'lz', 'linzi', 'null', '255400'),
(1172, '001015003005', '周村', '001015003', 152, '中国/山东/淄博/周村', '区', 4, 'zc', 'zhoucun', 'null', '255300'),
(1173, '001015003006', '桓台', '001015003', 152, '中国/山东/淄博/桓台', '县', 4, 'ht', 'huantai', 'null', '256400'),
(1174, '001015003007', '高青', '001015003', 152, '中国/山东/淄博/高青', '县', 4, 'gq', 'gaoqing', 'null', '256300'),
(1175, '001015003008', '沂源', '001015003', 152, '中国/山东/淄博/沂源', '县', 4, 'yy', 'yiyuan', 'null', '256100'),
(1176, '001015004001', '市中', '001015004', 153, '中国/山东/枣庄/市中', '区', 4, 'z', 'zhong', 'null', '277101'),
(1177, '001015004002', '薛城', '001015004', 153, '中国/山东/枣庄/薛城', '区', 4, 'xc', 'xuecheng', 'null', '277000'),
(1178, '001015004003', '峄城', '001015004', 153, '中国/山东/枣庄/峄城', '区', 4, 'c', 'cheng', 'null', '277300'),
(1179, '001015004004', '台儿庄', '001015004', 153, '中国/山东/枣庄/台儿庄', '区', 4, 'tez', 'taierzhuang', 'null', '277400'),
(1180, '001015004005', '山亭', '001015004', 153, '中国/山东/枣庄/山亭', '区', 4, 'st', 'shanting', 'null', '277200'),
(1181, '001015004006', '滕州', '001015004', 153, '中国/山东/枣庄/滕州', '市', 4, 'tz', 'tengzhou', 'null', '277500'),
(1182, '001015005001', '东营', '001015005', 154, '中国/山东/东营/东营', '区', 4, 'dy', 'dongying', 'null', '257029'),
(1183, '001015005002', '河口', '001015005', 154, '中国/山东/东营/河口', '区', 4, 'hk', 'hekou', 'null', '257200'),
(1184, '001015005003', '垦利', '001015005', 154, '中国/山东/东营/垦利', '县', 4, 'kl', 'kenli', 'null', '257500'),
(1185, '001015005004', '利津', '001015005', 154, '中国/山东/东营/利津', '县', 4, 'lj', 'lijin', 'null', '257400'),
(1186, '001015005005', '广饶', '001015005', 154, '中国/山东/东营/广饶', '县', 4, 'gr', 'guangrao', 'null', '257300'),
(1187, '001015006001', '潍城', '001015006', 155, '中国/山东/潍坊/潍城', '区', 4, 'wc', 'weicheng', 'null', '261021'),
(1188, '001015006002', '寒亭', '001015006', 155, '中国/山东/潍坊/寒亭', '区', 4, 'ht', 'hanting', 'null', '261100'),
(1189, '001015006003', '坊子', '001015006', 155, '中国/山东/潍坊/坊子', '区', 4, 'fz', 'fangzi', 'null', '261200'),
(1190, '001015006004', '奎文', '001015006', 155, '中国/山东/潍坊/奎文', '区', 4, 'kw', 'kuiwen', 'null', '261041'),
(1191, '001015006005', '安丘', '001015006', 155, '中国/山东/潍坊/安丘', '市', 4, 'aq', 'anqiu', 'null', '262100'),
(1192, '001015006006', '昌邑', '001015006', 155, '中国/山东/潍坊/昌邑', '市', 4, 'cy', 'changyi', 'null', '261300'),
(1193, '001015006007', '高密', '001015006', 155, '中国/山东/潍坊/高密', '市', 4, 'gm', 'gaomi', 'null', '261500'),
(1194, '001015006008', '青州', '001015006', 155, '中国/山东/潍坊/青州', '市', 4, 'qz', 'qingzhou', 'null', '262500'),
(1195, '001015006009', '诸城', '001015006', 155, '中国/山东/潍坊/诸城', '市', 4, 'zc', 'zhucheng', 'null', '262200'),
(1196, '001015006010', '寿光', '001015006', 155, '中国/山东/潍坊/寿光', '市', 4, 'sg', 'shouguang', 'null', '262700'),
(1197, '001015006011', '临朐', '001015006', 155, '中国/山东/潍坊/临朐', '县', 4, 'l', 'lin', 'null', '262600'),
(1198, '001015006012', '昌乐', '001015006', 155, '中国/山东/潍坊/昌乐', '县', 4, 'cl', 'changle', 'null', '262400'),
(1199, '001015007001', '芝罘', '001015007', 156, '中国/山东/烟台/芝罘', '区', 4, 'z', 'zhi', 'null', '264001'),
(1200, '001015007002', '福山', '001015007', 156, '中国/山东/烟台/福山', '区', 4, 'fs', 'fushan', 'null', '265500'),
(1201, '001015007003', '莱山', '001015007', 156, '中国/山东/烟台/莱山', '区', 4, 'ls', 'laishan', 'null', '264600'),
(1202, '001015007004', '牟平', '001015007', 156, '中国/山东/烟台/牟平', '区', 4, 'mp', 'mouping', 'null', '264100'),
(1203, '001015007005', '栖霞', '001015007', 156, '中国/山东/烟台/栖霞', '市', 4, 'qx', 'qixia', 'null', '265300'),
(1204, '001015007006', '海阳', '001015007', 156, '中国/山东/烟台/海阳', '市', 4, 'hy', 'haiyang', 'null', '265100'),
(1205, '001015007007', '龙口', '001015007', 156, '中国/山东/烟台/龙口', '市', 4, 'lk', 'longkou', 'null', '265700'),
(1206, '001015007008', '莱阳', '001015007', 156, '中国/山东/烟台/莱阳', '市', 4, 'ly', 'laiyang', 'null', '265200'),
(1207, '001015007009', '莱州', '001015007', 156, '中国/山东/烟台/莱州', '市', 4, 'lz', 'laizhou', 'null', '261400'),
(1208, '001015007010', '蓬莱', '001015007', 156, '中国/山东/烟台/蓬莱', '市', 4, 'pl', 'penglai', 'null', '265600'),
(1209, '001015007011', '招远', '001015007', 156, '中国/山东/烟台/招远', '市', 4, 'zy', 'zhaoyuan', 'null', '265400'),
(1210, '001015007012', '长岛', '001015007', 156, '中国/山东/烟台/长岛', '县', 4, 'cd', 'changdao', 'null', '265800'),
(1211, '001015008001', '环翠', '001015008', 157, '中国/山东/威海/环翠', '区', 4, 'hc', 'huancui', 'null', '264200'),
(1212, '001015008002', '荣成', '001015008', 157, '中国/山东/威海/荣成', '市', 4, 'rc', 'rongcheng', 'null', '264300'),
(1213, '001015008003', '乳山', '001015008', 157, '中国/山东/威海/乳山', '市', 4, 'rs', 'rushan', 'null', '264500'),
(1214, '001015008004', '文登', '001015008', 157, '中国/山东/威海/文登', '市', 4, 'wd', 'wendeng', 'null', '264400'),
(1215, '001015010001', '泰山', '001015010', 159, '中国/山东/泰安/泰山', '区', 4, 'ts', 'taishan', 'null', '271000'),
(1216, '001015010002', '岱岳', '001015010', 159, '中国/山东/泰安/岱岳', '区', 4, 'y', 'yue', 'null', '271000'),
(1217, '001015010003', '新泰', '001015010', 159, '中国/山东/泰安/新泰', '市', 4, 'xt', 'xintai', 'null', '271200'),
(1218, '001015010004', '肥城', '001015010', 159, '中国/山东/泰安/肥城', '市', 4, 'fc', 'feicheng', 'null', '271600'),
(1219, '001015010005', '宁阳', '001015010', 159, '中国/山东/泰安/宁阳', '县', 4, 'ny', 'ningyang', 'null', '271400'),
(1220, '001015010006', '东平', '001015010', 159, '中国/山东/泰安/东平', '县', 4, 'dp', 'dongping', 'null', '271500'),
(1221, '001015011001', '东港', '001015011', 160, '中国/山东/日照/东港', '区', 4, 'dg', 'donggang', 'null', '276800'),
(1222, '001015011002', '五莲', '001015011', 160, '中国/山东/日照/五莲', '县', 4, 'wl', 'wulian', 'null', '262300'),
(1223, '001015011003', '莒县', '001015011', 160, '中国/山东/日照/莒县', 'null', 4, 'null', 'null', 'null', '276500'),
(1224, '001015012001', '莱城', '001015012', 161, '中国/山东/莱芜/莱城', '区', 4, 'lc', 'laicheng', 'null', '271100'),
(1225, '001015012002', '钢城', '001015012', 161, '中国/山东/莱芜/钢城', '区', 4, 'gc', 'gangcheng', 'null', '271100'),
(1226, '001015013001', '兰山', '001015013', 162, '中国/山东/临沂/兰山', '区', 4, 'ls', 'lanshan', 'null', '276002'),
(1227, '001015013002', '罗庄', '001015013', 162, '中国/山东/临沂/罗庄', '区', 4, 'lz', 'luozhuang', 'null', '276022'),
(1228, '001015013003', '河东', '001015013', 162, '中国/山东/临沂/河东', '区', 4, 'hd', 'hedong', 'null', '276034'),
(1229, '001015013004', '郯城', '001015013', 162, '中国/山东/临沂/郯城', '县', 4, 'c', 'cheng', 'null', '276100'),
(1230, '001015013005', '苍山', '001015013', 162, '中国/山东/临沂/苍山', '县', 4, 'cs', 'cangshan', 'null', '277700'),
(1231, '001015013006', '莒南', '001015013', 162, '中国/山东/临沂/莒南', '县', 4, 'n', 'nan', 'null', '276600'),
(1232, '001015013007', '沂水', '001015013', 162, '中国/山东/临沂/沂水', '县', 4, 'ys', 'yishui', 'null', '276400'),
(1233, '001015013008', '蒙阴', '001015013', 162, '中国/山东/临沂/蒙阴', '县', 4, 'my', 'mengyin', 'null', '276200'),
(1234, '001015013009', '平邑', '001015013', 162, '中国/山东/临沂/平邑', '县', 4, 'py', 'pingyi', 'null', '273300'),
(1235, '001015013010', '费县', '001015013', 162, '中国/山东/临沂/费县', 'null', 4, 'f', 'fei', 'null', '273400'),
(1236, '001015013011', '沂南', '001015013', 162, '中国/山东/临沂/沂南', '县', 4, 'yn', 'yinan', 'null', '276300'),
(1237, '001015013012', '临沭', '001015013', 162, '中国/山东/临沂/临沭', '县', 4, 'l', 'lin', 'null', '276700'),
(1238, '001015014001', '德城', '001015014', 163, '中国/山东/德州/德城', '区', 4, 'dc', 'decheng', 'null', '253011'),
(1239, '001015014002', '乐陵', '001015014', 163, '中国/山东/德州/乐陵', '市', 4, 'll', 'leling', 'null', '253600'),
(1240, '001015014003', '禹城', '001015014', 163, '中国/山东/德州/禹城', '市', 4, 'yc', 'yucheng', 'null', '251200'),
(1241, '001015014004', '陵县', '001015014', 163, '中国/山东/德州/陵县', 'null', 4, 'l', 'ling', 'null', '253500'),
(1242, '001015014005', '平原', '001015014', 163, '中国/山东/德州/平原', '县', 4, 'py', 'pingyuan', 'null', '253100'),
(1243, '001015014006', '夏津', '001015014', 163, '中国/山东/德州/夏津', '县', 4, 'xj', 'xiajin', 'null', '253200'),
(1244, '001015014007', '武城', '001015014', 163, '中国/山东/德州/武城', '县', 4, 'wc', 'wucheng', 'null', '253300'),
(1245, '001015014008', '齐河', '001015014', 163, '中国/山东/德州/齐河', '县', 4, 'qh', 'qihe', 'null', '251100'),
(1246, '001015014009', '临邑', '001015014', 163, '中国/山东/德州/临邑', '县', 4, 'ly', 'linyi', 'null', '251500'),
(1247, '001015014010', '宁津', '001015014', 163, '中国/山东/德州/宁津', '县', 4, 'nj', 'ningjin', 'null', '253400'),
(1248, '001015014011', '庆云', '001015014', 163, '中国/山东/德州/庆云', '县', 4, 'qy', 'qingyun', 'null', '253700'),
(1249, '001015015001', '东昌府', '001015015', 164, '中国/山东/聊城/东昌府', '区', 4, 'dcf', 'dongchangfu', 'null', '252000'),
(1250, '001015015002', '临清', '001015015', 164, '中国/山东/聊城/临清', '市', 4, 'lq', 'linqing', 'null', '252600'),
(1251, '001015015003', '阳谷', '001015015', 164, '中国/山东/聊城/阳谷', '县', 4, 'yg', 'yanggu', 'null', '252300'),
(1252, '001015015004', '莘县', '001015015', 164, '中国/山东/聊城/莘县', 'null', 4, 'null', 'null', 'null', '252400'),
(1253, '001015015005', '茌平', '001015015', 164, '中国/山东/聊城/茌平', '县', 4, 'p', 'ping', 'null', '252100'),
(1254, '001015015006', '东阿', '001015015', 164, '中国/山东/聊城/东阿', '县', 4, 'da', 'donga', 'null', '252200'),
(1255, '001015015007', '冠县', '001015015', 164, '中国/山东/聊城/冠县', 'null', 4, 'g', 'guan', 'null', '252500'),
(1256, '001015015008', '高唐', '001015015', 164, '中国/山东/聊城/高唐', '县', 4, 'gt', 'gaotang', 'null', '252800'),
(1257, '001015016001', '滨城', '001015016', 165, '中国/山东/滨州/滨城', '区', 4, 'bc', 'bincheng', 'null', '256613'),
(1258, '001015016002', '惠民', '001015016', 165, '中国/山东/滨州/惠民', '县', 4, 'hm', 'huimin', 'null', '251700'),
(1259, '001015016003', '阳信', '001015016', 165, '中国/山东/滨州/阳信', '县', 4, 'yx', 'yangxin', 'null', '251800'),
(1260, '001015016004', '无棣', '001015016', 165, '中国/山东/滨州/无棣', '县', 4, 'w', 'wu', 'null', '251900'),
(1261, '001015016005', '沾化', '001015016', 165, '中国/山东/滨州/沾化', '县', 4, 'zh', 'zhanhua', 'null', '256800'),
(1262, '001015016006', '博兴', '001015016', 165, '中国/山东/滨州/博兴', '县', 4, 'bx', 'boxing', 'null', '256200'),
(1263, '001015016007', '邹平', '001015016', 165, '中国/山东/滨州/邹平', '县', 4, 'zp', 'zouping', 'null', '256200'),
(1264, '001015017001', '牡丹', '001015017', 166, '中国/山东/菏泽/牡丹', '区', 4, 'md', 'mudan', 'null', '274009'),
(1265, '001015017002', '曹县', '001015017', 166, '中国/山东/菏泽/曹县', 'null', 4, 'c', 'cao', 'null', '274400'),
(1266, '001015017003', '定陶', '001015017', 166, '中国/山东/菏泽/定陶', '县', 4, 'dt', 'dingtao', 'null', '274100'),
(1267, '001015017004', '成武', '001015017', 166, '中国/山东/菏泽/成武', '县', 4, 'cw', 'chengwu', 'null', '274200'),
(1268, '001015017005', '单县', '001015017', 166, '中国/山东/菏泽/单县', 'null', 4, 'd', 'dan', 'null', '273700'),
(1269, '001015017006', '巨野', '001015017', 166, '中国/山东/菏泽/巨野', '县', 4, 'jy', 'juye', 'null', '274900'),
(1270, '001015017007', '郓城', '001015017', 166, '中国/山东/菏泽/郓城', '县', 4, 'c', 'cheng', 'null', '274700'),
(1271, '001015017008', '鄄城', '001015017', 166, '中国/山东/菏泽/鄄城', '县', 4, 'c', 'cheng', 'null', '274600'),
(1272, '001015017009', '东明', '001015017', 166, '中国/山东/菏泽/东明', '县', 4, 'dm', 'dongming', 'null', '274500'),
(1273, '001016001001', '中原', '001016001', 167, '中国/河南/郑州/中原', '区', 4, 'zy', 'zhongyuan', 'null', '450007'),
(1274, '001016001002', '二七', '001016001', 167, '中国/河南/郑州/二七', '区', 4, 'eq', 'erqi', 'null', '450000'),
(1275, '001016001003', '管城', '001016001', 167, '中国/河南/郑州/管城', '回族区', 4, 'gc', 'guancheng', 'null', '450000'),
(1276, '001016001004', '金水', '001016001', 167, '中国/河南/郑州/金水', '区', 4, 'js', 'jinshui', 'null', '450003'),
(1277, '001016001005', '上街', '001016001', 167, '中国/河南/郑州/上街', '区', 4, 'sj', 'shangjie', 'null', '450041'),
(1278, '001016001006', '邙山', '001016001', 167, '中国/河南/郑州/邙山', '区', 4, 's', 'shan', 'null', '450053'),
(1279, '001016001007', '新郑', '001016001', 167, '中国/河南/郑州/新郑', '市', 4, 'xz', 'xinzheng', 'null', '451150'),
(1280, '001016001008', '登封', '001016001', 167, '中国/河南/郑州/登封', '市', 4, 'df', 'dengfeng', 'null', '452470'),
(1281, '001016001009', '新密', '001016001', 167, '中国/河南/郑州/新密', '市', 4, 'xm', 'xinmi', 'null', '452370'),
(1282, '001016001010', '巩义', '001016001', 167, '中国/河南/郑州/巩义', '市', 4, 'gy', 'gongyi', 'null', '451250'),
(1283, '001016001011', '荥阳', '001016001', 167, '中国/河南/郑州/荥阳', '市', 4, 'y', 'yang', 'null', '450100'),
(1284, '001016001012', '中牟', '001016001', 167, '中国/河南/郑州/中牟', '县', 4, 'zm', 'zhongmou', 'null', '451450'),
(1285, '001016002001', '鼓楼', '001016002', 168, '中国/河南/开封/鼓楼', '区', 4, 'gl', 'gulou', 'null', '475000'),
(1286, '001016002002', '龙亭', '001016002', 168, '中国/河南/开封/龙亭', '区', 4, 'lt', 'longting', 'null', '475100'),
(1287, '001016002003', '顺河', '001016002', 168, '中国/河南/开封/顺河', '回族区', 4, 'sh', 'shunhe', 'null', '475000'),
(1288, '001016002004', '南关', '001016002', 168, '中国/河南/开封/南关', '区', 4, 'ng', 'nanguan', 'null', '475003'),
(1289, '001016002005', '郊区', '001016002', 168, '中国/河南/开封/郊区', 'null', 4, 'j', 'jiao', 'null', '475002'),
(1290, '001016002006', '杞县', '001016002', 168, '中国/河南/开封/杞县', 'null', 4, 'null', 'null', 'null', '475200'),
(1291, '001016002007', '通许', '001016002', 168, '中国/河南/开封/通许', '县', 4, 'tx', 'tongxu', 'null', '475400'),
(1292, '001016002008', '尉氏', '001016002', 168, '中国/河南/开封/尉氏', '县', 4, 'ws', 'weishi', 'null', '475500'),
(1293, '001016002009', '开封', '001016002', 168, '中国/河南/开封/开封', '县', 4, 'kf', 'kaifeng', 'null', '475100'),
(1294, '001016002010', '兰考', '001016002', 168, '中国/河南/开封/兰考', '县', 4, 'lk', 'lankao', 'null', '475300'),
(1295, '001016003001', '西工', '001016003', 169, '中国/河南/洛阳/西工', '区', 4, 'xg', 'xigong', 'null', '471000'),
(1296, '001016003002', '老城', '001016003', 169, '中国/河南/洛阳/老城', '区', 4, 'lc', 'laocheng', 'null', '471002'),
(1297, '001016003003', '瀍河', '001016003', 169, '中国/河南/洛阳/瀍河', '回族区', 4, 'h', 'he', 'null', '471002'),
(1298, '001016003004', '涧西', '001016003', 169, '中国/河南/洛阳/涧西', '区', 4, 'jx', 'jianxi', 'null', '471003'),
(1299, '001016003005', '吉利', '001016003', 169, '中国/河南/洛阳/吉利', '区', 4, 'jl', 'jili', 'null', '471012'),
(1300, '001016003006', '洛龙', '001016003', 169, '中国/河南/洛阳/洛龙', '区', 4, 'll', 'luolong', 'null', '471000'),
(1301, '001016003007', '偃师', '001016003', 169, '中国/河南/洛阳/偃师', '市', 4, 's', 'shi', 'null', '471900'),
(1302, '001016003008', '孟津', '001016003', 169, '中国/河南/洛阳/孟津', '县', 4, 'mj', 'mengjin', 'null', '471100'),
(1303, '001016003009', '新安', '001016003', 169, '中国/河南/洛阳/新安', '县', 4, 'xa', 'xinan', 'null', '471800'),
(1304, '001016003010', '栾川', '001016003', 169, '中国/河南/洛阳/栾川', '县', 4, 'c', 'chuan', 'null', '471500'),
(1305, '001016003011', '嵩县', '001016003', 169, '中国/河南/洛阳/嵩县', 'null', 4, 'null', 'null', 'null', '471400'),
(1306, '001016003012', '汝阳', '001016003', 169, '中国/河南/洛阳/汝阳', '县', 4, 'ry', 'ruyang', 'null', '471200'),
(1307, '001016003013', '宜阳', '001016003', 169, '中国/河南/洛阳/宜阳', '县', 4, 'yy', 'yiyang', 'null', '471600'),
(1308, '001016003014', '洛宁', '001016003', 169, '中国/河南/洛阳/洛宁', '县', 4, 'ln', 'luoning', 'null', '471700'),
(1309, '001016003015', '伊川', '001016003', 169, '中国/河南/洛阳/伊川', '县', 4, 'yc', 'yichuan', 'null', '471300'),
(1310, '001016004001', '新华', '001016004', 170, '中国/河南/平顶山/新华', '区', 4, 'xh', 'xinhua', 'null', '467002'),
(1311, '001016004002', '卫东', '001016004', 170, '中国/河南/平顶山/卫东', '区', 4, 'wd', 'weidong', 'null', '467021'),
(1312, '001016004003', '湛河', '001016004', 170, '中国/河南/平顶山/湛河', '区', 4, 'zh', 'zhanhe', 'null', '467000'),
(1313, '001016004004', '石龙', '001016004', 170, '中国/河南/平顶山/石龙', '区', 4, 'sl', 'shilong', 'null', '467045'),
(1314, '001016004005', '舞钢', '001016004', 170, '中国/河南/平顶山/舞钢', '市', 4, 'wg', 'wugang', 'null', '462500'),
(1315, '001016004006', '汝州', '001016004', 170, '中国/河南/平顶山/汝州', '市', 4, 'rz', 'ruzhou', 'null', '467500'),
(1316, '001016004007', '宝丰', '001016004', 170, '中国/河南/平顶山/宝丰', '县', 4, 'bf', 'baofeng', 'null', '467400'),
(1317, '001016004008', '叶县', '001016004', 170, '中国/河南/平顶山/叶县', 'null', 4, 'y', 'ye', 'null', '467200'),
(1318, '001016004009', '鲁山', '001016004', 170, '中国/河南/平顶山/鲁山', '县', 4, 'ls', 'lushan', 'null', '467300'),
(1319, '001016004010', '郏县', '001016004', 170, '中国/河南/平顶山/郏县', 'null', 4, 'null', 'null', 'null', '467100'),
(1320, '001016005001', '山阳', '001016005', 171, '中国/河南/焦作/山阳', '区', 4, 'sy', 'shanyang', 'null', '454002'),
(1321, '001016005002', '解放', '001016005', 171, '中国/河南/焦作/解放', '区', 4, 'jf', 'jiefang', 'null', '454000'),
(1322, '001016005003', '中站', '001016005', 171, '中国/河南/焦作/中站', '区', 4, 'zz', 'zhongzhan', 'null', '454191'),
(1323, '001016005004', '马村', '001016005', 171, '中国/河南/焦作/马村', '区', 4, 'mc', 'macun', 'null', '454171'),
(1324, '001016005005', '孟州', '001016005', 171, '中国/河南/焦作/孟州', '市', 4, 'mz', 'mengzhou', 'null', '454750'),
(1325, '001016005006', '沁阳', '001016005', 171, '中国/河南/焦作/沁阳', '市', 4, 'qy', 'qinyang', 'null', '454550'),
(1326, '001016005007', '修武', '001016005', 171, '中国/河南/焦作/修武', '县', 4, 'xw', 'xiuwu', 'null', '454350'),
(1327, '001016005008', '博爱', '001016005', 171, '中国/河南/焦作/博爱', '县', 4, 'ba', 'boai', 'null', '454450'),
(1328, '001016005009', '武陟', '001016005', 171, '中国/河南/焦作/武陟', '县', 4, 'w', 'wu', 'null', '454950'),
(1329, '001016005010', '温县', '001016005', 171, '中国/河南/焦作/温县', 'null', 4, 'w', 'wen', 'null', '454850'),
(1330, '001016006001', '淇滨', '001016006', 172, '中国/河南/鹤壁/淇滨', '区', 4, 'b', 'bin', 'null', '458030'),
(1331, '001016006002', '山城', '001016006', 172, '中国/河南/鹤壁/山城', '区', 4, 'sc', 'shancheng', 'null', '458000'),
(1332, '001016006003', '鹤山', '001016006', 172, '中国/河南/鹤壁/鹤山', '区', 4, 'hs', 'heshan', 'null', '458010'),
(1333, '001016006004', '浚县', '001016006', 172, '中国/河南/鹤壁/浚县', 'null', 4, 'j', 'jun', 'null', '456250'),
(1334, '001016006005', '淇县', '001016006', 172, '中国/河南/鹤壁/淇县', 'null', 4, 'null', 'null', 'null', '456750'),
(1335, '001016007001', '新华', '001016007', 173, '中国/河南/新乡/新华', '区', 4, 'xh', 'xinhua', 'null', '453000'),
(1336, '001016007002', '红旗', '001016007', 173, '中国/河南/新乡/红旗', '区', 4, 'hq', 'hongqi', 'null', '453000'),
(1337, '001016007003', '北站', '001016007', 173, '中国/河南/新乡/北站', '区', 4, 'bz', 'beizhan', 'null', '453011'),
(1338, '001016007004', '郊区', '001016007', 173, '中国/河南/新乡/郊区', 'null', 4, 'j', 'jiao', 'null', '453002'),
(1339, '001016007005', '卫辉', '001016007', 173, '中国/河南/新乡/卫辉', '市', 4, 'wh', 'weihui', 'null', '453100'),
(1340, '001016007006', '辉县', '001016007', 173, '中国/河南/新乡/辉县', 'null', 4, 'h', 'hui', 'null', '453600'),
(1341, '001016007007', '新乡', '001016007', 173, '中国/河南/新乡/新乡', '县', 4, 'xx', 'xinxiang', 'null', '453700'),
(1342, '001016007008', '获嘉', '001016007', 173, '中国/河南/新乡/获嘉', '县', 4, 'hj', 'huojia', 'null', '453800'),
(1343, '001016007009', '原阳', '001016007', 173, '中国/河南/新乡/原阳', '县', 4, 'yy', 'yuanyang', 'null', '453500'),
(1344, '001016007010', '延津', '001016007', 173, '中国/河南/新乡/延津', '县', 4, 'yj', 'yanjin', 'null', '453200'),
(1345, '001016007011', '封丘', '001016007', 173, '中国/河南/新乡/封丘', '县', 4, 'fq', 'fengqiu', 'null', '453300'),
(1346, '001016007012', '长垣', '001016007', 173, '中国/河南/新乡/长垣', '县', 4, 'cy', 'changyuan', 'null', '453400'),
(1347, '001016008001', '北关', '001016008', 174, '中国/河南/安阳/北关', '区', 4, 'bg', 'beiguan', 'null', '455001'),
(1348, '001016008002', '文峰', '001016008', 174, '中国/河南/安阳/文峰', '区', 4, 'wf', 'wenfeng', 'null', '455000'),
(1349, '001016008003', '殷都', '001016008', 174, '中国/河南/安阳/殷都', '区', 4, 'yd', 'yindu', 'null', '455004'),
(1350, '001016008004', '龙安', '001016008', 174, '中国/河南/安阳/龙安', '区', 4, 'la', 'longan', 'null', '455001'),
(1351, '001016008005', '林州', '001016008', 174, '中国/河南/安阳/林州', '市', 4, 'lz', 'linzhou', 'null', '456550'),
(1352, '001016008006', '安阳', '001016008', 174, '中国/河南/安阳/安阳', '县', 4, 'ay', 'anyang', 'null', '455000'),
(1353, '001016008007', '汤阴', '001016008', 174, '中国/河南/安阳/汤阴', '县', 4, 'ty', 'tangyin', 'null', '456150'),
(1354, '001016008008', '滑县', '001016008', 174, '中国/河南/安阳/滑县', 'null', 4, 'h', 'hua', 'null', '456400'),
(1355, '001016008009', '内黄', '001016008', 174, '中国/河南/安阳/内黄', '县', 4, 'nh', 'neihuang', 'null', '456350'),
(1356, '001016009001', '市区', '001016009', 175, '中国/河南/濮阳/市区', 'null', 4, 'null', 'null', 'null', '457001'),
(1357, '001016009002', '清丰', '001016009', 175, '中国/河南/濮阳/清丰', '县', 4, 'qf', 'qingfeng', 'null', '457300'),
(1358, '001016009003', '南乐', '001016009', 175, '中国/河南/濮阳/南乐', '县', 4, 'nl', 'nanle', 'null', '457400'),
(1359, '001016009004', '范县', '001016009', 175, '中国/河南/濮阳/范县', 'null', 4, 'f', 'fan', 'null', '457500'),
(1360, '001016009005', '台前', '001016009', 175, '中国/河南/濮阳/台前', '县', 4, 'tq', 'taiqian', 'null', '457600'),
(1361, '001016009006', '濮阳', '001016009', 175, '中国/河南/濮阳/濮阳', '县', 4, 'y', 'yang', 'null', '457100'),
(1362, '001016010001', '魏都', '001016010', 176, '中国/河南/许昌/魏都', '区', 4, 'wd', 'weidu', 'null', '461000'),
(1363, '001016010002', '禹州', '001016010', 176, '中国/河南/许昌/禹州', '市', 4, 'yz', 'yuzhou', 'null', '461670'),
(1364, '001016010003', '长葛', '001016010', 176, '中国/河南/许昌/长葛', '市', 4, 'cg', 'changge', 'null', '461500'),
(1365, '001016010004', '许昌', '001016010', 176, '中国/河南/许昌/许昌', '县', 4, 'xc', 'xuchang', 'null', '461100'),
(1366, '001016010005', '鄢陵', '001016010', 176, '中国/河南/许昌/鄢陵', '县', 4, 'l', 'ling', 'null', '461200'),
(1367, '001016010006', '襄城', '001016010', 176, '中国/河南/许昌/襄城', '县', 4, 'xc', 'xiangcheng', 'null', '461700'),
(1368, '001016011001', '源汇', '001016011', 177, '中国/河南/漯河/源汇', '区', 4, 'yh', 'yuanhui', 'null', '462000'),
(1369, '001016011002', '舞阳', '001016011', 177, '中国/河南/漯河/舞阳', '县', 4, 'wy', 'wuyang', 'null', '462400'),
(1370, '001016011003', '临颖', '001016011', 177, '中国/河南/漯河/临颖', '县', 4, 'ly', 'linying', 'null', '462600'),
(1371, '001016011004', '郾城', '001016011', 177, '中国/河南/漯河/郾城', '县', 4, 'c', 'cheng', 'null', '462300'),
(1372, '001016012001', '湖滨', '001016012', 178, '中国/河南/三门峡/湖滨', '区', 4, 'hb', 'hubin', 'null', '472000'),
(1373, '001016012002', '义马', '001016012', 178, '中国/河南/三门峡/义马', '市', 4, 'ym', 'yima', 'null', '472300'),
(1374, '001016012003', '灵宝', '001016012', 178, '中国/河南/三门峡/灵宝', '市', 4, 'lb', 'lingbao', 'null', '472500'),
(1375, '001016012004', '渑池', '001016012', 178, '中国/河南/三门峡/渑池', '县', 4, 'c', 'chi', 'null', '472400'),
(1376, '001016012005', '陕县', '001016012', 178, '中国/河南/三门峡/陕县', 'null', 4, 's', 'shan', 'null', '472100'),
(1377, '001016012006', '卢氏', '001016012', 178, '中国/河南/三门峡/卢氏', '县', 4, 'ls', 'lushi', 'null', '472200'),
(1378, '001016013001', '卧龙', '001016013', 179, '中国/河南/南阳/卧龙', '区', 4, 'wl', 'wolong', 'null', '473003'),
(1379, '001016013002', '宛城', '001016013', 179, '中国/河南/南阳/宛城', '区', 4, 'wc', 'wancheng', 'null', '473001'),
(1380, '001016013003', '邓州', '001016013', 179, '中国/河南/南阳/邓州', '市', 4, 'dz', 'dengzhou', 'null', '474150'),
(1381, '001016013004', '南召', '001016013', 179, '中国/河南/南阳/南召', '县', 4, 'nz', 'nanzhao', 'null', '474650'),
(1382, '001016013005', '方城', '001016013', 179, '中国/河南/南阳/方城', '县', 4, 'fc', 'fangcheng', 'null', '473200'),
(1383, '001016013006', '西峡', '001016013', 179, '中国/河南/南阳/西峡', '县', 4, 'xx', 'xixia', 'null', '474550'),
(1384, '001016013007', '镇平', '001016013', 179, '中国/河南/南阳/镇平', '县', 4, 'zp', 'zhenping', 'null', '474250'),
(1385, '001016013008', '内乡', '001016013', 179, '中国/河南/南阳/内乡', '县', 4, 'nx', 'neixiang', 'null', '474350'),
(1386, '001016013009', '淅川', '001016013', 179, '中国/河南/南阳/淅川', '县', 4, 'c', 'chuan', 'null', '474450'),
(1387, '001016013010', '社旗', '001016013', 179, '中国/河南/南阳/社旗', '县', 4, 'sq', 'sheqi', 'null', '473300'),
(1388, '001016013011', '唐河', '001016013', 179, '中国/河南/南阳/唐河', '县', 4, 'th', 'tanghe', 'null', '473400'),
(1389, '001016013012', '新野', '001016013', 179, '中国/河南/南阳/新野', '县', 4, 'xy', 'xinye', 'null', '473500'),
(1390, '001016013013', '桐柏', '001016013', 179, '中国/河南/南阳/桐柏', '县', 4, 'tb', 'tongbai', 'null', '474750'),
(1391, '001016014001', '梁园', '001016014', 180, '中国/河南/商丘/梁园', '区', 4, 'ly', 'liangyuan', 'null', '476000'),
(1392, '001016014002', '睢阳', '001016014', 180, '中国/河南/商丘/睢阳', '区', 4, 'y', 'yang', 'null', '476100'),
(1393, '001016014003', '永城', '001016014', 180, '中国/河南/商丘/永城', '市', 4, 'yc', 'yongcheng', 'null', '456550'),
(1394, '001016014004', '虞城', '001016014', 180, '中国/河南/商丘/虞城', '县', 4, 'yc', 'yucheng', 'null', '476100'),
(1395, '001016014005', '民权', '001016014', 180, '中国/河南/商丘/民权', '县', 4, 'mq', 'minquan', 'null', '476600'),
(1396, '001016014006', '宁陵', '001016014', 180, '中国/河南/商丘/宁陵', '县', 4, 'nl', 'ningling', 'null', '476700'),
(1397, '001016014007', '睢县', '001016014', 180, '中国/河南/商丘/睢县', 'null', 4, 'null', 'null', 'null', '476900'),
(1398, '001016014008', '夏邑', '001016014', 180, '中国/河南/商丘/夏邑', '县', 4, 'xy', 'xiayi', 'null', '476400'),
(1399, '001016014009', '柘城', '001016014', 180, '中国/河南/商丘/柘城', '县', 4, 'c', 'cheng', 'null', '476200'),
(1400, '001016015001', '浉河', '001016015', 181, '中国/河南/信阳/浉河', '区', 4, 'h', 'he', 'null', '464000'),
(1401, '001016015002', '平桥', '001016015', 181, '中国/河南/信阳/平桥', '区', 4, 'pq', 'pingqiao', 'null', '464100'),
(1402, '001016015003', '息县', '001016015', 181, '中国/河南/信阳/息县', 'null', 4, 'x', 'xi', 'null', '464300'),
(1403, '001016015004', '淮滨', '001016015', 181, '中国/河南/信阳/淮滨', '县', 4, 'hb', 'huaibin', 'null', '464400'),
(1404, '001016015005', '潢川', '001016015', 181, '中国/河南/信阳/潢川', '县', 4, 'c', 'chuan', 'null', '465150'),
(1405, '001016015006', '光山', '001016015', 181, '中国/河南/信阳/光山', '县', 4, 'gs', 'guangshan', 'null', '465450'),
(1406, '001016015007', '固始', '001016015', 181, '中国/河南/信阳/固始', '县', 4, 'gs', 'gushi', 'null', '465250'),
(1407, '001016015008', '商城', '001016015', 181, '中国/河南/信阳/商城', '县', 4, 'sc', 'shangcheng', 'null', '465350'),
(1408, '001016015009', '罗山', '001016015', 181, '中国/河南/信阳/罗山', '县', 4, 'ls', 'luoshan', 'null', '464200'),
(1409, '001016015010', '新县', '001016015', 181, '中国/河南/信阳/新县', 'null', 4, 'x', 'xin', 'null', '465550'),
(1410, '001016016001', '川汇', '001016016', 182, '中国/河南/周口/川汇', '区', 4, 'ch', 'chuanhui', 'null', '466000'),
(1411, '001016016002', '项城', '001016016', 182, '中国/河南/周口/项城', '市', 4, 'xc', 'xiangcheng', 'null', '466200'),
(1412, '001016016003', '扶沟', '001016016', 182, '中国/河南/周口/扶沟', '县', 4, 'fg', 'fugou', 'null', '461300'),
(1413, '001016016004', '西华', '001016016', 182, '中国/河南/周口/西华', '县', 4, 'xh', 'xihua', 'null', '466600'),
(1414, '001016016005', '商水', '001016016', 182, '中国/河南/周口/商水', '县', 4, 'ss', 'shangshui', 'null', '466100'),
(1415, '001016016006', '太康', '001016016', 182, '中国/河南/周口/太康', '县', 4, 'tk', 'taikang', 'null', '461400'),
(1416, '001016016007', '鹿邑', '001016016', 182, '中国/河南/周口/鹿邑', '县', 4, 'ly', 'luyi', 'null', '477200'),
(1417, '001016016008', '郸城', '001016016', 182, '中国/河南/周口/郸城', '县', 4, 'dc', 'dancheng', 'null', '477150'),
(1418, '001016016009', '淮阳', '001016016', 182, '中国/河南/周口/淮阳', '县', 4, 'hy', 'huaiyang', 'null', '466700'),
(1419, '001016016010', '沈丘', '001016016', 182, '中国/河南/周口/沈丘', '县', 4, 'sq', 'shenqiu', 'null', '466300'),
(1420, '001016017001', '驿城', '001016017', 183, '中国/河南/驻马店/驿城', '区', 4, 'c', 'cheng', 'null', '463000'),
(1421, '001016017002', '确山', '001016017', 183, '中国/河南/驻马店/确山', '县', 4, 'qs', 'queshan', 'null', '463200'),
(1422, '001016017003', '泌阳', '001016017', 183, '中国/河南/驻马店/泌阳', '县', 4, 'my', 'miyang', 'null', '463700'),
(1423, '001016017004', '遂平', '001016017', 183, '中国/河南/驻马店/遂平', '县', 4, 'sp', 'suiping', 'null', '463100'),
(1424, '001016017005', '西平', '001016017', 183, '中国/河南/驻马店/西平', '县', 4, 'xp', 'xiping', 'null', '463900'),
(1425, '001016017006', '上蔡', '001016017', 183, '中国/河南/驻马店/上蔡', '县', 4, 'sc', 'shangcai', 'null', '463800'),
(1426, '001016017007', '汝南', '001016017', 183, '中国/河南/驻马店/汝南', '县', 4, 'rn', 'runan', 'null', '463300'),
(1427, '001016017008', '平舆', '001016017', 183, '中国/河南/驻马店/平舆', '县', 4, 'py', 'pingyu', 'null', '463400'),
(1428, '001016017009', '新蔡', '001016017', 183, '中国/河南/驻马店/新蔡', '县', 4, 'xc', 'xincai', 'null', '463500'),
(1429, '001016017010', '正阳', '001016017', 183, '中国/河南/驻马店/正阳', '县', 4, 'zy', 'zhengyang', 'null', '463600'),
(1430, '001017001001', '江岸', '001017001', 185, '中国/湖北/武汉/江岸', '区', 4, 'ja', 'jiangan', 'null', '430014'),
(1431, '001017001002', '江汉', '001017001', 185, '中国/湖北/武汉/江汉', '区', 4, 'jh', 'jianghan', 'null', '430021'),
(1432, '001017001003', '硚口', '001017001', 185, '中国/湖北/武汉/硚口', '区', 4, 'ck', 'changkou', 'null', '430033'),
(1433, '001017001004', '汉阳', '001017001', 185, '中国/湖北/武汉/汉阳', '区', 4, 'hy', 'hanyang', 'null', '430050'),
(1434, '001017001005', '武昌', '001017001', 185, '中国/湖北/武汉/武昌', '区', 4, 'wc', 'wuchang', 'null', '430061'),
(1435, '001017001006', '青山', '001017001', 185, '中国/湖北/武汉/青山', '区', 4, 'qs', 'qingshan', 'null', '430080'),
(1436, '001017001007', '洪山', '001017001', 185, '中国/湖北/武汉/洪山', '区', 4, 'hs', 'hongshan', 'null', '430070'),
(1437, '001017001008', '东西湖', '001017001', 185, '中国/湖北/武汉/东西湖', '区', 4, 'dxh', 'dongxihu', 'null', '430040'),
(1438, '001017001009', '汉南', '001017001', 185, '中国/湖北/武汉/汉南', '区', 4, 'hn', 'hannan', 'null', '430090'),
(1439, '001017001010', '蔡甸', '001017001', 185, '中国/湖北/武汉/蔡甸', '区', 4, 'cd', 'caidian', 'null', '430100'),
(1440, '001017001011', '江夏', '001017001', 185, '中国/湖北/武汉/江夏', '区', 4, 'jx', 'jiangxia', 'null', '430200'),
(1441, '001017001012', '黄陂', '001017001', 185, '中国/湖北/武汉/黄陂', '区', 4, 'h', 'huang', 'null', '432200'),
(1442, '001017001013', '新洲', '001017001', 185, '中国/湖北/武汉/新洲', '区', 4, 'xz', 'xinzhou', 'null', '431400'),
(1443, '001017002001', '黄石港', '001017002', 186, '中国/湖北/黄石/黄石港', '区', 4, 'hsg', 'huangshigan', 'null', '435000'),
(1444, '001017002002', '西塞山', '001017002', 186, '中国/湖北/黄石/西塞山', '区', 4, 'xss', 'xisaishan', 'null', '435001'),
(1445, '001017002003', '下陆', '001017002', 186, '中国/湖北/黄石/下陆', '区', 4, 'xl', 'xialu', 'null', '435005'),
(1446, '001017002004', '铁山', '001017002', 186, '中国/湖北/黄石/铁山', '区', 4, 'ts', 'tieshan', 'null', '435006'),
(1447, '001017002005', '大冶', '001017002', 186, '中国/湖北/黄石/大冶', '市', 4, 'dy', 'daye', 'null', '435100'),
(1448, '001017002006', '阳新', '001017002', 186, '中国/湖北/黄石/阳新', '县', 4, 'yx', 'yangxin', 'null', '435200'),
(1449, '001017003001', '襄城', '001017003', 187, '中国/湖北/襄樊/襄城', '区', 4, 'xc', 'xiangcheng', 'null', '441021'),
(1450, '001017003002', '樊城', '001017003', 187, '中国/湖北/襄樊/樊城', '区', 4, 'fc', 'fancheng', 'null', '441001'),
(1451, '001017003003', '襄阳', '001017003', 187, '中国/湖北/襄樊/襄阳', '区', 4, 'xy', 'xiangyang', 'null', '441100'),
(1452, '001017003004', '老河口', '001017003', 187, '中国/湖北/襄樊/老河口', '市', 4, 'lhk', 'laohekou', 'null', '441800'),
(1453, '001017003005', '枣阳', '001017003', 187, '中国/湖北/襄樊/枣阳', '市', 4, 'zy', 'zaoyang', 'null', '441200'),
(1454, '001017003006', '宜城', '001017003', 187, '中国/湖北/襄樊/宜城', '市', 4, 'yc', 'yicheng', 'null', '441400'),
(1455, '001017003007', '南漳', '001017003', 187, '中国/湖北/襄樊/南漳', '县', 4, 'nz', 'nanzhang', 'null', '441500'),
(1456, '001017003008', '谷城', '001017003', 187, '中国/湖北/襄樊/谷城', '县', 4, 'gc', 'gucheng', 'null', '441700'),
(1457, '001017003009', '保康', '001017003', 187, '中国/湖北/襄樊/保康', '县', 4, 'bk', 'baokang', 'null', '441600'),
(1458, '001017004001', '张湾', '001017004', 188, '中国/湖北/十堰/张湾', '区', 4, 'zw', 'zhangwan', 'null', '442001'),
(1459, '001017004002', '茅箭', '001017004', 188, '中国/湖北/十堰/茅箭', '区', 4, 'mj', 'maojian', 'null', '442012'),
(1460, '001017004003', '丹江口', '001017004', 188, '中国/湖北/十堰/丹江口', '市', 4, 'djk', 'danjiangkou', 'null', '442700'),
(1461, '001017004004', '郧县', '001017004', 188, '中国/湖北/十堰/郧县', 'null', 4, 'y', 'yun', 'null', '442500'),
(1462, '001017004005', '竹山', '001017004', 188, '中国/湖北/十堰/竹山', '县', 4, 'zs', 'zhushan', 'null', '442200'),
(1463, '001017004006', '房县', '001017004', 188, '中国/湖北/十堰/房县', 'null', 4, 'f', 'fang', 'null', '442100'),
(1464, '001017004007', '郧西', '001017004', 188, '中国/湖北/十堰/郧西', '县', 4, 'yx', 'yunxi', 'null', '442600'),
(1465, '001017004008', '竹溪', '001017004', 188, '中国/湖北/十堰/竹溪', '县', 4, 'zx', 'zhuxi', 'null', '442300'),
(1466, '001017005001', '沙市', '001017005', 189, '中国/湖北/荆州/沙市', '区', 4, 's', 'sha', 'null', '434000'),
(1467, '001017005002', '荆州', '001017005', 189, '中国/湖北/荆州/荆州', '区', 4, 'jz', 'jingzhou', 'null', '434020'),
(1468, '001017005003', '石首', '001017005', 189, '中国/湖北/荆州/石首', '市', 4, 'ss', 'shishou', 'null', '434400'),
(1469, '001017005004', '洪湖', '001017005', 189, '中国/湖北/荆州/洪湖', '市', 4, 'hh', 'honghu', 'null', '433200'),
(1470, '001017005005', '松滋', '001017005', 189, '中国/湖北/荆州/松滋', '市', 4, 'sz', 'songzi', 'null', '434200'),
(1471, '001017005006', '江陵', '001017005', 189, '中国/湖北/荆州/江陵', '县', 4, 'jl', 'jiangling', 'null', '434101'),
(1472, '001017005007', '公安', '001017005', 189, '中国/湖北/荆州/公安', '县', 4, 'ga', 'gongan', 'null', '434300'),
(1473, '001017005008', '监利', '001017005', 189, '中国/湖北/荆州/监利', '县', 4, 'jl', 'jianli', 'null', '433300'),
(1474, '001017006001', '西陵', '001017006', 190, '中国/湖北/宜昌/西陵', '区', 4, 'xl', 'xiling', 'null', '443000'),
(1475, '001017006002', '伍家岗', '001017006', 190, '中国/湖北/宜昌/伍家岗', '区', 4, 'wjg', 'wujiagang', 'null', '443001'),
(1476, '001017006003', '点军', '001017006', 190, '中国/湖北/宜昌/点军', '区', 4, 'dj', 'dianjun', 'null', '443006'),
(1477, '001017006004', '猇亭', '001017006', 190, '中国/湖北/宜昌/猇亭', '区', 4, 't', 'ting', 'null', '443007'),
(1478, '001017006005', '夷陵', '001017006', 190, '中国/湖北/宜昌/夷陵', '区', 4, 'yl', 'yiling', 'null', '443100'),
(1479, '001017006006', '枝江', '001017006', 190, '中国/湖北/宜昌/枝江', '市', 4, 'zj', 'zhijiang', 'null', '443200'),
(1480, '001017006007', '宜都', '001017006', 190, '中国/湖北/宜昌/宜都', '市', 4, 'yd', 'yidu', 'null', '443300'),
(1481, '001017006008', '当阳', '001017006', 190, '中国/湖北/宜昌/当阳', '市', 4, 'dy', 'dangyang', 'null', '444100'),
(1482, '001017006009', '远安', '001017006', 190, '中国/湖北/宜昌/远安', '县', 4, 'ya', 'yuanan', 'null', '444200'),
(1483, '001017006010', '兴山', '001017006', 190, '中国/湖北/宜昌/兴山', '县', 4, 'xs', 'xingshan', 'null', '443711'),
(1484, '001017006011', '秭归', '001017006', 190, '中国/湖北/宜昌/秭归', '县', 4, 'g', 'gui', 'null', '443600'),
(1485, '001017006012', '长阳', '001017006', 190, '中国/湖北/宜昌/长阳', '土家族自治县', 4, 'cytjzzz', 'changyangtu', 'null', '443500'),
(1486, '001017006013', '五峰', '001017006', 190, '中国/湖北/宜昌/五峰', '土家族自治县', 4, 'wftjzzz', 'wufengtujia', 'null', '443400'),
(1487, '001017007001', '东宝', '001017007', 191, '中国/湖北/荆门/东宝', '区', 4, 'db', 'dongbao', 'null', '448004'),
(1488, '001017007002', '掇刀', '001017007', 191, '中国/湖北/荆门/掇刀', '区', 4, 'dd', 'duodao', 'null', '448004'),
(1489, '001017007003', '钟祥', '001017007', 191, '中国/湖北/荆门/钟祥', '市', 4, 'zx', 'zhongxiang', 'null', '431900'),
(1490, '001017007004', '沙洋', '001017007', 191, '中国/湖北/荆门/沙洋', '县', 4, 'sy', 'shayang', 'null', '448200'),
(1491, '001017007005', '京山', '001017007', 191, '中国/湖北/荆门/京山', '县', 4, 'js', 'jingshan', 'null', '431800'),
(1492, '001017008001', '鄂城', '001017008', 192, '中国/湖北/鄂州/鄂城', '区', 4, 'ec', 'echeng', 'null', '436000'),
(1493, '001017008002', '梁子湖', '001017008', 192, '中国/湖北/鄂州/梁子湖', '区', 4, 'lzh', 'liangzihu', 'null', '436064'),
(1494, '001017008003', '华容', '001017008', 192, '中国/湖北/鄂州/华容', '区', 4, 'hr', 'huarong', 'null', '436030'),
(1495, '001017009001', '孝南', '001017009', 193, '中国/湖北/孝感/孝南', '区', 4, 'xn', 'xiaonan', 'null', '432100'),
(1496, '001017009002', '应城', '001017009', 193, '中国/湖北/孝感/应城', '市', 4, 'yc', 'yingcheng', 'null', '432400'),
(1497, '001017009003', '安陆', '001017009', 193, '中国/湖北/孝感/安陆', '市', 4, 'al', 'anlu', 'null', '432600'),
(1498, '001017009004', '汉川', '001017009', 193, '中国/湖北/孝感/汉川', '市', 4, 'hc', 'hanchuan', 'null', '432300'),
(1499, '001017009005', '孝昌', '001017009', 193, '中国/湖北/孝感/孝昌', '县', 4, 'xc', 'xiaochang', 'null', '432900'),
(1500, '001017009006', '大悟', '001017009', 193, '中国/湖北/孝感/大悟', '县', 4, 'dw', 'dawu', 'null', '432800'),
(1501, '001017009007', '云梦', '001017009', 193, '中国/湖北/孝感/云梦', '县', 4, 'ym', 'yunmeng', 'null', '432500'),
(1502, '001017010001', '黄州', '001017010', 194, '中国/湖北/黄冈/黄州', '区', 4, 'hz', 'huangzhou', 'null', '438000'),
(1503, '001017010002', '麻城', '001017010', 194, '中国/湖北/黄冈/麻城', '市', 4, 'mc', 'macheng', 'null', '438300'),
(1504, '001017010003', '武穴', '001017010', 194, '中国/湖北/黄冈/武穴', '市', 4, 'wx', 'wuxue', 'null', '435400'),
(1505, '001017010004', '红安', '001017010', 194, '中国/湖北/黄冈/红安', '县', 4, 'ha', 'hongan', 'null', '438401'),
(1506, '001017010005', '罗田', '001017010', 194, '中国/湖北/黄冈/罗田', '县', 4, 'lt', 'luotian', 'null', '438600'),
(1507, '001017010006', '英山', '001017010', 194, '中国/湖北/黄冈/英山', '县', 4, 'ys', 'yingshan', 'null', '438700'),
(1508, '001017010007', '浠水', '001017010', 194, '中国/湖北/黄冈/浠水', '县', 4, 's', 'shui', 'null', '438200'),
(1509, '001017010008', '蕲春', '001017010', 194, '中国/湖北/黄冈/蕲春', '县', 4, 'c', 'chun', 'null', '435300'),
(1510, '001017010009', '黄梅', '001017010', 194, '中国/湖北/黄冈/黄梅', '县', 4, 'hm', 'huangmei', 'null', '435500'),
(1511, '001017010010', '团风', '001017010', 194, '中国/湖北/黄冈/团风', '县', 4, 'tf', 'tuanfeng', 'null', '438000'),
(1512, '001017011001', '咸安', '001017011', 195, '中国/湖北/咸宁/咸安', '区', 4, 'xa', 'xianan', 'null', '437000'),
(1513, '001017011002', '赤壁', '001017011', 195, '中国/湖北/咸宁/赤壁', '市', 4, 'cb', 'chibi', 'null', '437300'),
(1514, '001017011003', '嘉鱼', '001017011', 195, '中国/湖北/咸宁/嘉鱼', '县', 4, 'jy', 'jiayu', 'null', '437200'),
(1515, '001017011004', '通城', '001017011', 195, '中国/湖北/咸宁/通城', '县', 4, 'tc', 'tongcheng', 'null', '437400'),
(1516, '001017011005', '崇阳', '001017011', 195, '中国/湖北/咸宁/崇阳', '县', 4, 'cy', 'chongyang', 'null', '437500'),
(1517, '001017011006', '通山', '001017011', 195, '中国/湖北/咸宁/通山', '县', 4, 'ts', 'tongshan', 'null', '437600'),
(1518, '001017012001', '曾都', '001017012', 196, '中国/湖北/随州/曾都', '区', 4, 'zd', 'zengdu', 'null', '441300'),
(1519, '001017012002', '广水', '001017012', 196, '中国/湖北/随州/广水', '市', 4, 'gs', 'guangshui', 'null', '432700'),
(1520, '001017013001', '恩施', '001017013', 197, '中国/湖北/恩施/恩施', '市', 4, 'es', 'enshi', 'null', '445000'),
(1521, '001017013002', '利川', '001017013', 197, '中国/湖北/恩施/利川', '市', 4, 'lc', 'lichuan', 'null', '445400'),
(1522, '001017013003', '建始', '001017013', 197, '中国/湖北/恩施/建始', '县', 4, 'js', 'jianshi', 'null', '445300'),
(1523, '001017013004', '巴东', '001017013', 197, '中国/湖北/恩施/巴东', '县', 4, 'bd', 'badong', 'null', '444300'),
(1524, '001017013005', '宣恩', '001017013', 197, '中国/湖北/恩施/宣恩', '县', 4, 'xe', 'xuanen', 'null', '445500'),
(1525, '001017013006', '咸丰', '001017013', 197, '中国/湖北/恩施/咸丰', '县', 4, 'xf', 'xianfeng', 'null', '445600'),
(1526, '001017013007', '来凤', '001017013', 197, '中国/湖北/恩施/来凤', '县', 4, 'lf', 'laifeng', 'null', '445700'),
(1527, '001017013008', '鹤峰', '001017013', 197, '中国/湖北/恩施/鹤峰', '县', 4, 'hf', 'hefeng', 'null', '445800'),
(1528, '001017014001', '潜江', '001017014', 198, '中国/湖北/直辖行政单位/潜江', '市', 4, 'qj', 'qianjiang', 'null', '433100'),
(1529, '001017014002', '神农架林', '001017014', 198, '中国/湖北/直辖行政单位/神农架林', '区', 4, 'snjl', 'shennongjia', 'null', '442400'),
(1530, '001018001001', '岳麓', '001018001', 199, '中国/湖南/长沙/岳麓', '区', 4, 'yl', 'yuelu', 'null', '410006'),
(1531, '001018001002', '芙蓉', '001018001', 199, '中国/湖南/长沙/芙蓉', '区', 4, 'r', 'rong', 'null', '410011'),
(1532, '001018001003', '天心', '001018001', 199, '中国/湖南/长沙/天心', '区', 4, 'tx', 'tianxin', 'null', '410002'),
(1533, '001018001004', '开福', '001018001', 199, '中国/湖南/长沙/开福', '区', 4, 'kf', 'kaifu', 'null', '410005'),
(1534, '001018001005', '雨花', '001018001', 199, '中国/湖南/长沙/雨花', '区', 4, 'yh', 'yuhua', 'null', '410007'),
(1535, '001018001006', '浏阳', '001018001', 199, '中国/湖南/长沙/浏阳', '市', 4, 'y', 'yang', 'null', '410300'),
(1536, '001018001007', '长沙', '001018001', 199, '中国/湖南/长沙/长沙', '县', 4, 'cs', 'changsha', 'null', '410100'),
(1537, '001018001008', '望城', '001018001', 199, '中国/湖南/长沙/望城', '县', 4, 'wc', 'wangcheng', 'null', '410200'),
(1538, '001018001009', '宁乡', '001018001', 199, '中国/湖南/长沙/宁乡', '县', 4, 'nx', 'ningxiang', 'null', '410600'),
(1539, '001018002001', '天元', '001018002', 200, '中国/湖南/株洲/天元', '区', 4, 'ty', 'tianyuan', 'null', '412000'),
(1540, '001018002002', '荷塘', '001018002', 200, '中国/湖南/株洲/荷塘', '区', 4, 'ht', 'hetang', 'null', '412000'),
(1541, '001018002003', '芦淞', '001018002', 200, '中国/湖南/株洲/芦淞', '区', 4, 'l', 'lu', 'null', '412000'),
(1542, '001018002004', '石峰', '001018002', 200, '中国/湖南/株洲/石峰', '区', 4, 'sf', 'shifeng', 'null', '412005'),
(1543, '001018002005', '醴陵', '001018002', 200, '中国/湖南/株洲/醴陵', '市', 4, 'l', 'ling', 'null', '412200'),
(1544, '001018002006', '株洲', '001018002', 200, '中国/湖南/株洲/株洲', '县', 4, 'zz', 'zhuzhou', 'null', '412100'),
(1545, '001018002007', '攸县', '001018002', 200, '中国/湖南/株洲/攸县', 'null', 4, 'null', 'null', 'null', '412300'),
(1546, '001018002008', '茶陵', '001018002', 200, '中国/湖南/株洲/茶陵', '县', 4, 'cl', 'chaling', 'null', '412400'),
(1547, '001018002009', '炎陵', '001018002', 200, '中国/湖南/株洲/炎陵', '县', 4, 'yl', 'yanling', 'null', '412500'),
(1548, '001018003001', '雨湖', '001018003', 201, '中国/湖南/湘潭/雨湖', '区', 4, 'yh', 'yuhu', 'null', '411100'),
(1549, '001018003002', '岳塘', '001018003', 201, '中国/湖南/湘潭/岳塘', '区', 4, 'yt', 'yuetang', 'null', '411101'),
(1550, '001018003003', '湘乡', '001018003', 201, '中国/湖南/湘潭/湘乡', '市', 4, 'xx', 'xiangxiang', 'null', '411400'),
(1551, '001018003004', '韶山', '001018003', 201, '中国/湖南/湘潭/韶山', '市', 4, 'ss', 'shaoshan', 'null', '411300'),
(1552, '001018003005', '湘潭', '001018003', 201, '中国/湖南/湘潭/湘潭', '县', 4, 'xt', 'xiangtan', 'null', '411200'),
(1553, '001018004001', '雁峰', '001018004', 202, '中国/湖南/衡阳/雁峰', '区', 4, 'yf', 'yanfeng', 'null', '421001'),
(1554, '001018004002', '珠晖', '001018004', 202, '中国/湖南/衡阳/珠晖', '区', 4, 'z', 'zhu', 'null', '421002'),
(1555, '001018004003', '石鼓', '001018004', 202, '中国/湖南/衡阳/石鼓', '区', 4, 'sg', 'shigu', 'null', '421001'),
(1556, '001018004004', '蒸湘', '001018004', 202, '中国/湖南/衡阳/蒸湘', '区', 4, 'zx', 'zhengxiang', 'null', '421001'),
(1557, '001018004005', '南岳', '001018004', 202, '中国/湖南/衡阳/南岳', '区', 4, 'ny', 'nanyue', 'null', '421000'),
(1558, '001018004006', '常宁', '001018004', 202, '中国/湖南/衡阳/常宁', '市', 4, 'cn', 'changning', 'null', '421500'),
(1559, '001018004007', '耒阳', '001018004', 202, '中国/湖南/衡阳/耒阳', '市', 4, 'y', 'yang', 'null', '421800'),
(1560, '001018004008', '衡阳', '001018004', 202, '中国/湖南/衡阳/衡阳', '县', 4, 'hy', 'hengyang', 'null', '421200'),
(1561, '001018004009', '衡南', '001018004', 202, '中国/湖南/衡阳/衡南', '县', 4, 'hn', 'hengnan', 'null', '421001'),
(1562, '001018004010', '衡山', '001018004', 202, '中国/湖南/衡阳/衡山', '县', 4, 'hs', 'hengshan', 'null', '421300'),
(1563, '001018004011', '衡东', '001018004', 202, '中国/湖南/衡阳/衡东', '县', 4, 'hd', 'hengdong', 'null', '421400'),
(1564, '001018004012', '祁东', '001018004', 202, '中国/湖南/衡阳/祁东', '县', 4, 'qd', 'qidong', 'null', '421600'),
(1565, '001018005001', '大祥', '001018005', 203, '中国/湖南/邵阳/大祥', '区', 4, 'dx', 'daxiang', 'null', '422000');
INSERT INTO `des_district` (`serialId`, `districtId`, `districtName`, `districtUpId`, `districtUpIdNum`, `districtPath`, `districtType`, `districtTypeNum`, `shortName`, `spell`, `areaId`, `postCode`) VALUES
(1566, '001018005002', '北塔', '001018005', 203, '中国/湖南/邵阳/北塔', '区', 4, 'bt', 'beita', 'null', '422001'),
(1567, '001018005003', '武冈', '001018005', 203, '中国/湖南/邵阳/武冈', '市', 4, 'wg', 'wugang', 'null', '422400'),
(1568, '001018005004', '邵东', '001018005', 203, '中国/湖南/邵阳/邵东', '县', 4, 'sd', 'shaodong', 'null', '422800'),
(1569, '001018005005', '邵阳', '001018005', 203, '中国/湖南/邵阳/邵阳', '县', 4, 'sy', 'shaoyang', 'null', '422100'),
(1570, '001018005006', '新邵', '001018005', 203, '中国/湖南/邵阳/新邵', '县', 4, 'xs', 'xinshao', 'null', '422900'),
(1571, '001018005007', '隆回', '001018005', 203, '中国/湖南/邵阳/隆回', '县', 4, 'lh', 'longhui', 'null', '422200'),
(1572, '001018005008', '洞口', '001018005', 203, '中国/湖南/邵阳/洞口', '县', 4, 'dk', 'dongkou', 'null', '422300'),
(1573, '001018005009', '绥宁', '001018005', 203, '中国/湖南/邵阳/绥宁', '县', 4, 'sn', 'suining', 'null', '422600'),
(1574, '001018005010', '新宁', '001018005', 203, '中国/湖南/邵阳/新宁', '县', 4, 'xn', 'xinning', 'null', '422700'),
(1575, '001018005011', '城步', '001018005', 203, '中国/湖南/邵阳/城步', '苗族自治县', 4, 'cbmzzz', 'chengbumiao', 'null', '422500'),
(1576, '001018006001', '岳阳楼', '001018006', 204, '中国/湖南/岳阳/岳阳楼', '区', 4, 'yyl', 'yueyanglou', 'null', '414000'),
(1577, '001018006002', '君山', '001018006', 204, '中国/湖南/岳阳/君山', '区', 4, 'js', 'junshan', 'null', '414005'),
(1578, '001018006003', '云溪', '001018006', 204, '中国/湖南/岳阳/云溪', '区', 4, 'yx', 'yunxi', 'null', '414003'),
(1579, '001018006004', '汨罗', '001018006', 204, '中国/湖南/岳阳/汨罗', '市', 4, 'l', 'luo', 'null', '414400'),
(1580, '001018006005', '临湘', '001018006', 204, '中国/湖南/岳阳/临湘', '市', 4, 'lx', 'linxiang', 'null', '414300'),
(1581, '001018006006', '岳阳', '001018006', 204, '中国/湖南/岳阳/岳阳', '县', 4, 'yy', 'yueyang', 'null', '414100'),
(1582, '001018006007', '华容', '001018006', 204, '中国/湖南/岳阳/华容', '县', 4, 'hr', 'huarong', 'null', '414200'),
(1583, '001018006008', '湘阴', '001018006', 204, '中国/湖南/岳阳/湘阴', '县', 4, 'xy', 'xiangyin', 'null', '410500'),
(1584, '001018006009', '平江', '001018006', 204, '中国/湖南/岳阳/平江', '县', 4, 'pj', 'pingjiang', 'null', '410400'),
(1585, '001018007001', '武陵', '001018007', 205, '中国/湖南/常德/武陵', '区', 4, 'wl', 'wuling', 'null', '415000'),
(1586, '001018007002', '鼎城', '001018007', 205, '中国/湖南/常德/鼎城', '区', 4, 'dc', 'dingcheng', 'null', '415100'),
(1587, '001018007003', '津市', '001018007', 205, '中国/湖南/常德/津市', 'null', 4, 'j', 'jin', 'null', '415400'),
(1588, '001018007004', '安乡', '001018007', 205, '中国/湖南/常德/安乡', '县', 4, 'ax', 'anxiang', 'null', '415600'),
(1589, '001018007005', '汉寿', '001018007', 205, '中国/湖南/常德/汉寿', '县', 4, 'hs', 'hanshou', 'null', '415900'),
(1590, '001018007006', '澧县', '001018007', 205, '中国/湖南/常德/澧县', 'null', 4, 'null', 'null', 'null', '415500'),
(1591, '001018007007', '临澧', '001018007', 205, '中国/湖南/常德/临澧', '县', 4, 'l', 'lin', 'null', '415200'),
(1592, '001018007008', '桃源', '001018007', 205, '中国/湖南/常德/桃源', '县', 4, 'ty', 'taoyuan', 'null', '415700'),
(1593, '001018007009', '石门', '001018007', 205, '中国/湖南/常德/石门', '县', 4, 'sm', 'shimen', 'null', '415300'),
(1594, '001018008001', '永定', '001018008', 206, '中国/湖南/张家界/永定', '区', 4, 'yd', 'yongding', 'null', '427000'),
(1595, '001018008002', '武陵源', '001018008', 206, '中国/湖南/张家界/武陵源', '区', 4, 'wly', 'wulingyuan', 'null', '427400'),
(1596, '001018008003', '慈利', '001018008', 206, '中国/湖南/张家界/慈利', '县', 4, 'cl', 'cili', 'null', '427200'),
(1597, '001018008004', '桑植', '001018008', 206, '中国/湖南/张家界/桑植', '县', 4, 'sz', 'sangzhi', 'null', '427100'),
(1598, '001018009001', '赫山', '001018009', 207, '中国/湖南/益阳/赫山', '区', 4, 'hs', 'heshan', 'null', '413002'),
(1599, '001018009002', '资阳', '001018009', 207, '中国/湖南/益阳/资阳', '区', 4, 'zy', 'ziyang', 'null', '413000'),
(1600, '001018009003', '沅江', '001018009', 207, '中国/湖南/益阳/沅江', '市', 4, 'j', 'jiang', 'null', '413100'),
(1601, '001018009004', '南县', '001018009', 207, '中国/湖南/益阳/南县', 'null', 4, 'n', 'nan', 'null', '413200'),
(1602, '001018009005', '桃江', '001018009', 207, '中国/湖南/益阳/桃江', '县', 4, 'tj', 'taojiang', 'null', '413400'),
(1603, '001018009006', '安化', '001018009', 207, '中国/湖南/益阳/安化', '县', 4, 'ah', 'anhua', 'null', '413500'),
(1604, '001018010001', '北湖', '001018010', 208, '中国/湖南/郴州/北湖', '区', 4, 'bh', 'beihu', 'null', '423000'),
(1605, '001018010002', '苏仙', '001018010', 208, '中国/湖南/郴州/苏仙', '区', 4, 'sx', 'suxian', 'null', '423000'),
(1606, '001018010003', '资兴', '001018010', 208, '中国/湖南/郴州/资兴', '市', 4, 'zx', 'zixing', 'null', '423400'),
(1607, '001018010004', '桂阳', '001018010', 208, '中国/湖南/郴州/桂阳', '县', 4, 'gy', 'guiyang', 'null', '424400'),
(1608, '001018010005', '永兴', '001018010', 208, '中国/湖南/郴州/永兴', '县', 4, 'yx', 'yongxing', 'null', '423300'),
(1609, '001018010006', '宜章', '001018010', 208, '中国/湖南/郴州/宜章', '县', 4, 'yz', 'yizhang', 'null', '424200'),
(1610, '001018010007', '嘉禾', '001018010', 208, '中国/湖南/郴州/嘉禾', '县', 4, 'jh', 'jiahe', 'null', '424500'),
(1611, '001018010008', '临武', '001018010', 208, '中国/湖南/郴州/临武', '县', 4, 'lw', 'linwu', 'null', '424300'),
(1612, '001018010009', '汝城', '001018010', 208, '中国/湖南/郴州/汝城', '县', 4, 'rc', 'rucheng', 'null', '424100'),
(1613, '001018010010', '桂东', '001018010', 208, '中国/湖南/郴州/桂东', '县', 4, 'gd', 'guidong', 'null', '423500'),
(1614, '001018010011', '安仁', '001018010', 208, '中国/湖南/郴州/安仁', '县', 4, 'ar', 'anren', 'null', '423600'),
(1615, '001018011001', '冷水滩', '001018011', 209, '中国/湖南/永州/冷水滩', '区', 4, 'lst', 'lengshuitan', 'null', '425000'),
(1616, '001018011002', '芝山', '001018011', 209, '中国/湖南/永州/芝山', '区', 4, 'zs', 'zhishan', 'null', '425007'),
(1617, '001018011003', '东安', '001018011', 209, '中国/湖南/永州/东安', '县', 4, 'da', 'dongan', 'null', '425900'),
(1618, '001018011004', '道县', '001018011', 209, '中国/湖南/永州/道县', 'null', 4, 'd', 'dao', 'null', '425300'),
(1619, '001018011005', '宁远', '001018011', 209, '中国/湖南/永州/宁远', '县', 4, 'ny', 'ningyuan', 'null', '425600'),
(1620, '001018011006', '江永', '001018011', 209, '中国/湖南/永州/江永', '县', 4, 'jy', 'jiangyong', 'null', '425400'),
(1621, '001018011007', '蓝山', '001018011', 209, '中国/湖南/永州/蓝山', '县', 4, 'ls', 'lanshan', 'null', '425800'),
(1622, '001018011008', '新田', '001018011', 209, '中国/湖南/永州/新田', '县', 4, 'xt', 'xintian', 'null', '425700'),
(1623, '001018011009', '双牌', '001018011', 209, '中国/湖南/永州/双牌', '县', 4, 'sp', 'shuangpai', 'null', '425200'),
(1624, '001018011010', '祁阳', '001018011', 209, '中国/湖南/永州/祁阳', '县', 4, 'qy', 'qiyang', 'null', '421700'),
(1625, '001018011011', '江华', '001018011', 209, '中国/湖南/永州/江华', '瑶族自治县', 4, 'jhyzzz', 'jianghuayao', 'null', '425500'),
(1626, '001018012001', '洪江', '001018012', 210, '中国/湖南/怀化/洪江', '市', 4, 'hj', 'hongjiang', 'null', '418200'),
(1627, '001018012002', '沅陵', '001018012', 210, '中国/湖南/怀化/沅陵', '县', 4, 'l', 'ling', 'null', '419600'),
(1628, '001018012003', '辰溪', '001018012', 210, '中国/湖南/怀化/辰溪', '县', 4, 'cx', 'chenxi', 'null', '419500'),
(1629, '001018012004', '溆浦', '001018012', 210, '中国/湖南/怀化/溆浦', '县', 4, 'p', 'pu', 'null', '419300'),
(1630, '001018012005', '中方', '001018012', 210, '中国/湖南/怀化/中方', '县', 4, 'zf', 'zhongfang', 'null', '418005'),
(1631, '001018012006', '会同', '001018012', 210, '中国/湖南/怀化/会同', '县', 4, 'ht', 'huitong', 'null', '418300'),
(1632, '001018012007', '麻阳', '001018012', 210, '中国/湖南/怀化/麻阳', '苗族自治县', 4, 'mymzzz', 'mayangmiaoz', 'null', '419400'),
(1633, '001018012008', '新晃', '001018012', 210, '中国/湖南/怀化/新晃', '侗族自治县', 4, 'xhdzzz', 'xinhuangdon', 'null', '419200'),
(1634, '001018012009', '芷江', '001018012', 210, '中国/湖南/怀化/芷江', '侗族自治县', 4, 'jdzzz', 'jiangdongzu', 'null', '419100'),
(1635, '001018012010', '靖州', '001018012', 210, '中国/湖南/怀化/靖州', '苗族侗族自治县', 4, 'jmzdzzz', 'jingmiaozud', 'null', '418400'),
(1636, '001018012011', '通道', '001018012', 210, '中国/湖南/怀化/通道', '侗族自治县', 4, 'tddzzz', 'tongdaodong', 'null', '418500'),
(1637, '001018013001', '娄星', '001018013', 211, '中国/湖南/娄底/娄星', '区', 4, 'lx', 'louxing', 'null', '417000'),
(1638, '001018013002', '冷水江', '001018013', 211, '中国/湖南/娄底/冷水江', '市', 4, 'lsj', 'lengshuijia', 'null', '417500'),
(1639, '001018013003', '涟源', '001018013', 211, '中国/湖南/娄底/涟源', '市', 4, 'ly', 'lianyuan', 'null', '417100'),
(1640, '001018013004', '双峰', '001018013', 211, '中国/湖南/娄底/双峰', '县', 4, 'sf', 'shuangfeng', 'null', '417700'),
(1641, '001018013005', '新化', '001018013', 211, '中国/湖南/娄底/新化', '县', 4, 'xh', 'xinhua', 'null', '417600'),
(1642, '001018014001', '吉首', '001018014', 212, '中国/湖南/湘西/吉首', '市', 4, 'js', 'jishou', 'null', '416000'),
(1643, '001018014002', '泸溪', '001018014', 212, '中国/湖南/湘西/泸溪', '县', 4, 'x', 'xi', 'null', '416100'),
(1644, '001018014003', '凤凰', '001018014', 212, '中国/湖南/湘西/凤凰', '县', 4, 'fh', 'fenghuang', 'null', '416200'),
(1645, '001018014004', '花垣', '001018014', 212, '中国/湖南/湘西/花垣', '县', 4, 'hy', 'huayuan', 'null', '416400'),
(1646, '001018014005', '保靖', '001018014', 212, '中国/湖南/湘西/保靖', '县', 4, 'bj', 'baojing', 'null', '416500'),
(1647, '001018014006', '古丈', '001018014', 212, '中国/湖南/湘西/古丈', '县', 4, 'gz', 'guzhang', 'null', '416300'),
(1648, '001018014007', '永顺', '001018014', 212, '中国/湖南/湘西/永顺', '县', 4, 'ys', 'yongshun', 'null', '416700'),
(1649, '001018014008', '龙山', '001018014', 212, '中国/湖南/湘西/龙山', '县', 4, 'ls', 'longshan', 'null', '416800'),
(1650, '001019001001', '越秀', '001019001', 213, '中国/广东/广州/越秀', '区', 4, 'yx', 'yuexiu', 'null', '510030'),
(1651, '001019001002', '东山', '001019001', 213, '中国/广东/广州/东山', '区', 4, 'ds', 'dongshan', 'null', '510080'),
(1652, '001019001003', '荔湾', '001019001', 213, '中国/广东/广州/荔湾', '区', 4, 'lw', 'liwan', 'null', '510145'),
(1653, '001019001004', '海珠', '001019001', 213, '中国/广东/广州/海珠', '区', 4, 'hz', 'haizhu', 'null', '510220'),
(1654, '001019001005', '天河', '001019001', 213, '中国/广东/广州/天河', '区', 4, 'th', 'tianhe', 'null', '510630'),
(1655, '001019001006', '芳村', '001019001', 213, '中国/广东/广州/芳村', '区', 4, 'fc', 'fangcun', 'null', '510360'),
(1656, '001019001007', '白云', '001019001', 213, '中国/广东/广州/白云', '区', 4, 'by', 'baiyun', 'null', '510080'),
(1657, '001019001008', '黄埔', '001019001', 213, '中国/广东/广州/黄埔', '区', 4, 'hp', 'huangpu', 'null', '510700'),
(1658, '001019001009', '番禺', '001019001', 213, '中国/广东/广州/番禺', '区', 4, 'f', 'fan', 'null', '511400'),
(1659, '001019001010', '花都', '001019001', 213, '中国/广东/广州/花都', '区', 4, 'hd', 'huadu', 'null', '510800'),
(1660, '001019001011', '增城', '001019001', 213, '中国/广东/广州/增城', '市', 4, 'zc', 'zengcheng', 'null', '511300'),
(1661, '001019001012', '从化', '001019001', 213, '中国/广东/广州/从化', '市', 4, 'ch', 'conghua', 'null', '510900'),
(1662, '001019002001', '罗湖', '001019002', 214, '中国/广东/深圳/罗湖', '区', 4, 'lh', 'luohu', 'null', '518001'),
(1663, '001019002002', '南山', '001019002', 214, '中国/广东/深圳/南山', '区', 4, 'ns', 'nanshan', 'null', '518052'),
(1664, '001019002003', '宝安', '001019002', 214, '中国/广东/深圳/宝安', '区', 4, 'ba', 'baoan', 'null', '518101'),
(1665, '001019002004', '龙岗', '001019002', 214, '中国/广东/深圳/龙岗', '区', 4, 'lg', 'longgang', 'null', '518116'),
(1666, '001019002005', '盐田', '001019002', 214, '中国/广东/深圳/盐田', '区', 4, 'yt', 'yantian', 'null', '518083'),
(1667, '001019003001', '香洲', '001019003', 215, '中国/广东/珠海/香洲', '区', 4, 'xz', 'xiangzhou', 'null', '519000'),
(1668, '001019003002', '斗门', '001019003', 215, '中国/广东/珠海/斗门', '区', 4, 'dm', 'doumen', 'null', '519100'),
(1669, '001019003003', '金湾', '001019003', 215, '中国/广东/珠海/金湾', '区', 4, 'jw', 'jinwan', 'null', '519090'),
(1670, '001019004001', '金园', '001019004', 216, '中国/广东/汕头/金园', '区', 4, 'jy', 'jinyuan', 'null', '515041'),
(1671, '001019004002', '达濠', '001019004', 216, '中国/广东/汕头/达濠', '区', 4, 'd', 'da', 'null', '515071'),
(1672, '001019004003', '龙湖', '001019004', 216, '中国/广东/汕头/龙湖', '区', 4, 'lh', 'longhu', 'null', '515041'),
(1673, '001019004004', '升平', '001019004', 216, '中国/广东/汕头/升平', '区', 4, 'sp', 'shengping', 'null', '515021'),
(1674, '001019004005', '河浦', '001019004', 216, '中国/广东/汕头/河浦', '区', 4, 'hp', 'hepu', 'null', '515131'),
(1675, '001019004006', '澄海', '001019004', 216, '中国/广东/汕头/澄海', '市', 4, 'ch', 'chenghai', 'null', '515800'),
(1676, '001019004007', '潮阳', '001019004', 216, '中国/广东/汕头/潮阳', '市', 4, 'cy', 'chaoyang', 'null', '515100'),
(1677, '001019004008', '南澳', '001019004', 216, '中国/广东/汕头/南澳', '县', 4, 'na', 'nanao', 'null', '515900'),
(1678, '001019005001', '北江', '001019005', 217, '中国/广东/韶关/北江', '区', 4, 'bj', 'beijiang', 'null', '512000'),
(1679, '001019005002', '武江', '001019005', 217, '中国/广东/韶关/武江', '区', 4, 'wj', 'wujiang', 'null', '512025'),
(1680, '001019005003', '浈江', '001019005', 217, '中国/广东/韶关/浈江', '区', 4, 'j', 'jiang', 'null', '512023'),
(1681, '001019005004', '乐昌', '001019005', 217, '中国/广东/韶关/乐昌', '市', 4, 'lc', 'lechang', 'null', '512200'),
(1682, '001019005005', '南雄', '001019005', 217, '中国/广东/韶关/南雄', '市', 4, 'nx', 'nanxiong', 'null', '512400'),
(1683, '001019005006', '曲江', '001019005', 217, '中国/广东/韶关/曲江', '县', 4, 'qj', 'qujiang', 'null', '512100'),
(1684, '001019005007', '始兴', '001019005', 217, '中国/广东/韶关/始兴', '县', 4, 'sx', 'shixing', 'null', '512500'),
(1685, '001019005008', '仁化', '001019005', 217, '中国/广东/韶关/仁化', '县', 4, 'rh', 'renhua', 'null', '512300'),
(1686, '001019005009', '翁源', '001019005', 217, '中国/广东/韶关/翁源', '县', 4, 'wy', 'wengyuan', 'null', '512600'),
(1687, '001019005010', '新丰', '001019005', 217, '中国/广东/韶关/新丰', '县', 4, 'xf', 'xinfeng', 'null', '511100'),
(1688, '001019005011', '乳源', '001019005', 217, '中国/广东/韶关/乳源', '瑶族自治县', 4, 'ryyzzz', 'ruyuanyaozu', 'null', '512700'),
(1689, '001019006001', '源城', '001019006', 218, '中国/广东/河源/源城', '区', 4, 'yc', 'yuancheng', 'null', '517000'),
(1690, '001019006002', '紫金', '001019006', 218, '中国/广东/河源/紫金', '县', 4, 'zj', 'zijin', 'null', '517400'),
(1691, '001019006003', '龙川', '001019006', 218, '中国/广东/河源/龙川', '县', 4, 'lc', 'longchuan', 'null', '517300'),
(1692, '001019006004', '连平', '001019006', 218, '中国/广东/河源/连平', '县', 4, 'lp', 'lianping', 'null', '517100'),
(1693, '001019006005', '和平', '001019006', 218, '中国/广东/河源/和平', '县', 4, 'hp', 'heping', 'null', '517200'),
(1694, '001019006006', '东源', '001019006', 218, '中国/广东/河源/东源', '县', 4, 'dy', 'dongyuan', 'null', '517500'),
(1695, '001019007001', '梅江', '001019007', 219, '中国/广东/梅州/梅江', '区', 4, 'mj', 'meijiang', 'null', '514000'),
(1696, '001019007002', '兴宁', '001019007', 219, '中国/广东/梅州/兴宁', '市', 4, 'xn', 'xingning', 'null', '514500'),
(1697, '001019007003', '梅县', '001019007', 219, '中国/广东/梅州/梅县', 'null', 4, 'm', 'mei', 'null', '514733'),
(1698, '001019007004', '大埔', '001019007', 219, '中国/广东/梅州/大埔', '县', 4, 'dp', 'dapu', 'null', '514200'),
(1699, '001019007005', '丰顺', '001019007', 219, '中国/广东/梅州/丰顺', '县', 4, 'fs', 'fengshun', 'null', '514300'),
(1700, '001019007006', '五华', '001019007', 219, '中国/广东/梅州/五华', '县', 4, 'wh', 'wuhua', 'null', '514400'),
(1701, '001019007007', '平远', '001019007', 219, '中国/广东/梅州/平远', '县', 4, 'py', 'pingyuan', 'null', '514600'),
(1702, '001019007008', '蕉岭', '001019007', 219, '中国/广东/梅州/蕉岭', '县', 4, 'jl', 'jiaoling', 'null', '514100'),
(1703, '001019008001', '惠城', '001019008', 220, '中国/广东/惠州/惠城', '区', 4, 'hc', 'huicheng', 'null', '516001'),
(1704, '001019008002', '惠阳', '001019008', 220, '中国/广东/惠州/惠阳', '市', 4, 'hy', 'huiyang', 'null', '516200'),
(1705, '001019008003', '博罗', '001019008', 220, '中国/广东/惠州/博罗', '县', 4, 'bl', 'boluo', 'null', '516100'),
(1706, '001019008004', '惠东', '001019008', 220, '中国/广东/惠州/惠东', '县', 4, 'hd', 'huidong', 'null', '516300'),
(1707, '001019008005', '龙门', '001019008', 220, '中国/广东/惠州/龙门', '县', 4, 'lm', 'longmen', 'null', '516800'),
(1708, '001019009001', '城区', '001019009', 221, '中国/广东/汕尾/城区', 'null', 4, 'c', 'cheng', 'null', '516601'),
(1709, '001019009002', '陆丰', '001019009', 221, '中国/广东/汕尾/陆丰', '市', 4, 'lf', 'lufeng', 'null', '516500'),
(1710, '001019009003', '海丰', '001019009', 221, '中国/广东/汕尾/海丰', '县', 4, 'hf', 'haifeng', 'null', '516400'),
(1711, '001019009004', '陆河', '001019009', 221, '中国/广东/汕尾/陆河', '县', 4, 'lh', 'luhe', 'null', '516700'),
(1712, '001019012001', '江海', '001019012', 224, '中国/广东/江门/江海', '区', 4, 'jh', 'jianghai', 'null', '529000'),
(1713, '001019012002', '蓬江', '001019012', 224, '中国/广东/江门/蓬江', '区', 4, 'pj', 'pengjiang', 'null', '529051'),
(1714, '001019012003', '新会', '001019012', 224, '中国/广东/江门/新会', '区', 4, 'xh', 'xinhui', 'null', '529100'),
(1715, '001019012004', '恩平', '001019012', 224, '中国/广东/江门/恩平', '市', 4, 'ep', 'enping', 'null', '529411'),
(1716, '001019012005', '台山', '001019012', 224, '中国/广东/江门/台山', '市', 4, 'ts', 'taishan', 'null', '529200'),
(1717, '001019012006', '开平', '001019012', 224, '中国/广东/江门/开平', '市', 4, 'kp', 'kaiping', 'null', '529312'),
(1718, '001019012007', '鹤山', '001019012', 224, '中国/广东/江门/鹤山', '市', 4, 'hs', 'heshan', 'null', '529711'),
(1719, '001019013001', '禅城', '001019013', 225, '中国/广东/佛山/禅城', '区', 4, 'c', 'cheng', 'null', '528000'),
(1720, '001019013002', '高明', '001019013', 225, '中国/广东/佛山/高明', '区', 4, 'gm', 'gaoming', 'null', '528500'),
(1721, '001019013003', '顺德', '001019013', 225, '中国/广东/佛山/顺德', '区', 4, 'sd', 'shunde', 'null', '528300'),
(1722, '001019013004', '南海', '001019013', 225, '中国/广东/佛山/南海', '区', 4, 'nh', 'nanhai', 'null', '528200'),
(1723, '001019013005', '三水', '001019013', 225, '中国/广东/佛山/三水', '区', 4, 'ss', 'sanshui', 'null', '528100'),
(1724, '001019014001', '江城', '001019014', 226, '中国/广东/阳江/江城', '区', 4, 'jc', 'jiangcheng', 'null', '529525'),
(1725, '001019014002', '阳春', '001019014', 226, '中国/广东/阳江/阳春', '市', 4, 'yc', 'yangchun', 'null', '529611'),
(1726, '001019014003', '阳西', '001019014', 226, '中国/广东/阳江/阳西', '县', 4, 'yx', 'yangxi', 'null', '529800'),
(1727, '001019014004', '阳东', '001019014', 226, '中国/广东/阳江/阳东', '县', 4, 'yd', 'yangdong', 'null', '529931'),
(1728, '001019015001', '赤坎', '001019015', 227, '中国/广东/湛江/赤坎', '区', 4, 'ck', 'chikan', 'null', '524033'),
(1729, '001019015002', '霞山', '001019015', 227, '中国/广东/湛江/霞山', '区', 4, 'xs', 'xiashan', 'null', '524002'),
(1730, '001019015003', '坡头', '001019015', 227, '中国/广东/湛江/坡头', '区', 4, 'pt', 'potou', 'null', '524057'),
(1731, '001019015004', '麻章', '001019015', 227, '中国/广东/湛江/麻章', '区', 4, 'mz', 'mazhang', 'null', '524003'),
(1732, '001019015005', '吴川', '001019015', 227, '中国/广东/湛江/吴川', '市', 4, 'wc', 'wuchuan', 'null', '524500'),
(1733, '001019015006', '廉江', '001019015', 227, '中国/广东/湛江/廉江', '市', 4, 'lj', 'lianjiang', 'null', '524400'),
(1734, '001019015007', '雷州', '001019015', 227, '中国/广东/湛江/雷州', '市', 4, 'lz', 'leizhou', 'null', '524200'),
(1735, '001019015008', '遂溪', '001019015', 227, '中国/广东/湛江/遂溪', '县', 4, 'sx', 'suixi', 'null', '524300'),
(1736, '001019015009', '徐闻', '001019015', 227, '中国/广东/湛江/徐闻', '县', 4, 'xw', 'xuwen', 'null', '524100'),
(1737, '001019016001', '茂南', '001019016', 228, '中国/广东/茂名/茂南', '区', 4, 'mn', 'maonan', 'null', '525011'),
(1738, '001019016002', '茂港', '001019016', 228, '中国/广东/茂名/茂港', '区', 4, 'mg', 'maogang', 'null', '525011'),
(1739, '001019016003', '化州', '001019016', 228, '中国/广东/茂名/化州', '市', 4, 'hz', 'huazhou', 'null', '525100'),
(1740, '001019016004', '信宜', '001019016', 228, '中国/广东/茂名/信宜', '市', 4, 'xy', 'xinyi', 'null', '525300'),
(1741, '001019016005', '高州', '001019016', 228, '中国/广东/茂名/高州', '市', 4, 'gz', 'gaozhou', 'null', '525200'),
(1742, '001019016006', '电白', '001019016', 228, '中国/广东/茂名/电白', '县', 4, 'db', 'dianbai', 'null', '525400'),
(1743, '001019017001', '端州', '001019017', 229, '中国/广东/肇庆/端州', '区', 4, 'dz', 'duanzhou', 'null', '526040'),
(1744, '001019017002', '鼎湖', '001019017', 229, '中国/广东/肇庆/鼎湖', '区', 4, 'dh', 'dinghu', 'null', '526070'),
(1745, '001019017003', '高要', '001019017', 229, '中国/广东/肇庆/高要', '市', 4, 'gy', 'gaoyao', 'null', '526100'),
(1746, '001019017004', '四会', '001019017', 229, '中国/广东/肇庆/四会', '市', 4, 'sh', 'sihui', 'null', '526200'),
(1747, '001019017005', '广宁', '001019017', 229, '中国/广东/肇庆/广宁', '县', 4, 'gn', 'guangning', 'null', '526300'),
(1748, '001019017006', '怀集', '001019017', 229, '中国/广东/肇庆/怀集', '县', 4, 'hj', 'huaiji', 'null', '526400'),
(1749, '001019017007', '封开', '001019017', 229, '中国/广东/肇庆/封开', '县', 4, 'fk', 'fengkai', 'null', '526500'),
(1750, '001019017008', '德庆', '001019017', 229, '中国/广东/肇庆/德庆', '县', 4, 'dq', 'deqing', 'null', '526600'),
(1751, '001019018001', '清城', '001019018', 230, '中国/广东/清远/清城', '区', 4, 'qc', 'qingcheng', 'null', '511500'),
(1752, '001019018002', '英德', '001019018', 230, '中国/广东/清远/英德', '市', 4, 'yd', 'yingde', 'null', '513000'),
(1753, '001019018003', '连州', '001019018', 230, '中国/广东/清远/连州', '市', 4, 'lz', 'lianzhou', 'null', '513401'),
(1754, '001019018004', '佛冈', '001019018', 230, '中国/广东/清远/佛冈', '县', 4, 'fg', 'fogang', 'null', '511600'),
(1755, '001019018005', '阳山', '001019018', 230, '中国/广东/清远/阳山', '县', 4, 'ys', 'yangshan', 'null', '513100'),
(1756, '001019018006', '清新', '001019018', 230, '中国/广东/清远/清新', '县', 4, 'qx', 'qingxin', 'null', '511800'),
(1757, '001019018007', '连山', '001019018', 230, '中国/广东/清远/连山', '壮族瑶族自治县', 4, 'lsyzzz', 'lianshanyao', 'null', '513200'),
(1758, '001019018008', '连南', '001019018', 230, '中国/广东/清远/连南', '瑶族自治县', 4, 'lnyzzz', 'liannanyaoz', 'null', '513300'),
(1759, '001019019001', '湘桥', '001019019', 231, '中国/广东/潮州/湘桥', '区', 4, 'xq', 'xiangqiao', 'null', '521000'),
(1760, '001019019002', '潮安', '001019019', 231, '中国/广东/潮州/潮安', '县', 4, 'ca', 'chaoan', 'null', '515638'),
(1761, '001019019003', '饶平', '001019019', 231, '中国/广东/潮州/饶平', '县', 4, 'rp', 'raoping', 'null', '515700'),
(1762, '001019020001', '榕城', '001019020', 232, '中国/广东/揭阳/榕城', '区', 4, 'c', 'cheng', 'null', '522095'),
(1763, '001019020002', '普宁', '001019020', 232, '中国/广东/揭阳/普宁', '市', 4, 'pn', 'puning', 'null', '515300'),
(1764, '001019020003', '揭东', '001019020', 232, '中国/广东/揭阳/揭东', '县', 4, 'jd', 'jiedong', 'null', '515554'),
(1765, '001019020004', '揭西', '001019020', 232, '中国/广东/揭阳/揭西', '县', 4, 'jx', 'jiexi', 'null', '515400'),
(1766, '001019020005', '惠来', '001019020', 232, '中国/广东/揭阳/惠来', '县', 4, 'hl', 'huilai', 'null', '515200'),
(1767, '001019021001', '云城', '001019021', 233, '中国/广东/云浮/云城', '区', 4, 'yc', 'yuncheng', 'null', '527300'),
(1768, '001019021002', '罗定', '001019021', 233, '中国/广东/云浮/罗定', '市', 4, 'ld', 'luoding', 'null', '527200'),
(1769, '001019021003', '云安', '001019021', 233, '中国/广东/云浮/云安', '县', 4, 'ya', 'yunan', 'null', '527500'),
(1770, '001019021004', '新兴', '001019021', 233, '中国/广东/云浮/新兴', '县', 4, 'xx', 'xinxing', 'null', '527400'),
(1771, '001019021005', '郁南', '001019021', 233, '中国/广东/云浮/郁南', '县', 4, 'yn', 'yunan', 'null', '527100'),
(1772, '001020001001', '新城', '001020001', 234, '中国/广西/南宁/新城', '区', 4, 'xc', 'xincheng', 'null', '530022'),
(1773, '001020001002', '兴宁', '001020001', 234, '中国/广西/南宁/兴宁', '区', 4, 'xn', 'xingning', 'null', '530012'),
(1774, '001020001003', '城北', '001020001', 234, '中国/广西/南宁/城北', '区', 4, 'cb', 'chengbei', 'null', '530001'),
(1775, '001020001004', '江南', '001020001', 234, '中国/广西/南宁/江南', '区', 4, 'jn', 'jiangnan', 'null', '530031'),
(1776, '001020001005', '永新', '001020001', 234, '中国/广西/南宁/永新', '区', 4, 'yx', 'yongxin', 'null', '530012'),
(1777, '001020001006', '邕宁', '001020001', 234, '中国/广西/南宁/邕宁', '县', 4, 'n', 'ning', 'null', '530200'),
(1778, '001020001007', '武鸣', '001020001', 234, '中国/广西/南宁/武鸣', '县', 4, 'wm', 'wuming', 'null', '530100'),
(1779, '001020001008', '宾阳', '001020001', 234, '中国/广西/南宁/宾阳', '县', 4, 'by', 'binyang', 'null', '530400'),
(1780, '001020001009', '上林', '001020001', 234, '中国/广西/南宁/上林', '县', 4, 'sl', 'shanglin', 'null', '530500'),
(1781, '001020001010', '马山', '001020001', 234, '中国/广西/南宁/马山', '县', 4, 'ms', 'mashan', 'null', '530600'),
(1782, '001020002001', '城中', '001020002', 235, '中国/广西/柳州/城中', '区', 4, 'cz', 'chengzhong', 'null', '545001'),
(1783, '001020002002', '鱼峰', '001020002', 235, '中国/广西/柳州/鱼峰', '区', 4, 'yf', 'yufeng', 'null', '545005'),
(1784, '001020002003', '柳南', '001020002', 235, '中国/广西/柳州/柳南', '区', 4, 'ln', 'liunan', 'null', '545005'),
(1785, '001020002004', '柳北', '001020002', 235, '中国/广西/柳州/柳北', '区', 4, 'lb', 'liubei', 'null', '545001'),
(1786, '001020002005', '柳江', '001020002', 235, '中国/广西/柳州/柳江', '县', 4, 'lj', 'liujiang', 'null', '545100'),
(1787, '001020002006', '柳城', '001020002', 235, '中国/广西/柳州/柳城', '县', 4, 'lc', 'liucheng', 'null', '545200'),
(1788, '001020002007', '鹿寨', '001020002', 235, '中国/广西/柳州/鹿寨', '县', 4, 'lz', 'luzhai', 'null', '545600'),
(1789, '001020002008', '融安', '001020002', 235, '中国/广西/柳州/融安', '县', 4, 'ra', 'rongan', 'null', '545400'),
(1790, '001020002009', '融水', '001020002', 235, '中国/广西/柳州/融水', '苗族自治县', 4, 'rsmzzz', 'rongshuimia', 'null', '545300'),
(1791, '001020002010', '三江', '001020002', 235, '中国/广西/柳州/三江', '侗族自治县', 4, 'sjdzzz', 'sanjiangdon', 'null', '545500'),
(1792, '001020003001', '秀峰', '001020003', 236, '中国/广西/桂林/秀峰', '区', 4, 'xf', 'xiufeng', 'null', '541001'),
(1793, '001020003002', '叠彩', '001020003', 236, '中国/广西/桂林/叠彩', '区', 4, 'dc', 'diecai', 'null', '541001'),
(1794, '001020003003', '象山', '001020003', 236, '中国/广西/桂林/象山', '区', 4, 'xs', 'xiangshan', 'null', '541002'),
(1795, '001020003004', '七星', '001020003', 236, '中国/广西/桂林/七星', '区', 4, 'qx', 'qixing', 'null', '541004'),
(1796, '001020003005', '雁山', '001020003', 236, '中国/广西/桂林/雁山', '区', 4, 'ys', 'yanshan', 'null', '541006'),
(1797, '001020003006', '阳朔', '001020003', 236, '中国/广西/桂林/阳朔', '县', 4, 'ys', 'yangshuo', 'null', '541900'),
(1798, '001020003007', '临桂', '001020003', 236, '中国/广西/桂林/临桂', '县', 4, 'lg', 'lingui', 'null', '541100'),
(1799, '001020003008', '灵川', '001020003', 236, '中国/广西/桂林/灵川', '县', 4, 'lc', 'lingchuan', 'null', '541200'),
(1800, '001020003009', '全州', '001020003', 236, '中国/广西/桂林/全州', '县', 4, 'qz', 'quanzhou', 'null', '541500'),
(1801, '001020003010', '兴安', '001020003', 236, '中国/广西/桂林/兴安', '县', 4, 'xa', 'xingan', 'null', '541300'),
(1802, '001020003011', '永福', '001020003', 236, '中国/广西/桂林/永福', '县', 4, 'yf', 'yongfu', 'null', '541800'),
(1803, '001020003012', '灌阳', '001020003', 236, '中国/广西/桂林/灌阳', '县', 4, 'gy', 'guanyang', 'null', '541600'),
(1804, '001020003013', '资源', '001020003', 236, '中国/广西/桂林/资源', '县', 4, 'zy', 'ziyuan', 'null', '541400'),
(1805, '001020003014', '平乐', '001020003', 236, '中国/广西/桂林/平乐', '县', 4, 'pl', 'pingle', 'null', '542400'),
(1806, '001020003015', '荔浦', '001020003', 236, '中国/广西/桂林/荔浦', '县', 4, 'lp', 'lipu', 'null', '546600'),
(1807, '001020003016', '龙胜', '001020003', 236, '中国/广西/桂林/龙胜', '各族自治县', 4, 'lsgzzz', 'longshengge', 'null', '541700'),
(1808, '001020003017', '恭城', '001020003', 236, '中国/广西/桂林/恭城', '瑶族自治县', 4, 'gcyzzz', 'gongchengya', 'null', '542500'),
(1809, '001020004001', '万秀', '001020004', 237, '中国/广西/梧州/万秀', '区', 4, 'wx', 'wanxiu', 'null', '543000'),
(1810, '001020004002', '蝶山', '001020004', 237, '中国/广西/梧州/蝶山', '区', 4, 'ds', 'dieshan', 'null', '543002'),
(1811, '001020004003', '市郊', '001020004', 237, '中国/广西/梧州/市郊', '区', 4, 'j', 'jiao', 'null', '543002'),
(1812, '001020004004', '岑溪', '001020004', 237, '中国/广西/梧州/岑溪', '市', 4, 'x', 'xi', 'null', '543200'),
(1813, '001020004005', '苍梧', '001020004', 237, '中国/广西/梧州/苍梧', '县', 4, 'cw', 'cangwu', 'null', '543100'),
(1814, '001020004006', '藤县', '001020004', 237, '中国/广西/梧州/藤县', 'null', 4, 't', 'teng', 'null', '543300'),
(1815, '001020004007', '蒙山', '001020004', 237, '中国/广西/梧州/蒙山', '县', 4, 'ms', 'mengshan', 'null', '546700'),
(1816, '001020005001', '海城', '001020005', 238, '中国/广西/北海/海城', '区', 4, 'hc', 'haicheng', 'null', '536000'),
(1817, '001020005002', '银海', '001020005', 238, '中国/广西/北海/银海', '区', 4, 'yh', 'yinhai', 'null', '536000'),
(1818, '001020005003', '铁山港', '001020005', 238, '中国/广西/北海/铁山港', '区', 4, 'tsg', 'tieshangang', 'null', '536017'),
(1819, '001020005004', '合浦', '001020005', 238, '中国/广西/北海/合浦', '县', 4, 'hp', 'hepu', 'null', '536100'),
(1820, '001020006001', '港口', '001020006', 239, '中国/广西/防城港/港口', '区', 4, 'gk', 'gangkou', 'null', '538001'),
(1821, '001020006002', '防城', '001020006', 239, '中国/广西/防城港/防城', '区', 4, 'fc', 'fangcheng', 'null', '538021'),
(1822, '001020006003', '东兴', '001020006', 239, '中国/广西/防城港/东兴', '市', 4, 'dx', 'dongxing', 'null', '538100'),
(1823, '001020006004', '上思', '001020006', 239, '中国/广西/防城港/上思', '县', 4, 'ss', 'shangsi', 'null', '535500'),
(1824, '001020007001', '钦南', '001020007', 240, '中国/广西/钦州/钦南', '区', 4, 'qn', 'qinnan', 'null', '535000'),
(1825, '001020007002', '钦北', '001020007', 240, '中国/广西/钦州/钦北', '区', 4, 'qb', 'qinbei', 'null', '535000'),
(1826, '001020007003', '灵山', '001020007', 240, '中国/广西/钦州/灵山', '县', 4, 'ls', 'lingshan', 'null', '535400'),
(1827, '001020007004', '浦北', '001020007', 240, '中国/广西/钦州/浦北', '县', 4, 'pb', 'pubei', 'null', '535300'),
(1828, '001020008001', '港北', '001020008', 241, '中国/广西/贵港/港北', '区', 4, 'gb', 'gangbei', 'null', '537100'),
(1829, '001020008002', '港南', '001020008', 241, '中国/广西/贵港/港南', '区', 4, 'gn', 'gangnan', 'null', '537130'),
(1830, '001020008003', '桂平', '001020008', 241, '中国/广西/贵港/桂平', '市', 4, 'gp', 'guiping', 'null', '537200'),
(1831, '001020008004', '平南', '001020008', 241, '中国/广西/贵港/平南', '县', 4, 'pn', 'pingnan', 'null', '537300'),
(1832, '001020009001', '北流', '001020009', 242, '中国/广西/玉林/北流', '市', 4, 'bl', 'beiliu', 'null', '537400'),
(1833, '001020009002', '兴业', '001020009', 242, '中国/广西/玉林/兴业', '县', 4, 'xy', 'xingye', 'null', '537800'),
(1834, '001020009003', '容县', '001020009', 242, '中国/广西/玉林/容县', 'null', 4, 'r', 'rong', 'null', '537500'),
(1835, '001020009004', '陆川', '001020009', 242, '中国/广西/玉林/陆川', '县', 4, 'lc', 'luchuan', 'null', '537700'),
(1836, '001020009005', '博白', '001020009', 242, '中国/广西/玉林/博白', '县', 4, 'bb', 'bobai', 'null', '537600'),
(1837, '001020010001', '田阳', '001020010', 243, '中国/广西/百色/田阳', '县', 4, 'ty', 'tianyang', 'null', '533600'),
(1838, '001020010002', '田东', '001020010', 243, '中国/广西/百色/田东', '县', 4, 'td', 'tiandong', 'null', '531500'),
(1839, '001020010003', '平果', '001020010', 243, '中国/广西/百色/平果', '县', 4, 'pg', 'pingguo', 'null', '531400'),
(1840, '001020010004', '德保', '001020010', 243, '中国/广西/百色/德保', '县', 4, 'db', 'debao', 'null', '533700'),
(1841, '001020010005', '靖西', '001020010', 243, '中国/广西/百色/靖西', '县', 4, 'jx', 'jingxi', 'null', '533800'),
(1842, '001020010006', '那坡', '001020010', 243, '中国/广西/百色/那坡', '县', 4, 'np', 'napo', 'null', '533900'),
(1843, '001020010007', '凌云', '001020010', 243, '中国/广西/百色/凌云', '县', 4, 'ly', 'lingyun', 'null', '533100'),
(1844, '001020010008', '乐业', '001020010', 243, '中国/广西/百色/乐业', '县', 4, 'ly', 'leye', 'null', '533200'),
(1845, '001020010009', '西林', '001020010', 243, '中国/广西/百色/西林', '县', 4, 'xl', 'xilin', 'null', '533500'),
(1846, '001020010010', '田林', '001020010', 243, '中国/广西/百色/田林', '县', 4, 'tl', 'tianlin', 'null', '533300'),
(1847, '001020010011', '隆林', '001020010', 243, '中国/广西/百色/隆林', '各族自治县', 4, 'llgzzz', 'longlingezu', 'null', '533500'),
(1848, '001020011001', '八步', '001020011', 244, '中国/广西/贺州/八步', '区', 4, 'bb', 'babu', 'null', '542800'),
(1849, '001020011002', '昭平', '001020011', 244, '中国/广西/贺州/昭平', '县', 4, 'zp', 'zhaoping', 'null', '546800'),
(1850, '001020011003', '钟山', '001020011', 244, '中国/广西/贺州/钟山', '县', 4, 'zs', 'zhongshan', 'null', '542600'),
(1851, '001020011004', '富川', '001020011', 244, '中国/广西/贺州/富川', '瑶族自治县', 4, 'fcyzzz', 'fuchuanyaoz', 'null', '542700'),
(1852, '001020012001', '金城江', '001020012', 245, '中国/广西/河池/金城江', '区', 4, 'jcj', 'jinchengjia', 'null', '547000'),
(1853, '001020012002', '宜州', '001020012', 245, '中国/广西/河池/宜州', '市', 4, 'yz', 'yizhou', 'null', '546300'),
(1854, '001020012003', '南丹', '001020012', 245, '中国/广西/河池/南丹', '县', 4, 'nd', 'nandan', 'null', '547200'),
(1855, '001020012004', '天峨', '001020012', 245, '中国/广西/河池/天峨', '县', 4, 'te', 'tiane', 'null', '547300'),
(1856, '001020012005', '凤山', '001020012', 245, '中国/广西/河池/凤山', '县', 4, 'fs', 'fengshan', 'null', '547600'),
(1857, '001020012006', '东兰', '001020012', 245, '中国/广西/河池/东兰', '县', 4, 'dl', 'donglan', 'null', '547400'),
(1858, '001020012007', '巴马', '001020012', 245, '中国/广西/河池/巴马', '瑶族自治县', 4, 'bmyzzz', 'bamayaozuzi', 'null', '547500'),
(1859, '001020012008', '都安', '001020012', 245, '中国/广西/河池/都安', '瑶族自治县', 4, 'dayzzz', 'duanyaozuzi', 'null', '530700'),
(1860, '001020012009', '大化', '001020012', 245, '中国/广西/河池/大化', '瑶族自治县', 4, 'dhyzzz', 'dahuayaozuz', 'null', '530800'),
(1861, '001020012010', '罗城', '001020012', 245, '中国/广西/河池/罗城', '仫佬族自治县', 4, 'lclzzz', 'luochenglao', 'null', '546400'),
(1862, '001020012011', '环江', '001020012', 245, '中国/广西/河池/环江', '毛南族自治县', 4, 'hjmnzzz', 'huanjiangma', 'null', '547100'),
(1863, '001020013001', '兴宾', '001020013', 246, '中国/广西/来宾/兴宾', '区', 4, 'xb', 'xingbin', 'null', '546100'),
(1864, '001020013002', '合山', '001020013', 246, '中国/广西/来宾/合山', '市', 4, 'hs', 'heshan', 'null', '546500'),
(1865, '001020013003', '象州', '001020013', 246, '中国/广西/来宾/象州', '县', 4, 'xz', 'xiangzhou', 'null', '545800'),
(1866, '001020013004', '武宣', '001020013', 246, '中国/广西/来宾/武宣', '县', 4, 'wx', 'wuxuan', 'null', '545900'),
(1867, '001020013005', '忻城', '001020013', 246, '中国/广西/来宾/忻城', '县', 4, 'xc', 'xincheng', 'null', '546200'),
(1868, '001020013006', '金秀', '001020013', 246, '中国/广西/来宾/金秀', '瑶族自治县', 4, 'jxyzzz', 'jinxiuyaozu', 'null', '545700'),
(1869, '001020014001', '凭祥', '001020014', 247, '中国/广西/崇左/凭祥', '市', 4, 'px', 'pingxiang', 'null', '532600'),
(1870, '001020014002', '扶绥', '001020014', 247, '中国/广西/崇左/扶绥', '县', 4, 'fs', 'fusui', 'null', '532100'),
(1871, '001020014003', '大新', '001020014', 247, '中国/广西/崇左/大新', '县', 4, 'dx', 'daxin', 'null', '532300'),
(1872, '001020014004', '天等', '001020014', 247, '中国/广西/崇左/天等', '县', 4, 'td', 'tiandeng', 'null', '532800'),
(1873, '001020014005', '宁明', '001020014', 247, '中国/广西/崇左/宁明', '县', 4, 'nm', 'ningming', 'null', '532500'),
(1874, '001020014006', '龙州', '001020014', 247, '中国/广西/崇左/龙州', '县', 4, 'lz', 'longzhou', 'null', '532400'),
(1875, '001021001001', '秀英', '001021001', 248, '中国/海南/海口/秀英', '区', 4, 'xy', 'xiuying', 'null', '570102'),
(1876, '001021001002', '新华', '001021001', 248, '中国/海南/海口/新华', '区', 4, 'xh', 'xinhua', 'null', '570206'),
(1877, '001021001003', '振东', '001021001', 248, '中国/海南/海口/振东', '区', 4, 'zd', 'zhendong', 'null', '570203'),
(1878, '001021001004', '秀英', '001021001', 248, '中国/海南/海口/秀英', '区', 4, 'xy', 'xiuying', 'null', '570311'),
(1879, '001021001005', '琼山', '001021001', 248, '中国/海南/海口/琼山', '市', 4, 'qs', 'qiongshan', 'null', '571100'),
(1880, '001021003001', '澄迈', '001021003', 250, '中国/海南/省直辖行政单位/澄迈', '县', 4, 'cm', 'chengmai', 'null', '571900'),
(1881, '001021003002', '定安', '001021003', 250, '中国/海南/省直辖行政单位/定安', '县', 4, 'da', 'dingan', 'null', '571200'),
(1882, '001021003003', '屯昌', '001021003', 250, '中国/海南/省直辖行政单位/屯昌', '县', 4, 'tc', 'tunchang', 'null', '571600'),
(1883, '001021003004', '昌江', '001021003', 250, '中国/海南/省直辖行政单位/昌江', '黎族自治县', 4, 'cjlzzz', 'changjiangl', 'null', '572700'),
(1884, '001021003005', '白沙', '001021003', 250, '中国/海南/省直辖行政单位/白沙', '黎族自治县', 4, 'bslzzz', 'baishalizuz', 'null', '572800'),
(1885, '001021003006', '琼中', '001021003', 250, '中国/海南/省直辖行政单位/琼中', '黎族苗族自治县', 4, 'qzlzmzzz', 'qiongzhongl', 'null', '572900'),
(1886, '001021003007', '陵水', '001021003', 250, '中国/海南/省直辖行政单位/陵水', '黎族自治县', 4, 'lslzzz', 'lingshuiliz', 'null', '572400'),
(1887, '001021003008', '保亭', '001021003', 250, '中国/海南/省直辖行政单位/保亭', '黎族苗族自治县', 4, 'btlzmzzz', 'baotinglizu', 'null', '572300'),
(1888, '001021003009', '乐东', '001021003', 250, '中国/海南/省直辖行政单位/乐东', '黎族自治县', 4, 'ldlzzz', 'ledonglizuz', 'null', '572500'),
(1889, '001023001001', '青羊', '001023001', 251, '中国/四川/成都/青羊', '区', 4, 'qy', 'qingyang', 'null', '610031'),
(1890, '001023001002', '锦江', '001023001', 251, '中国/四川/成都/锦江', '区', 4, 'jj', 'jinjiang', 'null', '610011'),
(1891, '001023001003', '金牛', '001023001', 251, '中国/四川/成都/金牛', '区', 4, 'jn', 'jinniu', 'null', '610036'),
(1892, '001023001004', '武侯', '001023001', 251, '中国/四川/成都/武侯', '区', 4, 'wh', 'wuhou', 'null', '610041'),
(1893, '001023001005', '成华', '001023001', 251, '中国/四川/成都/成华', '区', 4, 'ch', 'chenghua', 'null', '610051'),
(1894, '001023001006', '龙泉驿', '001023001', 251, '中国/四川/成都/龙泉驿', '区', 4, 'lq', 'longquan', 'null', '610100'),
(1895, '001023001007', '青白江', '001023001', 251, '中国/四川/成都/青白江', '区', 4, 'qbj', 'qingbaijian', 'null', '610300'),
(1896, '001023001008', '新都', '001023001', 251, '中国/四川/成都/新都', '区', 4, 'xd', 'xindu', 'null', '610500'),
(1897, '001023001009', '温江', '001023001', 251, '中国/四川/成都/温江', '区', 4, 'wj', 'wenjiang', 'null', '611130'),
(1898, '001023001010', '崇州', '001023001', 251, '中国/四川/成都/崇州', '市', 4, 'cz', 'chongzhou', 'null', '611230'),
(1899, '001023001011', '邛崃', '001023001', 251, '中国/四川/成都/邛崃', '市', 4, 'null', 'null', 'null', '611530'),
(1900, '001023001012', '都江堰', '001023001', 251, '中国/四川/成都/都江堰', '市', 4, 'djy', 'dujiangyan', 'null', '611830'),
(1901, '001023001013', '金堂', '001023001', 251, '中国/四川/成都/金堂', '县', 4, 'jt', 'jintang', 'null', '610400'),
(1902, '001023001014', '双流', '001023001', 251, '中国/四川/成都/双流', '县', 4, 'sl', 'shuangliu', 'null', '610200'),
(1903, '001023001015', '郫县', '001023001', 251, '中国/四川/成都/郫县', 'null', 4, 'null', 'null', 'null', '611730'),
(1904, '001023001016', '大邑', '001023001', 251, '中国/四川/成都/大邑', '县', 4, 'dy', 'dayi', 'null', '611330'),
(1905, '001023001017', '蒲江', '001023001', 251, '中国/四川/成都/蒲江', '县', 4, 'pj', 'pujiang', 'null', '611630'),
(1906, '001023001018', '新津', '001023001', 251, '中国/四川/成都/新津', '县', 4, 'xj', 'xinjin', 'null', '611430'),
(1907, '001023002001', '大安', '001023002', 252, '中国/四川/自贡/大安', '区', 4, 'da', 'daan', 'null', '643010'),
(1908, '001023002002', '贡井', '001023002', 252, '中国/四川/自贡/贡井', '区', 4, 'gj', 'gongjing', 'null', '643020'),
(1909, '001023002003', '自流井', '001023002', 252, '中国/四川/自贡/自流井', '区', 4, 'zlj', 'ziliujing', 'null', '643000'),
(1910, '001023002004', '沿滩', '001023002', 252, '中国/四川/自贡/沿滩', '区', 4, 'yt', 'yantan', 'null', '643030'),
(1911, '001023002005', '荣县', '001023002', 252, '中国/四川/自贡/荣县', 'null', 4, 'r', 'rong', 'null', '643100'),
(1912, '001023002006', '富顺', '001023002', 252, '中国/四川/自贡/富顺', '县', 4, 'fs', 'fushun', 'null', '643200'),
(1913, '001023003001', '东区', '001023003', 253, '中国/四川/攀枝花/东区', 'null', 4, 'd', 'dong', 'null', '617067'),
(1914, '001023003002', '西区', '001023003', 253, '中国/四川/攀枝花/西区', 'null', 4, 'x', 'xi', 'null', '617012'),
(1915, '001023003003', '仁和', '001023003', 253, '中国/四川/攀枝花/仁和', '区', 4, 'rh', 'renhe', 'null', '617061'),
(1916, '001023003004', '米易', '001023003', 253, '中国/四川/攀枝花/米易', '县', 4, 'my', 'miyi', 'null', '617200'),
(1917, '001023003005', '盐边', '001023003', 253, '中国/四川/攀枝花/盐边', '县', 4, 'yb', 'yanbian', 'null', '617100'),
(1918, '001023004001', '江阳', '001023004', 254, '中国/四川/泸州/江阳', '区', 4, 'jy', 'jiangyang', 'null', '646000'),
(1919, '001023004002', '纳溪', '001023004', 254, '中国/四川/泸州/纳溪', '区', 4, 'nx', 'naxi', 'null', '646300'),
(1920, '001023004003', '龙马潭', '001023004', 254, '中国/四川/泸州/龙马潭', '区', 4, 'lmt', 'longmatan', 'null', '646000'),
(1921, '001023004004', '泸县', '001023004', 254, '中国/四川/泸州/泸县', 'null', 4, 'null', 'null', 'null', '646106'),
(1922, '001023004005', '合江', '001023004', 254, '中国/四川/泸州/合江', '县', 4, 'hj', 'hejiang', 'null', '646200'),
(1923, '001023004006', '叙永', '001023004', 254, '中国/四川/泸州/叙永', '县', 4, 'xy', 'xuyong', 'null', '646400'),
(1924, '001023004007', '古蔺', '001023004', 254, '中国/四川/泸州/古蔺', '县', 4, 'g', 'gu', 'null', '646500'),
(1925, '001023005001', '旌阳', '001023005', 255, '中国/四川/德阳/旌阳', '区', 4, 'y', 'yang', 'null', '618000'),
(1926, '001023005002', '什邡', '001023005', 255, '中国/四川/德阳/什邡', '市', 4, 's', 'shi', 'null', '618400'),
(1927, '001023005003', '广汉', '001023005', 255, '中国/四川/德阳/广汉', '市', 4, 'gh', 'guanghan', 'null', '618300'),
(1928, '001023005004', '绵竹', '001023005', 255, '中国/四川/德阳/绵竹', '市', 4, 'mz', 'mianzhu', 'null', '618200'),
(1929, '001023005005', '罗江', '001023005', 255, '中国/四川/德阳/罗江', '县', 4, 'lj', 'luojiang', 'null', '618500'),
(1930, '001023005006', '中江', '001023005', 255, '中国/四川/德阳/中江', '县', 4, 'zj', 'zhongjiang', 'null', '618300'),
(1931, '001023006001', '涪城', '001023006', 256, '中国/四川/绵阳/涪城', '区', 4, 'fc', 'fucheng', 'null', '621000'),
(1932, '001023006002', '游仙', '001023006', 256, '中国/四川/绵阳/游仙', '区', 4, 'yx', 'youxian', 'null', '621022'),
(1933, '001023006003', '江油', '001023006', 256, '中国/四川/绵阳/江油', '市', 4, 'jy', 'jiangyou', 'null', '621700'),
(1934, '001023006004', '三台', '001023006', 256, '中国/四川/绵阳/三台', '县', 4, 'st', 'santai', 'null', '621100'),
(1935, '001023006005', '盐亭', '001023006', 256, '中国/四川/绵阳/盐亭', '县', 4, 'yt', 'yanting', 'null', '621600'),
(1936, '001023006006', '安县', '001023006', 256, '中国/四川/绵阳/安县', 'null', 4, 'a', 'an', 'null', '622650'),
(1937, '001023006007', '梓潼', '001023006', 256, '中国/四川/绵阳/梓潼', '县', 4, 'null', 'null', 'null', '622150'),
(1938, '001023006008', '北川', '001023006', 256, '中国/四川/绵阳/北川', '县', 4, 'bc', 'beichuan', 'null', '622750'),
(1939, '001023006009', '平武', '001023006', 256, '中国/四川/绵阳/平武', '县', 4, 'pw', 'pingwu', 'null', '622550'),
(1940, '001023007001', '市中', '001023007', 257, '中国/四川/广元/市中', '区', 4, 'z', 'zhong', 'null', '628017'),
(1941, '001023007002', '元坝', '001023007', 257, '中国/四川/广元/元坝', '区', 4, 'yb', 'yuanba', 'null', '628021'),
(1942, '001023007003', '朝天', '001023007', 257, '中国/四川/广元/朝天', '区', 4, 'ct', 'chaotian', 'null', '628012'),
(1943, '001023007004', '旺苍', '001023007', 257, '中国/四川/广元/旺苍', '县', 4, 'wc', 'wangcang', 'null', '628200'),
(1944, '001023007005', '青川', '001023007', 257, '中国/四川/广元/青川', '县', 4, 'qc', 'qingchuan', 'null', '628100'),
(1945, '001023007006', '剑阁', '001023007', 257, '中国/四川/广元/剑阁', '县', 4, 'jg', 'jiange', 'null', '628300'),
(1946, '001023007007', '苍溪', '001023007', 257, '中国/四川/广元/苍溪', '县', 4, 'cx', 'cangxi', 'null', '628400'),
(1947, '001023008001', '市中', '001023008', 258, '中国/四川/遂宁/市中', '区', 4, 'z', 'zhong', 'null', '629000'),
(1948, '001023008002', '蓬溪', '001023008', 258, '中国/四川/遂宁/蓬溪', '县', 4, 'px', 'pengxi', 'null', '629100'),
(1949, '001023008003', '射洪', '001023008', 258, '中国/四川/遂宁/射洪', '县', 4, 'sh', 'shehong', 'null', '629200'),
(1950, '001023008004', '大英', '001023008', 258, '中国/四川/遂宁/大英', '县', 4, 'dy', 'daying', 'null', '629300'),
(1951, '001023009001', '市中', '001023009', 259, '中国/四川/内江/市中', '区', 4, 'z', 'zhong', 'null', '641000'),
(1952, '001023009002', '东兴', '001023009', 259, '中国/四川/内江/东兴', '区', 4, 'dx', 'dongxing', 'null', '641100'),
(1953, '001023009003', '威远', '001023009', 259, '中国/四川/内江/威远', '县', 4, 'wy', 'weiyuan', 'null', '642450'),
(1954, '001023009004', '资中', '001023009', 259, '中国/四川/内江/资中', '县', 4, 'zz', 'zizhong', 'null', '641200');
INSERT INTO `des_district` (`serialId`, `districtId`, `districtName`, `districtUpId`, `districtUpIdNum`, `districtPath`, `districtType`, `districtTypeNum`, `shortName`, `spell`, `areaId`, `postCode`) VALUES
(1955, '001023009005', '隆昌', '001023009', 259, '中国/四川/内江/隆昌', '县', 4, 'lc', 'longchang', 'null', '642150'),
(1956, '001023010001', '市中', '001023010', 260, '中国/四川/乐山/市中', '区', 4, 'z', 'zhong', 'null', '614000'),
(1957, '001023010002', '沙湾', '001023010', 260, '中国/四川/乐山/沙湾', '区', 4, 'sw', 'shawan', 'null', '614900'),
(1958, '001023010003', '五通桥', '001023010', 260, '中国/四川/乐山/五通桥', '区', 4, 'wtq', 'wutongqiao', 'null', '614800'),
(1959, '001023010004', '金口河', '001023010', 260, '中国/四川/乐山/金口河', '区', 4, 'jkh', 'jinkouhe', 'null', '614700'),
(1960, '001023010005', '峨眉山', '001023010', 260, '中国/四川/乐山/峨眉山', '市', 4, 'ems', 'emeishan', 'null', '614200'),
(1961, '001023010006', '犍为', '001023010', 260, '中国/四川/乐山/犍为', '县', 4, 'w', 'wei', 'null', '614400'),
(1962, '001023010007', '井研', '001023010', 260, '中国/四川/乐山/井研', '县', 4, 'jy', 'jingyan', 'null', '613100'),
(1963, '001023010008', '夹江', '001023010', 260, '中国/四川/乐山/夹江', '县', 4, 'jj', 'jiajiang', 'null', '614100'),
(1964, '001023010009', '沐川', '001023010', 260, '中国/四川/乐山/沐川', '县', 4, 'c', 'chuan', 'null', '614500'),
(1965, '001023010010', '峨边', '001023010', 260, '中国/四川/乐山/峨边', '彝族自治县', 4, 'ebyzzz', 'ebianyizuzi', 'null', '614300'),
(1966, '001023010011', '马边', '001023010', 260, '中国/四川/乐山/马边', '彝族自治县', 4, 'mbyzzz', 'mabianyizuz', 'null', '614600'),
(1967, '001023011001', '顺庆', '001023011', 261, '中国/四川/南充/顺庆', '区', 4, 'sq', 'shunqing', 'null', '637000'),
(1968, '001023011002', '高坪', '001023011', 261, '中国/四川/南充/高坪', '区', 4, 'gp', 'gaoping', 'null', '637100'),
(1969, '001023011003', '嘉陵', '001023011', 261, '中国/四川/南充/嘉陵', '区', 4, 'jl', 'jialing', 'null', '637500'),
(1970, '001023011004', '阆中', '001023011', 261, '中国/四川/南充/阆中', '市', 4, 'z', 'zhong', 'null', '637400'),
(1971, '001023011005', '南部', '001023011', 261, '中国/四川/南充/南部', '县', 4, 'nb', 'nanbu', 'null', '637300'),
(1972, '001023011006', '营山', '001023011', 261, '中国/四川/南充/营山', '县', 4, 'ys', 'yingshan', 'null', '637700'),
(1973, '001023011007', '蓬安', '001023011', 261, '中国/四川/南充/蓬安', '县', 4, 'pa', 'pengan', 'null', '637800'),
(1974, '001023011008', '仪陇', '001023011', 261, '中国/四川/南充/仪陇', '县', 4, 'yl', 'yilong', 'null', '637600'),
(1975, '001023011009', '西充', '001023011', 261, '中国/四川/南充/西充', '县', 4, 'xc', 'xichong', 'null', '637200'),
(1976, '001023012001', '翠屏', '001023012', 262, '中国/四川/宜宾/翠屏', '区', 4, 'cp', 'cuiping', 'null', '644000'),
(1977, '001023012002', '宜宾', '001023012', 262, '中国/四川/宜宾/宜宾', '县', 4, 'yb', 'yibin', 'null', '644600'),
(1978, '001023012003', '南溪', '001023012', 262, '中国/四川/宜宾/南溪', '县', 4, 'nx', 'nanxi', 'null', '644100'),
(1979, '001023012004', '江安', '001023012', 262, '中国/四川/宜宾/江安', '县', 4, 'ja', 'jiangan', 'null', '644200'),
(1980, '001023012005', '长宁', '001023012', 262, '中国/四川/宜宾/长宁', '县', 4, 'cn', 'changning', 'null', '644300'),
(1981, '001023012006', '高县', '001023012', 262, '中国/四川/宜宾/高县', 'null', 4, 'g', 'gao', 'null', '645154'),
(1982, '001023012007', '筠连', '001023012', 262, '中国/四川/宜宾/筠连', '县', 4, 'l', 'lian', 'null', '645250'),
(1983, '001023012008', '珙县', '001023012', 262, '中国/四川/宜宾/珙县', 'null', 4, 'null', 'null', 'null', '644501'),
(1984, '001023012009', '兴文', '001023012', 262, '中国/四川/宜宾/兴文', '县', 4, 'xw', 'xingwen', 'null', '644400'),
(1985, '001023012010', '屏山', '001023012', 262, '中国/四川/宜宾/屏山', '县', 4, 'ps', 'pingshan', 'null', '645350'),
(1986, '001023013001', '广安', '001023013', 263, '中国/四川/广安/广安', '区', 4, 'ga', 'guangan', 'null', '638550'),
(1987, '001023013002', '华蓥', '001023013', 263, '中国/四川/广安/华蓥', '市', 4, 'h', 'hua', 'null', '638600'),
(1988, '001023013003', '岳池', '001023013', 263, '中国/四川/广安/岳池', '县', 4, 'yc', 'yuechi', 'null', '638300'),
(1989, '001023013004', '武胜', '001023013', 263, '中国/四川/广安/武胜', '县', 4, 'ws', 'wusheng', 'null', '638400'),
(1990, '001023013005', '邻水', '001023013', 263, '中国/四川/广安/邻水', '县', 4, 'ls', 'linshui', 'null', '638500'),
(1991, '001023014001', '通川', '001023014', 264, '中国/四川/达州/通川', '区', 4, 'tc', 'tongchuan', 'null', '635000'),
(1992, '001023014002', '万源', '001023014', 264, '中国/四川/达州/万源', '市', 4, 'wy', 'wanyuan', 'null', '636350'),
(1993, '001023014003', '达县', '001023014', 264, '中国/四川/达州/达县', 'null', 4, 'd', 'da', 'null', '635000'),
(1994, '001023014004', '宣汉', '001023014', 264, '中国/四川/达州/宣汉', '县', 4, 'xh', 'xuanhan', 'null', '636150'),
(1995, '001023014005', '开江', '001023014', 264, '中国/四川/达州/开江', '县', 4, 'kj', 'kaijiang', 'null', '636250'),
(1996, '001023014006', '大竹', '001023014', 264, '中国/四川/达州/大竹', '县', 4, 'dz', 'dazhu', 'null', '635100'),
(1997, '001023014007', '渠县', '001023014', 264, '中国/四川/达州/渠县', 'null', 4, 'q', 'qu', 'null', '635200'),
(1998, '001023015001', '东坡', '001023015', 265, '中国/四川/眉山/东坡', '区', 4, 'dp', 'dongpo', 'null', '620010'),
(1999, '001023015002', '仁寿', '001023015', 265, '中国/四川/眉山/仁寿', '县', 4, 'rs', 'renshou', 'null', '620500'),
(2000, '001023015003', '彭山', '001023015', 265, '中国/四川/眉山/彭山', '县', 4, 'ps', 'pengshan', 'null', '620860'),
(2001, '001023015004', '洪雅', '001023015', 265, '中国/四川/眉山/洪雅', '县', 4, 'hy', 'hongya', 'null', '620360'),
(2002, '001023015005', '丹棱', '001023015', 265, '中国/四川/眉山/丹棱', '县', 4, 'dl', 'danleng', 'null', '620200'),
(2003, '001023015006', '青神', '001023015', 265, '中国/四川/眉山/青神', '县', 4, 'qs', 'qingshen', 'null', '620460'),
(2004, '001023016001', '雨城', '001023016', 266, '中国/四川/雅安/雨城', '区', 4, 'yc', 'yucheng', 'null', '625000'),
(2005, '001023016002', '名山', '001023016', 266, '中国/四川/雅安/名山', '县', 4, 'ms', 'mingshan', 'null', '625100'),
(2006, '001023016003', '荥经', '001023016', 266, '中国/四川/雅安/荥经', '县', 4, 'j', 'jing', 'null', '625200'),
(2007, '001023016004', '汉源', '001023016', 266, '中国/四川/雅安/汉源', '县', 4, 'hy', 'hanyuan', 'null', '625300'),
(2008, '001023016005', '石棉', '001023016', 266, '中国/四川/雅安/石棉', '县', 4, 'sm', 'shimian', 'null', '625400'),
(2009, '001023016006', '天全', '001023016', 266, '中国/四川/雅安/天全', '县', 4, 'tq', 'tianquan', 'null', '625500'),
(2010, '001023016007', '芦山', '001023016', 266, '中国/四川/雅安/芦山', '县', 4, 'ls', 'lushan', 'null', '625600'),
(2011, '001023016008', '宝兴', '001023016', 266, '中国/四川/雅安/宝兴', '县', 4, 'bx', 'baoxing', 'null', '625700'),
(2012, '001023017001', '巴州', '001023017', 267, '中国/四川/巴中/巴州', '区', 4, 'bz', 'bazhou', 'null', '636600'),
(2013, '001023017002', '通江', '001023017', 267, '中国/四川/巴中/通江', '县', 4, 'tj', 'tongjiang', 'null', '636700'),
(2014, '001023017003', '南江', '001023017', 267, '中国/四川/巴中/南江', '县', 4, 'nj', 'nanjiang', 'null', '635600'),
(2015, '001023017004', '平昌', '001023017', 267, '中国/四川/巴中/平昌', '县', 4, 'pc', 'pingchang', 'null', '636400'),
(2016, '001023018001', '雁江', '001023018', 268, '中国/四川/资阳/雁江', '区', 4, 'yj', 'yanjiang', 'null', '641300'),
(2017, '001023018002', '简阳', '001023018', 268, '中国/四川/资阳/简阳', '市', 4, 'jy', 'jianyang', 'null', '641400'),
(2018, '001023018003', '乐至', '001023018', 268, '中国/四川/资阳/乐至', '县', 4, 'lz', 'lezhi', 'null', '641500'),
(2019, '001023018004', '安岳', '001023018', 268, '中国/四川/资阳/安岳', '县', 4, 'ay', 'anyue', 'null', '642350'),
(2020, '001023019001', '马尔康', '001023019', 269, '中国/四川/阿坝/马尔康', '县', 4, 'mek', 'maerkang', 'null', '624000'),
(2021, '001023019002', '汶川', '001023019', 269, '中国/四川/阿坝/汶川', '县', 4, 'c', 'chuan', 'null', '623000'),
(2022, '001023019003', '理县', '001023019', 269, '中国/四川/阿坝/理县', 'null', 4, 'l', 'li', 'null', '623100'),
(2023, '001023019004', '茂县', '001023019', 269, '中国/四川/阿坝/茂县', 'null', 4, 'm', 'mao', 'null', '623200'),
(2024, '001023019005', '松潘', '001023019', 269, '中国/四川/阿坝/松潘', '县', 4, 'sp', 'songpan', 'null', '623300'),
(2025, '001023019006', '九寨沟', '001023019', 269, '中国/四川/阿坝/九寨沟', '县', 4, 'jzg', 'jiuzhaigou', 'null', '623400'),
(2026, '001023019007', '金川', '001023019', 269, '中国/四川/阿坝/金川', '县', 4, 'jc', 'jinchuan', 'null', '624100'),
(2027, '001023019008', '小金', '001023019', 269, '中国/四川/阿坝/小金', '县', 4, 'xj', 'xiaojin', 'null', '624200'),
(2028, '001023019009', '黑水', '001023019', 269, '中国/四川/阿坝/黑水', '县', 4, 'hs', 'heishui', 'null', '623500'),
(2029, '001023019010', '壤塘', '001023019', 269, '中国/四川/阿坝/壤塘', '县', 4, 'rt', 'rangtang', 'null', '624300'),
(2030, '001023019011', '阿坝', '001023019', 269, '中国/四川/阿坝/阿坝', '县', 4, 'ab', 'aba', 'null', '624600'),
(2031, '001023019012', '若尔盖', '001023019', 269, '中国/四川/阿坝/若尔盖', '县', 4, 'reg', 'ruoergai', 'null', '624500'),
(2032, '001023019013', '红原', '001023019', 269, '中国/四川/阿坝/红原', '县', 4, 'hy', 'hongyuan', 'null', '624400'),
(2033, '001023020001', '康定', '001023020', 270, '中国/四川/甘孜/康定', '县', 4, 'kd', 'kangding', 'null', '626000'),
(2034, '001023020002', '泸定', '001023020', 270, '中国/四川/甘孜/泸定', '县', 4, 'd', 'ding', 'null', '626100'),
(2035, '001023020003', '丹巴', '001023020', 270, '中国/四川/甘孜/丹巴', '县', 4, 'db', 'danba', 'null', '626300'),
(2036, '001023020004', '九龙', '001023020', 270, '中国/四川/甘孜/九龙', '县', 4, 'jl', 'jiulong', 'null', '616200'),
(2037, '001023020005', '雅江', '001023020', 270, '中国/四川/甘孜/雅江', '县', 4, 'yj', 'yajiang', 'null', '627450'),
(2038, '001023020006', '道孚', '001023020', 270, '中国/四川/甘孜/道孚', '县', 4, 'd', 'dao', 'null', '626400'),
(2039, '001023020007', '炉霍', '001023020', 270, '中国/四川/甘孜/炉霍', '县', 4, 'lh', 'luhuo', 'null', '626500'),
(2040, '001023020008', '甘孜', '001023020', 270, '中国/四川/甘孜/甘孜', '县', 4, 'gz', 'ganzi', 'null', '626700'),
(2041, '001023020009', '新龙', '001023020', 270, '中国/四川/甘孜/新龙', '县', 4, 'xl', 'xinlong', 'null', '626800'),
(2042, '001023020010', '德格', '001023020', 270, '中国/四川/甘孜/德格', '县', 4, 'dg', 'dege', 'null', '627250'),
(2043, '001023020011', '白玉', '001023020', 270, '中国/四川/甘孜/白玉', '县', 4, 'by', 'baiyu', 'null', '627150'),
(2044, '001023020012', '石渠', '001023020', 270, '中国/四川/甘孜/石渠', '县', 4, 'sq', 'shiqu', 'null', '627350'),
(2045, '001023020013', '色达', '001023020', 270, '中国/四川/甘孜/色达', '县', 4, 'sd', 'seda', 'null', '626600'),
(2046, '001023020014', '理塘', '001023020', 270, '中国/四川/甘孜/理塘', '县', 4, 'lt', 'litang', 'null', '624300'),
(2047, '001023020015', '巴塘', '001023020', 270, '中国/四川/甘孜/巴塘', '县', 4, 'bt', 'batang', 'null', '627650'),
(2048, '001023020016', '乡城', '001023020', 270, '中国/四川/甘孜/乡城', '县', 4, 'xc', 'xiangcheng', 'null', '627850'),
(2049, '001023020017', '稻城', '001023020', 270, '中国/四川/甘孜/稻城', '县', 4, 'dc', 'daocheng', 'null', '627750'),
(2050, '001023020018', '得荣', '001023020', 270, '中国/四川/甘孜/得荣', '县', 4, 'dr', 'derong', 'null', '627950'),
(2051, '001023021001', '西昌', '001023021', 271, '中国/四川/凉山/西昌', '市', 4, 'xc', 'xichang', 'null', '615000'),
(2052, '001023021002', '盐源', '001023021', 271, '中国/四川/凉山/盐源', '县', 4, 'yy', 'yanyuan', 'null', '615700'),
(2053, '001023021003', '德昌', '001023021', 271, '中国/四川/凉山/德昌', '县', 4, 'dc', 'dechang', 'null', '615500'),
(2054, '001023021004', '会理', '001023021', 271, '中国/四川/凉山/会理', '县', 4, 'hl', 'huili', 'null', '615100'),
(2055, '001023021005', '会东', '001023021', 271, '中国/四川/凉山/会东', '县', 4, 'hd', 'huidong', 'null', '615200'),
(2056, '001023021006', '宁南', '001023021', 271, '中国/四川/凉山/宁南', '县', 4, 'nn', 'ningnan', 'null', '615400'),
(2057, '001023021007', '普格', '001023021', 271, '中国/四川/凉山/普格', '县', 4, 'pg', 'puge', 'null', '615300'),
(2058, '001023021008', '布拖', '001023021', 271, '中国/四川/凉山/布拖', '县', 4, 'bt', 'butuo', 'null', '615350'),
(2059, '001023021009', '金阳', '001023021', 271, '中国/四川/凉山/金阳', '县', 4, 'jy', 'jinyang', 'null', '616250'),
(2060, '001023021010', '昭觉', '001023021', 271, '中国/四川/凉山/昭觉', '县', 4, 'zj', 'zhaojue', 'null', '616150'),
(2061, '001023021011', '喜德', '001023021', 271, '中国/四川/凉山/喜德', '县', 4, 'xd', 'xide', 'null', '616750'),
(2062, '001023021012', '冕宁', '001023021', 271, '中国/四川/凉山/冕宁', '县', 4, 'mn', 'mianning', 'null', '615600'),
(2063, '001023021013', '越西', '001023021', 271, '中国/四川/凉山/越西', '县', 4, 'yx', 'yuexi', 'null', '616650'),
(2064, '001023021014', '甘洛', '001023021', 271, '中国/四川/凉山/甘洛', '县', 4, 'gl', 'ganluo', 'null', '616850'),
(2065, '001023021015', '美姑', '001023021', 271, '中国/四川/凉山/美姑', '县', 4, 'mg', 'meigu', 'null', '616450'),
(2066, '001023021016', '雷波', '001023021', 271, '中国/四川/凉山/雷波', '县', 4, 'lb', 'leibo', 'null', '616550'),
(2067, '001023021017', '木里', '001023021', 271, '中国/四川/凉山/木里', '藏族自治县', 4, 'mlczzz', 'mulicangzuz', 'null', '615800'),
(2068, '001024001001', '南明', '001024001', 272, '中国/贵州/贵阳/南明', '区', 4, 'nm', 'nanming', 'null', '550002'),
(2069, '001024001002', '云岩', '001024001', 272, '中国/贵州/贵阳/云岩', '区', 4, 'yy', 'yunyan', 'null', '550001'),
(2070, '001024001003', '花溪', '001024001', 272, '中国/贵州/贵阳/花溪', '区', 4, 'hx', 'huaxi', 'null', '550025'),
(2071, '001024001004', '乌当', '001024001', 272, '中国/贵州/贵阳/乌当', '区', 4, 'wd', 'wudang', 'null', '550018'),
(2072, '001024001005', '白云', '001024001', 272, '中国/贵州/贵阳/白云', '区', 4, 'by', 'baiyun', 'null', '550014'),
(2073, '001024001006', '小河', '001024001', 272, '中国/贵州/贵阳/小河', '区', 4, 'xh', 'xiaohe', 'null', '550009'),
(2074, '001024001007', '清镇', '001024001', 272, '中国/贵州/贵阳/清镇', '市', 4, 'qz', 'qingzhen', 'null', '551400'),
(2075, '001024001008', '开阳', '001024001', 272, '中国/贵州/贵阳/开阳', '县', 4, 'ky', 'kaiyang', 'null', '550300'),
(2076, '001024001009', '修文', '001024001', 272, '中国/贵州/贵阳/修文', '县', 4, 'xw', 'xiuwen', 'null', '550200'),
(2077, '001024001010', '息烽', '001024001', 272, '中国/贵州/贵阳/息烽', '县', 4, 'xf', 'xifeng', 'null', '551100'),
(2078, '001024002001', '钟山', '001024002', 273, '中国/贵州/六盘水/钟山', '区', 4, 'zs', 'zhongshan', 'null', '553000'),
(2079, '001024002002', '盘县', '001024002', 273, '中国/贵州/六盘水/盘县', 'null', 4, 'p', 'pan', 'null', '561611'),
(2080, '001024002003', '六枝特', '001024002', 273, '中国/贵州/六盘水/六枝特', '区', 4, 'lzt', 'liuzhite', 'null', '553400'),
(2081, '001024002004', '水城', '001024002', 273, '中国/贵州/六盘水/水城', '县', 4, 'sc', 'shuicheng', 'null', '553000'),
(2082, '001024003001', '红花岗', '001024003', 274, '中国/贵州/遵义/红花岗', '区', 4, 'hhg', 'honghuagang', 'null', '563000'),
(2083, '001024003002', '赤水', '001024003', 274, '中国/贵州/遵义/赤水', '市', 4, 'cs', 'chishui', 'null', '564700'),
(2084, '001024003003', '仁怀', '001024003', 274, '中国/贵州/遵义/仁怀', '市', 4, 'rh', 'renhuai', 'null', '564500'),
(2085, '001024003004', '遵义', '001024003', 274, '中国/贵州/遵义/遵义', '县', 4, 'zy', 'zunyi', 'null', '563100'),
(2086, '001024003005', '桐梓', '001024003', 274, '中国/贵州/遵义/桐梓', '县', 4, 't', 'tong', 'null', '563200'),
(2087, '001024003006', '绥阳', '001024003', 274, '中国/贵州/遵义/绥阳', '县', 4, 'sy', 'suiyang', 'null', '563300'),
(2088, '001024003007', '正安', '001024003', 274, '中国/贵州/遵义/正安', '县', 4, 'za', 'zhengan', 'null', '563400'),
(2089, '001024003008', '凤冈', '001024003', 274, '中国/贵州/遵义/凤冈', '县', 4, 'fg', 'fenggang', 'null', '564200'),
(2090, '001024003009', '湄潭', '001024003', 274, '中国/贵州/遵义/湄潭', '县', 4, 'mt', 'tan', 'null', '564100'),
(2091, '001024003010', '余庆', '001024003', 274, '中国/贵州/遵义/余庆', '县', 4, 'yq', 'yuqing', 'null', '564400'),
(2092, '001024003011', '习水', '001024003', 274, '中国/贵州/遵义/习水', '县', 4, 'xs', 'xishui', 'null', '564600'),
(2093, '001024003012', '道真', '001024003', 274, '中国/贵州/遵义/道真', '仡佬族苗族自治县', 4, 'dzlzmzzz', 'daozhenlaoz', 'null', '563500'),
(2094, '001024003013', '务川', '001024003', 274, '中国/贵州/遵义/务川', '仡佬族苗族自治县', 4, 'wclzmzzz', 'wuchuanlaoz', 'null', '564300'),
(2095, '001024004001', '西秀', '001024004', 275, '中国/贵州/安顺/西秀', '区', 4, 'xx', 'xixiu', 'null', '561000'),
(2096, '001024004002', '平坝', '001024004', 275, '中国/贵州/安顺/平坝', '县', 4, 'pb', 'pingba', 'null', '561100'),
(2097, '001024004003', '普定', '001024004', 275, '中国/贵州/安顺/普定', '县', 4, 'pd', 'puding', 'null', '562100'),
(2098, '001024004004', '关岭', '001024004', 275, '中国/贵州/安顺/关岭', '布依族苗族自治县', 4, 'glbyzmzzz', 'guanlingbuy', 'null', '561300'),
(2099, '001024004005', '镇宁', '001024004', 275, '中国/贵州/安顺/镇宁', '布依族苗族自治县', 4, 'znbyzmzzz', 'zhenningbuy', 'null', '561200'),
(2100, '001024004006', '紫云', '001024004', 275, '中国/贵州/安顺/紫云', '苗族布依族自治县', 4, 'zymzbyzzz', 'ziyunmiaozu', 'null', '550800'),
(2101, '001024005001', '铜仁', '001024005', 276, '中国/贵州/铜仁地/铜仁', '市', 4, 'tr', 'tongren', 'null', '554300'),
(2102, '001024005002', '江口', '001024005', 276, '中国/贵州/铜仁地/江口', '县', 4, 'jk', 'jiangkou', 'null', '554400'),
(2103, '001024005003', '石阡', '001024005', 276, '中国/贵州/铜仁地/石阡', '县', 4, 's', 'shi', 'null', '555100'),
(2104, '001024005004', '思南', '001024005', 276, '中国/贵州/铜仁地/思南', '县', 4, 'sn', 'sinan', 'null', '565100'),
(2105, '001024005005', '德江', '001024005', 276, '中国/贵州/铜仁地/德江', '县', 4, 'dj', 'dejiang', 'null', '565200'),
(2106, '001024005006', '玉屏', '001024005', 276, '中国/贵州/铜仁地/玉屏', '侗族自治县', 4, 'ypdzzz', 'yupingdongz', 'null', '554000'),
(2107, '001024005007', '印江', '001024005', 276, '中国/贵州/铜仁地/印江', '土家族苗族自治县', 4, 'yjtjzmzzz', 'yinjiangtuj', 'null', '555200'),
(2108, '001024005008', '沿河', '001024005', 276, '中国/贵州/铜仁地/沿河', '土家族自治县', 4, 'yhtjzzz', 'yanhetujiaz', 'null', '565300'),
(2109, '001024005009', '松桃', '001024005', 276, '中国/贵州/铜仁地/松桃', '苗族自治县', 4, 'stmzzz', 'songtaomiao', 'null', '554100'),
(2110, '001024005010', '万山特', '001024005', 276, '中国/贵州/铜仁地/万山特', '区', 4, 'wst', 'wanshante', 'null', '554200'),
(2111, '001024006001', '毕节', '001024006', 277, '中国/贵州/毕节地/毕节', '市', 4, 'bj', 'bijie', 'null', '551700'),
(2112, '001024006002', '大方', '001024006', 277, '中国/贵州/毕节地/大方', '县', 4, 'df', 'dafang', 'null', '551600'),
(2113, '001024006003', '黔西', '001024006', 277, '中国/贵州/毕节地/黔西', '县', 4, 'qx', 'qianxi', 'null', '551500'),
(2114, '001024006004', '金沙', '001024006', 277, '中国/贵州/毕节地/金沙', '县', 4, 'js', 'jinsha', 'null', '551800'),
(2115, '001024006005', '织金', '001024006', 277, '中国/贵州/毕节地/织金', '县', 4, 'zj', 'zhijin', 'null', '552100'),
(2116, '001024006006', '纳雍', '001024006', 277, '中国/贵州/毕节地/纳雍', '县', 4, 'ny', 'nayong', 'null', '553300'),
(2117, '001024006007', '赫章', '001024006', 277, '中国/贵州/毕节地/赫章', '县', 4, 'hz', 'hezhang', 'null', '553200'),
(2118, '001024006008', '威宁', '001024006', 277, '中国/贵州/毕节地/威宁', '彝族回族苗族自治县', 4, 'wnyzmzzz', 'weiningyizu', 'null', '553100'),
(2119, '001024007001', '兴义', '001024007', 278, '中国/贵州/黔西南/兴义', '市', 4, 'xy', 'xingyi', 'null', '562400'),
(2120, '001024007002', '兴仁', '001024007', 278, '中国/贵州/黔西南/兴仁', '县', 4, 'xr', 'xingren', 'null', '562300'),
(2121, '001024007003', '普安', '001024007', 278, '中国/贵州/黔西南/普安', '县', 4, 'pa', 'puan', 'null', '561500'),
(2122, '001024007004', '晴隆', '001024007', 278, '中国/贵州/黔西南/晴隆', '县', 4, 'ql', 'qinglong', 'null', '561400'),
(2123, '001024007005', '贞丰', '001024007', 278, '中国/贵州/黔西南/贞丰', '县', 4, 'zf', 'zhenfeng', 'null', '562200'),
(2124, '001024007006', '望谟', '001024007', 278, '中国/贵州/黔西南/望谟', '县', 4, 'w', 'wang', 'null', '552300'),
(2125, '001024007007', '册亨', '001024007', 278, '中国/贵州/黔西南/册亨', '县', 4, 'ch', 'ceheng', 'null', '552200'),
(2126, '001024007008', '安龙', '001024007', 278, '中国/贵州/黔西南/安龙', '县', 4, 'al', 'anlong', 'null', '552400'),
(2127, '001024008001', '凯里', '001024008', 279, '中国/贵州/黔东南/凯里', '市', 4, 'kl', 'kaili', 'null', '556000'),
(2128, '001024008002', '黄平', '001024008', 279, '中国/贵州/黔东南/黄平', '县', 4, 'hp', 'huangping', 'null', '556100'),
(2129, '001024008003', '施秉', '001024008', 279, '中国/贵州/黔东南/施秉', '县', 4, 'sb', 'shibing', 'null', '556200'),
(2130, '001024008004', '三穗', '001024008', 279, '中国/贵州/黔东南/三穗', '县', 4, 'ss', 'sansui', 'null', '556500'),
(2131, '001024008005', '镇远', '001024008', 279, '中国/贵州/黔东南/镇远', '县', 4, 'zy', 'zhenyuan', 'null', '557700'),
(2132, '001024008006', '岑巩', '001024008', 279, '中国/贵州/黔东南/岑巩', '县', 4, 'g', 'gong', 'null', '557800'),
(2133, '001024008007', '天柱', '001024008', 279, '中国/贵州/黔东南/天柱', '县', 4, 'tz', 'tianzhu', 'null', '556600'),
(2134, '001024008008', '锦屏', '001024008', 279, '中国/贵州/黔东南/锦屏', '县', 4, 'jp', 'jinping', 'null', '556700'),
(2135, '001024008009', '剑河', '001024008', 279, '中国/贵州/黔东南/剑河', '县', 4, 'jh', 'jianhe', 'null', '556400'),
(2136, '001024008010', '台江', '001024008', 279, '中国/贵州/黔东南/台江', '县', 4, 'tj', 'taijiang', 'null', '556300'),
(2137, '001024008011', '黎平', '001024008', 279, '中国/贵州/黔东南/黎平', '县', 4, 'lp', 'liping', 'null', '557300'),
(2138, '001024008012', '榕江', '001024008', 279, '中国/贵州/黔东南/榕江', '县', 4, 'j', 'jiang', 'null', '557200'),
(2139, '001024008013', '从江', '001024008', 279, '中国/贵州/黔东南/从江', '县', 4, 'cj', 'congjiang', 'null', '557400'),
(2140, '001024008014', '雷山', '001024008', 279, '中国/贵州/黔东南/雷山', '县', 4, 'ls', 'leishan', 'null', '557100'),
(2141, '001024008015', '麻江', '001024008', 279, '中国/贵州/黔东南/麻江', '县', 4, 'mj', 'majiang', 'null', '557600'),
(2142, '001024008016', '丹寨', '001024008', 279, '中国/贵州/黔东南/丹寨', '县', 4, 'dz', 'danzhai', 'null', '557500'),
(2143, '001024009001', '都匀', '001024009', 280, '中国/贵州/黔南/都匀', '市', 4, 'dy', 'duyun', 'null', '558000'),
(2144, '001024009002', '福泉', '001024009', 280, '中国/贵州/黔南/福泉', '市', 4, 'fq', 'fuquan', 'null', '550500'),
(2145, '001024009003', '荔波', '001024009', 280, '中国/贵州/黔南/荔波', '县', 4, 'lb', 'libo', 'null', '558400'),
(2146, '001024009004', '贵定', '001024009', 280, '中国/贵州/黔南/贵定', '县', 4, 'gd', 'guiding', 'null', '551300'),
(2147, '001024009005', '瓮安', '001024009', 280, '中国/贵州/黔南/瓮安', '县', 4, 'wa', 'wengan', 'null', '550400'),
(2148, '001024009006', '独山', '001024009', 280, '中国/贵州/黔南/独山', '县', 4, 'ds', 'dushan', 'null', '558200'),
(2149, '001024009007', '平塘', '001024009', 280, '中国/贵州/黔南/平塘', '县', 4, 'pt', 'pingtang', 'null', '558300'),
(2150, '001024009008', '罗甸', '001024009', 280, '中国/贵州/黔南/罗甸', '县', 4, 'ld', 'luodian', 'null', '550100'),
(2151, '001024009009', '长顺', '001024009', 280, '中国/贵州/黔南/长顺', '县', 4, 'cs', 'changshun', 'null', '550700'),
(2152, '001024009010', '龙里', '001024009', 280, '中国/贵州/黔南/龙里', '县', 4, 'll', 'longli', 'null', '551200'),
(2153, '001024009011', '惠水', '001024009', 280, '中国/贵州/黔南/惠水', '县', 4, 'hs', 'huishui', 'null', '550600'),
(2154, '001024009012', '三都', '001024009', 280, '中国/贵州/黔南/三都', '水族自治县', 4, 'sdszzz', 'sandushuizu', 'null', '558100'),
(2155, '001025001001', '盘龙', '001025001', 281, '中国/云南/昆明/盘龙', '区', 4, 'pl', 'panlong', 'null', '650051'),
(2156, '001025001002', '五华', '001025001', 281, '中国/云南/昆明/五华', '区', 4, 'wh', 'wuhua', 'null', '650032'),
(2157, '001025001003', '官渡', '001025001', 281, '中国/云南/昆明/官渡', '区', 4, 'gd', 'guandu', 'null', '650220'),
(2158, '001025001004', '西山', '001025001', 281, '中国/云南/昆明/西山', '区', 4, 'xs', 'xishan', 'null', '650100'),
(2159, '001025001005', '东川', '001025001', 281, '中国/云南/昆明/东川', '区', 4, 'dc', 'dongchuan', 'null', '654100'),
(2160, '001025001006', '安宁', '001025001', 281, '中国/云南/昆明/安宁', '市', 4, 'an', 'anning', 'null', '650300'),
(2161, '001025001007', '呈贡', '001025001', 281, '中国/云南/昆明/呈贡', '县', 4, 'cg', 'chenggong', 'null', '650500'),
(2162, '001025001008', '晋宁', '001025001', 281, '中国/云南/昆明/晋宁', '县', 4, 'jn', 'jinning', 'null', '650600'),
(2163, '001025001009', '富民', '001025001', 281, '中国/云南/昆明/富民', '县', 4, 'fm', 'fumin', 'null', '650400'),
(2164, '001025001010', '宜良', '001025001', 281, '中国/云南/昆明/宜良', '县', 4, 'yl', 'yiliang', 'null', '652100'),
(2165, '001025001011', '嵩明', '001025001', 281, '中国/云南/昆明/嵩明', '县', 4, 'm', 'ming', 'null', '651700'),
(2166, '001025001012', '石林', '001025001', 281, '中国/云南/昆明/石林', '彝族自治县', 4, 'slyzzz', 'shilinyizuz', 'null', '652200'),
(2167, '001025001013', '禄劝', '001025001', 281, '中国/云南/昆明/禄劝', '彝族苗族自治县', 4, 'lqyzmzzz', 'luquanyizum', 'null', '651500'),
(2168, '001025001014', '寻甸', '001025001', 281, '中国/云南/昆明/寻甸', '回族彝族自治县', 4, 'xdyzzz', 'xundianyizu', 'null', '655200'),
(2169, '001025002001', '麒麟', '001025002', 282, '中国/云南/曲靖/麒麟', '区', 4, 'null', 'null', 'null', '655000'),
(2170, '001025002002', '宣威', '001025002', 282, '中国/云南/曲靖/宣威', '市', 4, 'xw', 'xuanwei', 'null', '655400'),
(2171, '001025002003', '马龙', '001025002', 282, '中国/云南/曲靖/马龙', '县', 4, 'ml', 'malong', 'null', '655100'),
(2172, '001025002004', '沾益', '001025002', 282, '中国/云南/曲靖/沾益', '县', 4, 'zy', 'zhanyi', 'null', '655500'),
(2173, '001025002005', '罗平', '001025002', 282, '中国/云南/曲靖/罗平', '县', 4, 'lp', 'luoping', 'null', '655800'),
(2174, '001025002006', '师宗', '001025002', 282, '中国/云南/曲靖/师宗', '县', 4, 'sz', 'shizong', 'null', '655700'),
(2175, '001025002007', '陆良', '001025002', 282, '中国/云南/曲靖/陆良', '县', 4, 'll', 'luliang', 'null', '655600'),
(2176, '001025002008', '会泽', '001025002', 282, '中国/云南/曲靖/会泽', '县', 4, 'hz', 'huize', 'null', '654200'),
(2177, '001025003001', '红塔', '001025003', 283, '中国/云南/玉溪/红塔', '区', 4, 'ht', 'hongta', 'null', '653100'),
(2178, '001025003002', '江川', '001025003', 283, '中国/云南/玉溪/江川', '县', 4, 'jc', 'jiangchuan', 'null', '652600'),
(2179, '001025003003', '澄江', '001025003', 283, '中国/云南/玉溪/澄江', '县', 4, 'cj', 'chengjiang', 'null', '652500'),
(2180, '001025003004', '通海', '001025003', 283, '中国/云南/玉溪/通海', '县', 4, 'th', 'tonghai', 'null', '652700'),
(2181, '001025003005', '华宁', '001025003', 283, '中国/云南/玉溪/华宁', '县', 4, 'hn', 'huaning', 'null', '652800'),
(2182, '001025003006', '易门', '001025003', 283, '中国/云南/玉溪/易门', '县', 4, 'ym', 'yimen', 'null', '651100'),
(2183, '001025003007', '峨山', '001025003', 283, '中国/云南/玉溪/峨山', '彝族自治县', 4, 'esyzzz', 'eshanyizuzi', 'null', '653200'),
(2184, '001025003008', '新平', '001025003', 283, '中国/云南/玉溪/新平', '彝族傣族自治县', 4, 'xpyzdzzz', 'xinpingyizu', 'null', '653400'),
(2185, '001025003009', '元江', '001025003', 283, '中国/云南/玉溪/元江', '哈尼族彝族傣族自治县', 4, 'yjhnzyzdzzz', 'yuanjiangha', 'null', '653300'),
(2186, '001025004001', '隆阳', '001025004', 284, '中国/云南/保山/隆阳', '区', 4, 'ly', 'longyang', 'null', '678000'),
(2187, '001025004002', '施甸', '001025004', 284, '中国/云南/保山/施甸', '县', 4, 'sd', 'shidian', 'null', '678200'),
(2188, '001025004003', '腾冲', '001025004', 284, '中国/云南/保山/腾冲', '县', 4, 'tc', 'tengchong', 'null', '679100'),
(2189, '001025004004', '龙陵', '001025004', 284, '中国/云南/保山/龙陵', '县', 4, 'll', 'longling', 'null', '678300'),
(2190, '001025004005', '昌宁', '001025004', 284, '中国/云南/保山/昌宁', '县', 4, 'cn', 'changning', 'null', '678100'),
(2191, '001025005001', '昭阳', '001025005', 285, '中国/云南/昭通/昭阳', '区', 4, 'zy', 'zhaoyang', 'null', '657000'),
(2192, '001025005002', '鲁甸', '001025005', 285, '中国/云南/昭通/鲁甸', '县', 4, 'ld', 'ludian', 'null', '657100'),
(2193, '001025005003', '巧家', '001025005', 285, '中国/云南/昭通/巧家', '县', 4, 'qj', 'qiaojia', 'null', '654600'),
(2194, '001025005004', '盐津', '001025005', 285, '中国/云南/昭通/盐津', '县', 4, 'yj', 'yanjin', 'null', '657500'),
(2195, '001025005005', '大关', '001025005', 285, '中国/云南/昭通/大关', '县', 4, 'dg', 'daguan', 'null', '657400'),
(2196, '001025005006', '永善', '001025005', 285, '中国/云南/昭通/永善', '县', 4, 'ys', 'yongshan', 'null', '657300'),
(2197, '001025005007', '绥江', '001025005', 285, '中国/云南/昭通/绥江', '县', 4, 'sj', 'suijiang', 'null', '657700'),
(2198, '001025005008', '镇雄', '001025005', 285, '中国/云南/昭通/镇雄', '县', 4, 'zx', 'zhenxiong', 'null', '657200'),
(2199, '001025005009', '彝良', '001025005', 285, '中国/云南/昭通/彝良', '县', 4, 'yl', 'yiliang', 'null', '657600'),
(2200, '001025005010', '威信', '001025005', 285, '中国/云南/昭通/威信', '县', 4, 'wx', 'weixin', 'null', '657900'),
(2201, '001025005011', '水富', '001025005', 285, '中国/云南/昭通/水富', '县', 4, 'sf', 'shuifu', 'null', '657800'),
(2202, '001025006001', '思茅', '001025006', 286, '中国/云南/思茅/思茅', '市', 4, 'sm', 'simao', 'null', '665000'),
(2203, '001025006002', '普洱', '001025006', 286, '中国/云南/思茅/普洱', '哈尼族彝族自治县', 4, 'pehnzyzzz', 'puerhanizuy', 'null', '665100'),
(2204, '001025006003', '墨江', '001025006', 286, '中国/云南/思茅/墨江', '哈尼族自治县', 4, 'mjhnzzz', 'mojianghani', 'null', '654800'),
(2205, '001025006004', '景东', '001025006', 286, '中国/云南/思茅/景东', '彝族自治县', 4, 'jdyzzz', 'jingdongyiz', 'null', '676200'),
(2206, '001025006005', '景谷', '001025006', 286, '中国/云南/思茅/景谷', '傣族彝族自治县', 4, 'jgdzyzzz', 'jinggudaizu', 'null', '666400'),
(2207, '001025006006', '镇沅', '001025006', 286, '中国/云南/思茅/镇沅', '彝族哈尼族拉祜族自治县', 4, 'zyzhnzlzzz', 'zhenyizuhan', 'null', '666500'),
(2208, '001025006007', '江城', '001025006', 286, '中国/云南/思茅/江城', '哈尼族彝族自治县', 4, 'jchnzyzzz', 'jiangchengh', 'null', '665900'),
(2209, '001025006008', '孟连', '001025006', 286, '中国/云南/思茅/孟连', '傣族拉祜族佤族自治县', 4, 'mldzlzzzz', 'mengliandai', 'null', '665800'),
(2210, '001025006009', '澜沧', '001025006', 286, '中国/云南/思茅/澜沧', '拉祜族自治县', 4, 'lclzzz', 'lancanglazu', 'null', '665600'),
(2211, '001025006010', '西盟', '001025006', 286, '中国/云南/思茅/西盟', '佤族自治县', 4, 'xmzzz', 'ximengzuziz', 'null', '665700'),
(2212, '001025007001', '临沧', '001025007', 287, '中国/云南/临沧/临沧', '县', 4, 'lc', 'lincang', 'null', '677000'),
(2213, '001025007002', '凤庆', '001025007', 287, '中国/云南/临沧/凤庆', '县', 4, 'fq', 'fengqing', 'null', '675900'),
(2214, '001025007003', '云县', '001025007', 287, '中国/云南/临沧/云县', 'null', 4, 'y', 'yun', 'null', '675800'),
(2215, '001025007004', '永德', '001025007', 287, '中国/云南/临沧/永德', '县', 4, 'yd', 'yongde', 'null', '677600'),
(2216, '001025007005', '镇康', '001025007', 287, '中国/云南/临沧/镇康', '县', 4, 'zk', 'zhenkang', 'null', '677704'),
(2217, '001025007006', '双江', '001025007', 287, '中国/云南/临沧/双江', '拉祜族佤族布朗族傣族自治县', 4, 'sjlzzblzdzz', 'shuangjiang', 'null', '677300'),
(2218, '001025007007', '耿马', '001025007', 287, '中国/云南/临沧/耿马', '傣族佤族自治县', 4, 'gmdzzzz', 'gengmadaizu', 'null', '677500'),
(2219, '001025007008', '沧源', '001025007', 287, '中国/云南/临沧/沧源', '佤族自治县', 4, 'cyzzz', 'cangyuanzuz', 'null', '677400'),
(2220, '001025008001', '丽江', '001025008', 288, '中国/云南/丽江/丽江', '纳西族自治县', 4, 'ljnxzzz', 'lijiangnaxi', 'null', '674100'),
(2221, '001025008002', '永胜', '001025008', 288, '中国/云南/丽江/永胜', '县', 4, 'ys', 'yongsheng', 'null', '674200'),
(2222, '001025008003', '华坪', '001025008', 288, '中国/云南/丽江/华坪', '县', 4, 'hp', 'huaping', 'null', '674800'),
(2223, '001025008004', '宁蒗', '001025008', 288, '中国/云南/丽江/宁蒗', '彝族自治县', 4, 'nyzzz', 'ningyizuziz', 'null', '674300'),
(2224, '001025009001', '文山', '001025009', 289, '中国/云南/文山/文山', '县', 4, 'ws', 'wenshan', 'null', '663000'),
(2225, '001025009002', '砚山', '001025009', 289, '中国/云南/文山/砚山', '县', 4, 'ys', 'yanshan', 'null', '663100'),
(2226, '001025009003', '西畴', '001025009', 289, '中国/云南/文山/西畴', '县', 4, 'xc', 'xichou', 'null', '663500'),
(2227, '001025009004', '麻栗坡', '001025009', 289, '中国/云南/文山/麻栗坡', '县', 4, 'mlp', 'malipo', 'null', '663600'),
(2228, '001025009005', '马关', '001025009', 289, '中国/云南/文山/马关', '县', 4, 'mg', 'maguan', 'null', '663700'),
(2229, '001025009006', '丘北', '001025009', 289, '中国/云南/文山/丘北', '县', 4, 'qb', 'qiubei', 'null', '663200'),
(2230, '001025009007', '广南', '001025009', 289, '中国/云南/文山/广南', '县', 4, 'gn', 'guangnan', 'null', '663300'),
(2231, '001025009008', '富宁', '001025009', 289, '中国/云南/文山/富宁', '县', 4, 'fn', 'funing', 'null', '663400'),
(2232, '001025010001', '个旧', '001025010', 290, '中国/云南/红河/个旧', '市', 4, 'gj', 'gejiu', 'null', '661000'),
(2233, '001025010002', '开远', '001025010', 290, '中国/云南/红河/开远', '市', 4, 'ky', 'kaiyuan', 'null', '661600'),
(2234, '001025010003', '蒙自', '001025010', 290, '中国/云南/红河/蒙自', '县', 4, 'mz', 'mengzi', 'null', '661100'),
(2235, '001025010004', '绿春', '001025010', 290, '中国/云南/红河/绿春', '县', 4, 'lc', 'lvchun', 'null', '662500'),
(2236, '001025010005', '建水', '001025010', 290, '中国/云南/红河/建水', '县', 4, 'js', 'jianshui', 'null', '654300'),
(2237, '001025010006', '石屏', '001025010', 290, '中国/云南/红河/石屏', '县', 4, 'sp', 'shiping', 'null', '662200'),
(2238, '001025010007', '弥勒', '001025010', 290, '中国/云南/红河/弥勒', '县', 4, 'ml', 'mile', 'null', '652300'),
(2239, '001025010008', '泸西', '001025010', 290, '中国/云南/红河/泸西', '县', 4, 'x', 'xi', 'null', '652400'),
(2240, '001025010009', '元阳', '001025010', 290, '中国/云南/红河/元阳', '县', 4, 'yy', 'yuanyang', 'null', '662400'),
(2241, '001025010010', '红河', '001025010', 290, '中国/云南/红河/红河', '县', 4, 'hh', 'honghe', 'null', '654400'),
(2242, '001025010011', '金平', '001025010', 290, '中国/云南/红河/金平', '苗族瑶族傣族自治县', 4, 'jpmzyzdzzz', 'jinpingmiao', 'null', '661500'),
(2243, '001025010012', '河口', '001025010', 290, '中国/云南/红河/河口', '瑶族自治县', 4, 'hkyzzz', 'hekouyaozuz', 'null', '661300'),
(2244, '001025010013', '屏边', '001025010', 290, '中国/云南/红河/屏边', '苗族自治县', 4, 'pbmzzz', 'pingbianmia', 'null', '661200'),
(2245, '001025011001', '景洪', '001025011', 291, '中国/云南/西双版纳/景洪', '市', 4, 'jh', 'jinghong', 'null', '666100'),
(2246, '001025011002', '勐海', '001025011', 291, '中国/云南/西双版纳/勐海', '县', 4, 'h', 'hai', 'null', '666200'),
(2247, '001025011003', '勐腊', '001025011', 291, '中国/云南/西双版纳/勐腊', '县', 4, 'l', 'la', 'null', '666300'),
(2248, '001025012001', '楚雄', '001025012', 292, '中国/云南/楚雄/楚雄', '市', 4, 'cx', 'chuxiong', 'null', '675000'),
(2249, '001025012002', '双柏', '001025012', 292, '中国/云南/楚雄/双柏', '县', 4, 'sb', 'shuangbai', 'null', '675100'),
(2250, '001025012003', '牟定', '001025012', 292, '中国/云南/楚雄/牟定', '县', 4, 'md', 'mouding', 'null', '675500'),
(2251, '001025012004', '南华', '001025012', 292, '中国/云南/楚雄/南华', '县', 4, 'nh', 'nanhua', 'null', '675200'),
(2252, '001025012005', '姚安', '001025012', 292, '中国/云南/楚雄/姚安', '县', 4, 'ya', 'yaoan', 'null', '675300'),
(2253, '001025012006', '大姚', '001025012', 292, '中国/云南/楚雄/大姚', '县', 4, 'dy', 'dayao', 'null', '675400'),
(2254, '001025012007', '永仁', '001025012', 292, '中国/云南/楚雄/永仁', '县', 4, 'yr', 'yongren', 'null', '651400'),
(2255, '001025012008', '元谋', '001025012', 292, '中国/云南/楚雄/元谋', '县', 4, 'ym', 'yuanmou', 'null', '651300'),
(2256, '001025012009', '武定', '001025012', 292, '中国/云南/楚雄/武定', '县', 4, 'wd', 'wuding', 'null', '651600'),
(2257, '001025012010', '禄丰', '001025012', 292, '中国/云南/楚雄/禄丰', '县', 4, 'lf', 'lufeng', 'null', '651200'),
(2258, '001025013001', '大理', '001025013', 293, '中国/云南/大理/大理', '市', 4, 'dl', 'dali', 'null', '671000'),
(2259, '001025013002', '祥云', '001025013', 293, '中国/云南/大理/祥云', '县', 4, 'xy', 'xiangyun', 'null', '672100'),
(2260, '001025013003', '宾川', '001025013', 293, '中国/云南/大理/宾川', '县', 4, 'bc', 'binchuan', 'null', '671600'),
(2261, '001025013004', '弥渡', '001025013', 293, '中国/云南/大理/弥渡', '县', 4, 'md', 'midu', 'null', '675600'),
(2262, '001025013005', '永平', '001025013', 293, '中国/云南/大理/永平', '县', 4, 'yp', 'yongping', 'null', '672600'),
(2263, '001025013006', '云龙', '001025013', 293, '中国/云南/大理/云龙', '县', 4, 'yl', 'yunlong', 'null', '672700'),
(2264, '001025013007', '洱源', '001025013', 293, '中国/云南/大理/洱源', '县', 4, 'ey', 'eryuan', 'null', '671200'),
(2265, '001025013008', '剑川', '001025013', 293, '中国/云南/大理/剑川', '县', 4, 'jc', 'jianchuan', 'null', '671300'),
(2266, '001025013009', '鹤庆', '001025013', 293, '中国/云南/大理/鹤庆', '县', 4, 'hq', 'heqing', 'null', '671500'),
(2267, '001025013010', '漾濞', '001025013', 293, '中国/云南/大理/漾濞', '彝族自治县', 4, 'yyzzz', 'yangyizuziz', 'null', '672500'),
(2268, '001025013011', '南涧', '001025013', 293, '中国/云南/大理/南涧', '彝族自治县', 4, 'njyzzz', 'nanjianyizu', 'null', '675700'),
(2269, '001025013012', '巍山', '001025013', 293, '中国/云南/大理/巍山', '彝族回族自治县', 4, 'wsyzzz', 'weishanyizu', 'null', '672400'),
(2270, '001025014001', '潞西', '001025014', 294, '中国/云南/德宏/潞西', '市', 4, 'lx', 'luxi', 'null', '678400'),
(2271, '001025014002', '瑞丽', '001025014', 294, '中国/云南/德宏/瑞丽', '市', 4, 'rl', 'ruili', 'null', '678600'),
(2272, '001025014003', '梁河', '001025014', 294, '中国/云南/德宏/梁河', '县', 4, 'lh', 'lianghe', 'null', '679200'),
(2273, '001025014004', '盈江', '001025014', 294, '中国/云南/德宏/盈江', '县', 4, 'yj', 'yingjiang', 'null', '679300'),
(2274, '001025014005', '陇川', '001025014', 294, '中国/云南/德宏/陇川', '县', 4, 'lc', 'longchuan', 'null', '678700'),
(2275, '001025015001', '泸水', '001025015', 295, '中国/云南/怒江/泸水', '县', 4, 's', 'shui', 'null', '673200'),
(2276, '001025015002', '福贡', '001025015', 295, '中国/云南/怒江/福贡', '县', 4, 'fg', 'fugong', 'null', '673400'),
(2277, '001025015003', '贡山', '001025015', 295, '中国/云南/怒江/贡山', '独龙族怒族自治县', 4, 'gsdlznzzz', 'gongshandul', 'null', '673500'),
(2278, '001025015004', '兰坪', '001025015', 295, '中国/云南/怒江/兰坪', '白族普米族自治县', 4, 'lpbzpmzzz', 'lanpingbaiz', 'null', '671400'),
(2279, '001025016001', '香格里拉', '001025016', 296, '中国/云南/迪庆/香格里拉', '县', 4, 'xgll', 'xianggelila', 'null', '674400'),
(2280, '001025016002', '德钦', '001025016', 296, '中国/云南/迪庆/德钦', '县', 4, 'dq', 'deqin', 'null', '674500'),
(2281, '001025016003', '维西', '001025016', 296, '中国/云南/迪庆/维西', '傈僳族自治县', 4, 'wxlszzz', 'weixilisuzu', 'null', '674600'),
(2282, '001026001001', '城关', '001026001', 297, '中国/西藏/拉萨/城关', '区', 4, 'cg', 'chengguan', 'null', '850000'),
(2283, '001026001002', '林周', '001026001', 297, '中国/西藏/拉萨/林周', '县', 4, 'lz', 'linzhou', 'null', '851600'),
(2284, '001026001003', '当雄', '001026001', 297, '中国/西藏/拉萨/当雄', '县', 4, 'dx', 'dangxiong', 'null', '851500'),
(2285, '001026001004', '尼木', '001026001', 297, '中国/西藏/拉萨/尼木', '县', 4, 'nm', 'nimu', 'null', '851300'),
(2286, '001026001005', '曲水', '001026001', 297, '中国/西藏/拉萨/曲水', '县', 4, 'qs', 'qushui', 'null', '850600'),
(2287, '001026001006', '堆龙德庆', '001026001', 297, '中国/西藏/拉萨/堆龙德庆', '县', 4, 'dldq', 'duilongdeqi', 'null', '851400'),
(2288, '001026001007', '达孜', '001026001', 297, '中国/西藏/拉萨/达孜', '县', 4, 'dz', 'dazi', 'null', '850100'),
(2289, '001026001008', '墨竹工卡', '001026001', 297, '中国/西藏/拉萨/墨竹工卡', '县', 4, 'mzgk', 'mozhugongka', 'null', '850200'),
(2290, '001026002001', '那曲', '001026002', 298, '中国/西藏/那曲/那曲', '县', 4, 'nq', 'naqu', 'null', '852000'),
(2291, '001026002002', '嘉黎', '001026002', 298, '中国/西藏/那曲/嘉黎', '县', 4, 'jl', 'jiali', 'null', '852400'),
(2292, '001026002003', '比如', '001026002', 298, '中国/西藏/那曲/比如', '县', 4, 'br', 'biru', 'null', '852300'),
(2293, '001026002004', '聂荣', '001026002', 298, '中国/西藏/那曲/聂荣', '县', 4, 'nr', 'nierong', 'null', '853500'),
(2294, '001026002005', '安多', '001026002', 298, '中国/西藏/那曲/安多', '县', 4, 'ad', 'anduo', 'null', '853400'),
(2295, '001026002006', '申扎', '001026002', 298, '中国/西藏/那曲/申扎', '县', 4, 'sz', 'shenzha', 'null', '853100'),
(2296, '001026002007', '索县', '001026002', 298, '中国/西藏/那曲/索县', 'null', 4, 's', 'suo', 'null', '852200'),
(2297, '001026002008', '班戈', '001026002', 298, '中国/西藏/那曲/班戈', '县', 4, 'bg', 'bange', 'null', '852500'),
(2298, '001026002009', '巴青', '001026002', 298, '中国/西藏/那曲/巴青', '县', 4, 'bq', 'baqing', 'null', '852100'),
(2299, '001026002010', '尼玛', '001026002', 298, '中国/西藏/那曲/尼玛', '县', 4, 'nm', 'nima', 'null', '853200'),
(2300, '001026003001', '昌都', '001026003', 299, '中国/西藏/昌都/昌都', '县', 4, 'cd', 'changdu', 'null', '854000'),
(2301, '001026003002', '江达', '001026003', 299, '中国/西藏/昌都/江达', '县', 4, 'jd', 'jiangda', 'null', '854100'),
(2302, '001026003003', '贡觉', '001026003', 299, '中国/西藏/昌都/贡觉', '县', 4, 'gj', 'gongjue', 'null', '854200'),
(2303, '001026003004', '类乌齐', '001026003', 299, '中国/西藏/昌都/类乌齐', '县', 4, 'lwq', 'leiwuqi', 'null', '855600'),
(2304, '001026003005', '丁青', '001026003', 299, '中国/西藏/昌都/丁青', '县', 4, 'dq', 'dingqing', 'null', '855700'),
(2305, '001026003006', '察雅', '001026003', 299, '中国/西藏/昌都/察雅', '县', 4, 'cy', 'chaya', 'null', '854300'),
(2306, '001026003007', '八宿', '001026003', 299, '中国/西藏/昌都/八宿', '县', 4, 'bs', 'basu', 'null', '854600'),
(2307, '001026003008', '左贡', '001026003', 299, '中国/西藏/昌都/左贡', '县', 4, 'zg', 'zuogong', 'null', '854400'),
(2308, '001026003009', '芒康', '001026003', 299, '中国/西藏/昌都/芒康', '县', 4, 'mk', 'mangkang', 'null', '854500'),
(2309, '001026003010', '洛隆', '001026003', 299, '中国/西藏/昌都/洛隆', '县', 4, 'll', 'luolong', 'null', '855400'),
(2310, '001026003011', '边坝', '001026003', 299, '中国/西藏/昌都/边坝', '县', 4, 'bb', 'bianba', 'null', '855500'),
(2311, '001026004001', '乃东', '001026004', 300, '中国/西藏/山南/乃东', '县', 4, 'nd', 'naidong', 'null', '856100'),
(2312, '001026004002', '扎囊', '001026004', 300, '中国/西藏/山南/扎囊', '县', 4, 'zn', 'zhanang', 'null', '850800'),
(2313, '001026004003', '贡嘎', '001026004', 300, '中国/西藏/山南/贡嘎', '县', 4, 'gg', 'gongga', 'null', '850700'),
(2314, '001026004004', '桑日', '001026004', 300, '中国/西藏/山南/桑日', '县', 4, 'sr', 'sangri', 'null', '856200'),
(2315, '001026004005', '琼结', '001026004', 300, '中国/西藏/山南/琼结', '县', 4, 'qj', 'qiongjie', 'null', '856800'),
(2316, '001026004006', '曲松', '001026004', 300, '中国/西藏/山南/曲松', '县', 4, 'qs', 'qusong', 'null', '856300'),
(2317, '001026004007', '措美', '001026004', 300, '中国/西藏/山南/措美', '县', 4, 'cm', 'cuomei', 'null', '856900'),
(2318, '001026004008', '洛扎', '001026004', 300, '中国/西藏/山南/洛扎', '县', 4, 'lz', 'luozha', 'null', '851200'),
(2319, '001026004009', '加查', '001026004', 300, '中国/西藏/山南/加查', '县', 4, 'jc', 'jiacha', 'null', '856400'),
(2320, '001026004010', '隆子', '001026004', 300, '中国/西藏/山南/隆子', '县', 4, 'lz', 'longzi', 'null', '856600'),
(2321, '001026004011', '错那', '001026004', 300, '中国/西藏/山南/错那', '县', 4, 'cn', 'cuona', 'null', '856700'),
(2322, '001026004012', '浪卡子', '001026004', 300, '中国/西藏/山南/浪卡子', '县', 4, 'lkz', 'langkazi', 'null', '851100'),
(2323, '001026005001', '日喀则', '001026005', 301, '中国/西藏/日喀则/日喀则', '市', 4, 'rkz', 'rikaze', 'null', '857000'),
(2324, '001026005002', '南木林', '001026005', 301, '中国/西藏/日喀则/南木林', '县', 4, 'nml', 'nanmulin', 'null', '857100'),
(2325, '001026005003', '江孜', '001026005', 301, '中国/西藏/日喀则/江孜', '县', 4, 'jz', 'jiangzi', 'null', '857400'),
(2326, '001026005004', '定日', '001026005', 301, '中国/西藏/日喀则/定日', '县', 4, 'dr', 'dingri', 'null', '858200'),
(2327, '001026005005', '萨迦', '001026005', 301, '中国/西藏/日喀则/萨迦', '县', 4, 's', 'sa', 'null', '857800'),
(2328, '001026005006', '拉孜', '001026005', 301, '中国/西藏/日喀则/拉孜', '县', 4, 'lz', 'lazi', 'null', '858100'),
(2329, '001026005007', '昂仁', '001026005', 301, '中国/西藏/日喀则/昂仁', '县', 4, 'ar', 'angren', 'null', '858500'),
(2330, '001026005008', '谢通门', '001026005', 301, '中国/西藏/日喀则/谢通门', '县', 4, 'xtm', 'xietongmen', 'null', '858900'),
(2331, '001026005009', '白朗', '001026005', 301, '中国/西藏/日喀则/白朗', '县', 4, 'bl', 'bailang', 'null', '857300'),
(2332, '001026005010', '仁布', '001026005', 301, '中国/西藏/日喀则/仁布', '县', 4, 'rb', 'renbu', 'null', '857200'),
(2333, '001026005011', '康马', '001026005', 301, '中国/西藏/日喀则/康马', '县', 4, 'km', 'kangma', 'null', '857500'),
(2334, '001026005012', '定结', '001026005', 301, '中国/西藏/日喀则/定结', '县', 4, 'dj', 'dingjie', 'null', '857900'),
(2335, '001026005013', '仲巴', '001026005', 301, '中国/西藏/日喀则/仲巴', '县', 4, 'zb', 'zhongba', 'null', '858800'),
(2336, '001026005014', '亚东', '001026005', 301, '中国/西藏/日喀则/亚东', '县', 4, 'yd', 'yadong', 'null', '857600'),
(2337, '001026005015', '吉隆', '001026005', 301, '中国/西藏/日喀则/吉隆', '县', 4, 'jl', 'jilong', 'null', '858700'),
(2338, '001026005016', '聂拉木', '001026005', 301, '中国/西藏/日喀则/聂拉木', '县', 4, 'nlm', 'nielamu', 'null', '858300');
INSERT INTO `des_district` (`serialId`, `districtId`, `districtName`, `districtUpId`, `districtUpIdNum`, `districtPath`, `districtType`, `districtTypeNum`, `shortName`, `spell`, `areaId`, `postCode`) VALUES
(2339, '001026005017', '萨嘎', '001026005', 301, '中国/西藏/日喀则/萨嘎', '县', 4, 'sg', 'saga', 'null', '858600'),
(2340, '001026005018', '岗巴', '001026005', 301, '中国/西藏/日喀则/岗巴', '县', 4, 'gb', 'gangba', 'null', '857700'),
(2341, '001026006001', '噶尔', '001026006', 302, '中国/西藏/阿里/噶尔', '县', 4, 'ge', 'gaer', 'null', '859001'),
(2342, '001026006002', '普兰', '001026006', 302, '中国/西藏/阿里/普兰', '县', 4, 'pl', 'pulan', 'null', '859500'),
(2343, '001026006003', '札达', '001026006', 302, '中国/西藏/阿里/札达', '县', 4, 'zd', 'zhada', 'null', '859600'),
(2344, '001026006004', '日土', '001026006', 302, '中国/西藏/阿里/日土', '县', 4, 'rt', 'ritu', 'null', '859700'),
(2345, '001026006005', '革吉', '001026006', 302, '中国/西藏/阿里/革吉', '县', 4, 'gj', 'geji', 'null', '859100'),
(2346, '001026006006', '改则', '001026006', 302, '中国/西藏/阿里/改则', '县', 4, 'gz', 'gaize', 'null', '859200'),
(2347, '001026006007', '措勤', '001026006', 302, '中国/西藏/阿里/措勤', '县', 4, 'cq', 'cuoqin', 'null', '859300'),
(2348, '001026007001', '林芝', '001026007', 303, '中国/西藏/林芝/林芝', '县', 4, 'lz', 'linzhi', 'null', '860100'),
(2349, '001026007002', '工布江达', '001026007', 303, '中国/西藏/林芝/工布江达', '县', 4, 'gbjd', 'gongbujiang', 'null', '860200'),
(2350, '001026007003', '米林', '001026007', 303, '中国/西藏/林芝/米林', '县', 4, 'ml', 'milin', 'null', '860500'),
(2351, '001026007004', '墨脱', '001026007', 303, '中国/西藏/林芝/墨脱', '县', 4, 'mt', 'motuo', 'null', '860700'),
(2352, '001026007005', '波密', '001026007', 303, '中国/西藏/林芝/波密', '县', 4, 'bm', 'bomi', 'null', '860300'),
(2353, '001026007006', '察隅', '001026007', 303, '中国/西藏/林芝/察隅', '县', 4, 'cy', 'chayu', 'null', '860600'),
(2354, '001026007007', '朗县', '001026007', 303, '中国/西藏/林芝/朗县', 'null', 4, 'l', 'lang', 'null', '860400'),
(2355, '001027001001', '莲湖', '001027001', 304, '中国/陕西/西安/莲湖', '区', 4, 'lh', 'lianhu', 'null', '710003'),
(2356, '001027001002', '新城', '001027001', 304, '中国/陕西/西安/新城', '区', 4, 'xc', 'xincheng', 'null', '710005'),
(2357, '001027001003', '碑林', '001027001', 304, '中国/陕西/西安/碑林', '区', 4, 'bl', 'beilin', 'null', '710001'),
(2358, '001027001004', '灞桥', '001027001', 304, '中国/陕西/西安/灞桥', '区', 4, 'q', 'qiao', 'null', '710038'),
(2359, '001027001005', '未央', '001027001', 304, '中国/陕西/西安/未央', '区', 4, 'wy', 'weiyang', 'null', '710016'),
(2360, '001027001006', '雁塔', '001027001', 304, '中国/陕西/西安/雁塔', '区', 4, 'yt', 'yanta', 'null', '710061'),
(2361, '001027001007', '阎良', '001027001', 304, '中国/陕西/西安/阎良', '区', 4, 'yl', 'yanliang', 'null', '710089'),
(2362, '001027001008', '临潼', '001027001', 304, '中国/陕西/西安/临潼', '区', 4, 'l', 'lin', 'null', '710600'),
(2363, '001027001009', '长安', '001027001', 304, '中国/陕西/西安/长安', '区', 4, 'ca', 'changan', 'null', '710100'),
(2364, '001027001010', '蓝田', '001027001', 304, '中国/陕西/西安/蓝田', '县', 4, 'lt', 'lantian', 'null', '710500'),
(2365, '001027001011', '周至', '001027001', 304, '中国/陕西/西安/周至', '县', 4, 'zz', 'zhouzhi', 'null', '710400'),
(2366, '001027001012', '户县', '001027001', 304, '中国/陕西/西安/户县', 'null', 4, 'h', 'hu', 'null', '710300'),
(2367, '001027001013', '高陵', '001027001', 304, '中国/陕西/西安/高陵', '县', 4, 'gl', 'gaoling', 'null', '710200'),
(2368, '001027002001', '王益', '001027002', 305, '中国/陕西/铜川/王益', '区', 4, 'wy', 'wangyi', 'null', '727000'),
(2369, '001027002002', '印台', '001027002', 305, '中国/陕西/铜川/印台', '区', 4, 'yt', 'yintai', 'null', '727007'),
(2370, '001027002003', '耀州', '001027002', 305, '中国/陕西/铜川/耀州', '区', 4, 'yz', 'yaozhou', 'null', '727100'),
(2371, '001027002004', '宜君', '001027002', 305, '中国/陕西/铜川/宜君', '县', 4, 'yj', 'yijun', 'null', '727200'),
(2372, '001027003001', '渭滨', '001027003', 306, '中国/陕西/宝鸡/渭滨', '区', 4, 'wb', 'weibin', 'null', '721000'),
(2373, '001027003002', '金台', '001027003', 306, '中国/陕西/宝鸡/金台', '区', 4, 'jt', 'jintai', 'null', '721001'),
(2374, '001027003003', '宝鸡', '001027003', 306, '中国/陕西/宝鸡/宝鸡', '县', 4, 'bj', 'baoji', 'null', '721300'),
(2375, '001027003004', '凤翔', '001027003', 306, '中国/陕西/宝鸡/凤翔', '县', 4, 'fx', 'fengxiang', 'null', '721400'),
(2376, '001027003005', '岐山', '001027003', 306, '中国/陕西/宝鸡/岐山', '县', 4, 's', 'shan', 'null', '722400'),
(2377, '001027003006', '扶风', '001027003', 306, '中国/陕西/宝鸡/扶风', '县', 4, 'ff', 'fufeng', 'null', '722200'),
(2378, '001027003007', '眉县', '001027003', 306, '中国/陕西/宝鸡/眉县', 'null', 4, 'm', 'mei', 'null', '722300'),
(2379, '001027003008', '陇县', '001027003', 306, '中国/陕西/宝鸡/陇县', 'null', 4, 'l', 'long', 'null', '721200'),
(2380, '001027003009', '千阳', '001027003', 306, '中国/陕西/宝鸡/千阳', '县', 4, 'qy', 'qianyang', 'null', '721100'),
(2381, '001027003010', '麟游', '001027003', 306, '中国/陕西/宝鸡/麟游', '县', 4, 'y', 'you', 'null', '721500'),
(2382, '001027003011', '凤县', '001027003', 306, '中国/陕西/宝鸡/凤县', 'null', 4, 'f', 'feng', 'null', '721700'),
(2383, '001027003012', '太白', '001027003', 306, '中国/陕西/宝鸡/太白', '县', 4, 'tb', 'taibai', 'null', '721600'),
(2384, '001027004001', '秦都', '001027004', 307, '中国/陕西/咸阳/秦都', '区', 4, 'qd', 'qindu', 'null', '712000'),
(2385, '001027004002', '杨凌', '001027004', 307, '中国/陕西/咸阳/杨凌', '区', 4, 'yl', 'yangling', 'null', '712100'),
(2386, '001027004003', '渭城', '001027004', 307, '中国/陕西/咸阳/渭城', '区', 4, 'wc', 'weicheng', 'null', '712000'),
(2387, '001027004004', '兴平', '001027004', 307, '中国/陕西/咸阳/兴平', '市', 4, 'xp', 'xingping', 'null', '713100'),
(2388, '001027004005', '三原', '001027004', 307, '中国/陕西/咸阳/三原', '县', 4, 'sy', 'sanyuan', 'null', '713800'),
(2389, '001027004006', '泾阳', '001027004', 307, '中国/陕西/咸阳/泾阳', '县', 4, 'y', 'yang', 'null', '713700'),
(2390, '001027004007', '乾县', '001027004', 307, '中国/陕西/咸阳/乾县', 'null', 4, 'q', 'qian', 'null', '713300'),
(2391, '001027004008', '礼泉', '001027004', 307, '中国/陕西/咸阳/礼泉', '县', 4, 'lq', 'liquan', 'null', '713200'),
(2392, '001027004009', '永寿', '001027004', 307, '中国/陕西/咸阳/永寿', '县', 4, 'ys', 'yongshou', 'null', '713400'),
(2393, '001027004010', '彬县', '001027004', 307, '中国/陕西/咸阳/彬县', 'null', 4, 'b', 'bin', 'null', '713500'),
(2394, '001027004011', '长武', '001027004', 307, '中国/陕西/咸阳/长武', '县', 4, 'cw', 'changwu', 'null', '713600'),
(2395, '001027004012', '旬邑', '001027004', 307, '中国/陕西/咸阳/旬邑', '县', 4, 'xy', 'xunyi', 'null', '711300'),
(2396, '001027004013', '淳化', '001027004', 307, '中国/陕西/咸阳/淳化', '县', 4, 'ch', 'chunhua', 'null', '711200'),
(2397, '001027004014', '武功', '001027004', 307, '中国/陕西/咸阳/武功', '县', 4, 'wg', 'wugong', 'null', '712200'),
(2398, '001027005001', '临渭', '001027005', 308, '中国/陕西/渭南/临渭', '区', 4, 'lw', 'linwei', 'null', '714000'),
(2399, '001027005002', '华阴', '001027005', 308, '中国/陕西/渭南/华阴', '市', 4, 'hy', 'huayin', 'null', '714200'),
(2400, '001027005003', '韩城', '001027005', 308, '中国/陕西/渭南/韩城', '市', 4, 'hc', 'hancheng', 'null', '715400'),
(2401, '001027005004', '华县', '001027005', 308, '中国/陕西/渭南/华县', 'null', 4, 'h', 'hua', 'null', '714100'),
(2402, '001027005005', '潼关', '001027005', 308, '中国/陕西/渭南/潼关', '县', 4, 'g', 'guan', 'null', '714300'),
(2403, '001027005006', '大荔', '001027005', 308, '中国/陕西/渭南/大荔', '县', 4, 'dl', 'dali', 'null', '715100'),
(2404, '001027005007', '蒲城', '001027005', 308, '中国/陕西/渭南/蒲城', '县', 4, 'pc', 'pucheng', 'null', '715500'),
(2405, '001027005008', '澄城', '001027005', 308, '中国/陕西/渭南/澄城', '县', 4, 'cc', 'chengcheng', 'null', '715200'),
(2406, '001027005009', '白水', '001027005', 308, '中国/陕西/渭南/白水', '县', 4, 'bs', 'baishui', 'null', '715600'),
(2407, '001027005010', '合阳', '001027005', 308, '中国/陕西/渭南/合阳', '县', 4, 'hy', 'heyang', 'null', '715300'),
(2408, '001027005011', '富平', '001027005', 308, '中国/陕西/渭南/富平', '县', 4, 'fp', 'fuping', 'null', '711700'),
(2409, '001027006001', '宝塔', '001027006', 309, '中国/陕西/延安/宝塔', '区', 4, 'bt', 'baota', 'null', '716000'),
(2410, '001027006002', '延长', '001027006', 309, '中国/陕西/延安/延长', '县', 4, 'yc', 'yanchang', 'null', '717100'),
(2411, '001027006003', '延川', '001027006', 309, '中国/陕西/延安/延川', '县', 4, 'yc', 'yanchuan', 'null', '717200'),
(2412, '001027006004', '子长', '001027006', 309, '中国/陕西/延安/子长', '县', 4, 'zc', 'zichang', 'null', '717300'),
(2413, '001027006005', '安塞', '001027006', 309, '中国/陕西/延安/安塞', '县', 4, 'as', 'ansai', 'null', '717400'),
(2414, '001027006006', '志丹', '001027006', 309, '中国/陕西/延安/志丹', '县', 4, 'zd', 'zhidan', 'null', '717500'),
(2415, '001027006007', '吴旗', '001027006', 309, '中国/陕西/延安/吴旗', '县', 4, 'wq', 'wuqi', 'null', '717600'),
(2416, '001027006008', '甘泉', '001027006', 309, '中国/陕西/延安/甘泉', '县', 4, 'gq', 'ganquan', 'null', '716100'),
(2417, '001027006009', '富县', '001027006', 309, '中国/陕西/延安/富县', 'null', 4, 'f', 'fu', 'null', '727500'),
(2418, '001027006010', '洛川', '001027006', 309, '中国/陕西/延安/洛川', '县', 4, 'lc', 'luochuan', 'null', '727400'),
(2419, '001027006011', '宜川', '001027006', 309, '中国/陕西/延安/宜川', '县', 4, 'yc', 'yichuan', 'null', '716200'),
(2420, '001027006012', '黄龙', '001027006', 309, '中国/陕西/延安/黄龙', '县', 4, 'hl', 'huanglong', 'null', '715700'),
(2421, '001027006013', '黄陵', '001027006', 309, '中国/陕西/延安/黄陵', '县', 4, 'hl', 'huangling', 'null', '727300'),
(2422, '001027007001', '汉台', '001027007', 310, '中国/陕西/汉中/汉台', '区', 4, 'ht', 'hantai', 'null', '723000'),
(2423, '001027007002', '南郑', '001027007', 310, '中国/陕西/汉中/南郑', '县', 4, 'nz', 'nanzheng', 'null', '723100'),
(2424, '001027007003', '城固', '001027007', 310, '中国/陕西/汉中/城固', '县', 4, 'cg', 'chenggu', 'null', '723200'),
(2425, '001027007004', '洋县', '001027007', 310, '中国/陕西/汉中/洋县', 'null', 4, 'y', 'yang', 'null', '723300'),
(2426, '001027007005', '西乡', '001027007', 310, '中国/陕西/汉中/西乡', '县', 4, 'xx', 'xixiang', 'null', '723500'),
(2427, '001027007006', '勉县', '001027007', 310, '中国/陕西/汉中/勉县', 'null', 4, 'm', 'mian', 'null', '724200'),
(2428, '001027007007', '宁强', '001027007', 310, '中国/陕西/汉中/宁强', '县', 4, 'nq', 'ningqiang', 'null', '724400'),
(2429, '001027007008', '略阳', '001027007', 310, '中国/陕西/汉中/略阳', '县', 4, 'ly', 'lueyang', 'null', '724300'),
(2430, '001027007009', '镇巴', '001027007', 310, '中国/陕西/汉中/镇巴', '县', 4, 'zb', 'zhenba', 'null', '723600'),
(2431, '001027007010', '留坝', '001027007', 310, '中国/陕西/汉中/留坝', '县', 4, 'lb', 'liuba', 'null', '724100'),
(2432, '001027007011', '佛坪', '001027007', 310, '中国/陕西/汉中/佛坪', '县', 4, 'fp', 'foping', 'null', '723400'),
(2433, '001027008001', '榆阳', '001027008', 311, '中国/陕西/榆林/榆阳', '区', 4, 'yy', 'yuyang', 'null', '719000'),
(2434, '001027008002', '神木', '001027008', 311, '中国/陕西/榆林/神木', '县', 4, 'sm', 'shenmu', 'null', '719300'),
(2435, '001027008003', '府谷', '001027008', 311, '中国/陕西/榆林/府谷', '县', 4, 'fg', 'fugu', 'null', '719400'),
(2436, '001027008004', '横山', '001027008', 311, '中国/陕西/榆林/横山', '县', 4, 'hs', 'hengshan', 'null', '719200'),
(2437, '001027008005', '靖边', '001027008', 311, '中国/陕西/榆林/靖边', '县', 4, 'jb', 'jingbian', 'null', '718500'),
(2438, '001027008006', '定边', '001027008', 311, '中国/陕西/榆林/定边', '县', 4, 'db', 'dingbian', 'null', '718600'),
(2439, '001027008007', '绥德', '001027008', 311, '中国/陕西/榆林/绥德', '县', 4, 'sd', 'suide', 'null', '718000'),
(2440, '001027008008', '米脂', '001027008', 311, '中国/陕西/榆林/米脂', '县', 4, 'mz', 'mizhi', 'null', '718100'),
(2441, '001027008009', '佳县', '001027008', 311, '中国/陕西/榆林/佳县', 'null', 4, 'j', 'jia', 'null', '719200'),
(2442, '001027008010', '吴堡', '001027008', 311, '中国/陕西/榆林/吴堡', '县', 4, 'wb', 'wubao', 'null', '718200'),
(2443, '001027008011', '清涧', '001027008', 311, '中国/陕西/榆林/清涧', '县', 4, 'qj', 'qingjian', 'null', '718300'),
(2444, '001027008012', '子洲', '001027008', 311, '中国/陕西/榆林/子洲', '县', 4, 'zz', 'zizhou', 'null', '718400'),
(2445, '001027009001', '汉滨', '001027009', 312, '中国/陕西/安康/汉滨', '区', 4, 'hb', 'hanbin', 'null', '725000'),
(2446, '001027009002', '汉阴', '001027009', 312, '中国/陕西/安康/汉阴', '县', 4, 'hy', 'hanyin', 'null', '725100'),
(2447, '001027009003', '石泉', '001027009', 312, '中国/陕西/安康/石泉', '县', 4, 'sq', 'shiquan', 'null', '725200'),
(2448, '001027009004', '宁陕', '001027009', 312, '中国/陕西/安康/宁陕', '县', 4, 'ns', 'ningshan', 'null', '711600'),
(2449, '001027009005', '紫阳', '001027009', 312, '中国/陕西/安康/紫阳', '县', 4, 'zy', 'ziyang', 'null', '725300'),
(2450, '001027009006', '岚皋', '001027009', 312, '中国/陕西/安康/岚皋', '县', 4, 'g', 'gao', 'null', '725400'),
(2451, '001027009007', '平利', '001027009', 312, '中国/陕西/安康/平利', '县', 4, 'pl', 'pingli', 'null', '725500'),
(2452, '001027009008', '镇坪', '001027009', 312, '中国/陕西/安康/镇坪', '县', 4, 'zp', 'zhenping', 'null', '725600'),
(2453, '001027009009', '旬阳', '001027009', 312, '中国/陕西/安康/旬阳', '县', 4, 'xy', 'xunyang', 'null', '725700'),
(2454, '001027009010', '白河', '001027009', 312, '中国/陕西/安康/白河', '县', 4, 'bh', 'baihe', 'null', '725800'),
(2455, '001027010001', '商州', '001027010', 313, '中国/陕西/商洛/商州', '区', 4, 'sz', 'shangzhou', 'null', '726000'),
(2456, '001027010002', '洛南', '001027010', 313, '中国/陕西/商洛/洛南', '县', 4, 'ln', 'luonan', 'null', '726100'),
(2457, '001027010003', '丹凤', '001027010', 313, '中国/陕西/商洛/丹凤', '县', 4, 'df', 'danfeng', 'null', '726200'),
(2458, '001027010004', '商南', '001027010', 313, '中国/陕西/商洛/商南', '县', 4, 'sn', 'shangnan', 'null', '726300'),
(2459, '001027010005', '山阳', '001027010', 313, '中国/陕西/商洛/山阳', '县', 4, 'sy', 'shanyang', 'null', '726400'),
(2460, '001027010006', '镇安', '001027010', 313, '中国/陕西/商洛/镇安', '县', 4, 'za', 'zhenan', 'null', '711500'),
(2461, '001027010007', '柞水', '001027010', 313, '中国/陕西/商洛/柞水', '县', 4, 'zs', 'zuoshui', 'null', '711400'),
(2462, '001028001001', '城关', '001028001', 314, '中国/甘肃/兰州/城关', '区', 4, 'cg', 'chengguan', 'null', '730030'),
(2463, '001028001002', '七里河', '001028001', 314, '中国/甘肃/兰州/七里河', '区', 4, 'qlh', 'qilihe', 'null', '730050'),
(2464, '001028001003', '西固', '001028001', 314, '中国/甘肃/兰州/西固', '区', 4, 'xg', 'xigu', 'null', '730060'),
(2465, '001028001004', '安宁', '001028001', 314, '中国/甘肃/兰州/安宁', '区', 4, 'an', 'anning', 'null', '730070'),
(2466, '001028001005', '红古', '001028001', 314, '中国/甘肃/兰州/红古', '区', 4, 'hg', 'honggu', 'null', '730080'),
(2467, '001028001006', '永登', '001028001', 314, '中国/甘肃/兰州/永登', '县', 4, 'yd', 'yongdeng', 'null', '730300'),
(2468, '001028001007', '皋兰', '001028001', 314, '中国/甘肃/兰州/皋兰', '县', 4, 'gl', 'gaolan', 'null', '730200'),
(2469, '001028001008', '榆中', '001028001', 314, '中国/甘肃/兰州/榆中', '县', 4, 'yz', 'yuzhong', 'null', '730100'),
(2470, '001028002001', '金川', '001028002', 315, '中国/甘肃/金昌/金川', '区', 4, 'jc', 'jinchuan', 'null', '737103'),
(2471, '001028002002', '永昌', '001028002', 315, '中国/甘肃/金昌/永昌', '县', 4, 'yc', 'yongchang', 'null', '737200'),
(2472, '001028003001', '白银', '001028003', 316, '中国/甘肃/白银/白银', '区', 4, 'by', 'baiyin', 'null', '730900'),
(2473, '001028003002', '平川', '001028003', 316, '中国/甘肃/白银/平川', '区', 4, 'pc', 'pingchuan', 'null', '730913'),
(2474, '001028003003', '靖远', '001028003', 316, '中国/甘肃/白银/靖远', '县', 4, 'jy', 'jingyuan', 'null', '730600'),
(2475, '001028003004', '会宁', '001028003', 316, '中国/甘肃/白银/会宁', '县', 4, 'hn', 'huining', 'null', '730700'),
(2476, '001028003005', '景泰', '001028003', 316, '中国/甘肃/白银/景泰', '县', 4, 'jt', 'jingtai', 'null', '730400'),
(2477, '001028004001', '秦城', '001028004', 317, '中国/甘肃/天水/秦城', '区', 4, 'qc', 'qincheng', 'null', '741000'),
(2478, '001028004002', '北道', '001028004', 317, '中国/甘肃/天水/北道', '区', 4, 'bd', 'beidao', 'null', '741020'),
(2479, '001028004003', '清水', '001028004', 317, '中国/甘肃/天水/清水', '县', 4, 'qs', 'qingshui', 'null', '741400'),
(2480, '001028004004', '秦安', '001028004', 317, '中国/甘肃/天水/秦安', '县', 4, 'qa', 'qinan', 'null', '741600'),
(2481, '001028004005', '甘谷', '001028004', 317, '中国/甘肃/天水/甘谷', '县', 4, 'gg', 'gangu', 'null', '741200'),
(2482, '001028004006', '武山', '001028004', 317, '中国/甘肃/天水/武山', '县', 4, 'ws', 'wushan', 'null', '741300'),
(2483, '001028004007', '张家川', '001028004', 317, '中国/甘肃/天水/张家川', '回族自治县', 4, 'zjczz', 'zhangjiachu', 'null', '741500'),
(2484, '001028006001', '凉州', '001028006', 319, '中国/甘肃/武威/凉州', '区', 4, 'lz', 'liangzhou', 'null', '733000'),
(2485, '001028006002', '民勤', '001028006', 319, '中国/甘肃/武威/民勤', '县', 4, 'mq', 'minqin', 'null', '733300'),
(2486, '001028006003', '古浪', '001028006', 319, '中国/甘肃/武威/古浪', '县', 4, 'gl', 'gulang', 'null', '733100'),
(2487, '001028006004', '天祝', '001028006', 319, '中国/甘肃/武威/天祝', '藏族自治县', 4, 'tzczzz', 'tianzhucang', 'null', '733200'),
(2488, '001028007001', '甘州', '001028007', 320, '中国/甘肃/张掖/甘州', '区', 4, 'gz', 'ganzhou', 'null', '734000'),
(2489, '001028007002', '民乐', '001028007', 320, '中国/甘肃/张掖/民乐', '县', 4, 'ml', 'minle', 'null', '734500'),
(2490, '001028007003', '临泽', '001028007', 320, '中国/甘肃/张掖/临泽', '县', 4, 'lz', 'linze', 'null', '734200'),
(2491, '001028007004', '高台', '001028007', 320, '中国/甘肃/张掖/高台', '县', 4, 'gt', 'gaotai', 'null', '734300'),
(2492, '001028007005', '山丹', '001028007', 320, '中国/甘肃/张掖/山丹', '县', 4, 'sd', 'shandan', 'null', '734100'),
(2493, '001028007006', '肃南', '001028007', 320, '中国/甘肃/张掖/肃南', '裕固族自治县', 4, 'snygzzz', 'sunanyuguzu', 'null', '734400'),
(2494, '001028008001', '崆峒', '001028008', 321, '中国/甘肃/平凉/崆峒', '区', 4, 'null', 'null', 'null', '744000'),
(2495, '001028008002', '泾川', '001028008', 321, '中国/甘肃/平凉/泾川', '县', 4, 'c', 'chuan', 'null', '744300'),
(2496, '001028008003', '灵台', '001028008', 321, '中国/甘肃/平凉/灵台', '县', 4, 'lt', 'lingtai', 'null', '744400'),
(2497, '001028008004', '崇信', '001028008', 321, '中国/甘肃/平凉/崇信', '县', 4, 'cx', 'chongxin', 'null', '744200'),
(2498, '001028008005', '华亭', '001028008', 321, '中国/甘肃/平凉/华亭', '县', 4, 'ht', 'huating', 'null', '744100'),
(2499, '001028008006', '庄浪', '001028008', 321, '中国/甘肃/平凉/庄浪', '县', 4, 'zl', 'zhuanglang', 'null', '744600'),
(2500, '001028008007', '静宁', '001028008', 321, '中国/甘肃/平凉/静宁', '县', 4, 'jn', 'jingning', 'null', '743400'),
(2501, '001028009001', '肃州', '001028009', 322, '中国/甘肃/酒泉/肃州', '区', 4, 'sz', 'suzhou', 'null', '735000'),
(2502, '001028009002', '玉门', '001028009', 322, '中国/甘肃/酒泉/玉门', '市', 4, 'ym', 'yumen', 'null', '735200'),
(2503, '001028009003', '敦煌', '001028009', 322, '中国/甘肃/酒泉/敦煌', '市', 4, 'dh', 'dunhuang', 'null', '736200'),
(2504, '001028009004', '金塔', '001028009', 322, '中国/甘肃/酒泉/金塔', '县', 4, 'jt', 'jinta', 'null', '735300'),
(2505, '001028009005', '安西', '001028009', 322, '中国/甘肃/酒泉/安西', '县', 4, 'ax', 'anxi', 'null', '736100'),
(2506, '001028009006', '肃北', '001028009', 322, '中国/甘肃/酒泉/肃北', '蒙古族自治县', 4, 'sbmgzzz', 'subeimenggu', 'null', '736300'),
(2507, '001028009007', '阿克塞', '001028009', 322, '中国/甘肃/酒泉/阿克塞', '哈萨克族自治县', 4, 'akshskzzz', 'akesaihasak', 'null', '736400'),
(2508, '001028010001', '西峰', '001028010', 323, '中国/甘肃/庆阳/西峰', '区', 4, 'xf', 'xifeng', 'null', '745000'),
(2509, '001028010002', '庆城', '001028010', 323, '中国/甘肃/庆阳/庆城', '县', 4, 'qc', 'qingcheng', 'null', '745100'),
(2510, '001028010003', '环县', '001028010', 323, '中国/甘肃/庆阳/环县', 'null', 4, 'h', 'huan', 'null', '745700'),
(2511, '001028010004', '华池', '001028010', 323, '中国/甘肃/庆阳/华池', '县', 4, 'hc', 'huachi', 'null', '745600'),
(2512, '001028010005', '合水', '001028010', 323, '中国/甘肃/庆阳/合水', '县', 4, 'hs', 'heshui', 'null', '745400'),
(2513, '001028010006', '正宁', '001028010', 323, '中国/甘肃/庆阳/正宁', '县', 4, 'zn', 'zhengning', 'null', '745300'),
(2514, '001028010007', '宁县', '001028010', 323, '中国/甘肃/庆阳/宁县', 'null', 4, 'n', 'ning', 'null', '745200'),
(2515, '001028010008', '镇原', '001028010', 323, '中国/甘肃/庆阳/镇原', '县', 4, 'zy', 'zhenyuan', 'null', '744500'),
(2516, '001028011001', '定西', '001028011', 324, '中国/甘肃/定西/定西', '县', 4, 'dx', 'dingxi', 'null', '744300'),
(2517, '001028011002', '通渭', '001028011', 324, '中国/甘肃/定西/通渭', '县', 4, 'tw', 'tongwei', 'null', '743300'),
(2518, '001028011003', '临洮', '001028011', 324, '中国/甘肃/定西/临洮', '县', 4, 'l', 'lin', 'null', '730500'),
(2519, '001028011004', '漳县', '001028011', 324, '中国/甘肃/定西/漳县', 'null', 4, 'z', 'zhang', 'null', '748300'),
(2520, '001028011005', '岷县', '001028011', 324, '中国/甘肃/定西/岷县', 'null', 4, 'null', 'null', 'null', '748400'),
(2521, '001028011006', '渭源', '001028011', 324, '中国/甘肃/定西/渭源', '县', 4, 'wy', 'weiyuan', 'null', '748200'),
(2522, '001028011007', '陇西', '001028011', 324, '中国/甘肃/定西/陇西', '县', 4, 'lx', 'longxi', 'null', '748100'),
(2523, '001028012001', '成县', '001028012', 325, '中国/甘肃/陇南/成县', 'null', 4, 'c', 'cheng', 'null', '742500'),
(2524, '001028012002', '武都', '001028012', 325, '中国/甘肃/陇南/武都', '县', 4, 'wd', 'wudu', 'null', '746000'),
(2525, '001028012003', '宕昌', '001028012', 325, '中国/甘肃/陇南/宕昌', '县', 4, 'c', 'chang', 'null', '748500'),
(2526, '001028012004', '康县', '001028012', 325, '中国/甘肃/陇南/康县', 'null', 4, 'k', 'kang', 'null', '746500'),
(2527, '001028012005', '文县', '001028012', 325, '中国/甘肃/陇南/文县', 'null', 4, 'w', 'wen', 'null', '746400'),
(2528, '001028012006', '西和', '001028012', 325, '中国/甘肃/陇南/西和', '县', 4, 'xh', 'xihe', 'null', '742100'),
(2529, '001028012007', '礼县', '001028012', 325, '中国/甘肃/陇南/礼县', 'null', 4, 'l', 'li', 'null', '742200'),
(2530, '001028012008', '两当', '001028012', 325, '中国/甘肃/陇南/两当', '县', 4, 'ld', 'liangdang', 'null', '742400'),
(2531, '001028012009', '徽县', '001028012', 325, '中国/甘肃/陇南/徽县', 'null', 4, 'h', 'hui', 'null', '742300'),
(2532, '001028013001', '合作', '001028013', 326, '中国/甘肃/甘南/合作', '市', 4, 'hz', 'hezuo', 'null', '747000'),
(2533, '001028013002', '临潭', '001028013', 326, '中国/甘肃/甘南/临潭', '县', 4, 'lt', 'lintan', 'null', '747500'),
(2534, '001028013003', '卓尼', '001028013', 326, '中国/甘肃/甘南/卓尼', '县', 4, 'zn', 'zhuoni', 'null', '747600'),
(2535, '001028013004', '舟曲', '001028013', 326, '中国/甘肃/甘南/舟曲', '县', 4, 'zq', 'zhouqu', 'null', '746300'),
(2536, '001028013005', '迭部', '001028013', 326, '中国/甘肃/甘南/迭部', '县', 4, 'db', 'diebu', 'null', '747400'),
(2537, '001028013006', '玛曲', '001028013', 326, '中国/甘肃/甘南/玛曲', '县', 4, 'mq', 'maqu', 'null', '747300'),
(2538, '001028013007', '碌曲', '001028013', 326, '中国/甘肃/甘南/碌曲', '县', 4, 'lq', 'luqu', 'null', '747200'),
(2539, '001028013008', '夏河', '001028013', 326, '中国/甘肃/甘南/夏河', '县', 4, 'xh', 'xiahe', 'null', '747100'),
(2540, '001028014001', '临夏', '001028014', 327, '中国/甘肃/临夏/临夏', '市', 4, 'lx', 'linxia', 'null', '731100'),
(2541, '001028014002', '临夏', '001028014', 327, '中国/甘肃/临夏/临夏', '县', 4, 'lx', 'linxia', 'null', '731800'),
(2542, '001028014003', '康乐', '001028014', 327, '中国/甘肃/临夏/康乐', '县', 4, 'kl', 'kangle', 'null', '731500'),
(2543, '001028014004', '永靖', '001028014', 327, '中国/甘肃/临夏/永靖', '县', 4, 'yj', 'yongjing', 'null', '731600'),
(2544, '001028014005', '广河', '001028014', 327, '中国/甘肃/临夏/广河', '县', 4, 'gh', 'guanghe', 'null', '731300'),
(2545, '001028014006', '和政', '001028014', 327, '中国/甘肃/临夏/和政', '县', 4, 'hz', 'hezheng', 'null', '731200'),
(2546, '001028014007', '东乡族自治县', '001028014', 327, '中国/甘肃/临夏/东乡族自治县', 'null', 4, 'dxzzz', 'dongxiangzu', 'null', '731400'),
(2547, '001028014008', '积石山', '001028014', 327, '中国/甘肃/临夏/积石山', '保安族东乡族撒拉族自治县', 4, 'jssbazdxzsl', 'jishishanba', 'null', '731700'),
(2548, '001029001001', '城中', '001029001', 328, '中国/青海/西宁/城中', '区', 4, 'cz', 'chengzhong', 'null', '810000'),
(2549, '001029001002', '城东', '001029001', 328, '中国/青海/西宁/城东', '区', 4, 'cd', 'chengdong', 'null', '810000'),
(2550, '001029001003', '城西', '001029001', 328, '中国/青海/西宁/城西', '区', 4, 'cx', 'chengxi', 'null', '810001'),
(2551, '001029001004', '城北', '001029001', 328, '中国/青海/西宁/城北', '区', 4, 'cb', 'chengbei', 'null', '810001'),
(2552, '001029001005', '大通', '001029001', 328, '中国/青海/西宁/大通', '回族土族自治县', 4, 'dttzzz', 'datongtuzuz', 'null', '810100'),
(2553, '001029001006', '湟源', '001029001', 328, '中国/青海/西宁/湟源', '县', 4, 'y', 'yuan', 'null', '812100'),
(2554, '001029001007', '湟中', '001029001', 328, '中国/青海/西宁/湟中', '县', 4, 'z', 'zhong', 'null', '811600'),
(2555, '001029002001', '平安', '001029002', 329, '中国/青海/海东/平安', '县', 4, 'pa', 'pingan', 'null', '810600'),
(2556, '001029002002', '乐都', '001029002', 329, '中国/青海/海东/乐都', '县', 4, 'ld', 'ledu', 'null', '810700'),
(2557, '001029002003', '民和', '001029002', 329, '中国/青海/海东/民和', '回族土族自治县', 4, 'mhtzzz', 'minhetuzuzi', 'null', '810800'),
(2558, '001029002004', '互助', '001029002', 329, '中国/青海/海东/互助', '土族自治县', 4, 'hztzzz', 'huzhutuzuzi', 'null', '810500'),
(2559, '001029002005', '化隆', '001029002', 329, '中国/青海/海东/化隆', '回族自治县', 4, 'hlzz', 'hualongzizh', 'null', '810900'),
(2560, '001029002006', '循化', '001029002', 329, '中国/青海/海东/循化', '撒拉族自治县', 4, 'xhslzzz', 'xunhuasalaz', 'null', '811100'),
(2561, '001029003001', '海晏', '001029003', 330, '中国/青海/海北/海晏', '县', 4, 'h', 'hai', 'null', '812200'),
(2562, '001029003002', '祁连', '001029003', 330, '中国/青海/海北/祁连', '县', 4, 'ql', 'qilian', 'null', '810400'),
(2563, '001029003003', '刚察', '001029003', 330, '中国/青海/海北/刚察', '县', 4, 'gc', 'gangcha', 'null', '812300'),
(2564, '001029003004', '门源', '001029003', 330, '中国/青海/海北/门源', '回族自治县', 4, 'myzz', 'menyuanzizh', 'null', '810300'),
(2565, '001029004001', '同仁', '001029004', 331, '中国/青海/黄南/同仁', '县', 4, 'tr', 'tongren', 'null', '811300'),
(2566, '001029004002', '尖扎', '001029004', 331, '中国/青海/黄南/尖扎', '县', 4, 'jz', 'jianzha', 'null', '811200'),
(2567, '001029004003', '泽库', '001029004', 331, '中国/青海/黄南/泽库', '县', 4, 'zk', 'zeku', 'null', '811400'),
(2568, '001029004004', '河南', '001029004', 331, '中国/青海/黄南/河南', '蒙古族自治县', 4, 'hnmgzzz', 'henanmenggu', 'null', '811500'),
(2569, '001029005001', '共和', '001029005', 332, '中国/青海/海南/共和', '县', 4, 'gh', 'gonghe', 'null', '813000'),
(2570, '001029005002', '同德', '001029005', 332, '中国/青海/海南/同德', '县', 4, 'td', 'tongde', 'null', '813200'),
(2571, '001029005003', '贵德', '001029005', 332, '中国/青海/海南/贵德', '县', 4, 'gd', 'guide', 'null', '811700'),
(2572, '001029005004', '兴海', '001029005', 332, '中国/青海/海南/兴海', '县', 4, 'xh', 'xinghai', 'null', '813300'),
(2573, '001029005005', '贵南', '001029005', 332, '中国/青海/海南/贵南', '县', 4, 'gn', 'guinan', 'null', '813100'),
(2574, '001029006001', '玛沁', '001029006', 333, '中国/青海/果洛/玛沁', '县', 4, 'mq', 'maqin', 'null', '814000'),
(2575, '001029006002', '班玛', '001029006', 333, '中国/青海/果洛/班玛', '县', 4, 'bm', 'banma', 'null', '814300'),
(2576, '001029006003', '甘德', '001029006', 333, '中国/青海/果洛/甘德', '县', 4, 'gd', 'gande', 'null', '814100'),
(2577, '001029006004', '达日', '001029006', 333, '中国/青海/果洛/达日', '县', 4, 'dr', 'dari', 'null', '814200'),
(2578, '001029006005', '久治', '001029006', 333, '中国/青海/果洛/久治', '县', 4, 'jz', 'jiuzhi', 'null', '624700'),
(2579, '001029006006', '玛多', '001029006', 333, '中国/青海/果洛/玛多', '县', 4, 'md', 'maduo', 'null', '813500'),
(2580, '001029007001', '玉树', '001029007', 334, '中国/青海/玉树/玉树', '县', 4, 'ys', 'yushu', 'null', '815000'),
(2581, '001029007002', '杂多', '001029007', 334, '中国/青海/玉树/杂多', '县', 4, 'zd', 'zaduo', 'null', '815300'),
(2582, '001029007003', '称多', '001029007', 334, '中国/青海/玉树/称多', '县', 4, 'cd', 'chengduo', 'null', '815100'),
(2583, '001029007004', '治多', '001029007', 334, '中国/青海/玉树/治多', '县', 4, 'zd', 'zhiduo', 'null', '815400'),
(2584, '001029007005', '囊谦', '001029007', 334, '中国/青海/玉树/囊谦', '县', 4, 'nq', 'nangqian', 'null', '815200'),
(2585, '001029007006', '曲麻莱', '001029007', 334, '中国/青海/玉树/曲麻莱', '县', 4, 'qml', 'qumalai', 'null', '815500'),
(2586, '001029008001', '德令哈', '001029008', 335, '中国/青海/海西/德令哈', '市', 4, 'dlh', 'delingha', 'null', '817000'),
(2587, '001029008002', '格尔木', '001029008', 335, '中国/青海/海西/格尔木', '市', 4, 'gem', 'geermu', 'null', '816000'),
(2588, '001029008003', '乌兰', '001029008', 335, '中国/青海/海西/乌兰', '县', 4, 'wl', 'wulan', 'null', '817100'),
(2589, '001029008004', '都兰', '001029008', 335, '中国/青海/海西/都兰', '县', 4, 'dl', 'dulan', 'null', '816100'),
(2590, '001029008005', '天峻', '001029008', 335, '中国/青海/海西/天峻', '县', 4, 'tj', 'tianjun', 'null', '817200'),
(2591, '001030001001', '西夏', '001030001', 336, '中国/宁夏/银川/西夏', '区', 4, 'xx', 'xixia', 'null', '751400'),
(2592, '001030001002', '贺兰', '001030001', 336, '中国/宁夏/银川/贺兰', '县', 4, 'hl', 'helan', 'null', '750200'),
(2593, '001030001004', '新城', '001030001', 336, '中国/宁夏/银川/新城', '区', 4, 'xc', 'xincheng', 'null', '750011'),
(2594, '001030001005', '郊区', '001030001', 336, '中国/宁夏/银川/郊区', 'null', 4, 'j', 'jiao', 'null', '750002'),
(2595, '001030002001', '大武口', '001030002', 337, '中国/宁夏/石嘴山/大武口', '区', 4, 'dwk', 'dawukou', 'null', '753000'),
(2596, '001030002002', '石嘴山', '001030002', 337, '中国/宁夏/石嘴山/石嘴山', '区', 4, 'szs', 'shizuishan', 'null', '753200'),
(2597, '001030002003', '平罗', '001030002', 337, '中国/宁夏/石嘴山/平罗', '县', 4, 'pl', 'pingluo', 'null', '753400'),
(2598, '001030002004', '陶乐', '001030002', 337, '中国/宁夏/石嘴山/陶乐', '县', 4, 'tl', 'taole', 'null', '753500'),
(2599, '001030002005', '惠农', '001030002', 337, '中国/宁夏/石嘴山/惠农', '县', 4, 'hn', 'huinong', 'null', '753600'),
(2600, '001030003001', '利通', '001030003', 338, '中国/宁夏/吴忠/利通', '区', 4, 'lt', 'litong', 'null', '751100'),
(2601, '001030003002', '青铜峡', '001030003', 338, '中国/宁夏/吴忠/青铜峡', '市', 4, 'qtx', 'qingtongxia', 'null', '751600'),
(2602, '001030003003', '中卫', '001030003', 338, '中国/宁夏/吴忠/中卫', '县', 4, 'zw', 'zhongwei', 'null', '751700'),
(2603, '001030003004', '中宁', '001030003', 338, '中国/宁夏/吴忠/中宁', '县', 4, 'zn', 'zhongning', 'null', '751200'),
(2604, '001030003005', '盐池', '001030003', 338, '中国/宁夏/吴忠/盐池', '县', 4, 'yc', 'yanchi', 'null', '751500'),
(2605, '001030003006', '同心', '001030003', 338, '中国/宁夏/吴忠/同心', '县', 4, 'tx', 'tongxin', 'null', '751300'),
(2606, '001030004001', '原州', '001030004', 339, '中国/宁夏/固原/原州', '区', 4, 'yz', 'yuanzhou', 'null', '756000'),
(2607, '001030004002', '海原', '001030004', 339, '中国/宁夏/固原/海原', '县', 4, 'hy', 'haiyuan', 'null', '751800'),
(2608, '001030004003', '西吉', '001030004', 339, '中国/宁夏/固原/西吉', '县', 4, 'xj', 'xiji', 'null', '756200'),
(2609, '001030004004', '隆德', '001030004', 339, '中国/宁夏/固原/隆德', '县', 4, 'ld', 'longde', 'null', '756300'),
(2610, '001030004005', '泾源', '001030004', 339, '中国/宁夏/固原/泾源', '县', 4, 'y', 'yuan', 'null', '756400'),
(2611, '001030004006', '彭阳', '001030004', 339, '中国/宁夏/固原/彭阳', '县', 4, 'py', 'pengyang', 'null', '756500'),
(2612, '001031001001', '天山', '001031001', 340, '中国/新疆/乌鲁木齐/天山', '区', 4, 'ts', 'tianshan', 'null', '830002'),
(2613, '001031001002', '沙依巴克', '001031001', 340, '中国/新疆/乌鲁木齐/沙依巴克', '区', 4, 'sybk', 'shayibake', 'null', '830000'),
(2614, '001031001003', '新市', '001031001', 340, '中国/新疆/乌鲁木齐/新市', '区', 4, 'x', 'xin', 'null', '830011'),
(2615, '001031001004', '水磨沟', '001031001', 340, '中国/新疆/乌鲁木齐/水磨沟', '区', 4, 'smg', 'shuimogou', 'null', '830017'),
(2616, '001031001005', '头屯河', '001031001', 340, '中国/新疆/乌鲁木齐/头屯河', '区', 4, 'tth', 'toutunhe', 'null', '830023'),
(2617, '001031001006', '达坂城', '001031001', 340, '中国/新疆/乌鲁木齐/达坂城', '区', 4, 'dc', 'dacheng', 'null', '830019'),
(2618, '001031001007', '乌鲁木齐', '001031001', 340, '中国/新疆/乌鲁木齐/乌鲁木齐', '县', 4, 'wlmq', 'wulumuqi', 'null', '830002'),
(2619, '001031002001', '克拉玛依', '001031002', 341, '中国/新疆/克拉玛依/克拉玛依', '区', 4, 'klmy', 'kelamayi', 'null', '834018'),
(2620, '001031002002', '独山子', '001031002', 341, '中国/新疆/克拉玛依/独山子', '区', 4, 'dsz', 'dushanzi', 'null', '838600'),
(2621, '001031002003', '白碱滩', '001031002', 341, '中国/新疆/克拉玛依/白碱滩', '区', 4, 'bjt', 'baijiantan', 'null', '834009'),
(2622, '001031002004', '乌尔禾', '001031002', 341, '中国/新疆/克拉玛依/乌尔禾', '区', 4, 'weh', 'wuerhe', 'null', '834014'),
(2623, '001031004001', '吐鲁番', '001031004', 343, '中国/新疆/吐鲁番/吐鲁番', '市', 4, 'tlf', 'tulufan', 'null', '838000'),
(2624, '001031004002', '鄯善', '001031004', 343, '中国/新疆/吐鲁番/鄯善', '县', 4, 's', 'shan', 'null', '838200'),
(2625, '001031004003', '托克逊', '001031004', 343, '中国/新疆/吐鲁番/托克逊', '县', 4, 'tkx', 'tuokexun', 'null', '838100'),
(2626, '001031005001', '哈密', '001031005', 344, '中国/新疆/哈密/哈密', '市', 4, 'hm', 'hami', 'null', '839000'),
(2627, '001031005002', '伊吾', '001031005', 344, '中国/新疆/哈密/伊吾', '县', 4, 'yw', 'yiwu', 'null', '839300'),
(2628, '001031005003', '巴里坤', '001031005', 344, '中国/新疆/哈密/巴里坤', '哈萨克自治县', 4, 'blkhskzz', 'balikunhasa', 'null', '839200'),
(2629, '001031006001', '和田', '001031006', 345, '中国/新疆/和田/和田', '市', 4, 'ht', 'hetian', 'null', '848000'),
(2630, '001031006002', '和田', '001031006', 345, '中国/新疆/和田/和田', '县', 4, 'ht', 'hetian', 'null', '848000'),
(2631, '001031006003', '墨玉', '001031006', 345, '中国/新疆/和田/墨玉', '县', 4, 'my', 'moyu', 'null', '848100'),
(2632, '001031006004', '皮山', '001031006', 345, '中国/新疆/和田/皮山', '县', 4, 'ps', 'pishan', 'null', '845150'),
(2633, '001031006005', '洛浦', '001031006', 345, '中国/新疆/和田/洛浦', '县', 4, 'lp', 'luopu', 'null', '848200'),
(2634, '001031006006', '策勒', '001031006', 345, '中国/新疆/和田/策勒', '县', 4, 'cl', 'cele', 'null', '848300'),
(2635, '001031006007', '于田', '001031006', 345, '中国/新疆/和田/于田', '县', 4, 'yt', 'yutian', 'null', '848400'),
(2636, '001031006008', '民丰', '001031006', 345, '中国/新疆/和田/民丰', '县', 4, 'mf', 'minfeng', 'null', '848500'),
(2637, '001031007001', '阿克苏', '001031007', 346, '中国/新疆/阿克苏/阿克苏', '市', 4, 'aks', 'akesu', 'null', '843000'),
(2638, '001031007002', '温宿', '001031007', 346, '中国/新疆/阿克苏/温宿', '县', 4, 'ws', 'wensu', 'null', '843100'),
(2639, '001031007003', '库车', '001031007', 346, '中国/新疆/阿克苏/库车', '县', 4, 'kc', 'kuche', 'null', '842000'),
(2640, '001031007004', '沙雅', '001031007', 346, '中国/新疆/阿克苏/沙雅', '县', 4, 'sy', 'shaya', 'null', '842200'),
(2641, '001031007005', '新和', '001031007', 346, '中国/新疆/阿克苏/新和', '县', 4, 'xh', 'xinhe', 'null', '842100'),
(2642, '001031007006', '拜城', '001031007', 346, '中国/新疆/阿克苏/拜城', '县', 4, 'bc', 'baicheng', 'null', '842300'),
(2643, '001031007007', '乌什', '001031007', 346, '中国/新疆/阿克苏/乌什', '县', 4, 'ws', 'wushi', 'null', '843400'),
(2644, '001031007008', '阿瓦提', '001031007', 346, '中国/新疆/阿克苏/阿瓦提', '县', 4, 'awt', 'awati', 'null', '843200'),
(2645, '001031007009', '柯坪', '001031007', 346, '中国/新疆/阿克苏/柯坪', '县', 4, 'kp', 'keping', 'null', '843600'),
(2646, '001031008001', '喀什', '001031008', 347, '中国/新疆/喀什/喀什', '市', 4, 'ks', 'kashi', 'null', '844000'),
(2647, '001031008002', '疏附', '001031008', 347, '中国/新疆/喀什/疏附', '县', 4, 'sf', 'shufu', 'null', '844100'),
(2648, '001031008003', '疏勒', '001031008', 347, '中国/新疆/喀什/疏勒', '县', 4, 'sl', 'shule', 'null', '844200'),
(2649, '001031008004', '英吉沙', '001031008', 347, '中国/新疆/喀什/英吉沙', '县', 4, 'yjs', 'yingjisha', 'null', '844500'),
(2650, '001031008005', '泽普', '001031008', 347, '中国/新疆/喀什/泽普', '县', 4, 'zp', 'zepu', 'null', '844800'),
(2651, '001031008006', '莎车', '001031008', 347, '中国/新疆/喀什/莎车', '县', 4, 'sc', 'shache', 'null', '844700'),
(2652, '001031008007', '叶城', '001031008', 347, '中国/新疆/喀什/叶城', '县', 4, 'yc', 'yecheng', 'null', '844900'),
(2653, '001031008008', '麦盖提', '001031008', 347, '中国/新疆/喀什/麦盖提', '县', 4, 'mgt', 'maigaiti', 'null', '844600'),
(2654, '001031008009', '岳普湖', '001031008', 347, '中国/新疆/喀什/岳普湖', '县', 4, 'yph', 'yuepuhu', 'null', '844400'),
(2655, '001031008010', '伽师', '001031008', 347, '中国/新疆/喀什/伽师', '县', 4, 's', 'shi', 'null', '844300'),
(2656, '001031008011', '巴楚', '001031008', 347, '中国/新疆/喀什/巴楚', '县', 4, 'bc', 'bachu', 'null', '843800'),
(2657, '001031008012', '塔什库尔干塔吉克', '001031008', 347, '中国/新疆/喀什/塔什库尔干塔吉克', '自治县', 4, 'tskegtjkzz', 'tashikuerga', 'null', '845250'),
(2658, '001031009001', '阿克陶', '001031009', 348, '中国/新疆/克孜勒苏/阿克陶', '县', 4, 'akt', 'aketao', 'null', '845550'),
(2659, '001031009002', '阿合奇', '001031009', 348, '中国/新疆/克孜勒苏/阿合奇', '县', 4, 'ahq', 'aheqi', 'null', '843500'),
(2660, '001031009003', '乌恰', '001031009', 348, '中国/新疆/克孜勒苏/乌恰', '县', 4, 'wq', 'wuqia', 'null', '845450'),
(2661, '001031010001', '库尔勒', '001031010', 349, '中国/新疆/巴音郭楞/库尔勒', '市', 4, 'kel', 'kuerle', 'null', '841000'),
(2662, '001031010002', '轮台', '001031010', 349, '中国/新疆/巴音郭楞/轮台', '县', 4, 'lt', 'luntai', 'null', '841600'),
(2663, '001031010003', '尉犁', '001031010', 349, '中国/新疆/巴音郭楞/尉犁', '县', 4, 'wl', 'weili', 'null', '841500'),
(2664, '001031010004', '若羌', '001031010', 349, '中国/新疆/巴音郭楞/若羌', '县', 4, 'rq', 'ruoqiang', 'null', '841800'),
(2665, '001031010005', '且末', '001031010', 349, '中国/新疆/巴音郭楞/且末', '县', 4, 'qm', 'qiemo', 'null', '841900'),
(2666, '001031010006', '和静', '001031010', 349, '中国/新疆/巴音郭楞/和静', '县', 4, 'hj', 'hejing', 'null', '841300'),
(2667, '001031010007', '和硕', '001031010', 349, '中国/新疆/巴音郭楞/和硕', '县', 4, 'hs', 'heshuo', 'null', '841200'),
(2668, '001031010008', '博湖', '001031010', 349, '中国/新疆/巴音郭楞/博湖', '县', 4, 'bh', 'bohu', 'null', '841400'),
(2669, '001031010009', '焉耆', '001031010', 349, '中国/新疆/巴音郭楞/焉耆', '回族自治县', 4, 'yzz', 'yanzizhi', 'null', '841100'),
(2670, '001031011001', '	昌吉', '001031011', 350, '中国/新疆/昌吉/	昌吉', '市', 4, '	cj', '	changji', 'null', '831100'),
(2671, '001031011002', '阜康', '001031011', 350, '中国/新疆/昌吉/阜康', '市', 4, 'fk', 'fukang', 'null', '831500'),
(2672, '001031011003', '米泉', '001031011', 350, '中国/新疆/昌吉/米泉', '市', 4, 'mq', 'miquan', 'null', '831400'),
(2673, '001031011004', '呼图壁', '001031011', 350, '中国/新疆/昌吉/呼图壁', '县', 4, 'htb', 'hutubi', 'null', '831200'),
(2674, '001031011005', '玛纳斯', '001031011', 350, '中国/新疆/昌吉/玛纳斯', '县', 4, 'mns', 'manasi', 'null', '832200'),
(2675, '001031011006', '奇台', '001031011', 350, '中国/新疆/昌吉/奇台', '县', 4, 'qt', 'qitai', 'null', '831800'),
(2676, '001031011007', '吉木萨尔', '001031011', 350, '中国/新疆/昌吉/吉木萨尔', '县', 4, 'jmse', 'jimusaer', 'null', '831700'),
(2677, '001031011008', '木垒', '001031011', 350, '中国/新疆/昌吉/木垒', '哈萨克自治县', 4, 'mlhskzz', 'muleihasake', 'null', '831900'),
(2678, '001031012001', '博乐', '001031012', 351, '中国/新疆/博尔塔拉/博乐', '市', 4, 'bl', 'bole', 'null', '833400'),
(2679, '001031012002', '精河', '001031012', 351, '中国/新疆/博尔塔拉/精河', '县', 4, 'jh', 'jinghe', 'null', '833300'),
(2680, '001031012003', '温泉', '001031012', 351, '中国/新疆/博尔塔拉/温泉', '县', 4, 'wq', 'wenquan', 'null', '833500'),
(2681, '001031013002', '奎屯', '001031013', 352, '中国/新疆/伊犁/奎屯', '市', 4, 'kt', 'kuitun', 'null', '833200'),
(2682, '001031013003', '伊宁', '001031013', 352, '中国/新疆/伊犁/伊宁', '县', 4, 'yn', 'yining', 'null', '835100'),
(2683, '001031013004', '霍城', '001031013', 352, '中国/新疆/伊犁/霍城', '县', 4, 'hc', 'huocheng', 'null', '835200'),
(2684, '001031013005', '巩留', '001031013', 352, '中国/新疆/伊犁/巩留', '县', 4, 'gl', 'gongliu', 'null', '835400'),
(2685, '001031013006', '新源', '001031013', 352, '中国/新疆/伊犁/新源', '县', 4, 'xy', 'xinyuan', 'null', '835800'),
(2686, '001031013007', '昭苏', '001031013', 352, '中国/新疆/伊犁/昭苏', '县', 4, 'zs', 'zhaosu', 'null', '835600'),
(2687, '001031013008', '特克斯', '001031013', 352, '中国/新疆/伊犁/特克斯', '县', 4, 'tks', 'tekesi', 'null', '835500'),
(2688, '001031013009', '尼勒克', '001031013', 352, '中国/新疆/伊犁/尼勒克', '县', 4, 'nlk', 'nileke', 'null', '835700'),
(2689, '001031013010', '察布查尔锡伯', '001031013', 352, '中国/新疆/伊犁/察布查尔锡伯', '自治县', 4, 'cbcexbzz', 'chabuchaerx', 'null', '835300'),
(2690, '001031014001', '塔城', '001031014', 353, '中国/新疆/塔城/塔城', '市', 4, 'tc', 'tacheng', 'null', '834300'),
(2691, '001031014002', '乌苏', '001031014', 353, '中国/新疆/塔城/乌苏', '市', 4, 'ws', 'wusu', 'null', '833000'),
(2692, '001031014003', '额敏', '001031014', 353, '中国/新疆/塔城/额敏', '县', 4, 'em', 'emin', 'null', '834600'),
(2693, '001031014004', '沙湾', '001031014', 353, '中国/新疆/塔城/沙湾', '县', 4, 'sw', 'shawan', 'null', '832100'),
(2694, '001031014005', '托里', '001031014', 353, '中国/新疆/塔城/托里', '县', 4, 'tl', 'tuoli', 'null', '834500'),
(2695, '001031014006', '裕民', '001031014', 353, '中国/新疆/塔城/裕民', '县', 4, 'ym', 'yumin', 'null', '834800'),
(2696, '001031014007', '和布克赛尔', '001031014', 353, '中国/新疆/塔城/和布克赛尔', '蒙古自治县', 4, 'hbksemgzz', 'hebukesaier', 'null', '834400'),
(2697, '001031015001', '阿勒泰', '001031015', 354, '中国/新疆/阿勒泰/阿勒泰', '市', 4, 'alt', 'aletai', 'null', '836500'),
(2698, '001031015002', '布尔津', '001031015', 354, '中国/新疆/阿勒泰/布尔津', '县', 4, 'bej', 'buerjin', 'null', '836600'),
(2699, '001031015003', '富蕴', '001031015', 354, '中国/新疆/阿勒泰/富蕴', '县', 4, 'fy', 'fuyun', 'null', '836100'),
(2700, '001031015004', '福海', '001031015', 354, '中国/新疆/阿勒泰/福海', '县', 4, 'fh', 'fuhai', 'null', '836400'),
(2701, '001031015005', '哈巴河', '001031015', 354, '中国/新疆/阿勒泰/哈巴河', '县', 4, 'hbh', 'habahe', 'null', '836700'),
(2702, '001031015006', '青河', '001031015', 354, '中国/新疆/阿勒泰/青河', '县', 4, 'qh', 'qinghe', 'null', '836200'),
(2703, '001031015007', '吉木乃', '001031015', 354, '中国/新疆/阿勒泰/吉木乃', '县', 4, 'jmn', 'jimunai', 'null', '836800'),
(2704, '001009001001', '黄浦', '001009001', 355, '中国/上海/市辖区/黄浦', '区', 4, 'hp', 'huangpu', 'null', '200000'),
(2705, '001009001002', '卢湾', '001009001', 355, '中国/上海/市辖区/卢湾', '区', 4, 'lw', 'luwan', 'null', '200000'),
(2706, '001009001003', '徐汇', '001009001', 355, '中国/上海/市辖区/徐汇', '区', 4, 'xh', 'xuhui', 'null', '200000'),
(2707, '001009001004', '长宁', '001009001', 355, '中国/上海/市辖区/长宁', '区', 4, 'cn', 'changning', 'null', '200000'),
(2708, '001009001005', '静安', '001009001', 355, '中国/上海/市辖区/静安', '区', 4, 'ja', 'jingan', 'null', '200000'),
(2709, '001009001006', '普陀', '001009001', 355, '中国/上海/市辖区/普陀', '区', 4, 'pt', 'putuo', 'null', '200000'),
(2710, '001009001007', '闸北', '001009001', 355, '中国/上海/市辖区/闸北', '区', 4, 'zb', 'zhabei', 'null', '200000'),
(2711, '001009001008', '虹口', '001009001', 355, '中国/上海/市辖区/虹口', '区', 4, 'hk', 'hongkou', 'null', '200000'),
(2712, '001009001009', '杨浦', '001009001', 355, '中国/上海/市辖区/杨浦', '区', 4, 'yp', 'yangpu', 'null', '200000'),
(2713, '001009001010', '宝山', '001009001', 355, '中国/上海/市辖区/宝山', '区', 4, 'bs', 'baoshan', 'null', '201900'),
(2714, '001009001011', '闵行', '001009001', 355, '中国/上海/市辖区/闵行', '区', 4, 'x', 'xing', 'null', '201100'),
(2715, '001009001012', '嘉定', '001009001', 355, '中国/上海/市辖区/嘉定', '区', 4, 'jd', 'jiading', 'null', '201800'),
(2716, '001009001013', '浦东新', '001009001', 355, '中国/上海/市辖区/浦东新', '区', 4, 'pdx', 'pudongxin', 'null', '200120'),
(2717, '001009001014', '松江', '001009001', 355, '中国/上海/市辖区/松江', '区', 4, 'sj', 'songjiang', 'null', '201600'),
(2718, '001009001015', '金山', '001009001', 355, '中国/上海/市辖区/金山', '区', 4, 'js', 'jinshan', 'null', '201500'),
(2719, '001009001016', '青浦', '001009001', 355, '中国/上海/市辖区/青浦', '区', 4, 'qp', 'qingpu', 'null', '201700'),
(2720, '001009001017', '南汇', '001009001', 355, '中国/上海/市辖区/南汇', '区', 4, 'nh', 'nanhui', 'null', '201300'),
(2721, '001009001018', '奉贤', '001009001', 355, '中国/上海/市辖区/奉贤', '区', 4, 'fx', 'fengxian', 'null', '201400'),
(2722, '001009002001', '崇明', '001009002', 356, '中国/上海/县/崇明', '县', 4, 'cm', 'chongming', 'null', '202150'),
(2723, '001022001001', '渝中', '001022001', 357, '中国/重庆/市辖区/渝中', '区', 4, 'yz', 'yuzhong', 'null', '400000'),
(2724, '001022001002', '大渡口', '001022001', 357, '中国/重庆/市辖区/大渡口', '区', 4, 'ddk', 'dadukou', 'null', '400000'),
(2725, '001022001003', '江北', '001022001', 357, '中国/重庆/市辖区/江北', '区', 4, 'jb', 'jiangbei', 'null', '400000'),
(2726, '001022001004', '沙坪坝', '001022001', 357, '中国/重庆/市辖区/沙坪坝', '区', 4, 'spb', 'shapingba', 'null', '400000');
INSERT INTO `des_district` (`serialId`, `districtId`, `districtName`, `districtUpId`, `districtUpIdNum`, `districtPath`, `districtType`, `districtTypeNum`, `shortName`, `spell`, `areaId`, `postCode`) VALUES
(2727, '001022001005', '九龙坡', '001022001', 357, '中国/重庆/市辖区/九龙坡', '区', 4, 'jlp', 'jiulongpo', 'null', '400000'),
(2728, '001022001006', '南岸', '001022001', 357, '中国/重庆/市辖区/南岸', '区', 4, 'na', 'nanan', 'null', '400000'),
(2729, '001022001007', '北碚', '001022001', 357, '中国/重庆/市辖区/北碚', '区', 4, 'b', 'bei', 'null', '400700'),
(2730, '001022001008', '万盛', '001022001', 357, '中国/重庆/市辖区/万盛', '区', 4, 'ws', 'wansheng', 'null', '400800'),
(2731, '001022001009', '双桥', '001022001', 357, '中国/重庆/市辖区/双桥', '区', 4, 'sq', 'shuangqiao', 'null', '400900'),
(2732, '001022001010', '渝北', '001022001', 357, '中国/重庆/市辖区/渝北', '区', 4, 'yb', 'yubei', 'null', '401120'),
(2733, '001022001011', '巴南', '001022001', 357, '中国/重庆/市辖区/巴南', '区', 4, 'bn', 'banan', 'null', '401320'),
(2734, '001022001012', '万州', '001022001', 357, '中国/重庆/市辖区/万州', '区', 4, 'wz', 'wanzhou', 'null', '404100'),
(2735, '001022001013', '涪陵', '001022001', 357, '中国/重庆/市辖区/涪陵', '区', 4, 'fl', 'fuling', 'null', '408000'),
(2736, '001022001014', '黔江', '001022001', 357, '中国/重庆/市辖区/黔江', '区', 4, 'qj', 'qianjiang', 'null', '409000'),
(2737, '001022001015', '长寿', '001022001', 357, '中国/重庆/市辖区/长寿', '区', 4, 'cs', 'changshou', 'null', '401220'),
(2738, '001022002001', '永川', '001022002', 358, '中国/重庆/市/永川', '市', 4, 'yc', 'yongchuan', 'null', '402160'),
(2739, '001022002002', '合川', '001022002', 358, '中国/重庆/市/合川', '市', 4, 'hc', 'hechuan', 'null', '401520'),
(2740, '001022002003', '江津', '001022002', 358, '中国/重庆/市/江津', '市', 4, 'jj', 'jiangjin', 'null', '402260'),
(2741, '001022002004', '南川', '001022002', 358, '中国/重庆/市/南川', '市', 4, 'nc', 'nanchuan', 'null', '408400'),
(2742, '001022003001', '綦江', '001022003', 359, '中国/重庆/县/綦江', '县', 4, 'j', 'jiang', 'null', '401420'),
(2743, '001022003002', '潼南', '001022003', 359, '中国/重庆/县/潼南', '县', 4, 'n', 'nan', 'null', '402660'),
(2744, '001022003001', '荣昌', '001022003', 359, '中国/重庆/县/綦江', '县', 4, 'rc', 'rongchang', 'null', '402460'),
(2745, '001022003002', '璧山', '001022003', 359, '中国/重庆/县/潼南', '县', 4, 's', 'shan', 'null', '402760'),
(2746, '001022003003', '大足', '001022003', 359, '中国/重庆/县/大足', '县', 4, 'dz', 'dazu', 'null', '402360'),
(2747, '001022003004', '铜梁', '001022003', 359, '中国/重庆/县/铜梁', '县', 4, 'tl', 'tongliang', 'null', '402560'),
(2748, '001022003005', '梁平', '001022003', 359, '中国/重庆/县/梁平', '县', 4, 'lp', 'liangping', 'null', '405200'),
(2749, '001022003006', '城口', '001022003', 359, '中国/重庆/县/城口', '县', 4, 'ck', 'chengkou', 'null', '405900'),
(2750, '001022003007', '垫江', '001022003', 359, '中国/重庆/县/垫江', '县', 4, 'dj', 'dianjiang', 'null', '408300'),
(2751, '001022003008', '武隆', '001022003', 359, '中国/重庆/县/武隆', '县', 4, 'wl', 'wulong', 'null', '408500'),
(2752, '001022003009', '丰都', '001022003', 359, '中国/重庆/县/丰都', '县', 4, 'fd', 'fengdu', 'null', '408200'),
(2753, '001022003010', '奉节', '001022003', 359, '中国/重庆/县/奉节', '县', 4, 'fj', 'fengjie', 'null', '404600'),
(2754, '001022003011', '开县', '001022003', 359, '中国/重庆/县/开县', 'null', 4, 'k', 'kai', 'null', '405400'),
(2755, '001022003012', '云阳', '001022003', 359, '中国/重庆/县/云阳', '县', 4, 'yy', 'yunyang', 'null', '404500'),
(2756, '001022003013', '忠县', '001022003', 359, '中国/重庆/县/忠县', 'null', 4, 'z', 'zhong', 'null', '404300'),
(2757, '001022003014', '巫溪', '001022003', 359, '中国/重庆/县/巫溪', '县', 4, 'wx', 'wuxi', 'null', '405800'),
(2758, '001022003015', '巫山', '001022003', 359, '中国/重庆/县/巫山', '县', 4, 'ws', 'wushan', 'null', '404700'),
(2759, '001022003016', '石柱', '001022003', 359, '中国/重庆/县/石柱', '土家族自治县', 4, 'sztjzzz', 'shizhutujia', 'null', '409100'),
(2760, '001022003017', '秀山', '001022003', 359, '中国/重庆/县/秀山', '土家族苗族自治县', 4, 'xstjzmzzz', 'xiushantuji', 'null', '409900'),
(2761, '001022003018', '酉阳', '001022003', 359, '中国/重庆/县/酉阳', '土家族苗族自治县', 4, 'yytjzmzzz', 'youyangtuji', 'null', '409800'),
(2762, '001022003019', '彭水', '001022003', 359, '中国/重庆/县/彭水', '苗族土家族自治县', 4, 'psmztjzzz', 'pengshuimia', 'null', '409600'),
(2763, '001010010006', '扬中', '001010010', 98, '中国/江苏/镇江/扬中', '市', 4, 'Yz', 'Yangzhong', '0511', '212200'),
(2764, '001006001013', '沈河', '001006001', 53, '中国/辽宁/沈阳/沈河', '区', 4, 'null', 'null', 'null', '110400'),
(2765, '001013001013', '鼓楼', '001013001', 130, '中国/福建/福州/鼓楼', '区', 4, 'null', 'null', 'null', 'null'),
(2766, '001023001019', '彭州', '001023001', 251, '中国/四川/成都/彭州', '市', 4, 'null', 'null', 'null', 'null'),
(2767, '001019002006', '福田', '001019002', 214, '中国/广东/深圳/福田', '区', 4, 'null', 'null', 'null', 'null'),
(2768, '001020001011', '青秀', '001020001', 234, '中国/广西/南宁/青秀', '区', 4, 'null', 'null', 'null', 'null');


CREATE TABLE IF NOT EXISTS `des_group` (
  `id` smallint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL,
  `title` varchar(50) NOT NULL,
  `create_time` int(11) unsigned NOT NULL,
  `update_time` int(11) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sort` smallint(3) unsigned NOT NULL DEFAULT '0',
  `show` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;



INSERT INTO `des_group` (`id`, `name`, `title`, `create_time`, `update_time`, `status`, `sort`, `show`) VALUES
(2, 'App', '应用中心', 1222841259, 0, 1, 0, 0);



CREATE TABLE IF NOT EXISTS `des_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sort` mediumint(9) NOT NULL COMMENT '分类id',
  `name` varchar(125) NOT NULL COMMENT '名称',
  `link` varchar(255) NOT NULL COMMENT '链接',
  `order` int(11) NOT NULL COMMENT '排序',
  `type` int(11) NOT NULL COMMENT '类型',
  `icon` varchar(255) NOT NULL COMMENT '图标',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='友情链接';



INSERT INTO `des_links` (`id`, `sort`, `name`, `link`, `order`, `type`, `icon`) VALUES
(1, 1, 'Destroy官方', 'http://www.destroy.net.cn', 999, 1, '');



CREATE TABLE IF NOT EXISTS `des_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `icon` varchar(500) NOT NULL,
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `url` char(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否隐藏',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '提示',
  `controller` varchar(50) DEFAULT NULL COMMENT '分组',
  `action` varchar(50) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否仅开发者模式可见',
  `app` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


INSERT INTO `des_menu` (`id`, `icon`, `name`, `pid`, `sort`, `url`, `type`, `remark`, `controller`, `action`, `status`, `app`) VALUES
(1, 'fa fa-gear', '系统', 0, 0, 'Index/index', 0, '', 'Index', '', 1, 'admin'),
(2, 'fa fa-skyatlas', '应用', 0, 0, 'Article/mydocument', 0, '', 'appshop', '', 1, 'admin'),
(3, 'fa fa-plus-square', '扩展', 0, 0, 'article/index', 1, '', '内容', '', 1, 'admin'),
(4, 'fa fa-th-large', '界面', 0, 0, 'article/add', 0, '', 'view', 'index', 1, 'admin'),
(8, '', '保存草稿', 3, 0, 'article/autoSave', 0, '', NULL, '', 0, 'admin'),
(13, '', '回收站', 2, 0, 'article/recycle', 1, '', '内容', '', 0, 'admin'),
(16, 'fa fa-user', '用户', 0, 0, 'User/index', 0, '', 'user', 'index', 1, 'admin'),
(17, '', '用户列表', 16, 0, 'User/index', 0, '', 'user', 'index', 1, 'admin'),
(19, '', '用户行为', 16, 0, 'User/action', 0, '', 'user', '', 1, 'admin'),
(106, '', '行为日志', 16, 0, 'Action/actionlog', 0, '', '行为管理', '', 0, 'admin'),
(108, '', '修改密码', 16, 0, 'User/updatePassword', 1, '', '', '', 0, 'admin'),
(139, '', '用户权限', 16, 0, '', 0, '', 'node', '', 1, 'admin'),
(140, '', '分类列表', 2, 0, '', 0, '', 'category', 'index', 1, 'admin'),
(125, '', '基本设置', 1, 0, '', 0, '', 'setting', 'info', 1, 'admin'),
(126, '', '导航栏目', 1, 0, '', 0, '', 'nav', 'index', 1, 'admin'),
(127, '', '回收站', 1, 0, '', 0, '', 'recycle', 'index', 1, 'admin'),
(128, '', '文章内容', 2, 0, '', 0, '', 'content', 'read', 1, 'admin'),
(129, '', '图片相册', 2, 0, '', 0, '', 'album', 'index', 1, 'admin'),
(130, '', '留言评论', 2, 0, '', 0, '', 'comm', 'index', 1, 'admin'),
(131, '', '网络链接', 2, 0, '', 0, '', 'links', 'index', 1, 'admin'),
(132, '', '插件管理', 3, 0, '', 0, '', 'comp', 'index', 1, 'admin'),
(133, '', '游戏管理', 3, 0, '', 0, '', 'game', 'index', 1, 'admin'),
(134, '', '工具箱', 3, 0, '', 0, '', 'tools', 'index', 1, 'admin'),
(135, '', '模板超市', 4, 0, '', 0, '', 'view', 'shopView', 1, 'admin'),
(136, '', '我的模板', 4, 0, '', 0, '', 'view', 'index', 1, 'admin'),
(137, '', '模板编辑', 4, 0, '', 0, '', 'view', 'editView', 1, 'admin'),
(138, '', '用户角色', 16, 0, '', 0, '', 'Role', 'index', 1, 'admin');



CREATE TABLE IF NOT EXISTS `des_nav` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `parent_id` smallint(6) NOT NULL COMMENT '上级id',
  `name` varchar(125) NOT NULL COMMENT '名称',
  `link` varchar(255) NOT NULL COMMENT '链接',
  `sort` int(11) NOT NULL COMMENT '排序',
  `status` int(11) NOT NULL COMMENT '类型{1：在自动排序中显示，0：否}',
  `icon` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='导航菜单';



INSERT INTO `des_nav` (`id`, `parent_id`, `name`, `link`, `sort`, `status`, `icon`) VALUES
(1, 0, '日志', '/rizhi', 999, 1, ''),
(12, 0, '社区', 'http://bbs.destroy.net.cn', 0, 1, '');



CREATE TABLE IF NOT EXISTS `des_node` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `title` varchar(50) DEFAULT NULL,
  `controller` char(75) NOT NULL,
  `action` char(75) NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  `remark` varchar(255) DEFAULT NULL,
  `sort` smallint(6) unsigned DEFAULT NULL,
  `pid` smallint(6) unsigned NOT NULL,
  `level` tinyint(1) unsigned NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `group_id` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `level` (`level`),
  KEY `pid` (`pid`),
  KEY `status` (`status`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


INSERT INTO `des_node` (`id`, `name`, `title`, `controller`, `action`, `status`, `remark`, `sort`, `pid`, `level`, `type`, `group_id`) VALUES
(49, 'node', '节点管理', '', '', 1, '', NULL, 5, 3, 0, 0),
(40, 'menu', '菜单设置', '', '', 1, '', 1, 5, 2, 0, 0),
(39, 'role', '用户角色', '', '', 1, '', NULL, 5, 3, 0, 0),
(37, 'user', '用户列表', '', '', 1, '', NULL, 5, 3, 0, 0),
(36, 'shopView', '模版超市', '', '', 1, '', NULL, 4, 3, 0, 0),
(35, 'index', '我的模版', '', '', 1, '', NULL, 4, 3, 0, 0),
(34, 'editView', '模版编辑', '', '', 1, '', NULL, 4, 3, 0, 0),
(33, 'info', '常规设置', '', '', 1, '', NULL, 1, 3, 0, 0),
(32, 'set', '系统设置', '', '', 1, '', NULL, 1, 3, 0, 0),
(31, 'other', '其他设置', '', '', 1, '', NULL, 1, 3, 0, 0),
(30, 'nav', '导航栏目', '', '', 1, '', 2, 1, 2, 0, 0),
(5, 'users', '用户', '', '', 1, '', 1, 0, 2, 0, 2),
(4, 'view', '界面', '', '', 1, '', 4, 0, 2, 0, 2),
(3, 'comp', '扩展', '', '', 1, '', 3, 0, 2, 0, 2),
(2, 'app', '应用', '', '', 1, '', 2, 0, 2, 0, 2),
(1, 'system', '系统', '', '', 1, '', NULL, 0, 1, 0, 0),
(50, 'main', '广告管理', '', '', 1, '', NULL, 1, 3, 0, 0);



CREATE TABLE IF NOT EXISTS `des_option` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(125) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `key` (`key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='全局参数';



INSERT INTO `des_option` (`id`, `key`, `value`) VALUES
(1, 'host_url', 'http://demo.destroy.net.cn'),
(2, 'host_name', 'Destroy'),
(3, 'host_title', 'Destroy'),
(4, 'host_title2', '使用Destroy系统快速建立网站，最快只需5分钟'),
(5, 'host_url2', 'http://locahost'),
(6, 'host_keyword', '关键词'),
(7, 'host_description', '描述一下网站'),
(9, 'host_logo', ''),
(10, 'host_powered', 'Copyright @ 2014 Destroy All Rights Reserved'),
(11, 'host_beian', '停业提示'),
(12, 'host_address', '湖南省永州市'),
(13, 'host_tel', '0746-8888888'),
(14, 'host_qq', '12345678'),
(15, 'host_email', 'email@eamil.com'),
(16, 'host_code', '无'),
(17, 'host_dir', '/'),
(25, 'host_stop', '停业提示');



CREATE TABLE IF NOT EXISTS `des_province` (
  `serialId` int(3) NOT NULL AUTO_INCREMENT,
  `provinceId` varchar(20) CHARACTER SET gbk DEFAULT NULL,
  `provinceName` varchar(20) CHARACTER SET gbk DEFAULT NULL,
  `provinceUpId` varchar(20) CHARACTER SET gbk DEFAULT NULL,
  `provinceUpIdNum` int(11) DEFAULT NULL,
  `provincePath` varchar(100) CHARACTER SET gbk DEFAULT NULL,
  `provinceType` varchar(20) CHARACTER SET gbk DEFAULT NULL,
  `provinceTypeNum` int(11) DEFAULT NULL,
  `shortName` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  `spell` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  `areaId` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  `postCode` varchar(11) CHARACTER SET gbk DEFAULT NULL,
  PRIMARY KEY (`serialId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;



INSERT INTO `des_province` (`serialId`, `provinceId`, `provinceName`, `provinceUpId`, `provinceUpIdNum`, `provincePath`, `provinceType`, `provinceTypeNum`, `shortName`, `spell`, `areaId`, `postCode`) VALUES
(1, '001001', '北京', '001', 0, '中国/北京', '市', 2, 'bj', 'beijing', '010', '100000'),
(2, '001002', '天津', '001', 0, '中国/天津', '市', 2, 'tj', 'tianjin', '022', '300000'),
(3, '001003', '河北', '001', 0, '中国/河北', '省', 2, 'hb', 'hebei', 'null', 'null'),
(4, '001004', '山西', '001', 0, '中国/山西', '省', 2, 'sx', 'shanxi', 'null', 'null'),
(5, '001005', '内蒙古', '001', 0, '中国/内蒙古', '自治区', 2, 'nmg', 'neimenggu', 'null', 'null'),
(6, '001006', '辽宁', '001', 0, '中国/辽宁', '省', 2, 'ln', 'liaoning', 'null', 'null'),
(7, '001007', '吉林', '001', 0, '中国/吉林', '省', 2, 'jl', 'jilin', 'null', 'null'),
(8, '001008', '黑龙江', '001', 0, '中国/黑龙江', '省', 2, 'hlj', 'heilongjian', 'null', 'null'),
(9, '001009', '上海', '001', 0, '中国/上海', '市', 2, 'sh', 'shanghai', '021', '200000'),
(10, '001010', '江苏', '001', 0, '中国/江苏', '省', 2, 'js', 'jiangsu', 'null', 'null'),
(11, '001011', '浙江', '001', 0, '中国/浙江', '省', 2, 'zj', 'zhejiang', 'null', 'null'),
(12, '001012', '安徽', '001', 0, '中国/安徽', '省', 2, 'ah', 'anhui', 'null', 'null'),
(13, '001013', '福建', '001', 0, '中国/福建', '省', 2, 'fj', 'fujian', 'null', 'null'),
(14, '001014', '江西', '001', 0, '中国/江西', '省', 2, 'jx', 'jiangxi', 'null', 'null'),
(15, '001015', '山东', '001', 0, '中国/山东', '省', 2, 'sd', 'shandong', 'null', 'null'),
(16, '001016', '河南', '001', 0, '中国/河南', '省', 2, 'hn', 'henan', 'null', 'null'),
(17, '001017', '湖北', '001', 0, '中国/湖北', '省', 2, 'hb', 'hubei', 'null', 'null'),
(18, '001018', '湖南', '001', 0, '中国/湖南', '省', 2, 'hn', 'hunan', 'null', 'null'),
(19, '001019', '广东', '001', 0, '中国/广东', '省', 2, 'gd', 'guangdong', 'null', 'null'),
(20, '001020', '广西', '001', 0, '中国/广西', '壮族自治区', 2, 'gx', 'guangxi', 'null', 'null'),
(21, '001021', '海南', '001', 0, '中国/海南', '省', 2, 'hn', 'hainan', 'null', 'null'),
(22, '001022', '重庆', '001', 0, '中国/重庆', '市', 2, 'cq', 'chongqing', '023', '400000'),
(23, '001023', '四川', '001', 0, '中国/四川', '省', 2, 'sc', 'sichuan', 'null', 'null'),
(24, '001024', '贵州', '001', 0, '中国/贵州', '省', 2, 'gz', 'guizhou', 'null', 'null'),
(25, '001025', '云南', '001', 0, '中国/云南', '省', 2, 'yn', 'yunnan', 'null', 'null'),
(26, '001026', '西藏', '001', 0, '中国/西藏', '自治区', 2, 'xc', 'xicang', 'null', 'null'),
(27, '001027', '陕西', '001', 0, '中国/陕西', '省', 2, 'sx', 'shanxi', 'null', 'null'),
(28, '001028', '甘肃', '001', 0, '中国/甘肃', '省', 2, 'gs', 'gansu', 'null', 'null'),
(29, '001029', '青海', '001', 0, '中国/青海', '省', 2, 'qh', 'qinghai', 'null', 'null'),
(30, '001030', '宁夏', '001', 0, '中国/宁夏', '回族自治区', 2, 'nx', 'ningxia', 'null', 'null'),
(31, '001031', '新疆', '001', 0, '中国/新疆', '维吾尔自治区', 2, 'xj', 'xinjiang', 'null', 'null'),
(32, '001032', '香港', '001', 0, '中国/香港', '特别行政区', 2, 'xg', 'xianggang', '852', 'null'),
(33, '001033', '澳门', '001', 0, '中国/澳门', '特别行政区', 2, 'am', 'aomen', '853', 'null'),
(34, '001034', '台湾', '001', 0, '中国/台湾', '省', 2, 'tw', 'taiwan', '886', 'null');



CREATE TABLE IF NOT EXISTS `des_role` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `pid` smallint(6) DEFAULT NULL,
  `status` tinyint(1) unsigned DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `ename` varchar(5) DEFAULT NULL,
  `create_time` int(11) unsigned NOT NULL,
  `update_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `parentId` (`pid`),
  KEY `ename` (`ename`),
  KEY `status` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


INSERT INTO `des_role` (`id`, `name`, `pid`, `status`, `remark`, `ename`, `create_time`, `update_time`) VALUES
(1, '领导组', 0, 1, '', '', 1208784792, 1254325558),
(2, '员工组', 0, 1, '', '', 1215496283, 1254325566),
(7, '演示组', 0, 1, '', NULL, 1254325787, 0);


CREATE TABLE IF NOT EXISTS `des_role_user` (
  `role_id` mediumint(9) unsigned DEFAULT NULL,
  `user_id` char(32) DEFAULT NULL,
  KEY `group_id` (`role_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `des_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(255) NOT NULL,
  `type` tinyint(4) NOT NULL,
  `hot` tinyint(4) NOT NULL COMMENT '热度，查看次数',
  `bits` int(11) NOT NULL COMMENT '出现次数',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='标签';



CREATE TABLE IF NOT EXISTS `des_user` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `sort` smallint(6) NOT NULL,
  `number` int(11) NOT NULL,
  `account` varchar(64) NOT NULL,
  `face` varchar(255) NOT NULL COMMENT '头像',
  `nickname` varchar(50) NOT NULL,
  `password` char(32) NOT NULL,
  `phone` varchar(16) NOT NULL,
  `bind_account` varchar(50) NOT NULL,
  `last_login_time` int(11) unsigned DEFAULT '0',
  `last_login_ip` varchar(40) DEFAULT NULL,
  `login_count` mediumint(8) unsigned DEFAULT '0',
  `verify` varchar(32) DEFAULT NULL,
  `email` varchar(50) NOT NULL,
  `remark` varchar(255) NOT NULL,
  `create_time` int(11) unsigned NOT NULL,
  `update_time` int(11) unsigned NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  `type_id` tinyint(2) unsigned DEFAULT '0',
  `info` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account` (`account`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `des_user_communication` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `address` varchar(255) NOT NULL COMMENT '街道',
  `country` varchar(25) NOT NULL COMMENT '国家',
  `province` varchar(25) NOT NULL COMMENT '省份',
  `city` varchar(25) NOT NULL COMMENT '城市',
  `county` varchar(25) NOT NULL COMMENT '县区',
  `postalcode` smallint(6) NOT NULL COMMENT '邮编',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='用户通信表';


INSERT INTO `des_user_communication` (`uid`, `address`, `country`, `province`, `city`, `county`, `postalcode`) VALUES
(1, '', '', '001018', '001018011', '001018011004', 0);

CREATE TABLE IF NOT EXISTS `des_user_group` (
  `gid` int(11) NOT NULL,
  `name` varchar(25) NOT NULL COMMENT '组名称',
  `power` text NOT NULL COMMENT '权限',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户组';


CREATE TABLE IF NOT EXISTS `des_user_honour` (
  `id` tinyint(4) NOT NULL COMMENT 'id',
  `honour_name` varchar(25) NOT NULL COMMENT '名称',
  `icon` varchar(255) NOT NULL COMMENT '图标',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户头衔';


CREATE TABLE IF NOT EXISTS `des_user_level` (
  `uid` int(11) NOT NULL,
  `level` tinyint(4) NOT NULL COMMENT '等级',
  `honour` tinyint(11) NOT NULL COMMENT '头衔',
  `vip_level` tinyint(4) NOT NULL COMMENT 'vip等级',
  `vip_type` tinyint(4) NOT NULL COMMENT '会员类型',
  `online` int(11) NOT NULL COMMENT '在线时间',
  `art_amount` int(11) NOT NULL COMMENT '发表文章数量',
  `com_amount` int(11) NOT NULL COMMENT '发表评论数',
  UNIQUE KEY `user_id` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户等级';



CREATE TABLE IF NOT EXISTS `des_user_list` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `home` varchar(125) NOT NULL COMMENT '用户主页',
  `qq` int(125) NOT NULL COMMENT 'qq',
  `name` varchar(25) NOT NULL COMMENT '真实姓名',
  `sex` tinyint(4) NOT NULL COMMENT '性别',
  `birthday` date NOT NULL COMMENT '出生日',
  `believe` varchar(125) NOT NULL COMMENT '个性签名',
  `Individual` varchar(500) NOT NULL COMMENT '个人说明',
  `job` varchar(25) NOT NULL COMMENT '职业',
  `blood` char(2) NOT NULL COMMENT '血型',
  `school` varchar(125) NOT NULL COMMENT '毕业学校',
  `edu` varchar(6) NOT NULL COMMENT '学历',
  `love` varchar(125) NOT NULL COMMENT '爱好',
  `marriage` varchar(15) NOT NULL COMMENT '婚恋史',
  PRIMARY KEY (`uid`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='用户个人信息';


INSERT INTO `des_user_list` (`uid`, `home`, `qq`, `name`, `sex`, `birthday`, `believe`, `Individual`, `job`, `blood`, `school`, `edu`, `love`, `marriage`) VALUES
(1, '', 0, '', 0, '0000-00-00', '没个性不签名', '', '', '', '大学', '大专', '', '');


CREATE TABLE IF NOT EXISTS `des_user_log` (
  `uid` int(11) NOT NULL,
  `acion` varchar(125) NOT NULL COMMENT '动作',
  `log_time` int(11) NOT NULL COMMENT '时间',
  `log_ip` varchar(16) NOT NULL COMMENT '最后登录ip',
  KEY `user_id` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户日志';



CREATE TABLE IF NOT EXISTS `des_user_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `menu_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户管理菜单';


CREATE TABLE IF NOT EXISTS `des_user_property` (
  `pid` int(11) NOT NULL AUTO_INCREMENT,
  `alipay` varchar(125) NOT NULL COMMENT '支付宝',
  `tenpay` varchar(125) NOT NULL COMMENT '财付通',
  `bankpay` varchar(125) NOT NULL COMMENT '默认网上银行',
  `sys_money` int(11) NOT NULL DEFAULT '0' COMMENT '系统特有币种',
  `integral` int(11) NOT NULL DEFAULT '0' COMMENT '积分总额',
  `money` int(11) NOT NULL DEFAULT '0' COMMENT '人民币总额',
  `species` int(11) NOT NULL DEFAULT '0' COMMENT '金币',
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户财务';


CREATE TABLE IF NOT EXISTS `des_user_set` (
  `uid` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='量的转换';



CREATE TABLE IF NOT EXISTS `des_user_vip` (
  `id` tinyint(4) NOT NULL COMMENT 'id',
  `vip_name` varchar(25) NOT NULL COMMENT '会员名称',
  `icon` varchar(255) NOT NULL COMMENT '图标',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户会员';
