<?php
class PublicAction extends HomeBaseAction {
	function _initialize(){
		parent::_initialize();
		$data = YdCache::readReg();
		//未启用会员功能, 将导致public/testModel重定向到首页
		//if( $data['MEMBER_ENABLE'] == 0 ){
		//	redirect( HomeUrl() );
		//}
	}
	
	function index(){
		redirect(__URL__.'/Login');
	}
	
	//用户登录
    function login(){
        header("Content-Type:text/html; charset=utf-8");       
        $SitePath = $this->_getSitePath( 'userlogin' );
        $this->assign('SitePath', $SitePath);
        $this->display();
    }
    
    function checkLogin(){
    	header("Content-Type:text/html; charset=utf-8");
    	$MemberName = trim($_POST['MemberName']);
    	$MemberPassword = trim($_POST['MemberPassword']);
    	$MemberCode = trim($_POST['MemberCode']);
    
    	if($MemberName == ''){
    		session('MemberCode', rand(1000, 9999) );
    		$this->ajaxReturn(null, L('UserNameRequired') , 0);
    	}
    
    	if($MemberPassword == ''){
    		session('MemberPassword', rand(1000, 9999) );
    		$this->ajaxReturn(null, L('PasswordRequired') , 0);
    	}
    
    	$reg = YdCache::readReg();
    	if( $reg['MEMBER_LOGIN_VERIFYCODE'] == 1){ //启用验证码
	    	if($MemberCode == ''){
	    		session('MemberCode', rand(1000, 9999) );
	    		$this->ajaxReturn(null, L('VerifyCodeRequired') , 0);
	    	}
	    
	    	$MemberCode2 = session('membercode');
	    	if(md5($MemberCode) != $MemberCode2){
	    		session('MemberCode', rand(1000, 9999) );
	    		$this->ajaxReturn(null, L('VerifyCodeError') , 0);
	    	}
    	}
    
    	$m = D('Admin/Member');
    	//0: 用户名或密码错误，1：用户被锁定，2:用户组不存在，数组：认证成功
    	$result = $m->checkLogin($MemberName, md5($MemberPassword) );
    	if( $result == 0 ){
    		$this->ajaxReturn(null, L('UserNamePasswordError') , 0);
    	}else if($result == 1){
    		$this->ajaxReturn(null, L('AccountLock') , 0);
    	}else if($result == 2){
    		$this->ajaxReturn(null, L('AdminGroupNotExist') , 0);
    	}else if($result == 3){
    		$this->ajaxReturn(null, L('AccountUnchecked') , 0);
    	}else if( is_array($result) ){ //认证成功
    		$m->UpdateLogin($result['MemberID']);
    		session('MemberID', $result['MemberID']);
    		session('MemberName', $result['MemberName']);
    		session('MemberGroupID', $result['MemberGroupID']);
    		session('MemberGroupName', $result['MemberGroupName']);
    		
    		$IsAdmin = D('Admin/Admin')->where("MemberID=".$result['MemberID'])->count();
    		$IsAdmin = ( $IsAdmin > 0) ? 1 : 0;
    		session('IsAdmin', $IsAdmin );
    		$this->ajaxReturn(null, L('LoginSuccess'), 1);
    	}
    }

    function checkReg(){
    	$reg = YdCache::readReg();
    	$allowReg = $reg['MEMBER_REG_ENABLE'];
    	if( !$allowReg ){
    		alert(L('ForbidReg'), __APP__);
    		exit();
    	}
    }
    
    function reg(){
    	header("Content-Type:text/html; charset=utf-8");
		$this->checkReg();
		$SitePath = $this->_getSitePath( 'userreg' );
		$this->assign('SitePath', $SitePath);
    	$this->display();
    }
    
    //忘记密码
    function forget(){
    	header("Content-Type:text/html; charset=utf-8");
    	$Step = trim( $_POST['Step'] );  //当前步骤
    	if( $Step == 1 ){   //回答问题
    		$MemberName = trim( $_POST['MemberName'] );
    		if( $MemberName == ''){
    			$this->ajaxReturn(null, L('UserNameRequired') , 0);
    		}
    		$m = D('Admin/Member');
    		$question = $m->getQuestion($MemberName);
    		if( empty($question) ){
    			$this->ajaxReturn(null, L('UserOrAnswer') , 0);
    		}
    		$data['MemberName'] = $MemberName;
    		$data['MemberQuestion'] = $question;
    		$this->ajaxReturn($data, 'success' , 1);
    	}else if( $Step == 2 ){   //密码重置
    		//密保答案
    		$MemberAnswer = trim( $_POST['MemberAnswer'] );
    		if( $MemberAnswer == ''){
    			$this->ajaxReturn(null, L('AnswerRequired') , 0);
    		}
    		
    		$MemberCode = trim($_POST['MemberCode']);
    		if($MemberCode==''){
    			$this->ajaxReturn(null, L('VerifyCodeRequired') , 0);
    		}
    		 
    		$MemberCode2 = session('membercode');
    		if(md5($MemberCode) != $MemberCode2){
    			$this->ajaxReturn(null, L('VerifyCodeError') , 0);
    		}
    		 
    		$MemberName= trim( $_POST['MemberName'] );
    		$MemberQuestion = trim( $_POST['MemberQuestion'] );    		
    		$m = D('Admin/Member');
    		$answer = $m->getAnswer($MemberName);
    		if( $MemberAnswer == $answer){ //密码初始化为123456
    			$result =  $m->resetPwd($MemberName);
    			if( $result === false ){
    				$this->ajaxReturn(null, L('ResetPwdFail') , 2);
    			}else{
    				$this->ajaxReturn(null, L('ResetPwdSuccess') , 2);
    			}
    		}else{  //报密保答案错误
    			$this->ajaxReturn(null, L('AnswerError') , 0);
    		}
    	}else{  //显示第一个界面
    		$SitePath = $this->_getSitePath( 'forgetpassword' );
    		$this->assign('SitePath', $SitePath);
    		$this->display();
    	}
    }
    
    function saveReg(){
    	header("Content-Type:text/html; charset=utf-8");
    	$this->checkReg();
    	
    	$reg = YdCache::readReg();
    	$_POST = YdInput::checkReg($_POST, array('MemberPassword','MemberPassword1') ); //防止xss注入
    	$MemberName = trim($_POST['MemberName']); 
    	$MemberPassword = trim($_POST['MemberPassword']);
    	$MemberPassword1 = trim($_POST['MemberPassword1']);
    	$MemberQuestion = trim($_POST['MemberQuestion']);
    	$MemberAnswer = trim($_POST['MemberAnswer']);
    	
    	$MemberEmail = trim($_POST['MemberEmail']);
    	$MemberTelephone = trim($_POST['MemberTelephone']);
    	$MemberMobile = trim($_POST['MemberMobile']);
    	$MemberQQ = trim($_POST['MemberQQ']);
    	$MemberAddress = trim($_POST['MemberAddress']);
    	
    	
    	if( $MemberName == '' ){
    		$this->ajaxReturn(null, L('UserNameRequired') , 0);
    	}
    	
    	if( $reg['MEMBER_REG_CHECK'] == '2' ){  //启用邮件验证，电子邮件不能为空
    		if( $MemberEmail == '' ){
    			$this->ajaxReturn(null, L('MemberEmailRequired') , 0);
    		}
    	}
    	
    	if( $MemberPassword == '' ){
    		$this->ajaxReturn(null, L('PasswordRequired') , 0);
    	}
    		
    	if( $MemberPassword1 == '' ){
    		$this->ajaxReturn(null, L('ConfirmPasswordRequired') , 0);
    	}
   		
    	if( $MemberPassword != $MemberPassword1 ){
    		$this->ajaxReturn(null, L('PasswordUnmatch') , 0);
    	}
    		
        //if( $MemberQuestion == '' ){
    	//	$this->ajaxReturn(null, L('QuestionRequired') , 0);
    	//}
    	
    	//if( $MemberAnswer =='' ){
    	//	$this->ajaxReturn(null, L('AnswerRequired') , 0);
    	//}

    	if( $reg['MEMBER_REG_VERIFYCODE'] == 1){ //启用验证码
    		$MemberCode = trim($_POST['MemberCode']);
	    	if($MemberCode==''){
	    		session('MemberCode', rand(1000, 9999) );
	    		$this->ajaxReturn(null, L('VerifyCodeRequired') , 0);
	    	}
	    	
	    	$MemberCode2 = session('membercode');
	    	if(md5($MemberCode) != $MemberCode2){
	    		session('MemberCode', rand(1000, 9999) );
	    		$this->ajaxReturn(null, L('VerifyCodeError') , 0);
	    	}
    	}
    	   	
    	$m = D('Admin/Member');
    	if( $m->create() ){
    		$m->RegisterTime = date('Y-m-d H:i:s');
    		$m->MemberPassword = md5($MemberPassword);
    		switch($reg['MEMBER_REG_CHECK']){
    			case '0':  //不审核
    				$success = L('RegSuccessNoCheck');
    				$m->IsCheck = 1;
    				break;
    			case '1':  //管理员验证
    				$success = L('RegSuccess');
    				$m->IsCheck = 0;
    				break;
    			case '2':  // 邮件认证
    				$m->IsCheck = 0;
    				$success = L('RegSuccessEmailCheck');
    				$code = md5(strtotime($m->RegisterTime));
    				break;
    		}
    		
    		if($m->add()){
    			if( $reg['MEMBER_REG_CHECK'] == '2' ){ //邮件激活
    				$c1 = YdCache::readBasic();
    				$WebName = $c1['WEB_NAME'];
    				$WebUrl = get_web_url(); //自动获取当前地址
    				if(C('URL_MODEL') == 1){
    					$WebUrl .= '/index.php';
    				}
    				
    				$EmailTitle = $WebName.' '.L('EmailActivateTitle');
    				$ActivateUrl = "{$WebUrl}/public/activate?code={$code}&name={$MemberName}&l=".LANG_SET;
    				$Activate = "<a href='$ActivateUrl' target='_blank'>$ActivateUrl</a>";
    				//变量解析==============================================
    				$EmailBody = str_ireplace('{$WebName}', $WebName, $reg['EMAIL_BODY']);
    				$EmailBody = str_ireplace('{$WebUrl}', $WebUrl, $EmailBody);
    				$EmailBody = str_ireplace('{$MemberName}', $MemberName, $EmailBody);
    				$EmailBody = str_ireplace('{$Activate}', $Activate, $EmailBody);
    				//====================================================
    				$b = sendwebmail($MemberEmail, $EmailTitle, $EmailBody);
    			}
    			$this->ajaxReturn(null, $success, 1);
    		}else{
    			$this->ajaxReturn(null, L('RegFail') , 0);
    		}
    	}else{
    		$this->ajaxReturn(null, $m->getError() , 0);
    	}
    }
    
    //邮件激活帐号
    function activate(){
    	$reg = YdCache::readReg();
    	if( $reg['MEMBER_REG_CHECK'] == '2' ){
	    	$code = trim($_GET['code']);   //校验码
	    	$name = trim($_GET['name']); //会员名称
	    	$m = D('Admin/Member');
	    	$where['MemberName'] = $name;
	    	$RegisterTime = $m->where( $where )->getField('RegisterTime');
	    	$mycode = md5( strtotime($RegisterTime) );
	    	if( $mycode == $code ){ //校验成功
	    		$b = $m->where($where)->setField('IsCheck', 1);
	    		if($b){
	    			$redirect = HomeUrl();
	    			alert(L('ActivateSuccess'), $redirect );
	    		}
	    	}
    	}
    }
	
    //微信认证接口
    function wxapi(){
        import("@.Common.YdWx");
        $wx = new YdWx();
        $wx->valid();
        $wx->responseMsg();
    }
    
    //获取点击次数接口
    function getInfoHit(){
    	header("Content-Type:text/html; charset=utf-8");
    	$InfoID = $_REQUEST['infoid'];
    	if( !is_numeric($InfoID) ){
    		return false;
    	}
    	$m = D('Admin/Info');
    	$InfoHit = $m->where("InfoID=$InfoID")->getField('InfoHit');
    	echo "document.write({$InfoHit})";
    }
    
    //增加点击次数
    function incInfoHit(){
    	header("Content-Type:text/html; charset=utf-8");
    	$InfoID = $_REQUEST['infoid'];
    	if( !is_numeric($InfoID) ){
    		return false;
    	}
    	$m = D('Admin/Info');
    	$m->IncHit($InfoID);
    	$NewInfoHit = $m->where("InfoID=$InfoID")->getField('InfoHit');
    	echo "document.write({$NewInfoHit})";
    }
    
    //购物车操作===========================================
    //添加到购物车
    function addCart(){
    	$InfoID = $_REQUEST['infoid'];
    	$Num = empty($_REQUEST['num']) ? 1 : $_REQUEST['num'];
    	if( is_numeric($InfoID) ){
    		import("@.Common.YdCart");
    		$cart = new YdCart();
    		$cart->addCart($InfoID, $Num);
    		$this->ajaxReturn(null, '添加成功!' , 1);
    	}else{
    		$this->ajaxReturn(null, '添加失败!' , 0);
    	}
    }
    
    function addNum(){
    	$InfoID = $_REQUEST['infoid'];
    	import("@.Common.YdCart");
    	$cart = new YdCart();
    	$totalPrice = $cart->addNum($InfoID);
    	$this->ajaxReturn($totalPrice, '' , 1);
    }
    
    function minusNum(){
    	$InfoID = $_REQUEST['infoid'];
    	import("@.Common.YdCart");
    	$cart = new YdCart();
    	$totalPrice = $cart->minuxNum($InfoID);
    	$this->ajaxReturn($totalPrice, '' , 1);
    }
    
    function delCart(){
    	$InfoID = $_REQUEST['infoid'];
    	import("@.Common.YdCart");
    	$cart = new YdCart();
    	$totalPrice = 0;
    	if( $InfoID == -1){
    		$totalPrice = $cart->clearCart(); //清空购物车
    		$this->ajaxReturn($totalPrice, '清空购物车成功!' , 1);
    	}else{
    		$totalPrice = $cart->delCart($InfoID);
    		$this->ajaxReturn($totalPrice, '删除成功!' , 1);
    	}
    }
    //==================================================
}
?>