DROP TABLE IF EXISTS `youdian_ad`;
CREATE TABLE `youdian_ad` (
  `AdID` int(11) NOT NULL auto_increment,
  `AdTypeID` tinyint(4) default NULL,
  `AdName` varchar(50) default NULL,
  `AdContent` text,
  `AdUrl` varchar(255) default NULL,
  `AdDescription` varchar(255) default NULL,
  `AdTime` datetime default NULL,
  `IsEnable` tinyint(4) NOT NULL default '1',
  `LanguageID` tinyint(4) NOT NULL default '1',
  `AdGroupID` int(11) default NULL,
  `AdOrder` int(11) default '0',
  PRIMARY KEY  (`AdID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_ad_group`;
CREATE TABLE `youdian_ad_group` (
  `AdGroupID` int(11) NOT NULL auto_increment,
  `AdGroupName` varchar(50) default NULL,
  `AdGroupDescription` text,
  `IsEnable` tinyint(4) NOT NULL default '1',
  `LanguageID` tinyint(4) default '1',
  PRIMARY KEY  (`AdGroupID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_ad_type`;
CREATE TABLE `youdian_ad_type` (
  `AdTypeID` tinyint(4) NOT NULL,
  `AdTypeName` char(20) default NULL,
  PRIMARY KEY  (`AdTypeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_admin`;
CREATE TABLE `youdian_admin` (
  `AdminID` int(11) NOT NULL auto_increment,
  `AdminName` varchar(50) default NULL,
  `MemberID` int(11) default NULL,
  `AdminGroupID` int(11) default NULL,
  `AdminPassword` varchar(64) default NULL,
  `LastLoginTime` datetime default NULL,
  `LastLoginIP` varchar(15) default NULL,
  `IsLock` tinyint(4) NOT NULL default '0',
  `IsSystem` tinyint(4) NOT NULL default '0',
  `LoginFailCount` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`AdminID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_admin_group`;
CREATE TABLE `youdian_admin_group` (
  `AdminGroupID` int(11) NOT NULL auto_increment,
  `AdminGroupName` varchar(50) default NULL,
  `AdminGroupRemark` varchar(255) default NULL,
  `MenuPurview` text,
  `MenuTopPurview` varchar(512) default NULL,
  `MenuGroupPurview` varchar(512) default NULL,
  `ChannelPurviewcn` text,
  `ChannelPurviewen` text,
  `IsSystem` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`AdminGroupID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_attribute`;
CREATE TABLE `youdian_attribute` (
  `AttributeID` int(11) NOT NULL auto_increment,
  `ChannelModelID` int(11) default NULL,
  `FieldName` varchar(50) default NULL,
  `FieldType` varchar(20) default NULL,
  `DisplayName` varchar(255) default NULL,
  `DisplayType` varchar(20) default NULL,
  `DisplayOrder` int(11) default '0',
  `DisplayWidth` varchar(10) default NULL,
  `DisplayHeight` varchar(10) default NULL,
  `DisplayClass` varchar(20) default NULL,
  `DisplayValue` varchar(255) default NULL,
  `DisplayHelpText` varchar(255) default NULL,
  `IsValidate` tinyint(4) default NULL,
  `ValidateRule` varchar(255) default NULL,
  `GroupID` int(4) default NULL,
  `IsRequire` tinyint(4) NOT NULL default '0',
  `IsEnable` tinyint(4) NOT NULL default '1',
  `IsSystem` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`AttributeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_banner`;
CREATE TABLE `youdian_banner` (
  `BannerID` int(11) NOT NULL auto_increment,
  `BannerName` varchar(50) default NULL,
  `BannerGroupID` int(11) NOT NULL default '1',
  `BannerImage` varchar(512) default NULL,
  `BannerThumbnail` varchar(512) default NULL,
  `BannerUrl` varchar(512) default NULL,
  `BannerOrder` int(11) NOT NULL default '0',
  `BannerDescription` text,
  `IsEnable` tinyint(4) NOT NULL default '1',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`BannerID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_banner_group`;
CREATE TABLE `youdian_banner_group` (
  `BannerGroupID` int(11) NOT NULL auto_increment,
  `BannerGroupName` char(50) default NULL,
  `BannerGroupOrder` int(11) NOT NULL default '0',
  `IsSystem` tinyint(4) NOT NULL default '0',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`BannerGroupID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_channel`;
CREATE TABLE `youdian_channel` (
  `ChannelID` int(11) NOT NULL auto_increment,
  `Parent` int(11) default NULL,
  `HasChild` tinyint(4) default NULL,
  `ChannelName` varchar(50) default NULL,
  `ChannelSName` varchar(20) default NULL,
  `ChannelContent` longtext,
  `ChannelSContent` text,
  `ChannelModelID` int(11) default NULL,
  `ChannelTarget` varchar(10) default NULL,
  `LinkUrl` varchar(512) default NULL,
  `HasPicture` tinyint(4) default '0',
  `ChannelPicture` varchar(255) default NULL,
  `Title` varchar(255) default NULL,
  `Keywords` varchar(255) default NULL,
  `Description` varchar(512) default NULL,
  `Html` varchar(50) default NULL,
  `ReadLevel` varchar(255) default NULL,
  `PageSize` int(11) default '20',
  `ChannelOrder` int(11) NOT NULL default '0',
  `IndexTemplate` varchar(50) default NULL,
  `ReadTemplate` varchar(50) default NULL,
  `IsEnable` tinyint(4) NOT NULL default '1',
  `IsLock` tinyint(4) NOT NULL default '0',
  `IsShow` tinyint(4) NOT NULL default '1',
  `IsSystem` tinyint(4) NOT NULL default '0',
  `IsHtml` tinyint(4) NOT NULL default '1',
  `LanguageID` tinyint(4) NOT NULL default '1',
  `f1` text,
  `f2` text,
  `f3` text,
  `ChannelIcon` varchar(255) default NULL,
  `ChannelStyle` tinyint(4) default '0',
  PRIMARY KEY  (`ChannelID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_channel_model`;
CREATE TABLE `youdian_channel_model` (
  `ChannelModelID` int(11) NOT NULL auto_increment,
  `ChannelModelName` varchar(50) default NULL,
  `ChannelModelOrder` int(11) NOT NULL default '0',
  `ChannelModelTable` varchar(50) default NULL,
  `ChannelModelDescription` varchar(255) default NULL,
  `IsSystem` tinyint(4) NOT NULL default '0',
  `IsEnable` tinyint(4) NOT NULL default '1',
  `IndexTemplate` varchar(50) default NULL,
  `ReadTemplate` varchar(50) default NULL,
  PRIMARY KEY  (`ChannelModelID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_collect`;
CREATE TABLE `youdian_collect` (
  `CollectID` int(11) NOT NULL auto_increment,
  `CollectName` varchar(255) default NULL,
  `ChannelID` int(11) default NULL,
  `ListUrlPara` text,
  `DetailUrlPara` text,
  `FieldPara` text,
  `ReplacePara` text,
  `OtherPara` text,
  `CreateTime` datetime default NULL,
  `CollectDescription` text,
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`CollectID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_comment`;
CREATE TABLE `youdian_comment` (
  `CommentID` int(11) NOT NULL auto_increment,
  `InfoID` int(11) NOT NULL,
  `GuestID` int(11) default NULL,
  `GuestName` varchar(50) default NULL,
  `GuestIP` varchar(20) default NULL,
  `CommentContent` text,
  `CommentTime` datetime default NULL,
  `IsCheck` tinyint(4) NOT NULL default '0',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`CommentID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_config`;
CREATE TABLE `youdian_config` (
  `ConfigID` int(11) NOT NULL auto_increment,
  `ConfigName` varchar(50) default NULL,
  `ConfigValue` text,
  `ConfigDescription` varchar(255) default NULL,
  `ConfigFile` varchar(20) default NULL,
  `IsEnable` tinyint(4) NOT NULL default '1',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`ConfigID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_customer`;
CREATE TABLE `youdian_customer` (
  `CustomerID` int(11) NOT NULL auto_increment,
  `Host` varchar(50) NOT NULL,
  `OS` varchar(20) default NULL,
  `Version` varchar(10) default NULL,
  `Edition` varchar(20) default NULL,
  `Name` varchar(50) default NULL,
  `Contact` varchar(20) default NULL,
  `Telephone` varchar(20) default NULL,
  `Mobile` varchar(20) default NULL,
  `QQ` varchar(20) default NULL,
  `TaoBao` varchar(20) default NULL,
  `Email` varchar(20) default NULL,
  `Date` date default NULL,
  `Remark` varchar(255) default NULL,
  `IsAuthorize` tinyint(1) default '0',
  PRIMARY KEY  (`CustomerID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_guestbook`;
CREATE TABLE `youdian_guestbook` (
  `MessageID` int(11) NOT NULL auto_increment,
  `GuestID` int(11) default '0',
  `GuestName` varchar(50) default NULL,
  `GuestIP` varchar(20) default NULL,
  `Contact` text,
  `MessageTitle` text,
  `MessageContent` text,
  `MessageTime` datetime default NULL,
  `AnswerContent` text,
  `AnswerTime` datetime default NULL,
  `IsCheck` tinyint(4) NOT NULL default '0',
  `LanguageID` tinyint(4) NOT NULL default '1',
  `f1` text,
  `f2` text,
  `f3` text,
  `f4` text,
  `f5` text,
  `Email` text,
  `Address` text,
  `Gender` text,
  `QQ` text,
  PRIMARY KEY  (`MessageID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_info`;
CREATE TABLE `youdian_info` (
  `InfoID` int(11) NOT NULL auto_increment,
  `ChannelID` int(11) default NULL,
  `SpecialID` varchar(512) default NULL,
  `MemberID` int(11) default NULL,
  `InfoTitle` varchar(100) default NULL,
  `InfoSContent` text,
  `InfoContent` longtext,
  `HasPicture` tinyint(4) NOT NULL default '0',
  `InfoPicture` varchar(255) default NULL,
  `ReadLevel` varchar(255) default NULL,
  `InfoAttachment` varchar(255) default NULL,
  `HasAttachment` tinyint(4) NOT NULL default '0',
  `IsLinkUrl` tinyint(4) NOT NULL default '0',
  `LinkUrl` varchar(255) default NULL,
  `Title` varchar(255) default NULL,
  `Keywords` varchar(255) default NULL,
  `Description` varchar(512) default NULL,
  `InfoOrder` int(11) NOT NULL default '0',
  `InfoTime` datetime default NULL,
  `InfoAuthor` varchar(50) default NULL,
  `InfoHit` int(11) default '0',
  `InfoFrom` varchar(50) default NULL,
  `LabelID` varchar(512) default NULL,
  `f1` text,
  `f2` text,
  `f3` text,
  `f4` text,
  `f5` text,
  `IsEnable` tinyint(4) NOT NULL default '1',
  `IsCheck` tinyint(4) NOT NULL default '0',
  `LanguageID` tinyint(4) NOT NULL default '1',
  `IsHtml` tinyint(4) NOT NULL default '1',
  `Html` varchar(50) default NULL,
  `InfoAlbum` text,
  `InfoRelation` varchar(255) default NULL,
  `Tag` varchar(255) default '',
  PRIMARY KEY  (`InfoID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_job`;
CREATE TABLE `youdian_job` (
  `JobID` int(11) NOT NULL auto_increment,
  `JobName` varchar(50) default NULL,
  `Education` varchar(50) default NULL,
  `Gender` varchar(10) default NULL,
  `Age` varchar(50) default NULL,
  `Salary` varchar(50) default NULL,
  `Language` varchar(20) default NULL,
  `Number` varchar(20) default NULL,
  `Workplace` varchar(50) default NULL,
  `Expiration` varchar(20) default NULL,
  `Requirement` text,
  `JobOrder` int(11) default '0',
  `Time` datetime default NULL,
  `IsEnable` tinyint(4) NOT NULL default '1',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`JobID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_label`;
CREATE TABLE `youdian_label` (
  `LabelID` int(11) NOT NULL auto_increment,
  `LabelName` char(20) default NULL,
  `ChannelModelID` int(11) default NULL,
  `LabelOrder` int(11) default '0',
  `IsSystem` tinyint(4) NOT NULL default '0',
  `IsEnable` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`LabelID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_language`;
CREATE TABLE `youdian_language` (
  `LanguageID` int(11) NOT NULL auto_increment,
  `LanguageName` varchar(20) default NULL,
  `LanguageMark` varchar(10) default NULL,
  `LanguageIcon` varchar(255) default NULL,
  `LanguageOrder` int(11) default '0',
  `IsEnable` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`LanguageID`)
) DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_link`;
CREATE TABLE `youdian_link` (
  `LinkID` int(11) NOT NULL auto_increment,
  `LinkClassID` int(11) default NULL,
  `LinkName` varchar(50) default NULL,
  `LinkType` tinyint(4) default '0',
  `LinkUrl` varchar(255) default NULL,
  `LinkLogo` varchar(255) default NULL,
  `LinkOrder` int(11) NOT NULL default '0',
  `LinkDescription` varchar(512) default NULL,
  `IsEnable` tinyint(4) NOT NULL default '1',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`LinkID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_link_class`;
CREATE TABLE `youdian_link_class` (
  `LinkClassID` int(11) NOT NULL auto_increment,
  `LinkClassName` varchar(50) default NULL,
  `LinkClassOrder` int(11) NOT NULL default '0',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`LinkClassID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_log`;
CREATE TABLE `youdian_log` (
  `LogID` int(11) NOT NULL auto_increment,
  `LogType` tinyint(4) default '1',
  `UserAction` varchar(255) default NULL,
  `UserName` varchar(100) default NULL,
  `UserIP` varchar(50) default NULL,
  `UserCity` varchar(50) default NULL,
  `LogTime` datetime default NULL,
  `LogDescription` text,
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`LogID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_mail`;
CREATE TABLE `youdian_mail` (
  `MailID` int(11) NOT NULL auto_increment,
  `MailClassID` int(11) default NULL,
  `MailAccount` varchar(50) default NULL,
  `Name` varchar(50) default NULL,
  `Telephone` varchar(20) default NULL,
  `Address` varchar(1024) default NULL,
  `AddTime` datetime default NULL,
  `Remark` varchar(1024) default NULL,
  `IsEnable` tinyint(4) default '1',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`MailID`)
) DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_mail_class`;
CREATE TABLE `youdian_mail_class` (
  `MailClassID` int(11) NOT NULL auto_increment,
  `MailClassName` varchar(50) default NULL,
  `MailClassOrder` int(11) NOT NULL default '0',
  `MailClassDescription` varchar(1024) default NULL,
  `IsEnable` tinyint(4) default '1',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`MailClassID`)
) DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_mail_send`;
CREATE TABLE `youdian_mail_send` (
  `MailSendID` int(11) NOT NULL auto_increment,
  `MailTitle` varchar(255) default NULL,
  `MailContent` text,
  `AddTime` datetime default NULL,
  `SendTime` datetime default NULL,
  `SendLog` text,
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`MailSendID`)
) DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_member`;
CREATE TABLE `youdian_member` (
  `MemberID` int(11) NOT NULL auto_increment,
  `MemberGroupID` int(11) default '1',
  `MemberName` varchar(50) default NULL,
  `MemberGender` tinyint(4) default '1',
  `MemberRealName` varchar(50) default NULL,
  `MemberPassword` varchar(64) default NULL,
  `MemberBirthday` date default NULL,
  `MemberAddress` varchar(100) default NULL,
  `MemberPostCode` varchar(6) default NULL,
  `MemberEmail` varchar(50) default NULL,
  `MemberTelephone` varchar(20) default NULL,
  `MemberMobile` varchar(20) default NULL,
  `MemberQQ` varchar(20) default NULL,
  `MemberQuestion` varchar(50) default NULL,
  `MemberAnswer` varchar(50) default NULL,
  `LastLoginTime` datetime default NULL,
  `LastLoginIP` varchar(15) default NULL,
  `RegisterTime` datetime default NULL,
  `IsCheck` tinyint(4) NOT NULL default '0',
  `IsLock` tinyint(4) NOT NULL default '0',
  `IsSystem` tinyint(4) NOT NULL default '0',
  `f1` text,
  `f2` text,
  `f3` text,
  `f4` text,
  `f5` text,
  `WxID` varchar(50) default NULL,
  `WxName` varchar(50) default NULL,
  `FromUser` varchar(50) default NULL,
  `Position` varchar(100) default NULL,
  `CardNumber` varchar(20) default NULL,
  `CardTime` datetime default NULL,
  `InviterID` int(11) default '0',
  PRIMARY KEY  (`MemberID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_member_group`;
CREATE TABLE `youdian_member_group` (
  `MemberGroupID` int(11) NOT NULL auto_increment,
  `MemberGroupName` varchar(50) default NULL,
  `MemberGroupRemark` varchar(512) default NULL,
  `MenuTopPurview` varchar(512) default NULL,
  `MenuGroupPurview` varchar(512) default NULL,
  `MenuPurview` text,
  `ChannelPurviewen` text,
  `ChannelPurviewcn` text,
  `IsSystem` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`MemberGroupID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_menu`;
CREATE TABLE `youdian_menu` (
  `MenuID` int(11) NOT NULL auto_increment,
  `MenuGroupID` int(6) default NULL,
  `MenuName` char(20) default NULL,
  `MenuContent` char(255) default NULL,
  `MenuType` tinyint(4) default '0',
  `MenuOrder` int(11) NOT NULL default '0',
  `SubMenu` char(255) default NULL,
  `IsEnable` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`MenuID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_menu_group`;
CREATE TABLE `youdian_menu_group` (
  `MenuGroupID` int(11) NOT NULL auto_increment,
  `MenuTopID` int(11) default NULL,
  `MenuGroupName` char(20) default NULL,
  `MenuGroupOrder` int(11) NOT NULL default '0',
  `IsEnable` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`MenuGroupID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_menu_operation`;
CREATE TABLE `youdian_menu_operation` (
  `MenuOperationID` int(11) NOT NULL auto_increment,
  `MenuID` int(11) default NULL,
  `MenuOperationName` char(40) default NULL,
  `ActionName` char(25) default NULL,
  `ModuleName` char(25) default NULL,
  `GroupName` char(25) default 'Admin',
  `MenuOperationOrder` int(11) default '0',
  `LogType` tinyint(4) default '1',
  `IsEnable` tinyint(4) default '1',
  PRIMARY KEY  (`MenuOperationID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_menu_top`;
CREATE TABLE `youdian_menu_top` (
  `MenuTopID` int(11) NOT NULL auto_increment,
  `MenuTopName` char(20) default NULL,
  `MenuTopUrl` char(255) default NULL,
  `MenuTopTarget` char(20) default NULL,
  `MenuTopOrder` int(11) NOT NULL default '0',
  `MenuOwner` tinyint(4) unsigned zerofill NOT NULL default '0000',
  `IsActive` tinyint(4) NOT NULL default '0',
  `IsEnable` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`MenuTopID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_order`;
CREATE TABLE `youdian_order` (
  `OrderID` int(11) NOT NULL auto_increment,
  `ProductName` varchar(255) NOT NULL,
  `GuestID` int(11) default NULL,
  `GuestName` varchar(20) default NULL,
  `Quantity` int(11) default NULL,
  `Telephone` varchar(50) default NULL,
  `QQ` varchar(20) default NULL,
  `Email` varchar(30) default NULL,
  `Address` varchar(100) default NULL,
  `Remark` text,
  `OrderTime` datetime default NULL,
  `AnswerContent` text,
  `AnswerTime` datetime default NULL,
  `LanguageID` tinyint(4) NOT NULL default '1',
  `f1` text,
  `f2` text,
  `f3` text,
  `f4` text,
  `f5` text,
  PRIMARY KEY  (`OrderID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_resume`;
CREATE TABLE `youdian_resume` (
  `ResumeID` int(11) NOT NULL auto_increment,
  `JobID` int(11) NOT NULL,
  `GuestID` int(11) default NULL,
  `GuestName` varchar(20) default NULL,
  `Gender` varchar(20) default NULL,
  `Birthday` date default NULL,
  `Ethnic` varchar(20) default NULL,
  `Salary` varchar(20) default NULL,
  `Political` varchar(20) default NULL,
  `Education` varchar(20) default NULL,
  `Telephone` varchar(50) default NULL,
  `Email` varchar(50) default NULL,
  `Address` varchar(50) default NULL,
  `Time` datetime default NULL,
  `Birthplace` varchar(20) default NULL,
  `Specialty` varchar(20) default NULL,
  `School` varchar(20) default NULL,
  `Detail` text,
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`ResumeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_special`;
CREATE TABLE `youdian_special` (
  `SpecialID` int(11) NOT NULL auto_increment,
  `ChannelID` int(11) default NULL,
  `SpecialName` char(50) default NULL,
  `SpecialDescription` char(255) default NULL,
  `SpecialOrder` int(11) NOT NULL default '0',
  `IsEnable` tinyint(4) NOT NULL default '1',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`SpecialID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_support`;
CREATE TABLE `youdian_support` (
  `SupportID` int(11) NOT NULL auto_increment,
  `SupportName` char(50) default NULL,
  `SupportTypeID` int(11) default NULL,
  `SupportNumber` text,
  `SupportOrder` int(11) NOT NULL default '0',
  `IsEnable` tinyint(4) NOT NULL default '1',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`SupportID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_support3`;
CREATE TABLE `youdian_support3` (
  `Support3ID` int(11) NOT NULL auto_increment,
  `Support3Js` text,
  `IsEnable` tinyint(4) NOT NULL default '1',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`Support3ID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_support_type`;
CREATE TABLE `youdian_support_type` (
  `SupportTypeID` int(11) NOT NULL auto_increment,
  `SupportTypeName` char(20) default NULL,
  `SupportTypeOrder` int(11) NOT NULL default '0',
  PRIMARY KEY  (`SupportTypeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_tag`;
CREATE TABLE `youdian_tag` (
  `TagID` int(11) NOT NULL auto_increment,
  `TagName` varchar(50) default NULL,
  `TagContent` text,
  `TagDescription` varchar(255) default NULL,
  `IsEnable` tinyint(4) NOT NULL default '1',
  `LanguageID` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (`TagID`)
) DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

DROP TABLE IF EXISTS `youdian_wx_app`;
CREATE TABLE `youdian_wx_app` (
  `AppID` int(11) NOT NULL auto_increment,
  `AppName` varchar(100) default NULL,
  `AppTypeID` tinyint(4) default '1',
  `AppKeyword` varchar(50) default NULL,
  `AppOrder` int(11) default '99',
  `AppParameter` text,
  `AppDescription` text,
  `IsEnable` tinyint(4) default '1',
  PRIMARY KEY  (`AppID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_apptype`;
CREATE TABLE `youdian_wx_apptype` (
  `AppTypeID` int(11) NOT NULL default '0',
  `AppTypeName` varchar(50) default NULL,
  `AppTypeOrder` int(11) default '99',
  `IsEnable` tinyint(4) default '1',
  PRIMARY KEY  (`AppTypeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_award`;
CREATE TABLE `youdian_wx_award` (
  `AwardID` int(11) NOT NULL auto_increment,
  `AppID` int(11) default NULL,
  `AwardNumber` tinyint(4) default NULL,
  `FromUser` varchar(50) default NULL,
  `Mobile` varchar(50) default NULL,
  `AwardSN` varchar(50) default NULL,
  `AwardTime` datetime default NULL,
  `AwardStatus` tinyint(4) default '0',
  `IsCheck` tinyint(4) default '0',
  PRIMARY KEY  (`AwardID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_consume`;
CREATE TABLE `youdian_wx_consume` (
  `ConsumeID` int(11) NOT NULL auto_increment,
  `MemberID` int(11) default NULL,
  `ConsumeType` tinyint(4) default NULL,
  `ConsumeMoney` int(11) default NULL,
  `ConsumeTime` datetime default NULL,
  `RelationID` int(11) default NULL,
  `Remark` text,
  PRIMARY KEY  (`ConsumeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_coupon`;
CREATE TABLE `youdian_wx_coupon` (
  `CouponID` int(11) NOT NULL auto_increment,
  `CouponName` varchar(50) default NULL,
  `CouponOrder` int(11) default '99',
  `StartTime` datetime default NULL,
  `EndTime` datetime default NULL,
  `CouponNumber` int(11) default '100',
  `Remark` text,
  `IsEnable` tinyint(4) default NULL,
  PRIMARY KEY  (`CouponID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_gift`;
CREATE TABLE `youdian_wx_gift` (
  `GiftID` int(11) NOT NULL auto_increment,
  `GiftName` varchar(50) default NULL,
  `GiftOrder` int(11) default '99',
  `StartTime` datetime default NULL,
  `EndTime` datetime default NULL,
  `Score` int(11) default '100',
  `GiftPicture` varchar(255) default NULL,
  `Remark` text,
  `IsEnable` tinyint(4) default NULL,
  PRIMARY KEY  (`GiftID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_menu`;
CREATE TABLE `youdian_wx_menu` (
  `MenuID` tinyint(4) NOT NULL auto_increment,
  `Parent` tinyint(4) default NULL,
  `MenuName` varchar(50) default NULL,
  `TypeID` tinyint(4) default NULL,
  `MenuOrder` int(11) default '0',
  `p1` text,
  `p2` text,
  `p3` text,
  `p4` text,
  `IsEnable` tinyint(4) default '1',
  PRIMARY KEY  (`MenuID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_message`;
CREATE TABLE `youdian_wx_message` (
  `MessageID` int(4) NOT NULL auto_increment,
  `MsgID` varchar(50) default NULL,
  `MsgType` varchar(10) default NULL,
  `FromUserName` varchar(50) default '3',
  `ToUserName` varchar(50) default NULL,
  `p1` text,
  `p2` text,
  `p3` text,
  `p4` text,
  `CreateTime` datetime default NULL,
  PRIMARY KEY  (`MessageID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_notify`;
CREATE TABLE `youdian_wx_notify` (
  `NotifyID` int(11) NOT NULL auto_increment,
  `NotifyName` varchar(255) default NULL,
  `NotifyContent` text,
  `NotifyTime` datetime default NULL,
  PRIMARY KEY  (`NotifyID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_question`;
CREATE TABLE `youdian_wx_question` (
  `QuestionID` int(11) NOT NULL auto_increment,
  `AppID` int(11) default NULL,
  `QuestionOrder` int(11) default '99',
  `QuestionName` varchar(255) default NULL,
  `QuestionItem` text,
  `IsMultiple` tinyint(4) default NULL,
  `IsEnable` tinyint(4) default NULL,
  PRIMARY KEY  (`QuestionID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_reply`;
CREATE TABLE `youdian_wx_reply` (
  `ReplyID` tinyint(4) NOT NULL auto_increment,
  `ReplyTypeID` tinyint(4) default '3',
  `Keyword` varchar(50) default NULL,
  `Priority` int(11) default '0',
  `TypeID` tinyint(4) default NULL,
  `Count` int(11) default '0',
  `p1` text,
  `p2` text,
  `p3` text,
  `p4` text,
  `IsEnable` tinyint(4) default '1',
  PRIMARY KEY  (`ReplyID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_research`;
CREATE TABLE `youdian_wx_research` (
  `ResearchID` int(11) NOT NULL auto_increment,
  `AppID` int(11) default NULL,
  `QuestionID` int(11) default NULL,
  `ItemID` int(11) default NULL,
  `FromUser` varchar(50) default NULL,
  `ResearchTime` datetime default NULL,
  PRIMARY KEY  (`ResearchID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_score`;
CREATE TABLE `youdian_wx_score` (
  `ScoreID` int(11) NOT NULL auto_increment,
  `MemberID` int(11) default NULL,
  `ScoreNumber` int(11) default NULL,
  `ScoreTime` datetime default NULL,
  `ScoreType` tinyint(4) default NULL,
  `RelationID` int(11) default NULL,
  `Remark` text,
  PRIMARY KEY  (`ScoreID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_suggest`;
CREATE TABLE `youdian_wx_suggest` (
  `SuggestID` int(11) NOT NULL auto_increment,
  `AppID` int(11) default NULL,
  `FromUser` varchar(50) default NULL,
  `SuggestContent` text,
  `SuggestTime` datetime default NULL,
  PRIMARY KEY  (`SuggestID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_type`;
CREATE TABLE `youdian_wx_type` (
  `TypeID` tinyint(4) NOT NULL auto_increment,
  `TypeName` varchar(50) default NULL,
  `IsReply` tinyint(11) default '1',
  `TypeOrder` tinyint(4) unsigned default '0',
  `IsEnable` tinyint(4) default '1',
  PRIMARY KEY  (`TypeID`)
) DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `youdian_wx_vote`;
CREATE TABLE `youdian_wx_vote` (
  `VoteID` int(11) NOT NULL auto_increment,
  `AppID` int(11) default NULL,
  `ItemID` int(11) default NULL,
  `FromUser` varchar(50) default NULL,
  `VoteTime` datetime default NULL,
  PRIMARY KEY  (`VoteID`)
) DEFAULT CHARSET=utf8;


INSERT INTO `youdian_ad_group` VALUES
('1','默认广告分组','','1','1'),
('2','default ad group','','1','2');

INSERT INTO `youdian_ad_type` VALUES
('1','图片广告'),
('2','文字广告'),
('3','动画/视频广告'),
('4','代码广告');

INSERT INTO `youdian_admin` VALUES
('1','admin','1','1','ed9f2df6c3b16155f6981c23a99afc9e','2015-12-11 10:46:00','192.168.1.80','0','1','0');

INSERT INTO `youdian_admin_group` VALUES
('1','超级管理组','超级管理组拥有所有权限',NULL,NULL,NULL,NULL,NULL,'1'),
('2','频道管理员','','8,74','1,2,3,8','5,3','33,15,17,18,19,55,20,21,22,23,24,25,26,27,28,29,32,30,31,53','34,35,37,40,41,43,47,48,50,51,52,54','0');

INSERT INTO `youdian_attribute` VALUES
('2','1','Parent','int','所属频道','channelselect','0','',NULL,NULL,'',NULL,NULL,NULL,'22','0','1','1'),
('3','1','Child','varchar','子类频道','select','50','270px',NULL,NULL,'',NULL,NULL,NULL,'22','0','0','0'),
('4','1','ChannelName','varchar','频道名称','text','1','270px',NULL,'textinput',NULL,'',NULL,NULL,'22','1','1','0'),
('5','1','ChannelSName','varchar','简短名称','text','8','270px','','textinput','','如：新闻、图片、文章等','0','','22','0','1','0'),
('6','1','ChannelContent','text','详细内容','editor','5','100%','300px',NULL,NULL,NULL,NULL,NULL,'24','0','1','0'),
('7','1','ChannelSContent','text','简短内容','textarea','4','100%','65px',NULL,NULL,NULL,NULL,NULL,'24','0','1','0'),
('8','1','ChannelModelID','int','频道模型','modelselect','3','','',NULL,NULL,NULL,NULL,NULL,'22','0','1','0'),
('9','1','ChannelTarget','varchar','链接目标','select','7',NULL,NULL,NULL,'_self|当前窗口_self\r\n_blank|新窗口_blank','',NULL,NULL,'22','0','1','0'),
('10','1','HasPicture','int','是否启用代表图片','radio','2',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'24','0','0','0'),
('11','1','ChannelPicture','varchar','频道代表图片','image','2','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'24','0','1','0'),
('12','1','Keywords','varchar','页面关键词Keywords','text','12','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'23','0','1','1'),
('13','1','Description','varchar(512)','页面描述Description','textarea','13','100%',NULL,NULL,NULL,'设置页面描述，留空表示继承上级频道设置！建议不要超过200个字符！',NULL,NULL,'23','0','1','1'),
('14','1','PageSize','int','分页条数','text','10','270px',NULL,'textinput','20',NULL,NULL,NULL,'22','0','1','0'),
('15','1','ChannelOrder','int','频道排序','text','9','270px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'22','0','1','0'),
('16','1','IndexTemplate','varchar','频道首页模板','text','5','270px',NULL,'textinput','article.html','请输入模板文件名称，以html为扩展名！如：article.html',NULL,NULL,'22','0','1','0'),
('17','1','ReadTemplate','varchar','频道阅读模板','text','6','270px',NULL,'textinput','showarticle.html','请输入模板文件名称，以html为扩展名！如：showarticle.html',NULL,NULL,'22','0','1','0'),
('18','1','IsEnable','int','是否启用频道','radio','18',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'22','0','1','0'),
('19','1','IsLock','int','频道是否锁定','radio','17',NULL,NULL,NULL,'1|锁定\r\n0|不锁定|1',NULL,NULL,NULL,'22','0','1','0'),
('20','1','IsShow','int','频道是否显示','radio','16',NULL,NULL,NULL,'1|显示|1\r\n0|隐藏',NULL,NULL,NULL,'22','0','1','0'),
('21','1','IsSystem','int','是否是系统频道','radio','21',NULL,NULL,NULL,'1|是|1\r\n0|否',NULL,NULL,NULL,'22','0','0','0'),
('22','1',NULL,NULL,'基本信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('23','1',NULL,NULL,'搜索引擎优化设置',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('24','1',NULL,NULL,'频道内容',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('25','2','SpecialID','int','专题编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'30','0','2','0'),
('26','2','ChannelID','int','所属频道','channelselect','2',NULL,NULL,NULL,'所有频道',NULL,NULL,NULL,'30','0','1','0'),
('27','2','SpecialName','varchar','专题名称','text','3','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'30','1','1','0'),
('28','2','SpecialDescription','varchar','专题描述','textarea','5','100%','100px',NULL,NULL,NULL,NULL,NULL,'30','0','1','0'),
('29','2','IsEnable','int','是否启用','radio','6',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'30','0','1','0'),
('30','2',NULL,NULL,'专题信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('31','2','SpecialOrder','int','专题排序','text','4',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'30','0','1','0'),
('32','30','InfoID','int','信息ID','text','1','','','textinput','','','0','','54','0','0','1'),
('33','30','ChannelID','int','所属频道','channelselect','2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'54','0','1','1'),
('34','30','SpecialID','varchar','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'54','0','1','1'),
('35','30','InfoTitle','varchar','文章标题','text','4','50%','','textinput','','','0','','54','1','1','1'),
('36','30','InfoSContent','varchar','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,NULL,NULL,'54','0','1','0'),
('37','30','InfoContent','varchar','详细内容','editor','8','100%','400px',NULL,NULL,NULL,NULL,NULL,'54','0','1','0'),
('38','30','HasPicture','int','是否启用代表图片','radio','5','','','','1|启用\n0|禁用|1','','0','','54','0','0','0'),
('39','30','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'54','0','1','0'),
('40','30','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','20','','','textinput','','不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效','0','','55','0','1','1'),
('41','30','InfoAttachment','varchar(255)','附件','attachment','11','50%',NULL,'textinput',NULL,'',NULL,NULL,'55','0','1','0'),
('42','30','HasAttachment','int','是否启用附件','radio','10','','','','1|启用\n0|禁用|1','','0','','55','0','0','0'),
('43','30','IsLinkUrl','int','是否是转向链接','radio','12','','','','1|是\n0|否|1','','0','','55','0','0','1'),
('44','30','LinkUrl','varchar(255)','转向链接','text','13','270px','','textinput','','请输入转向链接地址！如：http://www.baidu.cn','0','','55','0','1','0'),
('45','30','Keywords','varchar','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'56','0','1','1'),
('46','30','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'56','0','1','1'),
('47','30','InfoOrder','int','排序','text','16',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'55','0','1','1'),
('48','30','InfoTime','datetime','发表时间','datetime','19','',NULL,'textinput',NULL,NULL,NULL,NULL,'55','0','1','0'),
('49','30','InfoAuthor','varchar','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'55','0','0','0'),
('51','30','InfoHit','int','点击次数','text','19','',NULL,'textinput','0',NULL,NULL,NULL,'55','0','1','1'),
('52','30','InfoFrom','varchar','来源','text','18',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'55','0','1','0'),
('53','30','IsEnable','int','是否启用','radio','23',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'55','0','1','1'),
('54','30',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('55','30',NULL,NULL,'其它信息',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('56','30',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('57','32',NULL,NULL,'基本信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('58','32',NULL,NULL,'搜索引擎优化设置',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('59','32','ChannelContent','varchar','详细内容','editor','3','100%','300px',NULL,NULL,NULL,NULL,NULL,'57','0','1','0'),
('60','32','Keywords','varchar','页面关键字Keywords','text','2','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'58','0','1','1'),
('61','32','Description','varchar(512)','页面描述Description','textarea','3','100%',NULL,'textinput',NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'58','0','1','1'),
('62','32','HasPicture','int','是否启用代表图片','radio','2','',NULL,'','1|启用\r\n0|禁用|1',NULL,NULL,NULL,'57','0','0','0'),
('63','32','ChannelPicture','varchar','代表图片','image','1','100%',NULL,'textinput','',NULL,NULL,NULL,'57','0','1','0'),
('64','31',NULL,NULL,'基本信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('65','31',NULL,NULL,'搜索引擎优化设置',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('66','31',NULL,NULL,'其它信息',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('67','31','InfoID','int','信息ID','text','1','','','textinput','','',NULL,'','64','0','0','1'),
('68','31','ChannelID','int','所属频道','channelselect','2','','','','','',NULL,'','64','0','1','1'),
('69','31','SpecialID','varchar','所属专题','specialselect','3','','','','','',NULL,'','64','0','1','1'),
('70','31','InfoTitle','varchar','图片标题','text','4','50%','','textinput','','','0','','64','1','1','1'),
('71','31','InfoSContent','varchar','简短内容','textarea','7','100%','70px','','','','0','','64','0','1','0'),
('72','31','InfoContent','varchar','详细内容','editor','8','100%','400px','','','',NULL,'','64','0','1','0'),
('73','31','HasPicture','int','是否启用代表图片','radio','5','','','','1|启用\r\n0|禁用|1',NULL,NULL,NULL,'64','0','0','0'),
('74','31','InfoPicture','varchar(255)','缩略图','image','6','100%','','textinput','','',NULL,'','64','0','1','0'),
('75','31','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','7','','','textinput','','不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效','0','','66','0','1','1'),
('76','31','InfoAttachment','varchar(255)','附件','attachment','1','50%','','textinput','','',NULL,'','66','0','1','0'),
('77','31','HasAttachment','int','是否启用附件','radio','1','','','','1|启用|1\n0|禁用','','0','','66','0','0','0'),
('78','31','InfoAuthor','varchar','作者','text','4','270px','','textinput','','',NULL,'','66','0','0','0'),
('79','31','IsLinkUrl','int','是否是转向链接','radio','2','','','','1|是\n0|否|1','','0','','66','0','0','1'),
('80','31','InfoHit','int','点击次数','text','5','','','textinput','0','',NULL,'','66','0','1','1'),
('81','31','LinkUrl','varchar(255)','转向链接','text','2','270px','','textinput','','请输入转向链接地址！如：http://www.baidu.com','0','','66','0','1','0'),
('82','31','Keywords','varchar','页面关键词 Keywords','text','1','100%','','textinput','','设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,'','65','0','1','1'),
('83','31','Description','varchar(512)','页面描述 Description','textarea','2','100%','','','','设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,'','65','0','1','1'),
('85','31','InfoTime','datetime','发表时间','datetime','6','','','textinput','','',NULL,'','66','0','1','0'),
('86','31','IsEnable','int','是否启用','radio','29','','','','1|启用|1\r\n0|禁用',NULL,NULL,NULL,'66','0','1','1'),
('87','31','InfoOrder','int','排序','text','3','','','textinput','0','请输入数字，值越小排名越靠前！',NULL,'','66','0','1','1'),
('88','30','LabelID','varchar','属性','labelcheckbox','21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'55','0','1','1'),
('89','31','LabelID','varchar','属性','labelcheckbox','8','','','','','',NULL,'','66','0','1','1'),
('90','1','LinkUrl','varchar(255)','转向链接','text','14','270px',NULL,'textinput',NULL,'如：http://www.baidu.com。频道模型为\"链接模型\"时有效！',NULL,NULL,'22','0','1','0'),
('91','33','ChannelTarget','varchar','链接目标','select','2','','','','_self|当前窗口_self\r\n_blank|新窗口_blank',NULL,NULL,NULL,'93','0','1','0'),
('92','33','LinkUrl','varchar(255)','转向链接','text','3','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'93','0','1','0'),
('93','33',NULL,NULL,'基本信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('94','33','ChannelName','varchar','频道名称','text','1','270px','','textinput','','',NULL,'','93','1','1','0'),
('95','3','BannerID','int','幻灯片编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','0','0'),
('96','3','BannerName','varchar','幻灯片名称','text','2','420px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('97','3','BannerImage','varchar','幻灯图片','image','4','420px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('98','3','BannerUrl','varchar','链接地址','text','5','420px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('99','3','BannerOrder','int','幻灯片排序','text','6','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'101','0','1','0'),
('100','3','IsEnable','int','是否启用','radio','7',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'101','0','1','0'),
('101','3',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('102','4',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('103','4','SupportID','int','客服编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'102','0','0','0'),
('104','4','SupportName','varchar','客服名称','text','2','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'102','1','1','0'),
('105','4','SupportTypeID','int','客服类型','supporttypeselect','3',NULL,NULL,'',NULL,'选择自定义类型，填写自定义客服HTML代码，可实现一键加QQ群、自定义QQ图标、发邮件等高级功能',NULL,NULL,'102','0','1','0'),
('106','4','SupportNumber','varchar','客服号码','textarea','4','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'102','0','1','0'),
('107','4','SupportOrder','int','客服排序','text','5','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'102','0','1','0'),
('108','4','IsEnable','int','是否启用','radio','6',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'102','0','1','0'),
('109','5','','','基本信息','text',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('110','5','Support3ID','text','第三方客服编号','text','1',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'109','0','0','0'),
('111','5','Support3Js','int','第三方客服Js脚本','textarea','2','100%','300px','textinput',NULL,NULL,NULL,NULL,'109','0','1','0'),
('112','5','IsEnable','int','是否启用','radio','3',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'109','0','1','0'),
('113','9','LinkClassID','int','友情链接分类编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'117','0','0','0'),
('114','9','LinkClassName','varchar','友情链接分类名称','text','2','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'117','1','1','0'),
('115','9','LinkClassOrder','int','友情链接分类排序','text','3','270px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'117','0','1','0'),
('117','9',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('118','10',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('119','10','LinkID','int','友情链接编号','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'118','0','0','0'),
('120','10','LinkClassID','int','链接分类','linkclassselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'118','0','1','0'),
('121','10','LinkType','int','链接类型','radio','1',NULL,NULL,NULL,'1|文字|1\r\n2|图片',NULL,NULL,NULL,'118','0','1','0'),
('122','10','LinkUrl','varchar(255)','链接地址','text','3','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'118','0','1','0'),
('123','10','LinkOrder','int','链接排序','text','7','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'118','0','1','0'),
('124','10','IsEnable','int','是否启用','radio','9',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'118','0','1','0'),
('125','10','LinkName','varchar','链接名称','text','2','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'118','1','1','0'),
('126','10','LinkLogo','varchar','链接Logo','image','4','420px',NULL,'textinput',NULL,'鼠标移动到文本框可以预览Logo',NULL,NULL,'118','0','1','0'),
('127','10','LinkDescription','varchar','链接描述','textarea','8','100%','100px','textinput',NULL,NULL,NULL,NULL,'118','0','1','0'),
('128','7',NULL,NULL,'招聘信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('129','7','JobID','int','招聘编号','text','1','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','0','0'),
('130','7','JobName','varchar','职位名称','text','2','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','1','1','0'),
('131','7','Education','varchar','学位要求','text','3','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('132','7','Gender','varchar','性别要求','text','4','192px',NULL,'textinput','',NULL,NULL,NULL,'128','0','1','0'),
('133','7','Age','varchar','年龄要求','text','5','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('134','7','Salary','varchar','薪水','text','6','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('135','7','Language','varchar','语言要求','text','7','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('136','7','Number','varchar','招聘人数','text','8','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('137','7','Workplace','varchar','工作地点','text','9','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('138','7','Expiration','varchar','截至日期','text','10','192px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('139','7','Requirement','varchar','详细要求','editormini','11','100%','250px','textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('140','7','JobOrder','int','职位排序','text','12','80px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'128','0','1','0'),
('141','7','IsEnable','int','是否启用','radio','14',NULL,NULL,'','1|启用|1\r\n0|禁用',NULL,NULL,NULL,'128','0','1','0'),
('142','7','Time','datetime','发布时间','datetime','13','150px',NULL,'textinput',NULL,NULL,NULL,NULL,'128','0','1','0'),
('143','8','CommentID','int','评论编号','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('144','8','InfoID','int','信息ID','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','0','1'),
('145','8','GuestID','int','评论人ID','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('146','8','GuestName','varchar','评论人','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('147','8','GuestIP','varchar','评论人IP','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('148','8','CommentContent','varchar','评论内容','textarea','6','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('149','8','CommentTime','datetime','评论时间','datetime','7','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'151','0','1','0'),
('150','8','IsCheck','int','是否审核','radio','8',NULL,NULL,NULL,'1|是|1\r\n0|否',NULL,NULL,NULL,'151','0','1','0'),
('151','8','',NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('152','11',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('153','11','AdID','int','广告编号','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','0','0'),
('154','11','AdTypeID','int','广告类型','adtyperadio','2','',NULL,NULL,NULL,NULL,NULL,NULL,'152','0','1','0'),
('155','11','AdName','varchar','广告名称','text','3','550px',NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('156','11','AdContent','varchar','广告内容','image','4','100%','100px','textinput',NULL,'',NULL,NULL,'152','0','1','0'),
('157','11','AdUrl','varchar','广告地址','text','5','550px',NULL,'textinput',NULL,'广告地址以http://开头，如：http://www.xx.com',NULL,NULL,'152','0','1','0'),
('158','11','AdDescription','varchar','广告描述','textarea','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('159','11','AdTime','datetime','发布时间','datetime','7','150px',NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('160','11','IsEnable','int','是否启用','radio','8',NULL,NULL,NULL,'1|是|1\r\n0|否',NULL,NULL,NULL,'152','0','1','0'),
('161','12',NULL,NULL,'添加会员分组',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('162','12','MemberGroupID','int','会员分组ID','text','1','200px',NULL,'',NULL,NULL,NULL,NULL,'161','0','0','0'),
('163','12','MemberGroupName','varchar','会员分组名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'161','1','1','0'),
('164','12','MemberGroupRemark','varchar','会员分组备注','text','3','200px','','textinput',NULL,NULL,NULL,NULL,'161','0','1','0'),
('165','12','IsSystem','int','是否是系统分组','radio','4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'161','0','0','0'),
('166','13',NULL,NULL,'会员信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('167','13','MemberID','int','会员编号','text','1','120px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','0','1'),
('168','13','MemberGroupID','int','会员分组','membergroupselect','2','',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('169','13','MemberName','varchar','会员名称','text','3','120px','','textinput','','','0','','166','1','1','1'),
('170','13','MemberGender','int','性别','radio','4',NULL,NULL,NULL,'1|女\r\n0|男|1',NULL,NULL,NULL,'166','0','1','1'),
('171','13','MemberRealName','varchar','真实姓名','text','5','120px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('172','13','MemberPassword','varchar','密码','text','6','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','0','1'),
('173','13','MemberBirthday','date','生日','date','7','120px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('174','13','MemberAddress','varchar','联系地址','text','15','280px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('175','13','MemberPostCode','varchar','邮政编码','text','9','120px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('176','13','MemberEmail','varchar','电子邮件','text','14','180px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('177','13','MemberTelephone','varchar','电话','text','11','180px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('178','13','MemberMobile','varchar','移动电话','text','12','180px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('179','13','MemberQQ','varchar','QQ','text','14','180px',NULL,'textinput',NULL,NULL,NULL,NULL,'166','0','1','1'),
('180','13','MemberQuestion','varchar','问题','text','17','280px',NULL,'textinput',NULL,'如：我初中地理老师是谁？我爸爸叫什么名字？',NULL,NULL,'166','0','1','1'),
('181','13','MemberAnswer','varchar','答案','text','18','280px',NULL,'textinput',NULL,'找回密码的重要依据，认真填写并记牢！',NULL,NULL,'166','0','1','1'),
('182','13','IsCheck','int','是否审核','radio','41',NULL,NULL,NULL,'1|是|1\r\n0|否',NULL,NULL,NULL,'166','0','1','1'),
('183','13','LastLoginTime','datetime','最后登录时间','label','21','150px',NULL,'',NULL,NULL,NULL,NULL,'166','0','1','1'),
('184','13','LastLoginIP','varchar','最后登录IP','label','20','150px',NULL,'',NULL,NULL,NULL,NULL,'166','0','1','1'),
('185','13','RegisterTime','datetime','注册时间','label','22','150px',NULL,'',NULL,NULL,NULL,NULL,'166','0','1','1'),
('186','13','IsLock','int','是否锁定','radio','40',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'166','0','1','1'),
('187','13','IsSystem','int','是否系统','radio','42',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'166','0','0','1'),
('188','15','AdminGroupID','int','管理组ID','text','1','170px',NULL,'textinput',NULL,NULL,NULL,NULL,'193','0','0','0'),
('189','15','AdminGroupName','varchar','管理组名称','text','2','170px',NULL,'textinput',NULL,NULL,NULL,NULL,'193','1','1','0'),
('190','15','AdminGroupRemark','varchar','管理组备注','text','3','170px','','textinput',NULL,NULL,NULL,NULL,'193','0','1','0'),
('191','15','MenuPurview','varchar','管理组权限','text','4','150px',NULL,'textinput',NULL,NULL,NULL,NULL,'193','0','0','0'),
('192','15','IsSystem','int','是否是系统','radio','5',NULL,NULL,'','1|是\r\n0|否|1',NULL,NULL,NULL,'193','0','0','0'),
('193','15',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('194','14',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('195','14','AdminID','int',NULL,'text','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'194','0','0','0'),
('196','14','AdminName','varchar','管理员名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'194','1','1','0'),
('197','14','MemberID','int',NULL,'text','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'194','0','0','0'),
('198','14','AdminGroupID','int','管理组','admingroupselect','4','',NULL,NULL,NULL,NULL,NULL,NULL,'194','0','1','0'),
('199','14','AdminPassword','varchar','密码','text','5',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'194','0','0','0'),
('200','14','LastLoginTime','varchar','最后登录时间','label','6','200px',NULL,'',NULL,NULL,NULL,NULL,'194','0','1','0'),
('201','14','LastLoginIP','varchar','最后登录IP','label','7','200px',NULL,'',NULL,NULL,NULL,NULL,'194','0','1','0'),
('202','14','IsLock','int','是否锁定','radio','8',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'194','0','1','0'),
('203','14','IsSystem','int','是否是系统','radio','9',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'194','0','0','0'),
('204','16','',NULL,'模板文件',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('205','16','FileName','varchar','文件名称','label','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'204','0','1','0'),
('206','16','FileContent','varchar','文件内容','editor','2','100%','500px',NULL,NULL,NULL,NULL,NULL,'204','0','1','0'),
('207','1','Title','varchar','页面标题Title','text','11','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设',NULL,NULL,'23','0','1','1'),
('208','30','Title','varchar','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','56','0','1','1'),
('209','31','Title','varchar','页面标题Title','text','0','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设',NULL,NULL,'65','0','1','1'),
('210','32','Title','varchar','页面标题Title','text','1','100%',NULL,'textinput',NULL,'设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设',NULL,NULL,'58','0','1','1'),
('211','17','TagID','int','自定义标签ID','text','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'215','0','0','0'),
('212','17','TagName','varchar','自定义标签名称','text','1','250px',NULL,'textinput',NULL,'名称只能使用英文字母、数字，并且必须以英文字母开头，不能与系统标签同名，否则会覆盖系统标签。在前台通过{$标签名称}调用！',NULL,NULL,'215','1','1','0'),
('213','17','TagDescription','varchar','自定义标签描述','text','2','100%','','textinput',NULL,'',NULL,NULL,'215','0','1','0'),
('214','17','TagContent','varchar','自定义标签内容','editormini','3','100%','315px','textinput',NULL,'',NULL,NULL,'215','0','1','0'),
('215','17',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('216','17','IsEnable','int','是否启用自定义标签','radio','4',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'215','0','1','0'),
('217','18','LabelID','int','属性标记编号','text','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'223','0','0','0'),
('218','18','LabelName','varchar','属性标记名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'223','1','1','0'),
('219','18','ChannelModelID','int','所属频道模型','modelselect','3','',NULL,'',NULL,NULL,NULL,NULL,'223','0','1','0'),
('220','18','LabelOrder','int','属性标记排序','text','4','200px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'223','0','1','0'),
('221','18','IsSystem','int','是否是系统','radio','5',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'223','0','0','0'),
('222','18','IsEnable','int','是否启用','radio','6',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'223','0','1','0'),
('223','18',NULL,NULL,'基本信息',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('224','32','ChannelSContent','varchar','简短内容','textarea','2','100%','70px','textinput',NULL,NULL,NULL,NULL,'57','0','1','0'),
('225','1','Html','varchar','静态页面名称','text','1','150px',NULL,'textinput',NULL,'设置频道在前台页面显示的静态文件名称，无需添加扩展名，常常以频道名称拼音命名，<b>留空则取频道名称拼音首字母作为页面名称！</b>如：wangzhanjianshe',NULL,NULL,'23','0','1','0'),
('226','19','ChannelModelID','int','频道模型编号','text','0','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'233','0','0','0'),
('227','19','ChannelModelName','varchar','频道模型名称','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'233','1','1','0'),
('228','19','ChannelModelOrder','int','频道模型排序','text','2','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'233','0','1','0'),
('229','19','ChannelModelTable','varchar','表名','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'233','0','0','0'),
('230','19','ChannelModelDescription','varchar','频道模型描述','textarea','4','100%','80px','textinput',NULL,NULL,NULL,NULL,'233','0','1','0'),
('231','19','IsSystem','int','是否是系统','radio','5',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'233','0','0','0'),
('232','19','IsEnable','int','是否是启用','radio','6',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'233','0','1','0'),
('233','19',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('234','20',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('235','20','AttributeID','int','属性编号','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','0','0'),
('236','20','ChannelModelID','int','所属频道模型','label','2','',NULL,'',NULL,NULL,NULL,NULL,'234','0','1','0'),
('237','20','FieldName','varchar','字段名称','label','4','',NULL,'',NULL,NULL,NULL,NULL,'234','0','1','0'),
('238','20','FieldType','varchar','字段类型','label','5','200px',NULL,'',NULL,NULL,NULL,NULL,'234','0','1','0'),
('239','20','DisplayName','varchar','显示名称','text','6','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('240','20','DisplayType','varchar','显示类型','displaytypeselect','7','',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('241','20','DisplayOrder','int','排序','text','8','100px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'234','0','1','0'),
('242','20','DisplayWidth','varchar','宽度','text','9','100px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('243','20','DisplayHeight','varchar','高度','text','10','100px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('244','20','DisplayClass','varchar','样式表类','text','11','100px',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('245','20','DisplayValue','varchar','默认值','textarea','12','280px','85px','textinput',NULL,'格式：值|文本|是否选中(1:表示选中，不填表示未选中)，每项回车分开！例如：1|启用|1',NULL,NULL,'234','0','1','0'),
('246','20','DisplayHelpText','varchar','帮助文字','text','13','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'234','0','1','0'),
('247','20','IsValidate','int','是否验证','radio','14',NULL,NULL,NULL,'1|启用验证\r\n0|禁用验证|1',NULL,NULL,NULL,'234','0','1','0'),
('248','20','ValidateRule','varchar','验证正则表达式','text','15','300px',NULL,'textinput','',NULL,NULL,NULL,'234','0','1','0'),
('249','20','GroupID','int','所属分组','attributegroupselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'234','0','1','0'),
('250','20','IsEnable','int','是否启用','radio','17',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'234','0','1','0'),
('251','20','IsSystem','int','是否是系统','radio','18',NULL,NULL,NULL,'1|系统|1\r\n0|自定义',NULL,NULL,NULL,'234','0','0','0'),
('252','21',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('253','21','AttributeID','int','字段分组编号','text','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'252','0','0','0'),
('254','21','DisplayName','varchar','字段分组名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'252','1','1','0'),
('255','21','IsEnable','int','是否启用','radio','4',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'252','0','1','0'),
('256','21','DisplayOrder','int','排序','text','3','80px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'252','0','1','0'),
('257','30','f1','varchar','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('258','30','f2','varchar','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('259','30','f3','varchar','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('260','30','f4','varchar','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('261','30','f5','varchar','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'262','0','0','0'),
('262','30',NULL,NULL,'扩展分组1',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('263','30',NULL,NULL,'扩展分组2',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('264','31','f1','varchar','扩展字段1','text','1','200px','','textinput','','','0','','269','0','0','0'),
('265','31','f2','varchar','扩展字段2','text','2','200px','','textinput','','','0','','269','0','0','0'),
('266','31','f3','varchar','扩展字段3','text','3','200px','','textinput','','','0','','269','0','0','0'),
('267','31','f4','varchar','扩展字段4','text','4','200px','','textinput','','','0','','269','0','0','0'),
('268','31','f5','varchar','扩展字段5','text','5','200px','','textinput','','','0','','269','0','0','0'),
('269','31',NULL,NULL,'扩展分组1',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('270','31',NULL,NULL,'扩展分组2',NULL,'10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('271','34',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('272','34',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('273','34',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('274','34',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('275','34',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('276','34','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'271','0','1','1'),
('277','34','SpecialID','varchar(512)','所属专题','specialselect','2','','','','','','0','','271','0','1','1'),
('278','34','InfoTitle','varchar','视频标题','text','3','50%','','textinput','','','0','','271','1','1','1'),
('279','34','InfoSContent','text','简短内容','textarea','7','100%','70px','','','','0','','271','0','1','0'),
('280','34','InfoContent','text','详细内容','editor','8','100%','400px','','','','0','','271','0','1','0'),
('281','34','HasPicture','int','是否启用代表图片','radio','50','',NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'272','0','0','0'),
('282','34','InfoPicture','varchar(255)','缩略图','image','6','100%','','textinput','','','0','','271','0','1','0'),
('283','34','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','8',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效',NULL,NULL,'272','0','1','1'),
('284','34','InfoAttachment','varchar(255)','视频文件','attachment','4','100%','','textinput','','超过5M的视频文件请使用FTP上传！推荐使用<span style=\'color:blue\'>H.264编码的mp4格式</span>，它能在电脑、平板、手机上播放！<a href=\'http://jingyan.baidu.com/article/c1465413b5ebc40bfdfc4c7a.html\' target=\'_blank\'>点击查看：如何转化为H.264编码的mp4格式？</a><br/>推荐将视频上传到第三方视频平台（如：优酷、土豆、搜狐视频等），然后再填写通用代码中的地址','0','','271','0','1','0'),
('285','34','HasAttachment','int','是否启用附件','radio','50',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'272','0','0','0'),
('286','34','IsLinkUrl','int','是否是转向链接','radio','50',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'272','0','0','1'),
('287','34','LinkUrl','varchar(255)','转向链接','text','2','270px','','textinput','','请输入转向链接地址！如：http://www.baidu.com','0','','272','0','1','0'),
('288','34','Title','varchar(255)','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','273','0','1','1'),
('289','34','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'273','0','1','1'),
('290','34','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'273','0','1','1'),
('291','34','InfoOrder','int','排序','text','3',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'272','0','1','1'),
('292','34','InfoTime','datetime','时间','datetime','7','',NULL,'textinput',NULL,NULL,NULL,NULL,'272','0','1','1'),
('293','34','InfoAuthor','varchar(50)','作者','text','6','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'272','0','0','0'),
('294','34','InfoHit','int','点击次数','text','5','',NULL,'textinput','0',NULL,NULL,NULL,'272','0','1','1'),
('295','34','InfoFrom','varchar(50)','来源','text','4','','','textinput','','','0','','272','0','1','0'),
('296','34','IsEnable','int','是否启用','radio','23',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'272','0','1','1'),
('297','34','LabelID','varchar(512)','属性','labelcheckbox','9','','','','','','0','','272','0','1','1'),
('298','34','f1','varchar(255)','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'274','0','0','0'),
('299','34','f2','varchar(255)','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'274','0','0','0'),
('300','34','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'274','0','0','0'),
('301','34','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'275','0','0','0'),
('302','34','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'275','0','0','0'),
('303','35',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('304','35',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('305','35',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('306','35',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('307','35',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('308','35','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'303','0','1','1'),
('309','35','SpecialID','varchar(512)','所属专题','specialselect','1','','','','','','0','','303','0','1','1'),
('310','35','InfoTitle','varchar','下载标题','text','2','50%','','textinput','','','0','','303','1','1','1'),
('311','35','InfoSContent','text','简短内容','textarea','7','100%','70px','','','','0','','303','0','0','0'),
('312','35','InfoContent','text','详细内容','editor','8','100%','400px','','','','0','','303','0','1','0'),
('313','35','HasPicture','int','是否启用代表图片','radio','50','',NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'304','0','0','0'),
('314','35','InfoPicture','varchar(255)','缩略图','image','4','100%','','textinput','','','0','','303','0','1','0'),
('315','35','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','6','','','textinput','','不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效','0','','304','0','1','1'),
('316','35','InfoAttachment','varchar(255)','附件','attachment','3','50%','','textinput','','','0','','303','0','1','0'),
('317','35','HasAttachment','int','是否启用附件','radio','50',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'304','0','0','0'),
('318','35','IsLinkUrl','int','是否是转向链接','radio','12','','','','1|是\n0|否|1','','0','','303','0','0','1'),
('319','35','LinkUrl','varchar(255)','转向链接','text','1','270px','','textinput','','请输入转向链接地址！如：http://www.baidu.com','0','','304','0','1','0'),
('320','35','Title','varchar(255)','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','305','0','1','1'),
('321','35','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'305','0','1','1'),
('322','35','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'305','0','1','1'),
('323','35','InfoOrder','int','排序','text','2','','','textinput','0','请输入数字，值越小排名越靠前！','0','','304','0','1','1'),
('324','35','InfoTime','datetime','时间','datetime','5','','','textinput','','','0','','304','0','1','1'),
('325','35','InfoAuthor','varchar(50)','作者','text','3','270px','','textinput','','','0','','304','0','1','0'),
('326','35','InfoHit','int','点击次数','text','4','','','textinput','0','','0','','304','0','1','1'),
('327','35','InfoFrom','varchar(50)','来源','text','3','','','textinput','','','0','','304','0','1','0'),
('328','35','IsEnable','int','是否启用','radio','23','','','','1|启用|1\r\n0|禁用','','0','','304','0','1','1'),
('329','35','LabelID','varchar(512)','属性','labelcheckbox','7','','','','','','0','','304','0','1','1'),
('330','35','f1','varchar(255)','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'306','0','0','0'),
('331','35','f2','varchar(255)','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'306','0','0','0'),
('332','35','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'306','0','0','0'),
('333','35','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'307','0','0','0'),
('334','35','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'307','0','0','0'),
('335','36',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('336','36',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('337','36',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('338','36',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('339','36',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('340','36','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'335','0','1','1'),
('341','36','SpecialID','varchar(512)','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'336','0','0','1'),
('342','36','InfoTitle','varchar','标题','text','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'335','1','1','1'),
('343','36','InfoSContent','text','简短内容','textarea','7','100%','70px','','','','0','','336','0','0','0'),
('344','36','InfoContent','text','产品详情','editor','8','100%','400px','','','','0','','335','0','1','0'),
('345','36','HasPicture','int','是否启用代表图片','radio','50','',NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'336','0','0','0'),
('346','36','InfoPicture','varchar(255)','缩略图','image','6','100%','','textinput','','','0','','335','0','1','0'),
('347','36','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','7','','','textinput','','不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效','0','','336','0','1','1'),
('348','36','InfoAttachment','varchar(255)','附件','attachment','1','50%','','textinput','','启用附件后有效！','0','','336','0','1','0'),
('349','36','HasAttachment','int','是否启用附件','radio','50',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'336','0','0','0'),
('350','36','IsLinkUrl','int','是否是转向链接','radio','50',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'336','0','0','1'),
('351','36','LinkUrl','varchar(255)','转向链接','text','2','270px','','textinput','','请输入转向链接地址！如：http://www.baidu.com','0','','336','0','1','0'),
('352','36','Title','varchar(255)','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','337','0','1','1'),
('353','36','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'337','0','1','1'),
('354','36','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'337','0','1','1'),
('355','36','InfoOrder','int','排序','text','3',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'336','0','1','1'),
('356','36','InfoTime','datetime','时间','datetime','6','',NULL,'textinput',NULL,NULL,NULL,NULL,'336','0','1','1'),
('357','36','InfoAuthor','varchar(50)','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'336','0','0','0'),
('358','36','InfoHit','int','点击次数','text','5','270px',NULL,'textinput','0',NULL,NULL,NULL,'336','0','1','1'),
('359','36','InfoFrom','varchar(50)','来源','text','4',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'336','0','0','0'),
('360','36','IsEnable','int','是否启用','radio','21',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'336','0','1','1'),
('361','36','LabelID','varchar(512)','属性','labelcheckbox','8','','','','','','0','','336','0','1','1'),
('362','36','f1','varchar(255)','价格','text','2','200px','','textinput','','','0','','335','0','1','0'),
('363','36','f2','varchar(255)','编号','text','2','200px','','textinput','','','0','','335','0','1','0'),
('364','36','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'338','0','0','0'),
('365','36','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'339','0','0','0'),
('366','36','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'339','0','0','0'),
('367','37',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('368','37',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('369','37',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','1'),
('370','37',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('371','37',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('372','37','ChannelID','int','所属频道','channelselect','0','','','','','','0','','368','0','1','1'),
('373','37','SpecialID','varchar(512)','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'368','0','0','1'),
('374','37','InfoTitle','varchar','标题','text','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'367','1','1','1'),
('375','37','InfoSContent','text','内容','textarea','7','100%','70px','','','','0','','367','0','1','0'),
('376','37','InfoContent','text','详细内容','editor','8','100%','400px','','','','0','','368','0','0','0'),
('377','37','HasPicture','int','是否启用代表图片','radio','5','',NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'368','0','0','0'),
('378','37','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'368','0','0','0'),
('379','37','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','9',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效',NULL,NULL,'368','0','1','1'),
('380','37','InfoAttachment','varchar(255)','附件','attachment','11','50%',NULL,'textinput',NULL,'启用附件后有效！',NULL,NULL,'368','0','0','0'),
('381','37','HasAttachment','int','是否启用附件','radio','10',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'368','0','0','0'),
('382','37','IsLinkUrl','int','是否是转向链接','radio','12',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'368','0','0','1'),
('383','37','LinkUrl','varchar(255)','转向链接','text','13','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com',NULL,NULL,'368','0','0','0'),
('384','37','Title','varchar(255)','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','369','0','1','1'),
('385','37','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'369','0','1','1'),
('386','37','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'369','0','1','1'),
('387','37','InfoOrder','int','排序','text','16','','','textinput','0','请输入数字，值越小排名越靠前！','0','','368','0','1','1'),
('388','37','InfoTime','datetime','时间','datetime','17','','','textinput','','','0','','368','0','1','1'),
('389','37','InfoAuthor','varchar(50)','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'368','0','0','0'),
('390','37','InfoHit','int','点击次数','text','19','270px','','textinput','0','','0','','368','0','1','1'),
('391','37','InfoFrom','varchar(50)','来源','text','20',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'368','0','0','0'),
('392','37','IsEnable','int','是否启用','radio','21','','','','1|启用|1\r\n0|禁用','','0','','368','0','1','1'),
('393','37','LabelID','varchar(512)','属性','labelcheckbox','21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'368','0','0','1'),
('394','37','f1','varchar(255)','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'370','0','0','0'),
('395','37','f2','varchar(255)','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'370','0','0','0'),
('396','37','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'370','0','0','0'),
('397','37','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'371','0','0','0'),
('398','37','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'371','0','0','0'),
('399','38',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('400','38',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('401','38',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('402','38',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('403','38',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('404','38','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'399','0','1','1'),
('405','38','SpecialID','varchar(512)','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'400','0','0','1'),
('406','38','InfoTitle','varchar','标题','text','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'399','1','1','1'),
('407','38','InfoSContent','text','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,NULL,NULL,'400','0','0','0'),
('408','38','InfoContent','text','详细内容','editor','8','100%','400px',NULL,NULL,NULL,NULL,NULL,'400','0','0','0'),
('409','38','HasPicture','int','是否启用代表图片','radio','5','',NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'400','0','0','0'),
('410','38','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'400','0','0','0'),
('411','38','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','9',NULL,NULL,'textinput',NULL,'不勾选则继承所属频道的阅读权限！启用Html静态缓存后无效',NULL,NULL,'400','0','1','1'),
('412','38','InfoAttachment','varchar(255)','附件','attachment','11','50%',NULL,'textinput',NULL,'启用附件后有效！',NULL,NULL,'400','0','0','0'),
('413','38','HasAttachment','int','是否启用附件','radio','10',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'400','0','0','0'),
('414','38','IsLinkUrl','int','是否是转向链接','radio','12',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'400','0','0','1'),
('415','38','LinkUrl','varchar(255)','转向链接','text','13','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com',NULL,NULL,'400','0','0','0'),
('416','38','Title','varchar(255)','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','401','0','1','1'),
('417','38','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'401','0','1','1'),
('418','38','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'401','0','1','1'),
('419','38','InfoOrder','int','排序','text','16',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'399','0','1','1'),
('420','38','InfoTime','datetime','时间','datetime','17','',NULL,'textinput',NULL,NULL,NULL,NULL,'399','0','1','1'),
('421','38','InfoAuthor','varchar(50)','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'400','0','0','0'),
('422','38','InfoHit','int','点击次数','text','19','270px',NULL,'textinput','0',NULL,NULL,NULL,'399','0','1','1'),
('423','38','InfoFrom','varchar(50)','来源','text','20',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'400','0','0','0'),
('424','38','IsEnable','int','是否启用','radio','21',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'399','0','1','1'),
('425','38','LabelID','varchar(512)','属性','labelcheckbox','21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'400','0','0','1'),
('426','38','f1','varchar(255)','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'402','0','0','0'),
('427','38','f2','varchar(255)','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'402','0','0','0'),
('428','38','f3','varchar(255)','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'402','0','0','0'),
('429','38','f4','varchar(255)','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'403','0','0','0'),
('430','38','f5','varchar(255)','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'403','0','0','0'),
('431','39',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('432','39',NULL,NULL,'其它信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('433','39',NULL,NULL,'搜索引擎优化设置',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','1'),
('434','39',NULL,NULL,'扩展分组1',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('435','39',NULL,NULL,'扩展分组2',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('436','39','ChannelID','int','所属频道','channelselect','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'431','0','1','1'),
('437','39','SpecialID','varchar(512)','所属专题','specialselect','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'432','0','0','1'),
('438','39','InfoTitle','varchar','标题','text','1','50%',NULL,'textinput',NULL,NULL,NULL,NULL,'431','1','1','1'),
('439','39','InfoSContent','text','简短内容','textarea','7','100%','70px',NULL,NULL,NULL,NULL,NULL,'432','0','0','0'),
('440','39','InfoContent','text','详细内容','editor','8','100%','400px',NULL,NULL,NULL,NULL,NULL,'432','0','0','0'),
('441','39','HasPicture','int','是否启用代表图片','radio','5','',NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'432','0','0','0'),
('442','39','InfoPicture','varchar(255)','缩略图','image','6','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'432','0','0','0'),
('443','39','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','9',NULL,NULL,'textinput',NULL,'不勾选继承所属频道的阅读权限！启用Html静态缓存后无效',NULL,NULL,'432','0','1','1'),
('444','39','InfoAttachment','varchar(255)','附件','attachment','11','50%',NULL,'textinput',NULL,'启用附件后有效！',NULL,NULL,'432','0','0','0'),
('445','39','HasAttachment','int','是否启用附件','radio','10',NULL,NULL,NULL,'1|启用\r\n0|禁用|1',NULL,NULL,NULL,'432','0','0','0'),
('446','39','IsLinkUrl','int','是否是转向链接','radio','12',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'432','0','0','1'),
('447','39','LinkUrl','varchar(255)','转向链接','text','13','270px',NULL,'textinput',NULL,'请输入转向链接地址！如：http://www.baidu.com',NULL,NULL,'432','0','0','0'),
('448','39','Title','varchar(255)','页面标题Title','text','0','100%','','textinput','','设置页面标题，留空表示继承上级频道设置！建议在多个关键词之间以竖线\"|\"分隔，并且最好不要超过80个字符！如：软件开发|网站建设','0','','433','0','1','1'),
('449','39','Keywords','varchar(255)','页面关键词Keywords','text','1','100%',NULL,'textinput',NULL,'设置页面关键词，留空表示继承上级频道设置！建议在多个关键词之间以英文逗号\",\"分隔，并且最好不要超过100个字符！如：软件开发,网站建设',NULL,NULL,'433','0','1','1'),
('450','39','Description','varchar(512)','页面描述Description','textarea','2','100%',NULL,NULL,NULL,'设置页面描述，留空表示自动从内容中提取。建议不要超过200个字符！',NULL,NULL,'433','0','1','1'),
('451','39','InfoOrder','int','排序','text','16',NULL,NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'431','0','1','1'),
('452','39','InfoTime','datetime','时间','datetime','17','',NULL,'textinput',NULL,NULL,NULL,NULL,'431','0','1','1'),
('453','39','InfoAuthor','varchar(50)','作者','text','18','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'432','0','0','0'),
('454','39','InfoHit','int','点击次数','text','19','270px',NULL,'textinput','0',NULL,NULL,NULL,'431','0','1','1'),
('455','39','InfoFrom','varchar(50)','来源','text','20',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'432','0','0','0'),
('456','39','IsEnable','int','是否启用','radio','21',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'431','0','1','1'),
('457','39','LabelID','varchar(512)','属性','labelcheckbox','21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'432','0','0','1'),
('458','39','f1','text','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'434','0','0','0'),
('459','39','f2','text','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'434','0','0','0'),
('460','39','f3','text','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'434','0','0','0'),
('461','39','f4','text','扩展字段4','text','4','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'435','0','0','0'),
('462','39','f5','text','扩展字段5','text','5','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'435','0','0','0'),
('463','30','IsCheck','int','是否审核','radio','22',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,NULL,NULL,'55','0','1','1'),
('464','31','IsCheck','int','是否审核','radio','28',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,NULL,NULL,'66','0','1','1'),
('465','38','IsCheck','int','是否审核','radio','20',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,NULL,NULL,'399','0','1','1'),
('466','39','IsCheck','int','是否审核','radio','20',NULL,NULL,NULL,'1|已审核|1\r\n0|未审核',NULL,NULL,NULL,'431','0','1','1'),
('467','34','IsCheck','int','是否审核','radio','22','','','','1|已审核|1\r\n0|未审核','','0','','272','0','1','1'),
('468','35','IsCheck','int','是否审核','radio','22','','','','1|已审核|1\r\n0|未审核','','0','','304','0','1','1'),
('469','36','IsCheck','int','是否审核','radio','20','','','','1|已审核|1\r\n0|未审核','','0','','336','0','1','1'),
('470','37','IsCheck','int','是否审核','radio','20','','','','1|已审核|1\r\n0|未审核','','0','','368','0','1','1'),
('471','22','BannerGroupID','int','幻灯分组编号','text','1','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'474','0','0','0'),
('472','22','BannerGroupName','varchar(50)','幻灯分组名称','text','2','200px',NULL,'textinput',NULL,NULL,NULL,NULL,'474','1','1','0'),
('473','22','IsSystem','int','是否是系统','radio','4',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'474','0','0','0'),
('474','22','BannerGroupID','int','基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('475','3','BannerGroupID','int','所属幻灯分组','bannergroupselect','3',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('476','22','BannerGroupOrder','int','幻灯分组排序','text','3','200px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'474','0','1','0'),
('477','1','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','15','','','textinput','','不勾选则继承父级频道的阅读权限！若父级频道未设置，则游客也可以访问！启用Html静态缓存后无效','0','','22','0','1','1'),
('478','13','f1','text','扩展字段1','text','25','200px','','textinput','','','0','','483','0','0','0'),
('479','13','f2','text','扩展字段2','text','26','200px','','textinput','','','0','','483','0','0','0'),
('480','13','f3','text','扩展字段3','text','27','200px','','textinput','','','0','','483','0','0','0'),
('481','13','f4','text','扩展字段4','text','28','200px','','textinput','','','0','','483','0','0','0'),
('482','13','f5','text','扩展字段5','text','29','200px','','textinput','','','0','','483','0','0','0'),
('483','13',NULL,NULL,'其它信息',NULL,'1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','0','0'),
('484','32','ReadLevel','varchar(255)','阅读权限','membergroupcheckbox','9',NULL,NULL,'textinput',NULL,'不勾选则继承父级频道的阅读权限！若父级频道未设置，则游客也可以访问！启用Html静态缓存后无效',NULL,NULL,'57','0','1','1'),
('485','20','IsRequire','int','是否是必填字段','radio','16',NULL,NULL,NULL,'1|是\r\n0|否|1',NULL,NULL,NULL,'234','0','1','0'),
('486','1','IsHtml','int','是否启用Html静态缓存','radio','19',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成频道Html静态缓存',NULL,NULL,'22','0','1','0'),
('487','30','IsHtml','int','是否启用Html静态缓存','radio','24',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存',NULL,NULL,'55','0','1','0'),
('488','31','IsHtml','int','是否启用Html静态缓存','radio','30','','','','1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0','','66','0','1','0'),
('489','34','IsHtml','int','是否启用Html静态缓存','radio','24','','','','1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0','','272','0','1','0'),
('490','35','IsHtml','int','是否启用Html静态缓存','radio','24','','','','1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0','','304','0','1','0'),
('491','36','IsHtml','int','是否启用Html静态缓存','radio','22','','','','1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0','','336','0','1','0'),
('492','37','IsHtml','int','是否启用Html静态缓存','radio','22','','','','1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存','0','','368','0','1','0'),
('493','38','IsHtml','int','是否启用Html静态缓存','radio','22',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存',NULL,NULL,'399','0','1','0'),
('494','39','IsHtml','int','是否启用Html静态缓存','radio','22',NULL,NULL,NULL,'1|启用|1\r\n0|禁用','启用后，将生成信息Html静态缓存',NULL,NULL,'431','0','1','0'),
('495','30','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'56','0','1','0'),
('496','31','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'65','0','1','0'),
('497','34','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'273','0','1','0'),
('498','35','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'305','0','1','0'),
('499','36','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'337','0','1','0'),
('500','37','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'369','0','1','0'),
('501','38','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'401','0','1','0'),
('502','39','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置信息在前台页面显示的静态文件名称，无需添加扩展名，<b>留空则取当前信息ID作为静态页面名称！</b>如：hotnews',NULL,NULL,'433','0','1','0'),
('503','32','Html','varchar','静态页面名称','text','0','150px',NULL,'textinput',NULL,'设置频道在前台页面显示的静态文件名称，无需添加扩展名，常常以频道名称拼音命名，<b>留空则取频道名称拼音首字母作为页面名称！</b>如：wangzhanjianshe',NULL,NULL,'58','0','1','0'),
('504','1',NULL,NULL,'其它信息',NULL,'4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('505','1','f1','text','扩展字段1','text','1','200px',NULL,'textinput',NULL,NULL,'0',NULL,'504','0','0','0'),
('506','1','f2','text','扩展字段2','text','2','200px',NULL,'textinput',NULL,NULL,'0',NULL,'504','0','0','0'),
('507','1','f3','text','扩展字段3','text','3','200px',NULL,'textinput',NULL,NULL,'0',NULL,'504','0','0','0'),
('508','23','MailClassName','varchar','邮件订阅分类名称','text','1','270px',NULL,'textinput',NULL,NULL,NULL,NULL,'512','0','1','0'),
('509','23','MailClassOrder','int','邮件订阅分类排序','text','2','270px','','textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'512','0','1','0'),
('510','23','MailClassDescription','varchar','邮件订阅分类描述','textarea','3','100%','80px','textinput',NULL,NULL,NULL,NULL,'512','0','1','0'),
('511','23','IsEnable','int','是否启用','radio','4',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'512','0','1','0'),
('512','23',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('513','24','MailClassID','int','所属订阅分类','mailclassselect','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'521','0','1','0'),
('514','24','MailAccount','varchar','邮箱帐号','text','2','220px',NULL,'textinput',NULL,NULL,NULL,NULL,'521','1','1','0'),
('515','24','Name','varchar','姓名','text','3','220px',NULL,'textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('516','24','Telephone','varchar','电话','text','4','220px',NULL,'textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('517','24','Address','varchar','地址','text','5','370px',NULL,'textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('518','24','AddTime','datetime','添加时间','datetime','6','',NULL,'textinput',NULL,NULL,NULL,NULL,'521','0','1','0'),
('519','24','Remark','varchar','备注','textarea','7','100%','80px','textinput','',NULL,NULL,NULL,'521','0','1','0'),
('520','24','IsEnable','int','是否启用','radio','8',NULL,NULL,NULL,'1|启用|1\r\n0|禁用',NULL,NULL,NULL,'521','0','1','0'),
('521','24',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('522','25',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('523','25','MailTitle','varchar','邮件主题','text','1','100%',NULL,'textinput',NULL,NULL,NULL,NULL,'522','1','1','0'),
('524','25','MailContent','varchar','邮件内容','editormini','2','100%','300px','textinput',NULL,NULL,NULL,NULL,'522','0','1','0'),
('525','25','AddTime','datetime','添加时间','datetime','3',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'522','0','1','0'),
('526','1','ChannelIcon','varchar','频道图标','imageex','4','500px',NULL,'textinput',NULL,'设置手机/微信网站频道图标，建议图片尺寸不大于64x64',NULL,NULL,'504','0','1','0'),
('527','1','ChannelStyle','varchar','频道首页模板排版样式','radio','5',NULL,NULL,'','0|默认|1\r\n1|图文\r\n2|文字\r\n3|橱窗\r\n4|相册','设置手机/微信网站频道首页模板样式，是否有效取决于模板是否实现当前功能',NULL,NULL,'504','0','1','0'),
('528','6','','','基本信息','','0','',NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('529','6','GuestName','varchar','姓名,name','text','14','100%',NULL,NULL,NULL,NULL,NULL,NULL,'528','0','1','0'),
('530','6','Contact','varchar','电话,telephone','text','15','100%',NULL,NULL,NULL,NULL,NULL,NULL,'528','0','1','0'),
('531','6','MessageTitle','varchar','标题,Title','text','5','100%','','','','','0','','528','1','1','0'),
('532','6','MessageContent','text','内容,content','textarea','10','100%',NULL,NULL,NULL,NULL,NULL,NULL,'528','0','1','0'),
('533','6','f1','text','字段1','textarea','30','100%','','','','','0','','528','0','0','0'),
('534','6','f2','text','字段2','textarea','30','100%','','','','','0','','528','0','0','0'),
('535','6','f3','text','字段3','textarea','30','100%','','','','','0','','528','0','0','0'),
('536','6','f4','text','字段4','textarea','30','100%','','','','','0','','528','0','0','0'),
('537','6','f5','text','字段5','text','30','100%','','','','','0','','528','1','0','0'),
('540','6','Email','text','Email','text','29','100%','','','','','0','','528','0','0','0'),
('541','6','Address','text','地址,address','text','29','100%','','','','','0','','528','0','0','0'),
('542','6','Gender','text','性别,gender','radio','29','100%','','','女|女|1\r\n男|男','','1','','528','0','0','0'),
('543','6','QQ','text','QQ','text','20','100%','','','','','0','','528','0','0','0'),
('544','26',NULL,NULL,'基本信息',NULL,'0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('545','26','GuestName','text','姓名,name','text','1','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('546','26','Quantity','text','订购数量,number','text','2','100%','','','','','0','','544','0','1','0'),
('547','26','Telephone','text','电话,telephone','text','3','100%','','','','','0','','544','0','1','0'),
('548','26','QQ','text','QQ','text','4','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('549','26','Email','text','Email','text','5','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('550','26','Address','text','地址,address','text','6','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('551','26','Remark','text','备注,remark','textarea','7','100%',NULL,NULL,NULL,NULL,NULL,NULL,'544','0','1','0'),
('552','26','f1','text','字段1','textarea','8','100%','','','','','0','','544','0','0','0'),
('553','26','f2','text','字段2','textarea','9','100%','','','','','0','','544','0','0','0'),
('554','26','f3','text','字段3','textarea','10','100%','','','','','0','','544','0','0','0'),
('555','26','f4','text','字段4','textarea','11','100%','','','','','0','','544','0','0','0'),
('556','26','f5','text','字段5','textarea','12','100%','','','','','0','','544','0','0','0'),
('557','26','ProductName','text','订购产品,Product','text','0','100%','','','','','0','','544','0','1','0'),
('558','3','BannerThumbnail','varchar','缩略图','imageex','4','420px',NULL,'textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('559','3','BannerDescription','text','幻灯片说明','textarea','6','100%','80px','textinput',NULL,NULL,NULL,NULL,'101','0','1','0'),
('560','19','IndexTemplate','varchar','默认首页模板','text','3','200px',NULL,'textinput',NULL,'设置当前模型默认的模板文件名，建议使用小写字母，如：article.html',NULL,NULL,'233','0','1','0'),
('561','19','ReadTemplate','varchar','默认阅读模板','text','4','200px',NULL,'textinput',NULL,'设置当前模型默认的模板文件名，建议使用小写字母，如：showarticle.html',NULL,NULL,'233','0','1','0'),
('562','11','AdGroupID','int','所属广告位','adgroupselect','4',NULL,NULL,'textinput',NULL,NULL,NULL,NULL,'152','0','1','0'),
('563','11','AdOrder','int','广告排序','text','5','80px',NULL,'textinput','0','请输入数字，值越小排名越靠前！',NULL,NULL,'152','0','1','0'),
('564','30',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('565','31',NULL,NULL,'相册/相关信息',NULL,'3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('566','34',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('567','35',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('568','36',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('569','37',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('570','38',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('571','39',NULL,NULL,'相册/相关信息',NULL,'2',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0','0','1','0'),
('572','30','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'564','0','1','0'),
('573','30','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'564','0','1','0'),
('574','31','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'565','0','1','0'),
('575','31','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'565','0','1','0'),
('576','34','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'566','0','1','0'),
('577','34','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'566','0','1','0'),
('578','35','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'567','0','1','0'),
('579','35','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'567','0','1','0'),
('580','36','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'568','0','1','0'),
('581','36','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'568','0','1','0'),
('582','37','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'569','0','1','0'),
('583','37','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'569','0','1','0'),
('584','38','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'570','0','1','0'),
('585','38','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'570','0','1','0'),
('586','39','InfoAlbum','text','相册','album','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'571','0','1','0'),
('587','39','InfoRelation','varchar(512)','相关信息','relation','3',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'571','0','1','0'),
('588','39','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'433','0','1','1'),
('589','38','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'401','0','1','1'),
('590','37','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'369','0','1','1'),
('591','36','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'337','0','1','1'),
('592','35','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'305','0','1','1'),
('593','34','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'273','0','1','1'),
('594','31','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'65','0','1','1'),
('595','30','Tag','varchar(255)','Tag标签','text','5','100%',NULL,'textinput',NULL,'多个标签以英文逗号隔开，一般设置2到5个。TAG标签是一种由您自己定义的，比分类更准确、更具体，可以概括文章主要内容的关键词，能使文章更容易被搜索到',NULL,NULL,'56','0','1','1');

INSERT INTO `youdian_banner` VALUES
('3','','1','/Upload/banner/1.jpg','','','1','','1','1'),
('4','','1','/Upload/banner/1.jpg','','','0','','1','1'),
('5','','2','/Upload/banner/1.jpg','','','0','','1','2'),
('6','','2','/Upload/banner/1.jpg','','','0','','1','2'),
('7','','3','/Upload/banner/11.jpg','','','0','','1','1'),
('8','','3','/Upload/banner/11.jpg','','','0','','1','1'),
('9','','4','/Upload/banner/11.jpg','','','0','','1','2'),
('10','','4','/Upload/banner/11.jpg','','','0','','1','2');

INSERT INTO `youdian_banner_group` VALUES
('1','首页幻灯分组','4','1','1'),
('2','banner group of home','0','1','2'),
('3','手机幻灯片分组','0','0','1'),
('4','banner grounp of mobile','0','0','2');

INSERT INTO `youdian_channel` VALUES
('1','0','0','网站首页','','','','33','_self','','1','/Upload/public/index.jpg','','','','index','','20','0','index.html','','1','1','1','1','1','1',NULL,NULL,NULL,'/Upload/public/logo.png','0'),
('2','0','0','Home','','','','33','_self','','0','','','','','index','','20','0','index.html','read.html','1','0','1','1','1','2',NULL,NULL,NULL,'/Upload/public/logo.png','0'),
('4','0','0','Job','job','','','33','_self','','0','','','','','job','','20','7','job.html','','1','0','0','1','1','2',NULL,NULL,NULL,'/Upload/icon/4.jpg','0'),
('5','0','0','Guestbook','','','','33','_self','','0','','','','','guestbook','','20','8','guestbook.html','','1','0','1','1','1','2',NULL,NULL,NULL,'/Upload/icon/5.jpg','0'),
('6','0','0','在线订购','','','','33','_self','','0','','','','','order',NULL,'20','7','order.html','','1','1','0','1','1','1',NULL,NULL,NULL,'/Upload/icon/6.jpg','0'),
('7','0','0','Order','','','','33','_self','','1','','','','','order',NULL,'20','6','order.html','read.html','1','1','0','1','1','2',NULL,NULL,NULL,'/Upload/icon/7.jpg','0'),
('8','0','0','人才招聘','招聘','','','33','_self','','1','','','','','job','','20','6','job.html','','1','1','0','1','1','1',NULL,NULL,NULL,'/Upload/icon/8.jpg','0'),
('9','0','0','在线留言','','','','33','_self','','1','','','','','guestbook',NULL,'10','18','guestbook.html','','1','1','1','1','1','1',NULL,NULL,NULL,'/Upload/icon/9.jpg','0'),
('10','0','0','投递简历','',NULL,NULL,'33','_self',NULL,'0',NULL,NULL,NULL,NULL,'resume',NULL,'20','20','resume.html','','1','1','0','1','1','1',NULL,NULL,NULL,'/Upload/icon/10.jpg','0'),
('11','0','0','Resume','','','','33','_self','','0','','','','','resume',NULL,'20','20','resume.html','','1','1','0','1','1','2',NULL,NULL,NULL,'/Upload/icon/11.jpg','0'),
('15','0','1','关于我们','','<p style=\"text-align: left\">\r\n	<img alt=\"\" src=\"/Upload/public/gywm.jpg\" style=\"border-width: 0px; border-style: solid; border-color: -moz-use-text-color; padding: 5px; width: 190px; float: left; height: 120px; margin-right: 5px;\" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 某某化工有限公司是一家集树脂研发、 生产和销售于一体，并从事液体化工品储存及经营等业务的综合型企业。主要产品类型有环氧树脂、氨基树脂、饱和聚酯、不饱和聚酯和工业用醇酸树脂等树脂上下游产品。公司拥有专业的技术研发团队，引进海外先进的分析检测仪器，并拥有一流的自动化生产成套设备，年生产树脂能力10万余吨。2008年，面对市场需求，公司在技术领域不断开拓创新，全方位推出极具市场竞争力的特种环氧树脂及其它系列树脂新品。上海某某化工有限公司在积极研发具有市场前瞻性产品、立足行业领跑者地位的同时，努力将未来的元邦打造成以健康生态和企业文化为鲜明特色的现代化树脂生产基地。上海某某化工有限公司将一如既往地在树脂行业做专做强，秉承建百年企业，树国际品牌的雄心，与您携手，共同开创更广阔的发展空间！</p>\r\n','站在这繁华的城市综合中，城市因为建筑而律动，我因为城市而享受生活，那么 你用什么DNA一栋建筑的生命？某某涂料致力于为你提供高品质的涂装解决方案，13年来，我们一直为此而努力...','32','_self','','0','/Upload/public/index.jpg','','','','aboutus','','20','1','page.html','','1','1','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/15.jpg','3'),
('17','15','0','企业文化','','公司自创立以来,本着&quot;质量就是生命,品质就是尊严，信誉就是血脉&quot;的企业宗旨，坚持以科技进步推动企业发展，持续引进树脂行业顶尖人才，并与部分高等院校科研部门合作，紧扣市场需求的脉搏，专注于从事船舶漆、木器漆、塑胶漆、汽车工业漆等一系列涂料用环氧树脂、氨基树脂、醇酸树脂的研发，不断推出新产品，一个强化企业自主创新的研发团队为公司未来的广阔前景注入了新的生命力。<br />\r\n研发平台：<br />\r\n为稳步推进公司的研发团队组建，公司坚持硬件与软件建设两手抓的原则，先后从海外引进多台先进的实验检测设备，如瓦里安的气相色谱、Q-LAB公司的耐老化实验仪（QUV）、耐盐雾实验仪、可程式恒温恒湿实验仪，梅特勒的水份测定仪等等。<br />\r\n研发成果：<br />\r\n为充分适应人类的文明与进步对环保型绿色产品的潜在需求，在广大元邦同仁的共同努力下，公司已陆续推出了一系列环保型树脂， 以良好的社会综效谱写着&quot;科技以人为本&quot;的元邦进行曲。','','32','_self','','0','/Upload/public/wenhua.jpg','','','','culture','','20','0','page.html','','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/wenhua.png','0'),
('18','15','0','资质荣誉','','<p style=\"padding-left: 60px\">\r\n	<br />\r\n	<span style=\"color: #ff0000\"><span style=\"font-size: 20px\"><strong>重要资质</strong></span></span><br />\r\n	计算机信息系统集成一级资质<br />\r\n	国家规划布局内重点软件企业<br />\r\n	高新技术企业<br />\r\n	通过CMMIv1.2五级<br />\r\n	ISO9001：2008质量管理体系认证<br />\r\n	ISO20000 IT服务管理体系认证<br />\r\n	企业管理信息系统（劳动99三版）前台技术支持商</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<br />\r\n	&nbsp;</p>\r\n<p style=\"padding-left: 60px\">\r\n	<strong><span style=\"color: #ff0000\"><span style=\"font-size: 20px\">重要荣誉</span></span></strong><br />\r\n	信息产业科技创新先进集体<br />\r\n	国家高技术产业化示范工程<br />\r\n	全国科技创新质量管理先进单位<br />\r\n	国家火炬计划软件产业基地骨干企业<br />\r\n	2013十大创新软件企业<br />\r\n	国家第四批创新型试点企业<br />\r\n	2014中国企业信息化杰出服务商<br />\r\n	2013中国年度创新软件企业<br />\r\n	2013年软件信息技术金鼎奖<br />\r\n	国家认定企业技术中心<br />\r\n	科技局信息工程技术研究中心<br />\r\n	2013年守合同重信用企业</p>\r\n','','32','_self','','0','/Upload/public/rongyu.jpg','','','','honor','','20','0','page.html','','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/rongyu.png','0'),
('19','15','0','组织机构','','<div style=\"text-align: center\">\r\n	<p>\r\n		<img alt=\"\" src=\"/Upload/public/zzjj1.png\" style=\"width: 100%;\" /></p>\r\n	<p>\r\n		<img alt=\"\" src=\"/Upload/public/zzjj.png\" style=\"width: 100%;\" /></p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>\r\n','','32','_self','','0','/Upload/public/jg.png','','','','organization','','20','0','page.html','','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/zzjj1.png','0'),
('20','0','1','新闻资讯','新闻','','','30','_self','','0','/Upload/news/news.jpg','','','','news','','20','2','article.html','showarticle.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/20.jpg','0'),
('21','20','0','公司新闻','新闻','','','30','_self','','0','/Upload/public/gsxw.jpg','','','','companynews','','20','0','article.html','showarticle.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/gsxw.png','0'),
('22','20','0','行业动态','新闻','','','30','_self','','0','/Upload/public/hyxw.jpg','','','','industrytrends','','20','0','article.html','showarticle.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/hyxw.png','0'),
('23','0','1','产品展示','产品','','','36','_self','','0','/Upload/public/ddsa.png','','','','product','','20','3','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','3'),
('24','23','0','涂料产品','产品','','','36','_self','','0','','','','','tlcp','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0'),
('25','23','0','添加剂','产品','','','36','_self','','0','','','','','tjj','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0'),
('26','23','0','医药产品','产品','','','36','_self','','0','','','','','yycp','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0'),
('27','23','1','防腐剂','产品','','','36','_self','','0','','','','','ffj','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','3'),
('28','27','0','熟食防腐','产品','','','36','_self','','0','','','','','ssff','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0'),
('29','27','0','干货防腐','产品','','','36','_self','','0','','','','','ghff','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/23.jpg','0'),
('31','0','0','联系我们','','<!--引用百度地图API-->\r\n<style type=\"text/css\">\r\n.iw_poi_title {color:#CC5522;font-size:14px;font-weight:bold;overflow:hidden;padding-right:13px;white-space:nowrap}\r\n    .iw_poi_content {font:12px arial,sans-serif;overflow:visible;padding-top:4px;white-space:-moz-pre-wrap;word-wrap:break-word}</style>\r\n<script type=\"text/javascript\" src=\"http://api.map.baidu.com/api?key=&v=1.1&services=true\"></script><!--百度地图容器-->\r\n<div id=\"dituContent\" style=\"width:100%;height:450px;border:#ccc solid 1px;float:right\">\r\n	&nbsp;</div>\r\n<script type=\"text/javascript\">\r\n    //创建和初始化地图函数：\r\n    function initMap(){\r\n        createMap();//创建地图\r\n        setMapEvent();//设置地图事件\r\n        addMapControl();//向地图添加控件\r\n    }\r\n    \r\n    //创建地图函数：\r\n    function createMap(){\r\n        var map = new BMap.Map(\"dituContent\");//在百度地图容器中创建一个地图\r\n        var point = new BMap.Point(116.395645,39.929986);//定义一个中心点坐标\r\n        map.centerAndZoom(point,12);//设定地图的中心点和坐标并将地图显示在地图容器中\r\n        window.map = map;//将map变量存储在全局\r\n    }\r\n    \r\n    //地图事件设置函数：\r\n    function setMapEvent(){\r\n        map.enableDragging();//启用地图拖拽事件，默认启用(可不写)\r\n        map.enableScrollWheelZoom();//启用地图滚轮放大缩小\r\n        map.enableDoubleClickZoom();//启用鼠标双击放大，默认启用(可不写)\r\n        map.enableKeyboard();//启用键盘上下左右键移动地图\r\n    }\r\n    \r\n    //地图控件添加函数：\r\n    function addMapControl(){\r\n        //向地图中添加缩放控件\r\n	var ctrl_nav = new BMap.NavigationControl({anchor:BMAP_ANCHOR_TOP_LEFT,type:BMAP_NAVIGATION_CONTROL_LARGE});\r\n	map.addControl(ctrl_nav);\r\n        //向地图中添加缩略图控件\r\n	var ctrl_ove = new BMap.OverviewMapControl({anchor:BMAP_ANCHOR_BOTTOM_RIGHT,isOpen:1});\r\n	map.addControl(ctrl_ove);\r\n        //向地图中添加比例尺控件\r\n	var ctrl_sca = new BMap.ScaleControl({anchor:BMAP_ANCHOR_BOTTOM_LEFT});\r\n	map.addControl(ctrl_sca);\r\n    }\r\n    \r\n    \r\n    initMap();//创建和初始化地图\r\n</script>','','32','_self','','0','','','','','contactus','','20','20','page.html','','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/31.jpg','0'),
('33','0','0','网站公告','公告','','','30','_self','','0','','','','','annnouncement','','20','0','article.html','showarticle.html','1','0','0','0','1','1',NULL,NULL,NULL,'/Upload/icon/33.jpg','0'),
('34','0','0','Announcement','','','','30','_self','','0','','','','','annnouncement','','20','0','article.html','showarticle.html','1','0','0','0','1','2',NULL,NULL,NULL,'','0'),
('35','0','1','About Us','','<p>\r\n	<span><img alt=\"\" src=\"/Upload/public/gywm.jpg\" style=\"border-width: 0px; border-style: solid; border-color: -moz-use-text-color; padding: 5px; width: 190px; float: left; height: 120px; margin-right: 5px;\" />XX Software Technology Co., Ltd. of&nbsp; Xingsha Economic Development Zone is located , the technology research and development of a set of large sites, network marketing software R &amp; D as well as the network marketing service in one of the high-tech software companies </span><span>is one of a handful of domestic enterprises to master the core technology in the field of network marketing software, bulk software, web crawler, a large construction site. </span><span>Relying on the company&#39;s core technology, products for different industries, different sizes, different applications and solutions. </span><span>At the same time, we have the perfect network infrastructure services, to businesses or individuals to provide domain name registration, web hosting, business offices, website acceleration, database, cloud host network infrastructure services.</span><br />\r\n	<br />\r\n	<span>The company has an extremely rich passion, technical top team, composed of a number of years of software development experience and network marketing experience in the professional and technical personnel. </span><span>Companies adhering to the &quot;state-of-the-art technology, sincere service, cooperation and win-win&quot; business philosophy, by virtue of its powerful software technical strength, rich network planning experience, comprehensive concept of network marketing, as well as improve the operational mode, is committed to providing our customers with the most </span><span>quality of service, and received wide acclaim from all sectors of society.</span><br />\r\n	<br />\r\n	&nbsp;</p>\r\n','business philosophy, by virtue of its powerful software technical strength, rich network planning experience, comprehensive concept of network marketing, as well as improve the operational mode, is committed to providing our customers with the most quality of service, and received wide acclaim from all sectors of society.','32','_self','','0','/Upload/public/index.jpg','','','','aboutus','','20','0','page.html','','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/35.jpg','3'),
('37','35','0','Culture','','<p>\r\n	<strong><span closure_uid_503514901=\"1114\" wd=\"null\">Company slogan:</span></strong><br closure_uid_503514901=\"1358\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1115\" wd=\"null\">Save time, worry</span><span closure_uid_503514901=\"1116\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1117\" wd=\"null\">and effort</span> <span class=\"hps\" closure_uid_503514901=\"1118\" wd=\"null\">to help</span> <span class=\"hps\" closure_uid_503514901=\"1119\" wd=\"null\">you</span> <span class=\"hps\" closure_uid_503514901=\"1120\" wd=\"null\">effectively</span> <span class=\"hps\" closure_uid_503514901=\"1121\" wd=\"null\">network</span> <span class=\"hps\" closure_uid_503514901=\"1122\" wd=\"null\">marketing</span><span closure_uid_503514901=\"1123\" wd=\"null\">.</span><br closure_uid_503514901=\"1359\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1360\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1361\" wd=\"null\" />\r\n	<strong><span closure_uid_503514901=\"1124\" wd=\"null\">Company</span> <span class=\"hps\" closure_uid_503514901=\"1125\" wd=\"null\">goals:</span></strong><br closure_uid_503514901=\"1362\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1126\" wd=\"null\">To</span> <span class=\"hps\" closure_uid_503514901=\"1127\" wd=\"null\">create</span> <span class=\"hps\" closure_uid_503514901=\"1128\" wd=\"null\">the first brand</span> <span class=\"hps\" closure_uid_503514901=\"1129\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"1130\" wd=\"null\">domestic</span> <span class=\"hps\" closure_uid_503514901=\"1131\" wd=\"null\">marketing software</span><span closure_uid_503514901=\"1132\" wd=\"null\">.</span><br closure_uid_503514901=\"1363\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1364\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1365\" wd=\"null\" />\r\n	<strong><span closure_uid_503514901=\"1133\" wd=\"null\">Company aim:</span></strong><br closure_uid_503514901=\"1366\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1134\" wd=\"null\">The interests of customers</span><span closure_uid_503514901=\"1135\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1136\" wd=\"null\">employees&#39; interests</span><span closure_uid_503514901=\"1137\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1138\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"1139\" wd=\"null\">maximize</span> <span class=\"hps\" closure_uid_503514901=\"1140\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1141\" wd=\"null\">interests of shareholders</span><span closure_uid_503514901=\"1142\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1143\" wd=\"null\">that</span> <span class=\"hps\" closure_uid_503514901=\"1144\" wd=\"null\">maximize</span> <span class=\"hps\" closure_uid_503514901=\"1145\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1146\" wd=\"null\">value of the company</span><span closure_uid_503514901=\"1147\" wd=\"null\">;</span><br closure_uid_503514901=\"1367\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1148\" wd=\"null\">The interests of customers</span><span closure_uid_503514901=\"1149\" wd=\"null\">:</span> <span class=\"hps\" closure_uid_503514901=\"1150\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1151\" wd=\"null\">use of</span> <span class=\"hps\" closure_uid_503514901=\"1152\" wd=\"null\">high-quality</span> <span class=\"hps\" closure_uid_503514901=\"1153\" wd=\"null\">software</span><span closure_uid_503514901=\"1154\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1155\" wd=\"null\">attentive service and</span> <span class=\"hps\" closure_uid_503514901=\"1156\" wd=\"null\">professional</span> <span class=\"hps\" closure_uid_503514901=\"1157\" wd=\"null\">consultation</span> <span class=\"hps\" closure_uid_503514901=\"1158\" wd=\"null\">to improve</span> <span class=\"hps\" closure_uid_503514901=\"1159\" wd=\"null\">competitiveness</span><span closure_uid_503514901=\"1160\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1161\" wd=\"null\">enhance</span> <span class=\"hps\" closure_uid_503514901=\"1162\" wd=\"null\">the image</span> <span class=\"hps\" closure_uid_503514901=\"1163\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"1164\" wd=\"null\">individuals and businesses</span><span closure_uid_503514901=\"1165\" wd=\"null\">;</span><br closure_uid_503514901=\"1368\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1166\" wd=\"null\">Employee</span> <span class=\"hps\" closure_uid_503514901=\"1167\" wd=\"null\">benefits:</span> <span class=\"hps\" closure_uid_503514901=\"1168\" wd=\"null\">pride,</span> <span class=\"hps\" closure_uid_503514901=\"1169\" wd=\"null\">job satisfaction,</span> <span class=\"hps\" closure_uid_503514901=\"1170\" wd=\"null\">the level of</span> <span class=\"hps\" closure_uid_503514901=\"1171\" wd=\"null\">skills</span> <span class=\"hps\" closure_uid_503514901=\"1172\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"1173\" wd=\"null\">experience</span> <span class=\"hps\" closure_uid_503514901=\"1174\" wd=\"null\">to continuously improve and</span> <span class=\"hps\" closure_uid_503514901=\"1175\" wd=\"null\">accumulation</span> <span class=\"hps\" closure_uid_503514901=\"1176\" wd=\"null\">on the</span> <span class=\"hps\" closure_uid_503514901=\"1177\" wd=\"null\">level</span> <span class=\"hps\" closure_uid_503514901=\"1178\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"1179\" wd=\"null\">income</span> <span class=\"hps\" closure_uid_503514901=\"1180\" wd=\"null\">in</span> <span class=\"hps\" closure_uid_503514901=\"1181\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1182\" wd=\"null\">same industry</span><span closure_uid_503514901=\"1183\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1184\" wd=\"null\">a</span> <span class=\"hps\" closure_uid_503514901=\"1185\" wd=\"null\">broad space for development</span><span closure_uid_503514901=\"1186\" wd=\"null\">;</span><br closure_uid_503514901=\"1369\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1187\" wd=\"null\">Shareholders</span><span closure_uid_503514901=\"1188\" wd=\"null\">&#39;</span> <span class=\"hps\" closure_uid_503514901=\"1189\" wd=\"null\">interests</span><span closure_uid_503514901=\"1190\" wd=\"null\">:</span> <span class=\"hps\" closure_uid_503514901=\"1191\" wd=\"null\">tangible</span> <span class=\"hps\" closure_uid_503514901=\"1192\" wd=\"null\">and intangible</span> <span class=\"hps\" closure_uid_503514901=\"1193\" wd=\"null\">investment income</span><span closure_uid_503514901=\"1194\" wd=\"null\">.</span><br closure_uid_503514901=\"1370\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1371\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1372\" wd=\"null\" />\r\n	<strong><span closure_uid_503514901=\"1195\" wd=\"null\">Enterprise spirit:</span></strong><br closure_uid_503514901=\"1373\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1196\" wd=\"null\">Dedication, integrity</span><span closure_uid_503514901=\"1197\" wd=\"null\">, responsibility</span><span closure_uid_503514901=\"1198\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1199\" wd=\"null\">innovation</span><span closure_uid_503514901=\"1200\" wd=\"null\">;</span><br closure_uid_503514901=\"1374\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1201\" wd=\"null\">Dedication</span><span closure_uid_503514901=\"1202\" wd=\"null\">:</span> <span class=\"hps\" closure_uid_503514901=\"1203\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1204\" wd=\"null\">quality</span> <span class=\"hps\" closure_uid_503514901=\"1205\" wd=\"null\">of the</span> <span class=\"hps\" closure_uid_503514901=\"1206\" wd=\"null\">software</span> <span class=\"hps\" closure_uid_503514901=\"1207\" wd=\"null\">and services</span><span closure_uid_503514901=\"1208\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1209\" wd=\"null\">to improve</span> <span class=\"hps\" closure_uid_503514901=\"1210\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1211\" wd=\"null\">level</span> <span class=\"hps\" closure_uid_503514901=\"1212\" wd=\"null\">of</span> <span class=\"hps\" closure_uid_503514901=\"1213\" wd=\"null\">user</span> <span class=\"hps\" closure_uid_503514901=\"1214\" wd=\"null\">network</span> <span class=\"hps\" closure_uid_503514901=\"1215\" wd=\"null\">marketing</span><span closure_uid_503514901=\"1216\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1217\" wd=\"null\">we</span> <span class=\"hps\" closure_uid_503514901=\"1218\" wd=\"null\">cherish</span> <span class=\"hps\" closure_uid_503514901=\"1219\" wd=\"null\">this</span> <span class=\"hps\" closure_uid_503514901=\"1220\" wd=\"null\">opportunity</span><span closure_uid_503514901=\"1221\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1222\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"1223\" wd=\"null\">we</span> <span class=\"hps\" closure_uid_503514901=\"1224\" wd=\"null\">respect</span> <span class=\"hps\" closure_uid_503514901=\"1225\" wd=\"null\">this</span> <span class=\"hps\" closure_uid_503514901=\"1226\" wd=\"null\">profession</span><span closure_uid_503514901=\"1227\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1228\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"1229\" wd=\"null\">we are</span> <span class=\"hps\" closure_uid_503514901=\"1230\" wd=\"null\">proud of</span><span closure_uid_503514901=\"1231\" wd=\"null\">;</span><br closure_uid_503514901=\"1375\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1232\" wd=\"null\">Honesty:</span> <span class=\"hps\" closure_uid_503514901=\"1233\" wd=\"null\">Sincerity</span> <span class=\"hps\" closure_uid_503514901=\"1234\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"1235\" wd=\"null\">convince people</span><span closure_uid_503514901=\"1236\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1237\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"1238\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1239\" wd=\"null\">interests of the user</span> <span class=\"hps\" closure_uid_503514901=\"1240\" wd=\"null\">to ensure</span> <span class=\"hps\" closure_uid_503514901=\"1241\" wd=\"null\">the interests of the company</span> <span class=\"hps\" closure_uid_503514901=\"1242\" wd=\"null\">to achieve</span> <span class=\"hps\" closure_uid_503514901=\"1243\" wd=\"null\">economic benefits</span><span closure_uid_503514901=\"1244\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1245\" wd=\"null\">social benefits</span><span closure_uid_503514901=\"1246\" wd=\"null\">;</span><br closure_uid_503514901=\"1376\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1247\" wd=\"null\">Diligence</span><span closure_uid_503514901=\"1248\" wd=\"null\">:</span> <span class=\"hps\" closure_uid_503514901=\"1249\" wd=\"null\">our software</span> <span class=\"hps\" closure_uid_503514901=\"1250\" wd=\"null\">design</span><span closure_uid_503514901=\"1251\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1252\" wd=\"null\">development</span><span closure_uid_503514901=\"1253\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1254\" wd=\"null\">testing,</span> <span class=\"hps\" closure_uid_503514901=\"1255\" wd=\"null\">implementation,</span> <span class=\"hps\" closure_uid_503514901=\"1256\" wd=\"null\">all aspects of the</span> <span class=\"hps\" closure_uid_503514901=\"1257\" wd=\"null\">service</span> <span class=\"hps\" closure_uid_503514901=\"1258\" wd=\"null\">are</span> <span class=\"hps\" closure_uid_503514901=\"1259\" wd=\"null\">diligent attention to detail</span><span closure_uid_503514901=\"1260\" wd=\"null\">;</span><br closure_uid_503514901=\"1377\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1261\" wd=\"null\">Innovation:</span> <span class=\"hps\" closure_uid_503514901=\"1262\" wd=\"null\">Innovation</span> <span class=\"hps\" closure_uid_503514901=\"1263\" wd=\"null\">is the essence of</span> <span class=\"hps\" closure_uid_503514901=\"1264\" wd=\"null\">creative destruction</span><span closure_uid_503514901=\"1265\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"1266\" wd=\"null\">Innovative</span> <span class=\"hps\" closure_uid_503514901=\"1267\" wd=\"null\">ways to</span> <span class=\"hps\" closure_uid_503514901=\"1268\" wd=\"null\">think creatively</span> <span class=\"hps\" closure_uid_503514901=\"1269\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"1270\" wd=\"null\">explore</span><span closure_uid_503514901=\"1271\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"1272\" wd=\"null\">Only</span> <span class=\"hps\" closure_uid_503514901=\"1273\" wd=\"null\">by</span> <span class=\"hps\" closure_uid_503514901=\"1274\" wd=\"null\">constant</span> <span class=\"hps\" closure_uid_503514901=\"1275\" wd=\"null\">self-denial</span><span closure_uid_503514901=\"1276\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1277\" wd=\"null\">self-improvement</span><span closure_uid_503514901=\"1278\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1279\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"1280\" wd=\"null\">create a</span> <span class=\"hps\" closure_uid_503514901=\"1281\" wd=\"null\">valuable product</span><span closure_uid_503514901=\"1282\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1283\" wd=\"null\">market</span><span closure_uid_503514901=\"1284\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1285\" wd=\"null\">and</span> <span class=\"hps\" closure_uid_503514901=\"1286\" wd=\"null\">service</span><span closure_uid_503514901=\"1287\" wd=\"null\">.</span><br closure_uid_503514901=\"1378\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1379\" wd=\"null\" />\r\n	<br closure_uid_503514901=\"1380\" wd=\"null\" />\r\n	<strong><span closure_uid_503514901=\"1288\" wd=\"null\">Talent:</span></strong><br closure_uid_503514901=\"1381\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1289\" wd=\"null\">Attitude is everything</span><span closure_uid_503514901=\"1290\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1291\" wd=\"null\">details</span> <span class=\"hps\" closure_uid_503514901=\"1292\" wd=\"null\">determine success or failure</span><span closure_uid_503514901=\"1293\" wd=\"null\">;</span><br closure_uid_503514901=\"1382\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1294\" wd=\"null\">People-oriented</span><span closure_uid_503514901=\"1295\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"1296\" wd=\"null\">Respecting knowledge and</span> <span class=\"hps\" closure_uid_503514901=\"1297\" wd=\"null\">personality</span><span closure_uid_503514901=\"1298\" wd=\"null\">;</span><br closure_uid_503514901=\"1383\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1299\" wd=\"null\">CD</span> <span class=\"hps\" closure_uid_503514901=\"1300\" wd=\"null\">performance</span><span closure_uid_503514901=\"1301\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1302\" wd=\"null\">not</span> <span class=\"hps\" closure_uid_503514901=\"1303\" wd=\"null\">only academic</span><span closure_uid_503514901=\"1304\" wd=\"null\">, not</span> <span class=\"hps\" closure_uid_503514901=\"1305\" wd=\"null\">only</span> <span class=\"hps\" closure_uid_503514901=\"1306\" wd=\"null\">qualifications</span><span closure_uid_503514901=\"1307\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1308\" wd=\"null\">not</span> <span class=\"hps\" closure_uid_503514901=\"1309\" wd=\"null\">the only</span> <span class=\"hps\" closure_uid_503514901=\"1310\" wd=\"null\">past</span> <span class=\"hps\" closure_uid_503514901=\"1311\" wd=\"null\">the credit</span><span closure_uid_503514901=\"1312\" wd=\"null\">;</span><br closure_uid_503514901=\"1384\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1313\" wd=\"null\">Provide sufficient</span> <span class=\"hps\" closure_uid_503514901=\"1314\" wd=\"null\">resources</span> <span class=\"hps\" closure_uid_503514901=\"1315\" wd=\"null\">so</span> <span class=\"hps\" closure_uid_503514901=\"1316\" wd=\"null\">that</span> <span class=\"hps\" closure_uid_503514901=\"1317\" wd=\"null\">all</span> <span class=\"hps\" closure_uid_503514901=\"1318\" wd=\"null\">employees</span> <span class=\"hps\" closure_uid_503514901=\"1319\" wd=\"null\">can</span> <span class=\"hps\" closure_uid_503514901=\"1320\" wd=\"null\">be</span> <span class=\"hps\" closure_uid_503514901=\"1321\" wd=\"null\">most suited to their</span> <span class=\"hps\" closure_uid_503514901=\"1322\" wd=\"null\">direction of</span> <span class=\"hps\" closure_uid_503514901=\"1323\" wd=\"null\">development</span><span closure_uid_503514901=\"1324\" wd=\"null\">;</span><br closure_uid_503514901=\"1385\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1325\" wd=\"null\">Encourage innovation</span><span closure_uid_503514901=\"1326\" wd=\"null\">,</span> <span class=\"hps atn\" closure_uid_503514901=\"1327\" wd=\"null\">promote &quot;</span><span closure_uid_503514901=\"1328\" wd=\"null\">performance</span><span closure_uid_503514901=\"1329\" wd=\"null\">&quot;</span><span closure_uid_503514901=\"1330\" wd=\"null\">.</span> <span class=\"hps\" closure_uid_503514901=\"1331\" wd=\"null\">A sound system</span><span closure_uid_503514901=\"1332\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1333\" wd=\"null\">norms</span><span closure_uid_503514901=\"1334\" wd=\"null\">,</span> <span class=\"hps\" closure_uid_503514901=\"1335\" wd=\"null\">from</span> <span class=\"hps\" closure_uid_503514901=\"1336\" wd=\"null\">the</span> <span class=\"hps\" closure_uid_503514901=\"1337\" wd=\"null\">person</span> <span class=\"hps\" closure_uid_503514901=\"1338\" wd=\"null\">responsible for the</span> <span class=\"hps\" closure_uid_503514901=\"1339\" wd=\"null\">progress</span> <span class=\"hps\" closure_uid_503514901=\"1340\" wd=\"null\">to</span> <span class=\"hps\" closure_uid_503514901=\"1341\" wd=\"null\">be responsible</span><span closure_uid_503514901=\"1342\" wd=\"null\">;</span><br closure_uid_503514901=\"1386\" wd=\"null\" />\r\n	<span closure_uid_503514901=\"1343\" wd=\"null\">Encourage</span> <span class=\"hps\" closure_uid_503514901=\"1344\" wd=\"null\">pondering</span> <span class=\"hps\" closure_uid_503514901=\"1345\" wd=\"null\">things</span> <span class=\"hps atn\" closure_uid_503514901=\"1346\" wd=\"null\">&quot;</span><span closure_uid_503514901=\"1347\" wd=\"null\">oppose</span><span closure_uid_503514901=\"1348\" wd=\"null\">&quot;</span> <span class=\"hps\" closure_uid_503514901=\"1349\" wd=\"null\">pondering</span> <span class=\"hps atn\" closure_uid_503514901=\"1350\" wd=\"null\">&quot;</span><span closure_uid_503514901=\"1351\" wd=\"null\">will never allow</span> <span class=\"hps\" closure_uid_503514901=\"1352\" wd=\"null\">any form of</span><span closure_uid_503514901=\"1353\" wd=\"null\">&quot;</span> <span class=\"hps\" closure_uid_503514901=\"1354\" wd=\"null\">office politics</span> <span class=\"hps atn\" closure_uid_503514901=\"1355\" wd=\"null\">&quot;</span><span closure_uid_503514901=\"1356\" wd=\"null\">.</span></p>\r\n','','32','_self','','0','/Upload/public/wenhua.jpg','','','','culture','','20','0','page.html','','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/wenhua.png','0'),
('38','35','0','Honor','','<p>\r\n	<span style=\"font-size: 16px\"><span style=\"color: #ff0000\"><strong>Important qualification</strong></span></span><br />\r\n	Computer information system integration qualification<br />\r\n	State planning key software enterprises<br />\r\n	High-tech enterprises<br />\r\n	CMMIv1.2 five<br />\r\n	ISO9001: 2008 quality management system certification<br />\r\n	The ISO20000 IT service management system certification<br />\r\n	Enterprise management information system 99 Third Edition (labor) front desk technical support providers</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<strong><span style=\"color: #ff0000\"><span style=\"font-size: 16px\">Important honor</span></span></strong><br />\r\n	Information Industry Technology Innovation Advanced Collective<br />\r\n	National high-tech industrialization demonstration project<br />\r\n	National science and technology innovation and advanced quality management unit<br />\r\n	Backbone enterprises of National Torch Program Software Industrial Base<br />\r\n	2013 top ten innovative software companies<br />\r\n	The country fourth installment innovative pilot enterprises<br />\r\n	2013 China Outstanding service provider of enterprise information<br />\r\n	2013 China Annual Innovation software companies<br />\r\n	2013 Software IT Golden Tripod<br />\r\n	China validated enterprise technical centers<br />\r\n	Science and Technology Bureau of Information Engineering Technology Research Center<br />\r\n	The 2013 older Shashi keep credit business contracts</p>\r\n','','32','_self','','0','/Upload/public/rongyu.jpg','','','','honor','','20','0','page.html','','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/rongyu.png','0'),
('39','35','0','Organization','','<div style=\"text-align: center\">\r\n	<p>\r\n		<img alt=\"\" src=\"/Upload/public/zzjj1en.png\" style=\"width: 99%;\" /></p>\r\n	<p>\r\n		<img alt=\"\" src=\"/Upload/public/zzjjen.png\" style=\"width: 99%;\" /></p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>\r\n','','32','_self','','0','/Upload/public/jg.png','','','','organization','','20','0','page.html','','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/zzjj1en.png','0'),
('40','0','1','News','news','','','30','_self','','0','/Upload/news/news.jpg','','','','news','','20','0','article.html','showarticle.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/40.jpg','0'),
('41','40','0','Company News','','','','30','_self','','0','/Upload/public/gsxw.jpg','','','','companynews','','20','0','article.html','showarticle.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/gsxw.png','0'),
('42','40','0','Industry Trends','','','','30','_self','','0','/Upload/public/hyxw.jpg','','','','industrytrends','','20','0','article.html','showarticle.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/hyxw.png','0'),
('43','0','1','Product','product','','','36','_self','','0','/Upload/public/ddsa.png','','','','product','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/43.jpg','3'),
('44','43','0','Paint','','','','36','_self','','0','','','','','class1','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0'),
('45','43','0','Additive','','','','36','_self','','0','','','','','class2','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0'),
('46','43','0','Medicine','','','','36','_self','','0','','','','','class3','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0'),
('47','43','1','Anticorrosive','','','','36','_self','','0','','','','','class4','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','3'),
('48','47','0','Edible','','','','36','_self','','0','','','','','class41','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0'),
('49','47','0','Industry','','','','36','_self','','0','','','','','class42','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/23.jpg','0'),
('52','0','0','Contact Us','','<!--引用百度地图API-->\r\n<style type=\"text/css\">\r\n.iw_poi_title {color:#CC5522;font-size:14px;font-weight:bold;overflow:hidden;padding-right:13px;white-space:nowrap}\r\n    .iw_poi_content {font:12px arial,sans-serif;overflow:visible;padding-top:4px;white-space:-moz-pre-wrap;word-wrap:break-word}</style>\r\n<script type=\"text/javascript\" src=\"http://api.map.baidu.com/api?key=&v=1.1&services=true\"></script><!--百度地图容器-->\r\n<div id=\"dituContent\" style=\"width:100%;height:550px;border:#ccc solid 1px;float:right\">\r\n	&nbsp;</div>\r\n<script type=\"text/javascript\">\r\n    //创建和初始化地图函数：\r\n    function initMap(){\r\n        createMap();//创建地图\r\n        setMapEvent();//设置地图事件\r\n        addMapControl();//向地图添加控件\r\n    }\r\n    \r\n    //创建地图函数：\r\n    function createMap(){\r\n        var map = new BMap.Map(\"dituContent\");//在百度地图容器中创建一个地图\r\n        var point = new BMap.Point(116.395645,39.929986);//定义一个中心点坐标\r\n        map.centerAndZoom(point,12);//设定地图的中心点和坐标并将地图显示在地图容器中\r\n        window.map = map;//将map变量存储在全局\r\n    }\r\n    \r\n    //地图事件设置函数：\r\n    function setMapEvent(){\r\n        map.enableDragging();//启用地图拖拽事件，默认启用(可不写)\r\n        map.enableScrollWheelZoom();//启用地图滚轮放大缩小\r\n        map.enableDoubleClickZoom();//启用鼠标双击放大，默认启用(可不写)\r\n        map.enableKeyboard();//启用键盘上下左右键移动地图\r\n    }\r\n    \r\n    //地图控件添加函数：\r\n    function addMapControl(){\r\n        //向地图中添加缩放控件\r\n	var ctrl_nav = new BMap.NavigationControl({anchor:BMAP_ANCHOR_TOP_LEFT,type:BMAP_NAVIGATION_CONTROL_LARGE});\r\n	map.addControl(ctrl_nav);\r\n        //向地图中添加缩略图控件\r\n	var ctrl_ove = new BMap.OverviewMapControl({anchor:BMAP_ANCHOR_BOTTOM_RIGHT,isOpen:1});\r\n	map.addControl(ctrl_ove);\r\n        //向地图中添加比例尺控件\r\n	var ctrl_sca = new BMap.ScaleControl({anchor:BMAP_ANCHOR_BOTTOM_LEFT});\r\n	map.addControl(ctrl_sca);\r\n    }\r\n    \r\n    \r\n    initMap();//创建和初始化地图\r\n</script>','','32','_self','','0','','','','','contacts','','20','20','page.html','','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/52.jpg','0'),
('55','15','0','涂料视频','视频','','','34','_self','','0','/Upload/public/sp.jpg','','','','video','','20','0','video.html','showvideo.html','1','0','1','0','1','1',NULL,NULL,NULL,'/Upload/icon/sp.png','0'),
('56','35','0','Video','video','','','34','_self','','0','/Upload/public/sp.jpg','','','','video','','20','0','video.html','showvideo.html','1','0','1','0','1','2',NULL,NULL,NULL,'/Upload/icon/sp.png','0'),
('57','23','0','卫生品','','','','36','_self','','0','','','','','jjwsp','','20','0','product.html','showproduct.html','1','0','1','0','1','1',NULL,NULL,NULL,'','0'),
('58','43','0','Hygiene','','','','36','_self','','0','','','','','hygiene','','20','0','product.html','showproduct.html','1','0','1','0','1','2',NULL,NULL,NULL,'','0');

INSERT INTO `youdian_channel_model` VALUES
('1','频道信息','1','youdian_channel','','0','1',NULL,NULL),
('2','专题信息','2','youdian_special',NULL,'1','1',NULL,NULL),
('3','幻 灯 片','3','youdian_banner',NULL,'1','1',NULL,NULL),
('4','在线客服','4','youdian_support',NULL,'1','1',NULL,NULL),
('5','第三方在线客服','5','youdian_support3',NULL,'1','1',NULL,NULL),
('6','在线留言','6','youdian_guestbook',NULL,'1','1',NULL,NULL),
('7','人才招聘','7','youdian_recruit',NULL,'1','1',NULL,NULL),
('8','信息评论','8','youdian_comment',NULL,'1','1',NULL,NULL),
('9','友情链接分类','5','youdian_link_class',NULL,'1','1',NULL,NULL),
('10','友情链接','9','youdian_link',NULL,'1','1',NULL,NULL),
('11','广告信息','10','youdian_ad',NULL,'1','1',NULL,NULL),
('12','会员分组','11','youdian_member_group',NULL,'1','1',NULL,NULL),
('13','会员信息','13','youdian_member',NULL,'0','1',NULL,NULL),
('14','管理员信息','14','youdian_admin',NULL,'1','1',NULL,NULL),
('15','管理员组','15','youdian_admin_group',NULL,'1','1',NULL,NULL),
('16','修改模板','16',NULL,NULL,'1','1',NULL,NULL),
('17','自定义标签','17','youdian_tag',NULL,'1','1',NULL,NULL),
('18','属性标记','18','youdian_label',NULL,'1','1',NULL,NULL),
('19','模型管理','19','youdian_channel_model',NULL,'1','1',NULL,NULL),
('20','字段管理','20','youdian_attribute',NULL,'1','1',NULL,NULL),
('21','字段分组管理','21','youdian_attribute',NULL,'1','1',NULL,NULL),
('22','幻灯分组管理','22','youdian_banner_group',NULL,'1','1',NULL,NULL),
('23','邮件订阅分类','23','youdian_mail_class',NULL,'1','1',NULL,NULL),
('24','邮件管理','24','youdian_mail',NULL,'1','1',NULL,NULL),
('25','邮件群发管理','25','youdian_mail_send',NULL,'1','1',NULL,NULL),
('26','订单模型','26','youdian_order',NULL,'1','1',NULL,NULL),
('30','文章模型','30','youdian_info','','0','1','article.html','showarticle.html'),
('31','图片模型','31','youdian_info',NULL,'0','1','picture.html','showpicture.html'),
('32','单页模型','32','youdian_channel',NULL,'0','1','page.html',''),
('33','链接模型','33','youdian_info',NULL,'0','1','',''),
('34','视频模型','34','youdian_info','','0','1','video.html','showvideo.html'),
('35','下载模型','35','youdian_info','','0','1','download.html','showdownload.html'),
('36','产品模型','36','youdian_info','','0','1','product.html','showproduct.html'),
('37','反馈模型','37',NULL,'','0','1','feedback.html','showfeedback.html'),
('38','保留模型3','38',NULL,'系统保留使用，建议不要自定义','0','0',NULL,NULL),
('39','保留模型4','39',NULL,'系统保留使用，建议不要自定义','0','0',NULL,NULL);

INSERT INTO `youdian_config` VALUES
('1','WEB_NAME','某某公司',NULL,'basic','1','1'),
('2','WEB_URL','http://www.xx.com',NULL,'basic','1','0'),
('3','WEB_ICP','ICP备888888888号',NULL,'basic','1','1'),
('4','WEB_STATUS','1',NULL,'basic','1','0'),
('5','WEB_CLOSE_REASON','抱歉，网站正在维护中，给您带来不便深表歉意！',NULL,'basic','1','1'),
('6','WEB_BAD_WORDS','他妈的=***',NULL,'basic','1','0'),
('7','TITLE','website|cms|wap website|finished website',NULL,'seo','1','2'),
('8','CONTACT','Miss Cheng',NULL,'contact','1','2'),
('9','COMPANY','某某公司',NULL,'contact','1','1'),
('10','CONTACT','陈小姐',NULL,'contact','1','1'),
('11','ADDRESS','北京市海淀区学院路春天花园8栋906',NULL,'contact','1','1'),
('12','TELEPHONE','010-12345678',NULL,'contact','1','1'),
('13','MOBILE','13512345678',NULL,'contact','1','1'),
('14','FAX','010-12345678',NULL,'contact','1','1'),
('15','EMAIL','12345@qq.com',NULL,'contact','1','1'),
('16','POSTCODE','400000',NULL,'contact','1','1'),
('17','ONLINE_ENABLE','1',NULL,'online','1','0'),
('18','ONLINE_STYLE','blue',NULL,'online','1','1'),
('19','ONLINE_POSITION','0',NULL,'online','1','0'),
('20','UPLOAD','./Upload/',NULL,'upload','1','0'),
('21','UPLOAD_FILE_TYPE','rar|zip|doc|docx|ppt|pptx|pdf|jpg|xls|png|gif|mp3|jpeg|bmp|swf|flv|ico',NULL,'upload','1','0'),
('22','MAX_UPLOAD_SIZE','5242880',NULL,'upload','1','0'),
('23','GUEST_BOOK_ALLOW','1',NULL,'guestbook','1','0'),
('24','GUEST_BOOK_CHECK','1',NULL,'guestbook','1','0'),
('25','GUEST_BOOK_VERIFYCODE','1',NULL,'guestbook','1','0'),
('26','GUEST_BOOK_PAGESIZE','10',NULL,'guestbook','1','0'),
('27','COMMENT_ENABLE','1',NULL,'comment','1','0'),
('28','COMMENT_CHECK','1',NULL,'comment','1','0'),
('29','COMMENT_VERIFYCODE','1',NULL,'comment','1','0'),
('30','MEMBER_REG_ENABLE','1',NULL,'reg','1','0'),
('31','MEMBER_REG_CHECK','1',NULL,'reg','1','0'),
('32','MEMBER_REG_VERIFYCODE','1',NULL,'reg','1','0'),
('40','QQ','',NULL,'contact','1','1'),
('41','APP_GROUP_LIST','Home,Admin,Install',NULL,'config','1','0'),
('42','DEFAULT_GROUP','Home',NULL,'config','1','0'),
('43','DEFAULT_MODULE','Index',NULL,'config','1','0'),
('44','DEFAULT_ACTION','Index',NULL,'config','1','0'),
('45','URL_MODEL','1',NULL,'config','1','0'),
('46','DEFAULT_THEME','Default',NULL,'config','1','0'),
('47','URL_CASE_INSENSITIVE','true',NULL,'config','1','0'),
('48','TMPL_ACTION_ERROR','APP_PATH.\'tpl/admin/default/public/error.html\'',NULL,'config','0','0'),
('49','TMPL_ACTION_SUCCESS','APP_PATH.\'tpl/admin/default/public/success.html\' ',NULL,'config','0','0'),
('50','TAGLIB_PRE_LOAD','YouDian',NULL,'config','1','0'),
('51','DEFAULT_THEME','Default',NULL,'home/config','1','0'),
('52','WATER_PIC','',NULL,'water','1','0'),
('53','WATER_OFFSET_X','0',NULL,'water','1','0'),
('54','WATER_OFFSET_Y','0',NULL,'water','1','0'),
('55','WATER_TRANS','60',NULL,'water','1','0'),
('56','TITLE','企业网站管理系统|微网站建设|手机网站建设|中英文网站建设',NULL,'seo','1','1'),
('57','KEYWORDS','企业网站管理系统,微网站建设,手机网站建设,中英文网站建设',NULL,'seo','1','1'),
('58','DESCRIPTION','本系统集手机站、微信站、电脑站三站合一，各站数据同步、只需一个空间,维护更方便！订购热线：010-88888888',NULL,'seo','1','1'),
('59','ONLINE_TOP','180',NULL,'online','1','0'),
('60','ONLINE_EFFECT','1',NULL,'online','1','0'),
('61','ONLINE_WIDTH','160',NULL,'online','1','0'),
('62','ONLINE_OPEN','1',NULL,'online','1','0'),
('63','ONLINE_TELEPHONE','',NULL,'online','1','0'),
('64','ONLINE_FOOTER_TEXT','<img alt=\"微信扫一扫 关注我们\" src=\"/Upload/public/qrcode.jpg\" style=\"width: 130px; height: 130px;margin-top:8px;\" title=\"微信扫一扫 关注微信公众号\" /><br />\r\n<b style=\"color: rgb(255, 0, 0);\">wangzhan</b><br />\r\n<strong>扫一扫，关注微信公众号</strong>',NULL,'online','1','1'),
('65','ONLINE_TITLE','在线客服',NULL,'online','1','1'),
('66','URL_MODEL','1',NULL,'core','1','0'),
('67','URL_HTML_SUFFIX','html',NULL,'core','1','0'),
('68','WEB_NAME',' web name',NULL,'basic','1','2'),
('69','WEB_ICP','ICP 123456789',NULL,'basic','1','2'),
('70','WEB_CLOSE_REASON','Sorry, the website is maintenance!',NULL,'basic','1','2'),
('71','COMPANY','your company',NULL,'contact','1','2'),
('72','DESCRIPTION','this product include pc site、mobile site、weixin site，Data synchronization, one virtual host, more convenient maintenance. Order hotline: +86-010-88888888',NULL,'seo','1','2'),
('73','KEYWORDS','website,cms,wap website',NULL,'seo','1','2'),
('74','ADDRESS','Room 906, 8th Building Spring Garden, XueYuan Road',NULL,'contact','1','2'),
('76','ONLINE_TITLE','online services',NULL,'online','1','2'),
('77','ONLINE_FOOTER_TEXT','<img alt=\"\" src=\"/Upload/public/qrcode.jpg\" style=\"width: 130px; height: 130px;margin-top:8px;\" title=\"号\" /><br />\r\n<b style=\"color: rgb(255, 0, 0);\">wangzhan</b><br />\r\n<strong>wechat</strong>',NULL,'online','1','2'),
('78','ORDER_ALLOW','1','订单权限','order','1','0'),
('79','ORDER_PAGESIZE','10','每页显示订单数','order','1','0'),
('80','STAT_USERNAME','','统计帐号','stat','1','0'),
('81','STAT_USERPWD','','登录密码','stat','1','0'),
('82','STAT_CODE','','统计代码','stat','1','0'),
('83','STAT_ENABLE','1','是否启用统计','stat','1','0'),
('84','SHARE_STYLE','0',NULL,'baidushare','1','0'),
('85','SHARE_TOP','333',NULL,'baidushare','1','0'),
('86','SHARE_POS','right',NULL,'baidushare','1','0'),
('87','SHARE_SIZE','0',NULL,'baidushare','1','0'),
('88','SHARE_ENABLE','0',NULL,'baidushare','1','0'),
('89','MOBILE','86-13512345678',NULL,'contact','1','2'),
('90','TELEPHONE','86-010-12345678',NULL,'contact','1','2'),
('91','FAX','86-010-12345678',NULL,'contact','1','2'),
('92','EMAIL','12345@qq.com',NULL,'contact','1','2'),
('93','QQ','',NULL,'contact','1','2'),
('94','POSTCODE','400000',NULL,'contact','1','2'),
('95','LINK_ENABLE','0','是否启用生成关键词内链','link','1','0'),
('96','LINK_KEYWORD','','关键词对应链接设置','link','1','0'),
('97','WEB_BAD_IP','',NULL,'basic','1','0'),
('98','WAP_URL','','手机网站域名','domain','1','0'),
('99','WEB_LOGO','/Upload/public/logo.png',NULL,'basic','1','1'),
('100','WEB_LOGO','/Upload/public/logo.png',NULL,'basic','1','2'),
('101','MEMBER_ADD_CHECK','1',NULL,'reg','1','0'),
('102','DEFAULT_THEME','Default',NULL,'wap/config','1','0'),
('103','ONLINE_STYLE','blue_en',NULL,'online','1','2'),
('104','HTML_ENABLE','0',NULL,'html','1','0'),
('105','INDEX_CACHE_TIME','604800',NULL,'html','1','0'),
('106','CHANNEL_CACHE_TIME','1296000',NULL,'html','1','0'),
('107','INFO_CACHE_TIME','0',NULL,'html','1','0'),
('108','AUTO_DEL_ENABLE','0',NULL,'other','1','0'),
('109','AUTO_UPLOAD_ENABLE','1',NULL,'other','1','0'),
('110','DEL_LINK_ENABLE','0',NULL,'other','1','0'),
('111','ALLOW_LINK','',NULL,'other','1','0'),
('112','WATER_ENABLE','0',NULL,'water','1','0'),
('113','MEMBER_LOGIN_VERIFYCODE','1',NULL,'reg','1','0'),
('114','ORDER_VERIFYCODE','1',NULL,'order','1','0'),
('115','THUMB_ENABLE','0',NULL,'thumb','1','0'),
('116','THUMB_WATER_ENABLE','0',NULL,'thumb','1','0'),
('117','THUMB_TYPE','2',NULL,'thumb','1','0'),
('118','THUMB_WIDTH','160',NULL,'thumb','1','0'),
('119','THUMB_HEIGHT','160',NULL,'thumb','1','0'),
('120','WATER_TYPE','2',NULL,'water','1','0'),
('121','WATER_TEXT','',NULL,'water','1','0'),
('122','WATER_FONT','simkai.ttf',NULL,'water','1','0'),
('123','WATER_TEXT_SIZE','12',NULL,'water','1','0'),
('124','WATER_TEXT_COLOR','#FF0000',NULL,'water','1','0'),
('125','WATER_TEXT_ANGLE','0',NULL,'water','1','0'),
('126','WATER_POSITION','9',NULL,'water','1','0'),
('127','THUMB_FIRST','1',NULL,'thumb','1','0'),
('128','WAP_AUTO_REDIRECT','0',NULL,'wap','1','0'),
('129','WAP_PC_ACCESS','0',NULL,'wap','1','0'),
('130','WAP_LOGO','',NULL,'wap','1','0'),
('131','LANG_AUTO_DETECT','1',NULL,'core','1','0'),
('132','DEFAULT_LANG','cn',NULL,'core','1','0'),
('133','EMAIL_SENDER','',NULL,'basic','1','1'),
('134','EMAIL_ACCOUNT','',NULL,'basic','1','1'),
('135','EMAIL_SMTP','',NULL,'basic','1','1'),
('136','EMAIL_PASSWORD','',NULL,'basic','1','1'),
('137','EMAIL_BODY','您好，{$MemberName}!感谢您注册成为{$WebName}会员。\r\n请点击以下链接激活会员帐号:\r\n{$Activate}',NULL,'reg','1','1'),
('138','EMAIL_BODY','Hello，{$MemberName}!Welcome to register the member of {$WebName}.\r\nplease click the following url to activate:{$Activate}',NULL,'reg','1','2'),
('139','EMAIL_SENDER','',NULL,'basic','1','2'),
('140','EMAIL_ACCOUNT','',NULL,'basic','1','2'),
('141','EMAIL_SMTP','',NULL,'basic','1','2'),
('142','EMAIL_PASSWORD','',NULL,'basic','1','2'),
('143','ORDER_EMAIL','0',NULL,'order','1','0'),
('144','ORDER_EMAIL_BODY','',NULL,'order','1','0'),
('146','MEMBER_ENABLE','1',NULL,'reg','1','0'),
('147','GUEST_BOOK_SENDEMAIL','0',NULL,'guestbook','1','0'),
('148','WX_TOKEN','',NULL,'wx','1','0'),
('149','WX_APP_ID','',NULL,'wx','1','0'),
('150','WX_APP_SECRET','',NULL,'wx','1','0'),
('151','COMMENT_PAGE_SIZE','5',NULL,'comment','1','0'),
('152','WX_LOGO','',NULL,'wx','1','0'),
('153','WX_NAME','',NULL,'wx','1','0'),
('154','WX_ORIGINAL_ID','',NULL,'wx','1','0'),
('155','WX_ID','',NULL,'wx','1','0'),
('156','WX_DESCRIPTION','',NULL,'wx','1','0'),
('157','WX_QRCODE','',NULL,'wx','1','0'),
('158','WAP_STATUS','1',NULL,'wap','1','0'),
('159','WX_SAVE_MSG','0',NULL,'wx','1','0'),
('160','GUEST_BOOK_EMAIL','',NULL,'guestbook','1','0'),
('161','GUEST_BOOK_EMAIL_TITLE','网站留言提醒',NULL,'guestbook','1','0'),
('162','GUEST_BOOK_EMAIL_BODY','',NULL,'guestbook','1','0'),
('163','ORDER_EMAIL_TITLE','订购通知',NULL,'order','1','0'),
('164','FEEDBACK_VERIFYCODE','1',NULL,'guestbook','1','0'),
('165','FEEDBACK_SENDEMAIL','0',NULL,'guestbook','1','0'),
('166','FEEDBACK_EMAIL','',NULL,'guestbook','1','0'),
('167','FEEDBACK_EMAIL_TITLE','网站反馈通知邮件',NULL,'guestbook','1','0'),
('168','FEEDBACK_CHECK','0',NULL,'guestbook','1','0'),
('169','WEB_ICON','',NULL,'basic','1','0'),
('170','BAIDU_TRANSLATE_APIKEY','RTpNxxuIuLhDsylsFZIa27GI',NULL,'other','1','0'),
('171','EMAIL_PORT','25',NULL,'basic','1','1'),
('172','EMAIL_PORT','25',NULL,'basic','1','2'),
('173','EMAIL_WAY','tls',NULL,'basic','1','1'),
('174','EMAIL_WAY','tls',NULL,'basic','1','2'),
('175','LOG_STATUS','0',NULL,'basic','1','0'),
('176','LOGTYPE_ALLOW','2,3,4,5,6,7,8,1',NULL,'basic','1','0'),
('177','ORDER_EMAIL_TO','',NULL,'order','1','0'),
('178','ADMIN_PAGE_SIZE','20',NULL,'other','1','0'),
('179','ADMIN_ROLL_PAGE','30',NULL,'other','1','0'),
('180','SITEMAP_ENABLE','1',NULL,'other','1','0'),
('181','SITEMAP_TIME','86400',NULL,'other','1','0');

INSERT INTO `youdian_info` VALUES
('67','33',NULL,'1','网站发布的公告标题1111','','<p>\r\n	网站公告1111详细内容</p>\r\n<p>\r\n	网站公告1111详细内容</p>\r\n<p>\r\n	网站公告1111详细内容</p>\r\n<p>\r\n	网站公告1111详细内容</p>\r\n<p>\r\n	网站公告1111详细内容</p>\r\n','0','','','','0','0','','','','','0','2013-03-26 21:05:22',NULL,'6','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,''),
('68','33',NULL,'1','网站发布的公告标题2222','','<p>\r\n	网站公告2222详细内容</p>\r\n<p>\r\n	网站公告2222详细内容</p>\r\n<p>\r\n	网站公告2222详细内容</p>\r\n<p>\r\n	网站公告2222详细内容</p>\r\n<p>\r\n	网站公告2222详细内容</p>\r\n','0','','','','0','0','','','','','0','2013-03-26 21:05:22',NULL,'1','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,''),
('69','33',NULL,'1','网站发布的公告标题3333','','<p>\r\n	网站公告3333详细内容</p>\r\n<p>\r\n	网站公告3333详细内容</p>\r\n<p>\r\n	网站公告3333详细内容</p>\r\n<p>\r\n	网站公告3333详细内容</p>\r\n<p>\r\n	网站公告3333详细内容</p>\r\n','0','','','','0','0','','','','','0','2013-03-26 21:05:22',NULL,'1','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,''),
('70','33',NULL,'1','网站发布的公告标题4444','','<p>\r\n	网站公告4444详细内容</p>\r\n<p>\r\n	网站公告4444详细内容</p>\r\n<p>\r\n	网站公告4444详细内容</p>\r\n<p>\r\n	网站公告4444详细内容</p>\r\n<p>\r\n	网站公告4444详细内容</p>\r\n<p>\r\n	&nbsp;</p>\r\n','0','','','','0','0','','','','','0','2013-03-26 21:05:22',NULL,'8','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,''),
('71','33',NULL,'1','网站发布的公告标题5555','','<p>\r\n	网站公告5555详细内容</p>\r\n<p>\r\n	网站公告5555详细内容</p>\r\n<p>\r\n	网站公告5555详细内容</p>\r\n<p>\r\n	网站公告5555详细内容</p>\r\n<p>\r\n	网站公告5555详细内容</p>\r\n','0','','','','0','0','','','','','0','2013-03-26 21:05:22',NULL,'26','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1',NULL,NULL,NULL,''),
('140','34',NULL,'1','website announcement 1','','<p>\r\n	the description of website announcement 1</p>\r\n<p>\r\n	the description of website announcement 1</p>\r\n<p>\r\n	the description of website announcement 1</p>\r\n<p>\r\n	the description of website announcement 1</p>\r\n<p>\r\n	the description of website announcement 1</p>\r\n','0','','','','0','0','','','','','0','2013-03-27 23:04:47',NULL,'1','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,''),
('141','34',NULL,'1','website announcement 2','','<p>\r\n	the description of website announcement 2</p>\r\n<p>\r\n	the description of website announcement 2</p>\r\n<p>\r\n	the description of website announcement 2</p>\r\n<p>\r\n	the description of website announcement 2</p>\r\n<p>\r\n	the description of website announcement 2</p>\r\n','0','','','','0','0','','','','','0','2013-03-27 23:04:47',NULL,'1','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,''),
('142','34',NULL,'1','website announcement 3','','<p>\r\n	the description of website announcement 3</p>\r\n<p>\r\n	the description of website announcement 3</p>\r\n<p>\r\n	the description of website announcement 3</p>\r\n<p>\r\n	the description of website announcement 3</p>\r\n<p>\r\n	the description of website announcement 3</p>\r\n','0','','','','0','0','','','','','0','2013-03-27 23:04:47',NULL,'1','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,''),
('143','34',NULL,'1','website announcement 4','','<p>\r\n	the description of website announcement 4</p>\r\n<p>\r\n	the description of website announcement 4</p>\r\n<p>\r\n	the description of website announcement 4</p>\r\n<p>\r\n	the description of website announcement 4</p>\r\n<p>\r\n	the description of website announcement 4</p>\r\n','0','','','','0','0','','','','','0','2013-03-27 23:04:47',NULL,'2','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,''),
('144','34',NULL,'1','website announcement 5','','<p>\r\n	the description of website announcement 5</p>\r\n<p>\r\n	the description of website announcement 5</p>\r\n<p>\r\n	the description of website announcement 5</p>\r\n<p>\r\n	the description of website announcement 5</p>\r\n<p>\r\n	the description of website announcement 5</p>\r\n','0','','','','0','0','','','','','0','2013-03-27 23:04:47',NULL,'1','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1',NULL,NULL,NULL,''),
('146','55',NULL,'1','防火涂料测试视频','<iframe height=498 width=100% src=\"http://player.youku.com/embed/XMzgwMDE4OTUy\" frameborder=0 allowfullscreen></iframe>','','0','/Upload/product/product4_03_zlr7.png','','','0','0','','','','','0','2013-04-27 17:34:10',NULL,'21','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('147','55',NULL,'1','公司宣传片','<iframe height=498 width=100%  src=\"http://player.youku.com/embed/XOTE1ODYyODg0\" frameborder=0 allowfullscreen></iframe>','','0','/Upload/product/f2.jpg','','','0','0','','','','','0','2013-04-27 18:06:04',NULL,'4','','9',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('150','55',NULL,'1','怎样验收密封油桶模具','<iframe height=498 width=100%  src=\"http://player.youku.com/embed/XNTc5OTM1OTMy\" frameborder=0 allowfullscreen></iframe>','<p>\r\n	你只闻到我的香水，却没看的我的汗水，你有你的规则，我有我的选择，你否定我的现在，我决定我的未来，你嘲笑我一无所有，不配去爱，我可怜你总是等待，你可以轻视我们的年轻，我们会证明这是谁的时代，梦想是注定孤独的旅行，路上少不了质疑和嘲笑，但那又怎样，哪怕遍体鳞伤也要活的漂亮！</p>\r\n','0','/Upload/product/product4_05_dd9u.png','','','0','0','','','','','0','2013-04-27 20:05:14',NULL,'31','','7',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('152','21',NULL,'1','我国船舶防腐蚀涂料研究发展及未来走向','','摘要:氟碳树脂是近年来广受关注的新型材料,它具有极优异的耐候性、耐沾污性、耐化学品性、耐溶剂性等,是超耐候性建筑涂料及重防腐涂料的优良材料。在海洋气候这种极苛刻的腐蚀环境下,以氟碳树脂及含氟聚氨酯等改性材料作为面漆的基料是极佳的选择,除用于船壳漆以外,... -<br />\r\n慧聪表面处理网：地球表面的4／5为海洋所覆盖，海洋经济和海洋产业对人类社会的发展起着极为重要的作用。我国从南至北海岸线长达18000多km，南北气温相差50℃，海生物众多。海洋环境是十分严酷的腐蚀环境，船舶长期处于这样的海洋环境中，腐蚀极其严重，而涂料一直是其最主要的防腐手段。海洋防腐和防污涂料是构成海洋涂料的基础。根据各种设施的使用环境和要求不同，又衍生出各种系列产品，例如，船舶涂料、海洋工程设施用重防腐涂料等。 其中，船舶涂料叉分为船底防腐和防污漆、船壳漆、甲板漆、内舱漆以及阻尼降噪等特种涂料。由于船舱的特殊性，人们除了关注船舱涂料的耐蚀性外，还特别关注其毒性问题。因为涂层的耐蚀性影响到船舶的服役时间和服役性能，而涂层的毒性问题则关系到船员的人身健康与安全。我国涂料又分为多种，分别用在不同领域。 1.重防腐涂料 重防腐涂料是指在严酷环境中比常规涂料有更长保护期的防腐涂料，具有厚膜、高固体分、双组分等特征。重防腐是一个系统工程，涉及使用环境评估、材料选择、配套设计、施工质量控制等各方面，并且根据使用环境和维修的难易程度，对不同的使用对象有不同的使用年限要求，对于船舶涂料来说，要求有5～10年的防护期。 1．1重防腐底漆 重防腐涂料通常由底漆、中间漆和面漆组成。由于普通面漆的寿命远不及防锈漆，所以底漆的性能尤其重要，无机富锌涂料是被公认的重防腐涂料通用底漆。目前重防腐涂料体系的问题是缺乏长效的实际使用数据支持，没有有效的加速测试方法。 1．2玻璃鳞片涂料 在涂层上通常存在两大类微孔：分子空隙产生的10-5～10-7cm孔隙，溶剂挥发产生的10-2～10-4cm孔隙。溶剂挥发产生的孔隙是水汽、盐雾等腐蚀产物渗入的主要通道，在这方面，鳞片涂料有很好的阻挡效果，从而成为重防腐涂料底漆的重要选择。涂料中的鳞片材料主要有片状的云母、云母氧化铁、石墨、锌粉、不锈钢和玻璃鳞片。片状云母、云母氧化铁、石墨等由于价格便宜，在船舶防锈涂料中得到大量应用，而玻璃鳞片的价格较贵，只在桥梁等建筑的涂装中最为常用。随着对舰船涂料更长效的要求，玻璃鳞片类型的重防腐涂料将会得到广泛的应用。 1．3超耐候性面漆 氟碳树脂是近年来广受关注的新型材料，它具有极优异的耐候性、耐沾污性、耐化学品性、耐溶剂性等，是超耐候性建筑涂料及重防腐涂料的优良材料。在海洋气候这种极苛刻的腐蚀环境下，以氟碳树脂及含氟聚氨酯等改性材料作为面漆的基料是极佳的选择，除用于船壳漆以外，还可用于接触强腐蚀介质的内舱涂料等。另外，有效期3～5a的脂肪族聚氨酯、5～8a的有机硅改性涂料等超耐候性面漆有一定的市场。国内在树脂、制漆工艺、可重涂性和层间附着力等性能方面正在缩小与国外产品的差距。','0','','','','0','0','','','','','0','2015-10-22 09:45:23',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('153','21',NULL,'1','三金华都:细节成就品质 探索三金外墙氟碳漆','','摘要:在外墙漆施工上独一无二,氟碳漆、使用寿命长,15年长效保护,具有优异的保色性,优异的耐候性、耐磨损性、抗碰击性等特性。...现在一般的外墙多是乳胶漆涂料,这种外墙的颜料耐晒牢度不高,涂料中有机树脂含量过少,成膜剂选着不当,...','0','','','','0','0','','','','','0','2015-10-22 09:45:23',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('154','21',NULL,'1','美国孕妇体内发现多种有毒化学品','','摘要:...在99%至100%的孕妇体内都带有多氯联苯(PCBs)、含有机氯的杀虫剂、全氟碳化合物(PFCs)、苯酚、多溴联苯醚(PBDEs)、邻苯二甲酸盐、多环芳烃(PAHs)以及高氯酸盐等等。 ...二联酚A能够使塑料制品更为结实、洁净,含有二联酚A的环氧树脂通常被用在食品和饮料金属罐的内部,经检测发现96%的孕妇体内均有携带...','0','','','','0','0','','','','','0','2015-10-22 09:45:23',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('155','21',NULL,'1','幕墙金属结构涂装氟碳漆的施工工艺','','摘要:氟碳漆 凭借其出色的耐候性、耐久性、耐腐蚀性、耐热性、耐低温性等优良特性,作为金属结构表面防护及装饰材料,在幕墙施工中得到大量使用 ...环氧树脂 、锌粉及聚酰胺树脂组成的A、B双组分涂料,施工性能良好,具有优良的防腐蚀及耐磨损性能。 喷涂前确定底材上无油污,无灰尘,...','0','','','','0','0','','','','','0','2015-10-22 09:45:23',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('156','21',NULL,'1','三爱富成国内最大PVDF产销商','','摘要:生意社1月28日讯 1月24日,记者从上海三爱富新材料股份有限公司获悉,2010年底,该公司已成为国内最大的PVDF(聚偏氟乙烯树脂)产销商。...据了解,PVDF是氟化工中产量仅次于PTFE的含氟树脂产品,主要应用于石油化工、电子电气和氟碳涂料三大领域。近年来,...','0','','','','0','0','','','','','0','2015-10-22 09:47:06',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('157','22',NULL,'1','“十二五”期间涂料用树脂质量双升','','摘要:树脂不仅仅在塑料行业应用广泛,同时也是涂料配方中的重要原料。作为涂料的主要成膜物质之一,涂料用环氧树脂已占总量的36%,是环氧树脂应用领域中增长最快的领域。...除了上述几大主要的合成树脂外,氟碳涂料以其优异的耐候性和高耐粘污性近年来不断得到应用。...','0','','','','0','0','','','','','0','2015-10-22 09:47:33',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('158','22',NULL,'1','氟碳漆国内外同类产品标准比较及样品','','摘要:如松香改性酚醛树脂占树脂总量50%或50 http://www.youqiyouqi.com %以上,则划入酚醛树脂漆类,小于50%则划入天然树脂漆类。必要时也可选取两种成膜物质命名, 产品序号用来区分同一类型的不同品种,表示油在树脂中所占的比例、氨基树脂在总树脂中所占的比例等。 已经批量生产的涂料品种,...','0','','','','0','0','','','','','0','2015-10-22 09:47:33',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('159','22',NULL,'1','新春送大礼 环保抗碱底漆打造完美家居','','摘要:环氧树脂 液,成份二为专用固化剂,适用于混凝土、木材、水磨石、钢铁等基材表面作封闭底漆。...氟碳漆和塑胶漆等民用及工业涂料的大型综合性化工企业。泰莱涂料精心研究设计产品配方与生产工艺,采用世界上最好的原料为主要原料,...','0','','','','0','0','','','','','0','2015-10-22 09:47:33',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('160','22',NULL,'1','2010年11月通过中国环境标志认证的企业名单','','摘要:广州力盟树脂有限公司 广东省 胶粘剂 2010-11-10 2012-9-23 05503P1008069R 2M 金力 牌 PU 胶: AD -85M 、 AD ...E800 水性氟碳漆、 S100 、 S 100C 清水混凝土保护剂、 T302 、 T306 外墙罩光清漆、 E100 、 E200 外墙抗碱底漆、 T200 专用抗碱底漆、 ...','0','/Upload/news/jiemei.jpg','','','0','0','','','','','0','2015-10-22 09:47:33',NULL,'1','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('161','22',NULL,'1','油漆非常流行的一种新型轻体地面装饰材料','','摘要:就是以聚氯乙烯及其共聚<font color=\"#CC0000\">树脂</font>为主要原料,加入填料、增塑剂、稳定剂、着色剂等辅料,在片状连续基材上,经涂敷工艺或经压延、挤出或挤压工艺生产而成。...<font color=\"#CC0000\">氟碳</font>漆它早已大量的使用在人们的日常生活中,比如餐具、医用的输液管袋等,其环保性是无需担忧的。其中石塑地板主要成分是天然石粉,...','0','/Upload/news/jumei.jpg','','','0','0','','','','','0','2015-10-22 09:48:37',NULL,'2','','',NULL,NULL,NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('162','24',NULL,'1','车载空气精华露',NULL,'','0','/Upload/product/product4_03_zlr7.png','','','0','0','','','','','0','2015-10-22 09:51:22',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('163','24',NULL,'1','杀蟑胶剂',NULL,'','0','/Upload/product/product4_05_dd9u.png','','','0','0','','','','','0','2015-10-22 09:51:22',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('164','24',NULL,'1','树脂空气精华露',NULL,'','0','/Upload/product/product4_15_k4dy.png','','','0','0','','','','','0','2015-10-22 09:51:22',NULL,'2',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('165','24',NULL,'1','杉树空气精华露',NULL,'','0','/Upload/product/product4_17_4v6y.png','','','0','0','','','','','0','2015-10-22 09:51:22',NULL,'6',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('166','25',NULL,'1','薄荷精华',NULL,'','0','/Upload/product/s1.png','','','0','0','','','','','0','2015-10-22 09:57:56',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('167','25',NULL,'1','牛油香精',NULL,'','0','/Upload/product/s2.png','','','0','0','','','','','0','2015-10-22 09:57:56',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('168','25',NULL,'1','柠檬香精',NULL,'','0','/Upload/product/s3.png','','','0','0','','','','','0','2015-10-22 09:57:56',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('169','25',NULL,'1','食用白糖',NULL,'','0','/Upload/product/s4.png','','','0','0','','','','','0','2015-10-22 09:57:56',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('170','26',NULL,'1','风伤涂剂',NULL,'','0','/Upload/product/y1.png','','','0','0','','','','','0','2015-10-22 09:57:56',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('171','26',NULL,'1','心脑血管',NULL,'','0','/Upload/product/y2.png','','','0','0','','','','','0','2015-10-22 09:57:56',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('172','26',NULL,'1','心率复苏片',NULL,'','0','/Upload/product/y3.png','','','0','0','','','','','0','2015-10-22 09:57:56',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('173','26',NULL,'1','人参大补丸',NULL,'','0','/Upload/product/y4.png','','','0','0','','','','','0','2015-10-22 09:57:56',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('174','28',NULL,'1','熟食防腐剂',NULL,'','0','/Upload/product/f1.jpg','','','0','0','','','','','0','2015-10-22 10:29:20',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('175','28',NULL,'1','熟食防腐',NULL,'','0','/Upload/product/f3.jpg','','','0','0','','','','','0','2015-10-22 10:29:20',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('176','29',NULL,'1','干货防腐',NULL,'','0','/Upload/product/f2.jpg','','','0','0','','','','','0','2015-10-22 10:30:01',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('177','29',NULL,'1','干货防腐剂',NULL,'','0','/Upload/product/f4.jpg','','','0','0','','','','','0','2015-10-22 10:30:01',NULL,'1',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('178','57',NULL,'1','洁身香皂',NULL,'','0','/Upload/product/w1.jpg','','','0','0','','','','','0','2015-10-22 10:32:37',NULL,'1',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('179','57',NULL,'1','洁衣香皂',NULL,'','0','/Upload/product/w2.jpg','','','0','0','','','','','0','2015-10-22 10:32:37',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('180','57',NULL,'1','婴儿香皂',NULL,'','0','/Upload/product/w3.jpg','','','0','0','','','','','0','2015-10-22 10:32:37',NULL,'1',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('181','57',NULL,'1','香斤纸',NULL,'','0','/Upload/product/w4.jpg','','','0','0','','','','','0','2015-10-22 10:32:37',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','1','1','','',NULL,''),
('182','56',NULL,'1','How the acceptance of sealing oil tank mold','','You have your rules, you can smell my perfume, but didn\'t see my sweat, I have my choice, you deny me now, I decided to my future, you laugh at me for nothing, not to love, I am sorry that you\'re always waiting for, you can despise our youth, we will prove that this is the era of who, the dream is doomed lonely journey, the road without doubt and ridicule, but so what, even black and blue also want to live in beautiful!','0','/Upload/product/product4_05_dd9u.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'31','','7',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('183','56',NULL,'1','Company propaganda film','','','0','/Upload/product/f2.jpg','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'4','','9',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('184','56',NULL,'1','Test video for fire proofing coatings','','','0','/Upload/product/product4_03_zlr7.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'21','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('185','41',NULL,'1','As the largest PVDF vendor sanaifu','','Abstract: social business January 28 hearing on January 24, the reporter from the Shanghai 3F new materials Co., Ltd was informed that the end of 2010, the company has become the largest PVDF (poly vinylidene fluoride resin) production and sales business. It is understood that the PVDF is the production of fluoride in the chemical industry, only after PTFE of fluoride containing products, mainly used in the petrochemical, electronic and electrical and fluorocarbon coatings three major areas. In recent years,...','0','','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('186','41',NULL,'1','Construction process of metal structure coating of curtain wall','','Abstract: fluorocarbon paint by virtue of the excellent weatherability, durability, resistance to corrosion, heat resistance, high temperature resistance and other excellent properties, as the metal structure surface protection and decoration materials, in the curtain wall construction get extensive use. Composed of epoxy resin, zinc powder and polyamide resin A and B two-component coating, good construction performance, with excellent anti corrosion and wear resistance. No oil stain, no dust on the surface of the coating,...','0','','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('187','41',NULL,'1','A variety of toxic chemicals found in pregnant women in the United States','','Abstract:... In 99 to 100% in pregnant women with polychlorinated biphenyls (PCBs), organochlorine pesticides containing, perfluorocarbons (PFCs), phenol, polybrominated diphenyl ethers (PBDEs), adjacent benzene two formic acid salt and polycyclic aromatic hydrocarbons (PAHs) (PAHs) and perchlorate, and so on. Two. A can make plastic products more solid, clean, containing two phenolic A epoxy resin is usually used in the food and beverage metal cans, the detection of 96% pregnant women were carried...','0','','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('188','41',NULL,'1','Three: the details of achievements in quality of Huadu Sanjin fluorocarbon paint wall','','Abstract: unique in the construction of exterior wall paint, fluorocarbon paint, the use of long life and long-term protection for 15 years, with excellent colour retention, excellent weather resistance, abrasion resistance, anti bump characteristics. ... now the general exterior is more latex paint, the exterior wall paint color fastness is not high, coating of organic resin content is too small, film-forming agent chooses improper,...','0','','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('189','41',NULL,'1','Research development and future trend of marine corrosion protection coatings in China','','Abstract: the fluorocarbon resin is widely concerned in recent years. The new material, it has excellent weather resistance, resistance to contamination, chemical resistance, solvent resistance and is excellent material for super weatherability of architectural coatings and anticorrosive coatings. In the marine climate the extremely harsh corrosive environment, fluorocarbon resin and fluorinated polyurethane modified material as the base material of paint is an excellent choice, except for hull paint,... -<br >\nHuicong net surface treatment: the surface of the earth 4 / 5 is covered with oceans, marine economy, marine industry development of human society plays a very important role. Our country from the south to Beihai long coastline of more than 18000 km, and the temperature difference of 50 degrees, many sea creatures. Marine environment is a very severe corrosion environment, the ship is in such a marine environment, corrosion is very serious, and the paint has been its most important means of anti-corrosion. Marine anti-corrosion and anti fouling coatings are the basis of the marine coatings. According to the use of various facilities and requirements of different, and derived a variety of products, such as marine coatings, marine engineering facilities, such as heavy anti-corrosion coatings. The marine coatings fork points for anticorrosion and antifouling paint, ship hull paint, paint on the deck, cabin paint and damping and noise reduction and other special coating. Due to the special nature of the cabin, people pay special attention to the problem of its toxicity, except to pay attention to the corrosion resistance of the coating. Because the corrosion resistance of the coating affects the service time and the service performance of the ship, the toxicity of the coating is related to the health and safety of the crew. China paint is divided into a variety of different areas, respectively, in different areas. 1 heavy-duty anti-corrosion coating is a coating with a longer period of protection in harsh environment than conventional coatings, which has thick film, high solid and double composition. Heavy anti-corrosion is a system engineering, involving the use of environmental assessment, material selection, design, construction quality control and other aspects, and according to the use of the environment and maintenance of ease, the use of different objects have different useful life requirements, for marine coatings, the requirements of 5 to 10 years of protection. 1.1 heavy-duty anticorrosive paint primer usually consists of primer, intermediate coat and top coat. Because the life of ordinary Mianqi far less antirust paint, so performance of the primer is especially important, inorganic zinc rich coating is recognized heavy anticorrosive coatings universal primer. At present, the problem of heavy corrosion protection coatings system is lack of effective data support, and there is no effective method to speed up the test. Two glass flake coatings usually exist in the coating of 1.2 major categories of micro pores: 10-7cm ~ 10-5 porosity of the molecules generated from the 10-2 ~ 10-4cm pore. Solvent evaporation is the main channel of the corrosion products such as water vapor and salt spray. In this aspect, the scale paint has a good blocking effect, which is an important choice for heavy anti-corrosion coatings. Paint flake materials are mainly flaky mica, mica iron oxide, graphite, zinc, stainless steel and glass flake. Due to the low price, such as flake mica, mica iron oxide, graphite, etc., the price of glass flake is more expensive, and the glass flake is more expensive, but only in the construction of the bridge. With the requirements of the more permanent ship coatings, the heavy anti-corrosion coatings for glass flake type will be widely used. 1.3 super weatherability fluorocarbon coatings resin is widely concerned in recent years. The new material, it has excellent weather resistance, resistance to contamination, chemical resistance, solvent resistance and is excellent material for super weatherability of architectural coatings and anticorrosive coatings. In the marine climate the extremely harsh corrosive environment, fluorocarbon resin and fluorinated polyurethane modified material as the base material of paint is an excellent choice, except for hull paint, for strong corrosive medium cabin paint contact. Also valid 3 ~ 5A aliphatic polyurethane, 5 to 8A silicone change paint with super weatherability paint has a certain market. In the process, the domestic resin paint, recoating and interlayer adhesion performance is narrowing the gap with foreign products.','0','','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('190','42',NULL,'1','A new type of light body ground decoration material, which is very popular.','','Abstract: is with polyvinyl chloride and its copolymerization resin as the main raw material, adding filler, increasing plastic agent, stabilizer, coloring agent and other accessories, in continuous sheet substrate and the coating process or by rolling, extrusion or extrusion process to produce a. It has already been used in people\'s daily life, such as tableware, medical infusion tube bags, etc., the environmental protection is no need to worry about. The main ingredient is a natural stone plastic flooring powder,...','0','/Upload/news/jumei.jpg','','','0','0','','','','','-1','0000-00-00 00:00:00',NULL,'2','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('191','42',NULL,'1','November 2010 through the China environmental labeling certification list of enterprises','','Abstract: Guangzhou limeng resin Co., Ltd. adhesive in Guangdong Province 2010-11-10 company 05503P1008069R 2m Jinli card, PU glue: ad -85M, Alzheimer\'s disease (AD)... E800 waterborne fluorocarbon paint, S100, s 100C water concrete protective agent, t302, t306 wall cover varnish, E100, E200 exterior alkali resisting primer, T200 special alkali resisting primer,...','0','/Upload/news/jiemei.jpg','','','0','0','','','','','-1','0000-00-00 00:00:00',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('192','42',NULL,'1','New Year gift to create the perfect environmental protection primer Home Furnishing','','Abstract: epoxy resin solution, composition of the special curing agent for in concrete, wood, terrazzo, steel and other substrate surface sealing primer. Large-scale comprehensive chemical enterprise of the civil and industrial coatings such as fluorocarbon paint, plastic paint, etc.. Taylor paint carefully studies the design product formula and production process, using the world\'s best raw materials as the main raw material,...','0','','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('193','42',NULL,'1','Standard comparison of similar products at home and abroad and samples','','Abstract: such as rosin modified phenolic resin for resin 50% of the total or 50 http://www.youqiyouqi.com%, is included in the phenolic resin paint, less than 50% is included in the natural resin paint. When necessary, we can also choose two kinds of film material, product serial number used to distinguish the same type of different varieties, said oil in the proportion of resin, amino resin in the proportion of total resin. Has mass production of paint varieties,...','0','','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('194','42',NULL,'1','The \"12th Five Year\" period or the quality of resin coatings','','Abstract: resin is not only widely used in the plastics industry, but also an important raw material in the coating formulation. As one of the main film forming materials, epoxy resin has accounted for 36% of the total, which is the fastest growing field in the field of application of epoxy resin. In addition to the above several major synthetic resin, fluorocarbon coatings with its excellent weather resistance and high stain resistance in recent years has been applied. ...','0','','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0','','',NULL,NULL,NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('195','44',NULL,'1','Cedar air essence',NULL,'','0','/Upload/product/product4_17_4v6y.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'6',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('196','44',NULL,'1','Resin air essence',NULL,'','0','/Upload/product/product4_15_k4dy.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'2',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('197','44',NULL,'1','Cockroach glue',NULL,'','0','/Upload/product/product4_05_dd9u.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('198','44',NULL,'1','Car air essence',NULL,'','0','/Upload/product/product4_03_zlr7.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('199','45',NULL,'1','Edible sugar',NULL,'','0','/Upload/product/s4.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('200','45',NULL,'1','Lemon essence',NULL,'','0','/Upload/product/s3.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('201','45',NULL,'1','Butter flavor',NULL,'','0','/Upload/product/s2.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('202','45',NULL,'1','Mint essence',NULL,'','0','/Upload/product/s1.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('203','46',NULL,'1','Ginseng tonic pill',NULL,'','0','/Upload/product/y4.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('204','46',NULL,'1','Heart rate recovery tablets',NULL,'','0','/Upload/product/y3.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('205','46',NULL,'1','Cardio cerebral vessel',NULL,'','0','/Upload/product/y2.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('206','46',NULL,'1','The wind hurt paint',NULL,'','0','/Upload/product/y1.png','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('207','48',NULL,'1','Cooked food preservative',NULL,'','0','/Upload/product/f3.jpg','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('208','49',NULL,'1','Dry cargo preservative',NULL,'','0','/Upload/product/f4.jpg','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'1',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('209','49',NULL,'1','Dry cargo anticorrosion',NULL,'','0','/Upload/product/f2.jpg','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('210','58',NULL,'1','Xiang Jin paper',NULL,'','0','/Upload/product/w4.jpg','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('211','58',NULL,'1','Baby soap',NULL,'','0','/Upload/product/w3.jpg','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('212','58',NULL,'1','Toilet soap',NULL,'','0','/Upload/product/w2.jpg','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,''),
('213','58',NULL,'1','Cleaning soap',NULL,'','0','/Upload/product/w1.jpg','','','0','0','','','','','0','0000-00-00 00:00:00',NULL,'0',NULL,'','','',NULL,NULL,NULL,'1','1','2','1','','',NULL,'');

INSERT INTO `youdian_job` VALUES
('1','销售经理','大专以上','男女不限','20-25岁','面议','不限','10','北京','长期有效','<div class=\"cc_l\">\r\n	<strong>职位说明：</strong></div>\r\n<div class=\"cc_m\">\r\n	开拓市场，完成公司分配的销售任务；市场调研，挖掘客户潜在需求。</div>\r\n<div class=\"cc_m\">\r\n	&nbsp;</div>\r\n<div class=\"cc_l\">\r\n	<strong>职位要求：</strong></div>\r\n<div class=\"cc_m\" style=\"height: 100%\">\r\n	1、普通话标准，性格开朗，善于与人沟通，具有一定的亲和力；<br />\r\n	2、有一定的客户资源优先；<br />\r\n	3、具有一定的市场开拓能力，挖掘客户潜在需求能力；<br />\r\n	4、具有良好的客户服务意识，高度的责任感。</div>\r\n','1','2012-08-23 17:18:10','1','1'),
('2','平面设计师','大专以上','女','20-30','3000-5000/月','不限','5','北京','长期有效','<div class=\"cc_l\">\r\n	<strong>职位说明：</strong></div>\r\n<div class=\"cc_m\">\r\n	从事我司软件产品相关美术设计，包括企业Logo、Flash动画设计、图标设计、网页美工等</div>\r\n<div class=\"cc_m\">\r\n	&nbsp;</div>\r\n<div class=\"cc_l\">\r\n	<strong>职位要求：</strong></div>\r\n<div class=\"cc_m\" style=\"height: 100%\">\r\n	1、美术、平面设计相关专业，大专以上学历；<br />\r\n	2、有扎实的美术功底、良好的创意思维和理解能力，能及时把握客户需求；<br />\r\n	3、熟练使用设计相关工具，如Photoshop、Illustrator、Dreamweaver、Flash等；<br />\r\n	4、了解div+css+js网页布局设计；<br />\r\n	5、善于与人沟通，良好的团队合作精神和高度的责任感，能够承受压力，有创新精神，保证工作质量；</div>\r\n<p>\r\n	&nbsp;</p>\r\n','0','2012-11-14 14:24:54','1','1'),
('3','前台接待','大专','女','20-25','面议','不限','2','北京','长期有效','<div class=\"cc_l\">\r\n	职位要求：</div>\r\n<div class=\"cc_m\" style=\"height: 100%\">\r\n	1、性格开朗，待人热情，身高1.60米以上，形象好，气质佳；<br />\r\n	2、普通话流利，具有良好的语言表达能力和沟通应变能力；<br />\r\n	3、熟练使用电脑、传真机及各种办公软件word，excel；<br />\r\n	4、工作积极主动，认真严谨，具备良好的团队合作精神；<br />\r\n	5、具有良好的思想道德素质，责任心强，较强的服务意识。</div>\r\n','0','2012-11-15 15:11:32','1','1'),
('4','Sales Manager','University Degree','Unlimited','20-25','Negotiable','Unlimited','10','Beijing','Unlimited','<p>\r\n	<strong>Requirements</strong>:</p>\r\n<p>\r\n	1, good putonghua, cheerful, affinity, good at communicating;<br />\r\n	2, having a customer resources is preferred;<br />\r\n	3, having a ability of market development and mining customer potential demand;<br />\r\n	4, good customer service consciousness, high sense of responsibility.</p>\r\n','0','2012-11-15 15:11:54','1','2'),
('5','Receptionist','University Degree','Female','20-25','Negotiable','Unlimited','2','Beijing','Unlimited','<p>\r\n	<strong>Requirements</strong>:</p>\r\n<p>\r\n	1, cheerful, warm, height 1.60 meters of above, good face, good temperament;<br />\r\n	2, good putonghua, good language expression ability and communication ability;<br />\r\n	3, skilled use of computer, fax and all kinds of office software,eg. word, excel;<br />\r\n	4, work actively, serious, and good team cooperation spirit;<br />\r\n	5, good ideological and moral quality, strong sense of responsibility, strong sense of service.</p>\r\n','0','2013-03-27 16:26:42','1','2'),
('6','Graphic Designers','University Degree','Female','20-30','3000-5000','Unlimited','5','Beijing','Unlimited','<p>\r\n	<strong>Requirements</strong>:</p>\r\n<p>\r\n	1, related to arts, graphic design specialty, college degree or above;<br />\r\n	2, good art foundation, good understanding of the creative thinking and ability, understanding customer requirement;<br />\r\n	3, skilled use of design tools, such as Photoshop, Illustrator, Dreamweaver, Flash etc.;<br />\r\n	4, understanding of div+css+js webpage layout design;<br />\r\n	5, good communication skills, team cooperation spirit and high sense of responsibility, bearing pressure,innovation spirit, guarantee the quality of work;</p>\r\n','0','2013-03-27 16:26:42','1','2');

INSERT INTO `youdian_label` VALUES
('1','热门','30','0','1','1'),
('2','头条','30','0','1','1'),
('3','推荐','30','0','1','1'),
('4','热门','31','0','1','1'),
('5','头条','31','0','1','1'),
('6','推荐','31','0','1','1'),
('7','热门','34','0','1','1'),
('8','头条','34','0','1','1'),
('9','推荐','34','0','1','1'),
('10','热门','35','0','1','1'),
('11','头条','35','0','1','1'),
('12','推荐','35','0','1','1'),
('13','热门','36','0','1','1'),
('14','头条','36','0','1','1'),
('15','推荐','36','0','1','1'),
('16','保留使用','37','0','1','1'),
('17','保留使用','37','0','1','1'),
('18','保留使用','37','0','1','1'),
('19','保留使用','38','0','1','1'),
('20','保留使用','38','0','1','1'),
('21','保留使用','38','0','1','1'),
('22','保留使用','39','0','1','1'),
('23','保留使用','39','0','1','1'),
('24','保留使用','39','0','1','1');

INSERT INTO `youdian_language` VALUES
('1','中文','cn',NULL,'0','1'),
('2','英语','en',NULL,'1','1');

INSERT INTO `youdian_link` VALUES
('1','1','好搜','1','http://www.haosou.com','','0','','1','1'),
('4','1','搜狗搜索','2','http://www.sogou.com','/Upload/link/sogou.png','2','','1','1'),
('9','1','搜狐','1','http://www.sohu.com','','20','','1','1'),
('10','1','百度','1','http://www.baidu.com','','0','','1','1'),
('11','1','百度搜索','2','http://www.baidu.com','/Upload/link/baidu.gif','1','','1','1'),
('12','2','baidu','1','http://www.baidu.com','','0','','1','2'),
('13','2','google','1','http://www.google.com','','0','','1','2'),
('14','2','yahoo','1','http://www.yahoo.com','','0','','1','2'),
('15','2','sohu','1','http://www.sohu.com','','0','','1','2'),
('16','2','sina','1','http://www.sina.com.cn','','0','','1','2'),
('17','2','sogou','1','http://www.sogou.com','','0','','1','2'),
('18','2','tencent','1','http://www.qq.com','','0','','1','2'),
('19','1','新浪','1','http://www.sina.com.cn','','0','','1','1'),
('20','1','搜狗','1','http://www.sogou.com/','','0','','1','1'),
('21','1','中国新闻网','1','http://www.chinanews.com/','','0','','1','1'),
('22','1','腾讯新闻','1','http://news.qq.com/','','0','','1','1'),
('23','1','中国政府网','1','http://www.gov.cn/','','0','','1','1'),
('24','1','中国日报','1','http://cn.chinadaily.com.cn/','','0','','1','1'),
('25','1','中国网','1','http://www.china.com.cn/','','0','','1','1'),
('26','1','新浪网','2','http://www.sina.com.cn','/Upload/link/sina.png','3','','1','1'),
('27','1','雅虎','2','https://www.yahoo.com/','/Upload/link/yahoo.png','5','','1','1'),
('28','1','QQ','2','http://www.qq.com','/Upload/link/qq.png','4','','1','1'),
('29','1','TOM','2','http://www.tom.com','/Upload/link/tom.png','6','','1','1'),
('30','1','网易','2','http://www.netease.com','/Upload/link/163.png','7','','1','1'),
('31','1','sohu','2','http://www.sohu.com','/Upload/link/sohu.png','8','','1','1'),
('32','2','baidu.com','2','http://www.baidu.com','/Upload/link/baidu.gif','0','','1','2'),
('33','2','sina.com.cn','2','http://www.sina.com.cn','/Upload/link/sina.png','0','','1','2'),
('34','2','sogou.com','2','http://www.sogou.com','/Upload/link/sogou.png','0','','1','2'),
('35','2','QQ','2','http://www.qq.com','/Upload/link/qq.png','0','','1','2'),
('36','2','163.com','2','http://www.163.com','/Upload/link/tom.png','0','','1','2'),
('37','2','netease.com','2','http://www.netease.com','/Upload/link/163.png','0','','1','2'),
('38','2','yahoo.com','2','http://www.yahoo.com','/Upload/link/yahoo.png','0','','1','2'),
('39','2','sohu.com','2','http://www.sohu.com','/Upload/link/sohu.png','0','','1','2'),
('40','2','china news','1','http://www.china.com.cn/','','0','','1','2');

INSERT INTO `youdian_link_class` VALUES
('1','默认分类','0','1'),
('2','default','0','2');

INSERT INTO `youdian_mail_class` VALUES
('1','默认分类','0','','1','1'),
('2','Default','0','','1','2');

INSERT INTO `youdian_member` VALUES
('1','1','admin','0','','ed9f2df6c3b16155f6981c23a99afc9e','1989-09-22','','410000','xx@qq.com','400-699-1720','','','网站在哪个公司做的','','2013-06-27 18:37:04','','2012-08-23 20:41:34','1','0','1','','','','','',NULL,NULL,NULL,NULL,NULL,NULL,'0');

INSERT INTO `youdian_member_group` VALUES
('1','注册会员','1','9,10,12,11','15,16,17','63,65,67,79,89','15,17,18,19,55,20,21,22',NULL,'1'),
('2','微信游客','1','9,10,12,11','15,16,17','63,65,67,79,89','33,15,17,18,19,55,20,21,22,23,24,25,26,27,28,29',NULL,'1');

INSERT INTO `youdian_menu` VALUES
('5','1','数据库设置','Config/db','0','30',NULL,'1'),
('7','5','添加频道','Channel/add','0','1',NULL,'0'),
('8','5','频道管理','Channel/index','0','2',NULL,'1'),
('9','1','基本设置','Config/basic','0','1',NULL,'1'),
('10','9','留言设置','Config/guestbook','0','2',NULL,'0'),
('14','9','评论设置','Config/comment','0','6',NULL,'0'),
('16','7','在线客服设置','Config/online','0','3',NULL,'0'),
('17','19','搜索引擎优化设置','Config/seo','0','3',NULL,'1'),
('18','1','联系方式','Config/contact','0','2',NULL,'1'),
('19','1','文件上传设置','Config/upload','0','7',NULL,'1'),
('20','12','会员功能设置','Config/reg','0','5',NULL,'1'),
('24','2','邮件订阅分类管理','Mail/classindex','0','6',NULL,'1'),
('25','2','邮件群发管理','Mail/sendindex','0','0',NULL,'1'),
('26','2','订阅邮箱管理','Mail/index','0','5',NULL,'1'),
('27','2','网站安全提示','Public/welcome#c2','0','2',NULL,'0'),
('28','2','组件支持情况','Public/welcome#c4','0','4',NULL,'0'),
('32','4','添加专题','Special/add','0','1',NULL,'0'),
('33','5','专题管理','Special/index','0','2',NULL,'1'),
('34','7','添加在线客服','Support/add','0','1',NULL,'0'),
('35','7','在线客服管理','Support/index','0','2',NULL,'1'),
('37','6','添加幻灯片','Banner/add','0','1',NULL,'0'),
('38','11','幻灯片管理','Banner/index','0','2',NULL,'1'),
('39','7','第三方在线客服','Support/third','0','4',NULL,'1'),
('40','8','添加友情链接','Link/add','0','1',NULL,'0'),
('41','8','友情链接管理','Link/index','0','2',NULL,'1'),
('42','8','添加友情链接分类','Link/addclass','0','3',NULL,'0'),
('43','8','友情链接分类管理','Link/classindex','0','4',NULL,'1'),
('44','9','留言管理','Guestbook/index','0','1',NULL,'1'),
('45','9','人才招聘','Job/index','0','2',NULL,'1'),
('46','9','信息评论','Comment/index','0','6',NULL,'1'),
('47','9','发布招聘信息','Job/add','0','0',NULL,'0'),
('48','11','添加广告','Ad/add','0','1',NULL,'0'),
('49','11','广告内容管理','Ad/index','0','10',NULL,'1'),
('50','12','添加会员分组','MemberGroup/add','0','3',NULL,'0'),
('51','12','会员分组管理','MemberGroup/index','0','4',NULL,'1'),
('52','12','会员管理','Member/index','0','1',NULL,'1'),
('53','12','添加会员','Member/add','0','0',NULL,'0'),
('55','13','管理员管理','Admin/index','0','2',NULL,'1'),
('56','13','添加管理员分组','AdminGroup/add','0','3',NULL,'0'),
('57','13','管理员分组管理','AdminGroup/index','0','4',NULL,'1'),
('58','14','模板选择','Template/pick','0','1',NULL,'1'),
('59','14','模板管理','Template/index','0','2',NULL,'1'),
('60','14','样式管理','Template/style','0','3',NULL,'1'),
('61','1','水印设置','Config/water','0','6',NULL,'1'),
('62','3','内容频道',NULL,'3','0',NULL,'1'),
('63','15','我的用户信息','Member/modify','0','1',NULL,'1'),
('65','15','修改我的密码','Public/pwd','0','3',NULL,'1'),
('66','15','用户后台首页','Public/welcome','0','0',NULL,'0'),
('67','16','我的留言','Guestbook/index','0','1',NULL,'1'),
('68','16','我的评论','Comment/index','0','2',NULL,'1'),
('69','17','内容频道',NULL,'3','0',NULL,'1'),
('71','18','添加自定义标签','Tag/add','0','1',NULL,'0'),
('72','18','自定义标签管理','Tag/index','0','2',NULL,'1'),
('73','5','添加属性标记','Label/add','0','3',NULL,'0'),
('74','5','属性标记管理','Label/index','0','4',NULL,'0'),
('75','19','常用搜索引擎登录入口','SEO/searchenginelogin','0','10',NULL,'1'),
('76','19','伪静态设置','Config/core','0','0',NULL,'1'),
('77','9','订单设置','Config/order','0','4',NULL,'0'),
('78','9','订单管理','Order/index','0','3',NULL,'1'),
('79','16','我的订单','Order/index','0','3',NULL,'1'),
('80','18','数据库管理','Db/index','0','3',NULL,'1'),
('81','18','数据库还原','Db/restore','0','4',NULL,'1'),
('82','18','添加频道模型','ChannelModel/add','0','5',NULL,'0'),
('83','18','频道模型管理','ChannelModel/index','0','6',NULL,'1'),
('84','1','站长统计设置','Config/stat','0','15',NULL,'1'),
('85','1','百度分享设置','Config/baidushare','0','16',NULL,'1'),
('86','19','生成网站地图','SEO/sitemap','0','11',NULL,'1'),
('87','19','生成关键词内链','Config/autolink','0','12',NULL,'1'),
('88','10','应聘简历管理','Job/resume','0','3',NULL,'1'),
('89','16','我的应聘','Resume/index','0','3',NULL,'1'),
('90','6','添加幻灯分组','BannerGroup/add','0','3',NULL,'0'),
('91','11','幻灯分组管理','BannerGroup/index','0','4',NULL,'1'),
('92','12','会员模型管理','MemberModel/index','0','2',NULL,'0'),
('93','21','模板选择','WapTemplate/pick','0','1',NULL,'1'),
('94','21','模板管理','WapTemplate/index','0','2',NULL,'1'),
('95','21','样式管理','WapTemplate/style','0','3',NULL,'1'),
('96','18','一键备份全站','Db/backupall','0','7',NULL,'1'),
('97','1','其它设置','Config/other','0','50',NULL,'1'),
('98','1','缩略图设置','Config/thumb','0','17',NULL,'1'),
('99','1','手机网站设置','Config/wap','0','45',NULL,'1'),
('100','1','邮箱设置','Config/email','0','40',NULL,'1'),
('101','1','语言设置','Config/language','0','41',NULL,'1'),
('102','22','微信绑定设置','Wx/messageapi','0','1',NULL,'1'),
('103','22','自定义菜单设置','Wx/menu','0','5',NULL,'1'),
('104','23','关注自动回复','Wx/subscribereply','0','0',NULL,'1'),
('105','23','关键词自动回复','Wx/keywordreply','0','0',NULL,'1'),
('106','23','默认自动回复','Wx/defaultreply','0','10',NULL,'1'),
('107','22','凭证接口设置','Wx/credentialapi','0','3',NULL,'0'),
('108','22','微信公众平台登录','Wx/index','0','0',NULL,'0'),
('109','25','微消息','Wx/message','0','0',NULL,'1'),
('110','22','第三方接口','Wx/api','0','2',NULL,'0'),
('111','25','微活动','Wx/lottery','0','2',NULL,'1'),
('112','22','基本信息设置','Wx/basic','0','2',NULL,'1'),
('113','23','地理位置自动回复','Wx/lbsreply','0','8',NULL,'1'),
('114','25','微查询','Wx/query','0','1',NULL,'1'),
('115','25','微投票','Wx/vote','0','3',NULL,'1'),
('116','25','微会员卡','wx/card','0','4',NULL,'1'),
('117','25','微调查','wx/research','0','5',NULL,'1'),
('118','22','微信功能设置','Wx/config','0','6',NULL,'1'),
('119','14','模板设置','Template/config','0','4',NULL,'1'),
('120','21','模板设置','WapTemplate/config','0','4',NULL,'1'),
('121','18','操作日志管理','Log/index','0','10',NULL,'1'),
('122','18','数据采集','Collect/index','0','15',NULL,'1'),
('123','11','广告位管理','AdGroup/index','0','15',NULL,'1');

INSERT INTO `youdian_menu_group` VALUES
('1','1','系统设置','2','1'),
('2','5','邮件群发','2','1'),
('3','3','信息管理','10','1'),
('4','2','专题管理','2','0'),
('5','3','频道管理','1','1'),
('6','5','幻 灯 片','0','0'),
('7','4','在线客服','1','1'),
('8','5','友情链接','2','1'),
('9','4','其它','4','1'),
('10','4','人才招聘','3','0'),
('11','5','网站广告','1','1'),
('12','6','会员信息','1','1'),
('13','6','管理员信息','1','1'),
('14','7','电脑模板管理','1','1'),
('15','9','基本信息','1','1'),
('16','9','互动管理','1','1'),
('17','10','内容频道','1','1'),
('18','2','系统管理','0','1'),
('19','14','网站优化','0','1'),
('20','5','第三方脚本','1','0'),
('21','7','手机模板管理','2','1'),
('22','15','微信设置','0','1'),
('23','15','自动回复','0','1'),
('24','15','消息管理','0','0'),
('25','15','微信应用','0','1');

INSERT INTO `youdian_menu_operation` VALUES
('1','41','添加','add','Link','Admin','0','10','1'),
('2','41','删除','del','Link','Admin','0','3','1'),
('3','41','修改','modify','Link','Admin','0','11','1'),
('4','41','排序','batchsort','Link','Admin','0','5','1'),
('5','41','查看','index','Link','Admin','0','9','1'),
('6','41','保存添加','saveadd','Link','Admin','0','2','1'),
('7','41','批量删除','batchdel','Link','Admin','0','3','1'),
('8','41','保存修改','savemodify','Link','Admin','0','4','1'),
('9','43','查看分类','classindex','Link','Admin','0','9','1'),
('10','43','添加分类','addclass','Link','Admin','0','10','1'),
('11','43','保存添加分类','saveaddclass','Link','Admin','0','2','1'),
('12','43','删除分类','delclass','Link','Admin','0','3','1'),
('13','43','批量删除分类','batchdelclass','Link','Admin','0','3','1'),
('14','43','分类排序','batchsortclass','Link','Admin','0','5','1'),
('15','43','修改分类','modifyclass','Link','Admin','0','11','1'),
('16','43','保存修改分类','savemodifyclass','Link','Admin','0','4','1'),
('17','49','查看','index','Ad','Admin','0','9','1'),
('18','49','添加','add','Ad','Admin','0','10','1'),
('19','49','保存添加','saveadd','Ad','Admin','0','2','1'),
('20','49','删除','del','Ad','Admin','0','3','1'),
('21','49','批量删除','batchdel','Ad','Admin','0','3','1'),
('22','49','修改','modify','Ad','Admin','0','11','1'),
('23','49','保存修改','savemodify','Ad','Admin','0','4','1'),
('24','55','查看','index','Admin','Admin','0','9','1'),
('25','55','添加','add','Admin','Admin','0','10','1'),
('26','55','保存添加','saveadd','Admin','Admin','0','2','1'),
('27','55','删除','del','Admin','Admin','0','3','1'),
('28','55','批量删除','batchdel','Admin','Admin','0','3','1'),
('29','55','锁定','batchlock','Admin','Admin','0','1','1'),
('30','55','修改密码','batchmodifypwd','Admin','Admin','0','1','1'),
('31','55','修改','modify','Admin','Admin','0','11','1'),
('32','55','保存修改','savemodify','Admin','Admin','0','4','1'),
('33','57','查看','index','AdminGroup','Admin','0','9','1'),
('34','57','添加','add','AdminGroup','Admin','0','10','1'),
('35','57','保存添加','saveadd','AdminGroup','Admin','0','2','1'),
('36','57','删除','del','AdminGroup','Admin','0','3','1'),
('37','57','批量删除','batchdel','AdminGroup','Admin','0','3','1'),
('38','57','修改','modify','AdminGroup','Admin','0','11','1'),
('39','57','保存修改','savemodify','AdminGroup','Admin','0','4','1'),
('40','38','查看','index','Banner','Admin','0','9','1'),
('41','38','添加','add','Banner','Admin','0','10','1'),
('42','38','保存添加','saveadd','Banner','Admin','0','2','1'),
('43','38','排序','batchsort','Banner','Admin','0','5','1'),
('44','38','删除','del','Banner','Admin','0','3','1'),
('45','38','批量删除','batchdel','Banner','Admin','0','3','1'),
('46','38','修改','modify','Banner','Admin','0','11','1'),
('47','38','保存修改','savemodify','Banner','Admin','0','4','1'),
('48','91','查看','index','BannerGroup','Admin','0','9','1'),
('49','91','添加','add','BannerGroup','Admin','0','10','1'),
('50','91','保存添加','saveadd','BannerGroup','Admin','0','2','1'),
('51','91','排序','batchsort','BannerGroup','Admin','0','5','1'),
('52','91','删除','del','BannerGroup','Admin','0','3','1'),
('53','91','批量删除','batchdel','BannerGroup','Admin','0','3','1'),
('54','91','修改','modify','BannerGroup','Admin','0','11','1'),
('55','91','保存修改','savemodify','BannerGroup','Admin','0','4','1'),
('56','8','查看','index','Channel','Admin','0','9','1'),
('57','8','链接频道查看','link','Channel','Admin','0','9','1'),
('58','8','单页频道查看','single','Channel','Admin','0','9','1'),
('59','8','添加','add','Channel','Admin','0','10','1'),
('60','8','保存添加','saveadd','Channel','Admin','0','2','1'),
('61','8','批量添加','batchadd','Channel','Admin','0','10','1'),
('62','8','保存批量添加','savebatchadd','Channel','Admin','0','2','1'),
('63','8','保存所有','saveall','Channel','Admin','0','4','1'),
('64','8','删除','del','Channel','Admin','0','3','1'),
('65','8','删除频道缓存','clearCache','Channel','Admin','0','7','1'),
('66','8','修改','modify','Channel','Admin','0','11','1'),
('67','8','保存修改','savemodify','Channel','Admin','0','4','1'),
('68','8','查看属性标记','index','Label','Admin','0','9','1'),
('69','8','添加属性标记','add','Label','Admin','0','10','1'),
('70','8','保存添加属性标记','saveadd','Label','Admin','0','2','1'),
('71','8','删除属性标记','del','Label','Admin','0','3','1'),
('72','8','批量删除属性标记','batchdel','Label','Admin','0','3','1'),
('73','8','属性标记排序','batchsort','Label','Admin','0','5','1'),
('74','8','修改属性标记','modify','Label','Admin','0','11','1'),
('75','8','保存修改属性标记','savemodify','Label','Admin','0','4','1'),
('76','83','添加','add','ChannelModel','Admin','0','10','1'),
('77','83','排序','batchsort','ChannelModel','Admin','0','5','1'),
('78','83','字段排序','batchsortfield','ChannelModel','Admin','0','5','1'),
('79','83','清除缓存','clearcache','ChannelModel','Admin','0','7','1'),
('80','83','删除','del','ChannelModel','Admin','0','3','1'),
('81','83','查看','index','ChannelModel','Admin','0','9','1'),
('82','83','修改','modify','ChannelModel','Admin','0','11','1'),
('83','83','修改字段','modifyfield','ChannelModel','Admin','0','11','1'),
('84','83','保存添加','saveadd','ChannelModel','Admin','0','2','1'),
('85','83','保存修改字段','savemodifyfield','ChannelModel','Admin','0','4','1'),
('86','83','查看字段','viewfield','ChannelModel','Admin','0','9','1'),
('87','83','保存修改','savemodify','ChannelModel','Admin','0','4','1'),
('88','122','添加','add','Collect','Admin','0','10','1'),
('89','122','采集内容','collectcontent','Collect','Admin','0','1','1'),
('90','122','采集列表地址','collectlist','Collect','Admin','0','1','1'),
('91','122','删除','del','Collect','Admin','0','3','1'),
('92','122','查看','index','Collect','Admin','0','9','1'),
('93','122','修改','modify','Collect','Admin','0','11','1'),
('94','122','保存添加','saveadd','Collect','Admin','0','2','1'),
('95','122','保存修改','savemodify','Collect','Admin','0','4','1'),
('96','122','开始采集数据','start','Collect','Admin','0','1','1'),
('97','122','测试采集字段数据','testfield','Collect','Admin','0','1','1'),
('98','46','审核','batchcheck','Comment','Admin','0','1','1'),
('99','46','批量删除','batchdel','Comment','Admin','0','3','1'),
('100','46','删除','del','Comment','Admin','0','3','1'),
('101','46','查看','index','Comment','Admin','0','9','1'),
('102','46','保存修改','savecomment','Config','Admin','0','4','1'),
('103','46','查看','comment','Config','Admin','0','9','1'),
('104','80','查看','index','Db','Admin','0','9','1'),
('105','80','备份','backup','Db','Admin','0','1','1'),
('106','80','分析','analyze','Db','Admin','0','1','1'),
('107','80','检查','check','Db','Admin','0','1','1'),
('108','80','优化','optimize','Db','Admin','0','1','1'),
('109','80','修复','repair','Db','Admin','0','1','1'),
('110','80','查看字段','columns','Db','Admin','0','9','1'),
('111','81','查看','restore','Db','Admin','0','9','1'),
('112','81','备份','backup','Db','Admin','0','1','1'),
('113','81','删除','delsqlfile','Db','Admin','0','3','1'),
('114','81','批量删除','batchdelsqlfile','Db','Admin','0','3','1'),
('115','81','还原','recover','Db','Admin','0','1','1'),
('116','81','查看SQL内容','viewsqlfile','Db','Admin','0','9','1'),
('117','96','查看','backupall','Db','Admin','0','9','1'),
('118','96','删除备份文件','delzip','Db','Admin','0','3','1'),
('119','96','一键备份全站','dobackupall','Db','Admin','0','1','1'),
('120','96','备份数据库','backupdata','Db','Admin','0','1','1'),
('121','9','查看','basic','Config','Admin','0','9','1'),
('122','9','保存修改','savebasic','Config','Admin','0','4','1'),
('123','18','查看','contact','Config','Admin','0','9','1'),
('124','18','保存修改','savecontact','Config','Admin','0','4','1'),
('125','61','查看','water','Config','Admin','0','9','1'),
('126','61','保存修改','savewater','Config','Admin','0','4','1'),
('127','19','查看','upload','Config','Admin','0','9','1'),
('128','19','保存修改','saveupload','Config','Admin','0','4','1'),
('129','84','查看','stat','Config','Admin','0','9','1'),
('130','84','保存修改','savestat','Config','Admin','0','4','1'),
('131','85','查看','baidushare','Config','Admin','0','9','1'),
('132','85','保存修改','savebaidushare','Config','Admin','0','4','1'),
('133','98','查看','thumb','Config','Admin','0','9','1'),
('134','98','保存修改','savethumb','Config','Admin','0','4','1'),
('135','5','查看','db','Config','Admin','0','9','1'),
('136','5','保存修改','savedb','Config','Admin','0','4','1'),
('137','100','查看','email','Config','Admin','0','9','1'),
('138','100','保存修改','saveemail','Config','Admin','0','4','1'),
('139','101','查看','language','Config','Admin','0','9','1'),
('140','101','保存修改','savelanguage','Config','Admin','0','4','1'),
('141','97','查看','other','Config','Admin','0','9','1'),
('142','97','保存修改','saveother','Config','Admin','0','4','1'),
('143','99','查看','wap','Config','Admin','0','9','1'),
('144','99','保存修改','savewap','Config','Admin','0','4','1'),
('145','44','回复留言','answermessage','Guestbook','Admin','0','2','1'),
('146','44','批量删除','batchdelmessage','Guestbook','Admin','0','3','1'),
('147','44','删除','delmessage','Guestbook','Admin','0','3','1'),
('148','44','审核/取消审核','batchcheckmessage','Guestbook','Admin','0','1','1'),
('149','44','查看','index','Guestbook','Admin','0','9','1'),
('150','44','导出','exportmessage','Guestbook','Admin','0','6','1'),
('151','44','设置','guestbook','Config','Admin','0','11','1'),
('152','44','保存修改','saveguestbook','Config','Admin','0','4','1'),
('153','45','发布招聘信息','add','Job','Admin','0','10','1'),
('154','45','批量删除','batchdel','Job','Admin','0','3','1'),
('155','45','批量删除简历','batchdelresume','Job','Admin','0','3','1'),
('156','45','排序','batchsort','Job','Admin','0','5','1'),
('157','45','删除','del','Job','Admin','0','3','1'),
('158','45','删除简历','delresume','Job','Admin','0','3','1'),
('159','45','查看','index','Job','Admin','0','9','1'),
('160','45','修改','modify','Job','Admin','0','11','1'),
('161','45','应聘简历','resume','Job','Admin','0','1','1'),
('162','45','应聘简历详情','viewresume','Job','Admin','0','1','1'),
('163','45','保存添加','saveadd','Job','Admin','0','2','1'),
('164','45','保存修改','savemodify','Job','Admin','0','4','1'),
('165','121','设置','config','Log','Admin','0','1','1'),
('166','121','删除','del','Log','Admin','0','3','1'),
('167','121','清除所有日志','delall','Log','Admin','0','3','1'),
('168','121','获取地理位置','getlocation','Log','Admin','0','3','1'),
('169','121','查看','index','Log','Admin','0','9','1'),
('170','121','保存设置','saveconfig','Log','Admin','0','4','1'),
('171','25','查看','sendindex','Mail','Admin','0','9','1'),
('172','25','添加','addsend','Mail','Admin','0','10','1'),
('173','25','保存添加','saveaddsend','Mail','Admin','0','2','1'),
('174','25','删除','delsend','Mail','Admin','0','3','1'),
('175','25','批量删除','batchdelsend','Mail','Admin','0','3','1'),
('176','25','修改','modifysend','Mail','Admin','0','11','1'),
('177','25','保存修改','savemodifysend','Mail','Admin','0','4','1'),
('178','26','添加','add','Mail','Admin','0','10','1'),
('179','26','批量删除','batchdel','Mail','Admin','0','3','1'),
('180','26','删除','del','Mail','Admin','0','3','1'),
('181','26','查看','index','Mail','Admin','0','9','1'),
('182','26','修改','modify','Mail','Admin','0','11','1'),
('183','26','保存添加','saveadd','Mail','Admin','0','2','1'),
('184','26','保存修改','savemodify','Mail','Admin','0','4','1'),
('185','24','添加','addclass','Mail','Admin','0','10','1'),
('186','24','批量删除','batchdelclass','Mail','Admin','0','3','1'),
('187','24','排序','batchsortclass','Mail','Admin','0','5','1'),
('188','24','删除','delclass','Mail','Admin','0','3','1'),
('189','24','查看','classindex','Mail','Admin','0','9','1'),
('190','24','修改','modifyclass','Mail','Admin','0','11','1'),
('191','24','导入查看','import','Mail','Admin','0','9','1'),
('192','24','导入','startimport','Mail','Admin','0','6','1'),
('193','24','导出','exportmail','Mail','Admin','0','6','1'),
('194','24','保存添加','saveaddclass','Mail','Admin','0','2','1'),
('195','24','保存修改','savemodifyclass','Mail','Admin','0','4','1'),
('196','52','添加','add','Member','Admin','0','10','1'),
('197','52','审核/取消审核','batchcheck','Member','Admin','0','1','1'),
('198','52','批量删除','batchdel','Member','Admin','0','3','1'),
('199','52','锁定/取消锁定','batchlock','Member','Admin','0','1','1'),
('200','52','修改密码','batchmodifypwd','Member','Admin','0','1','1'),
('201','52','删除','del','Member','Admin','0','3','1'),
('202','52','导出','export','Member','Admin','0','6','1'),
('203','52','查看','index','Member','Admin','0','9','1'),
('204','52','修改','modify','Member','Admin','0','11','1'),
('205','52','保存添加','saveadd','Member','Admin','0','2','1'),
('206','52','保存修改','savemodify','Member','Admin','0','4','1'),
('207','52','设置管理员','setadmin','Member','Admin','0','1','1'),
('208','52','代管','take','Member','Admin','0','1','1'),
('209','51','添加','add','MemberGroup','Admin','0','10','1'),
('210','51','批量删除','batchdel','MemberGroup','Admin','0','3','1'),
('211','51','删除','del','MemberGroup','Admin','0','3','1'),
('212','51','查看','index','MemberGroup','Admin','0','9','1'),
('213','51','修改','modify','MemberGroup','Admin','0','11','1'),
('214','51','保存添加','saveadd','MemberGroup','Admin','0','2','1'),
('215','51','保存修改','savemodify','MemberGroup','Admin','0','4','1'),
('216','20','添加','reg','Config','Admin','0','9','1'),
('217','20','保存修改','savereg','Config','Admin','0','4','1'),
('218','78','订单回复','answerorder','Order','Admin','0','10','1'),
('219','78','批量删除','batchdelorder','Order','Admin','0','3','1'),
('220','78','删除','delorder','Order','Admin','0','3','1'),
('221','78','查看','index','Order','Admin','0','9','1'),
('222','78','导出','export','Order','Admin','0','6','1'),
('223','78','设置','order','Config','Admin','0','11','1'),
('224','78','保存设置','saveorder','Config','Admin','0','4','1'),
('225','17','查看','seo','Config','Admin','0','9','1'),
('226','17','保存设置','saveseo','Config','Admin','0','4','1'),
('227','33','添加','add','Special','Admin','0','10','1'),
('228','33','删除','del','Special','Admin','0','3','1'),
('229','33','查看','index','Special','Admin','0','9','1'),
('230','33','修改','modify','Special','Admin','0','11','1'),
('231','33','保存所有','saveall','Special','Admin','0','2','1'),
('232','33','保存添加','saveadd','Special','Admin','0','2','1'),
('233','33','保存修改','savemodify','Special','Admin','0','4','1'),
('234','35','添加','add','Support','Admin','0','10','1'),
('235','35','批量删除','batchdel','Support','Admin','0','3','1'),
('236','35','排序','batchsort','Support','Admin','0','5','1'),
('237','35','删除','del','Support','Admin','0','3','1'),
('238','35','查看','index','Support','Admin','0','9','1'),
('239','35','修改','modify','Support','Admin','0','11','1'),
('240','35','保存添加','saveadd','Support','Admin','0','2','1'),
('241','35','保存修改','savemodify','Support','Admin','0','4','1'),
('242','35','设置','online','Config','Admin','0','11','1'),
('243','35','保存修改','saveonline','Config','Admin','0','4','1'),
('244','39','查看','third','Support','Admin','0','9','1'),
('245','39','保存添加','addthird','Support','Admin','0','2','1'),
('246','39','保存修改','savethird','Support','Admin','0','4','1'),
('247','72','添加','add','Tag','Admin','0','10','1'),
('248','72','批量删除','batchdel','Tag','Admin','0','3','1'),
('249','72','删除','del','Tag','Admin','0','3','1'),
('250','72','查看','index','Tag','Admin','0','9','1'),
('251','72','修改','modify','Tag','Admin','0','11','1'),
('252','72','保存添加','saveadd','Tag','Admin','0','2','1'),
('253','72','保存修改','savemodify','Tag','Admin','0','4','1'),
('268','58','查看模板切换','pick','Template','Admin','0','9','1'),
('269','58','保存模板切换','savepick','Template','Admin','0','4','1'),
('270','58','备份模板','backup','Template','Admin','0','1','1'),
('271','58','删除模板','del','Template','Admin','0','3','1'),
('272','58','语言包','lang','Template','Admin','0','1','1'),
('273','58','保存语言包','savelang','Template','Admin','0','4','1'),
('274','59','查看模板管理','index','Template','Admin','0','9','1'),
('275','59','修改模板文件','modify','Template','Admin','0','11','1'),
('276','59','保存模板文件修改','savemodify','Template','Admin','0','4','1'),
('324','103','保存所有','savemodifymenu','Wx','Admin','0','4','1'),
('278','59','保存样式修改','savemodifystyle','Template','Admin','0','4','1'),
('279','60','查看样式管理','style','Template','Admin','0','9','1'),
('312','102','微信绑定设置','messageapi','Wx','Admin','0','9','1'),
('313','102','保存微信绑定设置','savemessageapi','Wx','Admin','0','4','1'),
('314','112','基本信息设置','basic','Wx','Admin','0','9','1'),
('315','112','保存基本信息设置','savebasic','Wx','Admin','0','4','1'),
('316','103','同步菜单到微信','updatemenu','Wx','Admin','0','1','1'),
('317','103','清除微信菜单','clearmenu','Wx','Admin','0','1','1'),
('318','103','查看','menu','Wx','Admin','0','9','1'),
('319','103','添加','addmenu','Wx','Admin','0','10','1'),
('320','103','保存添加','saveaddmenu','Wx','Admin','0','2','1'),
('323','103','删除','menu','Wx','Admin','0','3','1'),
('321','103','修改','modifymenu','Wx','Admin','0','11','1'),
('322','103','保存修改','savemodifymenu','Wx','Admin','0','4','1'),
('292','60','修改样式','modifystyle','Template','Admin','0','11','1'),
('293','60','保存样式修改','savemodifystyle','Template','Admin','0','4','1'),
('294','119','模板设置','config','Template','Admin','0','9','1'),
('295','119','保存模板设置','saveconfig','Template','Admin','0','4','1'),
('296','93','查看模板切换','pick','WapTemplate','Admin','0','9','1'),
('297','93','保存模板切换','savepick','WapTemplate','Admin','0','4','1'),
('298','93','备份模板','backup','WapTemplate','Admin','0','1','1'),
('299','93','删除模板','del','WapTemplate','Admin','0','3','1'),
('300','93','语言包','lang','WapTemplate','Admin','0','1','1'),
('301','93','保存语言包','savelang','WapTemplate','Admin','0','4','1'),
('302','94','查看模板管理','index','WapTemplate','Admin','0','9','1'),
('303','94','修改模板文件','modify','WapTemplate','Admin','0','11','1'),
('304','94','保存模板文件修改','savemodify','WapTemplate','Admin','0','4','1'),
('325','118','排序','batchsortmenu','Wx','Admin','0','5','1'),
('306','94','保存样式修改','savemodifystyle','WapTemplate','Admin','0','4','1'),
('307','95','查看样式管理','style','WapTemplate','Admin','0','9','1'),
('308','95','修改样式','modifystyle','WapTemplate','Admin','0','11','1'),
('309','95','保存样式修改','savemodifystyle','WapTemplate','Admin','0','4','1'),
('310','120','模板设置','config','WapTemplate','Admin','0','9','1'),
('311','120','保存模板设置','saveconfig','WapTemplate','Admin','0','4','1'),
('326','118','查看','config','Wx','Admin','0','9','1'),
('327','118','显示/隐藏','savemodifymenu','Wx','Admin','0','1','1'),
('328','104','查看','subscribereply','Wx','Admin','0','9','1'),
('329','104','保存修改','savesubscribereply','Wx','Admin','0','4','1'),
('345','113','查看','lbsreply','Wx','Admin','0','9','1'),
('346','113','保存修改','savelbsreply','Wx','Admin','0','4','1'),
('347','106','查看','defaultreply','Wx','Admin','0','9','1'),
('348','106','保存修改','savedefaultreply','Wx','Admin','0','4','1'),
('349','109','查看','message','Wx','Admin','0','9','1'),
('350','109','删除','delallmessage','Wx','Admin','0','3','1'),
('336','105','查看','keywordreply','Wx','Admin','0','9','1'),
('337','105','删除','delkeywordreply','Wx','Admin','0','3','1'),
('338','105','批量删除','batchdelkeywordreply','Wx','Admin','0','3','1'),
('339','105','排序','batchsortkeywordreply','Wx','Admin','0','5','1'),
('340','105','修改','modifykeywordreply','Wx','Admin','0','11','1'),
('341','105','保存修改','savemodifykeywordreply','Wx','Admin','0','4','1'),
('342','105','使用次数清零','zerokeywordcount','Wx','Admin','0','1','1'),
('343','105','添加','addkeywordreply','Wx','Admin','0','10','1'),
('344','105','保存添加','saveaddkeywordreply','Wx','Admin','0','2','1'),
('351','109','批量删除','batchdelmessage','Wx','Admin','0','3','1'),
('352','109','导出','exportmessage','Wx','Admin','0','6','1'),
('353','114','查看','query','Wx','Admin','0','9','1'),
('354','111','查看','lottery','Wx','Admin','0','9','1'),
('355','111','查看中奖用户','award','Wx','Admin','0','1','1'),
('356','111','确认/取消领奖','checkaward','Wx','Admin','0','1','1'),
('357','111','删除','dellottery','Wx','Admin','0','3','1'),
('358','111','清除抽奖数据','clearlottery','Wx','Admin','0','3','1'),
('359','111','批量删除','batchdellottery','Wx','Admin','0','3','1'),
('360','111','添加','addlottery','Wx','Admin','0','10','1'),
('361','111','保存添加','saveaddlottery','Wx','Admin','0','2','1'),
('362','111','修改','modifylottery','Wx','Admin','0','11','1'),
('363','111','保存修改','savemodifylottery','Wx','Admin','0','4','1'),
('364','111','排序','batchsortlottery','Wx','Admin','0','5','1'),
('365','115','添加','addvote','Wx','Admin','0','10','1'),
('366','115','批量删除','batchdelvote','Wx','Admin','0','3','1'),
('367','115','排序','batchsortvote','Wx','Admin','0','5','1'),
('368','115','清空投票记录','clearvote','Wx','Admin','0','3','1'),
('369','115','删除','delvote','Wx','Admin','0','3','1'),
('370','115','查看','vote','Wx','Admin','0','9','1'),
('371','115','修改','modifyvote','Wx','Admin','0','11','1'),
('372','115','保存添加','saveaddvote','Wx','Admin','0','2','1'),
('373','115','保存修改','savemodifyvote','Wx','Admin','0','4','1'),
('374','117','查看','research','Wx','Admin','0','9','1'),
('375','117','添加','addresearch','Wx','Admin','0','10','1'),
('376','117','保存添加','saveresearchadd','Wx','Admin','0','2','1'),
('377','117','修改','modifyresearch','Wx','Admin','0','11','1'),
('378','117','保存修改','savemodifyresearch','Wx','Admin','0','4','1'),
('379','117','批量删除','batchdelresearch','Wx','Admin','0','3','1'),
('380','117','删除','delresearch','Wx','Admin','0','3','1'),
('381','117','清除调查数据','clearresearchdata','Wx','Admin','0','3','1'),
('382','117','无刷新清除调查数据','clearresearch','Wx','Admin','0','3','1'),
('383','117','查看设置调查问题','question','Wx','Admin','0','11','1'),
('384','117','导出调查结果','exportquestion','Wx','Admin','0','6','1'),
('385','117','添加调查问题','addquestion','Wx','Admin','0','10','1'),
('386','117','保存添加调查问题','savequestionadd','Wx','Admin','0','2','1'),
('387','117','修改调查问题','modifyquestion','Wx','Admin','0','11','1'),
('388','117','保存修改调查问题','savemodifyquestion','Wx','Admin','0','4','1'),
('389','117','批量删除调查问题','batchdelquestion','Wx','Admin','0','3','1'),
('390','117','删除调查问题','delquestion','Wx','Admin','0','3','1'),
('391','117','调查问题排序','sortquestion','Wx','Admin','0','5','1'),
('392','117','查看用户建议','suggest','Wx','Admin','0','11','1'),
('393','117','导出用户建议','exportsuggest','Wx','Admin','0','6','1'),
('394','116','查看会员卡','card','Wx','Admin','0','9','1'),
('395','116','会员卡设置','cardconfig','Wx','Admin','0','11','1'),
('396','116','保存会员卡设置','updatecardconfig','Wx','Admin','0','4','1'),
('397','116','会员卡充值','pay','Wx','Admin','0','1','1'),
('398','116','赠送积分','givescore','Wx','Admin','0','1','1'),
('399','116','批量冻结','batchlock','Wx','Admin','0','1','1'),
('400','116','导出所有会员','export','Wx','Admin','0','6','1'),
('401','116','查看消费记录','consume','Wx','Admin','0','11','1'),
('402','116','消费金额','expense','Wx','Admin','0','1','1'),
('403','116','查看积分记录','score','Wx','Admin','0','11','1'),
('404','116','查看礼品券','gift','Wx','Admin','0','11','1'),
('405','116','兑换礼品券会员','giftmember','Wx','Admin','0','11','1'),
('406','116','添加礼品券','addgift','Wx','Admin','0','10','1'),
('407','116','保存添加礼品券','savegiftadd','Wx','Admin','0','2','1'),
('408','116','修改礼品券','modifygift','Wx','Admin','0','11','1'),
('409','116','保存修改礼品券','savemodifygift','Wx','Admin','0','4','1'),
('410','116','删除礼品券','delgift','Wx','Admin','0','3','1'),
('411','116','礼品券排序','batchsortgift','Wx','Admin','0','5','1'),
('412','116','查看会员通知','notify','Wx','Admin','0','11','1'),
('413','116','发布会员通知','addnotify','Wx','Admin','0','10','1'),
('414','116','保存发布会员通知','savenotifyadd','Wx','Admin','0','2','1'),
('415','116','修改会员通知','modifynotify','Wx','Admin','0','11','1'),
('416','116','保存修改会员通知','savemodifynotify','Wx','Admin','0','4','1'),
('417','116','删除会员通知','delnotify','Wx','Admin','0','3','1'),
('418','116','查看优惠卷','coupon','Wx','Admin','0','11','1'),
('419','116','兑换优惠卷会员','couponmember','Wx','Admin','0','11','1'),
('420','116','添加优惠卷','addcoupon','Wx','Admin','0','10','1'),
('421','116','保存添加优惠卷','savecouponadd','Wx','Admin','0','2','1'),
('422','116','修改优惠卷','modifycoupon','Wx','Admin','0','11','1'),
('423','116','保存修改优惠卷','savemodifycoupon','Wx','Admin','0','4','1'),
('424','116','删除优惠卷','delcoupon','Wx','Admin','0','3','1'),
('425','116','优惠卷排序','batchsortcoupon','Wx','Admin','0','5','1'),
('426','63','查看','modify','Member','Member','0','9','1'),
('427','63','保存修改','savemodify','Member','Member','0','4','1'),
('428','67','批量删除','batchdelmessage','Guestbook','Member','0','3','1'),
('429','67','删除','delmessage','Guestbook','Member','0','3','1'),
('430','67','查看','index','Guestbook','Member','0','9','1'),
('431','79','批量删除','batchdelorder','Order','Member','0','3','1'),
('432','79','删除','delorder','Order','Member','0','3','1'),
('433','79','查看','index','Order','Member','0','9','1'),
('434','89','修改','modify','Resume','Member','0','11','1'),
('435','89','保存修改','savemodify','Resume','Member','0','4','1'),
('436','89','批量删除','batchdelresume','Resume','Member','0','3','1'),
('437','89','删除','delresume','Resume','Member','0','3','1'),
('438','89','查看','index','Resume','Member','0','9','1'),
('439','68','批量删除','batchdel','Comment','Member','0','3','1'),
('440','68','删除','del','Comment','Member','0','3','1'),
('441','68','查看','index','Comment','Member','0','9','1'),
('442','76','查看','core','Config','Admin','0','9','1'),
('443','76','保存修改','savecore','Config','Admin','0','4','1'),
('444','75','查看','searchenginelogin','Seo','Admin','0','9','1'),
('445','86','查看','sitemap','Seo','Admin','0','9','1'),
('446','86','生成网站地图','makesitemap','Seo','Admin','0','1','1'),
('447','86','删除网站地图','delsitemap','Seo','Admin','0','3','1'),
('448','87','查看','autolink','Config','Admin','0','9','1'),
('449','87','保存修改','saveautolink','Config','Admin','0','4','1'),
('451','123','添加','add','AdGroup','Admin','0','10','1'),
('452','123','删除','del','AdGroup','Admin','0','3','1'),
('453','123','查看','index','AdGroup','Admin','0','9','1'),
('454','123','修改','modify','AdGroup','Admin','0','11','1'),
('455','123','保存添加','saveadd','AdGroup','Admin','0','2','1'),
('456','123','保存修改','savemodify','AdGroup','Admin','0','4','1'),
('457','49','排序','sort','Ad','Admin','0','5','1'),
('458','25','群发当前邮件','send','Mail','Admin','0','1','1'),
('459','25','开始邮件群发','startsend','Mail','Admin','0','1','1'),
('460','25','查看邮件群发日志','viewlog','Mail','Admin','0','1','1');

INSERT INTO `youdian_menu_top` VALUES
('1','系统设置','Public/AdminLeft','menu','1','0001','1','1'),
('2','系统管理','Public/AdminLeft','menu','2','0001','0','1'),
('3','内容管理','Public/AdminLeft','menu','3','0001','0','1'),
('4','互动管理','Public/AdminLeft','menu','4','0001','0','1'),
('5','广告管理','Public/AdminLeft','menu','5','0001','0','1'),
('6','会员管理','Public/AdminLeft','menu','6','0001','0','1'),
('7','模板管理','Public/AdminLeft','menu','8','0001','0','1'),
('8','退出系统','Public/Logout','_top','15','0001','0','1'),
('9','基本信息','Public/MemberLeft','menu','1','0000','0','1'),
('10','内容管理','Public/MemberLeft','menu','2','0000','0','1'),
('11','安全退出','Public/Logout','_top','4','0000','0','1'),
('12','修改密码','Public/Pwd','main','3','0000','0','1'),
('13','缓存管理','Public/ClearCache','main','9','0001','0','1'),
('14','网站优化','Public/AdminLeft','menu','7','0001','0','1'),
('15','微信接口','Public/AdminLeft','menu','7','0001','0','1');

INSERT INTO `youdian_resume` VALUES
('1','3','0','肖芳','女','1990-05-16','汉族','2000-3000','群众','大专','13587898345','xiaofang@qq.com','北京市海淀区三一路','2013-05-16 11:13:27','北京','文秘','北京大学','','1');

INSERT INTO `youdian_support` VALUES
('1','业务咨询','1','123456','1','1','1'),
('6','consult','1','888888','1','1','2');

INSERT INTO `youdian_support3` VALUES
('1','','1','1'),
('2','','1','2');

INSERT INTO `youdian_support_type` VALUES
('1','腾讯QQ','1'),
('2','淘宝旺旺','2'),
('3','阿里旺旺','3'),
('4','微软MSN','4'),
('5','Skype','5'),
('6','阿里旺旺国际版','3'),
('7','自定义类型','20');

INSERT INTO `youdian_wx_app` VALUES
('1','迎中秋庆国庆刮刮卡大抽奖','1','刮刮卡','99','1@@@迎中秋庆国庆刮刮卡大抽奖，好运多多，机会多多，小伙伴们，赶快参与吧！@@@@@@2014-10-30 16:51:41@@@2018-10-31 16:51:41@@@你已经玩过了，下次再来！@@@/Public/tpl/wx/images/scratch.jpg@@@@@@活动已经结束@@@亲，活动已经结束，所有奖品已经发放完毕。下次早点哦！请继续关注我们的后续活动，谢谢！@@@联想x60笔记本@@@1@@@1@@@小米3S手机@@@2@@@5@@@64G U盘@@@5@@@10@@@3@@@123@@@1@@@','','1'),
('2','10周年店庆幸运大转抽奖活动','1','大转盘','99','0@@@10周年店庆大抽奖活动，好运多多，奖品多多，小伙伴们，赶快来参与吧！@@@@@@2014-10-30 16:52:46@@@2018-10-31 16:52:46@@@你已经玩过了，下次再来！@@@/Public/tpl/wx/images/wheel.jpg@@@@@@活动已经结束@@@亲，活动已经结束，所有奖品已经发放完毕。下次早点哦！请继续关注我们的后续活动，谢谢！@@@ipad平板电脑@@@1@@@1@@@iphone5手机@@@2@@@5@@@手机充电宝@@@5@@@10@@@3@@@123@@@1@@@','','1'),
('3','你是通过什么途径知道我们的','2','投票','99','0@@@2014-10-30 16:55:00@@@2019-10-30 16:55:00@@@1###搜索引擎$$$2###网络广告$$$3###朋友介绍$$$4###电视报纸$$$5###其它@@@/Upload/1414659467.png@@@1','','1'),
('4','高级会员卡','6','会员卡','99','高级会员卡@@@/Upload/1414659502.png@@@/Public/Images/card/bg17.png@@@/Public/Images/card/cover.jpg@@@微时代会员卡，方便携带收藏，永不挂失@@@#FFFF00@@@#FFFF00@@@@@@@@@1@@@1@@@某某商家@@@长沙友点软件科技有限公司（http://www.youdiansoft.cn）位于长沙市星沙经济开发区，是国内首家研发中英文网站、手机网站、微信网站三站合一的高科技软件企业，拥有独立自主研发的三站合一企业级产品《友点企业网站管理系统》。以公司核心技术为依托，形成了针对不同行业、不同规模、不同应用的系列产品和解决方案。@@@0731-84037726@@@长沙市星沙经济开发区板仓路尚都花园城6栋1单元904@@@@@@@@@123@@@@@@',NULL,'1'),
('5','你最想去哪里旅游?','5','调查','99','/Public/tpl/wx/images/research.png@@@感谢您参与此次调查，本调查目的在于了解产品对消费者购物选择的影响。您对本问卷的所有回答都是以匿名形式进行并且答案得到严格保密，研究结果将是结论性质的报告，不会泄漏您的任何相关信息。每位参与调研的朋友都将获得我们送出的尊贵礼品，同时你还有机会获得大奖。\r\n                                @@@尊敬的客户：\r\n感谢您的耐心参与，您的选择，将对我们起到重要的指导作用，我们在此向您表示诚挚的谢意。\r\n同时，为了回馈您的贡献，我们将从所有参与调研的客户中，随机抽取几位幸运奖得主。您将有机会获得我们为您精心准备的礼品一份，中奖名单将在近期公布，敬请关注。\r\n祝您生活愉快。\r\n                                @@@2014-10-30 17:00:30@@@2018-01-28 17:00:30@@@@@@赶快来参与吧，还有机会中大奖！@@@0',NULL,'1');

INSERT INTO `youdian_wx_apptype` VALUES
('1','微活动','1','1'),
('2','微投票','2','1'),
('3','微工具','3','1'),
('4','地理位置服务','4','1'),
('5','微调查','5','1'),
('6','微会员卡','6','1');

INSERT INTO `youdian_wx_menu` VALUES
('1','0','一级菜单1','1','0','',NULL,NULL,NULL,'1'),
('2','0','一级菜单2','1','2','',NULL,NULL,NULL,'1'),
('3','0','一级菜单3','1','3','',NULL,NULL,NULL,'1'),
('4','2','二级菜单25','1','4','这里填写二级菜单25返回消息！','3',NULL,NULL,'1'),
('5','2','二级菜单23','1','3','这里填写二级菜单23返回消息！','22','',NULL,'1'),
('6','1','二级菜单15','1','2','这里填写二级菜单15返回消息！','2','',NULL,'1'),
('10','2','二级菜单22','1','2','这里填写二级菜单22返回消息！',NULL,NULL,NULL,'1'),
('11','1','二级菜单14','1','1','这里填写二级菜单14返回消息！','','',NULL,'1'),
('15','2','二级菜单21','1','1','这里填写二级菜单21返回消息！',NULL,NULL,NULL,'1'),
('16','3','二级菜单31','1','1','这里填写二级菜单31返回消息！',NULL,NULL,NULL,'1'),
('17','2','二级菜单24','1','3','这里填写二级菜单24返回消息！',NULL,NULL,NULL,'1'),
('21','1','二级菜单11','1','0','这里填写二级菜单11返回消息！',NULL,NULL,NULL,'1'),
('22','1','二级菜单12','1','0','这里填写二级菜单12返回消息！','3',NULL,NULL,'1'),
('23','3','二级菜单32','1','2','这里填写二级菜单32返回消息！','3',NULL,NULL,'1'),
('24','1','二级菜单13','1','0','这里填写二级菜单13返回消息！','','',NULL,'1');

INSERT INTO `youdian_wx_question` VALUES
('1','5','99','你最想去的地方？','1###丽江@@@2###西藏@@@3###海南@@@4###香港@@@5###其他旅游景点','0','1'),
('2','5','99','你的业余爱好？','1###唱歌@@@2###旅游@@@3###逛街@@@4###看书@@@5###其他','0','1');

INSERT INTO `youdian_wx_reply` VALUES
('1','1','subscribe','0','2','0','1','1','',NULL,'1'),
('2','2','default','2','1','0','您好！客服美眉不在，请直接联系我们！\r\nQQ：1234567\r\n电话：010-88888888\r\n手机：13588888888','','',NULL,'1'),
('3','4','lbs','4','5','0','/^附近(d*)([wW]+)$/','/^附近(d*)([wW]+)$/','','附近1000KTV','1'),
('4','3','1,首页','0','2','0','1','1',NULL,NULL,'1');

INSERT INTO `youdian_wx_type` VALUES
('1','微信文本消息','1','1','1'),
('2','微信图文消息','1','2','1'),
('3','微信音乐消息','1','3','1'),
('4','打开频道主页','0','4','1'),
('5','微应用','1','5','1'),
('6','外部链接','0','6','1');