<?php 

/**
 * 名称：公共控制器
 * 作者：荷塘月色
 * 邮箱：kujiw@qq.com
 * 说明：
 */

namespace Admin\Controller;
use Think\Controller;
class CommonController extends Controller {

	protected $systemModule = array('CONFIG','CONFIGCATE','DATACATE','DATADICT','MENU');
	
	// status状态表
	// 1 可审核可修改
	// 2 可修改
	// 3 可审核
	// 4 全部禁止
	
	public function _initialize(){

		// 检查是否登陆
		if (!session('?userid')) {
			$this -> redirect('Admin/Auth/login');
		}
		$this -> namespace = MODULE_NAME.CONTROLLER_NAME;
	}

	// 获取数据
	protected function getData($model = CONTROLLER_NAME,$layer = 'ViewModel',$input){
		$input = isset($input)?$input:I();
		$m = D($input['model']?:$model,$layer);
		if (isset($input['where'])) $m -> where($input['where']);
		$order = getorder();
		if (str_replace(' ', '', $order) != '') $m -> order($order);
		switch ($input['type']) {
			case 'alldata':
				$result = $m -> select();
				break;

			case 'datagrid':
				$result['rows'] = $m -> page(getpage()) -> select()?:array();
				if (isset($input['where'])) {
					$result['total'] = $m -> where($input['where']) -> count();
				}else{
					$result['total'] = $m -> count();
				};
				$result['total'] = is_null($result['total'])?0:$result['total'];
				break;
			
			default:
				$result = $m -> select();
				break;
		}
		return empty($result)?array():$result;
	}

	protected function ebAdd($relation='',$model = CONTROLLER_NAME,$layer = 'RelationModel',$input){
		$input = isset($input)?$input:I();
		$m = D($model,$layer);
		if (false === $m -> create()) { //创建数据
			$this -> error('验证失败：'.$m -> getError(),'',true);
		}
		if (is_array($relation)) {
			$m -> relation($relation);
			foreach ($relation as $create) { //创建关联数据
				if (false === $temp = M($create) -> token(false) -> create($input[$create])) {
					$this -> error(M($create) -> getError(),'',true);
				}
				$m -> $create = $temp;
			}
		}
		if (false !== $num = $m -> add()) {
			$result = D($model,'ViewModel') -> find($num);
			header('Content-Type:text/plain; charset=utf-8');
			echo json_encode(array('info'=>$result,'status'=>1),0);
			return $result;
		}else{
			$this -> error('添加失败：'.$m -> getDbError(),'',true);
		}
	}

	protected function ebSave($relation='',$model = CONTROLLER_NAME,$layer = 'RelationModel',$input){
		$input = isset($input)?$input:I();
		$m = D($model,$layer);
		$oldData = $m -> find($input['id']);
		if (!$oldData) {
			$this -> error('对不起，数据不存在！','',true);
		}
		// 判断是否可以修改
		if (in_array(strtoupper($model), $this -> systemModule) && !in_array($oldData['system'], array(0,1,2))) {
			$this -> error('对不起，禁止修改！','',true);
		}

		if (false === $data = $m -> create()) { //创建数据
			$this -> error('验证失败：'.$m -> getError(),'',true);
		}

		if (is_array($relation)) {//创建关联数据
			foreach ($relation as $create) {
				if (false === $temp = M($create) -> token(false) -> create($input[$create])) {
					$this -> error(M($create) -> getError(),'',true);
				}
				$m -> $create = $temp;
			}
			$m -> relation($relation);
		}
		if (false !== $m -> save()) { //保存数据
			$result = D($model,'ViewModel') -> find($data['id']);
			header('Content-Type:text/plain; charset=utf-8');
			echo json_encode(array('info'=>$result,'status'=>1),0);
			return $result;
		}else{
			$this -> error('修改失败：'.$m -> getDbError(),'',true);
		}
	}

	protected function ebStatus($model = CONTROLLER_NAME,$field = 'status',$input){
		$input = isset($input)?$input:I();
		$ids = $input['ids'];
		$value = is_numeric($input['value'])?$input['value']:0;
		if (empty($ids)) {
			$this -> error('请选择要修改的数据！','',true);
		}
		if (is_array($ids)) {
			$map['id'] = array('in',$ids);
		} elseif (is_numeric($ids)) {
			$map['id'] = array('eq',$ids);
		}
		// 排除系统项
		if (in_array(strtoupper($model), $this -> systemModule)) {
			$map['system'] = array('in',array(0,1,3));
		}
		$m = D($model);
		$num = $m -> where($map) -> setField($field,$value);
		if (false === $num) {
			$this -> error('状态修改失败：'.$m->getDbError(),'',true);
		}elseif(is_numeric($num)){
			if ($num === 0) {
				$this -> error('未改动任何数据！','',true);
			}else{
				if (is_array($ids)) {
					header('Content-Type:text/plain; charset=utf-8');
					echo json_encode(array('info'=>'修改了权限范围内 '.$num.' 条数据的状态！','status'=>1),0);
				}elseif(is_numeric($ids)){
					header('Content-Type:text/plain; charset=utf-8');
					echo json_encode(array('info'=>$m -> find($ids),'status'=>1),0);
				}
			}
		}
	}

	protected function ebDelete($relation='',$model = CONTROLLER_NAME,$layer = 'RelationModel',$input){
		$input = isset($input)?$input:I();
		$m = D($model,$layer);
		if (is_array($relation)) {
			$m -> relation($relation);
		}
		$ids = $input['ids'];
		if (empty($ids)) {
			$this -> error('请选择要删除的数据！','',true);
		}
		if (is_array($ids)) {
			$map['id'] = array('in',$ids);
		} elseif (is_numeric($ids)) {
			$map['id'] = array('eq',$ids);
		}
		// 排除系统项
		if (in_array(strtoupper($model), $this -> systemModule)) {
			$map['system'] = array('eq',0);
		}
		// thinkphp的bug 关联删除 在没有删除主表数据的情况下，会删除关联表的数据
		$tmp = $m -> where($map) -> find();
		if ($tmp) {
			$m -> where($map);
			if (is_array($relation)) {
				$num = $m -> relation($relation) -> delete();
			}else{
				$num = $m -> delete();
			}
		}else{
			$this -> error('没有可删除的数据！',U('index'),true);
		}
		if (false === $num) {
			$this -> error('删除失败：'.$m->getDbError(),U('index'),true);
		}elseif (is_numeric($num)) {
			if ($num === 0) {
				$this -> error('未删除任何可删除的数据！',U('index'),true);
			}else{
				if (is_array($ids)) {
					header('Content-Type:text/plain; charset=utf-8');
					echo json_encode(array('info'=>'删除了可删除的 '.$num.' 条数据!','status'=>1),0);
				}elseif(is_numeric($ids)){
					header('Content-Type:text/plain; charset=utf-8');
					echo json_encode(array('info'=>'删除成功！','status'=>1),0);
				}
			}
		}
	}

	protected function ebSystem($model = CONTROLLER_NAME,$input){
		// 检测是否为系统
		if (!defined('__IS_DEVELOPER__') || !in_array(strtoupper($model), $this -> systemModule)) {
			$this -> error('非法操作！','',true);
		}
		$input = isset($input)?$input:I();
		$ids = $input['ids'];
		$value = is_numeric($input['value'])?$input['value']:0;
		if (empty($ids)) {
			$this -> error('请选择要修改的数据！','',true);
		}
		if (is_array($ids)) {
			$map['id'] = array('in',$ids);
		} elseif (is_numeric($ids)) {
			$map['id'] = array('eq',$ids);
		}
		$m = D($model);
		$num = $m -> where($map) -> setField('system',$value);
		if (false === $num) {
			$this -> error('状态修改失败：'.$m->getDbError(),'',true);
		}elseif (is_array($ids)) {
			header('Content-Type:text/plain; charset=utf-8');
			echo json_encode(array('info'=>'修改了权限范围内 '.$num.' 条数据的状态！','status'=>1),0);
		}elseif(is_numeric($ids)){
			header('Content-Type:text/plain; charset=utf-8');
			echo json_encode(array('info'=>$m -> find($ids),'status'=>1),0);
		}
	}

	public function _empty(){
		if (IS_POST) {
			if (ACTION_NAME == 'system') {
				$this -> ebSystem();
			}else{
				$this -> error('访问不存在的动作！','',true);
			}
		}elseif (IS_GET) {
			die('访问不存在的动作！');
		}
		die;
	}
}