<?php 

/**
 * 名称：模板管理控制器
 * 作者：荷塘月色
 * 邮箱：kujiw@qq.com
 * 说明：
 */

namespace Admin\Controller;
class TemplateController extends CommonController{

	// 所有模板显示
	public function index(){
		if (IS_POST) {
			$this -> ajaxReturn(file_id_dir(I('dir')));
		}elseif(IS_GET) {
			$this -> display();
		}
	}

	// 添加一个该目录下的新模板
	public function add(){
		if (IS_GET) {
			$this -> dir = I('dir');
			$this -> display();
		}
		if (IS_POST) {
			$dir = I('dir');
			$name = I('name');
			$filename = $dir.'/'.$name;
			$content = I('content','','');
			if (file_put_contents($filename, $content)) {
				$this -> success('保存成功',U('index'),true);
			}else{
				$this -> error('保存失败','',true);
			}
		}
	}

	// 更新一个模板
	public function save(){
		if (IS_GET) {
			$filename = I('filename');
			$result['filename'] = $filename;
			$result['content'] = htmlspecialchars(file_get_contents($filename));
			$this -> assign($result);
			$this -> display();
		}elseif (IS_POST) {
			$filename = I('filename');
			$content = I('content','','');
			if (file_put_contents($filename, $content)) {
				$this -> success('保存成功','',true);
			}else{
				$this -> error('保存失败','',true);
			}
		}
	}

	// 删除一个模板
	public function delete(){
		if (IS_GET) {
			// 取得目标文件的详细地址
			$filename = I('filename');
			if (unlink($filename)) {
				$this -> success('删除成功:'.$filename,'',true);
			}else{
				$this -> error('删除失败:'.$filename,'',true);
			}
		}
	}
}