<?php
namespace Admin\RelationModel;
use Think\Model\RelationModel;
class DatacateRelationModel extends RelationModel{
	
	protected $tableName = 'datacate';

	/* 自动验证规则 */
	protected $_validate = array(
		array('id', 'number', '非法提交', self::MUST_VALIDATE, 'regex', self::MODEL_UPDATE),
		array('text', '1,20', '标题字数介于0-20字', self::MUST_VALIDATE, 'length', self::MODEL_BOTH),
		array('field', '1,20', '字段字数介于0-20字', self::VALUE_VALIDATE, 'length', self::MODEL_BOTH),
		// array('field', 'require', '字段不能为空', self::VALUE_VALIDATE, 'regex', self::MODEL_BOTH),
		array('field', 'unique', '字段不能重复', self::VALUE_VALIDATE, 'unique', self::MODEL_BOTH),
		array('instruction', '0,250', '说明不得超过250个字', self::VALUE_VALIDATE , 'length', self::MODEL_BOTH),
		array('sort', 'number', '排序必须为数字', self::VALUE_VALIDATE , 'regex', self::MODEL_BOTH),
		array('status', array('0','1'), '状态错误', self::VALUE_VALIDATE , 'in', self::MODEL_BOTH)
	);

	// 自动完成规则
	protected $_auto = array (
		array('create_time','datetime',1,'function'), 
		array('update_time','datetime',3,'function'), 
		array('system',0,3)
	);

	// 关联模型
	protected $_link = array(
		'datadict'=> array(
			'mapping_type'=> self::HAS_MANY,
			'class_name'=>'Datadict',
			'foreign_key'=>'category_id',
			'mapping_name'=>'datadict',
			'mapping_order'=>'sort desc',
		),
	);
}