<?php
namespace Admin\RelationModel;
use Think\Model\RelationModel;
class MenuRelationModel extends RelationModel{

	protected $tableName = 'menu';

	/* 自动验证规则 */
	protected $_validate = array(
		array('id', 'number', '非法提交', self::MUST_VALIDATE, 'regex', self::MODEL_UPDATE),
		array('pid', 'number', '未指定分组', self::VALUE_VALIDATE, 'regex', self::MODEL_BOTH),
		array('text', '1,20', '标题字数介于1-20字', self::VALUE_VALIDATE, 'length', self::MODEL_BOTH),
		array('sort', 'number', '排序必须为数字', self::VALUE_VALIDATE, 'regex', self::MODEL_BOTH),
		array('status', array('0','1'), '状态错误', self::VALUE_VALIDATE, 'in', self::MODEL_BOTH),
	);

	// 自动完成规则
	protected $_auto = array ( 
		array('create_time','datetime',1,'function'), 
		array('update_time','datetime',3,'function'), 
		array('system',0,1), // 对lock字段在新增的时候赋值0
	);

	// 关联规则
	protected $_link = array(
	);
}