<?php

// 美观的数据结构显示
function p($var){
	echo '<pre>';
	print_r($var);
	echo '</pre>';
}

/**
 * 用户名密码加密
 * 
 */
function crypt_pwd($pwd){
	return md5($pwd.' love ebcms forever!');
}

// 当前时间
function datetime(){
	return date('Y-m-d H:i:s',time());
}

// 获取easyui传来的排序字段
function getorder(){
	$eusort = explode(',', I('sort','id'));
	$euorder = explode(',', I('order','desc'));
	$order = '';
	foreach ($eusort as $key => $value) {
		$order .= $value.' '.$euorder[$key].',';
	}
	return substr($order, 0,strlen($order)-1);
}

function getpage(){
	return I('page','1','intval').','.I('rows','1000','intval');
}

// 扩展字段转json
function ext_to_json($str){
	if (!$str) {
		return;
	}
	$arr = explode("\r\n", $str);
	$res = array();
	foreach ($arr as $key => $value) {
		$tmp = explode(':', $value);
		if (strpos($tmp[1],'|')) {
			$tmp[1] = explode('|', $tmp[1]);
		}
		$res[$tmp[0]] = $tmp[1];
	}
	return json_encode($res);
}

// json转扩展字段
function json_to_ext($json){
	if (!$json) {
		return;
	}
	$arr = json_decode($json,true);
	$str = '';
	foreach ($arr as $key => $value) {
		$str .=$key;
		$str .=':';
		if (is_array($value)) {
			$str .= implode('|', $value);
		} else {
			$str .= $value;
		}
		$str .="\r\n";
	}
	return substr($str, 0,-2);
}

// 附件字段转json
function str_to_json($str){
	if (!$str) {
		return;
	}
	$arr = explode("\r\n", $str);
	$array = array();
	foreach ($arr as $key => $value) {
		$array[] = explode('|', $value);
	}
	return json_encode($array);
}

// json转附件字段
function json_to_str($json){
	if (!$json) {
		return;
	}
	$arr = json_decode($json,true);
	$str = '';
	foreach ($arr as $key => $value) {
		$str .= implode('|', $value);
		$str .= "\r\n";
	}
	return substr($str, 0,-2);
}

// 获取所有子id
function subtreeid($data,$pid=0){
	$res = array();
	foreach ($data as $key => $value) {
		if ($value['pid'] == $pid) {
			$res = array_merge($res, (array)$value['id']);
			$res = array_merge($res, (array)subtreeid($data,$value['id']));
		}
	}
	return $res;
}

// 对数据按照pid归类排序 返回的不是递归数组
function subtree($data,$pid=0){
	$res = array();
	foreach ($data as $key => $value) {
		if ($value['pid'] == $pid) {
			array_push($res, (array)$value);
			$tmp = (array)subtree($data,$value['id']);
			if (count($tmp)) {
				foreach ($tmp as $key => $value) {
					array_push($res, (array)$value);
				}
			}
		}
	}
	return $res;
}

// 生成树
function data2tree($data,$childrenfield='children',$pidfield='pid',$idfield='id'){
	$temp = array();
	foreach ($data as $key => $value) {
		$temp[$value[$idfield]] = $value;
	}
	$topid = array();
	foreach ($data as $value) {
		if (!array_key_exists($value[$pidfield], $temp)) {
			$topid[] = $value[$idfield];
		}
	}
	$result = array();
	foreach ($topid as $key => $pid) {
		$result[$key] = $temp[$pid];
		$result[$key][$childrenfield] = data2subtree($data,$pid,$childrenfield,$pidfield,$idfield);
	}
	return $result;
}

// 数组压制
function data2subtree($arr = array(),$pid = 0,$childrenfield = 'children',$pidfield='pid',$idfield='id'){
	$temp = array();
	foreach ($arr as $key => $value) {
		if ($value[$pidfield] == $pid) {
			unset($arr[$key]);
			$value[$childrenfield] = data2subtree($arr,$value[$idfield],$childrenfield,$pidfield,$idfield);
			$temp[] = $value;
		}
	}
	return $temp;
}

// 读取所有配置文件
function read_config(){
	$cate = M('Configcate') -> where(array('module'=>array('neq',''),'status'=>array('eq',1))) -> order('sort desc') -> getField('id,module',true);
	foreach ($cate as $key => $value) {
		$cate[$key] = explode('|', $value);
	}
	$tmp = M('Config') -> where(array('status'=>array('eq',1))) -> order('update_time desc') -> getField('id,category_id,pid,name,value,type',true);
	foreach ($tmp as $key => $value) {
		$configs[$value['category_id']][] = $value;
	}
	foreach ($cate as $key => $value) {
		foreach ($value as $k => $v) {
			$data[$v] = array_merge((array)$data[$v],(array)config_level_merge(0,$configs[$key]));
		}
	}
	return $data;
}

// 配置文件递归
function config_level_merge($pid = 0,$config){
	$data = array();
	foreach ($config as $key => $value) {
		if ($value['pid'] == $pid) {
			unset($config[$key]);
			$data[$value['name']] = config_level_merge($value['id'],$config);
			if (!$data[$value['name']]) {
				$data[$value['name']] = render_config($value['value'],$value['type']);
			}
		}
	}
	return $data;
}
// 根据类型解析配置文档
function render_config($data,$type){
	switch ($type) {
		case 'string':
			$tmp = $data;
			break;
		case 'image':
			$tmp = $data;
			break;
		case 'mulstring':
			$tmp = $data;
			break;
		case 'bool':
			$tmp = (boolean)$data;
			break;
		case 'number':
			$tmp = (float)$data;
			break;
		case 'item':
			$tmp = explode("\r\n", $data);
			break;
		case 'json':
			$tmp = json_decode(preg_replace("/\/\*[\s\S]+?\*\//", "", htmlspecialchars_decode($data)),true);
			break;
		case 'ini':
			$tmp = parse_ini_string($data);
			break;
		case 'yaml':
			$tmp = yaml_parse($data);
			break;
		case 'xml':
			$tmp = (array)simplexml_load_string($data);
			break;
		
		default:
			# code...
			break;
	}
	return $tmp;
}

// /Uploads/pic/20140908/sad35kasu.jpg
function thumb($file,$width,$height,$type=3){
	if ($width && $height) {
		$file = '.'.$file;
		$thumbfile = dirname($file).'/thumb_'.$width.'_'.$height.'_'.basename($file);
		if (!is_file($thumbfile)) {
			if (!is_file($file)) {
				return 'holder.js/'.$width.'x'.$height.'/text:暂无图片';
			}else{
				$image = new \Think\Image();
				$image->open($file);
				$image->thumb($width, $height,$type)->save($thumbfile);
			}
		}
		return __ROOT__.substr($thumbfile, 1);
	}else{
		return __ROOT__.$file;
	}
}

// 获取目录下文档 返回数组
function file_in_dir($path){
	$tmp = scandir($path);
	$files = array();
	foreach ($tmp as $value) {
		if ($value != '.' && $value != '..') {
			$files[] = $value;
		}
	}
	return $files;
}

// 删除目录
function deldir($dir) {
	//删除当前文件夹下得文件：
	$dh=opendir($dir);
	while ($file=readdir($dh)) {
		if($file!="." && $file!="..") {
			$fullpath=$dir."/".$file;
			if(!is_dir($fullpath)) {
				unlink($fullpath);
			} else {
				deldir($fullpath);
			}
		}
	}

	closedir($dh);
	//删除当前文件夹：
	if(rmdir($dir)) {
		return true;
	} else {
		return false;
	}
}

// 将数组中选中的项做标记
function array_mark($arr = array(),$data='',$eq='id',$additem = '_mark',$mark = 'checked'){
	$pid = array();
	foreach ($arr as $key => $value) {
		$pid[$value['pid']] = 1;
	}
	$arr = is_array($arr)?$arr:false;
	$tmp = array();
	
	foreach ($arr as $v) {
		if (!$pid[$v['id']]) {
			$v[$additem] = in_array($v[$eq], (array)$data) ? $mark : '';
		}
		$tmp[] = $v;
	}
	return $tmp;
}

// 获取数组中标记的项
function array_getmarked($arr = array(),$data='',$eq='id'){

	$arr = is_array($arr)?$arr:redirect('', 2, '不是数组');
	$tmp = array();

	if (is_array($data)) {
		foreach ($arr as $v) {
			if (in_array($v[$eq], $data)) $tmp[] = $v;
		}
	}else{
		foreach ($arr as $v) {
			if ($v[$eq]=$data) $tmp[] = $v;
		}
	}
	return $tmp;
}

// 判断是否为手机号码
function ismobile($mobile){
	if (!preg_match("/1[3458]{1}\d{9}$/",$mobile)) {
		return false;
	}
	return true;
}

// 解析参数
function render($data,$keys=''){
	if (!$data) {
		return;
	}
	$data = explode("\r\n", $data);
	if ($keys) {
		$keys = explode('|', $keys);
		foreach ($data as $key => $value) {
			if (substr($value, 0,2) == '//') {
				continue;
			}
			$value = explode("|", $value);
			foreach ($value as $k => $v) {
				$result[$key][$keys[$k]] = $v;
			}
		}
	}else{
		foreach ($data as $key => $value) {
			if (substr($value, 0,2) == '//') {
				continue;
			}
			$value = explode("|", $value);
			foreach ($value as $k => $v) {
				$result[$key][$k] = $v;
			}
		}
	}
	return $result;
}