<?php
namespace Home\Controller;
use Think\Controller;
class GuestbookController extends CommonController {

	// 首页
	public function index(){
		if (IS_GET) {
			$this -> SEO = array(
				'title' => '留言板',
				'keywords' => '留言板',
				'description' => '留言板',
			);
			$this -> display();
		}elseif (IS_POST) {

			// 验证验证码
			if (C('GUESTBOOK_VERIFY')) {
				$verify = new \Think\Verify();
				if(!$verify->check(I('verify'))){
					$this -> error('验证码错误!');
				}
			}

			$nickname = I('nickname','游客');
			$mobile = I('mobile','');
			$content = I('content','');
			$content_id = I('content_id',0,'intval');
			if (!ismobile($mobile)) {
				$this -> error('手机号码填写错误！');
			}
			$data = array(
				'content_id'	=>	$content_id,
				'nickname'		=>	$nickname,
				'mobile'		=>	$mobile,
				'content'		=>	mb_substr($content, 0,255),
				'update_time'	=>	time(),
				'status'		=>	0,
				);
			$m = M('Guestbook');
			if ($m -> create($data)) {
				if ($m -> add()) {
					$this -> success('留言成功！');
				}else{
					$this -> error('留言失败！');
				}
			}else{
				$this -> error('留言失败！');
			}
		}
	}
}