<?php
namespace Home\Taglib;
use Think\Template\TagLib;
class Qy extends TagLib{

	// 标签定义
	protected $tags =  array(
		'contentcategory'		=>	array('attr'=>'recursion,pid,limit,return','close'=>0),
		'contentlist'			=>	array('attr'=>'recursion,categoryid,limit,return','close'=>0),
		'content'				=>	array('attr'=>'id,to,return','close'=>0),
		'navlist'				=>	array('attr'=>'mark,recursion,pid,limit,return','close'=>0),
		'linklist'				=>	array('attr'=>'limit,return','close'=>0),
		'guestbooklist'			=>	array('attr'=>'contentid,limit,return','close'=>0),
		'slidecontent'			=>	array('attr'=>'mark,id,return','close'=>0),
		'print'					=>	array('attr'=>'name','close'=>0),
		'fn'					=>	array('attr'=>'name,fn,param,return','close'=>0),
		);

	// 
	public function _contentcategory($tag,$content,$module = 'Content') {
		if (empty($tag['return'])) {//return为空 返回空
			return;
		}
		$str = '';
		$str .="<?php ";
		$str .="\$_m = D('{$module}cate','ViewModel');\r\n";
		$str .="\$_m -> order('sort desc');\r\n";
		$str .="\$_where = array();\r\n";
		$str .="\$_where['status'] = array('eq',1);\r\n";
		// 解析 recursion 限制
		if (isset($tag['recursion'])) {
			$str .="\${$tag['return']}_tmp = \$_m -> where(\$_where) -> select();\r\n";
			// pid限制
			if (isset($tag['pid'])) {
				if ('$' == substr($tag['pid'],0,1)) {
					$tag['pid']   = $this->autoBuildVar(substr($tag['pid'], 1));
					$str .="\${$tag['return']} = data2subtree(\${$tag['return']}_tmp,{$tag['pid']});\r\n";
				}else{
					$str .="\${$tag['return']} = data2subtree(\${$tag['return']}_tmp,'{$tag['pid']}');\r\n";
				}
			}else{
				$str .="\${$tag['return']} = data2tree(\${$tag['return']}_tmp);\r\n";
			}
		}else{
			// 解析limit限制属性
			if (isset($tag['limit'])) {
				if ('$' == substr($tag['limit'],0,1)) {
					$tag['limit']   = $this->autoBuildVar(substr($tag['limit'], 1));
					$str .="\$_m -> limit({$tag['limit']});";
				}else{
					$str .="\$_m -> limit('{$tag['limit']}');";
				}
			}
			// pid限制
			if (isset($tag['pid'])) {
				if ('$' == substr($tag['pid'],0,1)) {
					$tag['pid']   = $this->autoBuildVar(substr($tag['pid'], 1));
					$str .="\$_where['pid'] = array('eq',{$tag['pid']});\r\n";
				}else{
					$str .="\$_where['pid'] = array('eq','{$tag['pid']}');\r\n";
				}
			}
			$str .="\$_m -> where(\$_where);\r\n";
			$str .="\${$tag['return']} = \$_m -> select();\r\n";
		}
		$str .="?>";
		return $str;
	}

	// 
	public function _contentlist($tag,$content,$module = 'Content') {
		if (empty($tag['return'])) {//return为空 返回空
			return;
		}
		$str = '';
		$str .="<?php ";
		$str .="\$_m = D('Content','ViewModel');\r\n";
		$str .="\$_m -> order('id desc');\r\n";
		$str .="\$_where = array();\r\n";
		$str .="\$_where['status'] = array('eq',1);\r\n";
		if (isset($tag['categoryid'])) {
			if (isset($tag['recursion'])) {
				$str .="\$_categorys = M('Contentcate') -> where(array('status'=>array('eq',1))) -> getField('id,pid,status');\r\n";
				if ('$' == substr($tag['categoryid'],0,1)) {
					$tag['categoryid'] = $this->autoBuildVar(substr($tag['categoryid'],1));
					$str .="\$_category_ids = subtreeid(\$_categorys,{$tag['categoryid']});\r\n";
					$str .="\$_category_ids[] = {$tag['categoryid']};\r\n";
				}else{
					$str .="\$_category_ids = subtreeid(\$_categorys,'{$tag['categoryid']}');\r\n";
					$str .="\$_category_ids[] = '{$tag['categoryid']}';\r\n";
				}
				$str .="\$_where['category_id'] = array('in',(array)\$_category_ids);\r\n";
			}else{
				if ('$' == substr($tag['categoryid'],0,1)) {
					$tag['categoryid']   = $this->autoBuildVar(substr($tag['categoryid'], 1));
					$str .="\$_where['category_id'] = array('eq',{$tag['categoryid']});\r\n";
				}else{
					$str .="\$_where['category_id'] = array('eq','{$tag['categoryid']}');\r\n";
				}
			}
		}
		$str .="\$_m -> where(\$_where);\r\n";
		// 解析limit限制属性
		if (isset($tag['limit'])) {
			if ('$' == substr($tag['limit'],0,1)) {
				$tag['limit']   = $this->autoBuildVar(substr($tag['limit'], 1));
				$str .="\$_m -> limit({$tag['limit']});";
			}else{
				$str .="\$_m -> limit('{$tag['limit']}');";
			}
		}
		$str .="\${$tag['return']} = \$_m -> select();\r\n";
		$str .="?>";
		return $str;
	}

	// 解析内容标签 module,mark,id,return
	public function _content($tag,$content){
		if (empty($tag['return']) || (empty($tag['id']) && empty($tag['mark']))) {//module或者return为空 返回空
			return;
		}
		$str = '';
		$str .="<?php ";
		$str .="\$_m = D('Content','ViewModel');\r\n";
		$str .="\$_where = array();\r\n";
		$str .="\$_where['status'] = array('eq',1);\r\n";
		$str .="\$_where['Category.status'] = array('eq',1);\r\n";
		// id限制
		if (isset($tag['id'])) {

			$_type = 'eq';
			if (isset($tag['to'])) {
				if ($tag['to'] == 'next') {
					$_type = 'gt';
				}else{
					$_type = 'lt';
					$str .="\$_m -> order('id desc');\r\n";
				}

				if ('$' == substr($tag['id'],0,1)) {
					$_id = $this->autoBuildVar(substr($tag['id'], 1));
					$str .="\$_category_id = M('Content')->where('id = '.{$_id}) -> getField('category_id');\r\n";
				}else{
					$str .="\$_category_id = M('Content')->where('id = {$tag['id']}') -> getField('category_id');\r\n";
				}
				$str .="\$_where['category_id'] = array('eq',\$_category_id);\r\n";
			}

			if ('$' == substr($tag['id'],0,1)) {
				$tag['id'] = $this->autoBuildVar(substr($tag['id'], 1));
				$str .="\$_where['id'] = array('{$_type}',{$tag['id']});\r\n";
			}else{
				$str .="\$_where['id'] = array('{$_type}','{$tag['id']}');\r\n";
			}

		}else{
			if ('$' == substr($tag['mark'],0,1)) {
				$tag['mark'] = $this->autoBuildVar(substr($tag['mark'], 1));
				$str .="\$_where['mark'] = array('eq',{$tag['mark']});\r\n";
			}else{
				$str .="\$_where['mark'] = array('eq','{$tag['mark']}');\r\n";
			}
		}
		$str .="\$_m -> where(\$_where);\r\n";
		$str .="\${$tag['return']} = \$_m -> find();\r\n";
		$str .="?>";
		return $str;
	}

	// 
	public function _navlist($tag,$content) {
		if (empty($tag['return'])) {//return为空 返回空
			return;
		}
		if (empty($tag['mark'])) {//mark为空 返回空
			return;
		}
		$str = '';
		$str .="<?php ";
		$str .="\$_m = D('Nav','ViewModel');\r\n";
		$str .="\$_m -> order('sort desc');\r\n";
		$str .="\$_where = array();\r\n";
		$str .="\$_where['status'] = array('eq',1);\r\n";
		// 解析 mark 限制
		if ('$' == substr($tag['mark'],0,1)) {
			$tag['mark']   = $this->autoBuildVar(substr($tag['mark'], 1));
			$str .="\$_category_id = M('Nav_category') -> where(array('mark'=>array('eq',{$tag['mark']}),'status'=>array('eq',1))) -> limit(1) -> getField('id');\r\n";
		}else{
			$str .="\$_category_id = M('Nav_category') -> where(array('mark'=>array('eq','{$tag['mark']}'),'status'=>array('eq',1))) -> limit(1) -> getField('id');\r\n";
		}
		$str .="\$_where['category_id'] = array('eq',\$_category_id);\r\n";
		// 解析 recursion 限制
		if (isset($tag['recursion'])) {
			$str .="\${$tag['return']}_tmp = \$_m -> where(\$_where) -> select();\r\n";
			// pid限制
			if (isset($tag['pid'])) {
				if ('$' == substr($tag['pid'],0,1)) {
					$tag['pid']   = $this->autoBuildVar(substr($tag['pid'], 1));
					$str .="\${$tag['return']} = data2subtree(\${$tag['return']}_tmp,{$tag['pid']});\r\n";
				}else{
					$str .="\${$tag['return']} = data2subtree(\${$tag['return']}_tmp,'{$tag['pid']}');\r\n";
				}
			}else{
				$str .="\${$tag['return']} = data2tree(\${$tag['return']}_tmp);\r\n";
			}
		}else{
			// 解析limit限制属性
			if (isset($tag['limit'])) {
				if ('$' == substr($tag['limit'],0,1)) {
					$tag['limit']   = $this->autoBuildVar(substr($tag['limit'], 1));
					$str .="\$_m -> limit({$tag['limit']});";
				}else{
					$str .="\$_m -> limit('{$tag['limit']}');";
				}
			}
			// pid限制
			if (isset($tag['pid'])) {
				if ('$' == substr($tag['pid'],0,1)) {
					$tag['pid']   = $this->autoBuildVar(substr($tag['pid'], 1));
					$str .="\$_where['pid'] = array('eq',{$tag['pid']});\r\n";
				}else{
					$str .="\$_where['pid'] = array('eq','{$tag['pid']}');\r\n";
				}
			}
			$str .="\$_m -> where(\$_where);\r\n";
			$str .="\${$tag['return']} = \$_m -> select();\r\n";
		}
		$str .="?>";
		return $str;
	}

	// 
	public function _linklist($tag,$content,$module='Link') {
		if (empty($tag['return'])) {//return为空 返回空
			return;
		}
		$str = '';
		$str .="<?php ";
		$str .="\$_m = D('{$module}','ViewModel');\r\n";
		$str .="\$_m -> order('sort desc');\r\n";
		$str .="\$_where = array();\r\n";
		$str .="\$_where['status'] = array('eq',1);\r\n";
		$str .="\$_m -> where(\$_where);\r\n";
		// 解析limit限制属性
		if (isset($tag['limit'])) {
			if ('$' == substr($tag['limit'],0,1)) {
				$tag['limit']   = $this->autoBuildVar(substr($tag['limit'], 1));
				$str .="\$_m -> limit({$tag['limit']});";
			}else{
				$str .="\$_m -> limit('{$tag['limit']}');";
			}
		}
		$str .="\${$tag['return']} = \$_m -> select();\r\n";
		$str .="?>";
		return $str;
	}

	public function _guestbooklist($tag,$content){
		if (empty($tag['return'])) {//return为空 返回空
			return;
		}
		$str = '';
		$str .="<?php ";
		$str .="\$_m = D('Guestbook','ViewModel');\r\n";
		$str .="\$_m -> order('sort desc');\r\n";
		$str .="\$_where = array();\r\n";
		$str .="\$_where['status'] = array('eq',1);\r\n";
		// 解析contentid限制属性
		if (isset($tag['contentid'])) {
			if ('$' == substr($tag['contentid'],0,1)) {
				$tag['contentid']   = $this->autoBuildVar(substr($tag['contentid'], 1));
				$str .="\$_where['content_id'] = array('eq',{$tag['contentid']});\r\n";
			}else{
				$str .="\$_where['content_id'] = array('eq','{$tag['limit']}');\r\n";
			}
		}else{
			$str .="\$_where['content_id'] = array('eq',0);\r\n";
		}
		$str .="\$_m -> where(\$_where);\r\n";
		// 解析limit限制属性
		if (isset($tag['limit'])) {
			if ('$' == substr($tag['limit'],0,1)) {
				$tag['limit']   = $this->autoBuildVar(substr($tag['limit'], 1));
				$str .="\$_m -> limit({$tag['limit']});";
			}else{
				$str .="\$_m -> limit('{$tag['limit']}');";
			}
		}
		$str .="\${$tag['return']} = \$_m -> select();\r\n";
		$str .="?>";
		return $str;
	}

	// slide
	public function _slidecontent($tag,$content){
		if (empty($tag['return']) || (empty($tag['id']) && empty($tag['mark']))) {//module或者return为空 返回空
			return;
		}
		$str = '';
		$str .="<?php ";
		$str .="\$_m = D('Slide','ViewModel');\r\n";
		$str .="\$_where = array();\r\n";
		$str .="\$_where['status'] = array('eq',1);\r\n";
		// $str .="\$_where['Category.status'] = array('eq',1);\r\n";
		// id限制
		if (isset($tag['id'])) {
			if ('$' == substr($tag['id'],0,1)) {
				$tag['id'] = $this->autoBuildVar(substr($tag['id'], 1));
				$str .="\$_where['id'] = array('eq',{$tag['id']});\r\n";
			}else{
				$str .="\$_where['id'] = array('eq','{$tag['id']}');\r\n";
			}

		}else{
			if ('$' == substr($tag['mark'],0,1)) {
				$tag['mark'] = $this->autoBuildVar(substr($tag['mark'], 1));
				$str .="\$_where['mark'] = array('eq',{$tag['mark']});\r\n";
			}else{
				$str .="\$_where['mark'] = array('eq','{$tag['mark']}');\r\n";
			}
		}
		$str .="\$_m -> where(\$_where);\r\n";
		$str .="\${$tag['return']} = \$_m -> find();\r\n";
		$str .="?>";
		return $str;
	}

	// print调试标签
	public function _print($tag,$content) {
		if (empty($tag['name'])) {
			return;
		}
		if ('$' == substr($tag['name'],0,1)) {//当为变量的时候
			$name   = $this->autoBuildVar(substr($tag['name'], 1));
		}else{
			$name   = $this->autoBuildVar($tag['name']);
		}
		$str = "<?php ";
		$str .= "p({$name});";
		$str .= "?>";
		return $str;
	}

	// fn函数
	public function _fn($tag,$content){
		if (empty($tag['name']) || empty($tag['fn'])) {
			return;
		}
		// 模板禁止使用函数
		$template_deny_funs = explode(',',C('TMPL_DENY_FUNC_LIST'));
		if(!in_array($tag['fn'],$template_deny_funs)){
			$tag['name'] = $this->autoBuildVar($tag['name']);
			$str = '';
			$str .= '<?php ';
			if (isset($tag['return'])) {
				$str .= "\${$tag['return']} = ";
			} else {
				$str .= "{$tag['name']} = ";
			}
			
			if(isset($tag['param'])){
				if(strstr($tag['param'],'###')){
					$tag['param'] = str_replace('###',$tag['name'],$tag['param']);
					$str .= "{$tag['fn']}({$tag['param']});\r\n";
				}else{
					$str .= "{$tag['fn']}({$tag['name']},{$tag['param']});\r\n";
				}
			}else{
				$str .= "{$tag['fn']}({$tag['name']});\r\n";
			}
			$str .= "?>";
			return $str;
		}
	}

}
