/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50540
Source Host           : localhost:3306
Source Database       : qiyecms3

Target Server Type    : MYSQL
Target Server Version : 50540
File Encoding         : 65001

Date: 2015-12-30 11:48:45
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `mmt_attachment`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_attachment`;
CREATE TABLE `mmt_attachment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '图片id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '原始名称',
  `type` varchar(255) NOT NULL DEFAULT '',
  `size` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '图片大小',
  `ext` varchar(20) NOT NULL DEFAULT '' COMMENT '类型',
  `md5` varchar(32) NOT NULL DEFAULT '' COMMENT 'md5',
  `sha1` char(40) NOT NULL DEFAULT '',
  `savename` varchar(200) NOT NULL DEFAULT '' COMMENT '地区英文名称',
  `savepath` varchar(200) NOT NULL DEFAULT '' COMMENT '保存路径',
  `rootpath` varchar(200) NOT NULL DEFAULT '' COMMENT '保存目录',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '更新时间',
  `create_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='附件表';

-- ----------------------------
-- Records of mmt_attachment
-- ----------------------------
INSERT INTO `mmt_attachment` VALUES ('1', 'QQ截图20150921115858.png', 'image/png', '935553', 'png', 'c7af130df8767d11d609956b55a49d29', 'a4523df39af498219a22c961ee57bf73cec3c927', '5681ee52d2473.png', '/image/20151229/', '/Uploads', '2015-12-29 10:22:10', '2015-12-29 10:22:10');
INSERT INTO `mmt_attachment` VALUES ('2', 'QQ截图20150921120038.png', 'image/png', '128850', 'png', 'e6e73e4bb3777cb3dc9cd57353d3f1eb', 'fc7ef464c475d3242b01abbd4b711e7414f65cf7', '5681ee52da23b.png', '/image/20151229/', '/Uploads', '2015-12-29 10:22:10', '2015-12-29 10:22:10');
INSERT INTO `mmt_attachment` VALUES ('3', 's24.jpg', 'image/jpeg', '81958', 'jpg', '33d96dd40d8ff5c77a0ab53d5fc1b60b', '93b71c7c2afb3fa2a3ff98e57710aff849eccb00', '5681ee52dfbda.jpg', '/image/20151229/', '/Uploads', '2015-12-29 10:22:10', '2015-12-29 10:22:10');
INSERT INTO `mmt_attachment` VALUES ('4', '贝壳.jpg', 'image/jpeg', '256189', 'jpg', '01973bc147693a346660d3cff620ab98', 'bae312bc00dc3242fdc1dcbe9087f162cbde8881', '5681ee52e6318.jpg', '/image/20151229/', '/Uploads', '2015-12-29 10:22:10', '2015-12-29 10:22:10');
INSERT INTO `mmt_attachment` VALUES ('5', '捕获.PNG', 'image/png', '35540', 'PNG', '8dd2ac1d27b5edbf4be882ea9a3b29a5', '890d71ddf76d8ce57d581f932cd3986d2ad93073', '5681ee52eb9e0.PNG', '/image/20151229/', '/Uploads', '2015-12-29 10:22:10', '2015-12-29 10:22:10');
INSERT INTO `mmt_attachment` VALUES ('6', '沙滩贝壳.jpeg', 'image/jpeg', '92708', 'jpeg', '8182bb4b2a4bcaf75e1e3574eaddb054', '474075ea57b405c874321ea72483e921d3ac18f0', '5681ee52f10f4.jpeg', '/image/20151229/', '/Uploads', '2015-12-29 10:22:11', '2015-12-29 10:22:11');

-- ----------------------------
-- Table structure for `mmt_config`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_config`;
CREATE TABLE `mmt_config` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '配置项',
  `value` text COMMENT '配置值',
  `type` enum('string','yaml','ini','array','xml','number','bool','item','json','image','mulstring') NOT NULL DEFAULT 'string' COMMENT '类型',
  `text` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `instruction` text COMMENT '说明',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '更新时间',
  `create_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '99' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '锁定',
  `system` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '系统',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=268 DEFAULT CHARSET=utf8 COMMENT='配置表';

-- ----------------------------
-- Records of mmt_config
-- ----------------------------
INSERT INTO `mmt_config` VALUES ('1', '2', '0', 'VAR_MODULE', 'm', 'string', '模块获取变量', '', '2015-08-31 21:54:04', '2015-08-31 21:54:04', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('2', '2', '0', 'VAR_CONTROLLER', 'c', 'string', '控制器获取变量', '', '2015-08-31 21:54:23', '2015-08-31 21:54:23', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('3', '2', '0', 'VAR_ACTION', 'a', 'string', '操作获取变量', '', '2015-08-31 21:54:38', '2015-08-31 21:54:38', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('4', '2', '0', 'VAR_AJAX_SUBMIT', 'ajax', 'string', 'AJAX提交变量', '', '2015-08-31 21:54:56', '2015-08-31 21:54:56', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('5', '2', '0', 'VAR_JSONP_HANDLER', 'callback', 'string', 'VAR_JSONP_HANDLER', '', '2015-08-31 21:55:11', '2015-08-31 21:55:11', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('6', '2', '0', 'VAR_PATHINFO', 's', 'string', 'PATHINFO获取变量', '兼容模式PATHINFO获取变量例如 ?s=/module/action/id/1 后面的参数取决于URL_PATHINFO_DEPR', '2015-08-31 21:55:47', '2015-08-31 21:55:41', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('7', '2', '0', 'VAR_TEMPLATE', 't', 'string', '模板切换变量', '', '2015-08-31 21:56:06', '2015-08-31 21:56:06', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('8', '2', '0', 'VAR_ADDON', 'addon', 'string', '插件控制器命名空间变量', '默认的插件控制器命名空间变量 3.2.2新增', '2015-08-31 21:56:36', '2015-08-31 21:56:36', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('9', '3', '0', 'APP_USE_NAMESPACE', '1', 'bool', '应用类库是否使用命名空间', '应用类库是否使用命名空间 3.2.1新增', '2015-08-31 21:04:44', '2015-08-31 20:59:18', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('10', '3', '0', 'APP_SUB_DOMAIN_DEPLOY', '0', 'item', '是否开启子域名部署', '', '2015-08-31 21:04:48', '2015-08-31 21:00:14', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('11', '3', '0', 'APP_SUB_DOMAIN_RULES', '', 'item', '子域名部署规则', '', '2015-08-31 21:04:52', '2015-08-31 21:00:46', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('12', '3', '0', 'APP_DOMAIN_SUFFIX', '', 'string', '域名后缀', '如果是com.cn net.cn 之类的后缀必须设置', '2015-08-31 21:04:55', '2015-08-31 21:01:40', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('13', '3', '0', 'ACTION_SUFFIX', '', 'string', '操作方法后缀', '', '2015-08-31 21:05:00', '2015-08-31 21:03:45', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('14', '3', '0', 'MULTI_MODULE', '1', 'bool', '是否允许多模块', '如果为false 则必须设置 DEFAULT_MODULE', '2015-08-31 21:05:04', '2015-08-31 21:04:11', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('15', '3', '0', 'MODULE_DENY_LIST', 'Common\r\nRuntime', 'item', '禁止访问的模块列表', '', '2015-08-31 21:05:15', '2015-08-31 21:04:38', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('16', '3', '0', 'MODULE_ALLOW_LIST', '', 'item', '允许访问的模块列表', '', '2015-08-31 21:05:45', '2015-08-31 21:05:38', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('17', '3', '0', 'CONTROLLER_LEVEL', '1', 'number', '控制器层级', '', '2015-08-31 21:06:15', '2015-08-31 21:06:15', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('18', '3', '0', 'APP_AUTOLOAD_LAYER', 'Controller,Model', 'string', '自动加载类库层', '（针对非命名空间定义类库） 3.2.1新增', '2015-08-31 21:07:46', '2015-08-31 21:06:59', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('19', '3', '0', 'APP_AUTOLOAD_PATH', '', 'string', '自动加载的路径', '（针对非命名空间定义类库） 3.2.1新增', '2015-08-31 21:07:29', '2015-08-31 21:07:29', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('20', '4', '0', 'DEFAULT_M_LAYER', 'Model', 'string', '默认的模型层名称', '', '2015-08-31 21:08:38', '2015-08-31 21:08:38', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('21', '4', '0', 'DEFAULT_C_LAYER', 'Controller', 'string', '默认的控制器层名称', '', '2015-08-31 21:08:57', '2015-08-31 21:08:57', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('22', '4', '0', 'DEFAULT_V_LAYER', 'View', 'string', '默认的视图层名称', '', '2015-08-31 21:09:17', '2015-08-31 21:09:17', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('23', '4', '0', 'DEFAULT_LANG', 'zh-cn', 'string', '默认语言', '', '2015-08-31 21:09:37', '2015-08-31 21:09:37', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('24', '4', '0', 'DEFAULT_THEME', '', 'string', '默认模板主题名称', '', '2015-08-31 21:09:54', '2015-08-31 21:09:54', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('25', '4', '0', 'DEFAULT_MODULE', 'Home', 'string', '默认模块', '', '2015-08-31 21:10:15', '2015-08-31 21:10:15', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('26', '4', '0', 'DEFAULT_CONTROLLER', 'Index', 'string', '默认控制器名称', '', '2015-08-31 21:10:36', '2015-08-31 21:10:36', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('27', '4', '0', 'DEFAULT_ACTION', 'index', 'string', '默认操作名称', '', '2015-08-31 21:10:51', '2015-08-31 21:10:51', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('28', '4', '0', 'DEFAULT_CHARSET', 'utf-8', 'string', '默认输出编码', '', '2015-08-31 21:11:08', '2015-08-31 21:11:08', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('29', '4', '0', 'DEFAULT_TIMEZONE', 'PRC', 'string', '默认时区', '', '2015-08-31 21:11:28', '2015-08-31 21:11:23', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('30', '4', '0', 'DEFAULT_AJAX_RETURN', 'JSON', 'string', '默认AJAX 数据返回格式', '可选JSON XML ...', '2015-08-31 21:11:59', '2015-08-31 21:11:48', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('31', '4', '0', 'DEFAULT_JSONP_HANDLER', 'jsonpReturn', 'string', '默认JSONP格式返回的处理方法', '', '2015-08-31 21:12:17', '2015-08-31 21:12:17', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('32', '4', '0', 'DEFAULT_FILTER', 'htmlspecialchars', 'string', '默认参数过滤方法', '用于I函数...', '2015-08-31 21:12:41', '2015-08-31 21:12:41', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('33', '5', '0', 'URL_404_REDIRECT', '', 'string', '404 跳转页面', '部署模式有效', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('34', '5', '0', 'URL_MAP_RULES', '[]', 'json', 'URL映射定义规则', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('35', '5', '0', 'URL_ROUTE_RULES', '[]', 'json', '路由规则', '默认路由规则 针对模块', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('36', '5', '0', 'URL_ROUTER_ON', '0', 'bool', '是否开启URL路由', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('37', '5', '0', 'URL_MODEL', '0', 'number', 'URL访问模式', '可选参数0、1、2、3,代表以下四种模式：\r\n// 0 (普通模式); 1 (PATHINFO 模式); 2 (REWRITE  模式); 3 (兼容模式)  默认为PATHINFO 模式', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('38', '5', '0', 'URL_HTML_SUFFIX', 'html', 'string', '伪静态后缀', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('39', '5', '0', 'URL_PATHINFO_DEPR', '/', 'string', 'PATHINFO分隔符', 'PATHINFO模式下，各参数之间的分割符号', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('40', '5', '0', 'URL_DENY_SUFFIX', 'ico|png|gif|jpg|js|css', 'string', 'URL禁止访问的后缀', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('41', '5', '0', 'URL_CASE_INSENSITIVE', '0', 'bool', '是否区分大小写', '默认false 表示URL区分大小写 true则表示不区分大小写', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('42', '5', '0', 'URL_PATHINFO_FETCH', 'ORIG_PATH_INFO,REDIRECT_PATH_INFO,REDIRECT_URL', 'string', 'URL_PATHINFO_FETCH', '用于兼容判断PATH_INFO 参数的SERVER替代变量列表', '2015-08-31 21:49:52', '2015-08-31 21:49:52', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('43', '5', '0', 'URL_REQUEST_URI', 'REQUEST_URI', 'string', 'URL_REQUEST_URI', '获取当前页面地址的系统变量 默认为REQUEST_URI', '2015-08-31 21:50:31', '2015-08-31 21:50:25', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('44', '5', '0', 'URL_PARAMS_BIND', '1', 'bool', '绑定到参数', 'URL变量绑定到Action方法参数', '2015-08-31 21:51:33', '2015-08-31 21:51:33', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('45', '5', '0', 'URL_PARAMS_BIND_TYPE', '0', 'number', '变量绑定类型', '0 按变量名绑定 1 按变量顺序绑定', '2015-08-31 21:52:24', '2015-08-31 21:52:24', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('46', '6', '0', 'TMPL_ACTION_ERROR', '{{THINK_PATH}}Tpl/dispatch_jump.tpl', 'string', '错误跳转对应的模板文件', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('47', '6', '0', 'TMPL_STRIP_SPACE', '1', 'bool', '是否去除模板文件里面的html空格与换行', '', '2015-08-31 21:44:54', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('48', '6', '0', 'TMPL_ENGINE_TYPE', 'Think', 'string', '模板引擎', '', '2015-08-11 17:22:34', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('49', '6', '0', 'TMPL_FILE_DEPR', '/', 'string', '模板文件分割符', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('50', '6', '0', 'TMPL_TEMPLATE_SUFFIX', '.html', 'string', '模板文件后缀', '', '2015-08-13 20:47:10', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('51', '6', '0', 'TMPL_CONTENT_TYPE', 'text/html', 'string', '模板输出类型', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('52', '6', '0', 'TMPL_EXCEPTION_FILE', '{{THINK_PATH}}Tpl/think_exception.tpl', 'string', '异常页面的模板文件', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('53', '6', '0', 'TMPL_ACTION_SUCCESS', '{{THINK_PATH}}Tpl/dispatch_jump.tpl', 'string', '成功跳转对应的模板文件', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('54', '6', '0', 'TMPL_DETECT_THEME', '0', 'bool', '自动侦测模板主题', '', '2015-08-31 21:39:42', '2015-08-31 21:39:33', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('55', '6', '0', 'TMPL_CACHFILE_SUFFIX', '.php', 'string', '模板缓存后缀', '', '2015-08-31 21:40:32', '2015-08-31 21:40:32', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('56', '6', '0', 'TMPL_DENY_FUNC_LIST', 'echo,exit', 'string', '模板引擎禁用函数', '', '2015-08-31 21:40:58', '2015-08-31 21:40:58', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('57', '6', '0', 'TMPL_DENY_PHP', '0', 'bool', '禁用PHP原生代码', '', '2015-08-31 21:41:36', '2015-08-31 21:41:36', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('58', '6', '0', 'TMPL_L_DELIM', '{', 'string', '开始标记', '模板引擎普通标签开始标记', '2015-08-31 21:42:08', '2015-08-31 21:42:08', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('59', '6', '0', 'TMPL_R_DELIM', '}', 'string', '结束标记', '模板引擎普通标签结束标记', '2015-08-31 21:42:31', '2015-08-31 21:42:31', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('60', '6', '0', 'TMPL_VAR_IDENTIFY', 'array', 'string', '模板变量识别', '留空自动判断,参数为\'obj\'则表示对象', '2015-08-31 21:43:17', '2015-08-31 21:43:17', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('61', '6', '0', 'TMPL_CACHE_ON', '1', 'bool', '模板编译缓存', '是否开启模板编译缓存,设为false则每次都会重新编译', '2015-08-31 21:44:34', '2015-08-31 21:44:28', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('62', '6', '0', 'TMPL_CACHE_PREFIX', '', 'string', '模板缓存前缀标识', '模板缓存前缀标识，可以动态改变', '2015-08-31 21:45:55', '2015-08-31 21:45:55', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('63', '6', '0', 'TMPL_CACHE_TIME', '0', 'number', '模板缓存有效期', ' 0 为永久，(以数字为值，单位:秒)', '2015-08-31 21:46:43', '2015-08-31 21:46:43', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('64', '6', '0', 'TMPL_LAYOUT_ITEM', '{__CONTENT__}', 'string', '布局标识符', '布局模板的内容替换标识', '2015-08-31 21:47:34', '2015-08-31 21:47:28', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('65', '6', '0', 'LAYOUT_ON', '0', 'bool', '是否启用布局', '', '2015-08-31 21:48:07', '2015-08-31 21:48:07', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('66', '6', '0', 'LAYOUT_NAME', 'layout', 'string', '当前布局名称', '默认为layout', '2015-08-31 21:48:29', '2015-08-31 21:48:29', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('67', '7', '0', 'ERROR_MESSAGE', '页面错误！请稍后再试～', 'string', '错误显示信息', '非调试模式有效', '2015-08-31 21:31:06', '2015-08-31 21:31:06', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('68', '7', '0', 'ERROR_PAGE', '', 'string', '错误定向页面', '', '2015-08-31 21:31:25', '2015-08-31 21:31:25', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('69', '7', '0', 'SHOW_ERROR_MSG', '0', 'bool', '显示错误信息', '', '2015-09-03 15:16:35', '2015-08-31 21:31:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('70', '7', '0', 'TRACE_MAX_RECORD', '100', 'number', '记录数', '每个级别的错误信息 最大记录数', '2015-08-31 21:32:43', '2015-08-31 21:32:43', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('71', '8', '0', 'LOG_RECORD', '0', 'bool', '是否记录', '默认不记录日志', '2015-08-31 21:33:40', '2015-08-31 21:33:40', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('72', '8', '0', 'LOG_TYPE', 'File', 'string', '日志记录类型', '默认为文件方式', '2015-08-31 21:34:27', '2015-08-31 21:34:27', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('73', '8', '0', 'LOG_LEVEL', 'EMERG,ALERT,CRIT,ERR', 'string', '记录级别', '允许记录的日志级别', '2015-08-31 21:34:59', '2015-08-31 21:34:59', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('74', '8', '0', 'LOG_EXCEPTION_RECORD', '0', 'bool', '记录异常日志', '是否记录异常信息日志', '2015-08-31 21:35:39', '2015-08-31 21:35:39', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('75', '9', '0', 'DATA_CACHE_CHECK', '0', 'bool', '是否校验缓存', '', '2015-08-31 21:27:13', '2015-08-31 21:27:13', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('76', '9', '0', 'DATA_CACHE_COMPRESS', '0', 'bool', '是否压缩缓存', '', '2015-08-31 21:26:55', '2015-08-31 21:26:55', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('77', '9', '0', 'DATA_CACHE_TIME', '0', 'number', '缓存有效期', '0表示永久缓存', '2015-08-31 21:26:26', '2015-08-31 21:26:26', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('78', '9', '0', 'DATA_CACHE_PREFIX', '', 'string', '缓存前缀', '', '2015-08-31 21:27:28', '2015-08-31 21:27:28', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('79', '9', '0', 'DATA_CACHE_TYPE', 'File', 'string', '缓存类型', '支持:File|Db|Apc|Memcache|Shmop|Sqlite|Xcache|Apachenote|Eaccelerator等，前提需要您的服务器支持', '2015-08-31 21:28:23', '2015-08-31 21:28:23', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('80', '9', '0', 'DATA_CACHE_PATH', '{{TEMP_PATH}}', 'string', '缓存路径', '(仅对File方式缓存有效)', '2015-08-31 21:28:59', '2015-08-31 21:28:59', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('81', '9', '0', 'DATA_CACHE_SUBDIR', '0', 'bool', '使用子目录缓存', '(自动根据缓存标识的哈希创建子目录)', '2015-08-31 21:29:30', '2015-08-31 21:29:30', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('82', '9', '0', 'DATA_PATH_LEVEL', '1', 'number', '子目录缓存级别', '', '2015-08-31 21:29:52', '2015-08-31 21:29:52', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('83', '10', '0', 'SESSION_AUTO_START', '1', 'bool', '自动开启', '是否自动开启Session', '2015-08-31 21:36:53', '2015-08-31 21:36:53', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('84', '10', '0', 'SESSION_OPTIONS', '', 'string', '配置数组', '支持type name id path expire domain 等参数', '2015-08-31 21:37:45', '2015-08-31 21:37:39', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('85', '10', '0', 'SESSION_TYPE', '', 'string', 'hander类型', '默认无需设置 除非扩展了session hander驱动', '2015-08-31 21:38:11', '2015-08-31 21:38:11', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('86', '10', '0', 'SESSION_PREFIX', '', 'string', 'session 前缀', '', '2015-08-31 21:38:30', '2015-08-31 21:38:30', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('87', '11', '0', 'COOKIE_EXPIRE', '0', 'number', 'Cookie有效期', '', '2015-08-31 21:13:30', '2015-08-31 21:13:30', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('88', '11', '0', 'COOKIE_DOMAIN', '', 'string', 'Cookie有效域名', '', '2015-08-31 21:13:51', '2015-08-31 21:13:46', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('89', '11', '0', 'COOKIE_PATH', '/', 'string', 'Cookie路径', '', '2015-08-31 21:14:11', '2015-08-31 21:14:11', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('90', '11', '0', 'COOKIE_PREFIX', '', 'string', 'Cookie前缀', '避免冲突', '2015-08-31 21:14:32', '2015-08-31 21:14:32', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('91', '11', '0', 'COOKIE_HTTPONLY', '', 'string', 'COOKIE_HTTPONLY', 'Cookie的httponly属性 3.2.2新增', '2015-08-31 21:14:55', '2015-08-31 21:14:55', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('92', '12', '0', 'DB_HOST', '127.0.0.1', 'string', '服务器地址', '若发现数据库执行慢，可尝试切换数据库地址\r\nlocalhost\r\n127.0.0.1', '2015-10-15 09:25:13', '2015-07-25 17:04:49', '99', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('93', '12', '0', 'DB_PORT', '', 'number', '端口', 'mysql的默认端口是3306，可不填', '2015-09-03 18:30:25', '2015-07-25 17:04:49', '97', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('94', '12', '0', 'DB_TYPE', 'mysql', 'string', '数据库类型', '', '2015-09-03 18:30:32', '2015-07-25 17:04:49', '95', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('95', '12', '0', 'DB_USER', 'root', 'string', '用户名', '不建议使用超级账户', '2015-09-03 18:29:43', '2015-07-25 17:04:49', '71', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('96', '12', '0', 'DB_PWD', 'root', 'string', '密码', '', '2015-09-03 18:29:49', '2015-07-25 17:04:49', '60', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('97', '12', '0', 'DB_NAME', 'qiyecms3', 'string', '数据库名', '', '2015-09-08 11:18:16', '2015-07-25 17:04:49', '59', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('98', '12', '0', 'DB_PREFIX', 'mmt_', 'string', '数据库表前缀', '若非必要，此项请不要修改\r\n修改后需要手动对数据库表前缀重命名', '2015-09-03 18:30:10', '2015-07-25 17:04:49', '41', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('99', '12', '0', 'DB_FIELDS_CACHE', '', 'string', '字段缓存', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('100', '12', '0', 'DB_PARAMS', '{&quot;8&quot;:0}', 'json', '其他参数', '', '2015-08-31 22:18:40', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('101', '12', '0', 'DB_DEBUG', '1', 'bool', '数据库调试', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('102', '12', '0', 'DB_LITE', '0', 'bool', 'Lite模式', '3.2.3新增 ', '2015-08-31 21:21:39', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('103', '12', '0', 'DB_CHARSET', 'utf8', 'string', '数据库字符集', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('104', '12', '0', 'DB_DEPLOY_TYPE', '0', 'number', '数据库部署方式', '0 集中式(单一服务器),1 分布式(主从服务器)', '2015-08-31 21:17:45', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('105', '12', '0', 'DB_BIND_PARAM', '0', 'number', '数据库写入数据自动参数绑定', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('106', '12', '0', 'DB_RW_SEPARATE', '0', 'bool', '读写分离', '主从式有效', '2015-08-31 21:18:29', '2015-08-31 21:18:20', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('107', '12', '0', 'DB_MASTER_NUM', '1', 'number', '主服务器数量', '主从式有效', '2015-08-31 21:19:12', '2015-08-31 21:19:01', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('108', '12', '0', 'DB_SLAVE_NO', '', 'number', '从服务器序号', '主从式有效', '2015-08-31 21:19:45', '2015-08-31 21:19:45', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('126', '15', '0', 'TOKEN_ON', '1', 'bool', '是否开启表单令牌', '注意，开启表单令牌之前，请务必在配置目录下的tags.php中添加\r\n\'view_filter\' =&gt; array(\'Behavior\\\\TokenBuildBehavior\'),', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '4');
INSERT INTO `mmt_config` VALUES ('127', '15', '0', 'TOKEN_NAME', '__hash__', 'string', '令牌表单', '该字段请不要用常规的表单域，一般请使用双下划线避免重复', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '4');
INSERT INTO `mmt_config` VALUES ('128', '15', '0', 'TOKEN_TYPE', 'md5', 'string', '令牌类型', '令牌域值的生成算法', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '4');
INSERT INTO `mmt_config` VALUES ('129', '15', '0', 'TOKEN_RESET', '0', 'bool', '开启安全重置', '表单令牌是否', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '4');
INSERT INTO `mmt_config` VALUES ('130', '16', '0', 'DATA_BACKUP_PATH', './Backup', 'string', '备份路径', '为了系统安全，建议您将备份目录设置在网站目录之外，例如：../Backup', '2015-08-30 17:08:22', '2015-07-25 17:04:49', '1', '1', '0', '4');
INSERT INTO `mmt_config` VALUES ('131', '16', '0', 'DATA_BACKUP_PART_SIZE', '2048000', 'number', '卷大小', '单位B', '2015-11-16 16:50:59', '2015-07-25 17:04:49', '1', '1', '0', '4');
INSERT INTO `mmt_config` VALUES ('132', '16', '0', 'DATA_BACKUP_COMPRESS', '0', 'bool', '是否启用ZIP压缩', '不建议开启', '2015-09-01 10:22:00', '2015-07-25 17:04:49', '1', '1', '0', '4');
INSERT INTO `mmt_config` VALUES ('133', '16', '0', 'DATA_BACKUP_COMPRESS_LEVEL', '4', 'number', '压缩等级', '', '2015-08-30 17:14:46', '2015-07-25 17:04:49', '1', '1', '0', '4');
INSERT INTO `mmt_config` VALUES ('134', '17', '0', 'UEDITOR', '', 'json', '百度编辑器配置', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('135', '17', '134', 'fileManagerAllowFiles', '.png\r\n.jpg\r\n.jpeg\r\n.gif\r\n.bmp\r\n.flv\r\n.swf\r\n.mkv\r\n.avi\r\n.rm\r\n.rmvb\r\n.mpeg\r\n.mpg\r\n.ogg\r\n.ogv\r\n.mov\r\n.wmv\r\n.mp4\r\n.webm\r\n.mp3\r\n.wav\r\n.mid\r\n.rar\r\n.zip\r\n.tar\r\n.gz\r\n.7z\r\n.bz2\r\n.cab\r\n.iso\r\n.doc\r\n.docx\r\n.xls\r\n.xlsx\r\n.ppt\r\n.pptx\r\n.pdf\r\n.txt\r\n.md\r\n.xml', 'item', '列出的文件类型', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('136', '17', '134', 'fileManagerListSize', '20', 'number', '每次列出文件数量', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('137', '17', '134', 'fileManagerUrlPrefix', 'http://{{$_SERVER[\'HTTP_HOST\']}}', 'string', '文件访问路径前缀', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('138', '17', '134', 'fileManagerListPath', '/file/', 'string', '指定要列出文件的目录', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('139', '17', '134', 'fileManagerActionName', 'listfile', 'string', '执行文件管理的action名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('140', '17', '134', 'imageManagerAllowFiles', '.png\r\n.jpg\r\n.jpeg\r\n.gif\r\n.bmp', 'item', '列出的文件类型', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('141', '17', '134', 'imageManagerInsertAlign', 'none', 'string', '插入的图片浮动方式', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('142', '17', '134', 'imageManagerUrlPrefix', 'http://{{$_SERVER[\'HTTP_HOST\']}}', 'string', '图片访问路径前缀', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('143', '17', '134', 'imageManagerListSize', '20', 'number', '每次列出文件数量', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('144', '17', '134', 'imageManagerListPath', '/image/', 'string', ' 指定要列出图片的目录', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('145', '17', '134', 'imageManagerActionName', 'listimage', 'string', ' 执行图片管理的action名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('146', '17', '134', 'fileAllowFiles', '.png\r\n.jpg\r\n.jpeg\r\n.gif\r\n.bmp\r\n.flv\r\n.swf\r\n.mkv\r\n.avi\r\n.rm\r\n.rmvb\r\n.mpeg\r\n.mpg\r\n.ogg\r\n.ogv\r\n.mov\r\n.wmv\r\n.mp4\r\n.webm\r\n.mp3\r\n.wav\r\n.mid\r\n.rar\r\n.zip\r\n.tar\r\n.gz\r\n.7z\r\n.bz2\r\n.cab\r\n.iso\r\n.doc\r\n.docx\r\n.xls\r\n.xlsx\r\n.ppt\r\n.pptx\r\n.pdf\r\n.txt\r\n.md\r\n.xml', 'item', '上传文件格式显示', '允许上传的附件类型', '2015-09-01 11:18:46', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('147', '17', '134', 'fileMaxSize', '51200000', 'number', '上传大小限制', '上传文件时候的文件大小限制', '2015-09-01 11:17:38', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('148', '17', '134', 'fileUrlPrefix', 'http://{{$_SERVER[\'HTTP_HOST\']}}', 'string', ' 文件访问路径前缀', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('149', '17', '134', 'filePathFormat', '/file/{yyyy}{mm}{dd}/', 'string', '上传保存路径', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('150', '17', '134', 'fileFieldName', 'upfile', 'string', '提交的文件表单名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('151', '17', '134', 'fileActionName', 'uploadfile', 'string', '执行上传视频的action名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('152', '17', '134', 'videoAllowFiles', '.flv\r\n.swf\r\n.mkv\r\n.avi\r\n.rm\r\n.rmvb\r\n.mpeg\r\n.mpg\r\n.ogg\r\n.ogv\r\n.mov\r\n.wmv\r\n.mp4\r\n.webm\r\n.mp3\r\n.wav\r\n.mid', 'item', '上传视频格式显示', '允许上传的视频格式', '2015-09-01 11:17:17', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('153', '17', '134', 'videoMaxSize', '102400000', 'string', '上传大小限制', '视频上传大小限制', '2015-09-01 11:17:06', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('154', '17', '134', 'videoActionName', 'uploadvideo', 'string', '执行上传视频的action名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('155', '17', '134', 'videoFieldName', 'upfile', 'string', '提交的视频表单名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('156', '17', '134', 'videoPathFormat', '/video/{yyyy}{mm}{dd}/', 'string', '上传保存路径', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('157', '17', '134', 'videoUrlPrefix', 'http://{{$_SERVER[\'HTTP_HOST\']}}', 'string', '视频访问路径前缀', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('158', '17', '134', 'catcherAllowFiles', '.png\r\n.jpg\r\n.jpeg\r\n.gif\r\n.bmp', 'item', '抓取图片格式显示', '允许远程抓取的图片类型', '2015-09-01 11:16:51', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('159', '17', '134', 'catcherMaxSize', '2048000', 'number', '上传大小限制', '远程抓取的文件大小限制', '2015-09-01 11:16:32', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('160', '17', '134', 'catcherUrlPrefix', 'http://{{$_SERVER[\'HTTP_HOST\']}}', 'string', '图片访问路径前缀', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('161', '17', '134', 'catcherPathFormat', '/image/{yyyy}{mm}{dd}/', 'string', '上传保存路径', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('162', '17', '134', 'catcherFieldName', 'source', 'string', '提交的图片列表表单名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('163', '17', '134', 'catcherActionName', 'catchimage', 'string', '执行抓取远程图片的action名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('164', '17', '134', 'catcherLocalDomain', '127.0.0.1\r\nlocalhost\r\nimg.baidu.com', 'item', '不必远程抓取的地址', '这些域名下面的图片不会被抓取到本地', '2015-09-01 11:19:59', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('165', '17', '134', 'snapscreenInsertAlign', 'none', 'string', '插入的图片浮动方式', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('166', '17', '134', 'snapscreenUrlPrefix', 'http://{{$_SERVER[\'HTTP_HOST\']}}', 'string', '图片访问路径前缀', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('167', '17', '134', 'snapscreenPathFormat', '/image/{yyyy}{mm}{dd}/', 'string', '上传保存路径', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('168', '17', '134', 'snapscreenActionName', 'uploadimage', 'string', '执行上传截图的action名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('169', '17', '134', 'scrawlInsertAlign', 'none', 'string', '插入的插图浮动方式', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('170', '17', '134', 'scrawlUrlPrefix', 'http://{{$_SERVER[\'HTTP_HOST\']}}', 'string', '图片访问路径前缀', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('171', '17', '134', 'scrawlMaxSize', '2048000', 'number', '上传大小限制', '涂鸦上传的图片大小限制', '2015-09-01 11:15:23', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('172', '17', '134', 'scrawlPathFormat', '/image/{yyyy}{mm}{dd}/', 'string', '涂鸦上传保存路径', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('173', '17', '134', 'scrawlFieldName', 'upfile', 'string', '提交的图片表单名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('174', '17', '134', 'scrawlActionName', 'uploadscrawl', 'string', '执行上传涂鸦的action名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('175', '17', '134', 'imagePathFormat', '/image/{yyyy}{mm}{dd}/', 'string', '图片上传保存路径', '/* {filename} 原文件名,配置这项需要注意中文乱码问题 */\r\n/* {rand:6} 随机数,后面的数字是随机数的位数 */\r\n/* {time} 时间戳 */\r\n/* {yyyy} 四位年份 */\r\n/* {yy} 两位年份 */\r\n/* {mm} 两位月份 */\r\n/* {dd} 两位日期 */\r\n/* {hh} 两位小时 */\r\n/* {ii} 两位分钟 */\r\n/* {ss} 两位秒 */\r\n/* 非法字符 \\ : * ? &quot; &lt; &gt; | */', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('176', '17', '134', 'imageCompressEnable', '1', 'bool', '是否压缩图片', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('177', '17', '134', 'imageCompressBorder', '1600', 'number', '图片压缩最长边限制', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('178', '17', '134', 'imageInsertAlign', 'none', 'string', '插入的图片浮动方式', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('179', '17', '134', 'imageUrlPrefix', 'http://{{$_SERVER[\'HTTP_HOST\']}}', 'string', '图片访问路径前缀', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('180', '17', '134', 'imageAllowFiles', '.png\r\n.jpg\r\n.jpeg\r\n.gif\r\n.bmp', 'item', '上传图片格式', '图片上传功能的图片上传类型限制', '2015-09-01 11:14:27', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('181', '17', '134', 'imageMaxSize', '2048000', 'number', '上传大小限制，单位B', '图片上传功能的图片大小限制', '2015-09-01 11:14:39', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('182', '17', '134', 'imageFieldName', 'upfile', 'string', '提交的图片表单名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('183', '17', '134', 'imageActionName', 'uploadimage', 'string', '执行上传图片的action名称', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1', '1');
INSERT INTO `mmt_config` VALUES ('184', '18', '0', 'COOKIE_EXPIRE', '', 'number', 'COOKIE有效期', '', '2015-09-03 18:20:44', '2015-09-03 18:20:44', '1', '1', '0', '0');
INSERT INTO `mmt_config` VALUES ('185', '18', '0', 'COOKIE_DOMAIN', '', 'string', '有效域名', '', '2015-09-03 18:21:02', '2015-09-03 18:21:02', '1', '1', '0', '0');
INSERT INTO `mmt_config` VALUES ('186', '18', '0', 'COOKIE_PREFIX', '', 'string', 'COOKIE前缀', '', '2015-09-03 18:21:30', '2015-09-03 18:21:30', '1', '1', '0', '0');
INSERT INTO `mmt_config` VALUES ('187', '18', '0', 'COOKIE_HTTPONLY', '', 'bool', 'COOKIE_HTTPONLY', '', '2015-09-03 18:23:34', '2015-09-03 18:21:42', '1', '1', '0', '0');
INSERT INTO `mmt_config` VALUES ('188', '19', '0', 'UPLOAD_CONFIG', '', 'string', '上传配置', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('189', '19', '188', 'subName', 'date\r\nYmd', 'item', '文件夹命名', '保存路径的文件夹命名规则', '2015-09-01 10:52:37', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('190', '19', '188', 'saveName', 'uniqid\r\n', 'item', '文件命名规则', '文件命名规则', '2015-09-01 10:53:32', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('191', '19', '188', 'maxSize', '3145728', 'number', '文件大小限制', '单位B', '2015-09-01 10:53:21', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('192', '19', '188', 'savePath', '/image/', 'string', '保存路径', '相对于上传根目录', '2015-09-01 10:53:54', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('193', '19', '188', 'autoSub', '1', 'number', 'autoSub', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('194', '19', '188', 'exts', 'jpg\r\ngif\r\npng\r\njpeg\r\nzip\r\nrar\r\ndoc\r\ndocx\r\ntxt', 'item', '允许的文件类型', '建议剔除可能对系统安全造成威胁的文件，例如.php .exe等等', '2015-09-01 10:55:18', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('195', '19', '188', 'rootpath', '/Uploads', 'string', '上传的根目录', '可不填，默认为/Uploads', '2015-09-03 16:59:12', '2015-09-01 10:51:52', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('196', '20', '0', 'VERIFY', '', 'string', '验证码配置', '', '2015-08-12 17:00:07', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('197', '20', '196', 'fontSize', '30', 'number', '字体大小', '不要设置过大，一般填写验证码图片高度的1/3', '2015-09-01 10:24:55', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('198', '20', '196', 'imageH', '80', 'number', '图片高度', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('199', '20', '196', 'imageW', '320', 'number', '图片宽度', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('200', '20', '196', 'codeSet', '', 'string', '字符设置', '建议剔除容易引起混淆的字符，比如0o之类的', '2015-12-29 11:45:45', '2015-07-25 17:04:49', '1', '0', '0', '1');
INSERT INTO `mmt_config` VALUES ('201', '20', '196', 'useCurve', '1', 'bool', '使用干扰线', '干扰线能防止机器识别，提高系统安全性，但是会降低用户体验', '2015-09-01 10:26:57', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('202', '20', '196', 'useNoise', '1', 'bool', '使用噪点', '噪点能防止机器识别，提高系统安全性，但是会降低用户体验', '2015-09-01 10:26:49', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('203', '20', '196', 'length', '5', 'number', '字符个数', '', '2015-09-01 10:28:15', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('205', '22', '0', 'TMPL_PARSE_STRING', '', 'string', '模板替换配置', '', '2015-08-31 22:09:38', '2015-07-25 17:04:49', '1', '1', '0', '4');
INSERT INTO `mmt_config` VALUES ('206', '22', '205', '__THIRD__', '{{__ROOT__}}/Public/Third', 'string', 'THIRD', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('207', '22', '205', '__CSS__', '{{__ROOT__}}/Public/Css', 'string', 'CSS', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('208', '22', '205', '__JS__', '{{__ROOT__}}/Public/Js', 'string', 'JS', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('209', '22', '205', '__IMAGE__', '{{__ROOT__}}/Public/Image', 'string', 'IMAGE', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('210', '22', '0', 'SHOW_PAGE_TRACE', '1', 'bool', '是否显示调试信息', '', '2015-09-03 15:24:16', '2015-07-25 17:04:49', '1', '0', '0', '4');
INSERT INTO `mmt_config` VALUES ('213', '22', '0', 'EDITFILE_EXT', 'html\r\ncss\r\njs\r\ntxt', 'item', '模板管理中可以编辑的文件类型', '', '2015-12-29 11:39:30', '2015-08-30 17:17:46', '1', '1', '0', '1');
INSERT INTO `mmt_config` VALUES ('214', '22', '0', 'URL_MODEL', '0', 'bool', 'URL模式', '', '2015-09-03 17:32:00', '2015-09-03 17:32:00', '1', '1', '0', '0');
INSERT INTO `mmt_config` VALUES ('215', '24', '0', 'SITE_CLOSED', '0', 'bool', '关闭网站', '仅仅关闭前台', '2015-09-03 18:50:09', '2015-09-03 17:33:57', '99', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('216', '24', '0', 'SITE_CLOSED_REASON', '网站维护中...', 'mulstring', '关闭原因', '', '2015-12-29 11:37:13', '2015-09-03 17:35:37', '98', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('217', '24', '0', 'SHOW_PAGE_TRACE', '0', 'bool', '显示调试信息', '网站上线后建议关闭', '2015-12-29 16:25:38', '2015-08-07 09:12:26', '14', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('218', '27', '0', 'DEFAULT_THEME', 'default', 'string', '模版主题', '更改模板主题名称可以防止别人下载模板文件，\r\n更改后，还要到网站里面修改对应的文件夹名称', '2015-12-29 11:31:23', '2015-08-07 09:12:41', '90', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('219', '27', '0', 'TMPL_PARSE_STRING', '', 'string', '模板替换', '', '2015-12-29 11:31:11', '2015-09-02 15:11:12', '82', '1', '1', '4');
INSERT INTO `mmt_config` VALUES ('220', '27', '219', '__THIRD__', '{{__ROOT__}}/Public/Third', 'string', '第三方组件', '', '2015-09-02 15:11:35', '2015-09-02 15:11:35', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('221', '27', '219', '__CSS__', '{{__ROOT__}}/Public/Css', 'string', 'CSS样式表', '', '2015-09-02 15:11:53', '2015-09-02 15:11:53', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('222', '27', '219', '__JS__', '{{__ROOT__}}/Public/Js', 'string', 'JS资源地址', '', '2015-09-02 15:12:17', '2015-09-02 15:12:17', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('223', '27', '219', '__IMAGE__', '{{__ROOT__}}/Public/Image', 'string', '资源图片地址', '', '2015-09-02 15:12:37', '2015-09-02 15:12:37', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('226', '24', '0', 'TAGLIB_BUILD_IN', 'Cx,Home\\Taglib\\Qy', 'string', 'TAGLIB_BUILD_IN', '', '2015-08-11 17:47:10', '2015-08-07 09:13:00', '1', '1', '1', '2');
INSERT INTO `mmt_config` VALUES ('232', '25', '0', 'site_description', 'xx公司是一家。。。。', 'mulstring', '简介', '', '2015-12-30 09:49:46', '0000-00-00 00:00:00', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('233', '25', '0', 'site_title', '官方网站', 'string', '站点名称', '', '2015-11-23 11:35:18', '0000-00-00 00:00:00', '11', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('234', '25', '0', 'site_keywords', 'xx公司', 'string', '关键字', '用英文的逗号‘,’分割', '2015-11-23 11:35:22', '0000-00-00 00:00:00', '5', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('251', '28', '0', 'GUESTBOOK_VERIFY', '1', 'bool', '开启验证码', '开启验证码有助于防止灌水', '2015-12-29 15:42:25', '2015-09-08 11:26:04', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('252', '26', '0', 'VERIFY', '', 'string', '验证码', '', '2015-09-08 11:29:12', '2015-09-08 11:29:12', '1', '1', '0', '4');
INSERT INTO `mmt_config` VALUES ('253', '26', '252', 'fontSize', '30', 'string', '字体大小', '不要设置过大，一般填写验证码图片高度的1/3', '2015-09-08 11:29:46', '2015-09-08 11:29:46', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('254', '26', '252', 'imageH', '80', 'number', '图片高度', '', '2015-09-08 11:30:10', '2015-09-08 11:30:10', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('255', '26', '252', 'imageW', '320', 'number', '图片宽度', '', '2015-09-08 11:30:26', '2015-09-08 11:30:26', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('256', '26', '252', 'codeSet', '89', 'string', '字符设置', '建议剔除容易引起混淆的字符，比如0o之类的', '2015-09-08 11:30:53', '2015-09-08 11:30:53', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('257', '26', '252', 'useCurve', '1', 'bool', '使用干扰线', '干扰线能防止机器识别，提高系统安全性，但是会降低用户体验', '2015-09-08 11:31:16', '2015-09-08 11:31:16', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('258', '26', '252', 'useNoise', '1', 'bool', '使用噪点', '噪点能防止机器识别，提高系统安全性，但是会降低用户体验', '2015-09-08 11:31:38', '2015-09-08 11:31:38', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('259', '26', '252', 'length', '5', 'number', '字符个数', '推荐4个', '2015-09-08 11:32:04', '2015-09-08 11:32:04', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('260', '24', '0', 'RECORD_CLICK', '1', 'bool', '记录点击量', '', '2015-09-21 10:45:41', '2015-09-21 10:41:46', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('261', '24', '0', 'logo', '/Public/Image/logo.png', 'image', '网站logo', '请填写相对于入口文件（index.php）的目录，而不是网站根目录', '2015-10-15 10:10:40', '2015-10-15 09:27:07', '95', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('262', '24', '0', 'beian', '蜀ICP备13002009号', 'string', '备案信息', '', '2015-11-16 17:20:29', '2015-11-16 17:04:12', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('263', '24', '0', 'business_license', '蜀B2-20150071', 'string', '经营许可证', '', '2015-11-16 17:20:37', '2015-11-16 17:06:40', '1', '1', '0', '2');
INSERT INTO `mmt_config` VALUES ('264', '27', '0', 'CHECK_MOBILE', '1', 'bool', '开启手机访问', '开启手机访问后，需要有对应的手机模板，例如：default_mobile', '2015-12-29 14:02:53', '2015-12-29 14:00:13', '88', '1', '0', '0');
INSERT INTO `mmt_config` VALUES ('265', '28', '0', 'GUESTBOOK_NORMAL', '1', 'bool', '开启常规留言', '', '2015-12-29 15:47:40', '2015-12-29 15:41:23', '97', '1', '0', '0');
INSERT INTO `mmt_config` VALUES ('266', '28', '0', 'GUESTBOOK_CONTENT', '1', 'bool', '开启内容页留言', '', '2015-12-29 15:45:19', '2015-12-29 15:44:32', '91', '1', '0', '0');
INSERT INTO `mmt_config` VALUES ('267', '25', '0', 'URL_MODEL', '0', 'number', '伪静态模式', '普通模式	0 http://localhost/m=home&amp;c=user&amp;a=login&amp;var=value\r\nPATHINFO模式	1 http://localhost/index.php/home/user/login/var/value/\r\nREWRITE模式	2 http://localhost/home/user/login/var/value\r\n兼容模式	3 http://localhost/index.php?s=/guestbook/index.html', '2015-12-30 10:22:27', '2015-12-30 09:48:37', '1', '1', '1', '0');

-- ----------------------------
-- Table structure for `mmt_configcate`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_configcate`;
CREATE TABLE `mmt_configcate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `module` varchar(255) NOT NULL DEFAULT 'Common' COMMENT '生效模块',
  `text` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `instruction` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `iconcls` varchar(255) NOT NULL DEFAULT '' COMMENT '图标',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '更新时间',
  `create_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '创建时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否锁定',
  `system` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '系统',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COMMENT='配置分类表';

-- ----------------------------
-- Records of mmt_configcate
-- ----------------------------
INSERT INTO `mmt_configcate` VALUES ('1', '0', '', '基本配置', '', '', '2015-09-03 18:13:33', '2015-07-25 17:04:49', '99', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('2', '1', 'Common', '系统变量名', '', 'icon-zone', '2015-09-03 18:14:19', '2015-08-31 21:53:41', '99', '0', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('3', '1', 'Common', '应用设定', '', 'icon-zone', '2015-09-03 18:14:30', '2015-08-31 20:58:33', '95', '0', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('4', '1', 'Common', '默认设定', '', 'icon-zone', '2015-09-03 18:14:37', '2015-08-31 21:08:15', '88', '0', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('5', '1', 'Common', 'URL配置', '', 'icon-ruler_crop', '2015-09-03 18:15:20', '2015-07-25 17:04:49', '79', '0', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('6', '1', 'Common', '模板配置', '', 'icon-blog', '2015-09-03 18:15:11', '2015-07-25 17:04:49', '74', '0', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('7', '1', 'Common', '错误设置', '', 'icon-zone', '2015-09-03 18:15:46', '2015-08-31 21:30:19', '49', '0', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('8', '1', 'Common', '日志设置', '', 'icon-zone', '2015-09-03 18:15:52', '2015-08-31 21:33:10', '39', '0', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('9', '1', 'Common', '数据缓存设置', '', 'icon-zone', '2015-09-03 18:16:04', '2015-08-31 21:25:57', '22', '0', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('10', '1', 'Common', 'SESSION设置', '', 'icon-zone', '2015-09-03 18:16:36', '2015-08-31 21:36:23', '10', '0', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('11', '1', 'Common', 'Cookie设置', '', 'icon-zone', '2015-09-03 18:16:22', '2015-08-31 21:13:05', '7', '0', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('12', '1', 'Common', '数据库配置', '', 'icon-database', '2015-09-03 18:16:41', '2015-07-25 17:04:49', '1', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('13', '0', '', '后台配置', '', '', '2015-09-03 18:13:50', '2015-07-25 17:04:49', '98', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('15', '13', 'Admin|Qiye', '表单令牌', '开启表单令牌能防止数据重复提交', 'icon-accept', '2015-09-03 18:18:24', '2015-07-25 17:04:49', '97', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('16', '13', 'Admin|Qiye', '数据备份', '', 'icon-databases', '2015-09-03 18:18:33', '2015-07-25 17:04:49', '96', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('17', '13', 'Admin|Qiye', '组件配置', '', 'icon-plugin', '2015-09-03 18:18:43', '2015-07-25 17:04:49', '86', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('18', '13', 'Admin|Qiye', 'cookie设置', '', 'icon-zone', '2015-09-03 18:23:58', '2015-09-03 18:20:12', '70', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('19', '13', 'Admin|Qiye', '上传配置', '', 'icon-file', '2015-09-03 18:24:13', '2015-07-25 17:04:49', '54', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('20', '13', 'Admin|Qiye', '验证码', '', 'icon-nuclear', '2015-09-03 18:24:20', '2015-07-25 17:04:49', '38', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('27', '23', 'Home', '模板配置', '', 'icon-zone', '2015-12-29 11:30:58', '2015-12-29 11:30:58', '1', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('22', '13', 'Admin|Qiye', '其他配置', '', 'icon-zone', '2015-09-03 15:12:45', '2015-07-28 19:56:30', '1', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('23', '0', '', '前台配置', '', 'icon-house', '2015-08-07 09:16:49', '2015-08-07 09:11:12', '1', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('24', '23', 'Home', '网站配置', '', '', '2015-12-29 11:30:41', '2015-08-07 09:11:57', '1', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('25', '23', 'Home', 'SEO配置', '', '', '2015-08-11 17:30:36', '2015-08-07 09:12:07', '1', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('26', '23', 'Home', '验证码', '', 'icon-projection_screen_present', '2015-09-08 11:28:47', '2015-09-08 11:28:47', '1', '1', '0', '4');
INSERT INTO `mmt_configcate` VALUES ('28', '23', 'Home', '留言配置', '', 'icon-world', '2015-12-29 15:41:00', '2015-12-29 15:41:00', '1', '1', '0', '4');

-- ----------------------------
-- Table structure for `mmt_content`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_content`;
CREATE TABLE `mmt_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '栏目id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `ext` text COMMENT '扩展信息',
  `tpl` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `mark` varchar(255) NOT NULL DEFAULT '' COMMENT '标志',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `guestbook` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '是否允许留言',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='文章基本内容';

-- ----------------------------
-- Records of mmt_content
-- ----------------------------
INSERT INTO `mmt_content` VALUES ('1', '1', '公司简介', '的', '/Public/Image/nb.jpg', '阿斯顿', '{\"test\":\"&lt;p&gt;\\u9501\\u5b9a\\u963f\\u4e09\\u53cd\\u5bf9\\u6cd5&lt;\\/p&gt;\",\"date\":\"\",\"image\":\"\",\"number\":\"\"}', '', '242', 'gsjj', '1451446022', '1447996880', '0', '0', '1');
INSERT INTO `mmt_content` VALUES ('2', '1', '联系我们', '', '/Uploads/image/20151120/564ee62d966b8.png', '', '{\"test\":\"&lt;p&gt;\\u963f\\u65af\\u987f\\u7684\\u963f\\u65af\\u987f\\u53d1&lt;\\/p&gt;\",\"date\":\"\",\"image\":\"\",\"number\":\"\"}', '', '234', 'lxwm', '1451446026', '1448005314', '0', '0', '1');
INSERT INTO `mmt_content` VALUES ('3', '1', '人才招聘', '', '/Uploads/image/20151123/56526cfa38450.gif', '', '{\"test\":\"&lt;p&gt;\\u963f\\u65af\\u987f\\u963f\\u65af\\u987f&lt;\\/p&gt;\",\"date\":\"\",\"image\":\"\",\"number\":\"\"}', '', '13', '', '1451446029', '1448005434', '0', '0', '1');
INSERT INTO `mmt_content` VALUES ('4', '1', '大事记', '', '/Uploads/image/20151120/564ee6391e1d5.jpg', '', '{\"test\":\"&lt;p&gt;\\u9ed8\\u8ba4\\u503c&lt;\\/p&gt;\",\"bool\":\"0\",\"date\":\"2015-09-03\",\"image\":\"\\/Uploads\\/image\\/20151120\\/564ed1117efa8.png\",\"number\":\"\"}', '', '9', '', '1451446032', '1448005661', '0', '0', '1');
INSERT INTO `mmt_content` VALUES ('5', '2', '测试产品', '', '/Uploads/image/20151123/56527058cfd89.gif', '', '{\"price\":\"500\",\"property\":\"\\u89e6\\u6478\\u5c4f\\u7c7b\\u578b|\\u7535\\u5bb9\\u5c4f\\uff0c\\u591a\\u70b9\\u89e6\\u63a7\\r\\n\\u4e3b\\u5c4f|\\u5c3a\\u5bf84.7\\u82f1\\u5bf8\\r\\n\\u4e3b\\u5c4f\\u6750\\u8d28|Retina HD\\r\\n\\u4e3b\\u5c4f\\u5206\\u8fa8\\u7387|1334x750\\u50cf\\u7d20\\r\\n\\u5c4f\\u5e55\\u50cf\\u7d20\\u5bc6\\u5ea6|326ppi\\r\\n\\u5c4f\\u5e55\\u6280\\u672f|3D Touch \\u6280\\u672f\\r\\n\\u7a84\\u8fb9\\u6846|4.29mm\\r\\n\\u5c4f\\u5e55\\u5360\\u6bd4|65.62%\\r\\n\\u64cd\\u4f5c\\u7cfb\\u7edf|iOS 9 \\u7ea0\\u9519\\r\\n\\u6838\\u5fc3\\u6570|\\u53cc\\u6838\\r\\nCPU\\u578b\\u53f7|\\u82f9\\u679c A9+M9\\u534f\\u5904\\u7406\\u5668\\r\\nCPU\\u9891\\u7387|1.8GHz\\r\\n\\u5904\\u7406\\u5668\\u4f4d\\u6570|64\\u4f4d\\r\\nRAM\\u5bb9\\u91cf|2GB\\r\\nROM\\u5bb9\\u91cf|16GB\\/64GB\\/128GB\\r\\n\\u5b58\\u50a8\\u5361|\\u4e0d\\u652f\\u6301\\u5bb9\\u91cf\\u6269\\u5c55\\r\\n\\u7535\\u6c60\\u7c7b\\u578b|\\u4e0d\\u53ef\\u62c6\\u5378\\u5f0f\\u7535\\u6c60\\r\\n\\u7535\\u6c60\\u5bb9\\u91cf|1715mAh\\r\\n\\u7406\\u8bba\\u901a\\u8bdd\\u65f6\\u95f4|840\\u5206\\u949f\\uff083G\\uff09\\r\\n\\u7406\\u8bba\\u5f85\\u673a\\u65f6\\u95f4|240\\u5c0f\\u65f6\",\"images\":\"\\/Public\\/Image\\/logo.png\\r\\n\\/Public\\/Image\\/nb.jpg\"}', '', '44', '', '1451446042', '1448243291', '1', '0', '1');
INSERT INTO `mmt_content` VALUES ('6', '3', '产品说明书', '', '/Uploads/image/20151123/5652721cd5947.gif', '', '{\"attachment\":\"\\/Uploads\\/image\\/20151123\\/5652722492b05.PNG|8dd2ac1d27b5edbf4be882ea9a3b29a5|35540|\\u6355\\u83b7.PNG\\r\\n\\/Uploads\\/image\\/20151123\\/565272298aec7.rar|58a2ea8483549b9d6f40e62a1c390c43|1693|logo-yy.rar\\r\\n\\/Uploads\\/image\\/20151123\\/565280b5e1280.zip|5ed394af31405adfe47c79baf3d60f7f|73837|pure-release-0.6.0.zip\\r\\n\\/Uploads\\/image\\/20151123\\/565280b5e9300.zip|d34936afe7694070ee493b890392c58e|105646|qqConnect_Server_SDK-php_v2.1.zip\\r\\n\\/Uploads\\/image\\/20151123\\/565280b5f306d.zip|4730f52d09b6ef08827cb15023228480|836832|uikit-2.22.0.zip\\r\\n\\/Uploads\\/image\\/20151123\\/565280b6122e2.zip|07b1783aad581aecc99ab2b9d9e79918|825130|zTree-zTree_v3-master.zip\\r\\n\\/Uploads\\/image\\/20151123\\/565280b61d5c5.zip|560e460f6345d70603c0299c4619f3b4|1415026|\\u6709\\u597d\\u7c73\\u57df\\u540d\\u6279\\u91cf\\u67e5\\u8be2.zip\"}', '', '10', '', '1451446037', '1448243755', '0', '0', '1');

-- ----------------------------
-- Table structure for `mmt_contentcate`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_contentcate`;
CREATE TABLE `mmt_contentcate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `model_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '模型id',
  `icon` varchar(255) NOT NULL DEFAULT '' COMMENT '小图标',
  `banner` varchar(255) NOT NULL DEFAULT '' COMMENT '横幅',
  `recursion` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否调用所有子栏目内容',
  `text` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `tpl` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `tpl_detail` varchar(255) NOT NULL DEFAULT '' COMMENT '内容页默认模板',
  `pagenum` tinyint(3) unsigned NOT NULL DEFAULT '20' COMMENT '每页显示的数量',
  `ext` text NOT NULL COMMENT '扩展信息',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='文章分类';

-- ----------------------------
-- Records of mmt_contentcate
-- ----------------------------
INSERT INTO `mmt_contentcate` VALUES ('1', '0', '1', '', '', '1', '公司相关', '公司相关', '', '', '', '20', '', '1448012623', '1447996685', '1', '1');
INSERT INTO `mmt_contentcate` VALUES ('2', '0', '2', '', '', '1', '产品中心', '产品中心', '产品中心', 'index_product', 'detail_product', '20', '', '1448242717', '1448242505', '1', '1');
INSERT INTO `mmt_contentcate` VALUES ('3', '0', '3', '', '', '1', '资料下载', '资料下载', '资料下载', 'index_download', 'detail_download', '20', '', '1448243728', '1448243670', '1', '1');

-- ----------------------------
-- Table structure for `mmt_content_body`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_content_body`;
CREATE TABLE `mmt_content_body` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `body` text NOT NULL COMMENT '内容主体',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='文章详细内容';

-- ----------------------------
-- Records of mmt_content_body
-- ----------------------------
INSERT INTO `mmt_content_body` VALUES ('1', '&lt;p&gt;成都漫漫天网络科技有限公司，曾用名为锦江区漫漫天网络服务中心。公司自成立以来，本着“为企业保驾护航”的经营理念，已逐步得到了广大客户的认可，截止2014年3月份，公司已服务了数百家企业客户。&lt;/p&gt;&lt;p&gt;214年3月11日正式更名为成都漫漫天网络科技有限公司，并扩展业务范围，营业范围正式变更为计算机软件开发、计算机系统集成、网站建设、平面设计、广告设计制作、企业营销策划。全方位为企业提供“从策划到实施的一条龙服务”。&lt;/p&gt;');
INSERT INTO `mmt_content_body` VALUES ('2', '&lt;p&gt;地址:成都锦江区汇融国际E1006&lt;/p&gt;&lt;p&gt;电话:4006306640&lt;/p&gt;');
INSERT INTO `mmt_content_body` VALUES ('3', '&lt;p&gt;打发士大夫大师傅发射点发&lt;/p&gt;');
INSERT INTO `mmt_content_body` VALUES ('4', '&lt;p&gt;阿斯顿发&lt;/p&gt;');
INSERT INTO `mmt_content_body` VALUES ('5', '&lt;p&gt;啊手动阀手动阀&lt;/p&gt;');
INSERT INTO `mmt_content_body` VALUES ('6', '&lt;p&gt;迅雷7(thunder)使用先进的超线程下载技术，在不降低用户体验的前提下，让用户能够以更快的速度从第三方服务器和计算机获取所需的数据文件（ZOL特供迅雷7官方下载）。&lt;/p&gt;&lt;p&gt;迅雷7使用先进的超线程技术基于网格原理，能够将存在于第三方服务器和计算机上的数据文件进行有效整合，通过这种先进的超线程技术，用户能够以更快的速度从第三方服务器和计算机获取所需的数据文件。这种超线程技术还具有互联网下载负载均衡功能，在不降低用户体验的前提下，迅雷网络可以对服务器资源进行均衡，有效降低了服务器负载&lt;/p&gt;&lt;p&gt;迅雷7特点：&lt;/p&gt;&lt;p&gt;采用新一代高性能界面引擎“Bolt”，带给您从容流畅的下载体验&lt;/p&gt;&lt;p&gt;颠覆传统设计，更加便捷的操作流程，让您轻松驾驭迅雷7&lt;/p&gt;&lt;p&gt;超越历史的启动速度，让您的下载从下一秒开始&lt;/p&gt;&lt;p&gt;崇尚个性随意更换外观，让迅雷7跟随您的灵感&lt;/p&gt;&lt;p&gt;全新程序架构，突破传统开发方式打造的迅雷7稳定可靠&lt;/p&gt;&lt;p&gt;迅雷7独有私人医生“迅雷下载诊断工具”，保障迅雷7的品质始终如一&lt;/p&gt;');

-- ----------------------------
-- Table structure for `mmt_datacate`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_datacate`;
CREATE TABLE `mmt_datacate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `text` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `field` varchar(20) NOT NULL DEFAULT '' COMMENT '字段',
  `iconCls` varchar(20) NOT NULL DEFAULT '' COMMENT '图标类',
  `instruction` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '更新时间',
  `create_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '99' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `system` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '系统',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='数据字典分类表';

-- ----------------------------
-- Records of mmt_datacate
-- ----------------------------
INSERT INTO `mmt_datacate` VALUES ('1', '0', '系统字典', '', '未填写', '未填写', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '4');
INSERT INTO `mmt_datacate` VALUES ('3', '1', '附件分类', 'attachtype', '未填写', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '4');
INSERT INTO `mmt_datacate` VALUES ('4', '1', '模板分类', 'tpltype', '', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '4');
INSERT INTO `mmt_datacate` VALUES ('5', '1', '配置类型', 'configtype', '', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '4');
INSERT INTO `mmt_datacate` VALUES ('6', '0', '企业系统', '', '', '', '2015-08-07 09:53:04', '2015-08-07 09:53:04', '1', '1', '4');
INSERT INTO `mmt_datacate` VALUES ('7', '6', '导航实例', 'navexample', '', '', '2015-08-07 09:53:20', '2015-08-07 09:53:20', '1', '1', '4');
INSERT INTO `mmt_datacate` VALUES ('8', '6', '内容调用方式', 'recursion', '', '', '2015-08-13 21:22:20', '2015-08-07 09:55:54', '1', '1', '4');
INSERT INTO `mmt_datacate` VALUES ('9', '1', '自定义字段类型', 'modelfield', '', '', '2015-11-20 14:29:36', '2015-11-20 14:29:36', '1', '1', '4');

-- ----------------------------
-- Table structure for `mmt_datadict`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_datadict`;
CREATE TABLE `mmt_datadict` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `category_id` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `text` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `value` varchar(60) NOT NULL DEFAULT '' COMMENT '标题',
  `instruction` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '更新时间',
  `create_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '创建时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `system` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '系统',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=56 DEFAULT CHARSET=utf8 COMMENT='数据字典表';

-- ----------------------------
-- Records of mmt_datadict
-- ----------------------------
INSERT INTO `mmt_datadict` VALUES ('2', '0', '3', '图片文件', 'jpeg,jpg,gif,bmp,png', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('3', '2', '3', 'JPG', 'jpg', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1');
INSERT INTO `mmt_datadict` VALUES ('4', '2', '3', 'PNG', 'png', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1');
INSERT INTO `mmt_datadict` VALUES ('5', '2', '3', 'GIF', 'gif', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1');
INSERT INTO `mmt_datadict` VALUES ('6', '2', '3', 'BMP', 'bmp', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1');
INSERT INTO `mmt_datadict` VALUES ('7', '2', '3', 'JPEG', 'jpeg', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1');
INSERT INTO `mmt_datadict` VALUES ('8', '0', '3', '视频文件', 'rmvb,rmb,mkv,mp4,3gp,avi', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1');
INSERT INTO `mmt_datadict` VALUES ('9', '8', '3', 'RMVB', 'rmvb', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1');
INSERT INTO `mmt_datadict` VALUES ('10', '8', '3', 'MKV', 'mkv', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1');
INSERT INTO `mmt_datadict` VALUES ('11', '8', '3', 'RMB', 'rmb', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1');
INSERT INTO `mmt_datadict` VALUES ('12', '8', '3', 'AVI', 'avi', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1');
INSERT INTO `mmt_datadict` VALUES ('13', '8', '3', 'MP4', 'mp4', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1');
INSERT INTO `mmt_datadict` VALUES ('14', '8', '3', '3GP', '3gp', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '1');
INSERT INTO `mmt_datadict` VALUES ('15', '0', '4', '前台模板', './Application/Home/View', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('16', '0', '4', '后台模板', './Application/Admin/View', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '0', '3');
INSERT INTO `mmt_datadict` VALUES ('17', '0', '4', 'Css样式', './Public/Css', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('18', '0', '4', 'JS代码', './Public/Js', '', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('19', '0', '5', '字符', 'string', '任意字符\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015-09-08 10:55:39', '2015-07-25 17:04:49', '250', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('20', '0', '5', '文本', 'mulstring', '', '2015-09-08 10:55:47', '2015-09-08 10:54:11', '235', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('21', '0', '5', '数字型', 'number', '\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015-09-08 10:55:54', '2015-07-25 17:04:49', '230', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('22', '0', '5', '布尔型', 'bool', '\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015-09-08 10:55:57', '2015-07-25 17:04:49', '197', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('23', '0', '5', '多条数据', 'item', '一行一条，例如：\r\n中国\r\n日本\r\n韩国\r\n德国\r\n加拿大\r\n朝鲜\r\n美国\r\n新加坡\r\n德国\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015-09-08 10:56:01', '2015-07-25 17:04:49', '189', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('24', '0', '5', 'INI', 'ini', '\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015-09-08 10:56:08', '2015-07-25 17:04:49', '158', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('25', '0', '5', 'JSON', 'json', '标准的json数据格式！\r\n例如：\r\n{\r\n&quot;key1&quot;:&quot;value1&quot;,\r\n&quot;key2&quot;:&quot;value2&quot;\r\n}\r\n例如：\r\n[&quot;value1&quot;,&quot;value2&quot;]\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015-09-08 10:56:12', '2015-07-25 17:04:49', '129', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('26', '0', '5', 'XML', 'xml', '\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015-09-08 10:56:17', '2015-07-25 17:04:49', '101', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('27', '0', '5', 'YAML', 'yaml', '\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '1', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('28', '0', '7', '首页', 'Home/Index/index', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '250', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('35', '0', '7', '内容列表', 'Home/Content/index?id=栏目id', '', '2015-11-23 15:26:31', '0000-00-00 00:00:00', '121', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('36', '35', '7', '内容页', 'Home/Content/detail?id=内容ID', '', '2015-11-23 15:26:54', '0000-00-00 00:00:00', '1', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('38', '0', '7', '留言', 'Home/Guestbook/index', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('39', '0', '8', '不调用', '0', '', '2015-08-13 21:22:43', '2015-08-07 09:56:11', '183', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('40', '0', '8', '当前栏目', '1', '', '2015-08-13 21:24:21', '2015-08-07 09:56:03', '149', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('41', '0', '8', '当前栏目及子栏目', '2', '', '2015-08-13 21:24:24', '2015-08-07 09:57:36', '108', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('42', '0', '8', '所有子孙栏目', '3', '', '2015-08-13 21:24:28', '2015-08-09 21:57:38', '68', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('43', '0', '8', '所有栏目', '4', '', '2015-08-13 21:24:08', '2015-08-13 21:24:08', '1', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('44', '0', '5', '图片', 'image', '', '2015-10-15 09:17:30', '2015-10-15 09:17:12', '1', '1', '4');
INSERT INTO `mmt_datadict` VALUES ('45', '0', '9', '文本框', 'textbox', '', '2015-11-20 14:29:55', '2015-11-20 14:29:55', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('46', '0', '9', '日期', 'datebox', '', '2015-11-20 14:31:23', '2015-11-20 14:31:23', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('47', '0', '9', '日期时间', 'datetimebox', '', '2015-11-20 14:31:32', '2015-11-20 14:31:32', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('48', '0', '9', '数字', 'numberspinner', '', '2015-11-20 16:01:14', '2015-11-20 14:32:47', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('49', '0', '9', '单图', 'image', '', '2015-11-20 14:33:19', '2015-11-20 14:33:19', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('50', '0', '9', '多图', 'images', '', '2015-11-20 14:33:29', '2015-11-20 14:33:29', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('51', '0', '9', '单附件', 'file', '', '2015-11-20 14:33:42', '2015-11-20 14:33:42', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('52', '0', '9', '多文件', 'files', '', '2015-11-20 14:33:49', '2015-11-20 14:33:49', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('53', '0', '9', '百度编辑器', 'ueditor', '', '2015-11-20 14:33:57', '2015-11-20 14:33:57', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('54', '0', '9', '布尔', 'bool', '', '2015-11-20 14:35:27', '2015-11-20 14:35:27', '1', '1', '3');
INSERT INTO `mmt_datadict` VALUES ('55', '0', '9', '下拉选项', 'combotree', '', '2015-11-20 14:35:52', '2015-11-20 14:35:52', '1', '1', '3');

-- ----------------------------
-- Table structure for `mmt_guestbook`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_guestbook`;
CREATE TABLE `mmt_guestbook` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `content_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '内容id',
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT '昵称',
  `mobile` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '手机号码',
  `content` varchar(255) NOT NULL DEFAULT '' COMMENT '留言内容',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `reply` varchar(255) NOT NULL DEFAULT '' COMMENT '回复内容',
  `reply_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '回复时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='留言板';

-- ----------------------------
-- Records of mmt_guestbook
-- ----------------------------
INSERT INTO `mmt_guestbook` VALUES ('1', '3', 'sadf', '15285695565', 'asdfasdf', '1451373357', '', '0', '0', '1');
INSERT INTO `mmt_guestbook` VALUES ('2', '0', 'asdf ', '15245242254', 'sadfasdfasdf', '1451373988', 'sadfasdf', '1451374039', '0', '1');
INSERT INTO `mmt_guestbook` VALUES ('3', '1', '阿斯顿发', '18525425562', '啊手动阀手动阀手动阀手动阀阿斯顿发阿斯顿发', '1451375750', '', '0', '0', '1');

-- ----------------------------
-- Table structure for `mmt_icon`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_icon`;
CREATE TABLE `mmt_icon` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `pid` int(8) unsigned NOT NULL DEFAULT '0',
  `text` varchar(40) NOT NULL DEFAULT '' COMMENT '英文名称',
  `iconcls` varchar(40) NOT NULL DEFAULT '' COMMENT '标题',
  `sort` int(4) unsigned NOT NULL DEFAULT '99' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '锁定',
  `system` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '系统',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=690 DEFAULT CHARSET=utf8 COMMENT='小图标表';

-- ----------------------------
-- Records of mmt_icon
-- ----------------------------
INSERT INTO `mmt_icon` VALUES ('1', '0', 'accept', 'icon-accept', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('2', '0', 'action', 'icon-action', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('3', '0', 'action_add', 'icon-action_add', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('4', '0', 'action_check', 'icon-action_check', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('5', '0', 'action_check_gray', 'icon-action_check_gray', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('6', '0', 'action_remove', 'icon-action_remove', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('7', '0', 'add', 'icon-add', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('8', '0', 'alarm', 'icon-alarm', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('9', '0', 'anchor', 'icon-anchor', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('10', '0', 'application', 'icon-application', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('11', '0', 'application2', 'icon-application2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('12', '0', 'application_add', 'icon-application_add', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('13', '0', 'application_cascade', 'icon-application_cascade', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('14', '0', 'application_delete', 'icon-application_delete', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('15', '0', 'application_double', 'icon-application_double', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('16', '0', 'application_edit', 'icon-application_edit', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('17', '0', 'application_error', 'icon-application_error', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('18', '0', 'application_form', 'icon-application_form', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('19', '0', 'application_get', 'icon-application_get', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('20', '0', 'application_go', 'icon-application_go', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('21', '0', 'application_home', 'icon-application_home', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('22', '0', 'application_key', 'icon-application_key', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('23', '0', 'application_lightning', 'icon-application_lightning', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('24', '0', 'application_link', 'icon-application_link', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('25', '0', 'application_osx', 'icon-application_osx', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('26', '0', 'application_osx_terminal', 'icon-application_osx_terminal', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('27', '0', 'application_put', 'icon-application_put', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('28', '0', 'application_side_boxes', 'icon-application_side_boxes', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('29', '0', 'application_side_contract', 'icon-application_side_contract', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('30', '0', 'application_side_expand', 'icon-application_side_expand', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('31', '0', 'application_side_list', 'icon-application_side_list', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('32', '0', 'application_side_tree', 'icon-application_side_tree', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('33', '0', 'application_split', 'icon-application_split', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('34', '0', 'application_tile_horizontal', 'icon-application_tile_horizontal', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('35', '0', 'application_tile_vertical', 'icon-application_tile_vertical', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('36', '0', 'application_view_columns', 'icon-application_view_columns', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('37', '0', 'application_view_detail', 'icon-application_view_detail', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('38', '0', 'application_view_gallery', 'icon-application_view_gallery', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('39', '0', 'application_view_icons', 'icon-application_view_icons', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('40', '0', 'application_view_list', 'icon-application_view_list', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('41', '0', 'application_view_tile', 'icon-application_view_tile', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('42', '0', 'application_view_xp', 'icon-application_view_xp', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('43', '0', 'application_view_xp_terminal', 'icon-application_view_xp_terminal', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('44', '0', 'arrow_back', 'icon-arrow_back', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('45', '0', 'arrow_branch', 'icon-arrow_branch', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('46', '0', 'arrow_divide', 'icon-arrow_divide', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('47', '0', 'arrow_in', 'icon-arrow_in', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('48', '0', 'arrow_inout', 'icon-arrow_inout', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('49', '0', 'arrow_join', 'icon-arrow_join', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('50', '0', 'arrow_left', 'icon-arrow_left', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('51', '0', 'arrow_merge', 'icon-arrow_merge', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('52', '0', 'arrow_next', 'icon-arrow_next', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('53', '0', 'arrow_out', 'icon-arrow_out', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('54', '0', 'arrow_redo', 'icon-arrow_redo', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('55', '0', 'arrow_refresh', 'icon-arrow_refresh', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('56', '0', 'arrow_right', 'icon-arrow_right', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('57', '0', 'arrow_top', 'icon-arrow_top', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('58', '0', 'arrow_undo', 'icon-arrow_undo', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('59', '0', 'asterisk_orange', 'icon-asterisk_orange', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('60', '0', 'attach', 'icon-attach', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('61', '0', 'attach_2', 'icon-attach_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('62', '0', 'attention', 'icon-attention', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('63', '0', 'award_star_gold', 'icon-award_star_gold', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('64', '0', 'back', 'icon-back', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('65', '0', 'bandaid', 'icon-bandaid', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('66', '0', 'basket', 'icon-basket', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('67', '0', 'bell', 'icon-bell', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('68', '0', 'bin_closed', 'icon-bin_closed', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('69', '0', 'blank', 'icon-blank', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('70', '0', 'blog', 'icon-blog', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('71', '0', 'blueprint', 'icon-blueprint', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('72', '0', 'blueprint_horizontal', 'icon-blueprint_horizontal', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('73', '0', 'bluetooth', 'icon-bluetooth', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('74', '0', 'bomb', 'icon-bomb', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('75', '0', 'book', 'icon-book', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('76', '0', 'book_addresses', 'icon-book_addresses', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('77', '0', 'book_next', 'icon-book_next', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('78', '0', 'book_open', 'icon-book_open', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('79', '0', 'book_previous', 'icon-book_previous', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('80', '0', 'bookmark', 'icon-bookmark', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('81', '0', 'bookmark_book', 'icon-bookmark_book', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('82', '0', 'bookmark_book_open', 'icon-bookmark_book_open', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('83', '0', 'bookmark_document', 'icon-bookmark_document', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('84', '0', 'bookmark_folder', 'icon-bookmark_folder', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('85', '0', 'books', 'icon-books', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('86', '0', 'box', 'icon-box', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('87', '0', 'brick', 'icon-brick', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('88', '0', 'bricks', 'icon-bricks', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('89', '0', 'briefcase', 'icon-briefcase', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('90', '0', 'bug', 'icon-bug', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('91', '0', 'buildings', 'icon-buildings', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('92', '0', 'bullet_add_1', 'icon-bullet_add_1', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('93', '0', 'bullet_add_2', 'icon-bullet_add_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('94', '0', 'bullet_key', 'icon-bullet_key', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('95', '0', 'cake', 'icon-cake', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('96', '0', 'calculator', 'icon-calculator', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('97', '0', 'calendar_1', 'icon-calendar_1', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('98', '0', 'calendar_2', 'icon-calendar_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('99', '0', 'camera', 'icon-camera', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('100', '0', 'cancel', 'icon-cancel', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('101', '0', 'car', 'icon-car', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('102', '0', 'cart', 'icon-cart', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('103', '0', 'cd', 'icon-cd', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('104', '0', 'chart_bar', 'icon-chart_bar', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('105', '0', 'chart_curve', 'icon-chart_curve', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('106', '0', 'chart_line', 'icon-chart_line', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('107', '0', 'chart_organisation', 'icon-chart_organisation', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('108', '0', 'chart_pie', 'icon-chart_pie', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('109', '0', 'clear', 'icon-clear', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('110', '0', 'clipboard_paste_image', 'icon-clipboard_paste_image', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('111', '0', 'clipboard_sign', 'icon-clipboard_sign', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('112', '0', 'clipboard_text', 'icon-clipboard_text', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('113', '0', 'clock', 'icon-clock', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('114', '0', 'cog', 'icon-cog', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('115', '0', 'coins', 'icon-coins', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('116', '0', 'color_swatch_1', 'icon-color_swatch_1', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('117', '0', 'color_swatch_2', 'icon-color_swatch_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('118', '0', 'comment', 'icon-comment', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('119', '0', 'comments', 'icon-comments', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('120', '0', 'compass', 'icon-compass', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('121', '0', 'compress', 'icon-compress', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('122', '0', 'computer', 'icon-computer', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('123', '0', 'connect', 'icon-connect', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('124', '0', 'contrast', 'icon-contrast', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('125', '0', 'control_eject', 'icon-control_eject', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('126', '0', 'control_end', 'icon-control_end', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('127', '0', 'control_equalizer', 'icon-control_equalizer', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('128', '0', 'control_fastforward', 'icon-control_fastforward', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('129', '0', 'control_pause', 'icon-control_pause', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('130', '0', 'control_play', 'icon-control_play', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('131', '0', 'control_repeat', 'icon-control_repeat', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('132', '0', 'control_rewind', 'icon-control_rewind', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('133', '0', 'control_start', 'icon-control_start', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('134', '0', 'control_stop', 'icon-control_stop', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('135', '0', 'control_wheel', 'icon-control_wheel', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('136', '0', 'controller', 'icon-controller', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('137', '0', 'counter', 'icon-counter', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('138', '0', 'counter_count', 'icon-counter_count', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('139', '0', 'counter_count_up', 'icon-counter_count_up', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('140', '0', 'counter_reset', 'icon-counter_reset', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('141', '0', 'counter_stop', 'icon-counter_stop', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('142', '0', 'cross', 'icon-cross', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('143', '0', 'cross_octagon', 'icon-cross_octagon', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('144', '0', 'cross_octagon_fram', 'icon-cross_octagon_fram', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('145', '0', 'cross_shield', 'icon-cross_shield', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('146', '0', 'cross_shield_2', 'icon-cross_shield_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('147', '0', 'crown', 'icon-crown', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('148', '0', 'crown_bronze', 'icon-crown_bronze', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('149', '0', 'crown_silver', 'icon-crown_silver', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('150', '0', 'css', 'icon-css', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('151', '0', 'cursor', 'icon-cursor', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('152', '0', 'cut', 'icon-cut', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('153', '0', 'dashboard', 'icon-dashboard', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('154', '0', 'data', 'icon-data', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('155', '0', 'database', 'icon-database', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('156', '0', 'databases', 'icon-databases', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('157', '0', 'del', 'icon-del', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('158', '0', 'del_gray', 'icon-del_gray', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('159', '0', 'delete', 'icon-delete', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('160', '0', 'delivery', 'icon-delivery', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('161', '0', 'desktop', 'icon-desktop', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('162', '0', 'desktop_empty', 'icon-desktop_empty', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('163', '0', 'direction', 'icon-direction', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('164', '0', 'disconnect', 'icon-disconnect', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('165', '0', 'disk', 'icon-disk', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('166', '0', 'doc_access', 'icon-doc_access', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('167', '0', 'doc_break', 'icon-doc_break', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('168', '0', 'doc_convert', 'icon-doc_convert', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('169', '0', 'doc_excel_csv', 'icon-doc_excel_csv', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('170', '0', 'doc_excel_table', 'icon-doc_excel_table', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('171', '0', 'doc_film', 'icon-doc_film', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('172', '0', 'doc_illustrator', 'icon-doc_illustrator', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('173', '0', 'doc_music', 'icon-doc_music', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('174', '0', 'doc_music_playlist', 'icon-doc_music_playlist', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('175', '0', 'doc_offlice', 'icon-doc_offlice', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('176', '0', 'doc_page', 'icon-doc_page', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('177', '0', 'doc_page_previous', 'icon-doc_page_previous', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('178', '0', 'doc_pdf', 'icon-doc_pdf', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('179', '0', 'doc_photoshop', 'icon-doc_photoshop', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('180', '0', 'doc_resize', 'icon-doc_resize', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('181', '0', 'doc_resize_actual', 'icon-doc_resize_actual', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('182', '0', 'doc_shred', 'icon-doc_shred', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('183', '0', 'doc_stand', 'icon-doc_stand', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('184', '0', 'doc_table', 'icon-doc_table', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('185', '0', 'doc_tag', 'icon-doc_tag', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('186', '0', 'doc_text_image', 'icon-doc_text_image', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('187', '0', 'door', 'icon-door', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('188', '0', 'door_in', 'icon-door_in', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('189', '0', 'doubt', 'icon-doubt', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('190', '0', 'download', 'icon-download', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('191', '0', 'drawer', 'icon-drawer', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('192', '0', 'drink', 'icon-drink', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('193', '0', 'drink_empty', 'icon-drink_empty', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('194', '0', 'drive', 'icon-drive', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('195', '0', 'drive_burn', 'icon-drive_burn', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('196', '0', 'drive_cd', 'icon-drive_cd', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('197', '0', 'drive_cd_empty', 'icon-drive_cd_empty', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('198', '0', 'drive_delete', 'icon-drive_delete', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('199', '0', 'drive_disk', 'icon-drive_disk', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('200', '0', 'drive_error', 'icon-drive_error', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('201', '0', 'drive_go', 'icon-drive_go', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('202', '0', 'drive_link', 'icon-drive_link', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('203', '0', 'drive_network', 'icon-drive_network', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('204', '0', 'drive_rename', 'icon-drive_rename', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('205', '0', 'dvd', 'icon-dvd', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('206', '0', 'edit_add', 'icon-edit_add', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('207', '0', 'edit_remove', 'icon-edit_remove', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('208', '0', 'email', 'icon-email', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('209', '0', 'email_open', 'icon-email_open', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('210', '0', 'email_open_image', 'icon-email_open_image', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('211', '0', 'emoticon_evilgrin', 'icon-emoticon_evilgrin', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('212', '0', 'emoticon_grin', 'icon-emoticon_grin', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('213', '0', 'emoticon_happy', 'icon-emoticon_happy', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('214', '0', 'emoticon_smile', 'icon-emoticon_smile', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('215', '0', 'emoticon_surprised', 'icon-emoticon_surprised', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('216', '0', 'emoticon_tongue', 'icon-emoticon_tongue', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('217', '0', 'emoticon_unhappy', 'icon-emoticon_unhappy', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('218', '0', 'emoticon_waii', 'icon-emoticon_waii', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('219', '0', 'emoticon_wink', 'icon-emoticon_wink', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('220', '0', 'envelope', 'icon-envelope', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('221', '0', 'envelope_2', 'icon-envelope_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('222', '0', 'error', 'icon-error', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('223', '0', 'exclamation', 'icon-exclamation', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('224', '0', 'exclamation_octagon_fram', 'icon-exclamation_octagon_fram', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('225', '0', 'exclamation_octagon_fram_gray', 'icon-exclamation_octagon_fram_gray', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('226', '0', 'eye', 'icon-eye', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('227', '0', 'feed', 'icon-feed', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('228', '0', 'feed_ballon', 'icon-feed_ballon', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('229', '0', 'feed_document', 'icon-feed_document', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('230', '0', 'female', 'icon-female', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('231', '0', 'file', 'icon-file', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('232', '0', 'filesave', 'icon-filesave', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('233', '0', 'film', 'icon-film', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('234', '0', 'films', 'icon-films', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('235', '0', 'filter', 'icon-filter', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('236', '0', 'find', 'icon-find', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('237', '0', 'flag_blue', 'icon-flag_blue', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('238', '0', 'folder', 'icon-folder', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('239', '0', 'folder_files', 'icon-folder_files', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('240', '0', 'folder_open', 'icon-folder_open', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('241', '0', 'font', 'icon-font', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('242', '0', 'foward', 'icon-foward', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('243', '0', 'funnel', 'icon-funnel', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('244', '0', 'grid', 'icon-grid', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('245', '0', 'grid_dot', 'icon-grid_dot', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('246', '0', 'group', 'icon-group', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('247', '0', 'hammer', 'icon-hammer', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('248', '0', 'hammer_screwdriver', 'icon-hammer_screwdriver', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('249', '0', 'hand', 'icon-hand', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('250', '0', 'hand_point', 'icon-hand_point', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('251', '0', 'heart', 'icon-heart', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('252', '0', 'heart_break', 'icon-heart_break', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('253', '0', 'heart_empty', 'icon-heart_empty', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('254', '0', 'heart_half', 'icon-heart_half', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('255', '0', 'heart_small', 'icon-heart_small', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('256', '0', 'help', 'icon-help', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('257', '0', 'highlighter', 'icon-highlighter', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('258', '0', 'house', 'icon-house', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('259', '0', 'html', 'icon-html', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('260', '0', 'image_1', 'icon-image_1', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('261', '0', 'image_2', 'icon-image_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('262', '0', 'images', 'icon-images', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('263', '0', 'inbox', 'icon-inbox', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('264', '0', 'ipod', 'icon-ipod', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('265', '0', 'ipod_cast', 'icon-ipod_cast', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('266', '0', 'joystick', 'icon-joystick', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('267', '0', 'key', 'icon-key', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('268', '0', 'keyboard', 'icon-keyboard', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('269', '0', 'large_arrow_down', 'icon-large_arrow_down', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('270', '0', 'large_arrow_left-down', 'icon-large_arrow_left-down', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('271', '0', 'large_arrow_left-up', 'icon-large_arrow_left-up', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('272', '0', 'large_arrow_left', 'icon-large_arrow_left', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('273', '0', 'large_arrow_right-down', 'icon-large_arrow_right-down', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('274', '0', 'large_arrow_right-up', 'icon-large_arrow_right-up', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('275', '0', 'large_arrow_right', 'icon-large_arrow_right', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('276', '0', 'large_arrow_up', 'icon-large_arrow_up', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('277', '0', 'large_attention', 'icon-large_attention', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('278', '0', 'large_backward', 'icon-large_backward', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('279', '0', 'large_bag', 'icon-large_bag', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('280', '0', 'large_base', 'icon-large_base', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('281', '0', 'large_bonus', 'icon-large_bonus', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('282', '0', 'large_bug', 'icon-large_bug', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('283', '0', 'large_calculator', 'icon-large_calculator', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('284', '0', 'large_calendar', 'icon-large_calendar', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('285', '0', 'large_cd_dvd', 'icon-large_cd_dvd', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('286', '0', 'large_chart', 'icon-large_chart', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('287', '0', 'large_check-64', 'icon-large_check-64', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('288', '0', 'large_check', 'icon-large_check', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('289', '0', 'large_check_2', 'icon-large_check_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('290', '0', 'large_clipart', 'icon-large_clipart', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('291', '0', 'large_close_delete', 'icon-large_close_delete', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('292', '0', 'large_close_delete_2', 'icon-large_close_delete_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('293', '0', 'large_closed', 'icon-large_closed', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('294', '0', 'large_comment', 'icon-large_comment', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('295', '0', 'large_computer', 'icon-large_computer', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('296', '0', 'large_computer_monitor', 'icon-large_computer_monitor', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('297', '0', 'large_copy', 'icon-large_copy', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('298', '0', 'large_credit_card', 'icon-large_credit_card', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('299', '0', 'large_credit_card_back', 'icon-large_credit_card_back', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('300', '0', 'large_cut', 'icon-large_cut', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('301', '0', 'large_delete_2', 'icon-large_delete_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('302', '0', 'large_document_file', 'icon-large_document_file', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('303', '0', 'large_email', 'icon-large_email', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('304', '0', 'large_eraser', 'icon-large_eraser', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('305', '0', 'large_favorite_love', 'icon-large_favorite_love', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('306', '0', 'large_flag_mark_blue', 'icon-large_flag_mark_blue', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('307', '0', 'large_flag_mark_gray', 'icon-large_flag_mark_gray', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('308', '0', 'large_flag_mark_green', 'icon-large_flag_mark_green', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('309', '0', 'large_flag_mark_red', 'icon-large_flag_mark_red', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('310', '0', 'large_flag_mark_violet', 'icon-large_flag_mark_violet', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('311', '0', 'large_flag_mark_yellow', 'icon-large_flag_mark_yellow', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('312', '0', 'large_folder', 'icon-large_folder', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('313', '0', 'large_forward', 'icon-large_forward', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('314', '0', 'large_friends_group', 'icon-large_friends_group', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('315', '0', 'large_help', 'icon-large_help', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('316', '0', 'large_help_ring-buoy', 'icon-large_help_ring-buoy', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('317', '0', 'large_home', 'icon-large_home', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('318', '0', 'large_information', 'icon-large_information', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('319', '0', 'large_ipod', 'icon-large_ipod', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('320', '0', 'large_key_login', 'icon-large_key_login', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('321', '0', 'large_lamp_active', 'icon-large_lamp_active', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('322', '0', 'large_lamp_inactive', 'icon-large_lamp_inactive', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('323', '0', 'large_lock', 'icon-large_lock', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('324', '0', 'large_minus', 'icon-large_minus', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('325', '0', 'large_minus_2', 'icon-large_minus_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('326', '0', 'large_mobile_phone', 'icon-large_mobile_phone', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('327', '0', 'large_network', 'icon-large_network', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('328', '0', 'large_network_close', 'icon-large_network_close', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('329', '0', 'large_new_email', 'icon-large_new_email', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('330', '0', 'large_next', 'icon-large_next', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('331', '0', 'large_opened', 'icon-large_opened', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('332', '0', 'large_options', 'icon-large_options', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('333', '0', 'large_options_2', 'icon-large_options_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('334', '0', 'large_paste', 'icon-large_paste', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('335', '0', 'large_pause', 'icon-large_pause', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('336', '0', 'large_pencil_edit', 'icon-large_pencil_edit', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('337', '0', 'large_picture', 'icon-large_picture', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('338', '0', 'large_pie-chart_diagram', 'icon-large_pie-chart_diagram', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('339', '0', 'large_pie-chart_graph', 'icon-large_pie-chart_graph', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('340', '0', 'large_play', 'icon-large_play', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('341', '0', 'large_plus', 'icon-large_plus', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('342', '0', 'large_plus_2', 'icon-large_plus_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('343', '0', 'large_previous', 'icon-large_previous', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('344', '0', 'large_printer', 'icon-large_printer', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('345', '0', 'large_radio-button_off', 'icon-large_radio-button_off', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('346', '0', 'large_radio-button_on', 'icon-large_radio-button_on', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('347', '0', 'large_record', 'icon-large_record', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('348', '0', 'large_refresh', 'icon-large_refresh', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('349', '0', 'large_rss', 'icon-large_rss', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('350', '0', 'large_save_as', 'icon-large_save_as', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('351', '0', 'large_save_diskette_floppy_disk', 'icon-large_save_diskette_floppy_disk', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('352', '0', 'large_search_lense', 'icon-large_search_lense', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('353', '0', 'large_shapes', 'icon-large_shapes', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('354', '0', 'large_shield_protect_off', 'icon-large_shield_protect_off', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('355', '0', 'large_shield_protect_on', 'icon-large_shield_protect_on', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('356', '0', 'large_shopping_cart', 'icon-large_shopping_cart', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('357', '0', 'large_shopping_cart_empty', 'icon-large_shopping_cart_empty', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('358', '0', 'large_smartart', 'icon-large_smartart', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('359', '0', 'large_smartphone_2', 'icon-large_smartphone_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('360', '0', 'large_smartphone_iphone', 'icon-large_smartphone_iphone', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('361', '0', 'large_sound_music-off', 'icon-large_sound_music-off', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('362', '0', 'large_sound_music-on', 'icon-large_sound_music-on', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('363', '0', 'large_star', 'icon-large_star', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('364', '0', 'large_star_2', 'icon-large_star_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('365', '0', 'large_star_3', 'icon-large_star_3', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('366', '0', 'large_stop', 'icon-large_stop', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('367', '0', 'large_stop_2', 'icon-large_stop_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('368', '0', 'large_tag_blue', 'icon-large_tag_blue', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('369', '0', 'large_tag_gray', 'icon-large_tag_gray', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('370', '0', 'large_tag_green', 'icon-large_tag_green', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('371', '0', 'large_tag_orange', 'icon-large_tag_orange', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('372', '0', 'large_tag_red', 'icon-large_tag_red', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('373', '0', 'large_tag_violet', 'icon-large_tag_violet', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('374', '0', 'large_tag_white', 'icon-large_tag_white', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('375', '0', 'large_tag_yellow', 'icon-large_tag_yellow', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('376', '0', 'large_time_clock', 'icon-large_time_clock', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('377', '0', 'large_trash_box', 'icon-large_trash_box', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('378', '0', 'large_trash_box_2', 'icon-large_trash_box_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('379', '0', 'large_unlock', 'icon-large_unlock', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('380', '0', 'large_user_friend', 'icon-large_user_friend', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('381', '0', 'large_user_woman', 'icon-large_user_woman', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('382', '0', 'large_vote_no', 'icon-large_vote_no', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('383', '0', 'large_vote_yes', 'icon-large_vote_yes', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('384', '0', 'large_wizard', 'icon-large_wizard', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('385', '0', 'layer_treansparent', 'icon-layer_treansparent', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('386', '0', 'layers', 'icon-layers', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('387', '0', 'layout', 'icon-layout', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('388', '0', 'layout_header_footer_3', 'icon-layout_header_footer_3', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('389', '0', 'layout_header_footer_3_mix', 'icon-layout_header_footer_3_mix', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('390', '0', 'layout_join', 'icon-layout_join', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('391', '0', 'layout_join_vertical', 'icon-layout_join_vertical', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('392', '0', 'layout_select', 'icon-layout_select', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('393', '0', 'layout_select_content', 'icon-layout_select_content', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('394', '0', 'layout_select_footer', 'icon-layout_select_footer', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('395', '0', 'layout_select_sidebar', 'icon-layout_select_sidebar', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('396', '0', 'layout_split', 'icon-layout_split', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('397', '0', 'layout_split_vertical', 'icon-layout_split_vertical', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('398', '0', 'letter', 'icon-letter', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('399', '0', 'letter_open', 'icon-letter_open', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('400', '0', 'lifebuoy', 'icon-lifebuoy', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('401', '0', 'lightbulb', 'icon-lightbulb', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('402', '0', 'lightbulb_off', 'icon-lightbulb_off', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('403', '0', 'lightning', 'icon-lightning', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('404', '0', 'link', 'icon-link', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('405', '0', 'link_break', 'icon-link_break', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('406', '0', 'listen', 'icon-listen', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('407', '0', 'lock', 'icon-lock', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('408', '0', 'lock_gray', 'icon-lock_gray', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('409', '0', 'lock_unlock', 'icon-lock_unlock', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('410', '0', 'login', 'icon-login', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('411', '0', 'magnet', 'icon-magnet', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('412', '0', 'magnifier', 'icon-magnifier', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('413', '0', 'magnifier_zoom_in', 'icon-magnifier_zoom_in', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('414', '0', 'male', 'icon-male', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('415', '0', 'man', 'icon-man', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('416', '0', 'map', 'icon-map', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('417', '0', 'marker', 'icon-marker', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('418', '0', 'maximize', 'icon-maximize', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('419', '0', 'medal_bronze_1', 'icon-medal_bronze_1', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('420', '0', 'medal_gold_1', 'icon-medal_gold_1', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('421', '0', 'media_player_small_blue', 'icon-media_player_small_blue', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('422', '0', 'microphone', 'icon-microphone', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('423', '0', 'mini_add', 'icon-mini_add', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('424', '0', 'mini_edit', 'icon-mini_edit', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('425', '0', 'mini_refresh', 'icon-mini_refresh', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('426', '0', 'minimize', 'icon-minimize', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('427', '0', 'mobile_phone', 'icon-mobile_phone', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('428', '0', 'money', 'icon-money', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('429', '0', 'money_dollar', 'icon-money_dollar', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('430', '0', 'money_euro', 'icon-money_euro', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('431', '0', 'money_pound', 'icon-money_pound', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('432', '0', 'money_yen', 'icon-money_yen', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('433', '0', 'monitor', 'icon-monitor', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('434', '0', 'mouse', 'icon-mouse', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('435', '0', 'music', 'icon-music', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('436', '0', 'music_beam', 'icon-music_beam', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('437', '0', 'neutral', 'icon-neutral', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('438', '0', 'new', 'icon-new', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('439', '0', 'newspaper', 'icon-newspaper', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('440', '0', 'no', 'icon-no', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('441', '0', 'note', 'icon-note', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('442', '0', 'nuclear', 'icon-nuclear', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('443', '0', 'offline', 'icon-offline', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('444', '0', 'ok', 'icon-ok', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('445', '0', 'online', 'icon-online', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('446', '0', 'options', 'icon-options', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('447', '0', 'package', 'icon-package', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('448', '0', 'page', 'icon-page', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('449', '0', 'page_2', 'icon-page_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('450', '0', 'page_2_copy', 'icon-page_2_copy', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('451', '0', 'page_code', 'icon-page_code', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('452', '0', 'page_copy', 'icon-page_copy', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('453', '0', 'page_excel', 'icon-page_excel', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('454', '0', 'page_lightning', 'icon-page_lightning', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('455', '0', 'page_paste', 'icon-page_paste', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('456', '0', 'page_red', 'icon-page_red', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('457', '0', 'page_refresh', 'icon-page_refresh', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('458', '0', 'page_save', 'icon-page_save', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('459', '0', 'page_white_cplusplus', 'icon-page_white_cplusplus', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('460', '0', 'page_white_csharp', 'icon-page_white_csharp', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('461', '0', 'page_white_cup', 'icon-page_white_cup', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('462', '0', 'page_white_database', 'icon-page_white_database', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('463', '0', 'page_white_delete', 'icon-page_white_delete', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('464', '0', 'page_white_dvd', 'icon-page_white_dvd', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('465', '0', 'page_white_edit', 'icon-page_white_edit', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('466', '0', 'page_white_error', 'icon-page_white_error', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('467', '0', 'page_white_excel', 'icon-page_white_excel', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('468', '0', 'page_white_find', 'icon-page_white_find', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('469', '0', 'page_white_flash', 'icon-page_white_flash', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('470', '0', 'page_white_freehand', 'icon-page_white_freehand', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('471', '0', 'page_white_gear', 'icon-page_white_gear', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('472', '0', 'page_white_get', 'icon-page_white_get', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('473', '0', 'page_white_paintbrush', 'icon-page_white_paintbrush', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('474', '0', 'page_white_paste', 'icon-page_white_paste', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('475', '0', 'page_white_php', 'icon-page_white_php', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('476', '0', 'page_white_picture', 'icon-page_white_picture', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('477', '0', 'page_white_powerpoint', 'icon-page_white_powerpoint', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('478', '0', 'page_white_put', 'icon-page_white_put', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('479', '0', 'page_white_ruby', 'icon-page_white_ruby', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('480', '0', 'page_white_stack', 'icon-page_white_stack', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('481', '0', 'page_white_star', 'icon-page_white_star', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('482', '0', 'page_white_swoosh', 'icon-page_white_swoosh', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('483', '0', 'page_white_text', 'icon-page_white_text', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('484', '0', 'page_white_text_width', 'icon-page_white_text_width', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('485', '0', 'page_white_tux', 'icon-page_white_tux', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('486', '0', 'page_white_vector', 'icon-page_white_vector', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('487', '0', 'page_white_visualstudio', 'icon-page_white_visualstudio', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('488', '0', 'page_white_width', 'icon-page_white_width', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('489', '0', 'page_white_word', 'icon-page_white_word', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('490', '0', 'page_white_world', 'icon-page_white_world', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('491', '0', 'page_white_wrench', 'icon-page_white_wrench', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('492', '0', 'page_white_zip', 'icon-page_white_zip', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('493', '0', 'paintbrush', 'icon-paintbrush', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('494', '0', 'paintcan', 'icon-paintcan', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('495', '0', 'palette', 'icon-palette', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('496', '0', 'paper_bag', 'icon-paper_bag', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('497', '0', 'paste_plain', 'icon-paste_plain', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('498', '0', 'paste_word', 'icon-paste_word', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('499', '0', 'pencil', 'icon-pencil', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('500', '0', 'pencil_gray', 'icon-pencil_gray', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('501', '0', 'photo', 'icon-photo', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('502', '0', 'photo_album', 'icon-photo_album', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('503', '0', 'photos', 'icon-photos', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('504', '0', 'piano', 'icon-piano', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('505', '0', 'picture', 'icon-picture', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('506', '0', 'pilcrow', 'icon-pilcrow', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('507', '0', 'pill', 'icon-pill', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('508', '0', 'pin', 'icon-pin', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('509', '0', 'pipette', 'icon-pipette', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('510', '0', 'plaing_card', 'icon-plaing_card', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('511', '0', 'plug', 'icon-plug', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('512', '0', 'plugin', 'icon-plugin', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('513', '0', 'print', 'icon-print', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('514', '0', 'printer', 'icon-printer', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('515', '0', 'projection_screen', 'icon-projection_screen', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('516', '0', 'projection_screen_present', 'icon-projection_screen_present', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('517', '0', 'rainbow', 'icon-rainbow', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('518', '0', 'redo', 'icon-redo', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('519', '0', 'reload', 'icon-reload', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('520', '0', 'reply', 'icon-reply', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('521', '0', 'report', 'icon-report', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('522', '0', 'rocket', 'icon-rocket', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('523', '0', 'rosette', 'icon-rosette', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('524', '0', 'rss', 'icon-rss', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('525', '0', 'ruby', 'icon-ruby', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('526', '0', 'ruler_1', 'icon-ruler_1', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('527', '0', 'ruler_2', 'icon-ruler_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('528', '0', 'ruler_crop', 'icon-ruler_crop', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('529', '0', 'ruler_triangle', 'icon-ruler_triangle', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('530', '0', 'safe', 'icon-safe', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('531', '0', 'save', 'icon-save', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('532', '0', 'script', 'icon-script', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('533', '0', 'search', 'icon-search', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('534', '0', 'selection', 'icon-selection', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('535', '0', 'selection_select', 'icon-selection_select', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('536', '0', 'server', 'icon-server', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('537', '0', 'shading', 'icon-shading', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('538', '0', 'shape_aling_bottom', 'icon-shape_aling_bottom', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('539', '0', 'shape_aling_center', 'icon-shape_aling_center', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('540', '0', 'shape_aling_left', 'icon-shape_aling_left', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('541', '0', 'shape_aling_middle', 'icon-shape_aling_middle', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('542', '0', 'shape_aling_right', 'icon-shape_aling_right', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('543', '0', 'shape_aling_top', 'icon-shape_aling_top', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('544', '0', 'shape_flip_horizontal', 'icon-shape_flip_horizontal', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('545', '0', 'shape_flip_vertical', 'icon-shape_flip_vertical', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('546', '0', 'shape_group', 'icon-shape_group', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('547', '0', 'shape_handles', 'icon-shape_handles', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('548', '0', 'shape_move_back', 'icon-shape_move_back', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('549', '0', 'shape_move_backwards', 'icon-shape_move_backwards', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('550', '0', 'shape_move_forwards', 'icon-shape_move_forwards', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('551', '0', 'shape_move_front', 'icon-shape_move_front', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('552', '0', 'shape_square', 'icon-shape_square', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('553', '0', 'shield', 'icon-shield', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('554', '0', 'shoppingcart', 'icon-shoppingcart', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('555', '0', 'sitemap', 'icon-sitemap', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('556', '0', 'slide', 'icon-slide', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('557', '0', 'slides', 'icon-slides', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('558', '0', 'slides_stack', 'icon-slides_stack', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('559', '0', 'smiley_confuse', 'icon-smiley_confuse', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('560', '0', 'smiley_cool', 'icon-smiley_cool', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('561', '0', 'smiley_cry', 'icon-smiley_cry', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('562', '0', 'smiley_fat', 'icon-smiley_fat', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('563', '0', 'smiley_mad', 'icon-smiley_mad', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('564', '0', 'smiley_red', 'icon-smiley_red', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('565', '0', 'smiley_roll', 'icon-smiley_roll', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('566', '0', 'smiley_slim', 'icon-smiley_slim', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('567', '0', 'smiley_yell', 'icon-smiley_yell', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('568', '0', 'socket', 'icon-socket', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('569', '0', 'sockets', 'icon-sockets', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('570', '0', 'sort', 'icon-sort', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('571', '0', 'sort_alphabet', 'icon-sort_alphabet', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('572', '0', 'sort_date', 'icon-sort_date', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('573', '0', 'sort_disable', 'icon-sort_disable', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('574', '0', 'sort_number', 'icon-sort_number', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('575', '0', 'sort_price', 'icon-sort_price', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('576', '0', 'sort_quantity', 'icon-sort_quantity', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('577', '0', 'sort_rating', 'icon-sort_rating', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('578', '0', 'sound', 'icon-sound', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('579', '0', 'sound_note', 'icon-sound_note', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('580', '0', 'spellcheck', 'icon-spellcheck', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('581', '0', 'sport_8ball', 'icon-sport_8ball', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('582', '0', 'sport_basketball', 'icon-sport_basketball', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('583', '0', 'sport_football', 'icon-sport_football', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('584', '0', 'sport_golf', 'icon-sport_golf', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('585', '0', 'sport_raquet', 'icon-sport_raquet', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('586', '0', 'sport_shuttlecock', 'icon-sport_shuttlecock', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('587', '0', 'sport_soccer', 'icon-sport_soccer', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('588', '0', 'sport_tennis', 'icon-sport_tennis', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('589', '0', 'stamp', 'icon-stamp', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('590', '0', 'star_1', 'icon-star_1', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('591', '0', 'star_2', 'icon-star_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('592', '0', 'status', 'icon-status', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('593', '0', 'status_online', 'icon-status_online', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('594', '0', 'stop', 'icon-stop', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('595', '0', 'stopplay', 'icon-stopplay', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('596', '0', 'style', 'icon-style', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('597', '0', 'sum', 'icon-sum', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('598', '0', 'sum_2', 'icon-sum_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('599', '0', 'switch', 'icon-switch', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('600', '0', 'tab', 'icon-tab', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('601', '0', 'table', 'icon-table', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('602', '0', 'tag', 'icon-tag', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('603', '0', 'tag_blue', 'icon-tag_blue', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('604', '0', 'target', 'icon-target', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('605', '0', 'telephone', 'icon-telephone', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('606', '0', 'television', 'icon-television', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('607', '0', 'text_align_center', 'icon-text_align_center', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('608', '0', 'text_align_justify', 'icon-text_align_justify', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('609', '0', 'text_align_left', 'icon-text_align_left', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('610', '0', 'text_align_right', 'icon-text_align_right', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('611', '0', 'text_allcaps', 'icon-text_allcaps', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('612', '0', 'text_bold', 'icon-text_bold', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('613', '0', 'text_columns', 'icon-text_columns', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('614', '0', 'text_dropcaps', 'icon-text_dropcaps', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('615', '0', 'text_heading_1', 'icon-text_heading_1', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('616', '0', 'text_horizontalrule', 'icon-text_horizontalrule', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('617', '0', 'text_indent', 'icon-text_indent', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('618', '0', 'text_indent_remove', 'icon-text_indent_remove', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('619', '0', 'text_italic', 'icon-text_italic', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('620', '0', 'text_kerning', 'icon-text_kerning', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('621', '0', 'text_letter_omega', 'icon-text_letter_omega', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('622', '0', 'text_letterspacing', 'icon-text_letterspacing', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('623', '0', 'text_linespacing', 'icon-text_linespacing', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('624', '0', 'text_list_bullets', 'icon-text_list_bullets', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('625', '0', 'text_list_numbers', 'icon-text_list_numbers', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('626', '0', 'text_lowercase', 'icon-text_lowercase', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('627', '0', 'text_padding_bottom', 'icon-text_padding_bottom', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('628', '0', 'text_padding_left', 'icon-text_padding_left', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('629', '0', 'text_padding_right', 'icon-text_padding_right', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('630', '0', 'text_padding_top', 'icon-text_padding_top', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('631', '0', 'text_signature', 'icon-text_signature', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('632', '0', 'text_smallcaps', 'icon-text_smallcaps', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('633', '0', 'text_strikethrough', 'icon-text_strikethrough', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('634', '0', 'text_subscript', 'icon-text_subscript', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('635', '0', 'textfield', 'icon-textfield', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('636', '0', 'textfield_rename', 'icon-textfield_rename', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('637', '0', 'ticket', 'icon-ticket', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('638', '0', 'time', 'icon-time', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('639', '0', 'timeline_marker', 'icon-timeline_marker', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('640', '0', 'tip', 'icon-tip', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('641', '0', 'toend', 'icon-toend', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('642', '0', 'tostart', 'icon-tostart', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('643', '0', 'traffic', 'icon-traffic', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('644', '0', 'transmit', 'icon-transmit', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('645', '0', 'trophy', 'icon-trophy', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('646', '0', 'trophy_bronze', 'icon-trophy_bronze', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('647', '0', 'trophy_silver', 'icon-trophy_silver', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('648', '0', 'ui_combo_box', 'icon-ui_combo_box', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('649', '0', 'ui_saccordion', 'icon-ui_saccordion', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('650', '0', 'ui_slider_1', 'icon-ui_slider_1', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('651', '0', 'ui_slider_2', 'icon-ui_slider_2', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('652', '0', 'ui_tab_bottom', 'icon-ui_tab_bottom', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('653', '0', 'ui_tab_content', 'icon-ui_tab_content', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('654', '0', 'ui_tab_disable', 'icon-ui_tab_disable', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('655', '0', 'ui_tab_side', 'icon-ui_tab_side', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('656', '0', 'ui_text_field_hidden', 'icon-ui_text_field_hidden', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('657', '0', 'ui_text_field_password', 'icon-ui_text_field_password', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('658', '0', 'umbrella', 'icon-umbrella', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('659', '0', 'undo', 'icon-undo', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('660', '0', 'unlock', 'icon-unlock', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('661', '0', 'unlock_gray', 'icon-unlock_gray', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('662', '0', 'unstatus', 'icon-unstatus', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('663', '0', 'user', 'icon-user', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('664', '0', 'user_black_female', 'icon-user_black_female', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('665', '0', 'user_business', 'icon-user_business', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('666', '0', 'user_business_boss', 'icon-user_business_boss', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('667', '0', 'user_female', 'icon-user_female', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('668', '0', 'user_silhouette', 'icon-user_silhouette', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('669', '0', 'user_thief', 'icon-user_thief', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('670', '0', 'user_thief_baldie', 'icon-user_thief_baldie', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('671', '0', 'vcard', 'icon-vcard', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('672', '0', 'vector', 'icon-vector', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('673', '0', 'wait', 'icon-wait', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('674', '0', 'wall', 'icon-wall', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('675', '0', 'wall_break', 'icon-wall_break', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('676', '0', 'wall_brick', 'icon-wall_brick', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('677', '0', 'wall_disable', 'icon-wall_disable', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('678', '0', 'wand', 'icon-wand', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('679', '0', 'weather_clouds', 'icon-weather_clouds', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('680', '0', 'weather_cloudy', 'icon-weather_cloudy', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('681', '0', 'weather_lightning', 'icon-weather_lightning', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('682', '0', 'weather_rain', 'icon-weather_rain', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('683', '0', 'weather_snow', 'icon-weather_snow', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('684', '0', 'weather_sun', 'icon-weather_sun', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('685', '0', 'webcam', 'icon-webcam', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('686', '0', 'world', 'icon-world', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('687', '0', 'zone', 'icon-zone', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('688', '0', 'zone_money', 'icon-zone_money', '99', '1', '1', '1');
INSERT INTO `mmt_icon` VALUES ('689', '0', 'zones', 'icon-zones', '99', '1', '1', '1');

-- ----------------------------
-- Table structure for `mmt_link`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_link`;
CREATE TABLE `mmt_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `info` varchar(255) NOT NULL DEFAULT '' COMMENT '其他信息',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '连接地址',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='友情链接';

-- ----------------------------
-- Records of mmt_link
-- ----------------------------
INSERT INTO `mmt_link` VALUES ('1', '漫漫天网络科技', '', '', '', 'http://www.manmantian.com', '1448248214', '1448248214', '1', '1');

-- ----------------------------
-- Table structure for `mmt_menu`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_menu`;
CREATE TABLE `mmt_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '菜菜单ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `type` varchar(20) NOT NULL DEFAULT '' COMMENT '类型',
  `text` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `module` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `controller` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `action` varchar(255) NOT NULL DEFAULT '',
  `param` varchar(250) NOT NULL DEFAULT '' COMMENT '附加参数',
  `state` varchar(6) NOT NULL DEFAULT 'closed',
  `iconcls` varchar(40) NOT NULL DEFAULT '' COMMENT '图标',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '更新时间',
  `create_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '99' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `system` tinyint(1) NOT NULL DEFAULT '0' COMMENT '系统',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=96 DEFAULT CHARSET=utf8 COMMENT='功能菜单表';

-- ----------------------------
-- Records of mmt_menu
-- ----------------------------
INSERT INTO `mmt_menu` VALUES ('2', '95', 'admin', '功能菜单', 'Admin', 'Menu', 'index', '', '', 'icon-sitemap', '2015-12-29 15:03:24', '2015-07-25 17:04:49', '3', '1', '4');
INSERT INTO `mmt_menu` VALUES ('6', '72', 'admin', '附件管理', 'Admin', 'Attachment', 'index', '', 'open', 'icon-attach', '2015-12-29 11:01:38', '2015-07-25 17:04:49', '45', '1', '3');
INSERT INTO `mmt_menu` VALUES ('7', '95', 'admin', '数据字典', 'Admin', 'Datadict', 'index', '', 'open', 'icon-databases', '2015-12-29 15:02:27', '2015-07-25 17:04:49', '90', '0', '3');
INSERT INTO `mmt_menu` VALUES ('8', '95', 'admin', '配置管理', 'Admin', 'Config', 'index', '', 'open', 'icon-options', '2015-12-29 15:02:31', '2015-07-25 17:04:49', '81', '1', '3');
INSERT INTO `mmt_menu` VALUES ('13', '95', 'admin', '模板管理', 'Admin', 'Template', 'index', '', 'open', 'icon-layout', '2015-12-29 15:04:01', '2015-07-25 17:04:49', '95', '1', '3');
INSERT INTO `mmt_menu` VALUES ('72', '0', 'admin', '基本管理', '', '', '', '', 'open', 'icon-rainbow', '2015-11-23 11:23:47', '2015-07-25 17:04:49', '98', '1', '4');
INSERT INTO `mmt_menu` VALUES ('94', '72', 'admin', '模型管理', 'Qiye', 'Model', 'index', '', 'open', 'icon-zone', '2015-12-29 15:03:43', '2015-11-20 12:04:14', '1', '1', '3');
INSERT INTO `mmt_menu` VALUES ('95', '0', 'admin', '系统管理', '', '', '', '', 'open', 'icon-server', '2015-11-23 11:24:24', '2015-11-23 11:23:39', '77', '1', '4');
INSERT INTO `mmt_menu` VALUES ('75', '72', 'admin', '内容管理', 'Qiye', 'Content', 'index', '', 'open', 'icon-layout_header_footer_3_mix', '2015-11-20 12:04:31', '2015-07-25 17:04:49', '99', '1', '3');
INSERT INTO `mmt_menu` VALUES ('79', '72', 'admin', '导航管理', 'Qiye', 'Nav', 'index', '', 'open', 'icon-plugin', '2015-11-20 12:05:05', '2015-07-25 17:04:49', '70', '1', '3');
INSERT INTO `mmt_menu` VALUES ('80', '72', 'admin', '友情链接', 'Qiye', 'Link', 'index', '', 'open', 'icon-projection_screen', '2015-11-20 12:05:00', '2015-07-25 17:04:49', '83', '1', '3');
INSERT INTO `mmt_menu` VALUES ('81', '72', 'admin', '留言中心', 'Qiye', 'Guestbook', 'index', '', 'open', 'icon-comment', '2015-11-20 12:04:47', '2015-07-25 17:04:49', '91', '1', '3');
INSERT INTO `mmt_menu` VALUES ('83', '72', 'admin', '轮播管理', 'Qiye', 'Slide', 'index', '', 'open', 'icon-layout_join', '2015-11-20 12:04:52', '2015-07-25 17:04:49', '96', '1', '3');
INSERT INTO `mmt_menu` VALUES ('92', '95', 'admin', '备份优化', 'Admin', 'Database', 'index', '', 'open', 'icon-databases', '2015-12-29 15:04:12', '2015-07-25 17:04:49', '93', '1', '3');

-- ----------------------------
-- Table structure for `mmt_model`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_model`;
CREATE TABLE `mmt_model` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `text` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `instruction` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `iconcls` varchar(255) NOT NULL DEFAULT '' COMMENT '图标',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '更新时间',
  `create_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '创建时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='模型表';

-- ----------------------------
-- Records of mmt_model
-- ----------------------------
INSERT INTO `mmt_model` VALUES ('1', '0', '单页模型', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '1');
INSERT INTO `mmt_model` VALUES ('2', '0', '产品模型', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '1');
INSERT INTO `mmt_model` VALUES ('3', '0', '下载模型', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0', '1');

-- ----------------------------
-- Table structure for `mmt_modelfield`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_modelfield`;
CREATE TABLE `mmt_modelfield` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `model_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `text` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '配置项',
  `value` text COMMENT '配置值',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '类型配置',
  `instruction` text COMMENT '说明',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '更新时间',
  `create_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '99' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='模型字段表';

-- ----------------------------
-- Records of mmt_modelfield
-- ----------------------------
INSERT INTO `mmt_modelfield` VALUES ('6', '2', '参数', 'property', '', 'textbox', 'multiline:true,height:200', '一行一个，用‘|’分割，例如：\r\n重量|300kg\r\n长度|10m\r\n产地|河北武汉', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '85', '1');
INSERT INTO `mmt_modelfield` VALUES ('7', '2', '产品图', 'images', '', 'images', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '67', '1');
INSERT INTO `mmt_modelfield` VALUES ('8', '2', '售价', 'price', '', 'numberspinner', 'min:0', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '98', '1');
INSERT INTO `mmt_modelfield` VALUES ('9', '3', '附件', 'attachment', '', 'files', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', '1');

-- ----------------------------
-- Table structure for `mmt_nav`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_nav`;
CREATE TABLE `mmt_nav` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `pid` int(10) unsigned NOT NULL COMMENT '父ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'category_id 冗余',
  `text` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '连接地址',
  `ext` text NOT NULL COMMENT '扩展信息',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='导航表';

-- ----------------------------
-- Records of mmt_nav
-- ----------------------------
INSERT INTO `mmt_nav` VALUES ('1', '0', '1', '首页', 'Home/Index/index', '', '1444876432', '1448243807', '99', '1');
INSERT INTO `mmt_nav` VALUES ('2', '0', '1', '公司简介', 'Home/Content/detail?id=1', '', '1444876444', '1448243810', '93', '1');
INSERT INTO `mmt_nav` VALUES ('9', '0', '1', '产品中心', 'Home/Content/index?id=2', '', '1448243842', '1448261421', '64', '1');
INSERT INTO `mmt_nav` VALUES ('8', '0', '1', '联系我们', 'Home/Content/detail?id=2', '', '1448011028', '1448243813', '83', '1');
INSERT INTO `mmt_nav` VALUES ('7', '0', '1', '留言', 'Home/Guestbook/index', '', '1444876512', '1444876512', '1', '1');
INSERT INTO `mmt_nav` VALUES ('10', '0', '1', '资料下载', 'Home/Content/index?id=3', '', '1448243888', '1448243888', '50', '1');

-- ----------------------------
-- Table structure for `mmt_nav_category`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_nav_category`;
CREATE TABLE `mmt_nav_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `mark` varchar(255) NOT NULL DEFAULT '' COMMENT '标识',
  `text` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='导航分类表';

-- ----------------------------
-- Records of mmt_nav_category
-- ----------------------------
INSERT INTO `mmt_nav_category` VALUES ('1', 'top', '顶部导航', '1444876423', '1444876423', '1', '1');

-- ----------------------------
-- Table structure for `mmt_slide`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_slide`;
CREATE TABLE `mmt_slide` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `mark` varchar(255) NOT NULL DEFAULT '' COMMENT '标志',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `slide` text NOT NULL,
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='轮播图表';

-- ----------------------------
-- Records of mmt_slide
-- ----------------------------
INSERT INTO `mmt_slide` VALUES ('1', 'banner', '顶部轮播', '/Public/Image/logo.png\r\n/Public/Image/nb.jpg', '1444876688', '1444876635', '1');

-- ----------------------------
-- Table structure for `mmt_user`
-- ----------------------------
DROP TABLE IF EXISTS `mmt_user`;
CREATE TABLE `mmt_user` (
  `id` int(3) unsigned NOT NULL AUTO_INCREMENT COMMENT '后台人员ID',
  `username` char(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '密码',
  `login_times` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '登陆次数',
  `login_ip` varchar(15) NOT NULL DEFAULT '' COMMENT '登陆ip地址',
  `login_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '最后登陆时间',
  `update_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '更新时间',
  `create_time` datetime NOT NULL DEFAULT '1970-01-01 00:00:00' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '99' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`username`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='后台用户表';

-- ----------------------------
-- Records of mmt_user
-- ----------------------------
INSERT INTO `mmt_user` VALUES ('1', 'admin', 'f9c202f6438dbcb14e71451046b1e4de', '540', '0', '2015-12-30 09:44:13', '2015-07-25 17:04:49', '2015-07-25 17:04:49', '99', '1');
