<?php
namespace Qiye\RelationModel;
use Think\Model\RelationModel;
class ContentRelationModel extends RelationModel{
	
	protected $tableName = 'content';

	/* 自动验证规则 */
	protected $_validate = array(
		array('id', 'number', '非法提交', self::MUST_VALIDATE, 'regex', self::MODEL_UPDATE),
		array('title', '1,40', '标题字数介于0-40字', self::MUST_VALIDATE, 'length', self::MODEL_BOTH),
		array('description', '0,255', '简介不得超过255个字', self::VALUE_VALIDATE , 'length', self::MODEL_BOTH)
	);

	// 自动完成规则
	protected $_auto = array (
		array('ext','json_encode',3,'function'),
		array('create_time','time',1,'function'),
		array('update_time','time',3,'function'),
		array('status',0,1),
	);

	// 关联模型
	protected $_link = array(
		'content_body'=> array(
			'mapping_type'=> self::HAS_ONE,
			'foreign_key'=>'id',
			'class_name'=>'content_body',
			'mapping_name'=>'content_body'
		),
		'contentcate'=> array(
			'mapping_type'=> self::BELONGS_TO,
			'class_name'=>'contentcate',
			'mapping_name'=>'contentcate',
			'foreign_key'=>'category_id',
		)
	);
}