<?php
namespace Qiye\RelationModel;
use Think\Model\RelationModel;
class ContentcateRelationModel extends RelationModel{

	protected $tableName = 'contentcate';

	/* 自动验证规则 */
	protected $_validate = array(
		array('id', 'number', '非法提交', self::MUST_VALIDATE, 'regex', self::MODEL_UPDATE),
		array('text', '1,20', '标题字数介于1-20字', self::MUST_VALIDATE, 'length', self::MODEL_BOTH),
		// array('text', 'unique', '标题不能重复', self::MUST_VALIDATE, 'unique', self::MODEL_BOTH),
		array('keywords', '1,80', '关键字字数介于1-80字', self::VALUE_VALIDATE, 'length', self::MODEL_BOTH),
		array('description', '1,255', '描述字数介于1-255字', self::VALUE_VALIDATE, 'length', self::MODEL_BOTH),
	);

	// 自动完成规则
	protected $_auto = array (
		array('ext','ext_to_json',3,'function'),
		array('update_time','time',3,'function'),
		array('create_time','time',1,'function'),
		array('status',1,1),
	);

	protected $_link = array(
		'content'=> array(
			'mapping_type'=> self::HAS_MANY,
			'class_name'=>'content',
			'mapping_name'=>'content',
			'foreign_key'=>'category_id'
		)
	);

}