<?php
namespace Qiye\RelationModel;
use Think\Model\RelationModel;
class ModelfieldRelationModel extends RelationModel{
	
	protected $tableName = 'modelfield';

	/* 自动验证规则 */
	protected $_validate = array(
		array('id', 'number', '非法提交', self::MUST_VALIDATE, 'regex', self::MODEL_UPDATE),
		array('text', '1,40', '标题字数介于0-40字', self::MUST_VALIDATE, 'length', self::MODEL_BOTH),
		array('instruction', '0,255', '简介不得超过255个字', self::VALUE_VALIDATE , 'length', self::MODEL_BOTH)
	);

	// 自动完成规则
	protected $_auto = array (
		array('create_time','time',1,'function'),
		array('update_time','time',3,'function'),
		array('status',0,1),
	);

	// 关联模型
	protected $_link = array(
		'model'=> array(
			'mapping_type'=> self::BELONGS_TO,
			'class_name'=>'model',
			'mapping_name'=>'model',
			'foreign_key'=>'model_id',
		)
	);
}