$.extend($.fn.dialog.defaults,{
	height:'600',
	resizable:true,
	closed:true,
	modal:true,
	onLoad:function(){
		$(this).dialog('doLayout');
	},
	onLoadError:function(){
		MMT.MSG.show('加载失败！请重试');
	}
});
$.extend($.fn.tree.defaults,{
	loadFilter:function(data,parentId){
		if (data.status==0) {
			MMT.MSG.alert(data.info);
		};
		var opt = $(this).data().tree.options;
		if (opt.parentField) {
			var idField = opt.idField || 'id',
			textField = opt.textField || 'text',
			rootItem = opt.rootItem || false,
			parentField = opt.parentField;
			return MMT.FN.array2tree(data,idField,textField,parentField,rootItem);
		}else if(opt.datadict){
			var rootItem = opt.rootItem || false;
			return MMT.FN.datadict2tree(data,rootItem);
		}
		return data;
	},
});
$.extend($.fn.combotree.defaults,{
	width:'100%',
	loadFilter:function(data,parentId){
		if (data.status==0) {
			MMT.MSG.alert(data.info);
		};
		var opt = $(this).data().tree.options;
		if (opt.parentField) {
			var idField = opt.idField || 'id',
			textField = opt.textField || 'text',
			rootItem = opt.rootItem || false,
			parentField = opt.parentField;
			return MMT.FN.array2tree(data,idField,textField,parentField,rootItem);
		}else if(opt.datadict){
			var rootItem = opt.rootItem || false;
			return MMT.FN.datadict2tree(data,rootItem);
		}
		return data;
	},
});
$.extend($.fn.textbox.defaults,{
	width:'100%',
});
$.extend($.fn.slider.defaults,{
	width:'100%',
});
$.extend($.fn.numberspinner.defaults,{
	width:'100%',
});
$.extend($.fn.numberbox.defaults,{
	width:'100%',
});
$.extend($.fn.combobox.defaults,{
	editable:false,
	width:'100%',
});
$.extend($.fn.tabs.defaults,{
	cache:false,
	height:'570',
	onLoad:function(panel){
		try{
			data = jQuery.parseJSON(panel.context.innerHTML);
			panel.context.innerHTML = null;
			MMT.MSG.alert(data.info);
		}catch(e){
		}
	}
});
$.extend($.fn.datagrid.defaults,{
	fit:true,
	fitColumns:true,
	rownumbers:true,
	singleSelect:true,
	selectOnCheck:false,
	checkOnSelect:false,
	border:false,
	sortName:'sort',
	sortOrder:'desc',
	pagination:true,
	pageSize:20,
	pageList:[10,20,30,40,50,100,200,500,1000],
	loadFilter:function(data){
		if (data.status!=undefined) {
			MMT.MSG.alert(data.info);
		};
		return data;
	},
	onSelect:function(index,row){
		var contain = $(this).attr('id').replace(/datagrid/g, '');
		MMT[contain].selectedIndex = index;
		MMT[contain].selectedData = row;
	},
	onDblClickRow:function(index,row){
		var contain = $(this).attr('id').replace(/datagrid/g, '');
		MMT[contain].startSave(row.id);
	},
	onHeaderContextMenu:function(e, field){
		var contain = $(this).attr('id').replace(/datagrid/g, '');
		e.preventDefault();
		if (undefined==MMT[contain].TableHeadMenu) {
			MMT.EUI.fetchheadmenu(contain,'datagrid');
			MMT[contain].TableHeadMenu = MMT.FN.createTableHeadMenu(contain,'datagrid');
		};
        $('#'+contain+'datagridHeadMenu').menu('show', {
            left:e.pageX-2,
            top:e.pageY-2
        });
	},
	onRowContextMenu:function(e,index,row){
		var contain = $(this).attr('id').replace(/datagrid/g, '');
		e.preventDefault();
		$(this).datagrid('selectRow',index);
		$('#'+contain+'datagridMenu').menu('show', {
			left: e.pageX-2,
			top: e.pageY-2
		});
	},
});
$.extend($.fn.treegrid.defaults,{
	fit:true,
	rownumbers:true,
	singleSelect:true,
	selectOnCheck:false,
	checkOnSelect:false,
	border:false,
	sortName:'sort',
	sortOrder:'desc',
	idField:'id',
	treeField:'text',
	parentField:'pid',
	onSelect:function(row){
		var contain = $(this).attr('id').replace(/treegrid/g, '');
		MMT[contain].selectedIndex = row.id;
		MMT[contain].selectedData = row;
	},
	onDblClickRow:function(node){
		var contain = $(this).attr('id').replace(/treegrid/g, '');
		MMT[contain].startSave(node.id);
	},
	onHeaderContextMenu:function(e, field){
		var contain = $(this).attr('id').replace(/treegrid/g, '');
		e.preventDefault();
		if (undefined==MMT[contain].TableHeadMenu) {
			MMT.EUI.fetchheadmenu(contain,'treegrid');
			MMT[contain].TableHeadMenu = MMT.FN.createTableHeadMenu(contain,'treegrid');
		};
        $('#'+contain+'treegridHeadMenu').menu('show', {
            left:e.pageX-2,
            top:e.pageY-2
        });
	},
	onContextMenu:function(e, node){
		var contain = $(this).attr('id').replace(/treegrid/g, '');
		e.preventDefault();
		$('#'+contain+'treegrid').treegrid('unselectAll');
		$('#'+contain+'treegrid').treegrid('select',node.id);
		$('#'+contain+'treegridMenu').menu('show', {
			left: e.pageX-2,
			top: e.pageY-2
		});
	},
	loadFilter:function(data, parentId){
		if (data.status!=undefined) {
			MMT.MSG.alert(data.info);
		};
		var opt = $(this).data().treegrid.options;
		if (opt.parentField) {
			var idField = opt.idField || 'id',
			textField = opt.textField || 'text',
			rootItem = opt.rootItem || false,
			parentField = opt.parentField;
			return MMT.FN.array2tree(data,idField,textField,parentField,rootItem);
		}else if(opt.datadict){
			var rootItem = opt.rootItem || false;
			return MMT.FN.datadict2tree(data,rootItem);
		}
		return data;
	},
});