<?php
	class alipayset{
		//==========================================
		// 函数: getSet()
		// 功能: 获取需要设置的信息数组
		// 参数: 无
		// 返回: 需要对系统进行设置的选择数组
		//==========================================
		static function getSet(){
			$varList = array(
					 "partner"		=> PARTNER,
					 "seller"		=> SELLER,
					 "key"		=> KEY,
					 "weburl"		=> WEBURL
				 );
			return $varList;
		}

		//==========================================
		// 函数: writeConfig($fileName,$post)
		// 功能: 用于将用户输入的设置信息改写配置文件
		// 参数: fileName是配置文件的名称，和需要设置的内容数组
		// 返回: true或false
		//==========================================
		static function writeConfig($post){
			$confile=PROJECT_PATH."config.inc.php";
			$configText = file_get_contents($confile);
			$reg=array(
					"/define\(\"PARTNER\".+?;/i",
					"/define\(\"SELLER\".+?;/i",
					"/define\(\"KEY\".+?;/i",
					"/define\(\"WEBURL\".+?;/i"
				);
			$rep=array(
					"define(\"PARTNER\", \"{$post['partner']}\");",
					"define(\"SELLER\", \"{$post['seller']}\");",
					"define(\"KEY\", \"{$post['key']}\");",
					"define(\"WEBURL\", \"{$post['weburl']}\");"
				);
			return file_put_contents($confile, preg_replace($reg, $rep, $configText));
		}
	}

