<?php
	class Cart{
		//购物列表
		function index() {
			$this->caching=0;
			$this->assign("appname", APP_NAME);
			$this->assign("keywords", KEYWORD);
			$this->assign("description", DESCRIPTION);
			$this->assign("icp",ICP);
			$this->assign("copy",COPY);

			//导航
			$menu = D('menu');
			$globallink = $menu->field('id,title,url,target')->order('ord asc')->where(array('pid'=>0,'display'=>1))->r_select(array("menu",'id,title,url,target','pid',array('men','ord asc','',"display=1")));
			$this->assign('globallink',$globallink);

			//焦点图
			$banner = D('banner');
			$ban = $banner->where(array('display'=>1,'ord'=>array(0,1,2,3,4,5)))->order('ord asc')->select();
			$this->assign('ban',$ban);
			
			//友情链接
			$this->assign("links", D("flink")->field('id, webname,url,logo,list')->where(array("audit"=>1))->order("ord asc")->select());
			
			$this->assign('cart',$_SESSION["shoplist"]);
			//P($_SESSION["shoplist"]);
			$this->display();
		}
		
		//添加商品
		function add() {
			$photo = D('photo');
			$shop = $photo->field('id,uid,title,pic,memberprice')->find($_GET['id']);
			if($shop){
				$shop["num"]=1;//添加一个数量的字段
				if(isset($_SESSION["shoplist"][$shop['id']])){
					//若存在数量加加
					$_SESSION["shoplist"][$shop['id']]["num"]++;
				}else{
					//若不存在，作为新购买的商品添加到购物车中
					$_SESSION["shoplist"][$shop['id']]=$shop;
				}
			}else{
				$this->error('未找到指定商品或商品未审核',3,'index/index');
			}
			$this->redirect('index');
		}
		
		//修改购物车
		function update(){
			$id =$_GET['id'];
			$num = $_GET['num'];
			//修改商品信息的数量
			$_SESSION["shoplist"][$id]["num"]+=$num;
			//防止商品数量过小
			if($_SESSION["shoplist"][$id]["num"]<1){
				$_SESSION["shoplist"][$id]["num"]=1;
			}
		}
		
		//移除除购物车商品
		function clearcart(){
			if($_GET['id']){
				unset($_SESSION["shoplist"][$_GET['id']]);
			}else{
				unset($_SESSION["shoplist"]);
			}
			$this->redirect('index');
		}
		//结算页
		function customer() {
			$this->caching=0;
			
			$this->assign("appname", APP_NAME);
			$this->assign("keywords", KEYWORD);
			$this->assign("description", DESCRIPTION);
			$this->assign("icp",ICP);
			$this->assign("copy",COPY);

			//导航
			$menu = D('menu');
			$globallink = $menu->field('id,title,url,target')->order('ord asc')->where(array('pid'=>0,'display'=>1))->r_select(array("menu",'id,title,url,target','pid',array('men','ord asc','',"display=1")));
			$this->assign('globallink',$globallink);

			//焦点图
			$banner = D('banner');
			$ban = $banner->where(array('display'=>1,'ord'=>array(0,1,2,3,4,5)))->order('ord asc')->select();
			$this->assign('ban',$ban);
			
			//友情链接
			$this->assign("links", D("flink")->field('id, webname,url,logo,list')->where(array("audit"=>1))->order("ord asc")->select());
			
			if($_SESSION["login"]==1){
				$this->assign("ordernum",proRandName());
				$this->assign("payment",D("payment")->where(array('audit'=>1))->select());//支付方式
				$this->assign("ems",D("ems")->where(array('audit'=>1))->select());//配送方式
				$this->assign("fegconfig",D("fegconfig")->find());//配送方式
				$this->assign('cart',$_SESSION["shoplist"]);
				$this->assign("user",$_SESSION['user']);
				$this->display();			
			}else{
				$this->redirect('login/index','mark/1');
			}

		}
		//提交定单
		function pay() {
			$this->caching=0;
 			$orders = D('orders');
			$orderdetails = D('orderdetails');
			$order = $orders->field('id,ordersn')->where(array('ordersn'=>$_POST['ordersn']))->find();
			if(!$order){
				$_POST['posttime']=time();
				$_POST['address'] = $_POST['region1'].$_POST['region2'].$_POST['region3'].$_POST['address'];
				$orderid = $orders->insert($_POST,1,1);//返回订单ID
				if($orderid){
					foreach($_SESSION["shoplist"] as $v){
						$data = array(
							"orderid"=>$orderid,
							"proid"=>$v['id'],
							"proname"=>$v['title'],
							"pic"=>$v['pic'],
							"unitprice"=>$v['memberprice'],
							"quantity"=>$v['num']
						);
						$orderdetails->insert($data);
					}
					unset($_SESSION["shoplist"]);//清空购物车
					//转向付款页
					$this->assign("data",$orders->where(array('id'=>$orderid))->find());
					$this->assign("weburl",WEBURL);
					$this->display();
				}else{
					$this->error($orders->getMsg(),3,"customer");
				}			
			}else{
				//转向付款页
				$this->assign("data",$orders->where(array('ordersn'=>$_POST['ordersn']))->find());
				$this->display();				
			}

		}
	}