-- --------------------------------------------------
-- 文件名: yixun.sql 
-- YiXunCMS数据库安装文件
-- 作者： 易迅软件
-- --------------------------------------------------

# --------------------------------------------------------
# 表的结构 yx_about,该表用于单页信息
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_about;
CREATE TABLE IF NOT EXISTS yx_about (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `content` text,
  `audit` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `about_audit` (`audit`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_activex,该表用于插件信息
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_activex;
CREATE TABLE IF NOT EXISTS yx_activex (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(80) NOT NULL,
  `content` text,
  `audit` smallint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `activex_audit` (`audit`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_album,该表用于相册信息
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_album;
CREATE TABLE IF NOT EXISTS yx_album (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `path` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `display` smallint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `album_pid` (`pid`),
  KEY `album_display` (`path`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_article,该表用于文章信息
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_article;
CREATE TABLE IF NOT EXISTS yx_article (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `summary` varchar(300) NOT NULL DEFAULT '',
  `posttime` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `comefrom` varchar(50) NOT NULL DEFAULT '',
  `content` text,
  `keyword` varchar(20) NOT NULL DEFAULT '',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `audit` smallint(1) unsigned NOT NULL DEFAULT '0',
  `recommend` smallint(1) unsigned NOT NULL DEFAULT '0',
  `allow` smallint(1) unsigned NOT NULL DEFAULT '1',
  `views` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `article_title` (`title`),
  KEY `article_uid` (`uid`),
  KEY `article_pid` (`pid`),
  KEY `article_audit` (`audit`),
  KEY `article_recommend` (`recommend`),
  KEY `article_allow` (`allow`),
  KEY `article_keyword` (`keyword`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_banner,该表用于焦点图
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_banner;
CREATE TABLE IF NOT EXISTS yx_banner (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(80) NOT NULL,
  `pic` char(24) NOT NULL,
  `links` varchar(100) NOT NULL,
  `display` smallint(1) NOT NULL DEFAULT '1',
  `ord` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `banner_ord` (`ord`),
  KEY `banner_display` (`display`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_board,该表用于留言
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_board;
CREATE TABLE IF NOT EXISTS yx_board (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `nickname` varchar(50) NOT NULL DEFAULT '',
  `telephone` varchar(11) NOT NULL DEFAULT '0',
  `address` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `msn` varchar(20) DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `posttime` int(10) unsigned NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_column,该表用于文章栏目
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_column;
CREATE TABLE IF NOT EXISTS yx_column (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `path` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `audit` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  `display` smallint(3) unsigned NOT NULL DEFAULT '1',
  `callid` smallint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `column_pid` (`pid`),
  KEY `column_path` (`path`),
  KEY `column_audit` (`audit`),
  KEY `column_ord` (`ord`),
  KEY `column_display` (`display`),
  KEY `column_callid` (`callid`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_comment,该表用于商品评论
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_comment;
CREATE TABLE IF NOT EXISTS yx_comment (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `user` int(10) NOT NULL DEFAULT '0',
  `content` text,
  `posttime` int(10) unsigned NOT NULL DEFAULT '0',
  `audit` smallint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `comment_pid` (`pid`),
  KEY `comment_audit` (`audit`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_ems,该表用于快递方式
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_ems;
CREATE TABLE IF NOT EXISTS yx_ems (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(20) NOT NULL DEFAULT '',
  `ems` varchar(20) NOT NULL DEFAULT '',
  `audit` smallint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `ems_audit` (`audit`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_fegconfig,该表用于运费配置
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_fegconfig;
CREATE TABLE IF NOT EXISTS yx_fegconfig (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `freight` decimal(8,2) NOT NULL DEFAULT '0.00',
  `free` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_flink,该表用于友情链接
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_flink;
CREATE TABLE IF NOT EXISTS yx_flink (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `webname` varchar(30) NOT NULL DEFAULT '',
  `url` varchar(60) NOT NULL DEFAULT '',
  `logo` varchar(60) NOT NULL DEFAULT '',
  `rname` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `dtime` int(10) unsigned NOT NULL DEFAULT '0',
  `msg` varchar(200) NOT NULL DEFAULT '',
  `list` smallint(1) unsigned NOT NULL DEFAULT '0',
  `audit` smallint(1) unsigned NOT NULL DEFAULT '0',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `flink_audit` (`audit`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_fun,该表用于扩展
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_fun;
CREATE TABLE IF NOT EXISTS yx_fun (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `content` text,
  `audit` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fun_audit` (`audit`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_group,该表用于用户组
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_group;
CREATE TABLE IF NOT EXISTS yx_group (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `groupname` varchar(20) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `useradmin` tinyint(1) NOT NULL DEFAULT '0',
  `webadmin` tinyint(1) NOT NULL DEFAULT '0',
  `articleadmin` tinyint(1) NOT NULL DEFAULT '0',
  `sendcomment` tinyint(1) NOT NULL DEFAULT '0',
  `photoadmin` tinyint(1) NOT NULL DEFAULT '0',
  `jobadmin` tinyint(1) NOT NULL DEFAULT '0',
  `boardadmin` tinyint(1) NOT NULL DEFAULT '0',
  `funadmin` tinyint(1) NOT NULL DEFAULT '0',
  `memberadmin` tinyint(1) NOT NULL DEFAULT '0',
  `shopadmin` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_image,该表用于相片
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_image;
CREATE TABLE IF NOT EXISTS yx_image (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(4) unsigned NOT NULL DEFAULT '0',
  `name` char(24) NOT NULL DEFAULT '',
  `title` varchar(80) NOT NULL,
  `thumb` tinyint(1) NOT NULL DEFAULT '0',
  `water` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `image_pid` (`pid`),
  KEY `image_title` (`title`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_job,该表用于招聘信息
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_job;
CREATE TABLE IF NOT EXISTS yx_job (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL DEFAULT '',
  `address` varchar(50) NOT NULL DEFAULT '',
  `treatment` decimal(8,2) NOT NULL DEFAULT '0.00',
  `number` smallint(5) unsigned NOT NULL DEFAULT '0',
  `starttime` int(10) unsigned NOT NULL DEFAULT '0',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0',
  `content` text,
  PRIMARY KEY (`id`),
  KEY `job_starttime` (`starttime`),
  KEY `job_endtime` (`endtime`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_member,该表用于会员信息
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_member;
CREATE TABLE IF NOT EXISTS yx_member (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL DEFAULT '',
  `userpwd` varchar(40) NOT NULL DEFAULT '',
  `truename` varchar(20) DEFAULT NULL,
  `sex` smallint(3) NOT NULL DEFAULT '0',
  `email` varchar(60) NOT NULL DEFAULT '',
  `mobile` varchar(20) DEFAULT NULL,
  `regtime` int(10) unsigned NOT NULL DEFAULT '0',
  `disable` smallint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `member_username` (`username`),
  KEY `member_userpwd` (`userpwd`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_menu,该表用于导航信息
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_menu;
CREATE TABLE IF NOT EXISTS yx_menu (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(10) NOT NULL,
  `pid` smallint(5) NOT NULL,
  `path` varchar(100) NOT NULL,
  `target` varchar(10) NOT NULL,
  `url` varchar(100) NOT NULL,
  `display` smallint(1) NOT NULL DEFAULT '1',
  `ord` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `menu_pid` (`pid`),
  KEY `menu_display` (`display`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_notice,该表用于公告信息
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_notice;
CREATE TABLE IF NOT EXISTS yx_notice (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(80) NOT NULL DEFAULT '',
  `color` char(6) NOT NULL DEFAULT '000000',
  `starttime` int(10) unsigned NOT NULL DEFAULT '0',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0',
  `content` text,
  `display` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `notice_starttime` (`starttime`),
  KEY `notice_endtime` (`endtime`),
  KEY `notice_display` (`display`),
  KEY `notice_ord` (`ord`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_orderdetails,该表用于订单详情
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_orderdetails;
CREATE TABLE IF NOT EXISTS yx_orderdetails (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `orderid` int(11) unsigned NOT NULL DEFAULT '0',
  `proid` int(10) unsigned NOT NULL DEFAULT '0',
  `proname` varchar(50) NOT NULL DEFAULT '',
  `pic` char(24) NOT NULL DEFAULT '',
  `unitprice` decimal(8,2) NOT NULL DEFAULT '0.00',
  `quantity` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `orderdetails_orderid` (`orderid`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_orders,该表用于订单
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_orders;
CREATE TABLE IF NOT EXISTS yx_orders (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ordersn` varchar(20) NOT NULL DEFAULT '',
  `trade` varchar(80) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(20) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `mobile` varchar(20) NOT NULL DEFAULT '',
  `address` varchar(200) NOT NULL DEFAULT '',
  `postal` varchar(10) DEFAULT '000000',
  `payment` smallint(1) NOT NULL DEFAULT '1',
  `free` decimal(8,2) NOT NULL DEFAULT '0.00',
  `ems` varchar(10) NOT NULL DEFAULT '',
  `bear` varchar(10) NOT NULL DEFAULT '',
  `price` decimal(8,2) NOT NULL DEFAULT '0.00',
  `audit` smallint(1) NOT NULL DEFAULT '1',
  `posttime` int(10) NOT NULL DEFAULT '0',
  `endtime` int(10) NOT NULL DEFAULT '0',
  `unit` varchar(20) NOT NULL DEFAULT '无',
  `unitno` varchar(80) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `orders_payment` (`payment`),
  KEY `orders_ordersn` (`ordersn`),
  KEY `orders_uid` (`uid`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_payment,该表用于支付类型
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_payment;
CREATE TABLE IF NOT EXISTS yx_payment (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(20) NOT NULL DEFAULT '',
  `audit` smallint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `payment_audit` (`audit`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_phcolumn,该表用于展示分类
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_phcolumn;
CREATE TABLE IF NOT EXISTS yx_phcolumn (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `path` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `audit` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  `display` smallint(3) unsigned NOT NULL DEFAULT '1',
  `callid` smallint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `phcolumn_pid` (`pid`),
  KEY `phcolumn_path` (`path`),
  KEY `phcolumn_audit` (`audit`),
  KEY `phcolumn_ord` (`ord`),
  KEY `phcolumn_display` (`display`),
  KEY `phcolumn_callid` (`callid`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_photo,该表用于展示
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_photo;
CREATE TABLE IF NOT EXISTS yx_photo (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `title` varchar(50) NOT NULL DEFAULT '',
  `pic` char(24) NOT NULL DEFAULT '',
  `price` decimal(8,2) NOT NULL DEFAULT '0.00',
  `memberprice` decimal(8,2) NOT NULL DEFAULT '0.00',
  `recommend` smallint(1) unsigned NOT NULL DEFAULT '0',
  `top` smallint(1) unsigned NOT NULL DEFAULT '0',
  `audit` smallint(1) unsigned NOT NULL DEFAULT '0',
  `content` text,
  `views` smallint(5) NOT NULL DEFAULT '0',
  `posttime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `photo_title` (`title`),
  KEY `photo_pid` (`pid`),
  KEY `photo_uid` (`uid`),
  KEY `photo_recommend` (`recommend`),
  KEY `photo_top` (`top`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_play,该表用于幻灯片
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_play;
CREATE TABLE IF NOT EXISTS yx_play (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(11) unsigned NOT NULL DEFAULT '0',
  `title` varchar(80) NOT NULL DEFAULT '',
  `pic` char(24) NOT NULL DEFAULT '',
  `starttime` int(10) unsigned NOT NULL DEFAULT '0',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0',
  `display` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `play_aid` (`aid`),
  KEY `play_starttime` (`starttime`),
  KEY `play_endtime` (`endtime`),
  KEY `play_ord` (`ord`),
  KEY `play_display` (`display`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_user,该表用于用户
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_user;
CREATE TABLE IF NOT EXISTS yx_user (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `gid` smallint(4) unsigned NOT NULL,
  `username` varchar(20) NOT NULL DEFAULT '',
  `userpwd` varchar(40) NOT NULL DEFAULT '',
  `email` varchar(60) NOT NULL DEFAULT '',
  `regtime` int(10) unsigned NOT NULL DEFAULT '0',
  `sex` smallint(3) NOT NULL DEFAULT '0',
  `disable` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_gid` (`gid`),
  KEY `user_username` (`username`),
  KEY `user_userpwd` (`userpwd`),
  KEY `user_disable` (`disable`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_wapmenu,该表用于手机站菜单
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_wapmenu;
CREATE TABLE IF NOT EXISTS yx_wapmenu (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(10) NOT NULL,
  `url` varchar(100) NOT NULL,
  `display` smallint(1) NOT NULL DEFAULT '1',
  `ord` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `wapmenu_ord` (`ord`),
  KEY `wapmenu_display` (`display`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_wappic,该表用于手机站焦点图
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_wappic;
CREATE TABLE IF NOT EXISTS yx_wappic (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(80) NOT NULL,
  `pic` char(24) NOT NULL,
  `links` varchar(100) NOT NULL,
  `ord` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `wappic_ord` (`ord`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;



# --------------------------------------------------------
# 转存表中的数据 `yx_about`
# --------------------------------------------------------
INSERT INTO yx_about (`id`, `title`, `content`, `audit`, `ord`) VALUES
(1, '公司介绍', '<p>易迅软件是一家从事BS架构软件应用及开发的工作团队，专注服务于国内中小型企业单位、各级院校网站平台及WEB应用系统的设计与研发，旨在通过更加简易的搭建过程、更简单的维护特性、更省心的系统升级为用户寻找一种更为高效、经济的建站方式。<br />	目前易迅软件已广泛应用于国内数千家网站，数百家网络公司使用YIXUNCMS系统进行网站搭建，简洁的界面、简易的操作得到了广大企业的认可，被企业称为国内首选的企业网站建设系统。<br />	易迅软件拥有经验丰富的设计和研发团队，规范的软件开发流程。团队秉承简易操作、高效运行的理念注重产品的外观设计、易操作、高效率，易迅软件通过成熟的底层框架技术保证了软件代码的健壮，使得易迅软件无论在稳定性、运行效率、负载能力、安全性等方面都表现出了良好的性能。<br />	我们坚持高效、经济建站的原则，真诚希望与您建立良好的合作伙伴关系，努力提升我们的软件与服务水平，为您节约每一分成本、创造价值。易迅将不断进取，努力打造功能强大、简洁实用的软件，为用户提供满意的软件产品</p>', 1, 0),
(2, '业务范围', '<p>请在后台单页中修改</p>', 1, 1),
(3, '联系我们', '<p>易迅BS软件工作室</p><p>	全国服务热线：15284330477<br />	企鹅：1652368686<br />电子信箱：1652368686@qq.com<br />	官方网址：http://www.ys-bs.com</p>', 1, 2);

# --------------------------------------------------------
# 转存表中的数据 `yx_album`
# --------------------------------------------------------
INSERT INTO yx_album (`id`, `pid`, `path`, `title`, `description`, `display`) VALUES
(1, 0, '0', '装修图库', '感谢您选择使用YIXUNCMS企业网站建设软件，易迅BS软件与您共同进步', 1),
(2, 0, '0', '公司活动', '感谢您选择使用YIXUNCMS企业网站建设软件，易迅BS软件与您共同进步', 1),
(3, 0, '0', '网站用图', '感谢您选择使用YIXUNCMS企业网站建设软件，易迅BS软件与您共同进步', 0);

# --------------------------------------------------------
# 转存表中的数据 `yx_article`
# --------------------------------------------------------
INSERT INTO yx_article (`id`, `title`, `summary`, `posttime`, `uid`, `comefrom`, `content`, `keyword`, `pid`, `audit`, `recommend`, `allow`, `views`) VALUES
(1, 'YIXUNCMS网站建设系统介绍', 'YIXUNCMS网站建设系统是由易迅软件工作室专为中小型企业量身定制开发的一套企业网站建设系统，系统采用目前流行的PHP作为开发语言并搭配性能稳定的MYSQL数据库', 1442497848, 1, 'YIXUNSOFT', '<p>	YIXUNCMS网站建设系统是由易迅软件工作室专为中小型企业量身定制开发的一套企业网站建设系统，系统采用目前流行的PHP作为开发语言并搭配性能稳定的MYSQL数据库，使得系统不仅能布署在WINDOWS主机上，同时也可以布署到LINUX主机上。YIXUNCMS使用成熟的底层框架作为系统支撑，具有极低的CPU及内存消耗使得网站运行更加高效。</p><p>	YIXUNCMS系统从前端设计、制作到程序编写全部由易迅工作室亲自完成，非二次开发，从而有效的保证了代码的健壮、系统的安全及运行效率。YIXUNCMS系统所有代码全部开源、免费，您可以随意下载使用，并根据自己的需求对系统做出调整或二次开发，希望我们的努力能为您的工作带来方便。</p>', 'YIXUNCMS,易迅,PHP源码', 2, 1, 1, 0, 2),
(2, 'YIXUNCMS2.0.4企业建站系统强化版说明', 'YIXUNCMS历经标准版、简约版、时尚版后，8月22日强化版发布，9月1日停止简约版及时尚版的授权工作，强化版是简约版及时敞露版的整合版本并重新优化了前端设计增加了部分管理模块，强化版主要用于企业展示类网站的应用，囊括了基本企业网站最常用的功能，易迅工作室将陆续发布适配模板，彻底解决企业网站在改版、更新方面的后顾之忧。', 1442498706, 1, 'YIXUNSOFT', '<p><br />	YIXUNCMS历经标准版、简约版、时尚版后，8月22日强化版发布，9月1日停止简约版及时尚版的授权工作，强化版是简约版及时敞露版的整合版本并重新优化了前端设计增加了部分管理模块，强化版主要用于企业展示类网站的应用，囊括了基本企业网站最常用的功能，易迅工作室将陆续发布适配模板，彻底解决企业网站在改版、更新方面的后顾之忧。</p>', 'YIXUNCMS,易迅,PHP源码', 2, 1, 1, 0, 1),
(3, '感谢您选择并使用YIXUNCMS2.0.5企业营销版', '2.0.5企业营销版是2.0.4强化版的姊妹版本，是为了适应部分企业在线进行产品销售的需求而特意推出的，2.0.5企业营销版在保留了原所有功能的基础上增设了购物车、会员中心、订单管理、产品评论等相关功能。', 1442498783, 1, 'YIXUNSOFT', '<p>	2.0.5企业营销版是2.0.4强化版的姊妹版本，是为了适应部分企业在线进行产品销售的需求而特意推出的，2.0.5企业营销版在保留了原所有功能的基础上增设了购物车、会员中心、订单管理、产品评论等相关功能，并集成了支付宝担保交易的支付与发货接口，用户只需进行简单设置即可进行产品在线销售与金额交易，同时全面更新了手机版网站的风格样式，使得网站浏览者可以随时随地对商品进行浏览及购买。</p>', 'YIXUNCMS,易迅,PHP源码', 2, 1, 1, 0, 2),
(4, 'YIXUNCMS您值得信赖的企业建站软件', 'YIXUNCMS您值得信赖的企业建站软件', 1442502682, 1, 'YIXUNSOFT', '<p>	YIXUNCMS您值得信赖的企业建站软件</p>', 'YIXUNCMS,易迅,PHP源码', 2, 1, 1, 0, 0),
(5, '易迅工作室助力中国企业步入高速发展快车道', 'YIXUNCMS在开发之初，就将目标定位在了简洁上，使得无论具备专业知识都可以轻松搭建并管理自己的企业站，就像微信的一句广告语：再小的个体也有自己的品牌。我们真诚的希望YIXUNCMS在使用上能给管理者以轻松、一目了然的感觉，使其不拘泥于复杂的管理而纠结。', 1442502735, 1, 'YIXUNSOFT', '<p>	　　YIXUNCMS是一款专门为我国中小型企业设计开发的建站系统，完全开源免费；易迅BS软件工作室一直从事企业网站的设计与开发，在7年的时间里我们发现企业建站的方式各式各样，程序员的水平良莠不齐，一个普通的企业站基本的要求就是前端简洁大方、后台管理方便，因为一般的企业网站均没有专业的网站管理人员，他们对各式各样的网站后台使用感到困惑。</p><p>	　　众多的企业站采用DEDECMS、PHPCMS等开源软件做二次开发，我们并不否认这些开源软件先进性与全面性，但对于大部分没有专业知识的企业人员来说使用功能强大的后台无疑感到棘手、力不从心，而如此功能强大的系统也增加了企业站的体积，用另一方面来讲，企业站的基出功能大同小异，有见于此，我们为何不用一个简洁的系统去完成企业站的功能呢？</p><p>	　　YIXUNCMS在开发之初，就将目标定位在了简洁上，使得无论具备专业知识都可以轻松搭建并管理自己的企业站，就像微信的一句广告语：再小的个体也有自己的品牌。我们真诚的希望YIXUNCMS在使用上能给管理者以轻松、一目了然的感觉，使其不拘泥于复杂的管理而纠结。</p><p>	　　易迅BS软件助力中国企业站更加快速、高效、实用。</p>', 'YIXUNCMS,易迅,PHP源码', 2, 1, 1, 0, 0),
(6, '分享一些关于竞价推广排名的一些技巧', '关键词的质量需要点击的积累，如果关键词还没有产生点击，就把它排在前面，让它创造、积累一定的点击。如果无点击的词没有左栏排名，或排名靠后，这时候就需要提价，让它靠前来增加产生点击的几率。', 1442502949, 1, 'YIXUNSOFT', '<p>	百度竞价推广排名的实用技巧。理论上，如果自己的关键词质量高于对手，出更少的钱也可以排在前面，那么该如何进行价格调整？</p><p>	1、优化关键词的质量度。<br />	首先把自己要调整的词的质量度优化到3星。保证关键词的相关性，URL定位，点击率，价格，和整体账号的运营。对于相关性不大的关键词，把它们区分开来。</p><p>2、排除无点击的词，积累点击。<br />	关键词的质量需要点击的积累，如果关键词还没有产生点击，就把它排在前面，让它创造、积累一定的点击。如果无点击的词没有左栏排名，或排名靠后，这时候就需要提价，让它靠前来增加产生点击的几率。</p><p>3、下调价格的目标是位居首位，且已经有点击的词。<br />	位居首位，显然被顾客点击的次数就会多，但是被同行点击的几率也高，所以尽量不要排在首位，前3就行。而且有点击，就意味着关键词点击这块已经有分了，具有降价的资本。</p><p>	现在有很多企业都选择了竞价软件来帮助自己竞价排名，这样以来也省了许多不麻烦，所以还没有试用的也可以去试用看看。<br /></p>', 'YIXUNCMS,易迅,PHP源码', 3, 1, 1, 0, 0),
(7, '为什么百度不收录你的网站', '现在，百度对于过度优化的网站，惩罚是越来越重的了，网站过度优化会导致百度的收录减少或者是不收录，我们要知道，一个网站内容才是王道，就算外链再好，如果你长时间不更新网站的内容，那百度根本是不会收录你的网站的。', 1442503057, 1, 'YIXUNSOFT', '<p>	站长新建了一个网站，那么一定想要网站能够被快快地收录，最好能够做到秒收，但是很多的时候往往是事与愿违，这是为什么呢？</p><p>	第一：内容重复<br />	这里的内容重复包含了两个方面，分别是文章重复和模板重复。由于采集软件的泛滥，导致现在做网站都变得非常的简单。Nicewords、cms以及自助建站等技术，让很多的站长可以在极短的时间内建设出大量的网站来，加之采集的规则非常的不灵活，凡科看到现在伪原创到处都是，网络上重复的内容太过多了，连人都看腻了，我们还能怪百度蜘蛛不收录你的网站吗？</p><p>第二：网站优化过度<br />	现在，百度对于过度优化的网站，惩罚是越来越重的了，网站过度优化会导致百度的收录减少或者是不收录，我们要知道，一个网站内容才是王道，就算外链再好，如果你长时间不更新网站的内容，那百度根本是不会收录你的网站的。</p><p>第三：网站改版<br />	一个网站经常的改头换面，这会让用户花费大量的时间去重新认识网站，这样百度也会像用户一样，需要一个过程来重新认识改版网站。一个网站既然规划好了，就不要轻易去改动，就算真的修改，也要尽量去保持原来的路径，切忌大刀阔斧的干，否则百度是认不出网站来的，这又会延迟百度对网站的收录。</p><p>第四：主机空间不稳定<br />	网站的主机空间不稳定、网页时不时就打不开，或者是打开网站的时间过长，一旦百度连接网站时无法抓取相关的内容，在凡科看来那百度肯定会将你的网站从数据库中清除掉，因为百度误以为你的网站已经关闭，或者是页面已经不存在了，这样网站也是不会被百度采集的。</p><p>第五：链接<br />	网站的外部链接出现死链接，或者是链接出现在垃圾网站和被降权的网站，这些情况都会导致百度对你的网站减少收录或者是不收录。假如网站里有类似的链接的话，那最好就赶快删除了它。对于链接的添加，也要有规律的，慢慢的添加，切忌链接剧增的情况出现，否则很容易会被搜索引擎判定为作弊。<br />	当然少不了的就是外链资源，链接应做到多样性，那这些资源哪里找呢？其实现在有很多的网站盘点，想b2b网站大全这样的，里面其实都包含了丰富的外链资源，所以就要看你怎么去利用好这些资源啦！</p>', 'YIXUNCMS,易迅,PHP源码', 3, 1, 1, 0, 0),
(8, '怎样发挥出企业网站的价值', '在互联网的带动之下，如今绝大多少的企业都会拥有自己的网站，然而，很多的企业负责人依然是不知道企业网站建设出来能有什么作为，有的企业负责人甚至认为，做网站根本就没有用，还不如将投资网站建设的钱花在线下营销以及广告上。其实，这都是因为他们没有真正的发挥出网站的价值来。', 1442503135, 1, 'YIXUNSOFT', '<p>	在互联网的带动之下，如今绝大多少的企业都会拥有自己的网站，然而，很多的企业负责人依然是不知道企业网站建设出来能有什么作为，有的企业负责人甚至认为，做网站根本就没有用，还不如将投资网站建设的钱花在线下营销以及广告上。其实，这都是因为他们没有真正的发挥出网站的价值来。</p><p>企业网站要有出路，那企业必须意识到要做第一。在网络市场中，每一个企业的机会都是平等的，你想要的问题，别的企业也有可能想到，所以在竞争如此激烈的情况下，要想突围而出，以凡科的经验企业网站一定要做行业中的第一，比如网站的深度第一、网站的服务第一、网站的传播第一、网站的细节第一等。要做到这些第一，不是短时间就可以成功的，你需要对整个行业做一个细致的观察，寻找突破口，用做第一的思维去完善企业网站。</p><p>那具体的手段有哪些呢？<br />	第一：企业网站一定要向用户提供有价值的信息，如果不是必要，请不要加入过多的动画、视频、音频等，访客访问企业网站是要找到想要的信息，而不是要看企业的音乐以及视频。</p><p>	第二：企业网站不能只是建设出来后就放任不管，企业网站要根据实际的情况、市场需求以及各类新闻热点等作及时的更新。</p><p>	第三：要友好的对待每一位访客，要了解访客的需求，收集访客的意见，然后通过整理汇总，反映在网站的改版以及功能的改进上。</p><p>	我们要知道一条道理，罗马不是一天建成的，一个好的企业网站能够成为企业宣传的好工具，企业的盈利机器，但这要求我们用长远的眼光看清企业网站的真正价值，只有这样，企业网站才能做到真正的第一。</p>', 'YIXUNCMS,易迅,PHP源码', 3, 1, 1, 0, 0),
(9, '在推广竞价中有关企业的排名', '当用户通过搜索进入到产品的详细页面之后，如有购买意向，就会想办法找人咨询相关信息，自然就会找到竞价页面里的客服咨询。这就要求网站的客服人员要对产品信息有全方位了解，否则如果客服不熟悉产品，客户咨询之后一知半解或者胡乱回答客户的问题，通过竞价引入进来的客户流量就会白白浪费，简单说就是在浪费钱。', 1442503214, 1, 'YIXUNSOFT', '<p>	当用户通过搜索进入到产品的详细页面之后，如有购买意向，就会想办法找人咨询相关信息，自然就会找到竞价页面里的客服咨询。这就要求网站的客服人员要对产品信息有全方位了解，否则如果客服不熟悉产品，客户咨询之后一知半解或者胡乱回答客户的问题，通过竞价引入进来的客户流量就会白白浪费，简单说就是在浪费钱。</p><p>	所以，网站的竞价客服这个环节也是属于非常重要且不可缺少的一个环节。客服工作做好，对产品销售就会自然产生促进作用。不过，现在也有一部分人也不太重视客服工作，依然盈利很大，前提是你的产品口碑足够好、质量足够优，否则别人不会轻易就相信你。</p><p>	网站的竞价排名，简单说就是首先找到要销售的产品，利用网站排名的差异性，花钱去竞价联盟购买流量，然后进行通过这些流量寻找销售机会，以实现销售产品的目标。在购买竞价联名的时候，因为竞价广告成本较高，这就要求我们必须找到合适的产品和项目用来平衡竞价广告的成本，否则即使你成交订单较多，但是成本太高，结果也是入不敷出。</p><p>	总之，也只有正确做好竞价排名相关的各个方面，找到自己不足的地方加以改正，才能够离盈利这条路越来越近。还有就是使用小脑袋竞价软件来弥补本身的不足。</p>', 'YIXUNCMS,易迅,PHP源码', 3, 1, 1, 0, 0),
(10, '企业做谷歌推广要掌握基本的推广方式和方法', '企业做谷歌推广（www.021google.cn）要掌握基本的推广方式和方法，知道在当前情况下，自己的推广要从何处出发，知道在做这部分工作时，如何做才能确保最终的推广效果，但是企业还有一点是非常需要注意的，那就是绝对不可以任性而为，这样的谷歌推广是会出现失败的痕迹。', 1442503348, 1, 'YIXUNSOFT', '<p>	　　企业做谷歌推广（www.021google.cn）要掌握基本的推广方式和方法，知道在当前情况下，自己的推广要从何处出发，知道在做这部分工作时，如何做才能确保最终的推广效果，但是企业还有一点是非常需要注意的，那就是绝对不可以任性而为，这样的谷歌推广是会出现失败的痕迹。</p><p>	　　以自己为中心?</p><p>	　　企业做谷歌推广是可以以自己为中心的么?肯定不可以，但是有很多企业在做谷歌推广时都会出现这样的情况，那就是认为自己的推广应该以自己为中心，自己说什么就是什么，但是这样的情况肯定是不允许的。企业做谷歌推广要知道用户的需求和喜好，这样做出来的谷歌推广才能让用户乐于接受，最终明晰自己的推广工作效果。</p><p>	　　主观思维为主?</p><p>	　　企业在做谷歌推广时，还应该注意，很多事情并不是依靠企业的主观思想去判断的当前的情况，而是要把这样的数据寻找出来，知道在当前情况下，自己的推广究竟出了什么问题，如果要改正，应该从何处去改正。如果企业单纯依靠自己的主观思维去判断，很容易导致自己的判断出现问题，也会影响企业的推广方向，导致最终的推广效果并不是很好。</p><p>	　　坚持一意孤行?</p><p>	　　企业在做谷歌推广时还应该注意，做谷歌推广是不可以一意孤行的，因为对于企业来说，如果一意孤行，就很容易让自己的推广出现很严重的问题，最终导致企业的推广没有效果，那企业究竟要如何来做这部分工作呢?其实想要把这部分的工作做好非常简单，在做这部分工作时，多去看看其他人是怎么做的，如果别人给予一件，就多思考这个意见的可行性，不要看都不看就放在一边。</p><p>	　　企业在做谷歌推广时如果想要确保效果，应该从以上这些方面出发，知道自己的谷歌推广需要做什么，在做的过程中应该注意什么，绝对不能做的事情有哪些。</p>', 'YIXUNCMS,易迅,PHP源码', 3, 1, 1, 0, 0),
(11, '中小企业如何做好免费推广和付费推广工作', '利用网络树立企业品牌。如依靠谷歌的权威性，建立一个好的谷歌百科，这样可以帮助企业建立一个良好的品牌形象，使客户产生一种信任感。好的谷歌百科给客户以信任感的同时，还能让客户更好的了解自己的企业，是一个不错的产品推广平台。利用网络除了帮助企业建立企业信任品牌以外我们还可以利用网络为客户提供更多的相关。', 1442503402, 1, 'YIXUNSOFT', '<p>	现在网站推广方式有免费和付费两种，那么大家知道中小企业如何才能做好免费推广和付费推广呢?谷歌推广（www.googledaili.net）下面具体分析分析。</p><p>	免费推广的途径</p><p>	这里说的免费是相对付费推广而言的，它并不是说你一分钱不花就能做推广，而是相对付费推广来说投入钱比较少而已。免费推广比较适用于有那些盈利较小的企业，通过这种免费的网络推广方式既能为企业省钱，有在一定程度上达到盈利的目的。</p><p>	下面就向大家介绍一下具体有哪些免费的网络推广方法：</p><p>	1、利用网络树立企业品牌。如依靠谷歌的权威性，建立一个好的谷歌百科，这样可以帮助企业建立一个良好的品牌形象，使客户产生一种信任感。好的谷歌百科给客户以信任感的同时，还能让客户更好的了解自己的企业，是一个不错的产品推广平台。利用网络除了帮助企业建立企业信任品牌以外我们还可以利用网络为客户提供更多的相关。</p><p>	2、发布产品信息。随着个人电脑及网络的普及，现在越来越多的人在购买东西前更多的会在网上搜寻相关需求信息。这时，我们可以通过网络平台发布自己的产品信息，让客户更多更及时的了解我们的公司及相关产品。这种免费的推广方式既有利于提高效率，又有利于增加产品销量，所以很多企业都选择网络营销。</p><p>	付费推广的途径</p><p>	有别于免费推广方式，付费推广是需要花费一定的金钱，是通过有偿付费的方式在网络上投入广告，以此扩大推广范围，从而使企业能更好的在网络上获得更多的盈利。付费推广并不意味在网络上投放一些广告后就一定能获得很好的营销效果那么简单，广告投放也必须有它的方式方法才能取得良好的营销效果，才能将利润最大化，有的放矢的广告营销方案和步骤才是获得营销效果的前提，才能真正帮助企业快速发展。</p><p>	其实免费推广和付费推广的使用还是需要大家根据自身的实际情况来定，这是最基本的。</p>', 'YIXUNCMS,易迅,PHP源码', 3, 1, 1, 0, 1);

# --------------------------------------------------------
# 转存表中的数据 `yx_banner`
# --------------------------------------------------------
INSERT INTO yx_banner (`id`, `title`, `pic`, `links`, `display`, `ord`) VALUES
(1, '第一张焦点图', '1.jpg', '#', 1, 0),
(2, '第二张焦点图', '2.jpg', '#', 1, 1),
(3, '第三张焦点图', '20150430185900_322.jpg', '#', 1, 2);

# --------------------------------------------------------
# 转存表中的数据 `yx_column`
# --------------------------------------------------------
INSERT INTO yx_column (`id`, `pid`, `path`, `title`, `description`, `audit`, `ord`, `display`, `callid`) VALUES
(1, 0, '0', '资讯动态', '资讯动态', 0, 0, 1, 0),
(2, 1, '0-1', '公司动态', '公司动态', 0, 0, 1, 1),
(3, 5, '0-5', '行业资讯', '行业资讯', 0, 0, 1, 1),
(5, 0, '0', '技术文摘', '技术文摘', 0, 0, 1, 0);

# --------------------------------------------------------
# 转存表中的数据 `yx_ems`
# --------------------------------------------------------
INSERT INTO yx_ems (`id`, `title`, `ems`, `audit`) VALUES
(1, '快递', 'EXPRESS', 1),
(2, '平邮', 'POST', 1),
(3, 'EMS', 'EMS', 1);

# --------------------------------------------------------
# 转存表中的数据 `yx_fegconfig`
# --------------------------------------------------------
INSERT INTO yx_fegconfig (`id`, `freight`, `free`) VALUES
(1, '5.00', '2000.00');

# --------------------------------------------------------
# 转存表中的数据 `yx_flink`
# --------------------------------------------------------
INSERT INTO yx_flink (`id`, `webname`, `url`, `logo`, `rname`, `email`, `dtime`, `msg`, `list`, `audit`, `ord`) VALUES
(1, '易迅BS软件', 'http://www.ys-bs.com', 'yixun.gif', '易迅', '1652368686@qq.com', 1440658234, '易迅BS软件', 0, 1, 0);

# --------------------------------------------------------
# 转存表中的数据 `yx_fun`
# --------------------------------------------------------
INSERT INTO yx_fun (`id`, `title`, `content`, `audit`, `ord`) VALUES
(1, '子页联系方式', '<p>	易迅BS软件工作室</p><p>	全国服务热线：15284330477<br />	企鹅：1652368686<br />	电子信箱：1652368686@qq.com<br />	官方网址：http://www.ys-bs.com</p>', 1, 2),
(2, '首页公司概况', '<p>	<img align=left src=http://www.ys-bs.com/yixun.png style=margin-right:10px />　　易迅软件是一家从事BS架构软件应用及开发的工作团队，专注服务于国内中小型企业单位、各级院校网站平台及WEB应用系统的设计与研发，旨在通过更加简易的搭建过程、更简单的维护特性、更省心的系统升级为用户寻找一种更为高效、经济的建站方式。目前易迅软件已广泛应用于国内数千家网站.</p>', 1, 1),
(3, '首页业务范围', '<p>	<img align=left src=http://www.ys-bs.com/204.png style=margin-right:10px />　　2.0.5企业营销版是2.0.4强化版的姊妹版本，是为了迎合部分企业在线进行产品销售而特意推出的，2.0.5企业营销版增设了购物车、会员中心、订单管理、产品评论等相关功能，并集成了支付宝担保交易的支付与发货接口，用户只需进行简单设置即可进行产品在线销售与金额交易.</p>', 1, 0);

# --------------------------------------------------------
# 转存表中的数据 `yx_group`
# --------------------------------------------------------
INSERT INTO yx_group (`id`, `groupname`, `description`, `useradmin`, `webadmin`, `articleadmin`, `sendcomment`, `photoadmin`, `jobadmin`, `boardadmin`, `funadmin`, `memberadmin`, `shopadmin`) VALUES
(1, '超级管理员', '超级管理员用户组，该组的用户具有全部的权限', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);

# --------------------------------------------------------
# 转存表中的数据 `yx_image`
# --------------------------------------------------------
INSERT INTO yx_image (`id`, `pid`, `name`, `title`, `thumb`, `water`) VALUES
(1, 2, '20150707214748_412.jpg', '公司图集', 1, 1),
(2, 2, '20150707214735_876.jpg', '公司图集', 1, 1),
(3, 2, '20150707214718_706.jpg', '公司图册', 1, 1),
(4, 2, '20150707214710_674.jpg', '公司图册', 1, 1),
(5, 2, '20150707214703_398.jpg', '公司图册', 1, 1),
(6, 2, '20150707214655_119.jpg', '公司图册', 1, 1),
(8, 1, '20150707215330_840.jpg', '公司图册', 1, 1),
(9, 1, '20150707215316_258.jpg', '公司图册', 1, 1),
(10, 1, '20150707215420_971.jpg', '公司图册', 1, 1),
(11, 1, '20150707215301_706.jpg', '公司图册', 1, 1),
(12, 1, '20150707215245_933.jpg', '公司图册', 1, 1),
(13, 1, '20150707215224_781.jpg', '公司图册', 1, 1);

# --------------------------------------------------------
# 转存表中的数据 `yx_job`
# --------------------------------------------------------
INSERT INTO yx_job (`id`, `title`, `address`, `treatment`, `number`, `starttime`, `endtime`, `content`) VALUES
(1, 'PHP程序员', '北京市海淀区幸福路62号', '5000.00', 10, 1429369625, 0, '<p>	要求：<br />	1、大专以上学历<br />	2、计算机软件专业<br />	3、思维敏捷、学习能力强，有责任心和团队精神<br />	4、良好的沟通、理解及逻辑分析能力</p>'),
(2, '网站美工', '北京丰台区人民街富豪大厦A座9-501', '3500.00', 3, 1429514008, 0, '<p>	1、大专以上学历<br />	2、计算机软件专业<br />	3、思维敏捷、学习能力强，有责任心和团队精神<br />	4、良好的沟通、理解及逻辑分析能力</p>');

# --------------------------------------------------------
# 转存表中的数据 `yx_menu`
# --------------------------------------------------------
INSERT INTO yx_menu (`id`, `title`, `pid`, `path`, `target`, `url`, `display`, `ord`) VALUES
(1, '首页', 0, '0', '_self', '/', 1, 0),
(2, '公司简介', 0, '0', '_self', '/index/about/id/1', 1, 1),
(3, '优质产品推介', 0, '0', '_self', '/photo/index/pid/2', 1, 2),
(4, '公司风采', 0, '0', '_self', '/photo/prcture/pid/1', 1, 4),
(5, '动态资讯', 0, '0', '_self', '/article/index/pid/1', 1, 3),
(7, '企业招聘', 0, '0', '_self', '/index/job', 1, 6),
(11, '企业概况', 2, '0-2', '_self', '/index/about/id/1', 1, 0),
(12, '业务范围', 2, '0-2', '_self', '/index/about/id/2', 1, 0),
(13, '耐克运动系例', 3, '0-3', '_self', '/photo/index/pid/2', 1, 0),
(14, '阿迪达斯系列', 3, '0-3', '_self', '/photo/index/pid/7', 1, 0),
(15, '达芙妮系列', 3, '0-3', '_self', '/photo/index/pid/8', 1, 0),
(16, '公司活动', 4, '0-4', '_self', '/photo/prcture/pid/2', 1, 0),
(17, '装修图库', 4, '0-4', '_self', '/photo/prcture/pid/1', 1, 0),
(18, '联系我们', 2, '0-2', '_self', '/index/about/id/3', 1, 0),
(19, '公司新闻', 5, '0-5', '_self', '/article/index/pid/2', 1, 0),
(20, '行业动态', 5, '0-5', '_self', '/article/index/pid/3', 1, 0),
(22, '女装', 0, '0', '_self', '/photo/index/pid/4', 1, 2),
(23, '鞋包配饰', 0, '0', '_self', '/photo/index/pid/20', 1, 2);

# --------------------------------------------------------
# 转存表中的数据 `yx_notice`
# --------------------------------------------------------
INSERT INTO yx_notice (`id`, `title`, `color`, `starttime`, `endtime`, `content`, `display`, `ord`) VALUES
(1, '网站用图声明', '000000', 1439991868, 0, '<p>	本网站中所使用的部分图片均来源于互联网，仅为网站系统测试使用，图片版权规源网站、单位及个人所有，任何单位或个人不得使用其用于商业宣传或其它用途。</p>', 1, 0);

# --------------------------------------------------------
# 转存表中的数据 `yx_payment`
# --------------------------------------------------------
INSERT INTO yx_payment (`id`, `title`, `audit`) VALUES
(1, '支付宝', 1),
(2, '银行转帐', 1),
(3, '货到付款', 1);

# --------------------------------------------------------
# 转存表中的数据 `yx_phcolumn`
# --------------------------------------------------------
INSERT INTO yx_phcolumn (`id`, `pid`, `path`, `title`, `description`, `audit`, `ord`, `display`, `callid`) VALUES
(1, 0, '0', '推荐品牌', '推荐品牌', 0, 0, 1, 1),
(2, 1, '0-1', '耐克', '耐克', 0, 0, 1, 1),
(3, 0, '0', '女装', '女装', 0, 0, 1, 1),
(4, 3, '0-3', '呢大衣', '呢大衣', 0, 0, 1, 1),
(5, 3, '0-3', 'T恤', 'T恤', 0, 0, 1, 1),
(6, 3, '0-3', '羽绒', '羽绒', 0, 0, 1, 1),
(7, 1, '0-1', '阿迪达斯', '阿迪达斯', 0, 0, 1, 1),
(8, 1, '0-1', '达芙妮', '达芙妮', 0, 0, 1, 1),
(9, 1, '0-1', '李宁', '李宁', 0, 0, 1, 1),
(10, 1, '0-1', '安踏', '安踏', 0, 0, 1, 1),
(11, 1, '0-1', '奥康', '奥康', 0, 0, 1, 1),
(12, 1, '0-1', '骆驼', '骆驼', 0, 0, 1, 1),
(13, 1, '0-1', '特步', '特步', 0, 0, 1, 1),
(14, 3, '0-3', '衬衫', '衬衫', 0, 0, 1, 1),
(15, 3, '0-3', '羊绒衫', '羊绒衫', 0, 0, 1, 1),
(16, 3, '0-3', '针织', '针织', 0, 0, 1, 1),
(17, 3, '0-3', '连衣裙', '连衣裙', 0, 0, 1, 1),
(18, 3, '0-3', '皮外套', '皮外套', 0, 0, 1, 1),
(19, 0, '0', '鞋包配饰', '鞋包配饰', 0, 0, 1, 1),
(20, 19, '0-19', '围巾', '围巾', 0, 0, 1, 1),
(21, 19, '0-19', '旅行箱', '旅行箱', 0, 0, 1, 1),
(22, 19, '0-19', '真皮包', '真皮包', 0, 0, 1, 1),
(23, 19, '0-19', '韩版', '韩版', 0, 0, 1, 1),
(24, 19, '0-19', '达芙妮', '达芙妮', 0, 0, 1, 1),
(25, 19, '0-19', '单肩包', '单肩包', 0, 0, 1, 1),
(26, 19, '0-19', '毛线', '毛线', 0, 0, 1, 1),
(27, 19, '0-19', '清仓靴子', '清仓靴子', 0, 0, 1, 1);

# --------------------------------------------------------
# 转存表中的数据 `yx_photo`
# --------------------------------------------------------
INSERT INTO yx_photo (`id`, `pid`, `uid`, `title`, `pic`, `price`, `memberprice`, `recommend`, `top`, `audit`, `content`, `views`, `posttime`) VALUES
(17, 2, 1, '耐克2015新款春季全掌气垫跑鞋', '20150827224647_318.jpg', '1200.00', '1150.00', 1, 1, 1, '<p>请自行修改</p>', 37, 1440686807),
(18, 2, 1, '耐克男鞋跑步鞋2015年新款', '20150827224710_651.jpg', '1800.00', '1410.00', 1, 0, 1, '<p>请自行修改</p>', 130, 1440686830),
(19, 2, 1, '耐克NIKE减震透气休闲鞋跑步', '20150827234929_405.jpg', '5800.00', '3500.00', 1, 0, 1, '<p>请自行修改</p>', 45, 1440690569),
(20, 2, 1, 'NIKE登月LUNARGLIDE 6运动鞋男休闲跑步鞋', '20150912140740_452.jpg', '1180.00', '1150.00', 1, 0, 1, '<p>请自行修改</p>', 17, 1442038060),
(21, 2, 1, '耐克时尚男士黑色休闲鞋', '20150912142248_795.jpg', '2500.00', '2300.00', 1, 1, 1, '<p>请自行修改</p>', 18, 1442038968),
(22, 7, 1, '阿迪达斯2015秋季男士运动系系', '20150917162618_134.jpg', '599.00', '500.00', 1, 0, 1, '<p>请自行修改</p>', 4, 1442478378),
(23, 4, 1, '中长款蝴蝶结单排扣毛呢外套中长款', '20150917212405_147.jpg', '255.00', '190.00', 0, 0, 1, '<p>请自行修改</p>', 1, 1442496245),
(24, 4, 1, '中长款蝴蝶结单排扣毛呢外套中长款', '20150917212505_509.jpg', '500.00', '210.00', 0, 0, 1, '<p>请自行修改</p>', 1, 1442496305);

# --------------------------------------------------------
# 转存表中的数据 `yx_wapmenu`
# --------------------------------------------------------
INSERT INTO yx_wapmenu (`id`, `title`, `url`, `display`, `ord`) VALUES
(1, '网站首页', '/', 1, 0),
(2, '公司简介', '/index/about', 1, 1),
(3, '动态资讯', '/index/article', 1, 2),
(4, '推荐产品', '/index/product', 1, 3),
(5, '购物车', '/index/carlist', 1, 4),
(6, '会员中心', '/login', 1, 5),
(7, '信息反馈', '/index/board', 1, 6);

# --------------------------------------------------------
# 转存表中的数据 `yx_wapmenu`
# --------------------------------------------------------
INSERT INTO yx_wappic (`id`, `title`, `pic`, `links`, `ord`) VALUES
(1, '第一张', 'banner.jpg', '/index/globallink', 0),
(2, '第二张', 'banner2.jpg', '/', 1),
(4, '第三张', '20150917163335_763.jpg', '#', 0);