<?php
/**
 * Bigace - a PHP and MySQL based Web CMS.
 *
 * LICENSE
 *
 * This source file is subject to the new GNU General Public License
 * that is bundled with this package in the file LICENSE.
 * It is also available through the world-wide-web at this URL:
 * http://www.bigace.de/license.html
 *
 * Bigace is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * @category   Bigace
 * @copyright  Copyright (c) 2009-2010 Keleo (http://www.keleo.de)
 * @license    http://www.bigace.de/license.html     GNU Public License
 * @version    $Id$
 */

/**
 * Creates a URL to an Admin Action.
 *
 * @category   Bigace
 * @copyright  Copyright (c) 2009-2010 Keleo (http://www.keleo.de)
 * @license    http://www.bigace.de/license.html     GNU Public License
 */
class Admin_View_Helper_AdminUrl extends Zend_View_Helper_HtmlElement
{
    /**
     * Language will be automatically fetched if not passed.
     */
    public function adminUrl($controller, $action, $params = array(), $language = null)
    {
        if($language === null)
            $language = $this->view->LANGUAGE;

        $al = new AdministrationLink($controller, $action);
        $al->setLanguageId($language);
        return LinkHelper::getUrlFromCMSLink($al, $params);
    }
}
