/*
Navicat MySQL Data Transfer

Source Server         : localhost_3306
Source Server Version : 50540
Source Host           : localhost:3306
Source Database       : seacms

Target Server Type    : MYSQL
Target Server Version : 50540
File Encoding         : 65001

Date: 2015-03-21 11:26:37
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for adword
-- ----------------------------
DROP TABLE IF EXISTS `adword`;
CREATE TABLE `adword` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ad1` varchar(255) DEFAULT NULL,
  `ad2` varchar(255) DEFAULT NULL,
  `ad3` varchar(255) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of adword
-- ----------------------------
INSERT INTO `adword` VALUES ('1', '<script src=\"http://www.isea.so/adworld/ad-270px.js\"></script>', '<script src=\"http://www.isea.so/adworld/ad-370px.js\"></script>', '<script src=\"http://www.isea.so/adworld/ad-730px.js\"></script>', '2015-03-21 10:52:59');

-- ----------------------------
-- Table structure for content
-- ----------------------------
DROP TABLE IF EXISTS `content`;
CREATE TABLE `content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `navclass` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `toutiao` int(11) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `xs` int(11) DEFAULT NULL,
  `hit` int(11) DEFAULT NULL,
  `images` varchar(255) DEFAULT NULL,
  `content` longtext,
  `date` datetime DEFAULT NULL,
  `editdate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of content
-- ----------------------------
INSERT INTO `content` VALUES ('1', '1', '苹果回应向中国提交源代码', '1', '网络', '', '', '1', '609', '', '<p>　　据外媒报道，苹果已经同意向中国市场的提交产品源代码以及密钥，并且提供&ldquo;后门&rdquo;以供监管。对此，苹果方面最新回应称，他们只是同意让自家产品接受中国的审核，并不涉及源代码又或是密钥等核心技术。</p><p>　　此外，苹果方面还强调，虽然他们已经将其服务器转到中国电信，但这只是为了让用户得到更好的体验，而不涉及任何安全问题，因为中国电信也不能够查看用户的数据。</p><p>　　据了解，此前外媒Quartz报道，苹果可能已经同意中国即将出台的《反恐法》当中的部分条款。这部新法当中的条款规定，所有进入中国市场的外国企业都必须提交产品源代码以及密钥，并且提供&ldquo;后门&rdquo;以供监管。</p><p>　　中国政府正在起草的《反恐法》草案要求所有在华外国科技公司提供专用的源代码和加密密钥，方便有关部门可以访问存储在这些公司服务器上的用户数据，美国总统奥巴马对于草案中所出现的针对外国科技公司进行安全审查的条款进行了强烈批评。奥巴马日前接受路透社采访时表示，如果中国想与美国企业做生意，那么就需要在上述规定中做出改变。&ldquo;美国的科技公司肯定不乐意这样做，&rdquo;奥巴马说道，&ldquo;我不认为欧美的科技公司会愿意把用户的个人数据开放给政府部门。&rdquo;</p><p>　　微评：我觉得，在华外国科技公司提供专用的源代码和加密密钥给有关部门，可能存在的主要风险，一是知识产权的泄密，巨资研发的产品被他人轻易山寨，二是安全隐患，黑客可通过源代码分析出系统潜在的漏洞，并入侵系统获得用户信息。因此苹果不太可能会提交源代码和密钥给政府部门。</p>', '2015-03-10 16:13:10', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('2', '1', '百度云OS被放弃', '0', '网络', '', '', '1', '1031', '', '<p>　　3月11日消息，百度云OS今日宣布，由于公司内部业务调整，百度云OS将于2015年3月11日起，暂停更新。</p><p>　　百度云OS是基于Android 4.0及以上版本进行开发的第三方智能手机系统，诞生于2012年6月4日，是由李彦宏在2011年提出的百度&middot;易平台演变而来，至今已经发布6个正式版本。在《2014年刷机市场洞察》数据报告中，百度云OS在第三方ROM资源排行榜中仅次于CM，位列第二，超过MIUI、新蜂ROM、乐蛙等。</p><p>　　该系统最初命名为百度云ROM，后于2014年9月15日正式更名为百度云OS，同时启用新的品牌LOGO。</p><p>　　以下为百度云OS论坛声明全文：</p><p>　　忘不了那一天，你带着炙热的梦想横空出世，像个学步的孩子勇敢探索着未来</p><p>　　忘不了那一天，解决了你的一个Bug，忙到深夜的我们却笑得那么开心</p><p>　　忘不了那一天，炫5发布，UI全新改版，大家眼睛里满满的欣慰和自豪</p><p>　　忘不了那一天，正式版V6发布得到用户认可，我们的喜极而泣</p><p>　　忘不了那一天，我们从天南海北聚在一起就是为了讨论怎么让你变得更美好</p><p>　　我们因你而来，因爱而聚，你是百度云OS，是我们追随的女神白小云，也是大家眼里那个时而逗比时而傲娇的小白云，我们是你的缔造者，也是你忠实的粉丝</p><p>　　百度云OS从2012年6月4日诞生到今天，我们已经风雨同舟度过1010个难忘的日子。当初那个懵懂的小孩白小云，在大家的一路陪伴下长成了今天万众瞩目的明星，我们也在相伴相携中建立了深厚的感情</p><p>　　今天，我们要衷心的说一声感谢，感谢你们无怨无悔的风雨相伴</p><p>　　今天，我们也要真诚的说一声抱歉，今后的路再不能相伴相携地一起走</p><p>　　告别的话很难说出口，因公司业务调整，我们不得不痛苦的决定暂停百度云OS的更新和维护</p><p>　　迷失的人迷失了，相逢的人会再相逢，也许是永别，也许白小云还会回来~</p><p>　　今天，我们还要说一声珍重，前路漫漫，希望你一直记得和百度云OS相伴成长的日子，请带着小云的祝福继续往前走，因为有你，我们青春无悔，因为有你，我们更爱这世界的美好~</p>', '2015-03-10 16:22:16', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('3', '1', '小米4被指预装恶意软件：回应称测试机遭篡改', '0', '网络', '', '', '1', '98', '', '<p>　　近日有媒体报道，美国数据安全公司Bluebox通过测试发现，小米4手机中预装了恶意软件，还在这款手机中发现了很多其他问题。更令人担忧的是，这款手机似乎已经被尚未确认的第三方篡改。</p><p>　　Bluebox曾经就此问题联系小米，但并未得到回复，该公司随后在上周四发布了报告。当Bluebox的研究人员收到这款手机时，确定那是一款使用小米账户的合法小米设备。经过深入的测试后，研究人员发现这款智能手机中预装了多款恶意应用，包括一款伪装成合法谷歌应用的广告软件、一个可以让黑客控制手机的木马，还有其他一些高危软件。</p><p>　　另外，Bluebox首席安全分析师安德鲁&middot;布莱齐(Andrew Blaich)还表示，在该公司进行的所有漏洞扫描中，小米4该都存在问题。</p><p>　　布莱齐还表示，小米4的操作系统是未经认证的Android版本，因此可能存在很多瑕疵。他的团队发现的很多问题和漏洞都是较老的Android系统中存在的问题，最新版本已经修复，因此，他们认为小米4的操作系统融合了新的Android 4.4.4奇巧系统和旧版Android系统。API中的其他一些问题导致安全人员难以判断该设备究竟是用于测试的设备，还是供用户使用的产品。</p><p>　　该公司还怀疑，这款设备可能被第三方篡改，因为某些应用的签名与小米的签名密钥并不相同。</p><p>　　上周五，Bluebox终于收到小米方面的回复，小米国际副总裁雨果&middot;巴拉(Hugo Barra)在回复中说：&ldquo;我们确定Bluebox测试的设备使用的并非标准版MIUI ROM，因为我们的工厂ROM和OTA ROM从未root，也不会安装YT Service、PhoneGuardService、AppStats等服务。Bluebox购买的这款测试用机可能被篡改了，因为他们是通过中国的一家实体店购买的，而小米并不通过中国的第三方零售商销售手机，只通过官方网站和部分运营商销售。&rdquo;</p><p>　　巴拉还表示，小米正在调查该公司为何花费这么长时间才作出回应。他建议用户只购买Mi.com网站和部分认证商店的小米设备。</p><p>　　不过，布莱齐似乎并不认可这一回复。他写道：&ldquo;如果在零售渠道中这么容易篡改设备，那么即使通过Mi.com购买，也同样也可以在运输过程中篡改。&rdquo;他还引述了另外一篇来自《明镜周刊》的新闻报道：美国情报部门可以在某些设备到达目的地之前在其中加载恶意软件&mdash;&mdash;这是一种更加现代化的窃听方式。他认为，如果小米智能手机已经在零售层面被黑客入侵，便有可能引发更复杂的攻击。</p><p>　　布莱齐在报告中指出，电子设备越受欢迎，遭到攻击的频率就越高。小米的MIUI平台拥有1亿用户，而且计划今年进军美国，因此该公司的用户数量今后还将继续增加。</p><p>　　小米随后就此事向科技博客Venturebeat发布声明称：&ldquo;Bluebox得到的那部小米4手机可能被第三方篡改，因为那是通过非官方渠道购买的。由于中国的各个手机品牌都存在巨大的平行市场，所以第三方经常通过这类渠道篡改任何品牌的手机。小米只通过Mi.com以及移动运营商等少数受信赖的合作伙伴销售手机。&rdquo;</p><p>　　小米还补充说：&ldquo;另外，与Bluebox的结论不同的是，MIUI使用的是真正的Android系统，意味着MIUI完全遵守Android的兼容性定义文件(CDD)，而且通过了所有的Android CTS测试，这是行业内用于确保某款设备完全兼容Android的一项流程，适用于中国和国际市场。&rdquo;</p>', '2015-03-10 16:26:07', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('4', '1', '2014年DDoS威胁报告', '0', '网络', '', '', '1', '25', '', '<p>　　网络安全威胁正在变得日益复杂，各类攻击目标、手段及来源始终在不断的发生着变化，随之企业及各类组织需要不断关注这些发展态势，以便能够理解与预测未来可能遭遇的恶意攻击，进而应对复杂变化所带来的挑战。</p><p>　　DDoS（分布式拒绝服务）作为网络安全威胁中的典型攻击手段，从诞生的那天起就从未停止，本报告是2014年全年度DDoS报告。2014年，DDoS攻击方式中出现了新的DDoS反射式放大攻击形式，该攻击基于SSDP协议利用一些智能设备进行反射式攻击，攻击带宽放大倍数最高可达75倍。在国内，在线游戏已进入DDoS攻击目标的前3。在2014年DDoS攻击事件中，某次攻击事件流量超过100Gbps。</p><p>　　关键发现</p><p>　　1.&nbsp;智能设备发起DDoS攻击数量明显增多</p><p>　　2.&nbsp;广东依然是最严重的受害区域</p><p>　　3.&nbsp;18点-23点是DDoS开始攻击的主要时间段</p><p>　　4.&nbsp;UDP FLOOD成为最主要的DDoS攻击方式</p><p>　　5.&nbsp;在线游戏已进入DDoS攻击目标前3</p><p>　　6.&nbsp;93% DDoS攻击发生在半小时内</p><p>　　预测2015</p><p>　　1.&nbsp;DDoS攻击峰值流量将再创新高</p><p>　　2.&nbsp;反射式DDoS攻击技术会继续演进</p><p>　　3.&nbsp;DNS服务将迎来更多的DDoS攻击</p><p>　　4.&nbsp;针对行业的DDoS攻击将持续存在</p><p>　　观点1：智能设备发起DDoS攻击数量明显增多</p><p>　　近年来已监测到多起由智能设备发起的DDoS攻击，并且次数在逐渐增多。 由于一些智能设备（例如网络摄像机）具有以下特点：相对比较高的带宽、升级周期比较长，甚至可能自部署后从未升级、通常是7*24小时在线</p><p>　　如果这些设备存在弱口令或者漏洞，则容易被攻击者利用，进而成为DDoS攻击源。绿盟科技近期对世界范围内的智能设备进行了监控, 已发现约80万该类设备可能被利用进行DDoS攻击，下图显示了其分布情况。</p><p style=\"text-align: center\"><img alt=\"2014年DDoS威胁报告\" src=\"/upload/4166_1.jpg\" /></p><p>　　事件1：2014年国内规模最大的DDoS攻击--1/3攻击源是智能设备</p><p>　　自2014年12月10日起，全球范围内DNS流量出现异常，针对该事件绿盟科技安全团队做出了快速的分析处理，此次DNS攻击事件波及全国大多数省份，从10日凌晨至14日，攻击在全国范围内依然时常发生。初步统计，此次攻击事件在全国范围内的攻击流量至少有100G以上，单节点高峰流量达到70Gbps，其持续事件之长，攻击流量之大，属近年之最。经过样本分析发现，攻击者通过不断查询a***k.org、n***c.com等三个域名的随机二级域名的方法进行DNS Flood攻击。</p><p>　　这次DDoS攻击的基本方法是利用僵尸网络查询游戏网站的随机二级域名，企图攻击该游戏网站的权威域名服务器（即DNS Slow Drip DDoS攻击）。由于国内的宽带用户通常将其电脑的DNS选项设置为各省的递归服务器，在大量肉鸡发起攻击（请求）后，导致递归服务器需要向外递归查询游戏网站的随机二级域名，从而极大地消耗了这些服务器的系统资源，造成运营商核心解析业务受到严重影响。这次DDoS攻击有如下3点值得关注的地方：攻击源中有1/3左右是智能设备、国内DNS递归服务器是因牵连而受到严重影响、被攻击域名均属于在线游戏网站</p><p>　　此外，以2014年12月为例回顾针对DNS服务的DDoS攻击事件（DNS FLOOD），这些攻击能够频频得手充分说明，从攻击者角度看攻击DNS服务是实现攻击目的既有力又有效的手段，这种选择也间接体现了目前DNS的安全防护状况，毕竟DDoS攻击目的就是企图造成资源耗尽，因此需要找出攻击受害者的&quot;软肋&quot;。</p><p>　　观点2：沿海省市是受攻击的集中地区, 广东依然是最严重的受害区域</p><p>　　2014下半年广东依然是最严重的受害区域。与2014上半年相比，广东占攻击的比例虽然下降, 但是其下半年遭受攻击次数是上半年的1倍多，这充分反映了当前DDoS攻击活动的活跃程度。与2013下半年相比，变化最明显的是天津市，受害者数量不断上升，2013年还在10名之外，到2014下半年已超过福建省位列第4。在前10名受害区域中, 除内陆省份陕西与四川外，其它受害区域均属沿海省市。</p><p style=\"text-align: center\"><img alt=\"2014年DDoS威胁报告\" src=\"/upload/4166_2.jpg\" /></p><p>　　观点3：18点-23点是DDoS开始攻击的主要时间段</p><p>　　下图表现了2014年DDoS攻击目标每半年的DDoS攻击开始时间。从中可以看出，在2014下半年18点-23点（北京时间，GMT+8）是DDoS开始攻击的主要时间段（47.5%），其次是12点-17点的时间段（26.2%）。攻击者主要选择18点-23点开始进行攻击，这是因为这段时间网络流量比较大，使得攻击效果会&quot;事半功倍&quot;。</p><p style=\"text-align: center\"><img alt=\"2014年DDoS威胁报告\" src=\"/upload/4166_3.jpg\" /></p><p>　　观点4：UDP FLOOD成为最主要的DDoS攻击方式</p><p>　　监测数据显示，2014下半年UDP FLOOD超越DNS FLOOD成为当前最主要的DDoS攻击方式，占总数的51.9%。DDoS攻击方式的变化反映了在网络攻防对抗中，不断动态演进的攻防技术发展，例如：攻击者对数据包到目标站点经过的各节点进行试探，在发现网络链路上的薄弱环节后再发动攻击。UDP FLOOD上升为重要DDoS攻击方式的原因之一，与近年来攻击者持续使用反射式DDoS攻击有密切关系。</p><p style=\"text-align: center\"><img alt=\"2014年DDoS威胁报告\" src=\"/upload/4166_4.jpg\" /></p><p>　　事件2：SSDP反射式DDoS攻击实例分析</p><p>　　在2014年下半年SSDP反射式DDoS攻击次数显著上升，这种攻击的基本过程如下图所示。首先攻击者将伪造IP地址的M-SEARCH UDP数据包发送给众多UPnP设备；然后这些UPnP设备向受害者IP&quot;返回&quot;响应数据包；最后当受害者无法处理由于这些UPnP设备产生的反射攻击流量时，导致被攻击目标陷入拒绝服务状态。根据已监测到的SSDP反射式DDoS攻击数据，其攻击带宽放大倍数（BAF, 即UDP Payload比值）在30左右。</p><p style=\"text-align: center\"><img alt=\"2014年DDoS威胁报告\" src=\"/upload/4166_7.jpg\" /></p><p>　　可以看到，攻击者向UPnP设备发送M-SEARCH请求，并将ST（Search Target）设置为ssdp:all （即搜索所有设备和服务）。如果考虑到全球可被利用的UPnP设备数量，则很容易看出这种反射式DDoS攻击会给互联网带来非常巨大的影响。绿盟科技近期对世界范围内的SSDP服务进行监控时，发现700多万台SSDP设备（Controlled Device）能够被利用进行SSDP反射式DDoS攻击。</p><p style=\"text-align: center\"><img alt=\"2014年DDoS威胁报告\" src=\"/upload/4166_8.jpg\" /></p><p>　　根据统计结果，SSDP协议的平均带宽放大倍数（BAF）是37，最常见的放大倍数是24和32；SSDP协议的平均包放大倍数（PAF）是8.7。对SSDP设备放大倍数按升序排序，则前10% SSDP设备的平均带宽放大倍数是14，而后10% SSDP设备的平均带宽放大倍数是75。</p><p>　　这些SSDP设备的放大倍数分布状况如下：</p><p style=\"text-align: center\"><img alt=\"2014年DDoS威胁报告\" src=\"/upload/4166_9.jpg\" /></p><p>　　基于SSDP协议的反射攻击在很长时间内将难以修复。由于影响的设备范围广，手段多样以及攻击效果明显，可以预见的是越来越多的攻击者会利用/改进这种攻击的手段和方式。从应对反射攻击的思路上看，这种类型攻击需要终端用户、运营商、安全厂商协力配合，从各个层面阻击才能最大程度的保证用户业务的可靠性。</p><p>　　观点5：在线游戏已进入DDoS攻击目标前3</p><p>　　绿盟科技收集了2013至2014年全球发生的重大DDoS攻击事件。在这些攻击事件中，2014下半年政府网站依然是DDoS攻击最主要的目标，占总数近一半，其次则是针对商业公司的攻击。与2014上半年相比，运营商受到的攻击比例有所下降，而在线游戏和金融行业则有所上升。与2013下半年相比，最明显的区别是针对在线游戏的DDoS显著增加，游戏行业一直是DDoS攻击的主要目标之一，这是因为在线游戏对于游戏服务器的服务质量要求很高，在DDoS攻击影响游戏正常运行时，玩家常会责怪游戏服务器&quot;太慢、易掉线&quot;，如果频繁出现这些状况，玩家极有可能选择离开，从而直接导致该款游戏在线盈利能力下降。攻击者之所以喜欢将在线游戏作为攻击目标, 这可能与攻击者通过勒索而牟取非法利益存在着联系，也有可能存在非正当商业竞争等原因。</p><p style=\"text-align: center\"><img alt=\"2014年DDoS威胁报告\" src=\"/upload/4166_5.jpg\" /></p><p>　　观点6：93% DDoS攻击发生在半小时内</p><p>　　从2013年以来的数据显示，DDoS攻击时间的分布一直比较稳定，30分钟内完成的攻击始终占90%左右。目前DDoS攻击的重要特征是：持续时间短、但攻击流量大。攻击者采用这种攻击策略的目的至少有：</p><p>　　1.&nbsp;闪电战：试图在检测发现攻击至启动清洗服务的时间间隔内进行攻击, 以更有效率地对目标实施DDoS攻击；</p><p>　　2.&nbsp;干扰战：对攻击目标进行DDoS攻击，只是吸引攻击目标IT工作人员的注意力，掩护攻击者采取其它攻击方式；</p><p>　　3.&nbsp;游击战：通过长期DDoS攻击网站，意图恶意阻碍网站的正常访问, 常常是&quot;打一枪就走&quot;。</p><p>　　由此可见，对于DDoS的缓解而言，从检测发现攻击到启动清洗的响应速度会成为评判缓解效果的关键因素之一。此外，长期连续的DDoS攻击虽然少见但依然存在，2014下半年，绿盟科技云安全运营中心监测到持续最久DDoS攻击长达70个小时。</p><p style=\"text-align: center\"><img alt=\"2014年DDoS威胁报告\" src=\"/upload/4166_6.jpg\" /></p><p>　　预测2015</p><p>　　现状值得我们去分析，是因为它是未来的先兆。如果2015年不会出现颠覆性的技术变革，或是重大的政治宗教冲突。那么，我们可以对DDoS的数量、方法和对象提出一些预测。其中反射式DDoS攻击尤其值得重视，所以本节从技术和威胁角度给出了更详细的分析。</p><p>　　DDoS攻击峰值流量将再创新高</p><p>　　DDoS攻击峰值流量逐年上升,这一方面是由于攻击技术的不断发展, 另一方面也是由于网络带宽等可利用资源显著上升。 因此预期2015年DDoS攻击峰值流量较2014年将有明显增长, 甚至可能会进入1Tbps时代。</p><p>　　反射式DDoS 攻击技术会继续演进</p><p>　　从防护角度看反射式DDoS攻击易于检测与缓解，这是因为攻击数据包的源端口相对固定；然而从攻击角度看，这种DDoS攻击方式具有隐匿攻击者真实身份、攻击者无需组建僵尸网络、对攻击者的网络带宽要求小等优势。在2014年下半年，基于SSDP协议DDoS反射式攻击次数显著上升。预计这种高效、低成本的DDoS攻击技术还将为攻击者提供更多的攻击选项。</p><p>　　DNS服务将迎来更多的DDoS攻击</p><p>　　2014下半年多次重大DDoS攻击中都使用了DNS FLOOD，这主要是因为DNS协议设计存在安全缺陷、许多DNS服务器运维存在安全隐患等导致，从而使得DNS服务器自然而然地成为攻击者瞄准的重要攻击对象。</p><p>　　针对行业的DDoS攻击将持续存在</p><p>　　近年来针对金融、能源等行业的DDoS攻击时有发生，一些行业甚至长期面临DDoS攻击的困扰。虽然目前各种缓解DDoS的技术不断发展，但是从攻击者角度看DDoS攻击简单易行，只要其行之有效则会持续存在。</p><p>　　结束语</p><p>　　拒绝服务攻击存在的根源是Internet架构自身缺陷，正如RFC 4732所说，&quot;由于最初Internet架构未考虑拒绝服务攻击, 从而导致几乎所有Internet服务均易遭受拒绝服务攻击&quot;。纵观近5年DDoS攻防双方的对抗交锋，攻击方技术不断演进，将&quot;以大欺小&quot;（流量型攻击）与&quot;以小搏大&quot;（资源耗尽型）两种攻击方式组合起来，利用逐渐提高的网络带宽增强攻击力等；而防守方则通过流量清洗设备等多种手段予以应对。</p><p>　　从绿盟科技长期跟踪与分析的DDoS数据可以看出，攻击者行为是在不断变化，网络环境的演进使得攻防的战场更为复杂。相信报告中所述观点，对于预测未来的攻击形态，以及进一步完善企业及组织的解决方案是有价值的。</p><p>　　&quot;能因敌变化而取胜，谓之神&quot;，面对DDoS攻击目前所呈现的不断演变与浪潮冲击，您做好准备了吗？</p><p>　　来源：投稿，作者：赵刚，绿盟科技威胁响应中心研究员，主要研究领域为态势感知和信息安全事件分析。马乐乐，绿盟科技北京研发中心研发工程师，主要进行DDoS攻防相关的研究。</p>', '2015-03-10 16:26:04', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('5', '1', 'Windows网站架构服务器的优劣', '0', '网络', '', '', '1', '81', '', '<p>　　使用Windows平台来构建网站服务器，很大部分由网站管理员的技术背景决定的，早期的技术人员可能更熟悉Windows，或者负责人认为Windows的易用性、&ldquo;短平快&rdquo;的开发模式、人才成本等方面都比较符合团队需求，自然就选择了Windows.后期业务发展到一定规模，也很难轻易将整体架构迁移到其它平台上了。当然，对于构建大规模互联网，更建议首选开源架构，因为有很多成熟的案例和开源生态的支持，避免重复造轮子和支出授权费用。</p><p>　　那么，Windows架构的服务器和Linux架构的服务器到底哪个好呢？这里就从需求性、稳定性、操作性、安全性来分析一番。</p><p>　　需求性：</p><p>　　Windows网站服务器的主要组成部分是Windows+IIS+ASP（.NET），因此如果网站程序开发语言是ASP，那么应该选择Windows服务器，因为Linux不支持ASP系列的语言；如果是PHP语言建设的网站，建议选择Liunx主机，因为在liunx平台中，Linux+Apche+Mysql构架运行PHP网页可以更高效，更稳定。</p><p>　　稳定性：</p><p>　　主机的稳定性是至关重要的，关系着网站的生存发展，如果稳定性不够好的话，就会影响用户的访问，也会影响网站的优化，导致没有排名，这对于用户体验度的影响是非常大的。通常来说，Linux稳定性要比Windows好些，再就是Windows的图形界面需要占很多资源，而Linux系统去掉图形界面的包袱，系统运行得更快。</p><p>　　Windows配置变化的时候，通常需要重新启动，这导致不可避免的停机，而Linux通常不需要重新启动。几乎所有的Linux系统配置的改变都能在系统运行中操作，而且还不会影响其他无关的服务。</p><p>　　操作性：</p><p>　　Windows系统的普及和它的图形化界面让我们每个懂电脑的人都不会陌生了，而Linux服务器一般是纯命令行模式，每完成一个操作，比如新建一个文件夹，都要用一串命令来完成。所以从操作性来讲，Liunx操作性要困难些。</p><p>　　安全性：</p><p>　　从安全性来说，Windows和Linux其实差不多，网站管理员熟悉哪种操作系统，懂得如何配置哪种操作系统的安全参数，哪种操作系统就更安全。</p>', '2015-03-10 16:27:12', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('6', '3', 'LNMP网站架构方案分析', '0', '网络', '', '', '1', '15', '', '<p>　　LNMP（Linux-Nginx-MySQL-PHP）网站架构是目前国际流行的Web框架，该框架包括：Linux操作系统，Nginx网络服务器，MySQL数据库，PHP编程语言，所有组成产品均是免费开源软件，这四种软件组合到一起，成为一个免费、高效的网站服务系统。</p><p>　　Linux、MySQL、PHP这些框架的优点之前已经介绍过，LNMP和LAMP不同的一点就是Web服务器Nginx，那么Nginx相比Apache有什么优点呢？</p><p>　　Nginx是一个小巧而高效的Linux下的Web服务器软件，已在一些大型网站上运行多年，很多国内外的门户网站、行业网站也都在是使用Nginx，相当的稳定。</p><p>　　Nginx的主要特点是稳定、功能丰富、安装配置简单、低系统资源。Nginx对于反向代理和负载均衡有不错的支持。Nginx不仅仅可以做为Web服务器，还可以做负载均衡服务器、代理服务器和邮件服务器。</p><p>　　作为Web服务器来说，相比 Apache，Nginx 使用更少的资源，支持更多的并发连接，Nginx处理静态文件、索引文件，自动索引的效率非常高，体现更高的效率。</p><p>　　作为代理服务器，Nginx可以实现无缓存的反向代理加速，提高网站的运行速度。</p><p>　　作为负载均衡服务器，Nginx既可以在内部直接支持Rails和PHP，也可以支持HTTP代理服务器对外进行服务，同时还支持简单的容错和利用算法进行负载均衡；Nginx 用 C 编写, 不论是系统资源开销还是 CPU 使用效率都比 Perlbal 要好的多。</p><p>　　作为邮件代理服务器来说， Nginx是一个非常优秀的邮件代理服务器（最早开发这个产品的目的之一也是作为邮件代理服务器）。</p><p>　　安装配置上，Nginx安装简单、配置灵活、配置文件非常简洁（还能够支持perl语法）；性能方面，Nginx是专门为性能优化而开发的，非常注重效率。它采用Poll模型，可以支持更多的并发连接，最大可以支持对50000个并发连接数的形影，而且只占用很低的内存资源；可用性方面，Nginx支持热部署，启动速度特别迅速，可以在不间断服务的情况下，对软件版本或者配置进行升级，及时运行数月也无需重新启动，几乎可以做到7*24显示不间断运行。</p><p>　　可见，LNMP（Linux-Nginx-MySQL-PHP）这四种软件的组合，可以成为一个免费、高效、扩展性强的网站服务系统。</p>', '2015-03-10 17:00:00', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('7', '3', '独立服务器网站选择指南', '0', '网络', '', '', '1', '13', '', '<p>　　做过网站的朋友都知道，选择一台合适、稳定的服务器，是建立一个好网站的重要前提。在选择服务器的时候，一般IDC运营商都会提出几种建议：购买VPS（虚拟专用服务器）、购买服务器后托管到IDC机房、直接跟IDC运营商租用服务器或者选择购买云服务器。</p><p>　　然而，对于这么多选择，很多客户往往对服务器托管、服务器租用、独享带宽、VPS租用、虚拟主机、云服务器等概念不是很了解，不知道如何选择IDC业务，有的一味的追求品质，选择了费用较高的套餐，但是却浪费资源，没有必要，也有些客户一味的省钱，没有根据自己公司的实际需求选择。下面就针对这几种不同的方案就行一些对比和评估。</p><p>　　<strong>VPS</strong></p><p>　　VPS（Virtual Private Server 虚拟专用服务器）技术，将一部服务器分割成多个虚拟专享服务器的服务。VPS服务器简称VPS, 又称VPS主机。VPS主机是通过虚拟化技术实现的虚拟主机，虚拟化是一个抽象层，它将物理硬件与操作系统分开，从而提供更高的IT资源利用率和灵活性。这些VPS服务器以最大化的效率共享硬件、软件许可证以及管理资源。每个VPS都可分配独立公网IP地址、独立操作系统、独立空间、独立内存、独立CPU资源、独立执行程序和独立系统配置等，为用户和应用程序模拟出&ldquo;独占&rdquo;使用计算资源的体验。VPS可以像独立服务器一样，重装操作系统，安装程序，单独重启服务器。VPS为使用者提供了管理配置的自由，可用于企业虚拟化，也可以用于IDC资源租用。</p><p>　　不同VPS提供商所使用的硬件VPS软件的差异，及销售策略的不同，VPS的使用体验也有较大差异。尤其是VPS提供商超卖，导致实体服务器超负荷时，VPS性能将受到极大影响。相对来说，容器技术比虚拟机技术硬件使用效率更高，更易于超卖，所以一般来说容器VPS的价格都高于虚拟机VPS的价格。</p><p>　　目前用得最多的虚拟化技术是Xen, OpenVZ, Hyper-V,Vmware等，其中Hyper-V是微软自家的虚拟化技术，只能在windows上运行，也就是一般买windows系统的vps时，很可能是Hyper-V的。Vmware国内的一些较小主机商会用，跑windows或linux的都有。OpenVZ是基于操作系统的虚拟化技术，它运行效率跟真机(实体服务器)几乎一样，OpenVZ价格便宜，非常容易被超售（假设宿主机有16G内存，但开出20台1G内存的vps，都卖出去了；而这20台vps里都显示1G内存，这就是超售）。Xen虚拟出来的系统跟真机相似度极高，有swap，可以运行pptp的vpn，不容易超售。同等配置的vps，Xen的性能要明显优于OpenVZ。</p><p>　　VPS的优点主要是价格便宜。缺点是性能低下和安全性较差。</p><p>　　<strong>服务器租用</strong></p><p>　　服务器租用是指用户无须自己购买服务器，只需根据业务的需要，提出对硬件配置的要求。主机服务器由IDC服务商配置。用户采取租用的方式，安装相应的系统软件及应用软件以实现用户独享专用高性能服务器，实现全部网络服务功能，用户的初期投资减轻了，可以更专著于自己业务的研发。用户可以自行安装操作系统及相应的应用软件，并完全自行管理 ，也可由公司代用户安装系统、应用软件，免费提供服务器监测服务。用户可以月租、年租，月租无押金，年租送产权。</p><p>　　租用服务器的好处是便捷和低价，我们知道，大部分的服务器买来以后装好系统和软件，调试通过之后最终还是要放到 IDC 机房的，那么，直接租用 IDC 机房的服务器就相对要更加省事一点，因为毕竟省去了运输的环节，如果机房离用户所在地不远那就非常好办，自己开车或者乘车过去都可以，但假如 IDC 机房离用户所在地非常远，运过去通常就非常麻烦了，这时候，租用确实是个好办法，即使不是好办法，也是不得已的办法，尤其是西南地区和西北地区机房资源非常少，那些地区的用户采用自己拿服务器去托管的方式确实不如直接去租用。</p><p>　　但是，租用机房的服务器也有其不足：用户大部分情况下都看不到自己租用的服务器是啥模样，一些比较厚道的运营商倒是会如实的告诉客户他们所租用的服务器是什么品牌、什么型号。不过也会有极少数IDC采用自行组装的服务器作为租用业务使用以便降低成本，所以能够提供给用户的就是服务器的简单配置资料，至于采用什么品牌的主板甚至主板芯片是什么，这些都是用户远程管理服务器的时候才能查看到。</p><p>　　<strong>服务器托管</strong></p><p>　　服务器托管是指客户自己购买服务器，然后交通过IDC（主机商）交由机房进行管理维护，服务器的所有权和使用权都是属于客户自己的，只需要付管理费用。在服务器托管的情况下，如果硬件等出现问题，机房一般是不负责维修的，需要客户自行处理。</p><p>　　服务器托管的好处是是自主性强，对服务器拥有完全控制权。随着服务器成本的降低，大部分的专业客户和大客户都倾向于自行采购设备然后拿去托管的方式，因为采用自己的方式组装出一台服务器，甚至是一半新配件一半二手配件组装而成的价格其实也不会太高；想要高性能的用户可以拿出足够的资金购买更高配置的产品，一些注重品牌和稳定的用户也可以直接购买一线大厂的品牌服务器。另外，有些用户可能要使用比较特殊的操作系统和软件，又或者是事先需要复制大量的资料到服务器硬盘上，这些操作远程控制机房的服务器都不是很方便，一般是先调试或者复制好再拿去机房托管。</p><p>　　总的来说，服务器托管可以自己选择配置和安装软件，在硬件采购上比较有优势，不过需要企业有专业人员管理维护，而服务器租用则比较灵活，没有硬件成本，维护起来也比较省心。对于离机房较远的地方，可以选择租用服务器，省去了舟车劳顿。如果离机房不很远的话，则最好是自行购买服务器再放机房托管。</p><p>　　<strong>云服务器</strong></p><p>　　云服务器（Elastic Compute Service, 简称ECS）是一种处理能力可弹性伸缩的计算服务，其管理方式比物理服务器更简单高效。云服务器提供可调整云主机配置的弹性云技术，整合了计算、存储与网络资源的Iaas服务，具备按需使用和按需即时付费能力的云主机租用服务。在灵活性、可控性、扩展性及资源复用性上都有很大的提高。</p><p>　　云服务器服务包括两个核心产品：面向中小企业用户与高端用户的云服务器租用服务；面向大中型互联网用户的弹性计算平台服务。</p><p>　　云服务器平台的每个集群节点被部署在互联网的骨干数据中心，可独立提供计算、存储、在线备份、托管、带宽等互联网基础设施服务。</p><p>　　云服务器适合以下用户：注重主机服务性价比的用户；需要快速实现分布式部署的用户；对业务的弹性扩展能力有需求的用户；有系统高可用性和快速恢复需求的用户等。</p><p>　　与VPS相比，云服务器实现云主机之间的完全隔离；内置冗余的共享存储和智能备份，物理服务器失败可在几分钟内自动恢复；服务环境采用高端服务器进行部署，同时采用集中的管理与监控，确保业务稳定可靠。总的来说，云服务器总体性能远高于VPS，强于部分独立服务器。</p><p>　　应该说云主机租用业务是时下比较热门的一项 IDC 服务，也是将来比较有发展潜力的一项类似虚机的租用业务，相对于自行购买服务器来说，云主机业务既比较便宜同时也具有服务器租用的各个优点，而相对于传统的服务器租用和虚拟主机来说，云主机一般配置都比较高，单独租用这种配置的服务器太昂贵，而采用 云主机的方式租用就划算一些。</p><p style=\"text-align: center\"><img alt=\"独立服务器的选择\" src=\"/upload/4163_1.jpg\" /></p><p>　　<strong>总结</strong></p><p>　　对于如何选择VPS、租用服务器、托管服务器、云服务器，下面是一些总结：</p><p>　　1.VPS：适合是小型公司，动态网站，页面不是特别多，访问量不是特别大的网站；</p><p>　　2.服务器租用：适合中小型公司，电子商务网站或者大型论坛，网站每日流量很大；</p><p>　　3.服务器托管：适合大型公司，自己购买了服务器，需要托管在专业的IDC机房；</p><p>　　4.云服务器：适合开发型公司，有大并发、动态调整需求频繁的网站。</p>', '2015-03-10 17:21:00', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('8', '3', '虚拟主机上的网站备份方法', '0', '网络', '', '', '1', '79', '', '<p>　　虚拟主机因为价格便宜，因此服务可能就不太靠谱，说不定哪天就关了或无法访问，因此网站备份对于虚拟主机来说尤为重要，做为站长应该如何将自己的网站进行备份，下面月光博客就介绍几个常见的网站备份方法。</p><p>　　<strong>手动备份</strong></p><p>　　手动备份是最基本的备份方法，对于大多数网站来说，网站的程序代码变动较少，主要是数据库的变化，因此，可以一次性将全站程序和数据库通过FTP等方式备份到本地硬盘，如果遇到网站模板或文件变更，则变更后再进行手动下载备份，对于数据库文件来说，通过phpMyAdmin等管理程序将数据库导出到一个文件中，然后定期从网站上将其下载到本地，以避免数据的丢失。</p><p>　　手动备份的问题是实时性不强，依赖人工操作，效率低下，如果遇到突发事件，数据库有可能会丢失数天甚至更长时间的数据。</p><p>　　<strong>使用面板自带程序备份</strong></p><p>　　很多虚拟主机的面板程序会自带备份恢复功能，使用面板程序的这些功能会极大提高备份和恢复的效率，例如常用的面板程序cPanel自带的Backup功能就可以让用户方便地备份整个站点和全部或者部分数据库， 在cPanel面板进行空间全备份步骤是：</p><p>　　首先，登录网站的cPanel控制面板，点击Backups按钮，进入备份页面。</p><p>　　1.备份全站文件，点击这里的HomeDirectory按钮，就会自动开始下载一个压缩文件，这个压缩文件中的是public_html目录下的全部文件，网站源程序就会下载到本地电脑。</p><p>　　2.备份数据库，点击DATABASES下面的数据库的名字，就会开始下载对应数据库的压缩包，如果有多个数据库，就要逐个点击并将其全部下载。待全站文件和数据库下载完毕就完成了一次整站备份。如果以后出现问题，就可以使用这些备份文件使用右侧的Upload功能进行无损恢复了。</p><p>　　<strong>使用网站系统的备份功能</strong></p><p>　　大部分网站程序会自带备份功能，有的自身不提供，也会有第三方开发者帮忙制作扩展程序。例如对于WordPress来说，就有类似WordPress Database Backup这样的扩展插件可以实现对WordPress数据库的备份。</p><p>　　<strong>使用第三方工具自动备份</strong></p><p>　　使用第三方工具备份是灵活度最大的一种备份方式，效率也相对较高，但较为依赖服务器本身提供的资源，如果服务器不提供某些功能，就无法实现第三方工具备份。这里推荐的第三方工具是Dropbox，该软件支持多种不同的操作系统，无最大单个文件的限制，免费账户总容量5G，对于单个网站备份足够。Dropbox对于网站备份的优势是支持文件版本控制，可以实现历史版本文件的恢复，这对于网站来说非常重要。</p>', '2015-03-10 17:00:00', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('9', '3', '谷歌拟推无人机提供网络接入服务', '0', '网络', '', '', '1', '588', '', '<p>　　谷歌即将正式宣布推出泰坦项目（Project Titan）&amp;mdash;一种由太阳能驱动的无人机，并将于今年某个时点投入使用。该项目将利用太阳能驱动的轻量型飞机作为远程卫星使用，利用盘旋在特定区域的无人机为人们提供网络覆盖。</p><p>　　桑德尔&amp;middot;皮蔡（Sundar Pichai）是谷歌资深副总裁，负责安卓、Chrome以及谷歌应用产品。他于周一在世界移动通信大会（MWC）上表示，目前全球大约有40亿人尚无法上网，而公司正在进行3个大型计划，旨在为这些人提供接触网络的机会。</p><p>　　皮蔡表示，泰坦项目将利用太阳能驱动的轻量型飞机作为远程卫星使用。公司于2014年收购了泰坦航空，当时有传言称Facebook也看上了这家无人机初创公司。谷歌打算利用盘旋在特定区域的无人机为人们提供网络覆盖，同时在灾害发生时亦可充当热点使用。</p><p>　　皮蔡称，泰坦项目目前的进度相当于两年前的Loon项目。与泰坦项目类似，Loon的构想是利用漂浮于空中的气球作为浮动基站，但较前者提供更宽广的覆盖范围。Loon已经在澳大利亚及南美展开测试。</p><p>　　&amp;ldquo;当我第一次听说这个想法时，我认为非常疯狂，因为这些气球的确是太大了，&amp;rdquo;皮蔡说道。&amp;ldquo;听起来很像科幻情节，但是在随后几年我们将看到重大进展，这些构想能够成为现实。&amp;rdquo;</p><p>　　谷歌的第三个计划称之为Project Blank，该计划于一年前启动，旨在为全球范围内的郊区提供网络连接。</p><p>　　&amp;ldquo;我们修建光纤网络，同时与本地提供商合作，提供4G服务，&amp;rdquo;皮蔡说道。&amp;ldquo;我们将于今年在非洲推出Project Plank。&amp;rdquo;</p><p>　　皮蔡同时谈到，一些大公司发起的活动，如Facebook的Internet.org倡议，正在让更多生活在偏远地区的人们得以接触网络，这是非常重要的举措。</p><p>　　Facebook的CEO马克&amp;middot;扎克伯格（Mark Zuckerberg）也计划于今晚在MWC 2015上进行演讲。</p>', '2015-03-10 00:00:00', '2015-03-16 15:43:12');
INSERT INTO `content` VALUES ('10', '3', '知名杀软Avast被关键字屏蔽', '0', '网络', '', '', '1', '73', '', '<p>　　知名免费杀毒软件Avast的域名被中国关键字屏蔽，该软件用户量过亿，已有数十年的历史，支持中文，在国外市场一直处于领先地位，公司位于捷克。</p><p>　　Avast是一家捷克软件公司的产品，诞生于1988年，目前在全球拥有2亿用户。</p><p>　　Avast有免费版和付费版，但不同版本的杀毒引擎是一样的，免费版相比其他版本最主要是少了&ldquo;沙盒功能&rdquo;、&ldquo;网络防火墙&rdquo;和&ldquo;反垃圾邮件&rdquo;等功能，对于一般个人用户来说，免费版的功能也基本够用。</p><p>　　Avast是个跨平台的安全软件，支持Windows、Linux、Mac等操作系统，还支持Android等手机，手机版功能主要包括：防病毒软件、隐私权报告、SMS/来电过滤、应用程序管理器、网页防护、防火墙等。</p>', '2015-03-10 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('11', '2', 'MWC2015亮点解读：华为海尔等扎堆发智能手表', '0', '网络', '', '', '1', '20', '', '<p>　　一年一度的科技盛会MWC2015今日在西班牙巴塞罗那召开，作为通信领域最具规模和影响的展会，此次MWC 2015上将有众多手机和硬件厂商参展并发布旗下的最新产品。</p><p>　　在笔者看来，虽然MWC影响力有被CES(和MWC齐名的科技盛会)超越的趋势，但本届MWC大会依然亮点多多。以下是笔者通过收到的媒体邀请函和大会第一天的盛况，总结出的三大亮点。</p><p>　　三星和HTC等发布年度旗舰新机</p><p>　　作为本届HTC最受期待的产品，莫过于三星几年来风头最盛的GALAXY系列机型。3月1日三星不负众望的发布了GALAXY S6，这款三星年底旗舰机型配备了5.1英寸2K分辨率的super AMOLED屏幕，同时将屏幕的亮度提升到600nit，在色彩表现以及解析力方面表现不错。在核心处理器方面，此次S6的两款新机均采用三星自家的Exynos 7系处理器，运行内存为3GB。同时配备前置500万像素+后置具备OIS防抖功能的1600万像素镜头。</p><p>　　HTC也发布了期待已久的M9，这款 M9采用高通Snapdragon 810八核处理器，3GB内存和2840mAh电池。默认32GB存储空间(可使用microSD卡进行扩展)。采用前置双扬声器BoomSound，新增杜比音频调节。可选颜色包括青铜色、灰色、银色，以及金银双色调版本可供选择。</p><p>　　另外，3月2日当天金立等厂商也会发布年度旗舰机型，只不过声音和势头较小，这里不做细表。</p><p>　　华为海尔LG等扎堆发布智能手表</p><p>　　以往的科技盛会，手机或者平板是主食，智能手表最多算配菜，但本届MWC却出现而来智能手表百家争鸣百花齐放的情况，一线的厂商海尔、华为、LG等纷纷发布了自己的智能手表。</p><p>　　华为在本次发布会上还推出了旗下首款智能手表&mdash;&mdash;华为Watch，基于Android Wear平台，采用了传统手机的设计风格，42毫米圆形表盘，屏幕表面为蓝宝石玻璃材质。华为Watch采用了1.4英寸的圆形AMOLED屏幕，分辨率为400&times;400像素，像素密度为286PPI。搭载高通1.2GHz处理器，512MB RAM和4GB ROM存储空间，内置心率传感器和气压传感器，可计算海拔，记录日常各种运动信息和睡眠监测。</p><p>　　LG发布旗下首款智能手表，这款LG Watch Urbane LTE智能手表能够支持4G网络，可实现接打电话、紧急拨号和实时翻译等功能。它能进行GPS定位，准确获知用户的位置。还可以进行实时对讲功能，多个用户可同时进行通话。</p><p>　　海尔则主打儿童和老人，发布的儿童版智能手表拥有一个0.96英寸的OLED屏幕，电池续航时间为两天，防水深度为30米。外观设计上，该系列提供了多种色彩方案，孩子可以按照自己的喜好进行选择。这款手表在儿童功能的优化上比较到位，可以直接通过机身的话筒和扬声器和家人通话，关键时刻还可以利用SOS键向3个不同电话号码发送求救信号。</p><p>　　平板电脑几乎不见踪影</p><p>　　手机和平板是近年来科技硬件最主流的消费品，但这一年两年来平板电脑的销量和影响力正在下滑，在本届MWC盛会上体现的尤为明显。</p><p>　　纵观各大媒体对MWC的报道，平板电脑的出镜率几乎为0，虽然海尔和华为等厂商也发布了自己的平板。在笔者看来，平板电脑本来就是一款历史的过渡产品，迟早要被更大屏幕的智能手机取代。</p><p>　　智能手机将在五年内能够进一步挤压平板电脑的生存空间，进而迫使其退出市场。原因在于：1.随着语音输入识别功能的提升，手机逐渐的能够解决输入问题，平板电脑输入上的优势将荡然无存。2.移动互联网经济也是口袋经济，而能放进口袋的智能手机比平板电脑更加便于携带。 3.智能手机的屏幕越来越大，当达到一定尺寸后，到时候就没有了智能手机和平板电脑的区分，平板电脑无意中必将被手机同化。</p><p>　　写在最后：中国其实也有自己的各种科技盛会和博览会，比如深圳IT峰会、科博会、网博会、中国互联网大会、China V 中国产业互联网峰会等等。但我们无奈的发现，中国一线科技厂商都喜欢跑到海外的科技大会发布自己的产品(虽然这些产品几乎都卖给中国人)，正如中国人跑到日本买马桶盖一样(其实这些所谓的日货马桶盖大部分都是中国生产，然后运到日本)，这是一种不自信的表现。</p><p>　　说白了，中国有强大的制造业，有优秀的厂商(在我看来OPPO、小米等公司生产的手机一点不比三星差)，也有海量的中产阶级消费者，什么时候中国的厂商能够在本土的展会上发布自己的产品，中国的消费者能够去本土的商城购买出口给日本的马桶盖，那才是一种真正的进步。</p><p>　　来源：投稿，本文作者系速途研究院院长丁道师 微博：丁道师 微信公众：dingdaoshi123</p>', '2015-03-09 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('12', '2', '付费软文推广有陷阱，你中招了没有？', '0', '网络', '', '', '1', '161', '', '<p>　　现在很多的人都在做软文推广，而且其中很多都是没有那么多渠道以及时间，所以做付费软文推广，这样效果来得更快更好。现在有很多软文服务平台，帮助推广者快速在高权重网站发稿并获得排名。</p><p>　　做付费软文推广的虽然比较多，但是这些服务平台也分三六九等，有些甚至有骗人的陷阱，所以大家在做付费软文推广的时候也需要自己注意。下面来看看一位网友在做软文付费推广中的一些经历，大家可以好好借鉴一下。</p><p>　　笔者最近做了一款互联网站品，在这个流量为王的时代，也想通过软文推广来拉拉流量。但并没有想象的那么简单，几天下来，碰到各种&ldquo;坑&rdquo;，在此写出来分享给大家，希望对准备做软文推广的小伙伴们一些参考和借鉴。</p><p>　　从开始，我就没有准备做免费的渠道，一来没有太多时间构思和写作&ldquo;广告味&rdquo;没那么浓的软文，二来也不太相信这个世界真有免费的午餐。所以免费的软文没什么经验，如果在这方面有做得比较好的可以交流交流。接下来就来主要谈谈收费的渠道。</p><p>　　现在有很多第三方机构专门做软文推广的，百度一下&ldquo;软文推广&rdquo;，第一页几乎全是广告，随便选一家。我选的这家是自助式的，也就是明码标价，自己充值，自己选择媒体，自己写文章，自己提交，审核通过后就可以发布了，一切看起来都那么美好，价格也不贵，主流媒体每篇也就100元左右。</p><p>　　于是我写了一篇，投稿发过去。等了一天，状态一直是审核中，第二天，等不及了，打电话过去被告知催一下媒体，又等了半天，被告知审核不通过。问其原因，也说不出个真正不通过的原因来，要求我换个媒体，价钱多退少补。想想，可能是我软文的广告味太浓，并且多退少补，也还公平。于是，换了另外一家价格差不多的媒体，没想到这次很快，一个小时内就审核上线了，还发给了我链接。当时一看，入口还是二级栏目的主页，想想第二天就被百度收录，被各大网站转发&hellip;&hellip;心里那个美啊。</p><p>　　然而，一天过去了，百度没有收录，两天过去了，依旧没有收录，并且没有任何网站转载，心里就感觉不对劲，以为文章被删除了，打开链接，还在啊，怎么回事？</p><p>　　再一看当时的二级版首页，文章没有了？看文章上一级目录的文章列表，也没有？这时我明白了&mdash;&mdash;我的辛辛苦苦写的文章被人为&ldquo;孤立&rdquo;了，也就是说没有任何链接指向我的页面，一个没有入口的页面，搜索引擎怎么可能抓取得到？</p><p>　　于是找客服咨询，这个客服开始他以为我不懂技术，跟我说不保证100%被搜索收录之类的。我说&ldquo;你入口都没有，当然不可能被收录&rdquo;？就这样，扯了半天。</p><p>　　但是，比约一个小时后，他突然告诉我百度已经收录了，并且还给了我截图，我当时就感到诧异，刚刚都没有的，怎么这么快就有了？但是，马上就发现问题了，首先，两篇文章的地址不一样，其次，发布时间也不一样。刚刚他给我的百度截图那篇是刚刚发布刚刚收录的。我一下子就明白了：原来是采用的拖延战术，一边在跟我绕圈子，一边在帮我重新发布。</p><p>　　但这次他学聪明了，明确告诉我不能保证100%有入口，怕我以后再找他们麻烦。</p><p>　　再后来，问了一位多年做软文推广的朋友，才明白了其中的奥秘：原来是一些媒体编辑私自和这些第三方推广平台合作，利用自己的职务之便，先将文章发布出去，但为了不给整个网站内容质量带来太大的影响，会很快将文章从列表中剔除出去，将文章&ldquo;孤立&rdquo;起来，链接也成了一个死链，这样就出现了&ldquo;虽然直接通过链接可以访问，但搜索引擎永远也找不到&rdquo;的情况，当然也不可能被转载，你保能通过他给你的那个链接自我欣赏了。</p><p>　　其实，选择一个好的媒体，软文推广意义还是很大的。所以给想做软文推广的朋友些建议：</p><p>　　1、不要急着一口气全发，先发一两篇文章试试效果，再确认一些靠谱的媒体；</p><p>　　2、如果发文量比较大，可以直接和一些媒体合作，不通过第三方发布平台，这样可靠得多，当然费用也贵很多。</p><p>　　写了这么多，希望对准备软文推广的站长有一些帮助。</p><p>　　注意，以上只是说这些第三方软文推广平台可能有问题，本身那些软文媒体，比如比特网、新浪网、腾讯网等媒体是没有问题的，文中所涉及到的也可能只是个别，但是也足以引起大家的注意。毕竟是付费的，如果没有效果那就比较亏了。</p>', '2015-03-08 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('13', '2', '美国通过网络中立新规', '0', '网络', '', '', '1', '49', '', '<p>　　2月26日，美国联邦通信委员会（FCC）提出并制定的&ldquo;网络中立&rdquo;在华盛顿以3：2的投票率得以得通过，这也成为美国政府为确保网络中立而展开的最为激进的尝试。新规将大幅扩大FCC对美国高速宽带提供商的监管，将其当做公用事业机构来监督。</p><p>　　简单来说，网络中立新规主要包含如下三点&mdash;&mdash;即不得封阻、不得限速、不得设置付费优先。</p><p>　　1、不得封阻（No Blocking）：宽带服务提供商不得封阻用户对于合法内容、应用程序、服务、或无害设备的访问；</p><p>　　2、不得限速（No Throttling）：宽带服务提供商不得损害或降低被法律所许可的互联网流量（包括内容、应用程序、服务、或无害的设备）；</p><p>　　3、不得设置付费优先（No Paid Prioritization）：宽带服务提供商不得提供差别化待遇，比如付费以得到更快的通道（fast lanes）。此外，&ldquo;网络中立&rdquo;新规还禁止了ISP们为部分客户提供按照优先级排序的内容服务的行为。</p><p>　　根据新规，网络运营商针对流媒体视频、游戏和其他通过其网络传输的内容进行降速的行为将被认定为非法行为。如果这些运营商为支付额外费用的网站开辟&ldquo;快车道&rdquo;，为其提供更快的网速，同样也会受到处罚。</p><p>　　互联网服务提供商表示，他们有可能通过司法手段反对这项新规。而保守派立法者已经对这些新规展开了抨击，认为这相当于由政府接管了互联网，因此呼吁推翻新规。</p><p>　　这项新规不仅涵盖了互联网服务提供商与用户之间的关系，还会监管他们与大型内容公司之间的关系。根据新规，FCC可以逐一调查内容公司与互联网服务提供商之间达成的协议，以便为终端用户提供更好的服务。</p><p>　　注释：网络中立（Network Neutrality）， 是指在法律允许范围内，任何人有权选择访问网络内容、运行应用程序、接入设备、选择服务提供商。这一原则要求平等对待所有互联网内容和访问，保证网络数据传输的&ldquo;中立性&rdquo;。</p>', '2015-03-07 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('14', '2', '中国政府采购封杀国外科技品牌', '0', '网络', '', '', '1', '30', '', '<p>　　路透社今日报道称，中国政府已经将一些全球知名技术品牌从政府采购名单中删除，同时又增加了上千种本土产品。有业内人士称，此举主要出于安全因素考虑。</p><p>　　路透社对官方数据分析后称，该决定的最大受害者是美国网络设备制造商思科公司。2012年中央政府采购中心的名单上共有60款思科的产品，而到了2014年底，竟然没有任何一款思科产品上榜。</p><p>　　此外，苹果公司的iPad和MacBook、英特尔旗下安全软件公司McAfee，知名反病毒软件赛门铁克和卡巴斯基，以及网络及服务器软件公司Citrix Systems也是被排除。而微软入围的个人操作系统是Windows7而不是Windows8系统。</p><p>　　在两年的时间内，中央政府采购中心名单上的商品数量增加了2000多个，目前总数量将近5000个，但增加的这些商品几乎全部为本土品牌。而被批准的国外科技产品的数量下滑了1/3，不到1/2的安全相关产品得以幸存。</p><p>　　中央政府采购中心的一位官员称，导致这种局面的因素有许多。例如，本土产品的数量较多，国内安全技术公司比国外公司提供了更多的产品保障等。</p><p>　　中国政府此举正值美国国家安全局(NSA)前雇员爱德华&middot;斯诺登(Edward Snowd)曝光了美国政府的大规模监控活动之际。据斯诺登称，NSA和美国联邦调查局(FBI)通过一个代号为&ldquo;<a target=\"_blank\" href=\"http://www.williamlong.info/archives/3510.html\">棱镜</a>&rdquo;的机密项目，直接利用9大美国顶级互联网公司的中央服务器，提取音频、视频、照片、电子邮件、文件和连接日志，以便帮助分析师追踪个人用户的动向和联系人。</p>', '2015-03-07 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('15', '2', '李彦宏谈百度与Google的区别', '0', '网络', '', '', '1', '397', '', '<p>　　据万科周刊报道，2014年12月下旬，郁亮带领万科80多人赴北京百度总部与百度董事长兼CEO李彦宏进行了一次深度对话，话题涉及创新激励、智能家居、职业经理人文化&hellip;&hellip;以下是部分现场对话实录。</p><p>　　1、百度与Google的差异</p><p>　　提问：我想问两个问题：一是百度和Google在发展战略上，或者具体的产品策略上有什么差异？第二，我想问一下360和搜狗等，会不会对百度有影响？</p><p>　　李彦宏：百度和Google的差异可以分为两个阶段来说。早期在PC阶段我们主要做的东西是UGC，User Generated Content，就是用户生产内容。这个和美国意义上的搜索不太一样，我们在发展过程当中不是被动地索引网上已经有的内容，而是在针对中国的用户、中国的互联网网民来创造内容。比如百度贴吧，全球最大的中文社区，每天有活跃用户近1亿人，他们的发言从2003年12月份到现在，每一个发言都留下来了，这些内容是被百度能检索到的。后来推出的百度知道、百度百科等等都是这样的理念，我们让用户创造门户，创造内容，再通过搜索引擎的技术进行搜索，这是在PC时代百度搜索在发展路径上，或者思路上和google最大的区别。</p><p>　　在移动互联网时代百度和Google也有非常大的区别，甚至是更大的理念上的区别。谷歌把更多的精力放在安卓生态系统上，怎么让安卓创造更多的APP，或者怎么再做出他们认为20年后可能会变得很大的产业，比如无人驾驶，或者健康方面的硬件，他们在想这种事情。</p><p>　　对于百度来说，我们想不仅仅连接信息，也连接服务。比如现在打开百度输入电影院，就告诉你说离这儿1.1公里有什么电影院，几点几分在放映什么片子，哪些座位你还可以买，选好自己的座位以后再付钱，一系列的动作都可以在百度里面完成。Google没有做这个事情，在他们看来这不是他的事，网上有什么东西我给你做索引就好了。在我们看来，中国的网民和用户，不管这个事是不是百度的责任，他只管说我在这里有没有得到我想要的东西。</p><p>　　这种理念我在早期也觉得比较难接受，比如别人在百度上搜到不好的内容，上当受骗了，但这信息不是百度的，我只是做索引而已，我一开始理念就是这样：这不是我的错。后来我们慢慢意识到说，如果别人认为这是你的错，这就是你的错，你就得想办法解决。所以后来我们做安全保障计划，就等于买保险，如果你通过百度搜索被骗了，虽然上的不是百度的网站，最后被骗了我们也赔你。这个理念慢慢转过来，事实是什么并不重要，重要的是别人怎么认为，如果别人这样认为你就想办法解决。</p><p>　　而到了移动互联网时代，我们发现别人百度时终极目的不是要看现在放什么片子，终极目的是要去那里看电影，我们就想办法满足他。所以我们希望用户在这儿不仅仅是能够获得知识、获得信息，还能够获得服务，这样对他来说更方便。幸运的是中国整体的实体经济发展的时间并不是特别长，所以传统产业都非常开放，愿意和互联网合作，这也是我们为什么能够跟电影院的IT系统接起来的原因。这是我们在移动互联网时代和Google最大的不一样。</p><p>　　刚才你提到国内也有搜索引擎的竞争对手。我觉得这是好事，多几家竞争对手，大家可以相互参考，相互借鉴，也逼着你更快提升。目前来说百度无论是在PC上还是在移动互联网上市场份额都是绝对的第一，在无线上份额还更高一些。</p><p>　　在无线时代，门槛变得更高了。因为连接服务不是简单的搜索引擎技术，要跟线下结合。同时越来越多的人通过语音、图像来表达需求。语音识别很难，图象识别更复杂、更难，这些技术百度远比其他的竞争对手要好。所以未来在这些方面差异化的体验也会越来越明显。总之，每一个公司都有自己不同的发展思路，我们有自己认定的东西，就紧紧朝着自己的方向往前跑，不太关注别人的方向走得怎么样。我们更关注的还是对用户需求的满足程度。</p><p>　　2、最关心产品是否被市场认可</p><p>　　提问：此前你提到是战略办去发现一个新的未来，当你们认准这可能是未来，决策是谁来决策？</p><p>　　李彦宏：大的战略肯定都是我来决策，战略办相当于参谋部一样。其实有一个劝说的过程，他们讲的过程中我会挑战他们。下面的人理论上来讲应该更敏感，更知道市场发生什么变化，他要向上讲我们需要怎么做。他讲的过程就是大家在形成共识，做出判断的过程。百度还有一个文化是Enjoy being challenged，喜欢被挑战。有时候大家理解为Enjoy challenge Others，不是，我们并不是鼓励你去挑战别人，是鼓励别人挑战你，或者说我作为一个个体，我特别喜欢别人来说我不同意。越被挑战，你自己的想法就会越完善，出错的几率就会越低。战略办跟我的工作关系也是这样的，如果他跟我讲，我会挑战他，如果我跟他讲，他也会挑战我，最后我们经过辩论形成一个共识。</p><p>　　提问：提一个问题，在你的战略决策里哪些考虑更多，比如规模、保持机密性，或者盈利，哪些是你做决策基本的出发点？另外，作为一家互联网公司每天面临很大的不确定性，你是不是要规划自己的收入增长速度、结构，在你的决策里面如何和财务这方面结合？还有，你是否会设想未来百度来自于搜索之外的收入会在百度公司里起到什么样的作用？</p><p>　　李彦宏：说实话，我对于收入、利润或未来3年的人员成长花的精力并不是很多，今年收入是多少我根本记不住，上个季度的盈利是多少我也记不住，我最最关注的问题是我们的东西会不会被市场所认可。昨天移动搜索量是多少我能记住，PC搜索量是多少，团购昨天的流水是什么，这些东西我能记住。这些东西意味着市场对你的认可，如果每天有很多人用这些东西，说明这个东西是市场接受的，所以我天天琢磨的是这个事。一个新技术应用后，市场的认可度产生了什么样的影响，流水有没有增加，平均每个用户的搜索次数有没有发生变化，每天使用语音搜索的人数有没有发生变化，他们表达需求的方式有没有发生变化？一旦方式发生变化，我们的满足度是提升了还是降低了？如果降低了我们怎么改进？我天天琢磨的是这种事。我觉得一旦东西被市场所认可了，你自然而然就会有收入，就会有利润，就会有好的成长空间。当然了，对我来说，我知道公司里有其他人，比如说CFO非常关心下一季度的利润怎么样，这是她关心的事，我可以不关心。</p><p>　　3、百度为什么要国际化？</p><p>　　提问：Robin我想问一个问题，百度是全球最好的中文搜索，为什么要走出去？在埃及、巴西等国家你怎么考虑的？在国际化过程中遇到什么样的挑战？</p><p>　　李彦宏：其实在我心目当中，我从来没有觉得百度是一个只做中国市场的公司，百度在2000年成立的时候，百度的logo不是现在这个样子，只有现在logo的左半边，没有百度那两个汉字。因为我那会儿觉得我们不是一个只做中国市场的公司，虽然我从中文搜索开始，但将来一定是全球化的公司。后来在发展过程中意识到想要全球化，必须先做好中国市场。但当时百度的名气很小，大多数人一看logo不知道是什么东西，只好加上了百度这两个汉字。再到国际化的时候，大多数国家的人不认识那两个汉字是什么意思，就觉得很纠结。后来我们说进入任何一个市场，百度左边的三分之二保留，右半边换成当地的语言。</p><p>　　我觉得搜索的技术、人员的素质完全可以全球化，只不过在美国搜索引擎发展更早一些，市场很大，这些公司也很强，不可能一上来就做美国市场。我最初选择是做日本市场，因为日本是第二大经济体，也没有一家独大的搜索引擎，当时雅虎和Google基本上是一半、一半的市场份额，在品牌知名度还没有完全建立的情况下消费者容易接受一个新的品牌。</p><p>　　后来我们开始转向发展中国家，发展中国家对一个来自中国的品牌接受度更高一些，市场发展更像中国三五年前的状况。但是我们也发现国际市场，尤其是发展中国家的市场比较小，需要培育，比如越南市场；但是当我们看到一个相对大一点的市场，像巴西，有更多的人口，拥有8000万台手机，我们觉得培养几年还是能够做出很有意思的东西来，所以我们就坚定地做。</p><p>　　我们的技术积累除了搜索，也有自动翻译，在小语种的国家，我们起码可以让那些网民能够更方便的阅读英文文件、中文文件。所以我们也有自己独特的价值，我们可以在那些市场上提供更好的服务。我的思路还是先被市场认可，先在那个地方动起来，然后再考虑怎么挣钱。</p><p>　　4、百度CEO最大本事应是对变化作出判断</p><p>　　提问：Google曾经有职业经理人，而且很长时间主政，百度在过去15年都是你，从创业人士一直到现在成为这么大规模的公司，你在这个过程中的体会和学到的东西有什么？</p><p>　　李彦宏：这是一个很好的问题，百度成立的时候我们的投资者也明确跟我讲，希望引入一个职业经理人来做CEO，我说没问题。所以在百度的头5年，我自己并不是CEO，我是总裁，把CEO的位置空着，什么时候找到了，什么时候让他来做CEO。找了5年说实话没找到，找的这个过程也是逐步对业务的认识过程。慢慢到2005年要上市的时候，公司要上市不能没有CEO，于是在写招股书的时候谁是CEO？我说我还是做CEO吧，从那时候正式变成了百度CEO。其实我一直觉得如果能找到合适的CEO，我立刻都可以让出来，都是没有问题的。</p><p>　　为什么后来一直没有找到呢？我也考虑过这个问题。</p><p>　　我觉得是因为我们这个市场变化太快，一个迅速变化的市场，公司领导人或者CEO最大的本事应该是什么呢？是对变化做出判断。用户行为发生什么变化，新的生态对我们来说有什么危险，有什么机会？这些东西不是职业经理人擅长的。典型的职业经理人擅长的是什么？你只会管500人对吧，我会管5000人、1万人，他会干这个东西。但是一个互联网公司，在一个每年成长100%甚至200%的业务上，你会干这个东西是不足够的，甚至不必要。像我不会干这个东西，但是我觉得我也能带领公司往前走，原因是对于这样的行业和公司来说，对CEO的要求主要还是对业务的精准判断。</p><p>　　如果是职业经理人，他4年以后退休了，4年以后这个公司获得多大的收益对他来说没有那么重要。我刚才讲的移动转型，我2年之内把运营利润率从53%变到29%，职业经理人是不敢做这个事的，但创始人、企业家有魄力去做，这也是为什么这么多年来我一直在做CEO。但我的心态仍然是开放的，任何时候能够找到有一个人来做这个位置，我就会很高兴的把位置让出来。</p><p>　　提问：百度跟房地产一直有一些合作，包括百度乐居、投资安居客等，是否方便介绍一下百度和房地产的合作是怎样定位的？以及刚刚提到的百度开放的思路和平台如何在房地产上得到体现？</p><p>　　李彦宏：房地产是一个非常大的市场，可以通过多种形式来进行合作。有一类是跟房地产的网站进行合作，这种合作对我们来说是最容易的，因为他已经是一个互联网公司，思维就是互联网思维，不需要我们去教他，大多数情况下都是他们主动找上门说我需要买你这么多流量，你怎么给我导更多的客户过去，只要求我们在这方面想办法。但跟真正的开发商合作，我们还要更多了解他的真实需求，然后再看看我们这边的东西怎么跟他进行对接。百度完全是开放的，完全根据客户自己的喜好，以及他们对市场的认识。对于每一个垂直行业来说，我不是最懂，垂直行业里的人才最懂这些东西，我们只是配合的角度。</p>', '2015-03-05 00:00:00', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('16', '3', '熊海内容管理系统即将开源', '1', '熊海', 'cms', '熊海内容管理系统即将开源', '1', '78', '../upload/image/20150316/80811426496287.jpg', '<p>感谢大家长久以来对熊海开发程序的关注。</p><p>熊海内容管理系统即将开源，本系统可广泛使用，系统完全免费，开源。</p><p>随着网络应用的丰富和发展，很多网站往往不能迅速跟进大量信息衍生及业务模式变革的脚步，常常需要花费许多时间、人力和物力来处理信息更新和维护工作；遇到网站扩充的时候，整合内外网及分支网站的工作就变得更加复杂，甚至还需重新建设网站；如此下去，用户始终在一个高成本、低效率的循环中升级、整合……</p><p>于是，我们听到许多用户这样的反馈：</p><p>页面制作无序，网站风格不统一，大量信息堆积，发布显得异常沉重；<br/>内容繁杂，手工管理效率低下，手工链接视音频信息经常无法实现；<br/>应用难度较高，许多工作需要技术人员配合才能完成，角色分工不明确；<br/>改版工作量大，系统扩展能力差，集成其它应用时更是降低了灵活性；</p>', '2015-03-16 10:16:10', '2015-03-16 17:17:49');
INSERT INTO `content` VALUES ('17', '4', '关于熊海个人网站V1.0后台不能登录的问题', '0', '熊海', '', '', '1', '24', '', '<p>在程序发布时，的确测试完成，没有发现任何问题，后来经过网友们的反映，发现的确有后台无法登录的问题。</p><p>这一类问题都发生在空间是linux操作系统服务器上，Windows服务器上则没有这个问题。</p><p>因为之前没有linux系统的空间或者服务器，我将于近日修复这一问题。</p>', '2015-03-16 15:31:27', '0000-00-00 00:00:00');
INSERT INTO `content` VALUES ('18', '4', '欢迎使用熊海CMS内容管理系统', '1', '熊海', '熊海内容管理系统', '熊海内容管理系统', '1', '104', '../upload/image/20150321/75711426907499.jpg', '<p>熊海内容管理系统目前已经开发完成，文章模块、下载模块、友情链接模块，代码高亮、广告模块、文件图片上传、图片水印、图片缩略图。</p><p>部份模块添加多种实用功能，欢迎体验。</p><p>如果你在使用中遇到任何问题，请加群与我们一起探讨：QQ群：22206973</p><p>官网：<a href=\"http://www.isea.pw\">www.isea.pw</a></p><p>博客：<a href=\"http://www.isea.so\">www.isea.so</a></p>', '2015-03-17 15:24:09', '2015-03-21 11:25:41');

-- ----------------------------
-- Table structure for download
-- ----------------------------
DROP TABLE IF EXISTS `download`;
CREATE TABLE `download` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `images` varchar(255) DEFAULT NULL,
  `hit` int(11) DEFAULT NULL,
  `xiazai` int(11) DEFAULT NULL,
  `daxiao` varchar(255) DEFAULT NULL,
  `language` varchar(255) DEFAULT NULL,
  `version` varchar(255) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `demo` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `softadd` varchar(255) DEFAULT NULL,
  `softadd2` varchar(255) NOT NULL,
  `xs` int(11) NOT NULL,
  `content` longtext,
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of download
-- ----------------------------
INSERT INTO `download` VALUES ('1', '下载一', '', '', '../upload/soft/20150321/64291426907432.jpg', '2', '0', '0MB', 'PHP', 'V1.0', '熊海CMS', 'http://www.isea.pw', 'http://www.isea.so', '', '#', '1', '<p>这是一条演示内容。</p>', '2015-03-21 11:10:32');

-- ----------------------------
-- Table structure for imageset
-- ----------------------------
DROP TABLE IF EXISTS `imageset`;
CREATE TABLE `imageset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `img_kg` int(11) DEFAULT NULL,
  `img_logo` varchar(255) DEFAULT NULL,
  `img_weizhi` int(11) DEFAULT NULL,
  `img_slt` int(11) DEFAULT NULL,
  `img_moshi` int(11) DEFAULT NULL,
  `img_wzkd` varchar(255) DEFAULT NULL,
  `img_wzgd` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of imageset
-- ----------------------------
INSERT INTO `imageset` VALUES ('1', '0', '../upload/watermark/59751426560003.png', '3', '0', '2', '305', '202');

-- ----------------------------
-- Table structure for interaction
-- ----------------------------
DROP TABLE IF EXISTS `interaction`;
CREATE TABLE `interaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) DEFAULT NULL,
  `cid` int(11) DEFAULT NULL,
  `xs` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `mail` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `touxiang` varchar(255) DEFAULT NULL,
  `shebei` varchar(255) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `content` longtext,
  `tz` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `rip` varchar(255) DEFAULT NULL,
  `rshebei` varchar(255) DEFAULT NULL,
  `rcontent` longtext NOT NULL,
  `rdate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of interaction
-- ----------------------------
INSERT INTO `interaction` VALUES ('1', '3', '1', '1', '岁月', 'me@isea.so', 'http://www.isea.so', '79', 'PC', '121.62.142.214', '不错的系统，希望以后能一直更新。', '1', '2015-03-19 16:05:53', '121.62.142.214', 'PC', '感谢支持！', '2015-03-19 16:06:35');
INSERT INTO `interaction` VALUES ('2', '2', '0', '1', '岁月', 'me@isea.so', 'http://www.isea.so', '79', 'PC', '121.62.142.214', '正在等待这个系统的开源，希望尽快啊！', '1', '2015-03-19 16:09:08', '121.62.142.214', 'PC', '', '2015-03-19 16:09:27');
INSERT INTO `interaction` VALUES ('3', '2', '0', '1', '卖碟', '86226999@qq.com', '', '38', 'iPhone', '101.226.125.109', '上海在排队外拍，支持一下啊。', '0', '2015-03-19 18:09:11', '121.62.157.209', 'PC', '欢迎！', '2015-03-19 18:14:38');

-- ----------------------------
-- Table structure for link
-- ----------------------------
DROP TABLE IF EXISTS `link`;
CREATE TABLE `link` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `mail` varchar(255) DEFAULT NULL,
  `jieshao` varchar(255) DEFAULT NULL,
  `xs` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of link
-- ----------------------------
INSERT INTO `link` VALUES ('1', '熊海博客', 'http://www.isea.so', 'me@isea.so', '原创独立个人博客', '1', '2015-03-17 15:10:16');
INSERT INTO `link` VALUES ('2', '熊海个人网站', 'http://www.isea.pw', 'me@isea.so', '熊海个人网站', '1', '2015-03-17 15:15:30');

-- ----------------------------
-- Table structure for manage
-- ----------------------------
DROP TABLE IF EXISTS `manage`;
CREATE TABLE `manage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `img` varchar(255) DEFAULT NULL,
  `mail` varchar(255) DEFAULT NULL,
  `qq` varchar(255) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of manage
-- ----------------------------
INSERT INTO `manage` VALUES ('1', 'admin', 'admin', 'e10adc3949ba59abbe56e057f20f883e', '../upload/touxiang/25381426725729.jpg', 'me@isea.so', '86226999', '2015-03-21 08:36:03');

-- ----------------------------
-- Table structure for nav
-- ----------------------------
DROP TABLE IF EXISTS `nav`;
CREATE TABLE `nav` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `xs` int(11) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `px` int(11) DEFAULT NULL,
  `content` longtext,
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nav
-- ----------------------------
INSERT INTO `nav` VALUES ('1', '关于', '', '', '1', 'about', '1', '1', '<p>&nbsp;请在后台栏目设置编辑这里的内容</p>', '2015-03-21 11:03:18');
INSERT INTO `nav` VALUES ('2', '列表', '', '', '1', 'list', '2', '2', '', '2015-03-21 10:50:34');
INSERT INTO `nav` VALUES ('3', '下载', '', '', '1', 'download', '3', '3', '', '2015-03-10 15:36:04');
INSERT INTO `nav` VALUES ('4', '联系', '', '', '1', 'contact', '4', '4', '<p>请在后台栏目编辑这里的内容<br/></p><p><br/></p>', '2015-03-21 11:03:45');

-- ----------------------------
-- Table structure for navclass
-- ----------------------------
DROP TABLE IF EXISTS `navclass`;
CREATE TABLE `navclass` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nav` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `tuijian` int(11) unsigned NOT NULL DEFAULT '0',
  `xs` int(11) DEFAULT NULL,
  `px` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of navclass
-- ----------------------------
INSERT INTO `navclass` VALUES ('1', '2', '分类一', '', '', '1', '1', '1', '2015-03-21 10:49:55');
INSERT INTO `navclass` VALUES ('2', '2', '分类二', '', '', '1', '1', '2', '2015-03-21 10:50:07');
INSERT INTO `navclass` VALUES ('3', '2', '分类三', '', '', '1', '1', '3', '2015-03-21 10:50:15');
INSERT INTO `navclass` VALUES ('4', '2', '分类四', '', '', '0', '1', '4', '2015-03-21 10:50:23');

-- ----------------------------
-- Table structure for seniorset
-- ----------------------------
DROP TABLE IF EXISTS `seniorset`;
CREATE TABLE `seniorset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lysh` varchar(255) DEFAULT NULL,
  `plsh` varchar(255) DEFAULT NULL,
  `pltz` varchar(255) DEFAULT NULL,
  `huifu` varchar(255) DEFAULT NULL,
  `fjryx` varchar(255) DEFAULT NULL,
  `fjrmc` varchar(255) DEFAULT NULL,
  `hxdz` varchar(255) DEFAULT NULL,
  `faname` varchar(255) DEFAULT NULL,
  `fapass` varchar(255) DEFAULT NULL,
  `smtpname` varchar(255) DEFAULT NULL,
  `z_jsmail` varchar(255) DEFAULT NULL,
  `z_title` varchar(255) DEFAULT NULL,
  `h_title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of seniorset
-- ----------------------------
INSERT INTO `seniorset` VALUES ('1', '0', '0', '0', '0', '', '', '', '', '', '', '', '熊海博客上有新的', '您在熊海博客上的');

-- ----------------------------
-- Table structure for settings
-- ----------------------------
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `stitle` varchar(255) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `zz` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `tel` varchar(255) DEFAULT NULL,
  `mail` varchar(255) DEFAULT NULL,
  `qq` varchar(255) DEFAULT NULL,
  `icp` varchar(255) DEFAULT NULL,
  `bottominfo` varchar(255) DEFAULT NULL,
  `tongji` varchar(255) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of settings
-- ----------------------------
INSERT INTO `settings` VALUES ('1', '欢迎使用熊海内容管理系统(SEACMS)', 'SEACMS V 1.0', '欢迎使用 SEACMS', '', '', '熊海', 'http://www.isea.pw', '123456789', 'me@isea.so', '123456789', '', '© 2015 SEACMS V1.0& 保留所有权利 ', '<script src=\"http://s19.cnzz.com/stat.php?id=3801251&web_id=3801251\" language=\"JavaScript\"></script>', '2015-03-21 11:12:59');
