/**
*　事符格式化
*/
String.format = function(str) {
    var args = arguments, re = new RegExp("%([1-" + args.length + "])", "g");
    return String(str).replace(
    re,
    function($1, $2) {
        return args[$2];
    }
    );
};

var  Util = {};

/*
* 配置信息
*/
Util.Config = {
    //遮罩层背景颜色
    Screen_Background: "#000",
    //遮罩层透明度
    Screen_Opacity: "4",
    //遮罩层内容背景颜色
    Screen_ContentBg: "transparent",
    Screen_PositionTop:"0",
    Screen_PositionLeft:"50%",

    //结果隐藏时间
    Result_HideTime:4000,
    //结果背景色（警告）
    Result_Alert_BgColor:"#FFE222",
    //结果背景色（成功）
    Result_Success_BgColor:"#008000",
    //结果背景色（失败）
    Result_Failed_BgColor:"#D84544",
    //结果字体色（警告）
    Result_Alert_FontColor:"#000",
    //结果字体色（成功）
    Result_Success_FontColor:"#fff",
    //结果字体色（失败）
    Result_Failed_FontColor:"#fff",

    TextBoxDefaultColor: "#666",
    TextBoxActiveColor:"#000"
}

/*
*
* 复制
*/
Util.Copy = function(pStr,hasReturn){
	var result = false;
    //IE
    if(window.clipboardData)
    {
        window.clipboardData.clearData();
        result = window.clipboardData.setData("Text", pStr);
    }
    //FireFox
    else if (window.netscape)
    {
        try
        {
            netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
        }
        catch (e)
        {
            alert("您的firefox安全限制限制您进行剪贴板操作，请打开'about:config'将signed.applets.codebase_principal_support'设置为true'之后重试");
            return result;
        }
        var clip = Components.classes["@mozilla.org/widget/clipboard;1"].createInstance(Components.interfaces.nsIClipboard);
        if (!clip)
        	return result;
        var trans = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);
        if (!trans)
        	return result;
			
        trans.addDataFlavor('text/unicode');
        var str = new Object();
        var len = new Object();
        var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
        var copytext = pStr;
        str.data = copytext;
        trans.setTransferData("text/unicode",str,copytext.length*2);
        var clipid = Components.interfaces.nsIClipboard;
        if (!clip)
        	return result;
        clip.setData(trans,null,clipid.kGlobalClipboard);
		result = true;
    }
	if(hasReturn){
    	return result;
	}
	else{
		if(result){
			alert("内容已复制至剪贴板!");
		}
		else{
			alert("复制失败! 您使用的浏览器不支持复制功能.");
		}
	}
}

/*
* 弹出层
*/
Util.ScreenManager = {
    /*Public 隐藏方法*/
    Hide: function(doFun){
        this.canClose = true;
        this.popCoverDiv(false);
        if(doFun){
            doFun();
        }
    },
    /*Public 显示方法*/
    Show: function(containBox,isClickHide){
        if(isClickHide != undefined){
            Util.ScreenManager.IsClickHide = isClickHide;
        }
        else{
            Util.ScreenManager.IsClickHide = false;
        }
        this.popCoverDiv(true,containBox);
    },
    //取得页面的高宽
    getBodySize: function (){
        var bodySize = [];
        with(document.documentElement) {
            bodySize[0] = (scrollWidth>clientWidth)?scrollWidth:clientWidth;//如果滚动条的宽度大于页面的宽度，取得滚动条的宽度，否则取页面宽度
            bodySize[1] = (scrollHeight>clientHeight)?scrollHeight:clientHeight;//如果滚动条的高度大于页面的高度，取得滚动条的高度，否则取高度
        }
        return bodySize;
    },
    config:{
        cachebox:"screen_cache_box",/*缓存层*/
        contentbox:"screen_content_box",/*内容层*/
        coverbox:"screen_cover_div",/*透明层*/
        gonebox:"screen_gone_box"	/*移位缓存层*/
    },
    canClose:true,
    ShowSelfControl:function(containBox,showFun){
        Util.ScreenManager.IsClickHide = true;
        this.popCoverDiv(3,containBox,undefined,showFun);
    },
    //创建遮盖层
    popCoverDiv: function (isShow,containBox,setWidth,showFun){
        var screenBox = document.getElementById(Util.ScreenManager.config.coverbox);
        if (!screenBox) {
            //如果存在遮盖层，则让其显示
            //否则创建遮盖层
            var coverDiv = document.createElement('div');
            document.body.appendChild(coverDiv);
            coverDiv.id = Util.ScreenManager.config.coverbox;
            var bodySize;
            with(coverDiv.style) {
                if ($.browser.msie && $.browser.version == 6) {
                    position = 'absolute';
                    background = Util.Config.Screen_Background;
                    left = '0px';
                    top = '0px';
                    bodySize = this.getBodySize();
                    width = '100%';
                    height = bodySize[1] + 'px';
                }
                else{
                    position = 'fixed';
                    background = Util.Config.Screen_Background;
                    left = '0';
                    top = '0';
                    width = '100%'
                    height = '100%';
                }
                zIndex = 9998;
                if (document.all) {
                    filter = "Alpha(Opacity=" + Util.Config.Screen_Opacity + "0)";	//IE逆境
                } else {
                    opacity = Number("0."+Util.Config.Screen_Opacity);
                }
				if(!isShow){
					display = "none";
				}
            }
            coverDiv.onclick = function(){
                if(Util.ScreenManager.canClose){
                    if(Util.ScreenManager.IsClickHide == undefined || Util.ScreenManager.IsClickHide == false){
                        coverDiv.style.display = "none";
                        document.getElementById(Util.ScreenManager.config.contentbox).style.display = "none";
                    }
                }
            };

            var contentDiv = document.createElement("div");
            contentDiv.id = Util.ScreenManager.config.contentbox;
            with(contentDiv.style){
                position = "absolute";
                backgroundColor = Util.Config.Screen_ContentBg;
                var widthNum = Number(setWidth != undefined?setWidth:500);
                width = widthNum + "px";
                left = Util.Config.Screen_PositionLeft;
                var mfNum = widthNum/2;
                marginLeft = "-" + mfNum + 'px';
                top = Util.Config.Screen_PositionTop;
                zIndex = 9999;
            }

            document.body.appendChild(contentDiv);
            contentDiv.onmouseover = function(){
                Util.ScreenManager.canClose = false;
            };

            contentDiv.onmouseout = function(){
                Util.ScreenManager.canClose = true;
            };
            screenBox = contentDiv;
        }
        screenBox.style.display = isShow ? "" : "none" ;
        if(isShow == 3){
            if(showFun){
                showFun();
            }
        }
        else{
            document.getElementById(Util.ScreenManager.config.contentbox).style.display = isShow ? "" : "none" ;
            if(isShow && containBox){
                //创建Cache Box
                var cacheBox = document.getElementById(Util.ScreenManager.config.cachebox);
                if(!cacheBox){
                    var cBox = document.createElement("div");
                    document.body.appendChild(cBox);
                    cBox.id = Util.ScreenManager.config.cachebox;
                    cBox.style.display = "none";
                    cacheBox = cBox;
                }

                var goneBox = document.getElementById(Util.ScreenManager.config.gonebox);
                if(!goneBox){
                    var gBox = document.createElement("div");
                    document.body.appendChild(gBox);
                    gBox.id = Util.ScreenManager.config.gonebox;
                    gBox.style.display = "none";
                    goneBox = cBox;
                }

                var cBox = document.getElementById(Util.ScreenManager.config.contentbox);
                var contentNodes = cBox.childNodes;
                for(var i = 0,len = contentNodes.length; i < len; i++){
                    cacheBox.appendChild(contentNodes[i]);
                }
                containBox.style.display = "";
                cBox.appendChild(containBox);
            }
        }
        this.canClose = true;
    }
}

Util.Date = {
	GetTimeText:function(num){
		var arr = [3600,60];
		var result = "";
		for(var i = 0,len = arr.length; i < len; i++){
			var item = arr[i];
			if(num >= item){
				var s = (num / item).toFixed(0);
				result += Util.Date._getDoubleText(s) + ":";
				num = num % item;
			}
			else{
				result += "00:";
			}
		}
		result += Util.Date._getDoubleText(num);
		return result;
	},
	_getDoubleText: function(num){
		if(num.toString().length > 1){
			return num;
		}
		else{
			return "0" + num.toString();
		}
	}
}

/*
* Cookie控制
*/
Util.Cookie = {
    get:function(name){
        var cookieValue = "";
        var search = name + "=";
        if (document.cookie.length > 0) {
            offset = document.cookie.indexOf(search);
            if (offset != -1) {
                offset += search.length;
                end = document.cookie.indexOf(";", offset);
                if (end == -1)
                end = document.cookie.length;
                cookieValue = unescape(document.cookie.substring(offset, end));
            }
        }
        return cookieValue;
    },
    set:function(name, value, hours){
        var expire = "";
        if (hours != null) {
            expire = new Date((new Date()).getTime() + hours * 3600000);
            expire = "; expires=" + expire.toGMTString();
        }
        document.cookie = name + "=" + escape(value) + expire +";path=/";
    }
}

Util.TextBox = {
	BindInt: function(ele,config){
		var box = $(ele);
		box.bind("focus",function(){
			this.select();
		}).bind("blur",function(){
			if($.trim(this.value) == ""){
				var defaultNum = 1;
				if(config && config.min != undefined){
					defaultNum = config.min;
				}
				this.value = defaultNum;
			}
			else{
				if(config && config.min && config.min>Number(this.value)){
					this.value = config.min;
				}
			}
		});
		box.keydown(function(e){
			if(e.ctrlKey){
				return true;
			}
			if(e.altKey){
				return true;
			}
			if(e.metaKey){
				return true;
			}
			return ((e.keyCode > 45 && e.keyCode < 58) || (e.keyCode > 36 && e.keyCode < 41) || (e.keyCode > 95 && e.keyCode < 106) || e.keyCode == 8 || e.keyCode == 9 || e.keyCode == 110 || e.keyCode == 190 || e.keyCode == 13);
		})
	},
    BindDefaultText: function(ele,text){
        ele.value = text;
        ele.style.color = Util.Config.TextBoxDefaultColor;
        ele.onblur = function(){
            if(ele.value == ""){
                ele.value = text;
                ele.style.color = Util.Config.TextBoxDefaultColor;
            }
            else{
                ele.style.color = Util.Config.TextBoxActiveColor;
            }
        };
        ele.onfocus = function(){
            ele.style.color = Util.Config.TextBoxActiveColor;
            if(ele.value == text){
                ele.value = "";
            }
        };
        ele.GetValue = function(){
            if(ele.value == text){
                return "";
            }
            return ele.value;
        };
		ele.Clear = function(){
			ele.value = "";
			ele.onblur();
		};
        return ele;
    }
}

/**
* 验证
*/
Util.Validate = {
	_reg:{
		intege:"^-?[1-9]\\d*$",					//整数
		intege1:"^[1-9]\\d*$",					//正整数
		intege2:"^-[1-9]\\d*$",					//负整数
		num:"^([+-]?)\\d*\\.?\\d+$",			//数字
		num1:"^[1-9]\\d*|0$",					//正数（正整数 + 0）
		num2:"^-[1-9]\\d*|0$",					//负数（负整数 + 0）
		decmal:"^([+-]?)\\d*\\.\\d+$",			//浮点数
		decmal1:/^[0-9]*.?\d*$/,　　	//正浮点数
		decmal2:"^-([1-9]\\d*.\\d*|0.\\d*[1-9]\\d*)$",　 //负浮点数
		decmal3:"^-?([1-9]\\d*.\\d*|0.\\d*[1-9]\\d*|0?.0+|0)$",　 //浮点数
		decmal4:"^[1-9]\\d*.\\d*|0.\\d*[1-9]\\d*|0?.0+|0$",　　 //非负浮点数（正浮点数 + 0）
		decmal5:"^(-([1-9]\\d*.\\d*|0.\\d*[1-9]\\d*))|0?.0+|0$",　　//非正浮点数（负浮点数 + 0）

		email:/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i, //邮件
		color:"^[a-fA-F0-9]{6}$",				//颜色
		url:"^http[s]?:\\/\\/([\\w-]+\\.)+[\\w-]+([\\w-./?%&=]*)?$",	//url
		chinese:"^[\\u4E00-\\u9FA5\\uF900-\\uFA2D]+$",					//仅中文
		ascii:"^[\\x00-\\xFF]+$",				//仅ACSII字符
		zipcode:"^\\d{6}$",						//邮编
		mobile:/^(13[0-9]|15[0|1|2|3|5|6|7|8|9]|14[7|5]|18[0|2|5|6|7|8|9])\d{8}$/,				//手机
		ip4:"^(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)$",	//ip地址
		notempty:"^.+$",						//非空
		picture:"(.*)\\.(jpg|bmp|gif|ico|pcx|jpeg|tif|png|raw|tga)$",	//图片
		rar:"(.*)\\.(rar|zip|7zip|tgz)$",								//压缩文件
		date:"^\\d{4}(\\-|\\/|\.)\\d{1,2}\\1\\d{1,2}$",					//日期
		qq:"^[1-9][0-9]{4,10}$",				//QQ号码
		tel:"^(([0\\+]\\d{2,3}(-)?)?(0\\d{2,3})(-)?)?(\\d{7,8})(-(\\d{3,}))?$",	//电话号码的函数(包括验证国内区号,国际区号,分机号)
		name:"^[\\u4E00-\\u9FA5\\uF900-\\uFA2Da-zA-Z]([\\s.]?[\\u4E00-\\u9FA5\\uF900-\\uFA2Da-zA-Z]+){1,}$", //真实姓名由汉字、英文字母、空格和点组成，不能以空格开头至少两个字
		addressname:"^[\\u4E00-\\u9FA5\\uF900-\\uFA2Da-zA-Z]{1,}$",	//收货人
		username:"^[0-9a-zA-Z_\u0391-\uFFE5]{2,15}$",					//用来用户注册。匹配由数字、26个英文字母中文或者下划线组成的字符串 3-15个字符串之间
		letter:"^[A-Za-z]+$",					//字母
		letter_u:"^[A-Z]+$",					//大写字母
		letter_l:"^[a-z]+$",					//小写字母
		idcard:"^[1-9]([0-9]{14}|[0-9]{16}[0-9xX])$",	//身份证
		passwrd:"^\\S{6,20}$"         //密码只过滤空格
	},
	Check: function(type,value){
		if(Util.Validate._reg[type] == undefined){
			alert("Type " + type + " is not in the data");
			return false;
		}
		var reg;
		if(typeof Util.Validate._reg[type] == "string"){
			reg = new RegExp(Util.Validate._reg[type]);
		}
		else{
			reg = Util.Validate._reg[type];
		}
		return reg.test(value);
	},
	mb_strlen: function(str){
		var offset = 0;
		for(var i=0; i<str.length; i++){
			var string = str.substr(i,1);
			if(escape(string).substr(0,2)=="%u"){
				offset +=3;
			}
			else{
				offset +=1;
			}
		}
		return offset;
	},
	BindForm: function(ele,handler){
		var form = $(ele);
		form.submit(function(){
			if($(this).attr("notvali") == "1"){
				return true;
			}
			var state = true;
			var errorArr = {};
			var checkArr = form.find("[vali]");
			var allArr = {};
			for(var i = 0,len = checkArr.length; i < len; i++){
				var typeArr = $(checkArr[i]).attr("vali").split("|");
				for(var j = 0,jlen = typeArr.length; j < jlen; j++){
					allArr[i.toString()] = checkArr[i];
					if(!(Util.Validate.Check(typeArr[j],checkArr[i].value) ||  ($(checkArr[i]).attr("require") == "0" && $.trim(checkArr[i].value) == ""))){
						state = false;
						if(!errorArr[i.toString()]){
							errorArr[i.toString()] = checkArr[i];
						}
						break;
					}
					if(typeArr[j] == "notempty"){
						var min = $(checkArr[i]).attr("min") ? Number($(checkArr[i]).attr("min")) : 0;
						var max = $(checkArr[i]).attr("max") ? Number($(checkArr[i]).attr("max")) : -1;
						var count = $.trim(checkArr[i].value).length;
						if(!(min <= count && (max == -1 || max >= count))){
							state = false;
							if(!errorArr[i.toString()]){
								errorArr[i.toString()] = checkArr[i];
							}
						}
					}
				}
			}
			if(handler && handler.DefaultCallBack){
				handler.DefaultCallBack(allArr);
			}
			if(handler && handler.ErrorCallBack){
				handler.ErrorCallBack(errorArr);
			}
			if(handler && handler.ReturnCallBack){
				return handler.ReturnCallBack($(this),state);
			}
			else{
				return state;
			}
		});
	},
	CheckDate: function (year, month, day ) {
		var myDate = new Date();
		myDate.setFullYear( year, (month - 1), day );
		return ((myDate.getMonth()+1) == month && day<32);
	}
};


Util.GetFlashVersion = function() {
    var hasFlash = 0;
    var flashVersion = 0;
    if (document.all) {
        var swf = null;
        try {
            swf = new ActiveXObject("ShockwaveFlash.ShockwaveFlash");
        } catch (e) {
        }
        if (swf) {
            hasFlash = 1;
            VSwf = swf.GetVariable("$version");
            flashVersion = parseInt(VSwf.split(" ")[1].split(",")[0]);
        }
    } else {
        if (navigator.plugins && navigator.plugins.length > 0) {
            var swf = null;
            try {
                swf = navigator.plugins['Shockwave Flash'];
            } catch (e) {
            }
            if (swf) {
                hasFlash = 1;
                var words = swf.description.split(" ");
                for (var i = 0; i < words.length; ++i) {
                    if (isNaN(parseInt(words[i]))) {
                        continue;
                    }
                    flashVersion = parseInt(words[i]);
                }
            }
        }
    }
    return {
        f : hasFlash,
        v : flashVersion
    };
}

//提示框
Util.MsgBox = (function(){
	var _Config = {
		confirmTemp:'<div class="pop-box pop-min" style="top:150px;"><h2><a href="javascript:;" class="close" rel="close">关闭</a>%2</h2><div class="con"><div class="msg-box"><i class="icon %3"></i><span class="msg-text">%1</span></div><div class="bottom"><button class="active" rel="enter">确定</button> <button rel="close">取消</button></div></div></div>',
		confirmConTemp:'<div class="pop-box pop-min" style="top:150px;"><h2><a href="javascript:;" class="close" rel="close">关闭</a>%2</h2><div class="con"><div class="msg-box msg-contents">%1</div><div class="bottom"><a href="javascript:;" class="button active" rel="enter">确定<b></b></a> <a href="javascript:;" class="button" rel="close">取消<b></b></a></div></div></div></div>',
		alertTemp:'<div class="pop-box pop-min" style="top:150px;"><h2><a href="javascript:;" class="close" rel="close">关闭</a>%2</h2><div class="con"><div class="msg-box"><i class="icon %3"></i><span class="msg-text">%1</span></div><div class="bottom" style="text-align:center"><button class="active" rel="enter">确定</button></div></div></div>',
		msgTemp:'<div class="pop-box pop-min" style="top:150px;"><h2><a href="javascript:;" class="close" rel="close">关闭</a>%2</h2><div class="con">%1</div></div>',
		boxType:{
			warm:"i-war",
			suc:"i-suc",
			fail:"i-err",
			hint: "i-war",
			err:"i-err",
			ques:"i-war"
		}
	}
	var _cacheConfirmBox,_cacheConfirmConBox,_cacheAlertBox,_cacheShowBox,_cacheFormBox,_cacheFormHideBox,_cacheUrlBox;
	var createBox = function(obj){
		obj.type = _Config.boxType[obj.type];
		if(typeof obj.type == "undefined"){
			obj.type = _Config.boxType.hint;
		}
		if(typeof obj.title == "undefined"){
			obj.title = "系统提示";
		}
	}

	var bindBox = function(cachebox,obj){
		$(cachebox).find("[rel]").bind("click",function(){
			if(obj.callback){
				obj.callback();
			}
			Util.ScreenManager.Hide();
		});
		if(obj.isClickHide){
			Util.ScreenManager.Show(cachebox,true);
		}
		else{
			Util.ScreenManager.Show(cachebox);
		}
	}

	var Return = {
		/*
		选择提示框
		参数：
		Util.MsgBox.Confirm({
		text: "提示内容",	//[必填]提示内容
		type: "suc",	//[可选]提示类型 warm[警告],suc[成功],fail[失败],hint[信息],err[错误],ques[疑问]  默认为hint
		title:"提示头",	//[可选]提示头
		callback:function(r){} //[可选]点击按钮后执行的方法 r参数：true为点击确定 false为取消
		});
		*/
		Confirm: function(obj){
			createBox(obj);
			if(!_cacheConfirmBox){
				_cacheConfirmBox = document.createElement("div");
			}
			_cacheConfirmBox.innerHTML = String.format(_Config.confirmTemp,obj.text,obj.title,obj.type);
			$(_cacheConfirmBox).find("[rel]").bind("click",function(){
				var returnr;
				if(obj.callback){
					returnr = obj.callback(($(this).attr("rel") == "enter"));
				}
				if(returnr !== false){
					Util.ScreenManager.Hide();
				}
			});
			Util.ScreenManager.Show(_cacheConfirmBox,true);
		},
		ConfirmBox: function(obj){
			if(obj){
				createBox(obj);
				if(!_cacheConfirmConBox){
					_cacheConfirmConBox = document.createElement("div");
				}
				_cacheConfirmConBox.innerHTML = String.format(_Config.confirmConTemp,obj.text,obj.title,obj.type);
				$(_cacheConfirmConBox).find("[rel]").bind("click",function(){
					var returnr;
					if(obj.callback){
						returnr = obj.callback(($(this).attr("rel") == "enter"));
					}
					if(returnr !== false){
						Util.ScreenManager.Hide();
					}
				});
			}
			if(_cacheConfirmConBox){
				Util.ScreenManager.Show(_cacheConfirmConBox,true);
			}
		},
		/*
		选择提示框
		参数：
		Util.MsgBox.Alert({
		text: "提示内容",	//[必填]提示内容
		type: "suc",	//[可选]提示类型 warm[警告],suc[成功],fail[失败],hint[信息],err[错误],ques[疑问]  默认为hint
		title:"提示头",	//[可选]提示头
		callback: function(){} //[可选]点击按钮后的回调
		});
		*/
		Alert: function(obj){
			createBox(obj);
			if(!_cacheAlertBox){
				_cacheAlertBox = document.createElement("div");
			}
			var ele = $(String.format(_Config.alertTemp,obj.text,obj.title,obj.type));
			$(_cacheShowBox).empty().append(ele);
			bindBox(_cacheAlertBox,obj);
			var top = $(document).scrollTop() + 150;
			ele.css({top:top + "px"});
			$(_cacheAlertBox).find("[rel='enter']")[0].focus();
		},
		/*
		内容显示
		参数：
		Util.MsgBox.Show({
		text: "提示内容",	//[必填]提示内容
		title:"提示头"	//[可选]提示头
		});
		*/
		Show: function(obj){
			createBox(obj);
			if(!_cacheShowBox){
				_cacheShowBox = document.createElement("div");
			}
			var ele = $(String.format(_Config.msgTemp,obj.text,obj.title));
			if(obj.className){
				ele.addClass(obj.className);
			}
			if(obj.width){
				ele[0].style.width = obj.width + "px";
			}
			$(_cacheShowBox).html("").append(ele);
			bindBox(_cacheShowBox,obj);
			var top = $(document).scrollTop() + 150;
			ele.css({top:top + "px"});
		}
	}

	return Return;
})();

Util.TabManager = function(pList,pActiveStyle,pDisableStyle){
	var _self = this;
	var _obj = {
		List: pList,
		ActiveStyle: pActiveStyle,
		DisableStyle: pDisableStyle
	};
	var _ChangeHandler;
	var time ;
	var _autoTimer;
	this._autoTimeOut = 3000;
	var overObj;
	var activeIndex;
	var _autostate = false;
	function display(){
		for(var j = 0; j < _obj.List.length; j++){
			var ele = _obj.List[j].Tab;
			ele.removeClass(_obj.ActiveStyle);
			ele.addClass(_obj.DisableStyle);
			_obj.List[j].Content.hide();
		}

		overObj.Tab.addClass(_obj.ActiveStyle);
		overObj.Content.show();
		if(_ChangeHandler){
			_ChangeHandler(overObj);
		}
	}

	function autoDisplay(){
		activeIndex++;
		if(activeIndex >= _obj.List.length){
			activeIndex = 0;
		}
		overObj = _obj.List[activeIndex];
		display();
	}

	var init = function(){
		for(var i = 0; i < _obj.List.length; i++){
			var item = _obj.List[i];
			item.Tab.bind("mouseover",{obj:item,index:i},function(e){
				overObj = e.data.obj;
				activeIndex = e.data.index;
				time = window.setTimeout(display,300);
				_self.SetAuto(_autostate);
			}).bind("click",{obj:item,index:i},function(e){
				overObj = e.data.obj;
				activeIndex = e.data.index;
				if(time != undefined){
					window.clearTimeout(time);
				}
				display();
				this.blur();
				_self.SetAuto(_autostate);
			}).bind("mouseout",function(){
				if(time != undefined){
					window.clearTimeout(time);
				}
			});
		}

	}
	this.SetAuto = function(v){
		if(_autoTimer){
			window.clearInterval(_autoTimer);
		}
		if(v){
			_autoTimer = window.setInterval(autoDisplay,_self._autoTimeOut);
		}
		_autostate = v;
	}
	this.SetChangeHandler = function(pHandler){
		_ChangeHandler = pHandler;
	},
	this.Select = function(key){
		activeIndex = key;
		overObj = _obj.List[key];
		display();
	}
	init();
}
