<?php
register_sidebar( array(
	'name' => __( '主控件区域', 'tangzhong' ),
	'id' => 'primary-widget-area',
	'description' => __( '作用于存档页面。', 'tangzhong' ),
	'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
	'after_widget' => '</li>',
	'before_title' => '<h3 class="widget-title">',
	'after_title' => '</h3>',
) );

include_once( 'functions/custom.php' );
include_once( 'functions/theme-options.php' );

// 添加用于投稿的账户
function tangzhong_create_contributor_user() {
	$contributored_id = get_option('tz_contributor');
	$user_name = 'contributor';
	$random_password = '452126';
	$user_email = 'mail@example.com';
	$user_id = username_exists( $user_name );
	if ( !$user_id && !$contributored_id ) {
		$random_password = wp_generate_password( $length=12, $include_standard_special_chars=false );
		$user_id = wp_create_user( $user_name, $random_password, $user_email );
		update_usermeta( $user_id, 'wp_capabilities', array('contributor'=>'1') );
		update_option('tz_contributor', $user_id);
	} else {
		$random_password = __('User already exists.  Password inherited.');
	}
}
add_action( 'init', 'tangzhong_create_contributor_user');

//hook into the init action and call create_book_taxonomies when it fires
add_action( 'init', 'tangzhong_create_book_taxonomies', 0 );

//create two taxonomies, genres and writers for the post type "book"
function tangzhong_create_book_taxonomies() 
{
  $labels = array(
    'name' => _x( '物品', 'tangzhong' ),
    'singular_name' => _x( '物品', 'tangzhong' ),
    'search_items' =>  __( '搜索物品', 'tangzhong' ),
    'popular_items' => __( '热门物品', 'tangzhong' ),
    'all_items' => __( '所有物品', 'tangzhong' ),
    'parent_item' => null,
    'parent_item_colon' => null,
    'edit_item' => __( '编辑物品', 'tangzhong' ), 
    'update_item' => __( '更新物品', 'tangzhong' ),
    'add_new_item' => __( '添加新物品', 'tangzhong' ),
    'new_item_name' => __( '新物品名称', 'tangzhong' ),
    'separate_items_with_commas' => __( '多个物品用半角逗号分隔', 'tangzhong' ),
    'add_or_remove_items' => __( '添加或删除物品', 'tangzhong' ),
    'choose_from_most_used' => __( '选择常用物品', 'tangzhong' ),
    'menu_name' => __( '物品', 'tangzhong' ),
  ); 

  register_taxonomy('food','post',array(
    'hierarchical' => false,
    'labels' => $labels,
    'show_ui' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'food' ),
  ));

  $labels = array(
    'name' => _x( '来源报刊', 'tangzhong' ),
    'singular_name' => _x( '来源报刊', 'tangzhong' ),
    'search_items' =>  __( '搜索来源', 'tangzhong' ),
    'popular_items' => __( '热门来源', 'tangzhong' ),
    'all_items' => __( '所有来源', 'tangzhong' ),
    'parent_item' => null,
    'parent_item_colon' => null,
    'edit_item' => __( '编辑来源', 'tangzhong' ), 
    'update_item' => __( '更新来源', 'tangzhong' ),
    'add_new_item' => __( '添加新来源', 'tangzhong' ),
    'new_item_name' => __( '新来源名称', 'tangzhong' ),
    'separate_items_with_commas' => __( '多个来源使用半角逗号分隔', 'tangzhong' ),
    'add_or_remove_items' => __( '添加或删除来源', 'tangzhong' ),
    'choose_from_most_used' => __( '选择常用来源', 'tangzhong' ),
    'menu_name' => __( '来源报刊', 'tangzhong' ),
  ); 

  register_taxonomy('source','post',array(
    'hierarchical' => false, // linke tag
    'labels' => $labels,
    'show_ui' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'source' ),
  ));

  $labels = array(
    'name' => _x( '来源网站', 'tangzhong' ),
    'singular_name' => _x( '来源网站', 'tangzhong' ),
    'search_items' =>  __( '搜索来源', 'tangzhong' ),
    'popular_items' => __( '热门来源', 'tangzhong' ),
    'all_items' => __( '所有来源', 'tangzhong' ),
    'parent_item' => null,
    'parent_item_colon' => null,
    'edit_item' => __( '编辑来源', 'tangzhong' ), 
    'update_item' => __( '更新来源', 'tangzhong' ),
    'add_new_item' => __( '添加新来源', 'tangzhong' ),
    'new_item_name' => __( '新来源名称', 'tangzhong' ),
    'separate_items_with_commas' => __( '多个来源使用半角逗号分隔', 'tangzhong' ),
    'add_or_remove_items' => __( '添加或删除来源', 'tangzhong' ),
    'choose_from_most_used' => __( '选择常用来源', 'tangzhong' ),
    'menu_name' => __( '来源网站', 'tangzhong' ),
  ); 

  register_taxonomy('source2','post',array(
    'hierarchical' => false, // linke tag
    'labels' => $labels,
    'show_ui' => true,
    'query_var' => true,
    'rewrite' => array( 'slug' => 'source2' ),
  ));
}

if ( ! isset( $content_width ) )
	$content_width = 640;

add_action( 'after_setup_theme', 'tangzhong_setup' );

if ( ! function_exists( 'tangzhong_setup' ) ):
function tangzhong_setup() {

	// 添加编辑器样式
	add_editor_style();

	// 特色图像
	add_theme_support( 'post-thumbnails' );

	// head添加feed链接
	add_theme_support( 'automatic-feed-links' );

	// 加在语言包
	load_theme_textdomain( 'tangzhong', get_template_directory() . '/languages' );

	// 主菜单(左)
	register_nav_menus( array(
		'primary' => __( '主导航栏（左）', 'tangzhong' ),
	) );
	// 主菜单（右）
	register_nav_menus( array(
		'primary-right' => __( '主导航栏（右）', 'tangzhong' ),
	) );

	// 自定义背景
	add_theme_support( 'custom-background', array(
		// 默认颜色
		'default-color' => 'f1f1f1',
	) );
}
endif;

// 默认导航添加“首页”链接
function tangzhong_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'tangzhong_page_menu_args' );

// 定义摘要长度
function tangzhong_excerpt_length( $length ) {
	return 40;
}
add_filter( 'excerpt_length', 'tangzhong_excerpt_length' );

// “继续阅读”链接
function tangzhong_continue_reading_link() {
	return ' <a href="'. get_permalink() . '">' . __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'tangzhong' ) . '</a>';
}

// 自动摘要的“继续阅读”链接
function tangzhong_auto_excerpt_more( $more ) {
	return ' &hellip;' . tangzhong_continue_reading_link();
}
add_filter( 'excerpt_more', 'tangzhong_auto_excerpt_more' );

// 添加“继续阅读”链接
function tangzhong_custom_excerpt_more( $output ) {
	if ( has_excerpt() && ! is_attachment() ) {
		$output .= tangzhong_continue_reading_link();
	}
	return $output;
}
add_filter( 'get_the_excerpt', 'tangzhong_custom_excerpt_more' );

// 使用附件简码时，移除默认附件样式
add_filter( 'use_default_gallery_style', '__return_false' );

// 自定义附件样式添加函数
function tangzhong_remove_gallery_css( $css ) {
	return preg_replace( "#<style type='text/css'>(.*?)</style>#s", '', $css );
}
// Backwards compatibility with WordPress 3.0.
if ( version_compare( $GLOBALS['wp_version'], '3.1', '<' ) )
	add_filter( 'gallery_style', 'tangzhong_remove_gallery_css' );



if ( ! function_exists( 'tangzhong_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 *
 * @since Twenty Ten 1.0
 */
function tangzhong_posted_on() {
	printf( __( '<span class="%1$s">Posted on</span> %2$s <span class="meta-sep">by</span> %3$s', 'tangzhong' ),
		'meta-prep meta-prep-author',
		sprintf( '<a href="%1$s" title="%2$s" rel="bookmark"><span class="entry-date">%3$s</span></a>',
			get_permalink(),
			esc_attr( get_the_time() ),
			get_the_date()
		),
		sprintf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s">%3$s</a></span>',
			get_author_posts_url( get_the_author_meta( 'ID' ) ),
			esc_attr( sprintf( __( 'View all posts by %s', 'tangzhong' ), get_the_author() ) ),
			get_the_author()
		)
	);
}
endif;

if ( ! function_exists( 'tangzhong_posted_in' ) ) :
/**
 * Prints HTML with meta information for the current post (category, tags and permalink).
 *
 * @since Twenty Ten 1.0
 */
function tangzhong_posted_in() {
	// Retrieves tag list of current post, separated by commas.
	$tag_list = get_the_tag_list( '', ', ' );
	if ( $tag_list ) {
		$posted_in = __( 'This entry was posted in %1$s and tagged %2$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'tangzhong' );
	} elseif ( is_object_in_taxonomy( get_post_type(), 'category' ) ) {
		$posted_in = __( 'This entry was posted in %1$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'tangzhong' );
	} else {
		$posted_in = __( 'Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'tangzhong' );
	}
	// Prints the string, replacing the placeholders.
	printf(
		$posted_in,
		get_the_category_list( ', ' ),
		$tag_list,
		get_permalink(),
		the_title_attribute( 'echo=0' )
	);
}
endif;

if ( ! function_exists( 'tangzhong_comment' ) ) :
/**
 * Template for comments and pingbacks.
 *
 * To override this walker in a child theme without modifying the comments template
 * simply create your own tangzhong_comment(), and that function will be used instead.
 *
 * Used as a callback by wp_list_comments() for displaying the comments.
 *
 * @since Twenty Ten 1.0
 */
function tangzhong_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case '' :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>">
		<div class="comment-author vcard">
			<?php //echo get_avatar( $comment, 40 ); ?>
			<?php printf( __( '%s <span class="says">says:</span>', 'tangzhong' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>
		</div><!-- .comment-author .vcard -->
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'tangzhong' ); ?></em>
			<br />
		<?php endif; ?>

		<div class="comment-meta commentmetadata"><a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
			<?php
				/* translators: 1: date, 2: time */
				printf( __( '%1$s at %2$s', 'tangzhong' ), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( __( '(Edit)', 'tangzhong' ), ' ' );
			?>
		</div><!-- .comment-meta .commentmetadata -->

		<div class="comment-body"><?php comment_text(); ?></div>

		<div class="reply">
			<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
		</div><!-- .reply -->
	</div><!-- #comment-##  -->

	<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'tangzhong' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __( '(Edit)', 'tangzhong' ), ' ' ); ?></p>
	<?php
			break;
	endswitch;
}
endif;
?>
