<?php
/**
 * [TANGZHONG.ORG]主题选项面板
 */
include_once('theme-interface.php');
$options = tangzhong_admin_options_variable();





/**
 * 选项面板打印样式
 */
function tangzhong_admin_options_content() {
	global $texts, $options;
	foreach( $options as $panel ) {
		if( $_GET['page'] == $panel['page'] ) {
			$tabs_content = '<h2 class="nav-tab-wrapper">';
			$options_content = '<div id="tables">';

			$tabs = $panel['content'];
			for( $i = '0'; $i < count($tabs); $i++ ) {
				$tabs_content .= '<a href="#'.($i+1).'" class="nav-tab">'.$tabs[$i]['label'].'</a>';
				$options_content .= '<table class="form-table">';
				$options_content .= '<tbody>';
				$options_content .= '<tr valign="top"><td colspan="2">'.$tabs[$i]['desc'].'<p class="submit"><input type="button" class="top-botton button-primary" value="'.$texts['submit'].'"></p></td></tr>';
				$indep = false;

				foreach( $tabs[$i]['content'] as $option ) {
					if( $tabs[$i]['name'] ) {
						$values = get_option($tabs[$i]['name']);
						$value = $values[$option['name']] == '' ? $option['std'] : $values[$option['name']];
					} else {
						$value = get_option($option['name']) == '' ? $option['std'] : get_option($option['name']);
					}
					switch( $option['type'] ) {
						case 'tr-td':
							$indep = true;
							$options_content .= '<tr valign="top">';
							$options_content .= '<th scope="row">';
							$options_content .= $option['label'] ? $option['label'] : '';
							$options_content .= '</th>';
							$options_content .= '<td>';
						break;
						case 'td-tr':
							$indep = false;
							$options_content .= '</td>';
							$options_content .= '</tr>';
						break;
						case 'image':
							if( $indep ) {
								$options_content .= $option['label'] ? '<label for="'.$option['name'].'">'.$option['label'].'</label>' : '';
								$options_content .= '<input type="text" name="'.$option['name'].'" id="'.$option['name'].'" class="'.( $option['small'] ? 'small-text' : 'regular-text' ).'" value="'.$value.'" />';
								$options_content .= '<input type="button" class="upload-button" value="'.$texts['upload'].'" />';
								$options_content .= ' <a href="javascript:void(0)" class="view-image">'.$texts['view'].'</a>';
								$options_content .= $option['desc'] ? ' <p class="description">'.$option['desc'].'</p>' : '';
								$options_content .= $option['sep'] ? '<div class="clear"><br /></div>' : '';
							} else {
								$options_content .= '<tr valign="top">';
								$options_content .= '<th scope="row">';
								$options_content .= $option['label'] ? '<label for="'.$option['name'].'">'.$option['label'].'</label>' : '';
								$options_content .= '</th>';
								$options_content .= '<td>';
								$options_content .= '<input type="text" name="'.$option['name'].'" id="'.$option['name'].'" class="'.( $option['small'] ? 'small-text' : 'regular-text' ).'" value="'.$value.'" />';
								$options_content .= '<input type="button" class="upload-button" value="'.$texts['upload'].'" />';
								$options_content .= ' <a href="javascript:void(0)" class="view-image">'.$texts['view'].'</a>';
								$options_content .= $option['desc'] ? ' <p class="description">'.$option['desc'].'</p>' : '';
								$options_content .= '</td>';
								$options_content .= '</tr>';
							}
						break;
						case 'text':
							if( $indep ) {
								if( ($option['label'] || $option['desc']) && $option['small'] ) {
									$options_content .= '<label for="'.$option['name'].'">';
									$options_content .= $option['label'] ? $option['label'].' ' : '';
									$options_content .= '<input type="text" name="'.$option['name'].'" id="'.$option['name'].'" class="'.( $option['small'] ? 'small-text' : 'regular-text' ).'" value="'.$value.'" />';
									$options_content .= $option['desc'] ? ' '.$option['desc'] : '';
									$options_content .= '</label>';
								} else {
									$options_content .= $option['label'] ? '<label for="'.$option['name'].'">'.$option['label'].' </label>' : '';
									$options_content .= '<input type="text" name="'.$option['name'].'" id="'.$option['name'].'" class="'.( $option['small'] ? 'small-text' : 'regular-text' ).'" value="'.$value.'" />';
									$options_content .= $option['desc'] ? ' <span class="description">'.$option['desc'].'</span>' : '';
								}
								$options_content .= $option['sep'] ? '<div class="clear"><br /></div>' : '';
							} else {
								$options_content .= '<tr valign="top">';
								$options_content .= '<th scope="row">';
								$options_content .= $option['label'] ? '<label for="'.$option['name'].'">'.$option['label'].'</label>' : '';
								$options_content .= '</th>';
								$options_content .= '<td>';
								$options_content .= '<input type="text" name="'.$option['name'].'" id="'.$option['name'].'" class="'.( $option['small'] ? 'small-text' : 'regular-text' ).'" value="'.$value.'" />';
								$options_content .= $option['desc'] ? ' <span class="description">'.$option['desc'].'</span>' : '';
								$options_content .= '</td>';
								$options_content .= '</tr>';
							}
						break;
						case 'color':
							if( $indep ) {
								$options_content .= '<div class="color-box">';
								$options_content .= $option['label'] ? $option['label'].' ' : '';
								$options_content .= '<input type="text" name="'.$option['name'].'" id="'.$option['name'].'" class="color small-text" value="'.$value.'" />';
								$options_content .= ' <span class="description">'.$texts['def-val'].'<a href="javascript:void(0)" class="def-val">'.$option['std'].'</a> '.$option['desc'].'</span>';
								$options_content .= '</div>';
								$options_content .= '<div class="colorpicker" style="position: absolute; z-index: 55555;"></div>';
								$options_content .= $option['sep'] ? '<div class="clear"><br /></div>' : '';
							} else {
								$options_content .= '<tr valign="top">';
								$options_content .= '<th scope="row">';
								$options_content .= $option['label'] ? '<label for="'.$option['name'].'">'.$option['label'].'</label>' : '';
								$options_content .= '</th>';
								$options_content .= '<td>';
								$options_content .= '<div class="clear">';
								$options_content .= '<input type="text" name="'.$option['name'].'" id="'.$option['name'].'" class="color small-text" value="'.$value.'" />';
								$options_content .= ' <span class="description">'.$texts['def-val'].'<a href="javascript:void(0)" class="def-val">'.$option['std'].'</a> '.$option['desc'].'</span>';
								$options_content .= '</div>';
								$options_content .= '<div class="colorpicker" style="position: absolute;"></div>';
								$options_content .= '</td>';
								$options_content .= '</tr>';
							}
						break;
						case 'textarea':
							if( $indep ) {
								if( $option['data'] == 'html' ) {
									$options_content .= $option['label'] ? '<p><span class="li-ico">&hearts;</span> '.$option['label'].'</p>' : '';
									ob_start();
									wp_editor( $value, $option['name'], array() );
									$options_content .= ob_get_contents();
									ob_end_clean();
									$options_content .= $option['desc'] ? '<p class="description"><span class="li-ico2">&diams;</span> '.$option['desc'].'</p>' : '';
								} else {
									$options_content .= $option['label'] ? '<label for="'.$option['name'].'"><span class="li-ico">&hearts;</span> '.$option['label'].'</label>' : '';
									$options_content .= '<textarea name="'.$option['name'].'" id="'.$option['name'].'" cols="50" rows="5" class="large-text">'.$value.'</textarea>';
									if( $option['data'] == 'code' ) {
										$options_content .= '<p class="description"><a href="javascript:void(0)" class="'.$option['name'].'" rel="#overlay">[预览]</a>&nbsp;'.$texts['code'].'</p>';
									}
									$options_content .= $option['desc'] ? '<p class="description"><span class="li-ico2">&diams;</span> '.$option['desc'].'</p>' : '';
								}
								$options_content .= $option['sep'] ? '<div class="clear"><br /></div>' : '';
							} else {
								$options_content .= '<tr valign="top">';
								$options_content .= '<th scope="row">';
								$options_content .= $option['label'] ? '<p>'.$option['label'].'</p>' : '';
								$options_content .= '</th>';
								$options_content .= '<td>';
								if( $option['data'] == 'html' ) {
									ob_start();
									wp_editor( $value, $option['name'], array() );
									$options_content .= ob_get_contents();
									ob_end_clean();
									$options_content .= $option['desc'] ? '<p class="description"><span class="li-ico2">&diams;</span> '.$option['desc'].'</p>' : '';
								} else {
									$options_content .= $option['desc'] ? '<p><label for="'.$option['name'].'"><span class="li-ico">&hearts;</span> '.$option['desc'].'</label></p>' : '';
									$options_content .= '<textarea name="'.$option['name'].'" id="'.$option['name'].'" cols="50" rows="5" class="large-text">'.$value.'</textarea>';
									if( $option['data'] == 'code' ) {
										$options_content .= '<p class="description">'.$texts['code'].'</p>';
									}
								}
								$options_content .= '</td>';
								$options_content .= '</tr>';
							}
						break;
						case 'checkbox':
							if( $indep ) {
								$options_content .= $option['label'] ? ' <p><span class="li-ico">&hearts;</span> '.$option['label'].'</p>' : '';
								foreach( $option['source'] as $checkbox ) {
									$options_content .= '<label><input type="checkbox" name="'.$option['name'].'[]" class="" value="'.$checkbox['0'].'"'.( in_array($checkbox['0'], $value) ? ' checked="checked"' : '' ).'> '.$checkbox['1'].'</label><br />';
								}
								$options_content .= $option['desc'] ? ' <p class="description"><span class="li-ico2">&diams;</span> '.$option['desc'].'</p>' : '';
								$options_content .= $option['sep'] ? '<div class="clear"><br /></div>' : '';
							} else {
								$options_content .= '<tr valign="top">';
								$options_content .= '<th scope="row">';
								$options_content .= $option['label'] ? '<p>'.$option['label'].'</p>' : '';
								$options_content .= '</th>';
								$options_content .= '<td>';
								foreach( $option['source'] as $checkbox ) {
									$options_content .= '<label><input type="checkbox" name="'.$option['name'].'[]" class="" value="'.$checkbox['0'].'"'.( in_array($checkbox['0'], $value) ? ' checked="checked"' : '' ).'> '.$checkbox['1'].'</label><br />';
								}
								$options_content .= $option['desc'] ? ' <p class="description">'.$option['desc'].'</p>' : '';
								$options_content .= '</td>';
								$options_content .= '</tr>';
							}
						break;
						case 'radio':
							if( $indep ) {
								$options_content .= $option['label'] ? ' <p><span class="li-ico">&hearts;</span> '.$option['label'].'</p>' : '';
								$radios = $option['source'];
								for( $a = '0'; $a < count($radios); $a++ ) {
									$options_content .= '<label><input type="radio" name="'.$option['name'].'" id="'.$option['name'].($a+1).'" class="" value="'.$radios[$a]['0'].'"'.( $radios[$a]['0'] == $value ? ' checked="checked"' : '' ).'> '.$radios[$a]['1'].'</label><br />';
								}
								$options_content .= $option['desc'] ? ' <p class="description"><span class="li-ico2">&diams;</span> '.$option['desc'].'</p>' : '';
								$options_content .= $option['sep'] ? '<div class="clear"><br /></div>' : '';
							} else {
								$options_content .= '<tr valign="top">';
								$options_content .= '<th scope="row">';
								$options_content .= $option['label'] ? '<p>'.$option['label'].'</p>' : '';
								$options_content .= '</th>';
								$options_content .= '<td>';
								$radios = $option['source'];
								for( $b = '0'; $b < count($radios); $b++ ) {
									$options_content .= '<label><input type="radio" name="'.$option['name'].'" id="'.$option['name'].($b+1).'" class="" value="'.$radios[$b]['0'].'"'.( $radios[$b]['0'] == $value ? ' checked="checked"' : '' ).'> '.$radios[$b]['1'].'</label><br />';
								}
								$options_content .= $option['desc'] ? ' <p class="description">'.$option['desc'].'</p>' : '';
								$options_content .= '</td>';
								$options_content .= '</tr>';
							}
						break;
						case 'select':
							if( $indep ) {
								$options_content .= $option['label'] ? ' <p><span class="li-ico">&hearts;</span> '.$option['label'].'</p>' : '';
								$options_content .= $option['label'] || $option['desc'] ? '<label for="'.$option['name'].'">'.$option['label'] : '';
								$options_content .= '<select name="'.$option['name'].'" id="'.$option['name'].'">';
								foreach( $option['source'] as $select ) {
									$options_content .= '<option value="'.$select['0'].'"'.( $select['0'] == $value ? ' selected="selected"' : '' ).'>'.$select['1'].'</option>';
								}
								$options_content .= '</select>';
								$options_content .= $option['label'] || $option['desc'] ? $option['desc'].'</label>' : '';
								$options_content .= $option['sep'] ? '<div class="clear"><br /></div>' : '';
							} else {
								$options_content .= '<tr valign="top">';
								$options_content .= '<th scope="row">';
								$options_content .= $option['label'] ? '<label for="'.$option['name'].'">'.$option['label'].'</label>' : '';
								$options_content .= '</th>';
								$options_content .= '<td>';
								$options_content .= '<select name="'.$option['name'].'" id="'.$option['name'].'">';
								foreach( $option['source'] as $select ) {
									$options_content .= '<option value="'.$select['0'].'"'.( $select['0'] == $value ? ' selected="selected"' : '' ).'>'.$select['1'].'</option>';
								}
								$options_content .= '</select>';
								$options_content .= $option['desc'] ? '<span class="description">'.$option['desc'].'</span>' : '';
								$options_content .= '</td>';
								$options_content .= '</tr>';
							}
						break;
					}
				}

				$options_content .= '</tbody>';
				$options_content .= '</table>';
			}

			$tabs_content .= '</h2>';
			$options_content .= '</div>'; ?>
<!-- [TANGZHONG.THEME.OPTIONS.PANEL.START] -->
<div class="wrap">

	<div id="icon-themes" class="icon32"><br></div>
	<?php echo '<span class="title">['.get_current_theme().']&trade;</span>'; ?>
	<?php echo $tabs_content; if( $_POST['submit'] ) {
		echo '<div id="setting-error-settings_updated" class="updated settings-error"><p><strong>设置已保存。</strong></p></div>'; } ?>
	<form id="myform" method="post" action="options.php">
		<?php echo $options_content; ?>
		<table class="form-table"><tr valign="top"><td><?php echo $panel['desc']; ?></td><th scope="row"><?php submit_button($texts['submit'], 'button-primary', 'submit'); ?></th></tr></table>
	</form>
</div>
<!-- [TANGZHONG.THEME.OPTIONS.PANEL.STOP] -->
			<?php
		}
	}
}





/**
 * 设置保存
 */
 function tangzhong_admin_options_save() {
	global $menu_title, $options, $texts;
	 if( isset( $_POST['submit'] ) ) {
		foreach( $options as $panel ) { // 面板
			if( $_GET['page'] == $panel['page'] ) {
				foreach( $panel['content'] as $tab ) {
					if( $tab['name'] ) {
						$tab_option = get_option($tab['name']) ? get_option($tab['name']) : array();
						foreach( $tab['content'] as $option ) {
							if( $option['type'] == 'textarea' && ($option['data'] == 'html' || $option['data'] == 'code') ) {
								$tab_option[$option['name']] = stripslashes( $_POST[$option['name']] );
							} elseif( $option['type'] == 'textarea' || $option['type'] == 'text' || $option['type'] == 'image' || $option['type'] == 'color' ) {
								$tab_option[$option['name']] = strip_tags( $_POST[$option['name']] );
							} else {
								$tab_option[$option['name']] = $_POST[$option['name']];
							}
						}
						update_option( $tab['name'], $tab_option );
					} else {
						foreach( $tab['content'] as $option ) {
							$post_value = $_POST[$option['name']] ? $_POST[$option['name']] : $option['std'];
							if( $option['type'] == 'textarea' && ($option['data'] == 'html' || $option['data'] == 'code') ) {
								update_option( $option['name'], stripslashes( $_POST[$option['name']] ) );
							} elseif( $option['type'] == 'textarea' || $option['type'] == 'text' || $option['type'] == 'image' || $option['type'] == 'color' ) {
								update_option( $option['name'], strip_tags( $_POST[$option['name']] ) );
							} else {
								update_option( $option['name'], $_POST[$option['name']] );
							}
						}
					}
				}
			}
		}
		echo '<script>this.location=this.location;</script>';
	}
	for( $i = 0; $i < count($options); $i++ ) {
		switch( $i ) {
			case '0':
				$theme_options_page = add_menu_page( $menu_title, $menu_title, 'administrator', basename(__FILE__), 'tangzhong_admin_options_content', get_template_directory_uri().'/images/favicon.ico', 3);
				$theme_options_page = add_submenu_page( basename(__FILE__), $options['0']['label'], $options['0']['label'], 'administrator', basename(__FILE__), 'tangzhong_admin_options_content' );
				if( ! $theme_options_page ) return;
			break;
			case '1':
				$theme_options_page = add_submenu_page( basename(__FILE__), $options['0']['label'], $options['0']['label'], 'administrator', basename(__FILE__), 'tangzhong_admin_options_content' );
				$theme_options_page = add_submenu_page( basename(__FILE__), $options[$i]['label'], $options[$i]['label'], 'administrator', $options[$i]['page'], 'tangzhong_admin_options_content' );
			break;
			default :
				$theme_options_page = add_submenu_page( basename(__FILE__), $options[$i]['label'], $options[$i]['label'], 'administrator', $options[$i]['page'], 'tangzhong_admin_options_content' );
			break;
		}
		add_action( "load-$theme_options_page", 'tangzhong_admin_options_help' );
	}
 }
 add_action('admin_menu', 'tangzhong_admin_options_save');





/**
 * 设置面板特效脚本文件
 */
function tangzhong_admin_enqueue_scripts() {
	// farbtastic 拾色器（必须在加载jQuery前加载！）
    wp_enqueue_script( 'farbtastic' );
	wp_enqueue_script( 'farbtastic-tangzhong', get_template_directory_uri().'/js/farbtastic.js', false, '2012-05-27' );
	// 加载jQuery库
	wp_enqueue_script( 'jquery-basic', get_template_directory_uri().'/js/jquery-1.7.2.min.js', false, '2012-05-23' );
	// ajax提交表单
	//wp_enqueue_script( 'jquery-form', 'http://malsup.github.com/jquery.form.js', false, '2012-05-30' );
	// 引入定义的jQuery插件
	wp_enqueue_script( 'jquery-tools', get_template_directory_uri().'/js/jquery.tools.min.js', false, '2012-05-28' );
	// 打开媒体上传支持功能
	wp_enqueue_script('media-upload');
	wp_enqueue_script('thickbox');
	// 命令执行
	wp_enqueue_script( 'theme-options-js', get_template_directory_uri().'/functions/theme-options.js', false, '2012-05-23' );
}





/**
 * 设置面板样式文件
 */
function tangzhong_admin_enqueue_style() {
	// farbtastic 拾色器样式
	wp_enqueue_style( 'farbtastic' );
	// 媒体上传弹窗样式
	wp_enqueue_style('thickbox');
	// 选项面板样式表
	wp_enqueue_style( 'theme-options-css', get_template_directory_uri().'/functions/theme-options.css', false, '2012-05-23' );
}





/**
 * 在设置页面头部加载
 */
foreach( $options as $panel ) {
	if( $_GET['page'] == $panel['page'] ) {
		add_action( 'admin_menu', 'tangzhong_admin_enqueue_scripts' );
		add_action( 'admin_menu', 'tangzhong_admin_enqueue_style' );
	}
}





/**
 * 选项面板帮助
 */
function tangzhong_admin_options_help() {
	global $options;
	foreach( $options as $panel ) {
		if( $_GET['page'] == $panel['page'] ) {
			$sidebar = $panel['sidebar'];
			$screen = get_current_screen();
			$help = $panel['help'];
			for( $i = '0'; $i < count($help); $i++ ) {
				if ( method_exists( $screen, 'add_help_tab' ) ) {
					// WordPress 3.3
					$screen->add_help_tab(
						array(
							'title' => $help[$i]['label'],
							'id' => 'help-tab-'.($i+1),
							'content' => $help[$i]['desc'],
						)
					);
					$screen->set_help_sidebar( $sidebar );
				} else {
					// WordPress 3.2
					add_contextual_help( $screen, $help[$i]['help'] . $sidebar );
				}
			}
		}
	}
}





/**
 * 前台添加管理员导航菜单项目
 */
function tangzhong_add_admin_bar() {
	global $wp_admin_bar, $wpdb, $menu_title, $options;
	if ( !is_super_admin() || !is_admin_bar_showing() || is_admin() )
		return;
	$parent_title = __( '<span class="tz-icon"></span><span class="ab-label">'.$menu_title.'</span>', 'tangzhong' );
	$wp_admin_bar->add_menu( array( 'id' => 'codex_search', 'title' => $parent_title, 'href' => admin_url('admin.php?page='.$options['0']['page']) ) );
	if( count($options) > 1 ) {
		for( $i=0; $i<count($options); $i++ ) {
			if($i<1) {
				$wp_admin_bar->add_menu( array( 'parent' => 'codex_search', 'title' => $options[$i]['label'], 'href' => admin_url('admin.php?page='.$options[$i]['page']) ) );
			} else {
				$wp_admin_bar->add_menu( array( 'parent' => 'codex_search', 'title' => $options[$i]['label'], 'href' => admin_url('admin.php?page='.$options[$i]['page']) ) );
			}
		}
	}
}
add_action('admin_bar_menu', 'tangzhong_add_admin_bar');

//include( 'contributor-audit.php' );