<?php
$def_cat = get_option( 'tz_contributor_cat', '1' );
$areas = array(
	array( $def_cat, get_cat_name($def_cat) )
);
foreach( get_categories('hide_empty=0&parent='.$def_cat) as $the_category ) {
	$areas[] = array( $the_category->term_id, $the_category->name );
}

$fields_options = array(
	array(
		'type'		=> 'text',
		'key'		=> 'post_title',
		'label'		=> __( '标题:', 'tangzhong' )
	),
	array(
		'type'		=> 'text',
		'data'		=> 'field',
		'key'		=> 'source_url',
		'label'		=> __( '网址:', 'tangzhong' )
	),
	array(
		'type'		=> 'select',
		'data'		=> 'tax_input',
		'key'		=> 'post_category',
		'source'	=> $areas,
		'label'		=> __( '涉及地区:', 'tangzhong' )
	),
	array(
		'type'		=> 'text',
		'data'		=> 'tax_input',
		'key'		=> 'food',
		'label'		=> __( '名称:', 'tangzhong' )
	),
	array(
		'type'		=> 'text',
		'data'		=> 'tax_input',
		'key'		=> 'tags_input',
		'label'		=> __( '关键词:', 'tangzhong' )
	),
	array(
		'type'		=> 'file',
		'data'		=> 'field',
		'key'		=> 'thumbnail',
		'label'		=> __( '相关图片:', 'tangzhong' )
	),
	array(
		'type'		=> 'text',
		'data'		=> 'tax_input',
		'key'		=> 'source',
		'label'		=> __( '来源报刊:', 'tangzhong' )
	),
	array(
		'type'		=> 'text',
		'data'		=> 'tax_input',
		'key'		=> 'source2',
		'label'		=> __( '来源网站:', 'tangzhong' )
	),
	array(
		'type'		=> 'date',
		'key'		=> 'post_date',
		'label'		=> __( '来源网站新闻发布日期:', 'tangzhong' )
	)
);
$form_comtent = '';
foreach( $fields_options as $field ) {
	$name = $field['key'];
	$id = 'contributor_'.$name;
	$form_comtent .= '<fieldset>';
	$form_comtent .= '<label for="'.$id.'">'.$field['label'].'</label><br />';
	switch( $field['type'] ) {
		case 'text' :
			$form_comtent .= '<input type="text" name="'.$name.'" id="'.$id.'" class="regular-text" value="" />';
		break;
		case 'select' :
			if( is_array( $field['source'] ) && count($field['source']) > 0 ) {
				$form_comtent .= '<select name="'.$name.'" id="'.$id.'">';
				foreach( $field['source'] as $option ) {
					$form_comtent .= '<option value="'.$option['0'].'">'.$option['1'].'</option>';
				}
				$form_comtent .= '<select>';
			}
		break;
		case 'file' :
			$form_comtent .= '<input type="file" name="'.$name.'" id="'.$id.'" />';
		break;
		case 'date' :
			$form_comtent .= '<script>DateInput(\''.$name.'\', true, \'YYYY-MM-DD\')</script>';
		break;
	}
	$form_comtent .= '</fieldset>';
}
$the_post = array(
	'post_author'	=> get_option( 'tz_contributor', '1' ),
	'post_status'	=> get_option('tz_post_status', 'pending')
);
if( isset($_POST['submit']) ) {
	foreach( $fields_options as $the_field ) {
		$post_name = $the_field['key'];
		$the_value = $_POST[$post_name];
		if( $the_field['data'] == 'field' ) {
			if( $the_field['type'] == 'file' ) {
				$upload = wp_upload_bits(
					$_FILES[$post_name]["name"],
					null,
					file_get_contents($_FILES[$post_name]["tmp_name"])
				);
				$$post_name = $upload['url'];
			} else {
				$$post_name = trim(strip_tags($the_value));
			}
		} else if( $the_field['data'] == 'tax_input' ) {
			$the_value = trim(str_replace( ',', 'tagzhog', str_replace( '，', ',', $the_value ) ));
			$the_value = preg_replace('/\s/','',preg_replace("/[[:punct:]]/",'',strip_tags(html_entity_decode(str_replace(array('？','！','￥','（','）','：','‘','’','“','”','《','》','，','…','。','、','nbsp'),'',$the_value),ENT_QUOTES,'UTF-8'))));
			$the_value = explode('tagzhog',$the_value);
			if( $the_field['key'] == 'tags_input' || $the_field['key'] == 'post_category' ) {
				$the_post[$post_name] = $the_value;
			} else {
				$the_post['tax_input'][$post_name] = $the_value;
			}
		} else {
			$the_post[$post_name] = trim(strip_tags($the_value));
		}
	}
	$the_post_id = wp_insert_post( $the_post );
	foreach( $fields_options as $custom_field ) {
		if( $custom_field['data'] == 'field' ) {
			$field_name = $custom_field['key'];
			add_post_meta( $the_post_id, $field_name, $$field_name );
		}
	}
}
?>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/calendarDateInput.js">

/***********************************************
* Jason's Date Input Calendar- By Jason Moon http://calendar.moonscript.com/dateinput.cfm
* Script featured on and available at http://www.dynamicdrive.com
* Keep this notice intact for use.
***********************************************/

</script>
<form method="post" id="contributors" action="" enctype="multipart/form-data">
	<?php echo $form_comtent; ?>
	<input type="submit" name="submit" id="submit" value="提交">
</form>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/jquery-1.7.2.min.js"></script>
<script type="text/javascript">
$(document).ready(function(){
	$('#submit').click(function(){
		var post_title = $('#contributor_post_title').val();
		var source_url = $('#contributor_source_url').val();
		var tags_input = $('#contributor_tags_input').val();
		regex_url = /((?:http\:.\/.\/*))/;
		var alert_message = '';
		if( post_title == '' ) {
			alert_message = alert_message+'必须输入标题！'+"\n";
		}
		if( regex_url.test(source_url) == false ) {
			alert_message = alert_message+'请填入有效的网址！'+"\n";
		}
		if( tags_input == '' ) {
			alert_message = alert_message+'必须填写至少一个关键词！'+"\n";
		}
		if( alert_message !== '' ) {
			alert(alert_message);
			return false;
		}
		
	});
});
</script>

<?php if( isset($_POST['submit']) ) { echo '<script>this.location=this.location; alert("'.get_option( 'tz_contributor_ok', '提交成功！' ).'");</script>'; } 
?>