<?php if ( $wp_query->max_num_pages > 1 ) : ?>
	<div id="nav-above" class="navigation">
		<div class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', 'tangzhong' ) ); ?></div>
		<div class="nav-next"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', 'tangzhong' ) ); ?></div>
	</div><!-- #nav-above -->
<?php endif; ?>

<?php if ( ! have_posts() ) : ?>
	<div id="post-0" class="post error404 not-found">
		<h1 class="entry-title"><?php _e( 'Not Found', 'tangzhong' ); ?></h1>
		<div class="entry-content">
			<p><?php _e( 'Apologies, but no results were found for the requested archive. Perhaps searching will help find a related post.', 'tangzhong' ); ?></p>
			<?php get_search_form(); ?>
		</div><!-- .entry-content -->
	</div><!-- #post-0 -->
<?php endif; ?>
<?php
/**
 * 顶部分页
*/ ?>
<?php if(function_exists( 'wp_pagenavi' )) :
	wp_pagenavi(); ?>
<?php elseif (  $wp_query->max_num_pages > 1 ) : ?>
				<div id="nav-below" class="navigation">
					<div class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', 'tangzhong' ) ); ?></div>
					<div class="nav-next"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', 'tangzhong' ) ); ?></div>
				</div><!-- #nav-below -->
<?php endif; ?>
<?php if($paged=='0') { $result_id = '0'; } else { $result_id = ($paged-1)*get_option('posts_per_page'); } ?>
<?php while ( have_posts() ) : the_post(); ?>

	<?php $the_permalink = get_post_meta( $post->ID, 'source_url', true ) ? get_post_meta( $post->ID, 'source_url', true ) : get_permalink(); ?>

	<?php if( is_home() ) : ?>

		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<h2 class="entry-title"><a href="<?php echo $the_permalink; ?>" title="<?php echo $the_permalink; ?>" target="_blank" rel="bookmark"><?php the_title(); ?></a></h2>

			<div class="entry-meta">
				<?php tangzhong_posted_on(); ?>
			</div><!-- .entry-meta -->

	<?php if ( is_archive() || is_search() ) : ?>
			<div class="entry-summary">
				<?php the_excerpt(); ?>
			</div><!-- .entry-summary -->
	<?php else : ?>
			<div class="entry-content">
				<?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'tangzhong' ) ); ?>
				<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'tangzhong' ), 'after' => '</div>' ) ); ?>
			</div><!-- .entry-content -->
	<?php endif; ?>

			<div class="entry-utility">
				<?php if ( count( get_the_category() ) ) : ?>
					<span class="cat-links">
						<?php printf( __( '<span class="%1$s">Posted in</span> %2$s', 'tangzhong' ), 'entry-utility-prep entry-utility-prep-cat-links', get_the_category_list( ', ' ) ); ?>
					</span>
					<span class="meta-sep">|</span>
				<?php endif; ?>
				<?php
					$tags_list = get_the_tag_list( '', ', ' );
					if ( $tags_list ):
				?>
					<span class="tag-links">
						<?php printf( __( '<span class="%1$s">Tagged</span> %2$s', 'tangzhong' ), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list ); ?>
					</span>
					<span class="meta-sep">|</span>
				<?php endif; ?>
				<span class="comments-link"><?php comments_popup_link( __( 'Leave a comment', 'tangzhong' ), __( '1 Comment', 'tangzhong' ), __( '% Comments', 'tangzhong' ) ); ?></span>
				<?php edit_post_link( __( 'Edit', 'tangzhong' ), '<span class="meta-sep">|</span> <span class="edit-link">', '</span>' ); ?>
			</div><!-- .entry-utility -->
			<div width="95%" style="border-top:1px dotted #D4D0C8;height:1px; margin-top: 20px;"></div>
		</div><!-- #post-## -->

	<?php else : ?>

	<?php $result_id++; ?>
	<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<h2 class="entry-title"><span class="result-id"><?php echo $result_id; ?></span> <a href="<?php echo $the_permalink; ?>" title="<?php echo $the_permalink; ?>" target="_blank" rel="bookmark"><?php the_title(); ?></a><span class="date"><?php the_time('Y-m-d'); ?></span></h2>
		<div class="entry-utility">
			<ul>
			<?php
			$category = get_the_category(); 
			echo '<li class="the_cat"><a href="'.get_category_link($category[0]->term_id).'">'.$category[0]->cat_name.'</a>';
			$food_terms = wp_get_object_terms($post->ID, 'food');
			if(!empty($food_terms)){
				if(!is_wp_error( $food_terms )){
					foreach($food_terms as $term){
						echo '<li class="the_food"><a href="'.get_term_link($term->slug, 'food').'">'.$term->name.'</a></li>'; 
					}
				}
			}
			the_tags('<li class="the_tag">','','</li>');
			$source_terms = wp_get_object_terms($post->ID, 'source');
			if(!empty($source_terms)){
				if(!is_wp_error( $source_terms )){
					foreach($source_terms as $term){
						echo '<li class="the_source"><a href="'.get_term_link($term->slug, 'source').'">'.$term->name.'</a></li>'; 
					}
				}
			}
			$source2_terms = wp_get_object_terms($post->ID, 'source2');
			if(!empty($source2_terms)){
				if(!is_wp_error( $source2_terms )){
					foreach($source2_terms as $term){
						echo '<li class="the_source"><a href="'.get_term_link($term->slug, 'source2').'">'.$term->name.'</a></li>'; 
					}
				}
			}
			echo '<li class="the_author">';
			the_author_posts_link();
			echo '</li>';
			?>
			<ul>
		</div>
	</div>

	<?php endif; ?>

		<?php comments_template( '', true ); ?>

<?php endwhile; ?>

<?php
/**
 * 底部分页
*/ ?>
<?php if(function_exists( 'wp_pagenavi' )) :
	wp_pagenavi(); ?>
<?php elseif (  $wp_query->max_num_pages > 1 ) : ?>
				<div id="nav-below" class="navigation">
					<div class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', 'tangzhong' ) ); ?></div>
					<div class="nav-next"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', 'tangzhong' ) ); ?></div>
				</div><!-- #nav-below -->
<?php endif; ?>
